/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.ChangePropertyValue;

public final class ChangeApiVersion
extends Recipe {
    @Option(displayName="Old API version", description="The old Kubernetes API version to match.", example="flowcontrol.apiserver.k8s.io/v1beta3")
    private final String oldApiVersion;
    @Option(displayName="New API version", description="The new Kubernetes API version to change to.", example="flowcontrol.apiserver.k8s.io/v1")
    private final String newApiVersion;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", example="**/pod-*.yml", required=false)
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Change Kubernetes API version";
    }

    public String getDescription() {
        return "Change the Kubernetes API version in a resource.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyValue("apiVersion", this.newApiVersion, this.oldApiVersion, null, null, this.fileMatcher).getVisitor();
    }

    @ConstructorProperties(value={"oldApiVersion", "newApiVersion", "fileMatcher"})
    @Generated
    public ChangeApiVersion(String oldApiVersion, String newApiVersion, @Nullable String fileMatcher) {
        this.oldApiVersion = oldApiVersion;
        this.newApiVersion = newApiVersion;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public String getOldApiVersion() {
        return this.oldApiVersion;
    }

    @Generated
    public String getNewApiVersion() {
        return this.newApiVersion;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeApiVersion(oldApiVersion=" + this.getOldApiVersion() + ", newApiVersion=" + this.getNewApiVersion() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeApiVersion)) {
            return false;
        }
        ChangeApiVersion other = (ChangeApiVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldApiVersion = this.getOldApiVersion();
        String other$oldApiVersion = other.getOldApiVersion();
        if (this$oldApiVersion == null ? other$oldApiVersion != null : !this$oldApiVersion.equals(other$oldApiVersion)) {
            return false;
        }
        String this$newApiVersion = this.getNewApiVersion();
        String other$newApiVersion = other.getNewApiVersion();
        if (this$newApiVersion == null ? other$newApiVersion != null : !this$newApiVersion.equals(other$newApiVersion)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeApiVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldApiVersion = this.getOldApiVersion();
        result = result * 59 + ($oldApiVersion == null ? 43 : $oldApiVersion.hashCode());
        String $newApiVersion = this.getNewApiVersion();
        result = result * 59 + ($newApiVersion == null ? 43 : $newApiVersion.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

