/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class JenkinsfileAsGroovy
extends Recipe {
    public String getDisplayName() {
        return "Parse `Jenkinsfile` as Groovy";
    }

    public String getDescription() {
        return "Parse any `Jenkinsfile` as Groovy code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/Jenkinsfile*"), (TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof PlainText) {
                    PlainText pt = (PlainText)tree;
                    return (Tree)GroovyParser.builder().build().parse(new String[]{pt.getText()}).findFirst().map(sourceFile -> ((SourceFile)((SourceFile)sourceFile.withId(pt.getId())).withMarkers(pt.getMarkers())).withSourcePath(pt.getSourcePath())).orElse((SourceFile)pt);
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }
}

