/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jenkins.AddPluginsBom;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeVersionProperty
extends Recipe {
    @Option(displayName="Key", description="The name of the property key to change.", example="jenkins.version")
    private final String key;
    @Option(displayName="Minimum Version", description="Value to apply to the matching property if < this.", example="2.375.1")
    private final String minimumVersion;

    public String getDisplayName() {
        return "Upgrade property's value to version";
    }

    public String getDescription() {
        return "If the current value is < given version, upgrade it.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.minimumVersion, null).getValue();
        assert (versionComparator != null);
        return Preconditions.check((TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                String value = (String)this.getResolutionResult().getPom().getProperties().get(UpgradeVersionProperty.this.key);
                if (value == null) {
                    return document;
                }
                Optional upgrade = versionComparator.upgrade(value, Collections.singleton(UpgradeVersionProperty.this.minimumVersion));
                if (!upgrade.isPresent()) {
                    return document;
                }
                return (Xml)SearchResult.found((Tree)document);
            }
        }, (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (!this.isPropertyTag()) {
                    return t;
                }
                if (!t.getName().equals(UpgradeVersionProperty.this.key)) {
                    return t;
                }
                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(t, UpgradeVersionProperty.this.minimumVersion));
                this.doAfterVisit(new AddPluginsBom().getVisitor());
                return t;
            }
        });
    }

    @ConstructorProperties(value={"key", "minimumVersion"})
    public UpgradeVersionProperty(String key, String minimumVersion) {
        this.key = key;
        this.minimumVersion = minimumVersion;
    }

    public String getKey() {
        return this.key;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    @NonNull
    public String toString() {
        return "UpgradeVersionProperty(key=" + this.getKey() + ", minimumVersion=" + this.getMinimumVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeVersionProperty)) {
            return false;
        }
        UpgradeVersionProperty other = (UpgradeVersionProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$minimumVersion = this.getMinimumVersion();
        String other$minimumVersion = other.getMinimumVersion();
        return !(this$minimumVersion == null ? other$minimumVersion != null : !this$minimumVersion.equals(other$minimumVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeVersionProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $minimumVersion = this.getMinimumVersion();
        result = result * 59 + ($minimumVersion == null ? 43 : $minimumVersion.hashCode());
        return result;
    }
}

