/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ReplaceLibrariesWithApiPlugin
extends Recipe {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    @Option(displayName="API Plugin's groupId", description="The first part of a dependency coordinate 'io.jenkins.plugins:ARTIFACT_ID:VERSION'.", example="io.jenkins.plugins")
    private final String pluginGroupId;
    @Option(displayName="API Plugin's artifactId", description="The second part of a dependency coordinate 'GROUP_ID:jackson2-api:VERSION'.", example="jackson2-api")
    private final String pluginArtifactId;
    @Option(displayName="API Plugin's version", description="An exact version number.", example="1981.v17df70e84a_a_1")
    private final String pluginVersion;
    @Option(displayName="Replaced Libraries", description="The set of library coordinates replaced by this API Plugin.")
    private final Set<Library> replaces;

    public ReplaceLibrariesWithApiPlugin(String pluginGroupId, String pluginArtifactId, String pluginVersion, Set<Library> replaces) {
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.pluginVersion = pluginVersion;
        this.replaces = replaces;
    }

    public String getDisplayName() {
        return "Use Jenkins API plugin instead of libraries";
    }

    public String getDescription() {
        return "Prefer Jenkins API plugins over bundling libraries for slimmer plugins.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency dependency;
                if (this.isDependencyTag() && (dependency = this.findDependency(tag)) != null && !this.isApiPlugin(dependency)) {
                    for (Library replaced : ReplaceLibrariesWithApiPlugin.this.replaces) {
                        String artifactId;
                        String groupId = replaced.groupId;
                        ResolvedDependency found = dependency.findDependency(groupId, artifactId = replaced.artifactId);
                        if (found == null) continue;
                        this.doAfterVisit((TreeVisitor)new AddDependencyVisitor(ReplaceLibrariesWithApiPlugin.this.pluginGroupId, ReplaceLibrariesWithApiPlugin.this.pluginArtifactId, ReplaceLibrariesWithApiPlugin.this.pluginVersion, null, null, Boolean.valueOf(true), null, null, Boolean.valueOf(false), null));
                        this.doAfterVisit(new RemoveDependency(groupId, artifactId, null).getVisitor());
                        if (found == dependency) continue;
                        Optional maybeExclusions = tag.getChild("exclusions");
                        if (maybeExclusions.isPresent()) {
                            Xml.Tag exclusions = (Xml.Tag)maybeExclusions.get();
                            List individualExclusions = exclusions.getChildren("exclusion");
                            if (individualExclusions.stream().noneMatch(exclusion -> groupId.equals(exclusion.getChildValue("groupId").orElse(null)) && artifactId.equals(exclusion.getChildValue("artifactId").orElse(null)))) {
                                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(exclusions, Xml.Tag.build((String)("<exclusion>\n<!-- brought in by " + ReplaceLibrariesWithApiPlugin.this.pluginGroupId + ":" + ReplaceLibrariesWithApiPlugin.this.pluginArtifactId + " -->\n<groupId>" + groupId + "</groupId>\n<artifactId>" + artifactId + "</artifactId>\n</exclusion>"))));
                            }
                        } else {
                            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, Xml.Tag.build((String)("<exclusions>\n<exclusion>\n<!-- brought in by " + ReplaceLibrariesWithApiPlugin.this.pluginGroupId + ":" + ReplaceLibrariesWithApiPlugin.this.pluginArtifactId + " -->\n<groupId>" + groupId + "</groupId>\n<artifactId>" + artifactId + "</artifactId>\n</exclusion>\n</exclusions>"))));
                        }
                        this.maybeUpdateModel();
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }

            private boolean isApiPlugin(ResolvedDependency dependency) {
                return ReplaceLibrariesWithApiPlugin.this.pluginGroupId.equals(dependency.getGroupId()) && ReplaceLibrariesWithApiPlugin.this.pluginArtifactId.equals(dependency.getArtifactId());
            }
        };
    }

    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public Set<Library> getReplaces() {
        return this.replaces;
    }

    @NonNull
    public String toString() {
        return "ReplaceLibrariesWithApiPlugin(pluginGroupId=" + this.getPluginGroupId() + ", pluginArtifactId=" + this.getPluginArtifactId() + ", pluginVersion=" + this.getPluginVersion() + ", replaces=" + this.getReplaces() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceLibrariesWithApiPlugin)) {
            return false;
        }
        ReplaceLibrariesWithApiPlugin other = (ReplaceLibrariesWithApiPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginGroupId = this.getPluginGroupId();
        String other$pluginGroupId = other.getPluginGroupId();
        if (this$pluginGroupId == null ? other$pluginGroupId != null : !this$pluginGroupId.equals(other$pluginGroupId)) {
            return false;
        }
        String this$pluginArtifactId = this.getPluginArtifactId();
        String other$pluginArtifactId = other.getPluginArtifactId();
        if (this$pluginArtifactId == null ? other$pluginArtifactId != null : !this$pluginArtifactId.equals(other$pluginArtifactId)) {
            return false;
        }
        String this$pluginVersion = this.getPluginVersion();
        String other$pluginVersion = other.getPluginVersion();
        if (this$pluginVersion == null ? other$pluginVersion != null : !this$pluginVersion.equals(other$pluginVersion)) {
            return false;
        }
        Set<Library> this$replaces = this.getReplaces();
        Set<Library> other$replaces = other.getReplaces();
        return !(this$replaces == null ? other$replaces != null : !((Object)this$replaces).equals(other$replaces));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceLibrariesWithApiPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginGroupId = this.getPluginGroupId();
        result = result * 59 + ($pluginGroupId == null ? 43 : $pluginGroupId.hashCode());
        String $pluginArtifactId = this.getPluginArtifactId();
        result = result * 59 + ($pluginArtifactId == null ? 43 : $pluginArtifactId.hashCode());
        String $pluginVersion = this.getPluginVersion();
        result = result * 59 + ($pluginVersion == null ? 43 : $pluginVersion.hashCode());
        Set<Library> $replaces = this.getReplaces();
        result = result * 59 + ($replaces == null ? 43 : ((Object)$replaces).hashCode());
        return result;
    }

    public static final class Library {
        private final String groupId;
        private final String artifactId;

        @ConstructorProperties(value={"groupId", "artifactId"})
        public Library(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Library)) {
                return false;
            }
            Library other = (Library)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ReplaceLibrariesWithApiPlugin.Library(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
        }
    }
}

