/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class BomLookup {
    private final Set<String> artifactsInBom = new HashSet<String>();

    BomLookup() {
    }

    public boolean inBom(String groupId, String artifactId) {
        if (this.artifactsInBom.isEmpty()) {
            this.init();
        }
        return this.artifactsInBom.contains(groupId + ":" + artifactId);
    }

    private void init() {
        try (InputStream is = BomLookup.class.getResourceAsStream("/jenkins-plugins-bom-lookup.txt");){
            Objects.requireNonNull(is);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                List groupArtifacts = br.lines().collect(Collectors.toList());
                for (String groupArtifact : groupArtifacts) {
                    String tidy;
                    if (groupArtifact == null || (tidy = groupArtifact.trim()).isEmpty()) continue;
                    this.artifactsInBom.add(tidy);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getArtifactsInBom() {
        return this.artifactsInBom;
    }
}

