/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.MavenResolutionResult;

class Jenkins {
    private static final Predicate<String> LTS_PATTERN = Pattern.compile("^\\d\\.\\d+\\.\\d$").asPredicate();

    Jenkins() {
    }

    @Nullable
    public static String isJenkinsPluginPom(SourceFile sourceFile) {
        return sourceFile.getMarkers().findFirst(MavenResolutionResult.class).map(mavenResolution -> mavenResolution.getPom().getManagedVersion("org.jenkins-ci.main", "jenkins-core", null, null)).orElse(null);
    }

    @NonNull
    public static String bomNameForJenkinsVersion(@NonNull String version) {
        if (LTS_PATTERN.test(version)) {
            int lastIndex = version.lastIndexOf(".");
            String prefix = version.substring(0, lastIndex);
            return "bom-" + prefix + ".x";
        }
        return "bom-weekly";
    }
}

