/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.search;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.dependencies.DependencyInsight;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.SearchResult;

public final class RepositoryHasDependency
extends ScanningRecipe<AtomicBoolean> {
    private final String displayName = "Repository has dependency";
    private final String description = "Searches for both Gradle and Maven modules that have a dependency matching the specified groupId and artifactId. Places a `SearchResult` marker on all sources within a repository with a matching dependency. This recipe is intended to be used as a precondition for other recipes. For example this could be used to limit the application of a spring boot migration to only projects that use a springframework dependency, limiting unnecessary upgrading. If the search result you want is instead just the build.gradle(.kts) or pom.xml file applying the plugin, use the `FindDependency` recipe instead.";
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. All scopes are searched by default.", valid={"compile", "test", "runtime", "provided", "system"}, example="compile", required=false)
    private final @Nullable String scope;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (acc.get()) {
                    assert (tree != null);
                    return tree;
                }
                assert (tree != null);
                tree.getMarkers().findFirst(JavaProject.class).ifPresent(jp -> {
                    Tree t = new DependencyInsight(RepositoryHasDependency.this.groupIdPattern, RepositoryHasDependency.this.artifactIdPattern, RepositoryHasDependency.this.scope, RepositoryHasDependency.this.version).getVisitor().visit(tree, (Object)ctx);
                    if (t != tree) {
                        acc.set(true);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        if (acc.get()) {
            return new TreeVisitor<Tree, ExecutionContext>(){

                public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                    assert (tree != null);
                    return SearchResult.found((Tree)tree, (String)("Repository has dependency: " + RepositoryHasDependency.this.groupIdPattern + ":" + RepositoryHasDependency.this.artifactIdPattern + (RepositoryHasDependency.this.version == null ? "" : ":" + RepositoryHasDependency.this.version)));
                }
            };
        }
        return TreeVisitor.noop();
    }

    @ConstructorProperties(value={"groupIdPattern", "artifactIdPattern", "scope", "version"})
    @Generated
    public RepositoryHasDependency(String groupIdPattern, String artifactIdPattern, @Nullable String scope, @Nullable String version) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
        this.version = version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public String toString() {
        return "RepositoryHasDependency(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryHasDependency)) {
            return false;
        }
        RepositoryHasDependency other = (RepositoryHasDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepositoryHasDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

