/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpgradeTransitiveDependencyVersion;
import org.openrewrite.maven.AddManagedDependency;

public final class UpgradeTransitiveDependencyVersion
extends ScanningRecipe<Accumulator> {
    private final String displayName = "Upgrade transitive Gradle or Maven dependencies";
    private final String description = "Upgrades the version of a transitive dependency in a Maven pom.xml or Gradle build.gradle. Leaves direct dependencies unmodified. Can be paired with the regular Upgrade Dependency Version recipe to upgrade a dependency everywhere, regardless of whether it is direct or transitive.";
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.apache.logging.log4j:ARTIFACT_ID:VERSION'.", example="org.apache.logging.log4j")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.apache.logging.log4j:log4j-bom:VERSION'.", example="log4j-bom")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="latest.release")
    private final String version;
    @Option(displayName="Scope", description="An optional scope to use for the dependency management tag. Relevant only to Maven.", example="import", valid={"import", "runtime", "provided", "test"}, required=false)
    private final @Nullable String scope;
    @Option(displayName="Type", description="An optional type to use for the dependency management tag. Relevant only to Maven builds.", valid={"jar", "pom", "war"}, example="pom", required=false)
    private final @Nullable String type;
    @Option(displayName="Classifier", description="An optional classifier to use for the dependency management tag. Relevant only to Maven.", example="test", required=false)
    private final @Nullable String classifier;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Because", description="The reason for upgrading the transitive dependency. For example, we could be responding to a vulnerability.", required=false, example="CVE-2021-1234")
    private final @Nullable String because;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration when using a semver selector", required=false)
    private final @Nullable Boolean releasesOnly;
    @Option(displayName="Only if using glob expression for group:artifact", description="Only add managed dependencies to projects having a dependency matching the expression.", example="org.apache.logging.log4j:log4j*", required=false)
    private final @Nullable String onlyIfUsing;
    @Option(displayName="Add to the root pom", description="Add to the root pom where root is the eldest parent of the pom within the source set.", required=false)
    private final @Nullable Boolean addToRootPom;

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(this.getMavenUpgradeTransitive().getInitialValue(ctx), this.getGradleUpgradeTransitive().getInitialValue(ctx));
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        TreeVisitor gradleUTDV = this.getGradleUpgradeTransitive().getScanner(acc.gradleAccumulator);
        TreeVisitor mavenUTDV = this.getMavenUpgradeTransitive().getScanner(acc.mavenAccumulator);
        return this.delegate(gradleUTDV, mavenUTDV);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        TreeVisitor gradleUTDV = this.getGradleUpgradeTransitive().getVisitor(acc.gradleAccumulator);
        TreeVisitor mavenUTDV = this.getMavenUpgradeTransitive().getVisitor(acc.mavenAccumulator);
        return this.delegate(gradleUTDV, mavenUTDV);
    }

    private TreeVisitor<Tree, ExecutionContext> delegate(final TreeVisitor<?, ExecutionContext> gradle, final TreeVisitor<?, ExecutionContext> maven) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return gradle.isAcceptable(sourceFile, (Object)ctx) || maven.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile t = (SourceFile)tree;
                if (gradle.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)gradle.visitNonNull((Tree)t, (Object)ctx);
                } else if (maven.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)maven.visitNonNull((Tree)t, (Object)ctx);
                }
                return t;
            }
        };
    }

    private org.openrewrite.gradle.UpgradeTransitiveDependencyVersion getGradleUpgradeTransitive() {
        return new org.openrewrite.gradle.UpgradeTransitiveDependencyVersion(this.groupId, this.artifactId, this.version, this.versionPattern, this.because, null);
    }

    private org.openrewrite.maven.UpgradeTransitiveDependencyVersion getMavenUpgradeTransitive() {
        return new org.openrewrite.maven.UpgradeTransitiveDependencyVersion(this.groupId, this.artifactId, this.version, this.scope, this.type, this.classifier, this.versionPattern, this.releasesOnly, this.onlyIfUsing, this.addToRootPom, this.because);
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version", "scope", "type", "classifier", "versionPattern", "because", "releasesOnly", "onlyIfUsing", "addToRootPom"})
    @Generated
    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String versionPattern, @Nullable String because, @Nullable Boolean releasesOnly, @Nullable String onlyIfUsing, @Nullable Boolean addToRootPom) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.versionPattern = versionPattern;
        this.because = because;
        this.releasesOnly = releasesOnly;
        this.onlyIfUsing = onlyIfUsing;
        this.addToRootPom = addToRootPom;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getType() {
        return this.type;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getBecause() {
        return this.because;
    }

    @Generated
    public @Nullable Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Generated
    public @Nullable String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Generated
    public @Nullable Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @Generated
    public String toString() {
        return "UpgradeTransitiveDependencyVersion(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", versionPattern=" + this.getVersionPattern() + ", because=" + this.getBecause() + ", releasesOnly=" + this.getReleasesOnly() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", addToRootPom=" + this.getAddToRootPom() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeTransitiveDependencyVersion)) {
            return false;
        }
        UpgradeTransitiveDependencyVersion other = (UpgradeTransitiveDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$because = this.getBecause();
        String other$because = other.getBecause();
        if (this$because == null ? other$because != null : !this$because.equals(other$because)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        return !(this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeTransitiveDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $because = this.getBecause();
        result = result * 59 + ($because == null ? 43 : $because.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final AddManagedDependency.Scanned mavenAccumulator;
        private final UpgradeTransitiveDependencyVersion.DependencyVersionState gradleAccumulator;

        @ConstructorProperties(value={"mavenAccumulator", "gradleAccumulator"})
        @Generated
        public Accumulator(AddManagedDependency.Scanned mavenAccumulator, UpgradeTransitiveDependencyVersion.DependencyVersionState gradleAccumulator) {
            this.mavenAccumulator = mavenAccumulator;
            this.gradleAccumulator = gradleAccumulator;
        }

        @Generated
        public AddManagedDependency.Scanned getMavenAccumulator() {
            return this.mavenAccumulator;
        }

        @Generated
        public UpgradeTransitiveDependencyVersion.DependencyVersionState getGradleAccumulator() {
            return this.gradleAccumulator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            AddManagedDependency.Scanned this$mavenAccumulator = this.getMavenAccumulator();
            AddManagedDependency.Scanned other$mavenAccumulator = other.getMavenAccumulator();
            if (this$mavenAccumulator == null ? other$mavenAccumulator != null : !this$mavenAccumulator.equals(other$mavenAccumulator)) {
                return false;
            }
            UpgradeTransitiveDependencyVersion.DependencyVersionState this$gradleAccumulator = this.getGradleAccumulator();
            UpgradeTransitiveDependencyVersion.DependencyVersionState other$gradleAccumulator = other.getGradleAccumulator();
            return !(this$gradleAccumulator == null ? other$gradleAccumulator != null : !this$gradleAccumulator.equals(other$gradleAccumulator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AddManagedDependency.Scanned $mavenAccumulator = this.getMavenAccumulator();
            result = result * 59 + ($mavenAccumulator == null ? 43 : $mavenAccumulator.hashCode());
            UpgradeTransitiveDependencyVersion.DependencyVersionState $gradleAccumulator = this.getGradleAccumulator();
            result = result * 59 + ($gradleAccumulator == null ? 43 : $gradleAccumulator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.Accumulator(mavenAccumulator=" + this.getMavenAccumulator() + ", gradleAccumulator=" + this.getGradleAccumulator() + ")";
        }
    }
}

