/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dependencies.ChangeDependency;
import org.openrewrite.java.dependencies.oldgroupids.Migration;
import org.openrewrite.java.dependencies.table.RelocatedDependencyReport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RelocatedDependencyCheck
extends ScanningRecipe<Accumulator> {
    private final transient RelocatedDependencyReport report = new RelocatedDependencyReport((Recipe)this);
    @Option(displayName="Change dependencies", description="Whether to change dependencies to their relocated groupId and artifactId.", required=false)
    private final @Nullable Boolean changeDependencies;
    private final String displayName = "Find relocated dependencies";
    private final String description = "Find Maven and Gradle dependencies and Maven plugins that have relocated to a new `groupId` or `artifactId`. Relocation information comes from the [oga-maven-plugin](https://github.com/jonathanlermitage/oga-maven-plugin/) maintained by Jonathan Lermitage, Filipe Roque and others.\n\nThis recipe makes no changes to any source file by default. Add `changeDependencies=true` to change dependencies, but note that you might need to run additional recipes to update imports and adopt other breaking changes.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        try {
            MappingIterator objectMappingIterator = new CsvMapper().readerWithSchemaFor(Migration.class).readValues(RelocatedDependencyCheck.class.getResourceAsStream("/migrations.csv"));
            HashMap<GroupArtifact, Relocation> migrations = new HashMap<GroupArtifact, Relocation>();
            while (objectMappingIterator.hasNext()) {
                Migration def = (Migration)objectMappingIterator.next();
                GroupArtifact oldGav = new GroupArtifact(def.getOldGroupId(), StringUtils.isBlank((String)def.getOldArtifactId()) ? null : def.getOldArtifactId());
                GroupArtifact newGav = new GroupArtifact(def.getNewGroupId(), StringUtils.isBlank((String)def.getNewArtifactId()) ? null : def.getNewArtifactId());
                migrations.put(oldGav, new Relocation(newGav, StringUtils.isBlank((String)def.getContext()) ? null : def.getContext()));
            }
            return new Accumulator(migrations);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        return TreeVisitor.noop();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            private final TreeVisitor<?, ExecutionContext> gradleVisitor = this.gradleVisitor();
            private final TreeVisitor<?, ExecutionContext> mavenVisitor = this.mavenVisitor();

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (this.gradleVisitor.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.gradleVisitor.visitNonNull((Tree)s, (Object)ctx);
                } else if (this.mavenVisitor.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.mavenVisitor.visitNonNull((Tree)s, (Object)ctx);
                }
                return s;
            }

            private TreeVisitor<?, ExecutionContext> gradleVisitor() {
                return new GroovyIsoVisitor<ExecutionContext>(){
                    private final MethodMatcher dependencyMatcher = new MethodMatcher("DependencyHandlerSpec *(..)");

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                        J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                        if (this.dependencyMatcher.matches((MethodCall)mi)) {
                            List methodArguments = mi.getArguments();
                            Expression firstMethodArgument = (Expression)methodArguments.get(0);
                            if (firstMethodArgument instanceof J.Literal) {
                                J.Literal literal = (J.Literal)firstMethodArgument;
                                mi = this.searchInLiteral(literal, mi, ctx);
                            } else if (firstMethodArgument instanceof G.GString) {
                                G.GString gString = (G.GString)firstMethodArgument;
                                List strings = gString.getStrings();
                                if (!strings.isEmpty() && strings.get(0) instanceof J.Literal) {
                                    mi = this.searchInLiteral((J.Literal)strings.get(0), mi, ctx);
                                }
                            } else if (firstMethodArgument instanceof G.MapEntry) {
                                mi = this.searchInGMapEntry(methodArguments, mi, ctx);
                            }
                        }
                        return mi;
                    }

                    private J.MethodInvocation searchInLiteral(J.Literal literal, J.MethodInvocation mi, ExecutionContext ctx) {
                        String gav = (String)literal.getValue();
                        assert (gav != null);
                        String[] parts = gav.split(":");
                        if (gav.length() >= 2) {
                            mi = this.maybeUpdate(mi, parts[0], parts[1], ctx);
                        }
                        return mi;
                    }

                    private J.MethodInvocation searchInGMapEntry(List<Expression> methodArguments, J.MethodInvocation mi, ExecutionContext ctx) {
                        String groupId = null;
                        String artifactId = null;
                        for (Expression e : methodArguments) {
                            G.GString.Value versionGStringValue;
                            List strings;
                            J.Literal value;
                            G.MapEntry arg;
                            if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg.getKey();
                            Expression argValue = arg.getValue();
                            String valueValue = null;
                            if (argValue instanceof J.Literal) {
                                value = (J.Literal)argValue;
                                if (value.getValue() instanceof String) {
                                    valueValue = (String)value.getValue();
                                }
                            } else if (argValue instanceof J.Identifier) {
                                value = (J.Identifier)argValue;
                                valueValue = value.getSimpleName();
                            } else if (argValue instanceof G.GString && !(strings = (value = (G.GString)argValue).getStrings()).isEmpty() && strings.get(0) instanceof G.GString.Value && (versionGStringValue = (G.GString.Value)strings.get(0)).getTree() instanceof J.Identifier) {
                                valueValue = ((J.Identifier)versionGStringValue.getTree()).getSimpleName();
                            }
                            if (!(key.getValue() instanceof String)) continue;
                            String keyValue = (String)key.getValue();
                            if ("group".equals(keyValue)) {
                                groupId = valueValue;
                                continue;
                            }
                            if (!"name".equals(keyValue)) continue;
                            artifactId = valueValue;
                        }
                        if (groupId != null) {
                            mi = this.maybeUpdate(mi, groupId, artifactId, ctx);
                        }
                        return mi;
                    }

                    private <T extends Tree> T maybeUpdate(T tree, String groupId, @Nullable String artifactId, ExecutionContext ctx) {
                        Relocation relocation = this.getRelocation(groupId, artifactId);
                        if (relocation != null) {
                            this.insertRow(groupId, artifactId, relocation, ctx);
                            if (Boolean.TRUE.equals(RelocatedDependencyCheck.this.changeDependencies) && artifactId != null) {
                                String newGroupId = relocation.getTo().getGroupId();
                                String newArtifactId = Optional.ofNullable(relocation.getTo().getArtifactId()).orElse(artifactId);
                                this.doAfterVisit(new ChangeDependency(groupId, artifactId, newGroupId, newArtifactId, "latest.release", null, null, null).getVisitor());
                            } else {
                                return (T)this.getSearchResultFound(tree, relocation);
                            }
                        }
                        return tree;
                    }
                };
            }

            private TreeVisitor<?, ExecutionContext> mavenVisitor() {
                return new MavenIsoVisitor<ExecutionContext>(){
                    private final XPathMatcher dependencyMatcher = new XPathMatcher("//dependencies/dependency");

                    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                        tag = super.visitTag(tag, (Object)ctx);
                        Optional optionalGroupId = tag.getChildValue("groupId");
                        Optional optionalArtifactId = tag.getChildValue("artifactId");
                        if (this.dependencyMatcher.matches(this.getCursor())) {
                            if (optionalGroupId.isPresent()) {
                                String groupId = (String)optionalGroupId.get();
                                String artifactId = optionalArtifactId.orElse(null);
                                tag = this.maybeUpdate(tag, groupId, artifactId, ctx);
                            }
                        } else if (this.isPluginTag() && optionalArtifactId.isPresent()) {
                            String groupId = tag.getChildValue("groupId").orElse("org.apache.maven.plugins");
                            String artifactId = (String)optionalArtifactId.get();
                            tag = this.maybeUpdate(tag, groupId, artifactId, ctx);
                        }
                        return tag;
                    }

                    private <T extends Tree> T maybeUpdate(T tree, String groupId, @Nullable String artifactId, ExecutionContext ctx) {
                        Relocation relocation = this.getRelocation(groupId, artifactId);
                        if (relocation != null) {
                            this.insertRow(groupId, artifactId, relocation, ctx);
                            if (Boolean.TRUE.equals(RelocatedDependencyCheck.this.changeDependencies) && artifactId != null) {
                                String newGroupId = relocation.getTo().getGroupId();
                                String newArtifactId = Optional.ofNullable(relocation.getTo().getArtifactId()).orElse(artifactId);
                                this.doAfterVisit(new ChangeDependency(groupId, artifactId, newGroupId, newArtifactId, "latest.release", null, null, null).getVisitor());
                            } else {
                                return (T)this.getSearchResultFound(tree, relocation);
                            }
                        }
                        return tree;
                    }
                };
            }

            private @Nullable Relocation getRelocation(String groupId, @Nullable String artifactId) {
                Relocation relocation = acc.getMigrations().get(new GroupArtifact(groupId, artifactId));
                if (relocation == null && artifactId != null) {
                    relocation = acc.getMigrations().get(new GroupArtifact(groupId, null));
                }
                return relocation;
            }

            private void insertRow(String groupId, @Nullable String artifactId, Relocation relocation, ExecutionContext ctx) {
                GroupArtifact relocatedGA = relocation.getTo();
                RelocatedDependencyCheck.this.report.insertRow(ctx, new RelocatedDependencyReport.Row(groupId, artifactId, relocatedGA.getGroupId(), Optional.ofNullable(relocatedGA.getArtifactId()).orElse(artifactId), relocation.getContext()));
            }

            private <T extends Tree> T getSearchResultFound(T tree, Relocation relocation) {
                GroupArtifact relocatedGA = relocation.getTo();
                String relocatedMessage = String.format("Relocated to %s%s%s", relocatedGA.getGroupId(), Optional.ofNullable(relocatedGA.getArtifactId()).map(a -> ":" + a).orElse(""), relocation.getContext() == null ? "" : " as per \"" + relocation.getContext() + "\"");
                return (T)SearchResult.found(tree, (String)relocatedMessage);
            }
        };
    }

    @ConstructorProperties(value={"changeDependencies"})
    @Generated
    public RelocatedDependencyCheck(@Nullable Boolean changeDependencies) {
        this.changeDependencies = changeDependencies;
    }

    @Generated
    public RelocatedDependencyReport getReport() {
        return this.report;
    }

    @Generated
    public @Nullable Boolean getChangeDependencies() {
        return this.changeDependencies;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "RelocatedDependencyCheck(report=" + (Object)((Object)this.getReport()) + ", changeDependencies=" + this.getChangeDependencies() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelocatedDependencyCheck)) {
            return false;
        }
        RelocatedDependencyCheck other = (RelocatedDependencyCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$changeDependencies = this.getChangeDependencies();
        Boolean other$changeDependencies = other.getChangeDependencies();
        if (this$changeDependencies == null ? other$changeDependencies != null : !((Object)this$changeDependencies).equals(other$changeDependencies)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelocatedDependencyCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $changeDependencies = this.getChangeDependencies();
        result = result * 59 + ($changeDependencies == null ? 43 : ((Object)$changeDependencies).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    static final class GroupArtifact {
        private final String groupId;
        private final @Nullable String artifactId;

        @ConstructorProperties(value={"groupId", "artifactId"})
        @Generated
        public GroupArtifact(String groupId, @Nullable String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public @Nullable String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupArtifact)) {
                return false;
            }
            GroupArtifact other = (GroupArtifact)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelocatedDependencyCheck.GroupArtifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
        }
    }

    static final class Relocation {
        private final GroupArtifact to;
        private final String context;

        @ConstructorProperties(value={"to", "context"})
        @Generated
        public Relocation(GroupArtifact to, String context) {
            this.to = to;
            this.context = context;
        }

        @Generated
        public GroupArtifact getTo() {
            return this.to;
        }

        @Generated
        public String getContext() {
            return this.context;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Relocation)) {
                return false;
            }
            Relocation other = (Relocation)o;
            GroupArtifact this$to = this.getTo();
            GroupArtifact other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            return !(this$context == null ? other$context != null : !this$context.equals(other$context));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifact $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelocatedDependencyCheck.Relocation(to=" + this.getTo() + ", context=" + this.getContext() + ")";
        }
    }

    public static final class Accumulator {
        private final Map<GroupArtifact, Relocation> migrations;

        @ConstructorProperties(value={"migrations"})
        @Generated
        public Accumulator(Map<GroupArtifact, Relocation> migrations) {
            this.migrations = migrations;
        }

        @Generated
        public Map<GroupArtifact, Relocation> getMigrations() {
            return this.migrations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<GroupArtifact, Relocation> this$migrations = this.getMigrations();
            Map<GroupArtifact, Relocation> other$migrations = other.getMigrations();
            return !(this$migrations == null ? other$migrations != null : !((Object)this$migrations).equals(other$migrations));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<GroupArtifact, Relocation> $migrations = this.getMigrations();
            result = result * 59 + ($migrations == null ? 43 : ((Object)$migrations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelocatedDependencyCheck.Accumulator(migrations=" + this.getMigrations() + ")";
        }
    }
}

