/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.java.dependencies.table.DependencyListReport;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class DependencyList
extends Recipe {
    private final transient DependencyListReport report = new DependencyListReport(this);
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Scope", description="The scope of the dependencies to include in the report.Defaults to \"Compile\"", valid={"Compile", "Runtime", "TestRuntime"}, required=false, example="Compile")
    private final @Nullable Scope scope;
    @Option(displayName="Include transitive dependencies", description="Whether or not to include transitive dependencies in the report. Defaults to including only direct dependencies.Defaults to false.", required=false, example="true")
    private final boolean includeTransitive;
    @Option(displayName="Validate dependencies are resolvable", description="When enabled the recipe will attempt to download every dependency it encounters, reporting on any failures. This can be useful for identifying dependencies that have become unavailable since an LST was produced.Defaults to false.", valid={"true", "false"}, required=false, example="true")
    private final boolean validateResolvable;
    private final transient Set<GroupArtifactVersion> seenGradleProjects = new HashSet<GroupArtifactVersion>();
    private final String displayName = "Dependency report";
    private final String description = "Emits a data table detailing all Gradle and Maven dependencies. This recipe makes no changes to any source file.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Markers m = tree.getMarkers();
                HashSet seen = new HashSet();
                m.findFirst(GradleProject.class).filter(gradle -> DependencyList.this.seenGradleProjects.add(new GroupArtifactVersion(gradle.getGroup(), gradle.getName(), gradle.getVersion()))).ifPresent(gradle -> {
                    GradleDependencyConfiguration conf = gradle.getConfiguration(DependencyList.this.scope().asGradleConfigurationName());
                    if (conf != null) {
                        for (ResolvedDependency dep : conf.getResolved()) {
                            if (dep.getDepth() > 0) continue;
                            DependencyList.this.insertDependency(ctx, gradle, (Set<ResolvedGroupArtifactVersion>)seen, dep, true);
                        }
                    }
                });
                m.findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    for (ResolvedDependency dep : (List)maven.getDependencies().get(DependencyList.this.scope().asMavenScope())) {
                        if (dep.getDepth() > 0) continue;
                        DependencyList.this.insertDependency(ctx, maven, (Set<ResolvedGroupArtifactVersion>)seen, dep, true);
                    }
                });
                return tree;
            }
        };
    }

    private Scope scope() {
        return this.scope == null ? Scope.Compile : this.scope;
    }

    private void insertDependency(ExecutionContext ctx, GradleProject gradle, Set<ResolvedGroupArtifactVersion> seen, ResolvedDependency dep, boolean direct) {
        if (!seen.add(dep.getGav())) {
            return;
        }
        String resolutionFailure = "";
        if (this.validateResolvable) {
            try {
                this.metadataFailures.insertRows(ctx, () -> new MavenPomDownloader(Collections.emptyMap(), ctx, null, null).downloadMetadata(new GroupArtifact(gradle.getGroup(), gradle.getName()), null, gradle.getMavenRepositories()));
            }
            catch (MavenDownloadingException e) {
                resolutionFailure = ExceptionUtils.sanitizeStackTrace((Throwable)e, RecipeScheduler.class);
            }
        }
        this.report.insertRow(ctx, new DependencyListReport.Row("Gradle", gradle.getGroup(), gradle.getName(), gradle.getVersion(), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct, resolutionFailure));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, gradle, seen, transitive, false);
            }
        }
    }

    private void insertDependency(ExecutionContext ctx, MavenResolutionResult maven, Set<ResolvedGroupArtifactVersion> seen, ResolvedDependency dep, boolean direct) {
        if (!seen.add(dep.getGav())) {
            return;
        }
        String resolutionFailure = "";
        if (this.validateResolvable) {
            try {
                MavenExecutionContextView mctx = MavenExecutionContextView.view((ExecutionContext)ctx);
                this.metadataFailures.insertRows(ctx, () -> new MavenPomDownloader(Collections.emptyMap(), ctx, mctx.getSettings() == null ? maven.getMavenSettings() : (maven.getMavenSettings() == null ? mctx.getSettings() : mctx.getSettings().merge(maven.getMavenSettings())), Optional.ofNullable(mctx.getSettings()).map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(maven.getActiveProfiles())).downloadMetadata(new GroupArtifact(maven.getPom().getGroupId(), maven.getPom().getArtifactId()), null, maven.getPom().getRepositories()));
            }
            catch (MavenDownloadingException e) {
                resolutionFailure = ExceptionUtils.sanitizeStackTrace((Throwable)e, RecipeScheduler.class);
            }
        }
        this.report.insertRow(ctx, new DependencyListReport.Row("Maven", maven.getPom().getGroupId(), maven.getPom().getArtifactId(), maven.getPom().getVersion(), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct, resolutionFailure));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, maven, seen, transitive, false);
            }
        }
    }

    @ConstructorProperties(value={"scope", "includeTransitive", "validateResolvable"})
    @Generated
    public DependencyList(@Nullable Scope scope, boolean includeTransitive, boolean validateResolvable) {
        this.scope = scope;
        this.includeTransitive = includeTransitive;
        this.validateResolvable = validateResolvable;
    }

    @Generated
    public DependencyListReport getReport() {
        return this.report;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public @Nullable Scope getScope() {
        return this.scope;
    }

    @Generated
    public boolean isIncludeTransitive() {
        return this.includeTransitive;
    }

    @Generated
    public boolean isValidateResolvable() {
        return this.validateResolvable;
    }

    @Generated
    public Set<GroupArtifactVersion> getSeenGradleProjects() {
        return this.seenGradleProjects;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "DependencyList(report=" + (Object)((Object)this.getReport()) + ", metadataFailures=" + this.getMetadataFailures() + ", scope=" + (Object)((Object)this.getScope()) + ", includeTransitive=" + this.isIncludeTransitive() + ", validateResolvable=" + this.isValidateResolvable() + ", seenGradleProjects=" + this.getSeenGradleProjects() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyList)) {
            return false;
        }
        DependencyList other = (DependencyList)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeTransitive() != other.isIncludeTransitive()) {
            return false;
        }
        if (this.isValidateResolvable() != other.isValidateResolvable()) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DependencyList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeTransitive() ? 79 : 97);
        result = result * 59 + (this.isValidateResolvable() ? 79 : 97);
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static enum Scope {
        Compile,
        Runtime,
        TestRuntime;


        public org.openrewrite.maven.tree.Scope asMavenScope() {
            switch (this.ordinal()) {
                case 0: {
                    return org.openrewrite.maven.tree.Scope.Compile;
                }
                case 1: {
                    return org.openrewrite.maven.tree.Scope.Runtime;
                }
                case 2: {
                    return org.openrewrite.maven.tree.Scope.Test;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }

        public String asGradleConfigurationName() {
            switch (this.ordinal()) {
                case 0: {
                    return "compileClasspath";
                }
                case 1: {
                    return "runtimeClasspath";
                }
                case 2: {
                    return "testRuntimeClasspath";
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }
    }
}

