/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.AddDependency;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.tree.Scope;

public final class AddDependency
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Group ID", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact ID", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*", required=false)
    private final @Nullable String onlyIfUsing;
    @Option(displayName="Classifier", description="A classifier to add. Commonly used to select variants of a library.", example="test", required=false)
    private final @Nullable String classifier;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    private final @Nullable String familyPattern;
    @Option(displayName="Extension", description="For Gradle only, The extension of the dependency to add. If omitted Gradle defaults to assuming the type is \"jar\".", example="jar", required=false)
    private final @Nullable String extension;
    @Option(displayName="Gradle configuration", description="The Gradle dependency configuration name within which to place the dependency. When omitted the configuration will be determined by the Maven scope parameter. If that parameter is also omitted, configuration will be determined based on where types matching `onlyIfUsing` appear in source code.", example="implementation", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Maven scope", description="The Maven scope within which to place the dependency. When omitted scope will be determined based on where types matching `onlyIfUsing` appear in source code.", example="runtime", valid={"compile", "provided", "runtime", "test"}, required=false)
    private final @Nullable String scope;
    @Option(displayName="Releases only", description="For Maven only, Whether to exclude snapshots from consideration when using a semver selector", required=false)
    private final @Nullable Boolean releasesOnly;
    @Option(displayName="Type", description="For Maven only, The type of dependency to add. If omitted Maven defaults to assuming the type is \"jar\".", valid={"jar", "pom", "war"}, example="jar", required=false)
    private final @Nullable String type;
    @Option(displayName="Optional", description="Set the value of the `<optional>` tag. No `<optional>` tag will be added when this is `null`.", required=false)
    private final @Nullable Boolean optional;
    @Option(displayName="Accept transitive", description="Default false. If enabled, the dependency will not be added if it is already on the classpath as a transitive dependency.", example="true", required=false)
    private final @Nullable Boolean acceptTransitive;
    private final String displayName = "Add Gradle or Maven dependency";
    private final String description = "For a Gradle project, add a gradle dependency to a `build.gradle` file in the correct configuration based on where it is used. Or For a maven project, Add a Maven dependency to a `pom.xml` file in the correct scope based on where it is used.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(this.gradleAddDep().getInitialValue(ctx), this.mavenAddDep().getInitialValue(ctx));
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                AddDependency.this.gradleAddDep().getScanner(acc.gradleAccumulator).visit(tree, (Object)ctx);
                AddDependency.this.mavenAddDep().getScanner(acc.mavenAccumulator).visit(tree, (Object)ctx);
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> gradleAddDep;
            final TreeVisitor<?, ExecutionContext> mavenAddDep;
            {
                this.gradleAddDep = AddDependency.this.gradleAddDep().getVisitor(acc.gradleAccumulator);
                this.mavenAddDep = AddDependency.this.mavenAddDep().getVisitor(acc.mavenAccumulator);
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return this.gradleAddDep.isAcceptable(sourceFile, (Object)ctx) || this.mavenAddDep.isAcceptable(sourceFile, (Object)ctx);
            }

            public Tree visit(Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                Tree t = tree;
                if (this.gradleAddDep.isAcceptable((SourceFile)t, (Object)ctx)) {
                    t = this.gradleAddDep.visitNonNull(tree, (Object)ctx);
                }
                if (this.mavenAddDep.isAcceptable((SourceFile)t, (Object)ctx)) {
                    t = this.mavenAddDep.visitNonNull(tree, (Object)ctx);
                }
                return t;
            }
        };
    }

    private org.openrewrite.gradle.AddDependency gradleAddDep() {
        String configurationName = null;
        if (this.configuration != null) {
            configurationName = this.configuration;
        } else if (this.scope != null) {
            configurationName = Scope.asGradleConfigurationName((Scope)Scope.fromName((String)this.scope));
        }
        return new org.openrewrite.gradle.AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, configurationName, this.onlyIfUsing, this.classifier, this.extension, this.familyPattern, this.acceptTransitive);
    }

    private org.openrewrite.maven.AddDependency mavenAddDep() {
        return new org.openrewrite.maven.AddDependency(this.groupId, this.artifactId, this.version != null ? this.version : "latest.release", this.versionPattern, this.scope, this.releasesOnly, this.onlyIfUsing, this.type, this.classifier, this.optional, this.familyPattern, this.acceptTransitive);
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version", "versionPattern", "onlyIfUsing", "classifier", "familyPattern", "extension", "configuration", "scope", "releasesOnly", "type", "optional", "acceptTransitive"})
    @Generated
    public AddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String onlyIfUsing, @Nullable String classifier, @Nullable String familyPattern, @Nullable String extension, @Nullable String configuration, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable Boolean optional, @Nullable Boolean acceptTransitive) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.onlyIfUsing = onlyIfUsing;
        this.classifier = classifier;
        this.familyPattern = familyPattern;
        this.extension = extension;
        this.configuration = configuration;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.optional = optional;
        this.acceptTransitive = acceptTransitive;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable String getFamilyPattern() {
        return this.familyPattern;
    }

    @Generated
    public @Nullable String getExtension() {
        return this.extension;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Generated
    public @Nullable String getType() {
        return this.type;
    }

    @Generated
    public @Nullable Boolean getOptional() {
        return this.optional;
    }

    @Generated
    public @Nullable Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "AddDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", classifier=" + this.getClassifier() + ", familyPattern=" + this.getFamilyPattern() + ", extension=" + this.getExtension() + ", configuration=" + this.getConfiguration() + ", scope=" + this.getScope() + ", releasesOnly=" + this.getReleasesOnly() + ", type=" + this.getType() + ", optional=" + this.getOptional() + ", acceptTransitive=" + this.getAcceptTransitive() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        if (this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final AddDependency.Scanned gradleAccumulator;
        private final AddDependency.Scanned mavenAccumulator;

        @ConstructorProperties(value={"gradleAccumulator", "mavenAccumulator"})
        @Generated
        public Accumulator(AddDependency.Scanned gradleAccumulator, AddDependency.Scanned mavenAccumulator) {
            this.gradleAccumulator = gradleAccumulator;
            this.mavenAccumulator = mavenAccumulator;
        }

        @Generated
        public AddDependency.Scanned getGradleAccumulator() {
            return this.gradleAccumulator;
        }

        @Generated
        public AddDependency.Scanned getMavenAccumulator() {
            return this.mavenAccumulator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            AddDependency.Scanned this$gradleAccumulator = this.getGradleAccumulator();
            AddDependency.Scanned other$gradleAccumulator = other.getGradleAccumulator();
            if (this$gradleAccumulator == null ? other$gradleAccumulator != null : !this$gradleAccumulator.equals(other$gradleAccumulator)) {
                return false;
            }
            AddDependency.Scanned this$mavenAccumulator = this.getMavenAccumulator();
            AddDependency.Scanned other$mavenAccumulator = other.getMavenAccumulator();
            return !(this$mavenAccumulator == null ? other$mavenAccumulator != null : !this$mavenAccumulator.equals(other$mavenAccumulator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AddDependency.Scanned $gradleAccumulator = this.getGradleAccumulator();
            result = result * 59 + ($gradleAccumulator == null ? 43 : $gradleAccumulator.hashCode());
            AddDependency.Scanned $mavenAccumulator = this.getMavenAccumulator();
            result = result * 59 + ($mavenAccumulator == null ? 43 : $mavenAccumulator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AddDependency.Accumulator(gradleAccumulator=" + this.getGradleAccumulator() + ", mavenAccumulator=" + this.getMavenAccumulator() + ")";
        }
    }
}

