/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;

public final class Sbom {
    public static @Nullable Bom sbomFrom(Marker m) {
        if (m instanceof MavenResolutionResult) {
            return Sbom.sbomFrom((MavenResolutionResult)m);
        }
        if (m instanceof GradleProject) {
            return Sbom.sbomFrom((GradleProject)m);
        }
        return null;
    }

    public static Bom sbomFrom(MavenResolutionResult mrr) {
        return Bom.builder().version(mrr.getPom().getVersion()).metadata(Metadata.builder().tools(Collections.singletonList(Tool.builder().vendor("OpenRewrite by Moderne").name("OpenRewrite CycloneDX").version("8.32.0").build())).component(Sbom.componentFrom(mrr)).build()).components(Sbom.componentsFrom(mrr)).dependencies(Sbom.dependenciesFrom(mrr)).build();
    }

    public static Bom sbomFrom(GradleProject gp) {
        return Bom.builder().version(gp.getVersion()).metadata(Metadata.builder().tools(Collections.singletonList(Tool.builder().vendor("OpenRewrite by Moderne").name("OpenRewrite CycloneDX").version("8.32.0").build())).component(Sbom.componentFrom(gp)).build()).components(Sbom.componentsFrom(gp)).dependencies(Sbom.dependenciesFrom(gp)).build();
    }

    private static Component componentFrom(MavenResolutionResult mrr) {
        String groupId = mrr.getPom().getGroupId();
        String artifactId = mrr.getPom().getArtifactId();
        String version = mrr.getPom().getVersion();
        String bomRef = Sbom.bomRefFrom(groupId, artifactId, version);
        return Component.builder().bomRef(bomRef).group(groupId).name(artifactId).version(version).purl(bomRef).build();
    }

    private static Component componentFrom(GradleProject gp) {
        String groupId = gp.getGroup();
        String artifactId = gp.getName();
        String version = gp.getVersion();
        String bomRef = Sbom.bomRefFrom(groupId, artifactId, version);
        return Component.builder().bomRef(bomRef).group(groupId).name(artifactId).version(version).purl(bomRef).build();
    }

    private static String bomRefFrom(@Nullable String groupId, String artifactId, @Nullable String version) {
        return String.format("pkg:maven/%s/%s@%s", groupId == null ? "" : groupId, artifactId, version == null ? "" : version);
    }

    private static List<Component> componentsFrom(MavenResolutionResult mrr) {
        List<ResolvedDependency> compileDependencies = mrr.getDependencies().getOrDefault(Scope.Runtime, Collections.emptyList());
        List<ResolvedDependency> providedDependencies = mrr.getDependencies().getOrDefault(Scope.Provided, Collections.emptyList());
        return Sbom.componentsFrom(compileDependencies, providedDependencies);
    }

    private static List<Component> componentsFrom(GradleProject gp) {
        List compileDependencies = Optional.ofNullable(gp.getConfiguration("runtimeClasspath")).map(GradleDependencyConfiguration::getDirectResolved).orElseGet(Collections::emptyList);
        List providedDependencies = Optional.ofNullable(gp.getConfiguration("compileOnly")).map(GradleDependencyConfiguration::getDirectResolved).orElseGet(Collections::emptyList);
        return Sbom.componentsFrom(compileDependencies, providedDependencies);
    }

    private static List<Component> componentsFrom(List<ResolvedDependency> compileDependencies, List<ResolvedDependency> providedDependencies) {
        String bomRef;
        ArrayList<Component> components = new ArrayList<Component>(compileDependencies.size() + providedDependencies.size());
        HashSet<String> seen = new HashSet<String>();
        for (ResolvedDependency dep : compileDependencies) {
            bomRef = Sbom.bomRefFrom(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            seen.add(bomRef);
            components.add(Component.builder().bomRef(bomRef).group(dep.getGroupId()).name(dep.getArtifactId()).version(dep.getVersion()).scope("required").licenses(dep.getLicenses().stream().map(l -> License.builder().name(l.getName()).build()).collect(Collectors.toList())).purl(bomRef).build());
        }
        for (ResolvedDependency dep : providedDependencies) {
            bomRef = Sbom.bomRefFrom(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            if (!seen.add(bomRef)) continue;
            components.add(Component.builder().bomRef(bomRef).group(dep.getGroupId()).name(dep.getArtifactId()).version(dep.getVersion()).scope("optional").purl(bomRef).build());
        }
        return components;
    }

    private static List<Dependency> dependenciesFrom(MavenResolutionResult mrr) {
        List<ResolvedDependency> compileDependencies = mrr.getDependencies().getOrDefault(Scope.Runtime, Collections.emptyList());
        List<ResolvedDependency> providedDependencies = mrr.getDependencies().getOrDefault(Scope.Provided, Collections.emptyList());
        return Sbom.dependenciesFrom(compileDependencies, providedDependencies);
    }

    private static List<Dependency> dependenciesFrom(GradleProject gp) {
        List compileDependencies = Optional.ofNullable(gp.getConfiguration("runtimeClasspath")).map(GradleDependencyConfiguration::getDirectResolved).orElseGet(Collections::emptyList);
        List providedDependencies = Optional.ofNullable(gp.getConfiguration("compileOnly")).map(GradleDependencyConfiguration::getDirectResolved).orElseGet(Collections::emptyList);
        return Sbom.dependenciesFrom(compileDependencies, providedDependencies);
    }

    private static List<Dependency> dependenciesFrom(List<ResolvedDependency> compileDependencies, List<ResolvedDependency> providedDependencies) {
        Dependency dependency;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(compileDependencies.size() + providedDependencies.size());
        HashSet<Dependency> seen = new HashSet<Dependency>();
        for (ResolvedDependency dep : compileDependencies) {
            dependency = Sbom.dependencyFrom(dep);
            if (!seen.add(dependency)) continue;
            dependencies.add(dependency);
        }
        for (ResolvedDependency dep : providedDependencies) {
            dependency = Sbom.dependencyFrom(dep);
            if (!seen.add(dependency)) continue;
            dependencies.add(Sbom.dependencyFrom(dep));
        }
        return dependencies;
    }

    private static Dependency dependencyFrom(ResolvedDependency dep) {
        return Dependency.builder().ref(Sbom.bomRefFrom(dep.getGroupId(), dep.getArtifactId(), dep.getVersion())).dependencies(dep.getDependencies().stream().map(Sbom::dependencyFrom).collect(Collectors.toList())).build();
    }

    @Generated
    public Sbom() {
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Sbom;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Sbom()";
    }

    @JacksonXmlRootElement(localName="bom")
    @JsonPropertyOrder(value={"xmlns", "version"})
    public static final class Bom {
        @JacksonXmlProperty(isAttribute=true)
        private final String xmlns = "http://cyclonedx.org/schema/bom/1.6";
        @JacksonXmlProperty(isAttribute=true)
        private final String version;
        private final Metadata metadata;
        @JacksonXmlElementWrapper(localName="components")
        @JacksonXmlProperty(localName="component")
        private final List<Component> components;
        @JacksonXmlElementWrapper(localName="dependencies")
        @JacksonXmlProperty(localName="dependency")
        private final List<Dependency> dependencies;

        @ConstructorProperties(value={"version", "metadata", "components", "dependencies"})
        @Generated
        Bom(String version, Metadata metadata, List<Component> components, List<Dependency> dependencies) {
            this.version = version;
            this.metadata = metadata;
            this.components = components;
            this.dependencies = dependencies;
        }

        @NonNull
        @Generated
        public static BomBuilder builder() {
            return new BomBuilder();
        }

        @Generated
        public String getXmlns() {
            return this.xmlns;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public Metadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public List<Component> getComponents() {
            return this.components;
        }

        @Generated
        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bom)) {
                return false;
            }
            Bom other = (Bom)o;
            String this$xmlns = this.getXmlns();
            String other$xmlns = other.getXmlns();
            if (this$xmlns == null ? other$xmlns != null : !this$xmlns.equals(other$xmlns)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Metadata this$metadata = this.getMetadata();
            Metadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            List<Component> this$components = this.getComponents();
            List<Component> other$components = other.getComponents();
            if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $xmlns = this.getXmlns();
            result = result * 59 + ($xmlns == null ? 43 : $xmlns.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Metadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            List<Component> $components = this.getComponents();
            result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.Bom(xmlns=" + this.getXmlns() + ", version=" + this.getVersion() + ", metadata=" + this.getMetadata() + ", components=" + this.getComponents() + ", dependencies=" + this.getDependencies() + ")";
        }

        @Generated
        public static class BomBuilder {
            @Generated
            private String version;
            @Generated
            private Metadata metadata;
            @Generated
            private List<Component> components;
            @Generated
            private List<Dependency> dependencies;

            @Generated
            BomBuilder() {
            }

            @NonNull
            @JacksonXmlProperty(isAttribute=true)
            @Generated
            public BomBuilder version(String version) {
                this.version = version;
                return this;
            }

            @NonNull
            @Generated
            public BomBuilder metadata(Metadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @NonNull
            @JacksonXmlElementWrapper(localName="components")
            @JacksonXmlProperty(localName="component")
            @Generated
            public BomBuilder components(List<Component> components) {
                this.components = components;
                return this;
            }

            @NonNull
            @JacksonXmlElementWrapper(localName="dependencies")
            @JacksonXmlProperty(localName="dependency")
            @Generated
            public BomBuilder dependencies(List<Dependency> dependencies) {
                this.dependencies = dependencies;
                return this;
            }

            @NonNull
            @Generated
            public Bom build() {
                return new Bom(this.version, this.metadata, this.components, this.dependencies);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.Bom.BomBuilder(version=" + this.version + ", metadata=" + this.metadata + ", components=" + this.components + ", dependencies=" + this.dependencies + ")";
            }
        }
    }

    public static final class Metadata {
        @JacksonXmlElementWrapper(localName="tools")
        @JacksonXmlProperty(localName="tool")
        private final List<Tool> tools;
        private final Component component;

        @ConstructorProperties(value={"tools", "component"})
        @Generated
        Metadata(List<Tool> tools, Component component) {
            this.tools = tools;
            this.component = component;
        }

        @NonNull
        @Generated
        public static MetadataBuilder builder() {
            return new MetadataBuilder();
        }

        @Generated
        public List<Tool> getTools() {
            return this.tools;
        }

        @Generated
        public Component getComponent() {
            return this.component;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            List<Tool> this$tools = this.getTools();
            List<Tool> other$tools = other.getTools();
            if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
                return false;
            }
            Component this$component = this.getComponent();
            Component other$component = other.getComponent();
            return !(this$component == null ? other$component != null : !((Object)this$component).equals(other$component));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Tool> $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            Component $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.Metadata(tools=" + this.getTools() + ", component=" + this.getComponent() + ")";
        }

        @Generated
        public static class MetadataBuilder {
            @Generated
            private List<Tool> tools;
            @Generated
            private Component component;

            @Generated
            MetadataBuilder() {
            }

            @NonNull
            @JacksonXmlElementWrapper(localName="tools")
            @JacksonXmlProperty(localName="tool")
            @Generated
            public MetadataBuilder tools(List<Tool> tools) {
                this.tools = tools;
                return this;
            }

            @NonNull
            @Generated
            public MetadataBuilder component(Component component) {
                this.component = component;
                return this;
            }

            @NonNull
            @Generated
            public Metadata build() {
                return new Metadata(this.tools, this.component);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.Metadata.MetadataBuilder(tools=" + this.tools + ", component=" + this.component + ")";
            }
        }
    }

    public static final class Tool {
        private final String vendor;
        private final String name;
        private final String version;

        @ConstructorProperties(value={"vendor", "name", "version"})
        @Generated
        Tool(String vendor, String name, String version) {
            this.vendor = vendor;
            this.name = name;
            this.version = version;
        }

        @NonNull
        @Generated
        public static ToolBuilder builder() {
            return new ToolBuilder();
        }

        @Generated
        public String getVendor() {
            return this.vendor;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tool)) {
                return false;
            }
            Tool other = (Tool)o;
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.Tool(vendor=" + this.getVendor() + ", name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public static class ToolBuilder {
            @Generated
            private String vendor;
            @Generated
            private String name;
            @Generated
            private String version;

            @Generated
            ToolBuilder() {
            }

            @NonNull
            @Generated
            public ToolBuilder vendor(String vendor) {
                this.vendor = vendor;
                return this;
            }

            @NonNull
            @Generated
            public ToolBuilder name(String name) {
                this.name = name;
                return this;
            }

            @NonNull
            @Generated
            public ToolBuilder version(String version) {
                this.version = version;
                return this;
            }

            @NonNull
            @Generated
            public Tool build() {
                return new Tool(this.vendor, this.name, this.version);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.Tool.ToolBuilder(vendor=" + this.vendor + ", name=" + this.name + ", version=" + this.version + ")";
            }
        }
    }

    @JsonPropertyOrder(value={"xmlns", "type", "group", "name", "version", "version"})
    public static final class Component {
        @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
        private final String bomRef;
        @JacksonXmlProperty(isAttribute=true)
        private final @Nullable String type;
        private final String group;
        private final String name;
        private final String version;
        private final @Nullable String scope;
        @JacksonXmlElementWrapper(localName="licenses")
        @JacksonXmlProperty(localName="license")
        private final List<License> licenses;
        private final String purl;

        @ConstructorProperties(value={"bomRef", "type", "group", "name", "version", "scope", "licenses", "purl"})
        @Generated
        Component(String bomRef, @Nullable String type, String group, String name, String version, @Nullable String scope, List<License> licenses, String purl) {
            this.bomRef = bomRef;
            this.type = type;
            this.group = group;
            this.name = name;
            this.version = version;
            this.scope = scope;
            this.licenses = licenses;
            this.purl = purl;
        }

        @NonNull
        @Generated
        public static ComponentBuilder builder() {
            return new ComponentBuilder();
        }

        @Generated
        public String getBomRef() {
            return this.bomRef;
        }

        @Generated
        public @Nullable String getType() {
            return this.type;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public @Nullable String getScope() {
            return this.scope;
        }

        @Generated
        public List<License> getLicenses() {
            return this.licenses;
        }

        @Generated
        public String getPurl() {
            return this.purl;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Component)) {
                return false;
            }
            Component other = (Component)o;
            String this$bomRef = this.getBomRef();
            String other$bomRef = other.getBomRef();
            if (this$bomRef == null ? other$bomRef != null : !this$bomRef.equals(other$bomRef)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            List<License> this$licenses = this.getLicenses();
            List<License> other$licenses = other.getLicenses();
            if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
                return false;
            }
            String this$purl = this.getPurl();
            String other$purl = other.getPurl();
            return !(this$purl == null ? other$purl != null : !this$purl.equals(other$purl));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bomRef = this.getBomRef();
            result = result * 59 + ($bomRef == null ? 43 : $bomRef.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            List<License> $licenses = this.getLicenses();
            result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
            String $purl = this.getPurl();
            result = result * 59 + ($purl == null ? 43 : $purl.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.Component(bomRef=" + this.getBomRef() + ", type=" + this.getType() + ", group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", licenses=" + this.getLicenses() + ", purl=" + this.getPurl() + ")";
        }

        @Generated
        public static class ComponentBuilder {
            @Generated
            private String bomRef;
            @Generated
            private String type;
            @Generated
            private String group;
            @Generated
            private String name;
            @Generated
            private String version;
            @Generated
            private String scope;
            @Generated
            private List<License> licenses;
            @Generated
            private String purl;

            @Generated
            ComponentBuilder() {
            }

            @NonNull
            @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
            @Generated
            public ComponentBuilder bomRef(String bomRef) {
                this.bomRef = bomRef;
                return this;
            }

            @NonNull
            @JacksonXmlProperty(isAttribute=true)
            @Generated
            public ComponentBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @NonNull
            @Generated
            public ComponentBuilder group(String group) {
                this.group = group;
                return this;
            }

            @NonNull
            @Generated
            public ComponentBuilder name(String name) {
                this.name = name;
                return this;
            }

            @NonNull
            @Generated
            public ComponentBuilder version(String version) {
                this.version = version;
                return this;
            }

            @NonNull
            @Generated
            public ComponentBuilder scope(@Nullable String scope) {
                this.scope = scope;
                return this;
            }

            @NonNull
            @JacksonXmlElementWrapper(localName="licenses")
            @JacksonXmlProperty(localName="license")
            @Generated
            public ComponentBuilder licenses(List<License> licenses) {
                this.licenses = licenses;
                return this;
            }

            @NonNull
            @Generated
            public ComponentBuilder purl(String purl) {
                this.purl = purl;
                return this;
            }

            @NonNull
            @Generated
            public Component build() {
                return new Component(this.bomRef, this.type, this.group, this.name, this.version, this.scope, this.licenses, this.purl);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.Component.ComponentBuilder(bomRef=" + this.bomRef + ", type=" + this.type + ", group=" + this.group + ", name=" + this.name + ", version=" + this.version + ", scope=" + this.scope + ", licenses=" + this.licenses + ", purl=" + this.purl + ")";
            }
        }
    }

    public static final class Dependency {
        @JacksonXmlProperty(isAttribute=true)
        private final String ref;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="dependency")
        private final List<Dependency> dependencies;

        @ConstructorProperties(value={"ref", "dependencies"})
        @Generated
        Dependency(String ref, List<Dependency> dependencies) {
            this.ref = ref;
            this.dependencies = dependencies;
        }

        @NonNull
        @Generated
        public static DependencyBuilder builder() {
            return new DependencyBuilder();
        }

        @Generated
        public String getRef() {
            return this.ref;
        }

        @Generated
        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            String this$ref = this.getRef();
            String other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.Dependency(ref=" + this.getRef() + ", dependencies=" + this.getDependencies() + ")";
        }

        @Generated
        public static class DependencyBuilder {
            @Generated
            private String ref;
            @Generated
            private List<Dependency> dependencies;

            @Generated
            DependencyBuilder() {
            }

            @NonNull
            @JacksonXmlProperty(isAttribute=true)
            @Generated
            public DependencyBuilder ref(String ref) {
                this.ref = ref;
                return this;
            }

            @NonNull
            @JacksonXmlElementWrapper(useWrapping=false)
            @JacksonXmlProperty(localName="dependency")
            @Generated
            public DependencyBuilder dependencies(List<Dependency> dependencies) {
                this.dependencies = dependencies;
                return this;
            }

            @NonNull
            @Generated
            public Dependency build() {
                return new Dependency(this.ref, this.dependencies);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.Dependency.DependencyBuilder(ref=" + this.ref + ", dependencies=" + this.dependencies + ")";
            }
        }
    }

    public static final class License {
        private final String id;
        private final String name;

        @ConstructorProperties(value={"id", "name"})
        @Generated
        License(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @NonNull
        @Generated
        public static LicenseBuilder builder() {
            return new LicenseBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Sbom.License(id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        @Generated
        public static class LicenseBuilder {
            @Generated
            private String id;
            @Generated
            private String name;

            @Generated
            LicenseBuilder() {
            }

            @NonNull
            @Generated
            public LicenseBuilder id(String id) {
                this.id = id;
                return this;
            }

            @NonNull
            @Generated
            public LicenseBuilder name(String name) {
                this.name = name;
                return this;
            }

            @NonNull
            @Generated
            public License build() {
                return new License(this.id, this.name);
            }

            @NonNull
            @Generated
            public String toString() {
                return "Sbom.License.LicenseBuilder(id=" + this.id + ", name=" + this.name + ")";
            }
        }
    }
}

