/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;

public final class RemoveDependency
extends Recipe {
    @Option(displayName="Group ID", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact ID", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="The dependency configuration", description="The dependency configuration to remove from.", example="api", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Scope", description="Only remove dependencies if they are in this scope. If 'runtime', this willalso remove dependencies in the 'compile' scope because 'compile' dependencies are part of the runtime dependency set", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    private final @Nullable String scope;
    private final @Nullable org.openrewrite.gradle.RemoveDependency removeGradleDependency;
    private final @Nullable org.openrewrite.maven.RemoveDependency removeMavenDependency;

    public String getDisplayName() {
        return "Remove a Gradle or Maven dependency";
    }

    public String getDescription() {
        return "For Gradle project, removes a single dependency from the dependencies section of the `build.gradle`.\nFor Maven project, removes a single dependency from the <dependencies> section of the pom.xml.";
    }

    public RemoveDependency(String groupId, String artifactId, @Nullable String configuration, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
        this.scope = scope;
        this.removeGradleDependency = new org.openrewrite.gradle.RemoveDependency(groupId, artifactId, configuration);
        this.removeMavenDependency = new org.openrewrite.maven.RemoveDependency(groupId, artifactId, scope);
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(this.removeGradleDependency, this.removeMavenDependency);
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable org.openrewrite.gradle.RemoveDependency getRemoveGradleDependency() {
        return this.removeGradleDependency;
    }

    @Generated
    public @Nullable org.openrewrite.maven.RemoveDependency getRemoveMavenDependency() {
        return this.removeMavenDependency;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ", scope=" + this.getScope() + ", removeGradleDependency=" + this.getRemoveGradleDependency() + ", removeMavenDependency=" + this.getRemoveMavenDependency() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveDependency)) {
            return false;
        }
        RemoveDependency other = (RemoveDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        org.openrewrite.gradle.RemoveDependency this$removeGradleDependency = this.getRemoveGradleDependency();
        org.openrewrite.gradle.RemoveDependency other$removeGradleDependency = other.getRemoveGradleDependency();
        if (this$removeGradleDependency == null ? other$removeGradleDependency != null : !this$removeGradleDependency.equals(other$removeGradleDependency)) {
            return false;
        }
        org.openrewrite.maven.RemoveDependency this$removeMavenDependency = this.getRemoveMavenDependency();
        org.openrewrite.maven.RemoveDependency other$removeMavenDependency = other.getRemoveMavenDependency();
        return !(this$removeMavenDependency == null ? other$removeMavenDependency != null : !this$removeMavenDependency.equals(other$removeMavenDependency));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        org.openrewrite.gradle.RemoveDependency $removeGradleDependency = this.getRemoveGradleDependency();
        result = result * 59 + ($removeGradleDependency == null ? 43 : $removeGradleDependency.hashCode());
        org.openrewrite.maven.RemoveDependency $removeMavenDependency = this.getRemoveMavenDependency();
        result = result * 59 + ($removeMavenDependency == null ? 43 : $removeMavenDependency.hashCode());
        return result;
    }
}

