/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.table.LicenseReport;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class DependencyLicenseCheck
extends ScanningRecipe<Map<ResolvedGroupArtifactVersion, Set<License>>> {
    private final transient LicenseReport report = new LicenseReport((Recipe)this);
    @Option(displayName="Scope", description="Match dependencies with the specified scope", valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final String scope;
    @Option(displayName="Add markers", description="Report each license transitively used by a dependency in search results.", required=false)
    private final @Nullable Boolean addMarkers;

    public String getDisplayName() {
        return "Find licenses in use in third-party dependencies";
    }

    public String getDescription() {
        return "Locates and reports on all licenses in use.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                Scope.fromName((String)s);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public Map<ResolvedGroupArtifactVersion, Set<License>> getInitialValue(ExecutionContext ctx) {
        return new HashMap<ResolvedGroupArtifactVersion, Set<License>>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<ResolvedGroupArtifactVersion, Set<License>> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Scope scope = Scope.fromName((String)DependencyLicenseCheck.this.scope);
                DependencyLicenseCheck.this.scanMaven(acc, scope).visit(tree, (Object)ctx);
                DependencyLicenseCheck.this.scanGradleGroovy(acc, scope).visit(tree, (Object)ctx);
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Map<ResolvedGroupArtifactVersion, Set<License>> acc, ExecutionContext ctx) {
        for (Map.Entry<ResolvedGroupArtifactVersion, Set<License>> licensesByGav : acc.entrySet()) {
            ResolvedGroupArtifactVersion gav = licensesByGav.getKey();
            for (License license : licensesByGav.getValue()) {
                this.report.insertRow(ctx, new LicenseReport.Row(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), license.getName(), license.getType().toString()));
            }
        }
        return Collections.emptyList();
    }

    private MavenVisitor<ExecutionContext> scanMaven(final Map<ResolvedGroupArtifactVersion, Set<License>> licenses, final Scope aScope) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                List scopeDependencies = (List)this.getResolutionResult().getDependencies().get(aScope);
                if (scopeDependencies != null) {
                    for (ResolvedDependency resolvedDependency : scopeDependencies) {
                        DependencyLicenseCheck.this.analyzeDependency(resolvedDependency, licenses);
                    }
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }

    private GroovyVisitor<ExecutionContext> scanGradleGroovy(final Map<ResolvedGroupArtifactVersion, Set<License>> licenses, Scope aScope) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(GradleProject.class).ifPresent(gradleProject -> {
                    for (GradleDependencyConfiguration configuration : gradleProject.getConfigurations()) {
                        for (ResolvedDependency resolvedDependency : configuration.getResolved()) {
                            if (StringUtils.isBlank((String)resolvedDependency.getVersion())) continue;
                            DependencyLicenseCheck.this.analyzeDependency(resolvedDependency, licenses);
                        }
                    }
                });
                return super.visitCompilationUnit(cu, (Object)ctx);
            }
        };
    }

    private void analyzeDependency(ResolvedDependency resolvedDependency, Map<ResolvedGroupArtifactVersion, Set<License>> licenses) {
        if (!resolvedDependency.getLicenses().isEmpty()) {
            licenses.computeIfAbsent(resolvedDependency.getGav(), gav -> new LinkedHashSet()).addAll(resolvedDependency.getLicenses());
        } else {
            licenses.computeIfAbsent(resolvedDependency.getGav(), gav -> new LinkedHashSet()).add(new License("", License.Type.Unknown));
        }
    }

    @ConstructorProperties(value={"scope", "addMarkers"})
    @Generated
    public DependencyLicenseCheck(String scope, @Nullable Boolean addMarkers) {
        this.scope = scope;
        this.addMarkers = addMarkers;
    }

    @Generated
    public LicenseReport getReport() {
        return this.report;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable Boolean getAddMarkers() {
        return this.addMarkers;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyLicenseCheck(report=" + (Object)((Object)this.getReport()) + ", scope=" + this.getScope() + ", addMarkers=" + this.getAddMarkers() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyLicenseCheck)) {
            return false;
        }
        DependencyLicenseCheck other = (DependencyLicenseCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addMarkers = this.getAddMarkers();
        Boolean other$addMarkers = other.getAddMarkers();
        if (this$addMarkers == null ? other$addMarkers != null : !((Object)this$addMarkers).equals(other$addMarkers)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyLicenseCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addMarkers = this.getAddMarkers();
        result = result * 59 + ($addMarkers == null ? 43 : ((Object)$addMarkers).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

