/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class RepositoryAccessibilityReport
extends DataTable<Row> {
    public RepositoryAccessibilityReport(Recipe recipe) {
        super(recipe, "Repository accessibility report", "Listing of all dependency repositories and whether they are accessible.");
    }

    public static final class Row {
        @Column(displayName="Repository URI", description="The URI of the repository")
        private final String uri;
        @Column(displayName="Ping exception type", description="Empty if the repository responded to a ping. Otherwise, the type of exception encountered when attempting to access the repository.")
        private final String pingExceptionType;
        @Column(displayName="Ping error message", description="Empty if the repository was accessible. Otherwise, the error message encountered when attempting to access the repository.")
        private final String pingExceptionMessage;
        @Column(displayName="Ping HTTP code", description="The HTTP response code returned by the repository. May be empty for non-HTTP repositories.")
        @Nullable
        private final Integer pingHttpCode;
        @Column(displayName="Dependency resolution exception type", description="Empty if ping failed, or if the repository successfully downloaded the specified dependency. Otherwise, the type of exception encountered when attempting to access the repository.")
        private final String dependencyResolveExceptionType;
        @Column(displayName="Dependency resolution error message", description="Empty if ping failed, or if the repository successfully downloaded the specified dependency. Otherwise, the error message encountered when attempting to access the repository.")
        private final String dependencyResolveExceptionMessage;

        @ConstructorProperties(value={"uri", "pingExceptionType", "pingExceptionMessage", "pingHttpCode", "dependencyResolveExceptionType", "dependencyResolveExceptionMessage"})
        @Generated
        public Row(String uri, String pingExceptionType, String pingExceptionMessage, @Nullable Integer pingHttpCode, String dependencyResolveExceptionType, String dependencyResolveExceptionMessage) {
            this.uri = uri;
            this.pingExceptionType = pingExceptionType;
            this.pingExceptionMessage = pingExceptionMessage;
            this.pingHttpCode = pingHttpCode;
            this.dependencyResolveExceptionType = dependencyResolveExceptionType;
            this.dependencyResolveExceptionMessage = dependencyResolveExceptionMessage;
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public String getPingExceptionType() {
            return this.pingExceptionType;
        }

        @Generated
        public String getPingExceptionMessage() {
            return this.pingExceptionMessage;
        }

        @Nullable
        @Generated
        public Integer getPingHttpCode() {
            return this.pingHttpCode;
        }

        @Generated
        public String getDependencyResolveExceptionType() {
            return this.dependencyResolveExceptionType;
        }

        @Generated
        public String getDependencyResolveExceptionMessage() {
            return this.dependencyResolveExceptionMessage;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$pingHttpCode = this.getPingHttpCode();
            Integer other$pingHttpCode = other.getPingHttpCode();
            if (this$pingHttpCode == null ? other$pingHttpCode != null : !((Object)this$pingHttpCode).equals(other$pingHttpCode)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$pingExceptionType = this.getPingExceptionType();
            String other$pingExceptionType = other.getPingExceptionType();
            if (this$pingExceptionType == null ? other$pingExceptionType != null : !this$pingExceptionType.equals(other$pingExceptionType)) {
                return false;
            }
            String this$pingExceptionMessage = this.getPingExceptionMessage();
            String other$pingExceptionMessage = other.getPingExceptionMessage();
            if (this$pingExceptionMessage == null ? other$pingExceptionMessage != null : !this$pingExceptionMessage.equals(other$pingExceptionMessage)) {
                return false;
            }
            String this$dependencyResolveExceptionType = this.getDependencyResolveExceptionType();
            String other$dependencyResolveExceptionType = other.getDependencyResolveExceptionType();
            if (this$dependencyResolveExceptionType == null ? other$dependencyResolveExceptionType != null : !this$dependencyResolveExceptionType.equals(other$dependencyResolveExceptionType)) {
                return false;
            }
            String this$dependencyResolveExceptionMessage = this.getDependencyResolveExceptionMessage();
            String other$dependencyResolveExceptionMessage = other.getDependencyResolveExceptionMessage();
            return !(this$dependencyResolveExceptionMessage == null ? other$dependencyResolveExceptionMessage != null : !this$dependencyResolveExceptionMessage.equals(other$dependencyResolveExceptionMessage));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $pingHttpCode = this.getPingHttpCode();
            result = result * 59 + ($pingHttpCode == null ? 43 : ((Object)$pingHttpCode).hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $pingExceptionType = this.getPingExceptionType();
            result = result * 59 + ($pingExceptionType == null ? 43 : $pingExceptionType.hashCode());
            String $pingExceptionMessage = this.getPingExceptionMessage();
            result = result * 59 + ($pingExceptionMessage == null ? 43 : $pingExceptionMessage.hashCode());
            String $dependencyResolveExceptionType = this.getDependencyResolveExceptionType();
            result = result * 59 + ($dependencyResolveExceptionType == null ? 43 : $dependencyResolveExceptionType.hashCode());
            String $dependencyResolveExceptionMessage = this.getDependencyResolveExceptionMessage();
            result = result * 59 + ($dependencyResolveExceptionMessage == null ? 43 : $dependencyResolveExceptionMessage.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RepositoryAccessibilityReport.Row(uri=" + this.getUri() + ", pingExceptionType=" + this.getPingExceptionType() + ", pingExceptionMessage=" + this.getPingExceptionMessage() + ", pingHttpCode=" + this.getPingHttpCode() + ", dependencyResolveExceptionType=" + this.getDependencyResolveExceptionType() + ", dependencyResolveExceptionMessage=" + this.getDependencyResolveExceptionMessage() + ")";
        }
    }
}

