/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SelfHostedRunnerRecipe
extends Recipe {
    public String getDisplayName() {
        return "Find usage of self-hosted runners";
    }

    public String getDescription() {
        return "Find workflows that use `self-hosted` runners, which may have security implications in public repositories due to potential persistence between workflow runs and lack of isolation. Self-hosted runners should be properly secured and ideally ephemeral. Based on [zizmor's `self-hosted-runner` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/self_hosted_runner.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new SelfHostedRunnerVisitor());
    }

    @Generated
    public SelfHostedRunnerRecipe() {
    }

    @Generated
    public String toString() {
        return "SelfHostedRunnerRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelfHostedRunnerRecipe)) {
            return false;
        }
        SelfHostedRunnerRecipe other = (SelfHostedRunnerRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SelfHostedRunnerRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class SelfHostedRunnerVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private SelfHostedRunnerVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if ("runs-on".equals(mappingEntry.getKey().getValue())) {
                return this.checkRunsOn(mappingEntry);
            }
            return mappingEntry;
        }

        private Yaml.Mapping.Entry checkRunsOn(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                Yaml.Scalar scalar = (Yaml.Scalar)entry.getValue();
                return this.checkRunsOnValue(entry, scalar.getValue());
            }
            if (entry.getValue() instanceof Yaml.Sequence) {
                return this.checkRunsOnSequence(entry, (Yaml.Sequence)entry.getValue());
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRunsOnValue(Yaml.Mapping.Entry entry, String runsOnValue) {
            if ("self-hosted".equals(runsOnValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses self-hosted runner which may have security implications in public repositories. Ensure runners are ephemeral and properly isolated.");
            }
            if (runsOnValue.contains("${{") && this.containsSelfHostedInMatrix(runsOnValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Expression may expand to self-hosted runner. Verify that self-hosted runners are properly secured.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRunsOnSequence(Yaml.Mapping.Entry entry, Yaml.Sequence sequence) {
            String firstValue = YamlHelper.getScalarValue(((Yaml.Sequence.Entry)sequence.getEntries().get(0)).getBlock());
            if ("self-hosted".equals(firstValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses self-hosted runner which may have security implications in public repositories. Ensure runners are ephemeral and properly isolated.");
            }
            return entry;
        }

        private boolean containsSelfHostedInMatrix(String expression) {
            if (!expression.contains("matrix.")) {
                return false;
            }
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Object value = current.getValue();
                if (!(value instanceof Yaml.Mapping)) continue;
                Yaml.Mapping mapping = (Yaml.Mapping)value;
                for (Yaml.Mapping.Entry matrixEntry : mapping.getEntries()) {
                    if (!"strategy".equals(matrixEntry.getKey().getValue()) || !(matrixEntry.getValue() instanceof Yaml.Mapping)) continue;
                    return this.hasMatrixWithSelfHosted((Yaml.Mapping)matrixEntry.getValue());
                }
            }
            return false;
        }

        private boolean hasMatrixWithSelfHosted(Yaml.Mapping strategyMapping) {
            for (Yaml.Mapping.Entry strategyEntry : strategyMapping.getEntries()) {
                if (!"matrix".equals(strategyEntry.getKey().getValue()) || !(strategyEntry.getValue() instanceof Yaml.Mapping)) continue;
                Yaml.Mapping matrixMapping = (Yaml.Mapping)strategyEntry.getValue();
                return this.containsSelfHostedInMatrixValues(matrixMapping);
            }
            return false;
        }

        private boolean containsSelfHostedInMatrixValues(Yaml.Mapping matrixMapping) {
            for (Yaml.Mapping.Entry matrixEntry : matrixMapping.getEntries()) {
                if (!(matrixEntry.getValue() instanceof Yaml.Sequence)) continue;
                Yaml.Sequence sequence = (Yaml.Sequence)matrixEntry.getValue();
                for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                    String value = YamlHelper.getScalarValue(seqEntry.getBlock());
                    if (!"self-hosted".equals(value)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

