/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class AutoCancelInProgressWorkflow
extends Recipe {
    @Option(displayName="Optional access token", description="Optionally provide the key name of a repository or organization secret that contains a GitHub personal access token with permission to cancel workflows.", required=false, example="WORKFLOWS_ACCESS_TOKEN")
    private final @Nullable String accessToken;

    public String getDisplayName() {
        return "Cancel in-progress workflow when it is triggered again";
    }

    public String getDescription() {
        return "When a workflow is already running and would be triggered again, cancel the existing workflow. See [`styfle/cancel-workflow-action`](https://github.com/styfle/cancel-workflow-action) for details.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher firstStep = new JsonPathMatcher("$.jobs..steps[:1].uses");
        final JsonPathMatcher jobSteps = new JsonPathMatcher("$.jobs..steps.*");
        final String userProvidedAccessTokenTemplate = "- uses: styfle/cancel-workflow-action@0.9.1\n  with:\n    access_token: ${{ secrets." + this.accessToken + " }}";
        final String defaultAccessTokenTemplate = "- uses: styfle/cancel-workflow-action@0.9.1\n  with:\n    access_token: ${{ github.token }}";
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                block2: {
                    block3: {
                        if (!firstStep.matches(this.getCursor())) break block2;
                        if (!(entry.getValue() instanceof Yaml.Scalar)) break block3;
                        if (((Yaml.Scalar)entry.getValue()).getValue().contains("cancel-workflow-action")) break block2;
                    }
                    this.getCursor().dropParentUntil(Yaml.Sequence.class::isInstance).putMessage("ADD_STEP", (Object)true);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }

            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                Yaml.Sequence s = super.visitSequence(sequence, (Object)ctx);
                if (jobSteps.matches(this.getCursor()) && Boolean.TRUE.equals(this.getCursor().getMessage("ADD_STEP"))) {
                    Yaml.Documents documents = new YamlParser().parse(ctx, new String[]{StringUtils.isNullOrEmpty((String)AutoCancelInProgressWorkflow.this.accessToken) ? defaultAccessTokenTemplate : userProvidedAccessTokenTemplate}).map(Yaml.Documents.class::cast).findFirst().get();
                    Yaml.Sequence.Entry cancelWorkflowAction = (Yaml.Sequence.Entry)((Yaml.Sequence)((Yaml.Document)documents.getDocuments().get(0)).getBlock()).getEntries().get(0);
                    cancelWorkflowAction = (Yaml.Sequence.Entry)this.autoFormat((Yaml)cancelWorkflowAction.withPrefix("\n"), ctx, this.getCursor());
                    return s.withEntries(ListUtils.concat((Object)cancelWorkflowAction, (List)s.getEntries()));
                }
                return s;
            }
        });
    }

    @Generated
    public AutoCancelInProgressWorkflow(@Nullable String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public @Nullable String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String toString() {
        return "AutoCancelInProgressWorkflow(accessToken=" + this.getAccessToken() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoCancelInProgressWorkflow)) {
            return false;
        }
        AutoCancelInProgressWorkflow other = (AutoCancelInProgressWorkflow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoCancelInProgressWorkflow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }
}

