/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CachePoisoningRecipe
extends Recipe {
    private static final Set<String> CACHE_AWARE_ACTIONS = new HashSet<String>(Arrays.asList("actions/cache", "actions/setup-java", "actions/setup-go", "actions/setup-node", "actions/setup-python", "actions/setup-dotnet", "astral-sh/setup-uv", "Swatinem/rust-cache", "ruby/setup-ruby", "PyO3/maturin-action", "mlugg/setup-zig", "oven-sh/setup-bun", "DeterminateSystems/magic-nix-cache-action", "graalvm/setup-graalvm", "gradle/actions/setup-gradle", "docker/setup-buildx-action", "actions-rust-lang/setup-rust-toolchain", "Mozilla-Actions/sccache-action", "nix-community/cache-nix-action", "jdx/mise-action"));
    private static final Set<String> PUBLISHER_ACTIONS = new HashSet<String>(Arrays.asList("pypa/gh-action-pypi-publish", "rubygems/release-gem", "jreleaser/release-action", "goreleaser/goreleaser-action", "softprops/action-gh-release", "release-drafter/release-drafter", "googleapis/release-please-action", "docker/build-push-action", "redhat-actions/push-to-registry"));
    private static final Pattern RELEASE_BRANCH_PATTERN = Pattern.compile(".*release.*", 2);

    public String getDisplayName() {
        return "Find cache poisoning vulnerabilities";
    }

    public String getDescription() {
        return "Detects potential cache poisoning vulnerabilities in workflows that use caching and publish artifacts. When workflows use caches during artifact publishing, attackers may be able to poison the cache with malicious content that gets included in published artifacts. Based on [zizmor's cache-poisoning audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/cache_poisoning.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CachePoisoningVisitor();
    }

    @Generated
    public CachePoisoningRecipe() {
    }

    @Generated
    public String toString() {
        return "CachePoisoningRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachePoisoningRecipe)) {
            return false;
        }
        CachePoisoningRecipe other = (CachePoisoningRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CachePoisoningRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class CachePoisoningVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private boolean isPublishingWorkflow = false;
        private boolean hasPublisherAction = false;

        private CachePoisoningVisitor() {
        }

        public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
            this.isPublishingWorkflow = false;
            this.hasPublisherAction = false;
            this.analyzeWorkflow(document);
            if (this.isPublishingWorkflow || this.hasPublisherAction) {
                return super.visitDocument(document, (Object)ctx);
            }
            return document;
        }

        private void analyzeWorkflow(Yaml.Document document) {
            if (document.getBlock() instanceof Yaml.Mapping) {
                Yaml.Mapping workflowMapping = (Yaml.Mapping)document.getBlock();
                for (Yaml.Mapping.Entry entry : workflowMapping.getEntries()) {
                    if (!(entry.getKey() instanceof Yaml.Scalar)) continue;
                    String key = ((Yaml.Scalar)entry.getKey()).getValue();
                    if ("on".equals(key)) {
                        this.isPublishingWorkflow = this.isPublishingTrigger(entry.getValue());
                        continue;
                    }
                    if (!"jobs".equals(key)) continue;
                    this.hasPublisherAction = this.hasPublisherActions(entry.getValue());
                }
            }
        }

        private boolean isPublishingTrigger(Yaml.Block onValue) {
            block5: {
                block4: {
                    if (onValue instanceof Yaml.Scalar) {
                        String trigger = ((Yaml.Scalar)onValue).getValue();
                        return "release".equals(trigger);
                    }
                    if (!(onValue instanceof Yaml.Sequence)) break block4;
                    Yaml.Sequence sequence = (Yaml.Sequence)onValue;
                    for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                        String trigger;
                        if (!(seqEntry.getBlock() instanceof Yaml.Scalar) || !"release".equals(trigger = ((Yaml.Scalar)seqEntry.getBlock()).getValue())) continue;
                        return true;
                    }
                    break block5;
                }
                if (!(onValue instanceof Yaml.Mapping)) break block5;
                Yaml.Mapping mapping = (Yaml.Mapping)onValue;
                for (Yaml.Mapping.Entry triggerEntry : mapping.getEntries()) {
                    if (!(triggerEntry.getKey() instanceof Yaml.Scalar)) continue;
                    String trigger = ((Yaml.Scalar)triggerEntry.getKey()).getValue();
                    if ("release".equals(trigger)) {
                        return true;
                    }
                    if (!"push".equals(trigger) || !this.isReleasePush(triggerEntry.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isReleasePush(Yaml.Block pushConfig) {
            if (pushConfig instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)pushConfig;
                for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                    if (!(entry.getKey() instanceof Yaml.Scalar)) continue;
                    String key = ((Yaml.Scalar)entry.getKey()).getValue();
                    if ("tags".equals(key)) {
                        return true;
                    }
                    if (!"branches".equals(key)) continue;
                    return this.hasReleaseBranches(entry.getValue());
                }
            }
            return false;
        }

        private boolean hasReleaseBranches(Yaml.Block branchesValue) {
            if (branchesValue instanceof Yaml.Sequence) {
                Yaml.Sequence sequence = (Yaml.Sequence)branchesValue;
                for (Yaml.Sequence.Entry entry : sequence.getEntries()) {
                    if (!(entry.getBlock() instanceof Yaml.Scalar)) continue;
                    String branch = ((Yaml.Scalar)entry.getBlock()).getValue();
                    if (!RELEASE_BRANCH_PATTERN.matcher(branch).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasPublisherActions(Yaml.Block jobsValue) {
            if (jobsValue instanceof Yaml.Mapping) {
                Yaml.Mapping jobsMapping = (Yaml.Mapping)jobsValue;
                for (Yaml.Mapping.Entry jobEntry : jobsMapping.getEntries()) {
                    Yaml.Mapping jobMapping;
                    if (!(jobEntry.getValue() instanceof Yaml.Mapping) || !this.jobHasPublisherAction(jobMapping = (Yaml.Mapping)jobEntry.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean jobHasPublisherAction(Yaml.Mapping jobMapping) {
            for (Yaml.Mapping.Entry entry : jobMapping.getEntries()) {
                if (!(entry.getKey() instanceof Yaml.Scalar) || !"steps".equals(((Yaml.Scalar)entry.getKey()).getValue()) || !(entry.getValue() instanceof Yaml.Sequence)) continue;
                Yaml.Sequence stepsSequence = (Yaml.Sequence)entry.getValue();
                for (Yaml.Sequence.Entry stepEntry : stepsSequence.getEntries()) {
                    Yaml.Mapping stepMapping;
                    if (!(stepEntry.getBlock() instanceof Yaml.Mapping) || !this.stepUsesPublisherAction(stepMapping = (Yaml.Mapping)stepEntry.getBlock())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean stepUsesPublisherAction(Yaml.Mapping stepMapping) {
            for (Yaml.Mapping.Entry entry : stepMapping.getEntries()) {
                if (!(entry.getKey() instanceof Yaml.Scalar) || !"uses".equals(((Yaml.Scalar)entry.getKey()).getValue()) || !(entry.getValue() instanceof Yaml.Scalar)) continue;
                String uses = ((Yaml.Scalar)entry.getValue()).getValue();
                String actionName = this.extractActionName(uses);
                return PUBLISHER_ACTIONS.contains(actionName);
            }
            return false;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isCacheAwareActionStep(mappingEntry)) {
                String actionName = this.getActionName(mappingEntry);
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)String.format("Action '%s' uses caching in a workflow that publishes artifacts. This could lead to cache poisoning where malicious content gets cached and included in published artifacts. Consider disabling caching for this step or using read-only cache mode.", actionName));
            }
            return mappingEntry;
        }

        private boolean isCacheAwareActionStep(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar) || !"uses".equals(((Yaml.Scalar)entry.getKey()).getValue())) {
                return false;
            }
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String uses = ((Yaml.Scalar)entry.getValue()).getValue();
            String actionName = this.extractActionName(uses);
            return CACHE_AWARE_ACTIONS.contains(actionName);
        }

        private String getActionName(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                return this.extractActionName(((Yaml.Scalar)entry.getValue()).getValue());
            }
            return "unknown";
        }

        private String extractActionName(String uses) {
            if (uses.contains("@")) {
                uses = uses.substring(0, uses.indexOf("@"));
            }
            return uses;
        }
    }
}

