/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.VisibleForTesting;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public class AddCronTrigger
extends Recipe {
    @Option(displayName="Cron expression", description="Using the [POSIX cron syntax](https://pubs.opengroup.org/onlinepubs/9699919799/utilities/crontab.html#tag_20_25_07) or the non standard options @hourly @daily @weekly @weekdays @weekends @monthly @yearly.", example="@daily")
    private final String cron;
    @VisibleForTesting
    final transient Random random;

    @VisibleForTesting
    AddCronTrigger(String cron, Random random) {
        this.random = random;
        this.cron = this.parseExpression(cron);
        this.doNext((Recipe)new MergeYaml("$.on", String.format("schedule:%n  - cron: \"%s\"", this.cron), Boolean.valueOf(true), ".github/workflows/*.yml", null));
    }

    public AddCronTrigger(String cron) {
        this(cron, ThreadLocalRandom.current());
    }

    private String parseExpression(String cron) {
        RandomCronExpression randomCronExpression = new RandomCronExpression(this.random);
        switch (cron) {
            case "@hourly": {
                return randomCronExpression.hourlyCron();
            }
            case "@daily": {
                return randomCronExpression.dailyCron();
            }
            case "@weekly": {
                return randomCronExpression.weeklyCron();
            }
            case "@weekdays": {
                return randomCronExpression.weekdays();
            }
            case "@weekends": {
                return randomCronExpression.weekends();
            }
            case "@monthly": {
                return randomCronExpression.monthlyCron();
            }
            case "@yearly": {
                return randomCronExpression.yearlyCron();
            }
        }
        return cron;
    }

    public String getDisplayName() {
        return "Add cron workflow trigger";
    }

    public String getDescription() {
        return "The `schedule` [event](https://docs.github.com/en/actions/reference/events-that-trigger-workflows#scheduled-events) allows you to trigger a workflow at a scheduled time.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCronTrigger)) {
            return false;
        }
        AddCronTrigger other = (AddCronTrigger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        return !(this$cron == null ? other$cron != null : !this$cron.equals(other$cron));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddCronTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        return result;
    }

    public String getCron() {
        return this.cron;
    }

    public Random getRandom() {
        return this.random;
    }

    static class RandomCronExpression {
        private final Random random;

        public RandomCronExpression(Random random) {
            this.random = random;
        }

        public int random(int min, int max) {
            return this.random.nextInt(max + 1 - min) + min;
        }

        public int minute() {
            return this.random(0, 59);
        }

        public int hour() {
            return this.random(0, 23);
        }

        public String dayOfWeek() {
            List<String> daysOfWeek = Arrays.asList("mon", "tue", "wed", "thu", "fri", "sat", "sun");
            return daysOfWeek.get(this.random.nextInt(daysOfWeek.size()));
        }

        public String dailyCron() {
            return String.format("%d %d * * *", this.minute(), this.hour());
        }

        public String weeklyCron() {
            return String.format("%d %d * * %s", this.minute(), this.hour(), this.dayOfWeek());
        }

        public String weekdays() {
            return String.format("%d %d * * 1-5", this.minute(), this.hour());
        }

        public String weekends() {
            return String.format("%d %d * * sat,sun", this.minute(), this.hour());
        }

        public String monthlyCron() {
            return String.format("%d %d %d * *", this.minute(), this.hour(), this.dayOfTheMonth());
        }

        public int dayOfTheMonth() {
            return this.random(1, 28);
        }

        public String month() {
            List<String> months = Arrays.asList("jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec");
            return months.get(this.random.nextInt(months.size()));
        }

        public String hourlyCron() {
            return String.format("* %s * * *", this.hour());
        }

        public String yearlyCron() {
            return String.format("%d %d %d %s *", this.minute(), this.hour(), this.dayOfTheMonth(), this.month());
        }
    }
}

