/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class ActionsSetupJavaAdoptOpenJDKToTemurin
extends Recipe {
    public String getDisplayName() {
        return "Use `actions/setup-java` `temurin` distribution";
    }

    public String getDescription() {
        return "Adopt OpenJDK got moved to Eclipse Temurin and won't be updated anymore. It is highly recommended to migrate workflows from adopt to temurin to keep receiving software and security updates. See more details in the [Good-bye AdoptOpenJDK post](https://blog.adoptopenjdk.net/2021/08/goodbye-adoptopenjdk-hello-adoptium/).";
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath(".github/workflows/*.yml");
    }

    protected YamlVisitor<ExecutionContext> getVisitor() {
        return new ActionsSetupJavaAdoptOpenJDKToTemurinVisitor();
    }

    private static class ActionsSetupJavaAdoptOpenJDKToTemurinVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private static final JsonPathMatcher distribution = new JsonPathMatcher(".distribution");

        private ActionsSetupJavaAdoptOpenJDKToTemurinVisitor() {
        }

        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
            if (mapping.getEntries().stream().anyMatch(e -> e.getValue() instanceof Yaml.Scalar && ((Yaml.Scalar)e.getValue()).getValue().contains("actions/setup-java@v2"))) {
                this.getCursor().putMessage("USES_ACTIONS_SETUP_JAVA", (Object)true);
            }
            return super.visitMapping(mapping, (Object)ctx);
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
            if (Boolean.TRUE.equals(this.getCursor().getNearestMessage("USES_ACTIONS_SETUP_JAVA")) && distribution.matches(this.getCursor()) && ((Yaml.Scalar)e.getValue()).getValue().contains("adopt")) {
                return super.visitMappingEntry(e.withValue((Yaml.Block)((Yaml.Scalar)e.getValue()).withValue("temurin")), (Object)ctx);
            }
            return e;
        }
    }
}

