export class Json {
    format(lintResults, showDetails) {
        const jsonFormattedResults = [];
        lintResults.forEach((oLintedFile) => {
            let aFileMessages = oLintedFile.messages;
            // Ignore files without findings (empty messages)
            if (aFileMessages && aFileMessages.length > 0) {
                // Exclude messageDetails property if CLI option "details" was not provided
                if (!showDetails) {
                    aFileMessages = aFileMessages.map((message) => {
                        const { messageDetails: _, ...oModifiedMessage } = message;
                        return oModifiedMessage;
                    });
                }
                jsonFormattedResults.push({
                    filePath: oLintedFile.filePath,
                    messages: aFileMessages,
                    errorCount: oLintedFile.errorCount,
                    warningCount: oLintedFile.warningCount,
                    fatalErrorCount: oLintedFile.fatalErrorCount,
                });
            }
        });
        return JSON.stringify(jsonFormattedResults);
    }
}
//# sourceMappingURL=json.js.map