"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPluginName = exports.buildOptions = exports.isParserPluginName = void 0;
const DefaultParserPlugins = new Set([
    'asyncGenerators',
    'bigInt',
    'classPrivateMethods',
    'classPrivateProperties',
    'classProperties',
    'doExpressions',
    'dynamicImport',
    'exportDefaultFrom',
    'exportNamespaceFrom',
    'functionBind',
    'functionSent',
    'importAssertions',
    'importMeta',
    'jsx',
    'logicalAssignment',
    'nullishCoalescingOperator',
    'numericSeparator',
    'objectRestSpread',
    'optionalCatchBinding',
    'optionalChaining',
    'partialApplication',
    'throwExpressions',
    'topLevelAwait',
    ['decorators', { decoratorsBeforeExport: true }],
    'decorators-legacy',
    ['pipelineOperator', { proposal: 'minimal' }],
    ['recordAndTuple', { syntaxType: 'hash' }],
]);
function isParserPluginName(name) {
    for (const plugin of DefaultParserPlugins) {
        if (name === getPluginName(plugin)) {
            return true;
        }
    }
    return false;
}
exports.isParserPluginName = isParserPluginName;
/**
 * Builds options for `@babel/parser` by enabling as many features as possible,
 * while also preserving the options given as an argument.
 */
function buildOptions(_a = {}) {
    var { sourceType = 'unambiguous', allowAwaitOutsideFunction = true, allowImportExportEverywhere = true, allowReturnOutsideFunction = true, allowSuperOutsideMethod = true, allowUndeclaredExports = true, plugins = [], sourceFilename } = _a, rest = __rest(_a, ["sourceType", "allowAwaitOutsideFunction", "allowImportExportEverywhere", "allowReturnOutsideFunction", "allowSuperOutsideMethod", "allowUndeclaredExports", "plugins", "sourceFilename"]);
    for (const plugin of DefaultParserPlugins) {
        if (shouldAddPlugin(plugins, plugin)) {
            plugins = [...plugins, plugin];
        }
    }
    const typePlugin = typePluginForSourceFileName(sourceFilename);
    if (shouldAddPlugin(plugins, typePlugin)) {
        plugins = [...plugins, typePlugin];
    }
    return Object.assign({ sourceType,
        allowAwaitOutsideFunction,
        allowImportExportEverywhere,
        allowReturnOutsideFunction,
        allowSuperOutsideMethod,
        allowUndeclaredExports,
        plugins,
        sourceFilename }, rest);
}
exports.buildOptions = buildOptions;
/**
 * Gets the type plugin to use for a given file name.
 *
 * @example
 *
 *   typePluginForSourceFileName('index.ts');  // 'typescript'
 *   typePluginForSourceFileName('index.jsx'); // 'flow'
 */
function typePluginForSourceFileName(sourceFileName) {
    if (typeof sourceFileName === 'string' && !/\.tsx?$/i.test(sourceFileName)) {
        return 'flow';
    }
    else {
        return 'typescript';
    }
}
function getPluginOptions(plugins, name) {
    for (const plugin of plugins) {
        if (Array.isArray(plugin)) {
            if (plugin[0] === name) {
                return plugin[1];
            }
        }
        else if (plugin === name) {
            return {};
        }
    }
}
/**
 * Determines whether a plugin list can accept a new plugin by name.
 *
 * @example
 *
 *   shouldAddPlugin([], 'jsx');                // true; existing list does not have "jsx"
 *   shouldAddPlugin(['jsx', 'bigInt'], 'jsx'); // false; existing list already has "jsx"
 *   shouldAddPlugin(['flow'], 'typescript');   // false; "typescript" is incompatible with "flow"
 */
function shouldAddPlugin(plugins, plugin) {
    const name = getPluginName(plugin);
    if (pluginListIncludesPlugin(plugins, name)) {
        return false;
    }
    switch (name) {
        case 'flow':
        case 'flowComments':
            return !getPluginOptions(plugins, 'typescript');
        case 'typescript':
            return !(getPluginOptions(plugins, 'flow') ||
                getPluginOptions(plugins, 'flowComments'));
        case 'decorators':
            return !getPluginOptions(plugins, 'decorators-legacy');
        case 'decorators-legacy':
            return !getPluginOptions(plugins, 'decorators');
        case 'recordAndTuple':
        case 'pipelineOperator': {
            const recordAndTupleOptions = name === 'recordAndTuple'
                ? plugin[1]
                : getPluginOptions(plugins, 'recordAndTuple');
            const pipelineOperatorOptions = name === 'pipelineOperator'
                ? plugin[1]
                : getPluginOptions(plugins, 'pipelineOperator');
            if ((recordAndTupleOptions === null || recordAndTupleOptions === void 0 ? void 0 : recordAndTupleOptions.syntaxType) === 'hash') {
                // https://github.com/babel/babel/blob/15f2f171ab13b224757ca43483a456e409f12a0a/packages/babel-parser/src/plugin-utils.js#L124-L128
                if ((pipelineOperatorOptions === null || pipelineOperatorOptions === void 0 ? void 0 : pipelineOperatorOptions.proposal) === 'smart') {
                    return false;
                }
                // https://github.com/babel/babel/blob/15f2f171ab13b224757ca43483a456e409f12a0a/packages/babel-parser/src/plugin-utils.js#L119-L123
                if ((pipelineOperatorOptions === null || pipelineOperatorOptions === void 0 ? void 0 : pipelineOperatorOptions.proposal) === 'hack' &&
                    pipelineOperatorOptions.topicToken === '#') {
                    return false;
                }
            }
            return true;
        }
        default:
            return true;
    }
}
/**
 * Checks `plugins` for an entry named `name`.
 *
 * @example
 *
 *   pluginListIncludesPlugin(['jsx', 'bigInt'], 'bigInt');              // true; list includes "bigInt" without options
 *   pluginListIncludesPlugin(['jsx', 'bigInt'], 'flow');                // false; list does not include "flow"
 *   pluginListIncludesPlugin(['jsx', ['flow', { all: true }]], 'flow'); // true; list includes "flow" with options
 */
function pluginListIncludesPlugin(plugins, name) {
    return plugins.some((entry) => getPluginName(entry) === name);
}
/**
 * Gets the name of `plugin`.
 *
 * @example
 *
 *   getPluginName('decorators');            // 'decorators'
 *   getPluginName(['flow', { all: true }]); // 'flow'
 */
function getPluginName(plugin) {
    return typeof plugin === 'string' ? plugin : plugin[0];
}
exports.getPluginName = getPluginName;
//# sourceMappingURL=options.js.map