"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.capture = exports.CapturedMatcher = void 0;
const anything_1 = require("./anything");
const Matcher_1 = require("./Matcher");
class CapturedMatcher extends Matcher_1.Matcher {
    constructor(matcher = (0, anything_1.anything)()) {
        super();
        this.matcher = matcher;
    }
    get current() {
        return this._current;
    }
    get currentKeys() {
        return this._currentKeys;
    }
    matchValue(value, keys) {
        if (this.matcher.matchValue(value, keys)) {
            this.capture(value, keys);
            return true;
        }
        else {
            return false;
        }
    }
    capture(value, keys) {
        this._current = value;
        this._currentKeys = keys;
    }
}
exports.CapturedMatcher = CapturedMatcher;
function capture(matcher) {
    return new CapturedMatcher(matcher);
}
exports.capture = capture;
//# sourceMappingURL=capture.js.map