"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arrayOf = exports.ArrayOfMatcher = void 0;
const Matcher_1 = require("./Matcher");
class ArrayOfMatcher extends Matcher_1.Matcher {
    constructor(elementMatcher) {
        super();
        this.elementMatcher = elementMatcher;
    }
    matchValue(value, keys) {
        if (!Array.isArray(value)) {
            return false;
        }
        for (const [i, element] of value.entries()) {
            if (!this.elementMatcher.matchValue(element, [...keys, i])) {
                return false;
            }
        }
        return true;
    }
}
exports.ArrayOfMatcher = ArrayOfMatcher;
function arrayOf(elementMatcher) {
    return new ArrayOfMatcher(elementMatcher);
}
exports.arrayOf = arrayOf;
//# sourceMappingURL=arrayOf.js.map