import Transformer from './Transformer';
export declare class Source {
    readonly path: string;
    readonly content: string;
    constructor(path: string, content: string);
}
export declare enum SourceTransformResultKind {
    Transformed = "Transformed",
    Error = "Error"
}
export declare type SourceTransformResult = {
    kind: SourceTransformResultKind.Transformed;
    source: Source;
    output: string;
} | {
    kind: SourceTransformResultKind.Error;
    source: Source;
    error: Error;
};
export declare class TransformRunner {
    readonly sources: AsyncGenerator<Source>;
    readonly transformer: Transformer;
    constructor(sources: AsyncGenerator<Source>, transformer: Transformer);
    run(): AsyncIterableIterator<SourceTransformResult>;
}
