// For Library Version: 1.120.25

declare module "sap/me/library" {
  /**
   * Type of Design for the Calendar
   *
   * @deprecated (since 1.34)
   * @experimental (since 1.12) - API is not yet finished and might change completely
   */
  export enum CalendarDesign {
    /**
     * Colors match calendar design for Action
     */
    Action = "Action",
    /**
     * Colors match calendar design for Approval
     */
    Approval = "Approval",
  }
  /**
   * Type code for a calendar event
   *
   * @deprecated (since 1.34)
   * @experimental (since 1.12) - API is not yet finished and might change completely
   */
  export enum CalendarEventType {
    /**
     * Type 00 (non-working day (e.g. weekend))
     */
    Type00 = "Type00",
    /**
     * Type 01 (nonattendance / submitted day)
     */
    Type01 = "Type01",
    /**
     * Type 04 (open request / manager action needed)
     */
    Type04 = "Type04",
    /**
     * Type 06 (public holiday)
     */
    Type06 = "Type06",
    /**
     * Type 07 (deletion requested / your action needed)
     */
    Type07 = "Type07",
    /**
     * Type 10 (workday)
     */
    Type10 = "Type10",
  }
  /**
   * Selection Mode for the Calendar
   *
   * @deprecated (since 1.34)
   * @experimental (since 1.12) - API is not yet finished and might change completely
   */
  export enum CalendarSelectionMode {
    /**
     * Can select multiple dates and ranges
     */
    MULTIPLE = "MULTIPLE",
    /**
     * Can select a range of dates
     */
    RANGE = "RANGE",
    /**
     * Can only select one date
     */
    SINGLE = "SINGLE",
  }
}

declare module "sap/me/Calendar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    CalendarDesign,
    CalendarSelectionMode,
    CalendarEventType,
  } from "sap/me/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * This is the Calendar control
   *
   * @deprecated (since 1.26.0) - This control was experimental since 1.12. Please use the sap.ui.unified.Calendar
   * instead!
   */
  export default class Calendar extends Control {
    /**
     * Constructor for a new Calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );
    /**
     * Constructor for a new Calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );

    /**
     * Creates a new subclass of class sap.me.Calendar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Calendar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.Calendar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Helper function to instantiate a Date from the string(s) provided by the getCurrentDate, getSelectedDates
     * methods. IMPORTANT: The only valid values for the created Date are: year, month, day. Disregard
     * any other value: hours, minutes, seconds, milliseconds...
     *
     *
     * @returns The Date, parsed from the input string.
     */
    static parseDate(
      /**
       * The date, produced by a former call to Date.toDateString.
       */
      strDate: string
    ): Date;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeCurrentDate changeCurrentDate} event of
     * this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * event fired when tap to next or previous button and currentDate is updated
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeCurrentDate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeCurrentDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeCurrentDate changeCurrentDate} event of
     * this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * event fired when tap to next or previous button and currentDate is updated
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeCurrentDate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeCurrentDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeRange changeRange} event of this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * when the range of selected dates changes
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeRange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeRangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeRange changeRange} event of this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * when the range of selected dates changes
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeRange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeRangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tapOnDate tapOnDate} event of this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * event fired when a date is tapped
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTapOnDate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$TapOnDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tapOnDate tapOnDate} event of this `sap.me.Calendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.Calendar` itself.
     *
     * event fired when a date is tapped
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTapOnDate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Calendar$TapOnDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.Calendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changeCurrentDate changeCurrentDate} event
     * of this `sap.me.Calendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChangeCurrentDate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeCurrentDateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changeRange changeRange} event of this `sap.me.Calendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChangeRange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Calendar$ChangeRangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tapOnDate tapOnDate} event of this `sap.me.Calendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTapOnDate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Calendar$TapOnDateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:changeCurrentDate changeCurrentDate} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChangeCurrentDate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Calendar$ChangeCurrentDateEventParameters
    ): this;
    /**
     * Fires event {@link #event:changeRange changeRange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChangeRange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Calendar$ChangeRangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:tapOnDate tapOnDate} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTapOnDate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Calendar$TapOnDateEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getCurrentDate currentDate}.
     *
     * the center date where the month/week will be built around
     *
     *
     * @returns Value of property `currentDate`
     */
    getCurrentDate(): string;
    /**
     * Gets current value of property {@link #getDayHeight dayHeight}.
     *
     * the height of a day
     *
     * Default value is `50`.
     *
     *
     * @returns Value of property `dayHeight`
     */
    getDayHeight(): int;
    /**
     * Gets current value of property {@link #getDays days}.
     *
     * Array of day names, default value is sap.m.getLocaleData().getDays("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     *
     *
     * @returns Value of property `days`
     */
    getDays(): any;
    /**
     * Gets current value of property {@link #getDayWidth dayWidth}.
     *
     * the width of a day
     *
     * Default value is `45`.
     *
     *
     * @returns Value of property `dayWidth`
     */
    getDayWidth(): int;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Indicates the design of the calendar (mainly colors)
     *
     * Default value is `Approval`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): CalendarDesign | keyof typeof CalendarDesign;
    /**
     * Gets current value of property {@link #getDisabledDates disabledDates}.
     *
     * Array of specific dates (strings or Date objects) that will be disabled/non interactive
     *
     *
     * @returns Value of property `disabledDates`
     */
    getDisabledDates(): any;
    /**
     * Gets current value of property {@link #getDisabledWeekDays disabledWeekDays}.
     *
     * Array of weekDays (as integers where 0=Sunday, 1=Monday etc) to be disabled. Interaction will be disabled
     * for these week days.
     *
     *
     * @returns Value of property `disabledWeekDays`
     */
    getDisabledWeekDays(): any;
    /**
     * Gets current value of property {@link #getEnableMultiselection enableMultiselection}.
     *
     * to enable multiselection feature
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableMultiselection`
     */
    getEnableMultiselection(): boolean;
    /**
     * Gets current value of property {@link #getFirstDayOffset firstDayOffset}.
     *
     * to offset the first day of the week (0 = sunday)
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `firstDayOffset`
     */
    getFirstDayOffset(): int;
    /**
     * Gets current value of property {@link #getHideMonthTitles hideMonthTitles}.
     *
     * hides the area of month titles
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideMonthTitles`
     */
    getHideMonthTitles(): boolean;
    /**
     * Gets current value of property {@link #getHideNavControls hideNavControls}.
     *
     * hides the area of navigation controls
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `hideNavControls`
     */
    getHideNavControls(): boolean;
    /**
     * Gets current value of property {@link #getMonths months}.
     *
     * Array of month names, default value is sap.m.getLocaleData().getMonths("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     *
     *
     * @returns Value of property `months`
     */
    getMonths(): any;
    /**
     * Gets current value of property {@link #getMonthsPerRow monthsPerRow}.
     *
     * months to display in a row. This sets the width of the whole control in order to contain the desired
     * number of months per row
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `monthsPerRow`
     */
    getMonthsPerRow(): int;
    /**
     * Gets current value of property {@link #getMonthsToDisplay monthsToDisplay}.
     *
     * number of months in a row.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `monthsToDisplay`
     */
    getMonthsToDisplay(): int;
    /**
     * returns an array of the currently selected dates (dates are strings formatted as Date.toDateString())
     */
    getSelectedDates(): any;
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Indicates the design of the calendar (mainly colors)
     *
     * Default value is `SINGLE`.
     *
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode():
      | CalendarSelectionMode
      | keyof typeof CalendarSelectionMode;
    /**
     * Gets current value of property {@link #getSingleRow singleRow}.
     *
     * boolean that sets the view to week mode or month mode
     *
     *
     * @returns Value of property `singleRow`
     */
    getSingleRow(): boolean;
    /**
     * Gets current value of property {@link #getSwipeToNavigate swipeToNavigate}.
     *
     * When enabled, swipe gestures will navigate and not select
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `swipeToNavigate`
     */
    getSwipeToNavigate(): boolean;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * visibility of the control
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWeeksPerRow weeksPerRow}.
     *
     * weeks to display in a row
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `weeksPerRow`
     */
    getWeeksPerRow(): int;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the calendar
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets the current date of the calendar.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setCurrentDate(
      /**
       * The Date to set, the format being identical to a date string produced by "toDateString".
       */
      strDate: string
    ): this;
    /**
     * Sets a new value for property {@link #getDayHeight dayHeight}.
     *
     * the height of a day
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `50`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDayHeight(
      /**
       * New value for property `dayHeight`
       */
      iDayHeight?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDays days}.
     *
     * Array of day names, default value is sap.m.getLocaleData().getDays("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDays(
      /**
       * New value for property `days`
       */
      oDays?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDayWidth dayWidth}.
     *
     * the width of a day
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `45`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDayWidth(
      /**
       * New value for property `dayWidth`
       */
      iDayWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Indicates the design of the calendar (mainly colors)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Approval`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: CalendarDesign | keyof typeof CalendarDesign
    ): this;
    /**
     * Sets a new value for property {@link #getDisabledDates disabledDates}.
     *
     * Array of specific dates (strings or Date objects) that will be disabled/non interactive
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisabledDates(
      /**
       * New value for property `disabledDates`
       */
      oDisabledDates?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDisabledWeekDays disabledWeekDays}.
     *
     * Array of weekDays (as integers where 0=Sunday, 1=Monday etc) to be disabled. Interaction will be disabled
     * for these week days.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisabledWeekDays(
      /**
       * New value for property `disabledWeekDays`
       */
      oDisabledWeekDays?: any
    ): this;
    /**
     * Sets a new value for property {@link #getEnableMultiselection enableMultiselection}.
     *
     * to enable multiselection feature
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableMultiselection(
      /**
       * New value for property `enableMultiselection`
       */
      bEnableMultiselection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDayOffset firstDayOffset}.
     *
     * to offset the first day of the week (0 = sunday)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDayOffset(
      /**
       * New value for property `firstDayOffset`
       */
      iFirstDayOffset?: int
    ): this;
    /**
     * Sets a new value for property {@link #getHideMonthTitles hideMonthTitles}.
     *
     * hides the area of month titles
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideMonthTitles(
      /**
       * New value for property `hideMonthTitles`
       */
      bHideMonthTitles?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHideNavControls hideNavControls}.
     *
     * hides the area of navigation controls
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideNavControls(
      /**
       * New value for property `hideNavControls`
       */
      bHideNavControls?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMonths months}.
     *
     * Array of month names, default value is sap.m.getLocaleData().getMonths("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMonths(
      /**
       * New value for property `months`
       */
      oMonths?: any
    ): this;
    /**
     * Sets a new value for property {@link #getMonthsPerRow monthsPerRow}.
     *
     * months to display in a row. This sets the width of the whole control in order to contain the desired
     * number of months per row
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMonthsPerRow(
      /**
       * New value for property `monthsPerRow`
       */
      iMonthsPerRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getMonthsToDisplay monthsToDisplay}.
     *
     * number of months in a row.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMonthsToDisplay(
      /**
       * New value for property `monthsToDisplay`
       */
      iMonthsToDisplay?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionMode selectionMode}.
     *
     * Indicates the design of the calendar (mainly colors)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `SINGLE`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionMode(
      /**
       * New value for property `selectionMode`
       */
      sSelectionMode?:
        | CalendarSelectionMode
        | keyof typeof CalendarSelectionMode
    ): this;
    /**
     * Sets a new value for property {@link #getSingleRow singleRow}.
     *
     * boolean that sets the view to week mode or month mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSingleRow(
      /**
       * New value for property `singleRow`
       */
      bSingleRow?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSwipeToNavigate swipeToNavigate}.
     *
     * When enabled, swipe gestures will navigate and not select
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSwipeToNavigate(
      /**
       * New value for property `swipeToNavigate`
       */
      bSwipeToNavigate?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * visibility of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWeeksPerRow weeksPerRow}.
     *
     * weeks to display in a row
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWeeksPerRow(
      /**
       * New value for property `weeksPerRow`
       */
      iWeeksPerRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the calendar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * it toggles the selection of the dates within the passed range to selected/unselected
     */
    toggleDatesRangeSelection(
      /**
       * starting date of the range. It can be Strings or Date objects.
       */
      oDateStart: any,
      /**
       * ending date of the range. It can be Strings or Date objects.
       */
      oDateEnd: any,
      /**
       * selected/unselected. Optional, if omitted it inverts each date's current state
       */
      bSelected: boolean
    ): void;
    /**
     * it toggles the passed dates to selected/unselected
     */
    toggleDatesSelection(
      /**
       * Array of the dates to be toggled. they can be Strings or Date objects.
       */
      aDates: any,
      /**
       * select/unselect. Optional, if omitted it inverts each date's current state
       */
      bSelected: boolean
    ): void;
    /**
     * Change the type of the given dates
     */
    toggleDatesType(
      /**
       * An array of dates in string representation
       */
      aDates: any,
      /**
       * The type of event
       */
      sType: CalendarEventType | keyof typeof CalendarEventType,
      /**
       * Add/remove the type, if ommited it will toggle
       */
      bSelected: boolean
    ): void;
    /**
     * unselect all the dates
     */
    unselectAllDates(): void;
  }
  /**
   * Describes the settings that can be provided to the Calendar constructor.
   *
   * @deprecated (since 1.26.0) - This control was experimental since 1.12. Please use the sap.ui.unified.Calendar
   * instead!
   */
  export interface $CalendarSettings extends $ControlSettings {
    /**
     * visibility of the control
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * hides the area of navigation controls
     */
    hideNavControls?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * hides the area of month titles
     */
    hideMonthTitles?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * months to display in a row. This sets the width of the whole control in order to contain the desired
     * number of months per row
     */
    monthsPerRow?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the width of a day
     */
    dayWidth?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the height of a day
     */
    dayHeight?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * weeks to display in a row
     */
    weeksPerRow?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * boolean that sets the view to week mode or month mode
     */
    singleRow?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * number of months in a row.
     */
    monthsToDisplay?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * the center date where the month/week will be built around
     */
    currentDate?: string | PropertyBindingInfo;

    /**
     * to enable multiselection feature
     */
    enableMultiselection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * to offset the first day of the week (0 = sunday)
     */
    firstDayOffset?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of weekDays (as integers where 0=Sunday, 1=Monday etc) to be disabled. Interaction will be disabled
     * for these week days.
     */
    disabledWeekDays?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of specific dates (strings or Date objects) that will be disabled/non interactive
     */
    disabledDates?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * When enabled, swipe gestures will navigate and not select
     */
    swipeToNavigate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates the design of the calendar (mainly colors)
     */
    design?:
      | (CalendarDesign | keyof typeof CalendarDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Indicates the design of the calendar (mainly colors)
     */
    selectionMode?:
      | (CalendarSelectionMode | keyof typeof CalendarSelectionMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The width of the calendar
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of day names, default value is sap.m.getLocaleData().getDays("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     */
    days?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of month names, default value is sap.m.getLocaleData().getMonths("abbreviated") Check sap.ui.core.LocaleData
     * documentation for more info.
     */
    months?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * event fired when a date is tapped
     */
    tapOnDate?: (oEvent: Calendar$TapOnDateEvent) => void;

    /**
     * event fired when tap to next or previous button and currentDate is updated
     */
    changeCurrentDate?: (oEvent: Calendar$ChangeCurrentDateEvent) => void;

    /**
     * when the range of selected dates changes
     */
    changeRange?: (oEvent: Calendar$ChangeRangeEvent) => void;
  }

  /**
   * Parameters of the Calendar#changeCurrentDate event.
   */
  export interface Calendar$ChangeCurrentDateEventParameters {
    /**
     * new date
     */
    currentDate?: string;
  }

  /**
   * Event object of the Calendar#changeCurrentDate event.
   */
  export type Calendar$ChangeCurrentDateEvent = Event<
    Calendar$ChangeCurrentDateEventParameters,
    Calendar
  >;

  /**
   * Parameters of the Calendar#changeRange event.
   */
  export interface Calendar$ChangeRangeEventParameters {
    /**
     * from date
     */
    fromDate?: string;

    /**
     * to date
     */
    toDate?: string;
  }

  /**
   * Event object of the Calendar#changeRange event.
   */
  export type Calendar$ChangeRangeEvent = Event<
    Calendar$ChangeRangeEventParameters,
    Calendar
  >;

  /**
   * Parameters of the Calendar#tapOnDate event.
   */
  export interface Calendar$TapOnDateEventParameters {
    /**
     * date tapped
     */
    date?: string;

    /**
     * if day was selected
     */
    didSelect?: boolean;
  }

  /**
   * Event object of the Calendar#tapOnDate event.
   */
  export type Calendar$TapOnDateEvent = Event<
    Calendar$TapOnDateEventParameters,
    Calendar
  >;
}

declare module "sap/me/CalendarLegend" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CalendarDesign } from "sap/me/library";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Legend for the calendar control
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.ui.unified.CalendarLegend
   * instead!
   */
  export default class CalendarLegend extends Control {
    /**
     * Constructor for a new CalendarLegend.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CalendarLegendSettings
    );
    /**
     * Constructor for a new CalendarLegend.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CalendarLegendSettings
    );

    /**
     * Creates a new subclass of class sap.me.CalendarLegend with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CalendarLegend>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.CalendarLegend.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * design name for the legend
     *
     * Default value is `Approval`.
     *
     *
     * @returns Value of property `design`
     */
    getDesign(): CalendarDesign | keyof typeof CalendarDesign;
    /**
     * Gets current value of property {@link #getExpandable expandable}.
     *
     * Indicates if the legend can be collapsed and expanded
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandable`
     */
    getExpandable(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Indicates if the legend is expanded or not
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getLegendForNormal legendForNormal}.
     *
     * legend for normal
     *
     *
     * @returns Value of property `legendForNormal`
     */
    getLegendForNormal(): string;
    /**
     * Gets current value of property {@link #getLegendForSelected legendForSelected}.
     *
     * legend for selected
     *
     *
     * @returns Value of property `legendForSelected`
     */
    getLegendForSelected(): string;
    /**
     * Gets current value of property {@link #getLegendForSelected00 legendForSelected00}.
     *
     * legend for selected 00
     *
     *
     * @returns Value of property `legendForSelected00`
     */
    getLegendForSelected00(): string;
    /**
     * Gets current value of property {@link #getLegendForToday legendForToday}.
     *
     * legend for today
     *
     *
     * @returns Value of property `legendForToday`
     */
    getLegendForToday(): string;
    /**
     * Gets current value of property {@link #getLegendForType00 legendForType00}.
     *
     * legend for type 00
     *
     *
     * @returns Value of property `legendForType00`
     */
    getLegendForType00(): string;
    /**
     * Gets current value of property {@link #getLegendForType01 legendForType01}.
     *
     * legend for type 01
     *
     *
     * @returns Value of property `legendForType01`
     */
    getLegendForType01(): string;
    /**
     * Gets current value of property {@link #getLegendForType04 legendForType04}.
     *
     * legend for type 04
     *
     *
     * @returns Value of property `legendForType04`
     */
    getLegendForType04(): string;
    /**
     * Gets current value of property {@link #getLegendForType06 legendForType06}.
     *
     * legend for type 06
     *
     *
     * @returns Value of property `legendForType06`
     */
    getLegendForType06(): string;
    /**
     * Gets current value of property {@link #getLegendForType07 legendForType07}.
     *
     * legend for type 07
     *
     *
     * @returns Value of property `legendForType07`
     */
    getLegendForType07(): string;
    /**
     * Gets current value of property {@link #getLegendWidth legendWidth}.
     *
     * Indicates the legend items width
     *
     * Default value is `'12.5rem'`.
     *
     *
     * @returns Value of property `legendWidth`
     */
    getLegendWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Indicates if the legend is visible
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Indicates the whole component width
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * design name for the legend
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Approval`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: CalendarDesign | keyof typeof CalendarDesign
    ): this;
    /**
     * Sets a new value for property {@link #getExpandable expandable}.
     *
     * Indicates if the legend can be collapsed and expanded
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandable(
      /**
       * New value for property `expandable`
       */
      bExpandable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Indicates if the legend is expanded or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForNormal legendForNormal}.
     *
     * legend for normal
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForNormal(
      /**
       * New value for property `legendForNormal`
       */
      sLegendForNormal?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForSelected legendForSelected}.
     *
     * legend for selected
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForSelected(
      /**
       * New value for property `legendForSelected`
       */
      sLegendForSelected?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForSelected00 legendForSelected00}.
     *
     * legend for selected 00
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForSelected00(
      /**
       * New value for property `legendForSelected00`
       */
      sLegendForSelected00?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForToday legendForToday}.
     *
     * legend for today
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForToday(
      /**
       * New value for property `legendForToday`
       */
      sLegendForToday?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForType00 legendForType00}.
     *
     * legend for type 00
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForType00(
      /**
       * New value for property `legendForType00`
       */
      sLegendForType00?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForType01 legendForType01}.
     *
     * legend for type 01
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForType01(
      /**
       * New value for property `legendForType01`
       */
      sLegendForType01?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForType04 legendForType04}.
     *
     * legend for type 04
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForType04(
      /**
       * New value for property `legendForType04`
       */
      sLegendForType04?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForType06 legendForType06}.
     *
     * legend for type 06
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForType06(
      /**
       * New value for property `legendForType06`
       */
      sLegendForType06?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendForType07 legendForType07}.
     *
     * legend for type 07
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendForType07(
      /**
       * New value for property `legendForType07`
       */
      sLegendForType07?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLegendWidth legendWidth}.
     *
     * Indicates the legend items width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'12.5rem'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendWidth(
      /**
       * New value for property `legendWidth`
       */
      sLegendWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Indicates if the legend is visible
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Indicates the whole component width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CalendarLegend constructor.
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.ui.unified.CalendarLegend
   * instead!
   */
  export interface $CalendarLegendSettings extends $ControlSettings {
    /**
     * legend for type 00
     */
    legendForType00?: string | PropertyBindingInfo;

    /**
     * legend for type 01
     */
    legendForType01?: string | PropertyBindingInfo;

    /**
     * legend for type 04
     */
    legendForType04?: string | PropertyBindingInfo;

    /**
     * legend for type 06
     */
    legendForType06?: string | PropertyBindingInfo;

    /**
     * legend for type 07
     */
    legendForType07?: string | PropertyBindingInfo;

    /**
     * legend for today
     */
    legendForToday?: string | PropertyBindingInfo;

    /**
     * legend for selected
     */
    legendForSelected?: string | PropertyBindingInfo;

    /**
     * legend for selected 00
     */
    legendForSelected00?: string | PropertyBindingInfo;

    /**
     * legend for normal
     */
    legendForNormal?: string | PropertyBindingInfo;

    /**
     * Indicates if the legend can be collapsed and expanded
     */
    expandable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the legend is expanded or not
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates the whole component width
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates the legend items width
     */
    legendWidth?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the legend is visible
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * design name for the legend
     */
    design?:
      | (CalendarDesign | keyof typeof CalendarDesign)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/me/OverlapCalendar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import OverlapCalendarEvent from "sap/me/OverlapCalendarEvent";

  import Calendar from "sap/me/Calendar";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * A calendar that allows to display events in a grid and show the overlapped events
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.m.PlanningCalendar
   * instead!
   */
  export default class OverlapCalendar extends Control {
    /**
     * Constructor for a new OverlapCalendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlapCalendarSettings
    );
    /**
     * Constructor for a new OverlapCalendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlapCalendarSettings
    );

    /**
     * Creates a new subclass of class sap.me.OverlapCalendar with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OverlapCalendar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.OverlapCalendar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some calendarEvent to the aggregation {@link #getCalendarEvents calendarEvents}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCalendarEvent(
      /**
       * The calendarEvent to add; if empty, nothing is inserted
       */
      oCalendarEvent: OverlapCalendarEvent
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeDate changeDate} event of this `sap.me.OverlapCalendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.OverlapCalendar` itself.
     *
     * Triggered when the displayed dates change
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeDate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$ChangeDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.OverlapCalendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeDate changeDate} event of this `sap.me.OverlapCalendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.OverlapCalendar` itself.
     *
     * Triggered when the displayed dates change
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeDate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$ChangeDateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.OverlapCalendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:endOfData endOfData} event of this `sap.me.OverlapCalendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.OverlapCalendar` itself.
     *
     * Indicates that we have reach the last week with data
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEndOfData(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$EndOfDataEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.OverlapCalendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:endOfData endOfData} event of this `sap.me.OverlapCalendar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.OverlapCalendar` itself.
     *
     * Indicates that we have reach the last week with data
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEndOfData(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$EndOfDataEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.OverlapCalendar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the calendarEvents in the aggregation {@link #getCalendarEvents calendarEvents}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCalendarEvents(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changeDate changeDate} event of this `sap.me.OverlapCalendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChangeDate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$ChangeDateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:endOfData endOfData} event of this `sap.me.OverlapCalendar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEndOfData(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: OverlapCalendar$EndOfDataEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:changeDate changeDate} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChangeDate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlapCalendar$ChangeDateEventParameters
    ): this;
    /**
     * Fires event {@link #event:endOfData endOfData} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEndOfData(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: OverlapCalendar$EndOfDataEventParameters
    ): this;
    /**
     *
     * @returns The calendar object
     */
    getCalendar(): Calendar;
    /**
     * Gets content of aggregation {@link #getCalendarEvents calendarEvents}.
     *
     * The list of events to display in the calendar grid
     */
    getCalendarEvents(): OverlapCalendarEvent[];
    /**
     * Gets current value of property {@link #getFirstDayOffset firstDayOffset}.
     *
     * Indicate how to offset the first day in regards to a Sunday (by default)
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `firstDayOffset`
     */
    getFirstDayOffset(): int;
    /**
     * Gets current value of property {@link #getShowOverlapIndicator showOverlapIndicator}.
     *
     * Do we want to display the overlap indicator
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showOverlapIndicator`
     */
    getShowOverlapIndicator(): boolean;
    /**
     * Gets current value of property {@link #getStartDate startDate}.
     *
     * The first date to display for the calendar
     *
     *
     * @returns Value of property `startDate`
     */
    getStartDate(): string;
    /**
     * Gets current value of property {@link #getSwipeToNavigate swipeToNavigate}.
     *
     * Use swipe gesture to navigate
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `swipeToNavigate`
     */
    getSwipeToNavigate(): boolean;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Indicates if we should render this component
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWeeksPerRow weeksPerRow}.
     *
     * Number of weeks
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `weeksPerRow`
     */
    getWeeksPerRow(): int;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the calendar
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.me.OverlapCalendarEvent` in the aggregation {@link #getCalendarEvents calendarEvents}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCalendarEvent(
      /**
       * The calendarEvent whose index is looked for
       */
      oCalendarEvent: OverlapCalendarEvent
    ): int;
    /**
     * Inserts a calendarEvent into the aggregation {@link #getCalendarEvents calendarEvents}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCalendarEvent(
      /**
       * The calendarEvent to insert; if empty, nothing is inserted
       */
      oCalendarEvent: OverlapCalendarEvent,
      /**
       * The `0`-based index the calendarEvent should be inserted at; for a negative value of `iIndex`, the calendarEvent
       * is inserted at position 0; for a value greater than the current size of the aggregation, the calendarEvent
       * is inserted at the last position
       */
      iIndex: int
    ): this;

    onAfterRendering(): void;

    onBeforeRendering(): void;

    onswipeleft(oEvent: jQuery.Event): void;

    onswiperight(oEvent: jQuery.Event): void;
    /**
     * Removes all the controls from the aggregation {@link #getCalendarEvents calendarEvents}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCalendarEvents(): OverlapCalendarEvent[];
    /**
     * Removes a calendarEvent from the aggregation {@link #getCalendarEvents calendarEvents}.
     *
     *
     * @returns The removed calendarEvent or `null`
     */
    removeCalendarEvent(
      /**
       * The calendarEvent to remove or its index or id
       */
      vCalendarEvent: int | string | OverlapCalendarEvent
    ): OverlapCalendarEvent | null;
    /**
     * Sets a new value for property {@link #getFirstDayOffset firstDayOffset}.
     *
     * Indicate how to offset the first day in regards to a Sunday (by default)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDayOffset(
      /**
       * New value for property `firstDayOffset`
       */
      iFirstDayOffset?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowOverlapIndicator showOverlapIndicator}.
     *
     * Do we want to display the overlap indicator
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowOverlapIndicator(
      /**
       * New value for property `showOverlapIndicator`
       */
      bShowOverlapIndicator?: boolean
    ): this;

    setStartDate(
      /**
       * The start date, expected toDateString.
       */
      sDate: string | Date
    ): void;

    setSwipeToNavigate(bSwipe: boolean): void;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Indicates if we should render this component
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;

    setWeeksPerRow(
      /**
       * The integer number of weeks per row
       */
      iWeeksPerRow: int
    ): void;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the calendar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OverlapCalendar constructor.
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.m.PlanningCalendar
   * instead!
   */
  export interface $OverlapCalendarSettings extends $ControlSettings {
    /**
     * The first date to display for the calendar
     */
    startDate?: string | PropertyBindingInfo;

    /**
     * Number of weeks
     */
    weeksPerRow?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicate how to offset the first day in regards to a Sunday (by default)
     */
    firstDayOffset?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Do we want to display the overlap indicator
     */
    showOverlapIndicator?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if we should render this component
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Use swipe gesture to navigate
     */
    swipeToNavigate?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the calendar
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The list of events to display in the calendar grid
     */
    calendarEvents?:
      | OverlapCalendarEvent[]
      | OverlapCalendarEvent
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Indicates that we have reach the last week with data
     */
    endOfData?: (oEvent: OverlapCalendar$EndOfDataEvent) => void;

    /**
     * Triggered when the displayed dates change
     */
    changeDate?: (oEvent: OverlapCalendar$ChangeDateEvent) => void;
  }

  /**
   * Parameters of the OverlapCalendar#changeDate event.
   */
  export interface OverlapCalendar$ChangeDateEventParameters {
    /**
     * The first date displayed in the calendar
     */
    firstDate?: object;

    /**
     * The last date that will be displayed
     */
    lastDate?: object;
  }

  /**
   * Event object of the OverlapCalendar#changeDate event.
   */
  export type OverlapCalendar$ChangeDateEvent = Event<
    OverlapCalendar$ChangeDateEventParameters,
    OverlapCalendar
  >;

  /**
   * Parameters of the OverlapCalendar#endOfData event.
   */
  export interface OverlapCalendar$EndOfDataEventParameters {
    /**
     * Indicates if the data missing are before the start date or at the end
     */
    before?: boolean;
  }

  /**
   * Event object of the OverlapCalendar#endOfData event.
   */
  export type OverlapCalendar$EndOfDataEvent = Event<
    OverlapCalendar$EndOfDataEventParameters,
    OverlapCalendar
  >;
}

declare module "sap/me/OverlapCalendarEvent" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Represent the data of an event for the overlap calendar
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.ui.unified.CalendarAppointment
   * instead!
   */
  export default class OverlapCalendarEvent extends UI5Element {
    /**
     * Constructor for a new OverlapCalendarEvent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlapCalendarEventSettings
    );
    /**
     * Constructor for a new OverlapCalendarEvent.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverlapCalendarEventSettings
    );

    /**
     * Creates a new subclass of class sap.me.OverlapCalendarEvent with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OverlapCalendarEvent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.OverlapCalendarEvent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Binds property {@link #getEndDay endDay} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindEndDay(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getHalfDay halfDay} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindHalfDay(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getName name} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindName(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getRelevant relevant} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRelevant(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getRow row} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRow(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getStartDay startDay} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindStartDay(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getType type} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindType(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Binds property {@link #getTypeName typeName} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindTypeName(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Gets current value of property {@link #getEndDay endDay}.
     *
     * Last day of the event
     *
     *
     * @returns Value of property `endDay`
     */
    getEndDay(): string;
    /**
     * Gets current value of property {@link #getHalfDay halfDay}.
     *
     * Is this half a day
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `halfDay`
     */
    getHalfDay(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of the row
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getRelevant relevant}.
     *
     * Indicates if this elements is relevant to be consider in the overlap
     *
     *
     * @returns Value of property `relevant`
     */
    getRelevant(): boolean;
    /**
     * Gets current value of property {@link #getRow row}.
     *
     * Id of the row on which to place this event
     *
     * Default value is `-1`.
     *
     *
     * @returns Value of property `row`
     */
    getRow(): int;
    /**
     * Gets current value of property {@link #getStartDay startDay}.
     *
     * The first day of the event
     *
     *
     * @returns Value of property `startDay`
     */
    getStartDay(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Type of the event. Display in the second label (no overlap)
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property {@link #getTypeName typeName}.
     *
     * The CSS class to use
     *
     *
     * @returns Value of property `typeName`
     */
    getTypeName(): string;
    /**
     * Sets a new value for property {@link #getEndDay endDay}.
     *
     * Last day of the event
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndDay(
      /**
       * New value for property `endDay`
       */
      sEndDay?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHalfDay halfDay}.
     *
     * Is this half a day
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHalfDay(
      /**
       * New value for property `halfDay`
       */
      bHalfDay?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of the row
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRelevant relevant}.
     *
     * Indicates if this elements is relevant to be consider in the overlap
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRelevant(
      /**
       * New value for property `relevant`
       */
      bRelevant?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRow row}.
     *
     * Id of the row on which to place this event
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRow(
      /**
       * New value for property `row`
       */
      iRow?: int
    ): this;
    /**
     * Sets a new value for property {@link #getStartDay startDay}.
     *
     * The first day of the event
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStartDay(
      /**
       * New value for property `startDay`
       */
      sStartDay?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Type of the event. Display in the second label (no overlap)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTypeName typeName}.
     *
     * The CSS class to use
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTypeName(
      /**
       * New value for property `typeName`
       */
      sTypeName?: string
    ): this;
    /**
     * Unbinds property {@link #getEndDay endDay} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindEndDay(): this;
    /**
     * Unbinds property {@link #getHalfDay halfDay} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindHalfDay(): this;
    /**
     * Unbinds property {@link #getName name} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindName(): this;
    /**
     * Unbinds property {@link #getRelevant relevant} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRelevant(): this;
    /**
     * Unbinds property {@link #getRow row} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRow(): this;
    /**
     * Unbinds property {@link #getStartDay startDay} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindStartDay(): this;
    /**
     * Unbinds property {@link #getType type} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindType(): this;
    /**
     * Unbinds property {@link #getTypeName typeName} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindTypeName(): this;
  }
  /**
   * Describes the settings that can be provided to the OverlapCalendarEvent constructor.
   *
   * @deprecated (since 1.34.0) - This control was experimental since 1.12. Please use the sap.ui.unified.CalendarAppointment
   * instead!
   */
  export interface $OverlapCalendarEventSettings extends $ElementSettings {
    /**
     * The first day of the event
     */
    startDay?: string | PropertyBindingInfo;

    /**
     * Last day of the event
     */
    endDay?: string | PropertyBindingInfo;

    /**
     * Indicates if this elements is relevant to be consider in the overlap
     */
    relevant?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Type of the event. Display in the second label (no overlap)
     */
    type?: string | PropertyBindingInfo;

    /**
     * The CSS class to use
     */
    typeName?: string | PropertyBindingInfo;

    /**
     * Is this half a day
     */
    halfDay?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Id of the row on which to place this event
     */
    row?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of the row
     */
    name?: string | PropertyBindingInfo;
  }
}

declare module "sap/me/ProgressIndicator" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { BarColor, CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Shows the progress of a process in a graphical way. The indicator can be displayed with or without numerical
   * values. The filling can be displayed in color only, or additionally with the percentage rate. The indicator
   * status can be interactive.
   *
   * @deprecated (since 1.14) - This control is replaced by sap.m.ProgressIndicator
   */
  export default class ProgressIndicator extends Control {
    /**
     * Constructor for a new ProgressIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );
    /**
     * Constructor for a new ProgressIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ProgressIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.me.ProgressIndicator with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ProgressIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.ProgressIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBarColor barColor}.
     *
     * The color of the bar. Enumeration sap.ui.core.BarColor provides CRITICAL (yellow), NEGATIVE (red), POSITIVE
     * (green), NEUTRAL (blue) (default value).
     *
     * Default value is `NEUTRAL`.
     *
     *
     * @returns Value of property `barColor`
     */
    getBarColor(): BarColor | keyof typeof BarColor;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * The text value to be displayed in the bar.
     *
     * Default value is `'0%'`.
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Switches enabled state of the control. Disabled fields have different colors, and cannot be focused.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getPercentValue percentValue}.
     *
     * The numerical value for the displayed length of the progress bar.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `percentValue`
     */
    getPercentValue(): int;
    /**
     * Gets current value of property {@link #getShowValue showValue}.
     *
     * Specifies whether the current value shall be rendered inside the bar.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showValue`
     */
    getShowValue(): boolean;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Invisible controls are not rendered
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the control.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getBarColor barColor}.
     *
     * The color of the bar. Enumeration sap.ui.core.BarColor provides CRITICAL (yellow), NEGATIVE (red), POSITIVE
     * (green), NEUTRAL (blue) (default value).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `NEUTRAL`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBarColor(
      /**
       * New value for property `barColor`
       */
      sBarColor?: BarColor | keyof typeof BarColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * The text value to be displayed in the bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'0%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      sDisplayValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Switches enabled state of the control. Disabled fields have different colors, and cannot be focused.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Property setter for the PercentValue A new rendering is not necessary, only the bar has to be moved.
     *
     *
     * @returns `this` to allow method chaining
     */
    setPercentValue(iPercentValue: undefined): this;
    /**
     * Sets a new value for property {@link #getShowValue showValue}.
     *
     * Specifies whether the current value shall be rendered inside the bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValue(
      /**
       * New value for property `showValue`
       */
      bShowValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Invisible controls are not rendered
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ProgressIndicator constructor.
   *
   * @deprecated (since 1.14) - This control is replaced by sap.m.ProgressIndicator
   */
  export interface $ProgressIndicatorSettings extends $ControlSettings {
    /**
     * Invisible controls are not rendered
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switches enabled state of the control. Disabled fields have different colors, and cannot be focused.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The color of the bar. Enumeration sap.ui.core.BarColor provides CRITICAL (yellow), NEGATIVE (red), POSITIVE
     * (green), NEUTRAL (blue) (default value).
     */
    barColor?:
      | (BarColor | keyof typeof BarColor)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The text value to be displayed in the bar.
     */
    displayValue?: string | PropertyBindingInfo;

    /**
     * The numerical value for the displayed length of the progress bar.
     */
    percentValue?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether the current value shall be rendered inside the bar.
     */
    showValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/me/TabContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The TabContainer allow to stack 1 to 4 contents in a view with corresponding icons
   *
   * @deprecated (since 1.15.0) - The functionality of this control is merged with the sap.m.IconTabBar. Please
   * use the sap.m.IconTabBar instead! This control will not be supported anymore.
   */
  export default class TabContainer extends Control {
    /**
     * Constructor for a new TabContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $TabContainerSettings
    );
    /**
     * Constructor for a new TabContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $TabContainerSettings
    );

    /**
     * Creates a new subclass of class sap.me.TabContainer with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TabContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.me.TabContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:collapse collapse} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the tab will collapse
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCollapse(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:collapse collapse} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the tab will collapse
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCollapse(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the tab will expand
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:expand expand} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the tab will expand
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachExpand(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the selected tab has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.me.TabContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.me.TabContainer` itself.
     *
     * Indicates that the selected tab has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.me.TabContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the contentAttachments in the aggregation {@link #getContentAttachments contentAttachments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentAttachments(): this;
    /**
     * Destroys the contentInfo in the aggregation {@link #getContentInfo contentInfo}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentInfo(): this;
    /**
     * Destroys the contentNotes in the aggregation {@link #getContentNotes contentNotes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentNotes(): this;
    /**
     * Destroys the contentPeople in the aggregation {@link #getContentPeople contentPeople}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentPeople(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:collapse collapse} event of this `sap.me.TabContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCollapse(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:expand expand} event of this `sap.me.TabContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachExpand(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:select select} event of this `sap.me.TabContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:collapse collapse} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCollapse(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:expand expand} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireExpand(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:select select} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): boolean;
    /**
     * Gets current value of property {@link #getBadgeAttachments badgeAttachments}.
     *
     * The number to display in the badge for the attachments tab
     *
     *
     * @returns Value of property `badgeAttachments`
     */
    getBadgeAttachments(): int;
    /**
     * Gets current value of property {@link #getBadgeInfo badgeInfo}.
     *
     * The number to display in the badge for the info tab
     *
     *
     * @returns Value of property `badgeInfo`
     */
    getBadgeInfo(): int;
    /**
     * Gets current value of property {@link #getBadgeNotes badgeNotes}.
     *
     * The number to display in the badge for the notes tab
     *
     *
     * @returns Value of property `badgeNotes`
     */
    getBadgeNotes(): int;
    /**
     * Gets current value of property {@link #getBadgePeople badgePeople}.
     *
     * The number to display in the badge for the people tab
     *
     *
     * @returns Value of property `badgePeople`
     */
    getBadgePeople(): int;
    /**
     * Gets content of aggregation {@link #getContentAttachments contentAttachments}.
     *
     * The attachments tab
     */
    getContentAttachments(): Control;
    /**
     * Gets content of aggregation {@link #getContentInfo contentInfo}.
     *
     * The info tab
     */
    getContentInfo(): Control;
    /**
     * Gets content of aggregation {@link #getContentNotes contentNotes}.
     *
     * The notes tab
     */
    getContentNotes(): Control;
    /**
     * Gets content of aggregation {@link #getContentPeople contentPeople}.
     *
     * The people tab
     */
    getContentPeople(): Control;
    /**
     * Gets current value of property {@link #getExpandable expandable}.
     *
     * Indicates if the tab can be collapsed and expanded
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expandable`
     */
    getExpandable(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * Indicates if the actual tab is expanded or not
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getSelectedTab selectedTab}.
     *
     * Return the index of the selected tab
     *
     *
     * @returns Value of property `selectedTab`
     */
    getSelectedTab(): int;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * setter for visible property
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Sets a new value for property {@link #getBadgeAttachments badgeAttachments}.
     *
     * The number to display in the badge for the attachments tab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeAttachments(
      /**
       * New value for property `badgeAttachments`
       */
      iBadgeAttachments?: int
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeInfo badgeInfo}.
     *
     * The number to display in the badge for the info tab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeInfo(
      /**
       * New value for property `badgeInfo`
       */
      iBadgeInfo?: int
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeNotes badgeNotes}.
     *
     * The number to display in the badge for the notes tab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeNotes(
      /**
       * New value for property `badgeNotes`
       */
      iBadgeNotes?: int
    ): this;
    /**
     * Sets a new value for property {@link #getBadgePeople badgePeople}.
     *
     * The number to display in the badge for the people tab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgePeople(
      /**
       * New value for property `badgePeople`
       */
      iBadgePeople?: int
    ): this;
    /**
     * Sets the aggregated {@link #getContentAttachments contentAttachments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentAttachments(
      /**
       * The contentAttachments to set
       */
      oContentAttachments: Control
    ): this;
    /**
     * Sets the aggregated {@link #getContentInfo contentInfo}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentInfo(
      /**
       * The contentInfo to set
       */
      oContentInfo: Control
    ): this;
    /**
     * Sets the aggregated {@link #getContentNotes contentNotes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentNotes(
      /**
       * The contentNotes to set
       */
      oContentNotes: Control
    ): this;
    /**
     * Sets the aggregated {@link #getContentPeople contentPeople}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentPeople(
      /**
       * The contentPeople to set
       */
      oContentPeople: Control
    ): this;
    /**
     * Sets a new value for property {@link #getExpandable expandable}.
     *
     * Indicates if the tab can be collapsed and expanded
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandable(
      /**
       * New value for property `expandable`
       */
      bExpandable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * Indicates if the actual tab is expanded or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedTab selectedTab}.
     *
     * Return the index of the selected tab
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedTab(
      /**
       * New value for property `selectedTab`
       */
      iSelectedTab?: int
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * setter for visible property
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TabContainer constructor.
   *
   * @deprecated (since 1.15.0) - The functionality of this control is merged with the sap.m.IconTabBar. Please
   * use the sap.m.IconTabBar instead! This control will not be supported anymore.
   */
  export interface $TabContainerSettings extends $ControlSettings {
    /**
     * Return the index of the selected tab
     */
    selectedTab?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The number to display in the badge for the info tab
     */
    badgeInfo?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The number to display in the badge for the notes tab
     */
    badgeNotes?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The number to display in the badge for the attachments tab
     */
    badgeAttachments?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The number to display in the badge for the people tab
     */
    badgePeople?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the tab can be collapsed and expanded
     */
    expandable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the actual tab is expanded or not
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * setter for visible property
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The info tab
     */
    contentInfo?: Control;

    /**
     * The attachments tab
     */
    contentAttachments?: Control;

    /**
     * The notes tab
     */
    contentNotes?: Control;

    /**
     * The people tab
     */
    contentPeople?: Control;

    /**
     * Indicates that the selected tab has changed
     */
    select?: (oEvent: Event) => void;

    /**
     * Indicates that the tab will expand
     */
    expand?: (oEvent: Event) => void;

    /**
     * Indicates that the tab will collapse
     */
    collapse?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the TabContainer#collapse event.
   */
  export interface TabContainer$CollapseEventParameters {}

  /**
   * Event object of the TabContainer#collapse event.
   */
  export type TabContainer$CollapseEvent = Event<
    TabContainer$CollapseEventParameters,
    TabContainer
  >;

  /**
   * Parameters of the TabContainer#expand event.
   */
  export interface TabContainer$ExpandEventParameters {}

  /**
   * Event object of the TabContainer#expand event.
   */
  export type TabContainer$ExpandEvent = Event<
    TabContainer$ExpandEventParameters,
    TabContainer
  >;

  /**
   * Parameters of the TabContainer#select event.
   */
  export interface TabContainer$SelectEventParameters {}

  /**
   * Event object of the TabContainer#select event.
   */
  export type TabContainer$SelectEvent = Event<
    TabContainer$SelectEventParameters,
    TabContainer
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/me/Calendar": undefined;

    "sap/me/CalendarLegend": undefined;

    "sap/me/library": undefined;

    "sap/me/OverlapCalendar": undefined;

    "sap/me/OverlapCalendarEvent": undefined;

    "sap/me/ProgressIndicator": undefined;

    "sap/me/TabContainer": undefined;
  }
}
