import ts from "typescript";
import { LintMetadata } from "../LinterContext.js";
export declare function findDirectives(sourceFile: ts.SourceFile, metadata: LintMetadata): void;
export type DirectiveAction = "enable" | "disable";
export type DirectiveScope = "line" | "next-line" | undefined;
export interface Directive {
    action: DirectiveAction;
    scope: DirectiveScope;
    ruleNames: string[];
    pos: number;
    length: number;
    line: number;
    column: number;
}
export declare function collectPossibleDirectives(sourceFile: ts.SourceFile): Set<Directive>;
