"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __asyncDelegator = (this && this.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.iterateSources = void 0;
const assert_1 = require("assert");
const fs_1 = require("fs");
const ignore_1 = require("ignore");
const path_1 = require("path");
const globby = require("globby");
const findUp = require("find-up");
const DOTGIT = '.git';
const GITIGNORE = '.gitignore';
function pathWithin(container, contained) {
    const pathInContainer = (0, path_1.relative)(container, contained);
    return pathInContainer.startsWith('../') ? undefined : pathInContainer;
}
function pathContains(container, contained) {
    return typeof pathWithin(container, contained) === 'string';
}
function readIgnoreFile(path) {
    return __awaiter(this, void 0, void 0, function* () {
        const ig = (0, ignore_1.default)();
        ig.add(yield fs_1.promises.readFile(path, { encoding: 'utf-8' }));
        return ig;
    });
}
function findGitroot(from) {
    return __awaiter(this, void 0, void 0, function* () {
        const dotgit = yield findUp(DOTGIT, { cwd: from, type: 'directory' });
        return dotgit && (0, path_1.dirname)(dotgit);
    });
}
class FileFilter {
    constructor({ cwd, extensions }) {
        this.ignoresByGitignoreDirectory = new Map();
        this.cwd = cwd;
        this.extensions = extensions;
    }
    static build({ cwd, extensions, }) {
        return __awaiter(this, void 0, void 0, function* () {
            return new FileFilter({
                cwd,
                extensions,
            }).addGitignoreFilesTraversingUpToGitRoot();
        });
    }
    addGitignoreFilesTraversingUpToGitRoot(start = this.cwd) {
        return __awaiter(this, void 0, void 0, function* () {
            const gitroot = yield findGitroot(start);
            if (gitroot) {
                let search = start;
                while (pathContains(gitroot, search)) {
                    const gitignorePath = yield findUp(GITIGNORE, {
                        cwd: search,
                        type: 'file',
                    });
                    if (!gitignorePath) {
                        break;
                    }
                    yield this.addGitignoreFile(gitignorePath);
                    search = (0, path_1.dirname)((0, path_1.dirname)(gitignorePath));
                }
            }
            return this;
        });
    }
    addGitignoreFile(gitignorePath) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.ignoresByGitignoreDirectory.has((0, path_1.dirname)(gitignorePath))) {
                this.ignoresByGitignoreDirectory.set((0, path_1.dirname)(gitignorePath), yield readIgnoreFile(gitignorePath));
            }
        });
    }
    test(path, { isFile }) {
        const base = (0, path_1.basename)(path);
        if (base === DOTGIT || base === GITIGNORE) {
            return true;
        }
        if (isFile && this.extensions && !this.extensions.has((0, path_1.extname)(path))) {
            return true;
        }
        for (const [directory, ig] of this.ignoresByGitignoreDirectory) {
            const pathInDirectory = pathWithin(directory, path);
            if (!pathInDirectory) {
                continue;
            }
            if (ig.ignores(pathInDirectory)) {
                return true;
            }
        }
        return false;
    }
}
function iterateDirectory(root, { extensions } = {}) {
    return __asyncGenerator(this, arguments, function* iterateDirectory_1() {
        (0, assert_1.strict)((0, path_1.isAbsolute)(root), `expected absolute path: ${root}`);
        const filter = yield __await(FileFilter.build({ cwd: root, extensions }));
        const queue = [root];
        while (queue.length > 0) {
            const directory = queue.shift();
            const entries = yield __await(fs_1.promises.readdir(directory, { withFileTypes: true }));
            for (const entry of entries) {
                if (entry.isFile() && entry.name === GITIGNORE) {
                    const path = (0, path_1.join)(directory, entry.name);
                    yield __await(filter.addGitignoreFile(path));
                }
            }
            for (const entry of entries) {
                const path = (0, path_1.join)(directory, entry.name);
                if (filter.test(path, { isFile: entry.isFile() })) {
                    continue;
                }
                if (entry.isFile()) {
                    const content = yield __await(fs_1.promises.readFile(path, { encoding: 'utf-8' }));
                    yield yield __await({ path, content });
                }
                else if (entry.isDirectory()) {
                    queue.push(path);
                }
            }
        }
    });
}
function iterateFiles(paths, { extensions, cwd }) {
    return __asyncGenerator(this, arguments, function* iterateFiles_1() {
        const filter = yield __await(FileFilter.build({ cwd, extensions }));
        for (const path of paths) {
            yield __await(filter.addGitignoreFilesTraversingUpToGitRoot((0, path_1.dirname)(path)));
            if (!filter.test(path, { isFile: true })) {
                const content = yield __await(fs_1.promises.readFile(path, { encoding: 'utf-8' }));
                yield yield __await({ path, content });
            }
        }
    });
}
/**
 * Builds an iterator that loops through all the files in the given paths,
 * matching an allowlist of extensions. Ignores files excluded by git.
 */
function iterateSources(roots, { extensions, cwd = process.cwd(), } = {}) {
    return __asyncGenerator(this, arguments, function* iterateSources_1() {
        (0, assert_1.strict)((0, path_1.isAbsolute)(cwd), `expected absolute path: ${cwd}`);
        for (const root of roots) {
            if (globby.hasMagic(root)) {
                const matches = yield __await(globby((0, path_1.isAbsolute)(root) ? root : (0, path_1.join)(cwd, root), {
                    cwd,
                }));
                yield __await(yield* __asyncDelegator(__asyncValues(iterateFiles(matches, { cwd, extensions }))));
            }
            else if ((yield __await(fs_1.promises.lstat(root))).isDirectory()) {
                yield __await(yield* __asyncDelegator(__asyncValues(iterateDirectory((0, path_1.isAbsolute)(root) ? root : (0, path_1.join)(cwd, root), {
                    cwd,
                    extensions,
                }))));
            }
            else {
                yield __await(yield* __asyncDelegator(__asyncValues(iterateFiles([root], { cwd }))));
            }
        }
    });
}
exports.iterateSources = iterateSources;
//# sourceMappingURL=iterateSources.js.map