"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigBuilder = exports.Config = exports.Plugin = void 0;
const Babel = require("@babel/core");
const path_1 = require("path");
const extensions_1 = require("./extensions");
const PluginLoader_1 = require("./PluginLoader");
const AstExplorerResolver_1 = require("./resolvers/AstExplorerResolver");
const FileSystemResolver_1 = require("./resolvers/FileSystemResolver");
const NetworkResolver_1 = require("./resolvers/NetworkResolver");
const PackageResolver_1 = require("./resolvers/PackageResolver");
class Plugin {
    constructor(rawPlugin, inferredName, source, resolvedPath) {
        this.rawPlugin = rawPlugin;
        this.inferredName = inferredName;
        this.source = source;
        this.resolvedPath = resolvedPath;
        try {
            const instance = rawPlugin(Babel);
            if (instance.name) {
                this.declaredName = instance.name;
            }
        }
        catch (_a) {
            // We won't be able to determine what the plugin names itself ¯\_(ツ)_/¯
        }
    }
}
exports.Plugin = Plugin;
class Config {
    constructor(sourcePaths = [], localPlugins = [], remotePlugins = [], pluginOptions = new Map(), parserPlugins = new Set(), extensions = extensions_1.TransformableExtensions, sourceType = 'unambiguous', requires = [], transpilePlugins = true, stdio = false, dry = false) {
        this.sourcePaths = sourcePaths;
        this.localPlugins = localPlugins;
        this.remotePlugins = remotePlugins;
        this.pluginOptions = pluginOptions;
        this.parserPlugins = parserPlugins;
        this.extensions = extensions;
        this.sourceType = sourceType;
        this.requires = requires;
        this.transpilePlugins = transpilePlugins;
        this.stdio = stdio;
        this.dry = dry;
        this.pluginLoader = new PluginLoader_1.PluginLoader([
            new FileSystemResolver_1.FileSystemResolver(),
            new PackageResolver_1.PackageResolver(),
        ]);
        this.remotePluginLoader = new PluginLoader_1.PluginLoader([
            new AstExplorerResolver_1.AstExplorerResolver(),
            new NetworkResolver_1.NetworkResolver(),
        ]);
    }
    getPlugins() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this._pluginCache) {
                const localPlugins = Promise.all(this.localPlugins.map((localPlugin) => __awaiter(this, void 0, void 0, function* () {
                    const pluginExports = yield this.pluginLoader.load(localPlugin);
                    const defaultExport = pluginExports['default'] || pluginExports;
                    return new Plugin(defaultExport, (0, path_1.basename)(localPlugin, (0, path_1.extname)(localPlugin)), localPlugin);
                })));
                const remotePlugins = Promise.all(this.remotePlugins.map((remotePlugin) => __awaiter(this, void 0, void 0, function* () {
                    const pluginExports = yield this.remotePluginLoader.load(remotePlugin);
                    const defaultExport = pluginExports['default'] || pluginExports;
                    return new Plugin(defaultExport, (0, path_1.basename)(remotePlugin, (0, path_1.extname)(remotePlugin)), remotePlugin);
                })));
                this._pluginCache = [...(yield localPlugins), ...(yield remotePlugins)];
            }
            return this._pluginCache;
        });
    }
    loadRequires() {
        for (const modulePath of this.requires) {
            require(modulePath);
        }
    }
    loadBabelTranspile() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.transpilePlugins && !require.extensions['.ts']) {
                yield Promise.resolve().then(() => require('esbuild-runner/register.js'));
            }
        });
    }
    getPlugin(name) {
        return __awaiter(this, void 0, void 0, function* () {
            for (const plugin of yield this.getPlugins()) {
                if (plugin.declaredName === name ||
                    plugin.inferredName === name ||
                    plugin.source === name) {
                    return plugin;
                }
            }
            return null;
        });
    }
    getBabelPlugins() {
        return __awaiter(this, void 0, void 0, function* () {
            const result = [];
            for (const plugin of yield this.getPlugins()) {
                const options = (plugin.declaredName && this.pluginOptions.get(plugin.declaredName)) ||
                    this.pluginOptions.get(plugin.inferredName) ||
                    (plugin.source && this.pluginOptions.get(plugin.source));
                if (options) {
                    result.push([plugin.rawPlugin, options]);
                }
                else {
                    result.push(plugin.rawPlugin);
                }
            }
            return result;
        });
    }
    getBabelPlugin(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const plugin = yield this.getPlugin(name);
            if (!plugin) {
                return null;
            }
            const options = this.pluginOptions.get(name);
            if (options) {
                return [plugin.rawPlugin, options];
            }
            else {
                return plugin.rawPlugin;
            }
        });
    }
}
exports.Config = Config;
class ConfigBuilder {
    constructor() {
        this._parserPluginNames = new Set();
        this._extensions = new Set(extensions_1.TransformableExtensions);
        this._sourceType = 'module';
    }
    sourcePaths(value) {
        this._sourcePaths = value;
        return this;
    }
    addSourcePath(value) {
        if (!this._sourcePaths) {
            this._sourcePaths = [];
        }
        this._sourcePaths.push(value);
        return this;
    }
    addSourcePaths(...values) {
        for (const value of values) {
            this.addSourcePath(value);
        }
        return this;
    }
    localPlugins(value) {
        this._localPlugins = value;
        return this;
    }
    addLocalPlugin(value) {
        if (!this._localPlugins) {
            this._localPlugins = [];
        }
        this._localPlugins.push(value);
        return this;
    }
    remotePlugins(value) {
        this._remotePlugins = value;
        return this;
    }
    addRemotePlugin(value) {
        if (!this._remotePlugins) {
            this._remotePlugins = [];
        }
        this._remotePlugins.push(value);
        return this;
    }
    pluginOptions(value) {
        this._pluginOptions = value;
        return this;
    }
    setOptionsForPlugin(options, plugin) {
        if (!this._pluginOptions) {
            this._pluginOptions = new Map();
        }
        this._pluginOptions.set(plugin, options);
        return this;
    }
    addParserPlugin(name) {
        this._parserPluginNames.add(name);
        return this;
    }
    extensions(value) {
        this._extensions = value;
        return this;
    }
    addExtension(value) {
        if (!this._extensions) {
            this._extensions = new Set();
        }
        this._extensions.add(value);
        return this;
    }
    sourceType(value) {
        this._sourceType = value;
        return this;
    }
    requires(value) {
        this._requires = value;
        return this;
    }
    addRequire(value) {
        if (!this._requires) {
            this._requires = [];
        }
        this._requires.push(value);
        return this;
    }
    transpilePlugins(value) {
        this._transpilePlugins = value;
        return this;
    }
    stdio(value) {
        this._stdio = value;
        return this;
    }
    dry(value) {
        this._dry = value;
        return this;
    }
    build() {
        return new Config(this._sourcePaths, this._localPlugins, this._remotePlugins, this._pluginOptions, this._parserPluginNames, this._extensions, this._sourceType, this._requires, this._transpilePlugins, this._stdio, this._dry);
    }
}
exports.ConfigBuilder = ConfigBuilder;
//# sourceMappingURL=Config.js.map