/**
 * Convert a string to the `RegExp`.
 * Normal strings (e.g. `"foo"`) is converted to `/^foo$/` of `RegExp`.
 * Strings like `"/^foo/i"` are converted to `/^foo/i` of `RegExp`.
 *
 * @param {string} string The string to convert.
 * @returns {RegExp} Returns the `RegExp`.
 */
export declare function toRegExp(string: string): {
    test(s: string): boolean;
};
/**
 * Checks whether given string is regexp string
 * @param {string} string
 * @returns {boolean}
 */
export declare function isRegExp(string: string): boolean;
