// For Library Version: 1.136.13

declare module "sap/zen/dsh/library" {}

declare module "sap/zen/dsh/AnalyticGrid" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Control for embedding a Design Studio Analytic Grid in an S/4 HANA Fiori application
   *
   * @since 1.46
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   * @experimental As of version 1.46. API is incomplete and may change incompatibly
   */
  export default class AnalyticGrid extends Control {
    /**
     * Constructor for a new AnalyticGrid.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalyticGridSettings
    );
    /**
     * Constructor for a new AnalyticGrid.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AnalyticGridSettings
    );

    /**
     * Creates a new subclass of class sap.zen.dsh.AnalyticGrid with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AnalyticGrid>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.dsh.AnalyticGrid.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.zen.dsh.AnalyticGrid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.AnalyticGrid` itself.
     *
     * Event is triggered when the selection is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.AnalyticGrid` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.zen.dsh.AnalyticGrid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.AnalyticGrid` itself.
     *
     * Event is triggered when the selection is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.AnalyticGrid` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stateChange stateChange} event of this `sap.zen.dsh.AnalyticGrid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.AnalyticGrid` itself.
     *
     * Event is triggered when the state of the AnalyticGrid is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStateChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$StateChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.AnalyticGrid` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:stateChange stateChange} event of this `sap.zen.dsh.AnalyticGrid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.AnalyticGrid` itself.
     *
     * Event is triggered when the state of the AnalyticGrid is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachStateChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$StateChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.AnalyticGrid` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.zen.dsh.AnalyticGrid`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:stateChange stateChange} event of this `sap.zen.dsh.AnalyticGrid`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachStateChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AnalyticGrid$StateChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnalyticGrid$SelectionChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:stateChange stateChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireStateChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AnalyticGrid$StateChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Desired width of the AnalyticGrid control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getQueryName queryName}.
     *
     * Name of the Query to bind the AnalyticGrid to.
     *
     *
     * @returns Value of property `queryName`
     */
    getQueryName(): string;
    /**
     * Gets current value of property {@link #getSelection selection}.
     *
     * A SelectionVariant specifying the initial selection state used by the AnalyticGrid. Depending on the
     * specific query and selection variant state, this will result in setting one or more variables' values
     * and setting one or more filters on the datasource.
     *
     *
     * @returns Value of property `selection`
     */
    getSelection(): object;
    /**
     * Gets current value of property {@link #getState state}.
     *
     * A string representing the current state of the analytic grid, including data selection and navigation
     * state. Intended to be used for saving and recreating inner application state in navigation scenarios,
     * for example.
     *
     *
     * @returns Value of property `state`
     */
    getState(): string;
    /**
     * Gets current value of property {@link #getSystemAlias systemAlias}.
     *
     * Target System alias for data connectivity
     *
     *
     * @returns Value of property `systemAlias`
     */
    getSystemAlias(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Desired width of the AnalyticGrid control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Desired width of the AnalyticGrid control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getQueryName queryName}.
     *
     * Name of the Query to bind the AnalyticGrid to.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setQueryName(
      /**
       * New value for property `queryName`
       */
      sQueryName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelection selection}.
     *
     * A SelectionVariant specifying the initial selection state used by the AnalyticGrid. Depending on the
     * specific query and selection variant state, this will result in setting one or more variables' values
     * and setting one or more filters on the datasource.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelection(
      /**
       * New value for property `selection`
       */
      oSelection?: object
    ): this;
    /**
     * Sets a new value for property {@link #getState state}.
     *
     * A string representing the current state of the analytic grid, including data selection and navigation
     * state. Intended to be used for saving and recreating inner application state in navigation scenarios,
     * for example.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setState(
      /**
       * New value for property `state`
       */
      sState?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSystemAlias systemAlias}.
     *
     * Target System alias for data connectivity
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSystemAlias(
      /**
       * New value for property `systemAlias`
       */
      sSystemAlias?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Desired width of the AnalyticGrid control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AnalyticGrid constructor.
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   * @experimental As of version 1.46. API is incomplete and may change incompatibly
   */
  export interface $AnalyticGridSettings extends $ControlSettings {
    /**
     * Desired width of the AnalyticGrid control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Desired width of the AnalyticGrid control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * A SelectionVariant specifying the initial selection state used by the AnalyticGrid. Depending on the
     * specific query and selection variant state, this will result in setting one or more variables' values
     * and setting one or more filters on the datasource.
     */
    selection?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of the Query to bind the AnalyticGrid to.
     */
    queryName?: string | PropertyBindingInfo;

    /**
     * Target System alias for data connectivity
     */
    systemAlias?: string | PropertyBindingInfo;

    /**
     * A string representing the current state of the analytic grid, including data selection and navigation
     * state. Intended to be used for saving and recreating inner application state in navigation scenarios,
     * for example.
     */
    state?: string | PropertyBindingInfo;

    /**
     * Event is triggered when the state of the AnalyticGrid is changed.
     */
    stateChange?: (oEvent: AnalyticGrid$StateChangeEvent) => void;

    /**
     * Event is triggered when the selection is changed.
     */
    selectionChange?: (oEvent: AnalyticGrid$SelectionChangeEvent) => void;
  }

  /**
   * Parameters of the AnalyticGrid#selectionChange event.
   */
  export interface AnalyticGrid$SelectionChangeEventParameters {
    /**
     * A SelectionVariant specifying the current selection state of the AnalyticGrid.
     */
    selection?: object;
  }

  /**
   * Event object of the AnalyticGrid#selectionChange event.
   */
  export type AnalyticGrid$SelectionChangeEvent = Event<
    AnalyticGrid$SelectionChangeEventParameters,
    AnalyticGrid
  >;

  /**
   * Parameters of the AnalyticGrid#stateChange event.
   */
  export interface AnalyticGrid$StateChangeEventParameters {
    /**
     * Serialized state string.
     */
    state?: string;
  }

  /**
   * Event object of the AnalyticGrid#stateChange event.
   */
  export type AnalyticGrid$StateChangeEvent = Event<
    AnalyticGrid$StateChangeEventParameters,
    AnalyticGrid
  >;
}

declare module "sap/zen/dsh/Dsh" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Control for embedding a Design Studio application full-screen in an S/4 HANA Fiori application
   *
   * @since 1.44
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   */
  export default class Dsh extends Control {
    /**
     * Constructor for a new Dsh.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DshSettings
    );
    /**
     * Constructor for a new Dsh.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DshSettings
    );

    /**
     * Creates a new subclass of class sap.zen.dsh.Dsh with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dsh>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.dsh.Dsh.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;

    addParameter(
      /**
       * the name of the parameter
       */
      sName: string,
      /**
       * the value of the parameter
       */
      sValue: string
    ): string;

    createPage(): void;

    executeScript(
      /**
       * the content of the script
       */
      sScript: string
    ): void;
    /**
     * Gets current value of property {@link #getAppComponent appComponent}.
     *
     * the application component
     *
     *
     * @returns Value of property `appComponent`
     */
    getAppComponent(): object;
    /**
     * Gets current value of property {@link #getClient client}.
     *
     * the client
     *
     *
     * @returns Value of property `client`
     */
    getClient(): string;

    getComponent(
      /**
       * the Name of the Component
       */
      sName: string
    ): object;

    getDataSource(
      /**
       * the namw of the data source
       */
      sName: string
    ): object;
    /**
     * Gets current value of property {@link #getDeferCreation deferCreation}.
     *
     * whether to defer the creation
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `deferCreation`
     */
    getDeferCreation(): boolean;
    /**
     * Gets current value of property {@link #getDeployment deployment}.
     *
     * the type of deployment
     *
     * Default value is `"bw"`.
     *
     *
     * @returns Value of property `deployment`
     */
    getDeployment(): string;
    /**
     * Gets current value of property {@link #getDshAppName dshAppName}.
     *
     * Name of the Design Studio application to be opened.
     *
     * Default value is `"0ANALYSIS"`.
     *
     *
     * @returns Value of property `dshAppName`
     */
    getDshAppName(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Desired height of the Design Studio Control
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getLanguage language}.
     *
     * the language
     *
     *
     * @returns Value of property `language`
     */
    getLanguage(): string;

    getPage(): object;
    /**
     * Gets current value of property {@link #getProtocol protocol}.
     *
     * the protocol
     *
     *
     * @returns Value of property `protocol`
     */
    getProtocol(): string;
    /**
     * Gets current value of property {@link #getRepoPath repoPath}.
     *
     * Path to application specified by dshAppName
     *
     *
     * @returns Value of property `repoPath`
     */
    getRepoPath(): string;
    /**
     * Gets current value of property {@link #getSemanticMappings semanticMappings}.
     *
     * the semantic mappings
     *
     *
     * @returns Value of property `semanticMappings`
     */
    getSemanticMappings(): object;
    /**
     * Gets current value of property {@link #getSystemAlias systemAlias}.
     *
     * the system alias
     *
     *
     * @returns Value of property `systemAlias`
     */
    getSystemAlias(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Desired width of the Design Studio Control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Initialize cross-application navigation state with an AppState object
     */
    initializeAppState(
      /**
       * The AppState object from which to retrieve and apply Application State.
       */
      oOStartupAppState: object,
      /**
       * Simple Javascript object containing name-value pairs of additional navigation state to be mixed in
       */
      oONavParams: object
    ): void;
    /**
     * Initialize cross-application navigation state directly with AppStateData. e.g., when calculated by sap.ui.generic.app.navigation.service.NavigationHandler
     */
    initializeAppStateData(
      /**
       * The AppStateData to apply
       */
      oOStateData: object,
      /**
       * Simple Javascript object containing name-value pairs of additional navigation state to be mixed in
       */
      oONavParams: object
    ): void;
    /**
     * Sets a new value for property {@link #getAppComponent appComponent}.
     *
     * the application component
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAppComponent(
      /**
       * New value for property `appComponent`
       */
      oAppComponent?: object
    ): this;
    /**
     * Sets a new value for property {@link #getClient client}.
     *
     * the client
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClient(
      /**
       * New value for property `client`
       */
      sClient?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDeferCreation deferCreation}.
     *
     * whether to defer the creation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeferCreation(
      /**
       * New value for property `deferCreation`
       */
      bDeferCreation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDeployment deployment}.
     *
     * the type of deployment
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"bw"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeployment(
      /**
       * New value for property `deployment`
       */
      sDeployment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDshAppName dshAppName}.
     *
     * Name of the Design Studio application to be opened.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0ANALYSIS"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDshAppName(
      /**
       * New value for property `dshAppName`
       */
      sDshAppName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Desired height of the Design Studio Control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLanguage language}.
     *
     * the language
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLanguage(
      /**
       * New value for property `language`
       */
      sLanguage?: string
    ): this;
    /**
     * Sets a new value for property {@link #getProtocol protocol}.
     *
     * the protocol
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setProtocol(
      /**
       * New value for property `protocol`
       */
      sProtocol?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRepoPath repoPath}.
     *
     * Path to application specified by dshAppName
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRepoPath(
      /**
       * New value for property `repoPath`
       */
      sRepoPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticMappings semanticMappings}.
     *
     * the semantic mappings
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticMappings(
      /**
       * New value for property `semanticMappings`
       */
      oSemanticMappings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getSystemAlias systemAlias}.
     *
     * the system alias
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSystemAlias(
      /**
       * New value for property `systemAlias`
       */
      sSystemAlias?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Desired width of the Design Studio Control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Dsh constructor.
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   */
  export interface $DshSettings extends $ControlSettings {
    /**
     * Name of the Design Studio application to be opened.
     */
    dshAppName?: string | PropertyBindingInfo;

    /**
     * Path to application specified by dshAppName
     */
    repoPath?: string | PropertyBindingInfo;

    /**
     * Desired width of the Design Studio Control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Desired height of the Design Studio Control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * the type of deployment
     */
    deployment?: string | PropertyBindingInfo;

    /**
     * the protocol
     */
    protocol?: string | PropertyBindingInfo;

    /**
     * the client
     */
    client?: string | PropertyBindingInfo;

    /**
     * the language
     */
    language?: string | PropertyBindingInfo;

    /**
     * the semantic mappings
     */
    semanticMappings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * the application component
     */
    appComponent?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * whether to defer the creation
     */
    deferCreation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * the system alias
     */
    systemAlias?: string | PropertyBindingInfo;
  }
}

declare module "sap/zen/dsh/widgets/ValueHelpDialog" {
  import { default as Dialog, $DialogSettings } from "sap/m/Dialog";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ValueHelpRangeOperation from "sap/zen/dsh/ValueHelpRangeOperation";

  import Token from "sap/m/Token";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Control from "sap/ui/core/Control";

  /**
   * The ValueHelpDialog control can be used to implement a value help for an input field.
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   */
  export default class ValueHelpDialog extends Dialog {
    /**
     * Constructor for a new valuehelpdialog/ValueHelpDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ValueHelpDialogSettings
    );
    /**
     * Constructor for a new valuehelpdialog/ValueHelpDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ValueHelpDialogSettings
    );

    /**
     * Creates a new subclass of class sap.zen.dsh.ValueHelpDialog with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Dialog.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ValueHelpDialog>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.dsh.ValueHelpDialog.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the Cancel button is pressed.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the Cancel button is pressed.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ok ok} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the OK button is pressed.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOk(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$OkEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ok ok} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the OK button is pressed.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOk(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$OkEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the user selects an item in the items table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the user selects an item in the items table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tokenRemove tokenRemove} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the user removes one or multiple existing token(s) from the dialog.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTokenRemove(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$TokenRemoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tokenRemove tokenRemove} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the user removes one or multiple existing token(s) from the dialog.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTokenRemove(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$TokenRemoveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:updateSelection updateSelection} event of this
     * `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the table gets an update and all existing tokens must be selected in the table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUpdateSelection(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$UpdateSelectionEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:updateSelection updateSelection} event of this
     * `sap.zen.dsh.ValueHelpDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.zen.dsh.ValueHelpDialog` itself.
     *
     * This event is fired when the table gets an update and all existing tokens must be selected in the table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUpdateSelection(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$UpdateSelectionEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.zen.dsh.ValueHelpDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the filterBar in the aggregation {@link #getFilterBar filterBar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFilterBar(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancel cancel} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancel(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:ok ok} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOk(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$OkEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.zen.dsh.ValueHelpDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tokenRemove tokenRemove} event of this `sap.zen.dsh.ValueHelpDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTokenRemove(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$TokenRemoveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:updateSelection updateSelection} event of
     * this `sap.zen.dsh.ValueHelpDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.32
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUpdateSelection(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ValueHelpDialog$UpdateSelectionEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:cancel cancel} to attached listeners.
     *
     * @since 1.24
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancel(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:ok ok} to attached listeners.
     *
     * @since 1.24
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOk(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ValueHelpDialog$OkEventParameters
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @since 1.32
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ValueHelpDialog$SelectionChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:tokenRemove tokenRemove} to attached listeners.
     *
     * @since 1.32
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTokenRemove(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ValueHelpDialog$TokenRemoveEventParameters
    ): this;
    /**
     * Fires event {@link #event:updateSelection updateSelection} to attached listeners.
     *
     * @since 1.32
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUpdateSelection(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ValueHelpDialog$UpdateSelectionEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getBasicSearchText basicSearchText}.
     *
     * Defines the value for the basic search field. The value is set into the basic search field of the filter
     * bar used.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Value of property `basicSearchText`
     */
    getBasicSearchText(): string;
    /**
     * Gets current value of property {@link #getDescriptionKey descriptionKey}.
     *
     * Defines the key of the column used for the token text.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Value of property `descriptionKey`
     */
    getDescriptionKey(): string;
    /**
     * Gets current value of property {@link #getDisplayFormat displayFormat}.
     *
     * Represents the display format of the range values. With the `displayFormat` value UpperCase, the entered
     * value of the range (condition) is converted to uppercase letters.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Value of property `displayFormat`
     */
    getDisplayFormat(): string;
    /**
     * Gets current value of property {@link #getFilterMode filterMode}.
     *
     * Sets the dialog into a filter mode, which only shows ranges (conditions) and hides the tokens.
     *
     * Default value is `false`.
     *
     * @since 1.24
     *
     * @returns Value of property `filterMode`
     */
    getFilterMode(): boolean;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Defines the key of the column used for the internal key handling. The value of the column is used for
     * the token key and also to identify the row in the table.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getKeys keys}.
     *
     * Defines the list of additional keys of the column used for the internal key handling.
     *
     * @since 1.24
     *
     * @returns Value of property `keys`
     */
    getKeys(): string[];
    /**
     * Gets current value of property {@link #getMaxExcludeRanges maxExcludeRanges}.
     *
     * Defines the maximum number of exclude ranges.
     *
     * Default value is `"-1"`.
     *
     * @since 1.24
     *
     * @returns Value of property `maxExcludeRanges`
     */
    getMaxExcludeRanges(): string;
    /**
     * Gets current value of property {@link #getMaxIncludeRanges maxIncludeRanges}.
     *
     * Defines the maximum number of include ranges.
     *
     * Default value is `"-1"`.
     *
     * @since 1.24
     *
     * @returns Value of property `maxIncludeRanges`
     */
    getMaxIncludeRanges(): string;
    /**
     * Gets current value of property {@link #getSupportMultiselect supportMultiselect}.
     *
     * Enables multi-selection in the table used.
     *
     * Default value is `true`.
     *
     * @since 1.24
     *
     * @returns Value of property `supportMultiselect`
     */
    getSupportMultiselect(): boolean;
    /**
     * Gets current value of property {@link #getSupportRanges supportRanges}.
     *
     * Enables the ranges (conditions) feature in the dialog.
     *
     * Default value is `false`.
     *
     * @since 1.24
     *
     * @returns Value of property `supportRanges`
     */
    getSupportRanges(): boolean;
    /**
     * Gets current value of property {@link #getSupportRangesOnly supportRangesOnly}.
     *
     * If this property is set to `true`, the value help dialog only supports the ranges (conditions) feature.
     *
     * Default value is `false`.
     *
     * @since 1.24
     *
     * @returns Value of property `supportRangesOnly`
     */
    getSupportRangesOnly(): boolean;
    /**
     * getTable Gives access to the internal table instance.
     *
     * @since 1.28
     *
     * @returns the used table instance
     */
    getTable(): object;
    /**
     * Gets current value of property {@link #getTokenDisplayBehaviour tokenDisplayBehaviour}.
     *
     * Represents how the item token text should be displayed in ValueHelpDialog. Use one of the valid `sap.ui.comp.smartfilterbar.DisplayBehaviour`
     * values.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Value of property `tokenDisplayBehaviour`
     */
    getTokenDisplayBehaviour(): string;
    /**
     * Sets a new value for property {@link #getDescriptionKey descriptionKey}.
     *
     * Defines the key of the column used for the token text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDescriptionKey(
      /**
       * New value for property `descriptionKey`
       */
      sDescriptionKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayFormat displayFormat}.
     *
     * Represents the display format of the range values. With the `displayFormat` value UpperCase, the entered
     * value of the range (condition) is converted to uppercase letters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayFormat(
      /**
       * New value for property `displayFormat`
       */
      sDisplayFormat?: string
    ): this;
    /**
     * setExcludeRangeOperations Sets the array for the supported exclude range operations.
     *
     * @since 1.24
     */
    setExcludeRangeOperations(
      /**
       * An array of range operations
       */
      aOperation: Array<
        ValueHelpRangeOperation | keyof typeof ValueHelpRangeOperation
      >,
      /**
       * the type for which the operations are defined
       */
      sType: string
    ): void;
    /**
     * Sets a new value for property {@link #getFilterMode filterMode}.
     *
     * Sets the dialog into a filter mode, which only shows ranges (conditions) and hides the tokens.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterMode(
      /**
       * New value for property `filterMode`
       */
      bFilterMode?: boolean
    ): this;
    /**
     * setIncludeRangeOperations Sets the array for the supported include range operations.
     *
     * @since 1.24
     */
    setIncludeRangeOperations(
      /**
       * An array of range operations
       */
      aOperation: Array<
        ValueHelpRangeOperation | keyof typeof ValueHelpRangeOperation
      >,
      /**
       * the type for which the operations are defined
       */
      sType: string
    ): void;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Defines the key of the column used for the internal key handling. The value of the column is used for
     * the token key and also to identify the row in the table.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKeys keys}.
     *
     * Defines the list of additional keys of the column used for the internal key handling.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKeys(
      /**
       * New value for property `keys`
       */
      sKeys?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getMaxExcludeRanges maxExcludeRanges}.
     *
     * Defines the maximum number of exclude ranges.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"-1"`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxExcludeRanges(
      /**
       * New value for property `maxExcludeRanges`
       */
      sMaxExcludeRanges?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMaxIncludeRanges maxIncludeRanges}.
     *
     * Defines the maximum number of include ranges.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"-1"`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxIncludeRanges(
      /**
       * New value for property `maxIncludeRanges`
       */
      sMaxIncludeRanges?: string
    ): this;
    /**
     * setRangeKeyFields Sets a RangeKeyFields array. This method allows you to specify the KeyFields for the
     * ranges. You can set an array of objects with Key and Label properties to define the key fields.
     *
     * @since 1.24
     */
    setRangeKeyFields(
      /**
       * An array of range KeyFields `[{key: "CompanyCode", label: "ID"}, {key:"CompanyName", label : "Name"}]`
       */
      aRangeKeyFields: object[]
    ): void;
    /**
     * setTable Sets the table used in the value help dialog. If not used, the dialog creates a sap.ui.table.Table
     * or sap.m.Table instance internally.
     *
     * @since 1.32
     */
    setTable(
      /**
       * The used table control instance
       */
      oTable: object
    ): void;
    /**
     * Sets a new value for property {@link #getTokenDisplayBehaviour tokenDisplayBehaviour}.
     *
     * Represents how the item token text should be displayed in ValueHelpDialog. Use one of the valid `sap.ui.comp.smartfilterbar.DisplayBehaviour`
     * values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.24
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTokenDisplayBehaviour(
      /**
       * New value for property `tokenDisplayBehaviour`
       */
      sTokenDisplayBehaviour?: string
    ): this;
    /**
     * Sets the array of tokens. The `sap.m.Tokens` are added to the dialog tokenizer Selected Items or Excluded
     * Items. Normal tokens are added to the Selected Items tokenizer only and are selected in the table. `
     * new sap.m.Token({key: "0001", text:"SAP A.G. (0001)"}); ` Tokens with the extra data with value 'range'
     * are handled as range tokens or exclude range tokens. ` new sap.m.Token({key: "i1", text: "ID: a..z"}).data("range",
     * { "exclude": false, "operation": sap.ui.comp.valuehelpdialog.ValueHelpRangeOperation.BT, "keyField":
     * "CompanyCode", "value1": "a", "value2": "z"}); ` The selected items or range tokens are returned in the
     * event parameters of the Ok event.
     *
     * @since 1.24
     */
    setTokens(
      /**
       * An array of token controls
       */
      aTokens: Token[]
    ): void;
    /**
     * Update the Control
     *
     * Updates the selection of rows in the table. This function must be called after a first binding or binding
     * update of the table. It will set a table row as selected if a token for this row exists.
     *
     * @since 1.24
     */
    update(): void;
  }
  /**
   * Describes the settings that can be provided to the ValueHelpDialog constructor.
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   */
  export interface $ValueHelpDialogSettings extends $DialogSettings {
    /**
     * Defines the value for the basic search field. The value is set into the basic search field of the filter
     * bar used.
     *
     * @since 1.24
     */
    basicSearchText?: string | PropertyBindingInfo;

    /**
     * Enables multi-selection in the table used.
     *
     * @since 1.24
     */
    supportMultiselect?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables the ranges (conditions) feature in the dialog.
     *
     * @since 1.24
     */
    supportRanges?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `true`, the value help dialog only supports the ranges (conditions) feature.
     *
     * @since 1.24
     */
    supportRangesOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the key of the column used for the internal key handling. The value of the column is used for
     * the token key and also to identify the row in the table.
     *
     * @since 1.24
     */
    key?: string | PropertyBindingInfo;

    /**
     * Defines the list of additional keys of the column used for the internal key handling.
     *
     * @since 1.24
     */
    keys?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the key of the column used for the token text.
     *
     * @since 1.24
     */
    descriptionKey?: string | PropertyBindingInfo;

    /**
     * Defines the maximum number of include ranges.
     *
     * @since 1.24
     */
    maxIncludeRanges?: string | PropertyBindingInfo;

    /**
     * Defines the maximum number of exclude ranges.
     *
     * @since 1.24
     */
    maxExcludeRanges?: string | PropertyBindingInfo;

    /**
     * Represents the display format of the range values. With the `displayFormat` value UpperCase, the entered
     * value of the range (condition) is converted to uppercase letters.
     *
     * @since 1.24
     */
    displayFormat?: string | PropertyBindingInfo;

    /**
     * Represents how the item token text should be displayed in ValueHelpDialog. Use one of the valid `sap.ui.comp.smartfilterbar.DisplayBehaviour`
     * values.
     *
     * @since 1.24
     */
    tokenDisplayBehaviour?: string | PropertyBindingInfo;

    /**
     * Sets the dialog into a filter mode, which only shows ranges (conditions) and hides the tokens.
     *
     * @since 1.24
     */
    filterMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Allows you to add a {@link sap.ui.comp.filterbar.FilterBar FilterBar} or {@link sap.ui.comp.smartfilterbar.SmartFilterBar SmartFilterBar }
     * control to the value help dialog.
     */
    filterBar?: Control;

    /**
     * This event is fired when the OK button is pressed.
     *
     * @since 1.24
     */
    ok?: (oEvent: ValueHelpDialog$OkEvent) => void;

    /**
     * This event is fired when the Cancel button is pressed.
     *
     * @since 1.24
     */
    cancel?: (oEvent: Event) => void;

    /**
     * This event is fired when the user selects an item in the items table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     */
    selectionChange?: (oEvent: ValueHelpDialog$SelectionChangeEvent) => void;

    /**
     * This event is fired when the user removes one or multiple existing token(s) from the dialog.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     */
    tokenRemove?: (oEvent: ValueHelpDialog$TokenRemoveEvent) => void;

    /**
     * This event is fired when the table gets an update and all existing tokens must be selected in the table.
     *
     * **Note:** The event will only be raised when the dialog gets a table instance from outside via `setTable`.
     *
     * @since 1.32
     */
    updateSelection?: (oEvent: ValueHelpDialog$UpdateSelectionEvent) => void;
  }

  /**
   * Parameters of the ValueHelpDialog#cancel event.
   */
  export interface ValueHelpDialog$CancelEventParameters {}

  /**
   * Event object of the ValueHelpDialog#cancel event.
   */
  export type ValueHelpDialog$CancelEvent = Event<
    ValueHelpDialog$CancelEventParameters,
    ValueHelpDialog
  >;

  /**
   * Parameters of the ValueHelpDialog#ok event.
   */
  export interface ValueHelpDialog$OkEventParameters {
    /**
     * The array of tokens created or modified on the ValueHelpDialog.
     */
    tokens?: Token[];
  }

  /**
   * Event object of the ValueHelpDialog#ok event.
   */
  export type ValueHelpDialog$OkEvent = Event<
    ValueHelpDialog$OkEventParameters,
    ValueHelpDialog
  >;

  /**
   * Parameters of the ValueHelpDialog#selectionChange event.
   */
  export interface ValueHelpDialog$SelectionChangeEventParameters {
    /**
     * The RowSelectionChange event parameter from the hosted table that contains the selected items.
     */
    tableSelectionParams?: object;

    /**
     * Returns an array of objects which represents all selected row tokens. The object contains the token key,
     * the row object data from the model, and the information if the token is selected. ` [{sKey, oRow, bSelect},
     * ...] `
     */
    updateTokens?: object[];

    /**
     * Can be set to `true` to execute the default behaviour of the ValueHelpDialog.
     */
    useDefault?: boolean;
  }

  /**
   * Event object of the ValueHelpDialog#selectionChange event.
   */
  export type ValueHelpDialog$SelectionChangeEvent = Event<
    ValueHelpDialog$SelectionChangeEventParameters,
    ValueHelpDialog
  >;

  /**
   * Parameters of the ValueHelpDialog#tokenRemove event.
   */
  export interface ValueHelpDialog$TokenRemoveEventParameters {
    /**
     * The array of token keys that has been removed.
     */
    tokenKeys?: string[];

    /**
     * Can be set to true to execute the default behaviour of ValueHelpDialog.
     */
    useDefault?: boolean;
  }

  /**
   * Event object of the ValueHelpDialog#tokenRemove event.
   */
  export type ValueHelpDialog$TokenRemoveEvent = Event<
    ValueHelpDialog$TokenRemoveEventParameters,
    ValueHelpDialog
  >;

  /**
   * Parameters of the ValueHelpDialog#updateSelection event.
   */
  export interface ValueHelpDialog$UpdateSelectionEventParameters {
    /**
     * The array of existing token keys for which the selection in the table has to be updated.
     */
    tokenKeys?: string[];

    /**
     * Can be set to true to execute the default behavior of ValueHelpDialog.
     */
    useDefault?: boolean;
  }

  /**
   * Event object of the ValueHelpDialog#updateSelection event.
   */
  export type ValueHelpDialog$UpdateSelectionEvent = Event<
    ValueHelpDialog$UpdateSelectionEventParameters,
    ValueHelpDialog
  >;
}

declare module "sap/zen/dsh/ValueHelpRangeOperation" {
  /**
   * Sort Type
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   * @experimental
   */
  enum ValueHelpRangeOperation {
    /**
     * The Between operation for the ranges.
     */
    BT = "BT",
    /**
     * The Contains operation for the ranges.
     */
    Contains = "Contains",
    /**
     * The EndsWith operation for the ranges.
     */
    EndsWith = "EndsWith",
    /**
     * The Equals operation for the ranges.
     */
    EQ = "EQ",
    /**
     * The Between or equals operation for the ranges.
     */
    GE = "GE",
    /**
     * The Greater operation for the ranges.
     */
    GT = "GT",
    /**
     * The Less or equals operation for the ranges.
     */
    LE = "LE",
    /**
     * The Less operation for the ranges.
     */
    LT = "LT",
    /**
     * The StartsWith operation for the ranges.
     */
    StartsWith = "StartsWith",
  }
  export default ValueHelpRangeOperation;
}

declare module "sap/zen/dsh/widgets/SDKModel" {
  import Model from "sap/ui/model/Model";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Model implementation for JSON format
   *
   * @deprecated As of version 1.89.0. Please use the WD Grid control instead.
   */
  export default class SDKModel extends Model {
    /**
     * Constructor for a new SDKModel.
     */
    constructor(
      /**
       * either the URL where to load the JSON from or a JS object
       */
      oData: object
    );

    /**
     * Creates a new subclass of class sap.zen.dsh.widgets.SDKModel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.model.Model.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SDKModel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.zen.dsh.widgets.SDKModel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/zen/dsh/AnalyticGrid": undefined;

    "sap/zen/dsh/Dsh": undefined;

    "sap/zen/dsh/library": undefined;

    "sap/zen/dsh/ValueHelpRangeOperation": undefined;

    "sap/zen/dsh/widgets/SDKModel": undefined;

    "sap/zen/dsh/widgets/ValueHelpDialog": undefined;
  }
}
