// For Library Version: 1.136.11

declare module "sap/ui/comp/library" {
  /**
   * Marker interface for SmartForm GroupElements.
   *
   * @since 1.88.0
   */
  export interface IFormGroupElement {
    __implements__sap_ui_comp_IFormGroupElement: boolean;
  }

  /**
   * Enumeration of text arrangement types.
   *
   * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'TextArrangementType'.
   *
   * @since 1.60
   */
  export enum TextArrangementType {
    /**
     * Text comes first, followed by the ID.
     */
    TextFirst = "com.sap.vocabularies.UI.v1.TextArrangementType/TextFirst",
    /**
     * ID comes first, followed by the description.
     */
    TextLast = "com.sap.vocabularies.UI.v1.TextArrangementType/TextLast",
    /**
     * Only description is represented, ID is hidden (for example, for `UUIDs`).
     */
    TextOnly = "com.sap.vocabularies.UI.v1.TextArrangementType/TextOnly",
    /**
     * ID and description are represented separately.
     */
    TextSeparate = "com.sap.vocabularies.UI.v1.TextArrangementType/TextSeparate",
  }

  export namespace navpopover {
    /**
     * Type of change handler type for link personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'navpopover.ChangeHandlerType'.
     */
    enum ChangeHandlerType {
      /**
       * Change handler creating a change for an added link.
       */
      addLink = "addLink",
      /**
       * Change handler creating a change for a moved link.
       */
      moveLink = "moveLink",
      /**
       * Change handler creating a change for a removed link.
       */
      removeLink = "removeLink",
    }
  }

  export namespace personalization {
    /**
     * Provides enumeration sap.ui.comp.personalization.AggregationRole. A subset of aggregation roles used
     * in table personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'personalization.AggregationRole'.
     */
    enum AggregationRole {
      /**
       * Dimension role.
       */
      Dimension = "Dimension",
      /**
       * Measure role.
       */
      Measure = "Measure",
      /**
       * Role which is neither dimension nor measure.
       */
      NotDimeasure = "NotDimeasure",
    }
    /**
     * Provides enumeration sap.ui.comp.personalization.ChangeType. A subset of changes done during table personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'personalization.ChangeType'.
     */
    enum ChangeType {
      /**
       * Change is applied to model but not applied to table
       */
      ModelChanged = "ModelChanged",
      /**
       * Change is applied to model and to table
       */
      TableChanged = "TableChanged",
      /**
       * Not changed
       */
      Unchanged = "Unchanged",
    }
    /**
     * Provides enumeration sap.ui.comp.personalization.ColumnType. A subset of column types that fit for table
     * personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'personalization.ColumnType'.
     */
    enum ColumnType {
      /**
       * Represents `sap.ui.comp.personalization.ColumnWrapper`.
       */
      ColumnWrapper = "ColumnWrapper",
      /**
       * Represents `sap.m.Column`.
       */
      ResponsiveColumn = "ResponsiveColumn",
      /**
       * Represents `sap.ui.table.Column`.
       */
      TableColumn = "TableColumn",
    }
    /**
     * Provides enumeration sap.ui.comp.personalization.ResetType. A subset of reset types used in table personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'personalization.ResetType'.
     */
    enum ResetType {
      /**
       * Reset back to Restore (i.e. the version of the table with which the controller was instantiated or via
       * setter updated) was triggered (either via API or via reset button)
       */
      ResetFull = "ResetFull",
      /**
       * Reset back to the CurrentVariant was triggered
       */
      ResetPartial = "ResetPartial",
    }
    /**
     * Provides enumeration sap.ui.comp.personalization.TableType. A subset of table types that fit for table
     * personalization.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'personalization.TableType'.
     */
    enum TableType {
      /**
       * Represents `sap.ui.table.AnalyticalTable`.
       */
      AnalyticalTable = "AnalyticalTable",
      /**
       * Represents `sap.ui.comp.personalization.ChartWrapper`.
       */
      ChartWrapper = "ChartWrapper",
      /**
       * Represents `sap.m.Table`.
       */
      ResponsiveTable = "ResponsiveTable",
      /**
       * Represents `sap.ui.comp.personalization.SelectionWrapper`.
       */
      SelectionWrapper = "SelectionWrapper",
      /**
       * Represents `sap.ui.table.Table`.
       */
      Table = "Table",
      /**
       * Represents `sap.ui.table.TreeTable`.
       */
      TreeTable = "TreeTable",
    }
  }

  export namespace smartchart {
    /**
     * Enumeration for supported selection mode in SmartChart
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartchart.SelectionMode'.
     */
    enum SelectionMode {
      /**
       * Multi selection mode, multiple sets of data points can be selected at once.
       */
      Multi = "MULTIPLE",
      /**
       * None selection mode, no data points can be selected.
       */
      None = "NONE",
      /**
       * Single selection mode, only one set of data points can be selected at once.
       */
      Single = "SINGLE",
    }
  }

  export namespace smartfield {
    /**
     * Enumeration of the different contexts supported by the SmartField, if it is using an OData model.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.ControlContextType'.
     */
    enum ControlContextType {
      /**
       * Behaves currently exactly like `sap.ui.comp.smartfield.ControlContextType.None`.
       */
      Form = "form",
      /**
       * No special context is selected. The Smart Field applies its internal defaults.
       */
      None = "",
      /**
       * Also the UoM layout is influenced.
       */
      ResponsiveTable = "responsiveTable",
      /**
       * If this is selected the UoM layout is influenced.
       */
      SmartFormGrid = "smartFormGrid",
      /**
       * If this is selected the UoM layout is influenced.
       */
      Table = "table",
    }
    /**
     * Enumeration of the different control proposals supported by the Smart Field, if it is using an OData
     * model.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.ControlProposalType'.
     */
    enum ControlProposalType {
      /**
       * No special context is selected. The Smart Field applies its internal defaults.
       */
      None = "",
      /**
       * If this is selected, the sap.m.ObjectIdentifier control is used to display IDs, if they are not editable.
       * The current OData property is assumed to have a text annotation. Otherwise the configuration is ignored.
       */
      ObjectIdentifier = "ObjectIdentifier",
      /**
       * If this is selected, the sap.m.ObjectNumber control is used to display units of measure. If the value
       * property of the Smart Field is not bound to a unit of measure, the property is ignored.
       */
      ObjectNumber = "ObjectNumber",
    }
    /**
     * The available control types to configure the internal control selection of a SmartField control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.ControlType'.
     */
    enum ControlType {
      /**
       * The `SmartField` control chooses the control to be displayed.
       */
      auto = "auto",
      /**
       * The `SmartField` control displays a check box control.
       */
      checkBox = "checkBox",
      /**
       * The `SmartField` control displays a date picker control.
       */
      datePicker = "datePicker",
      /**
       * The `SmartField` control displays a combo box control.
       */
      dropDownList = "dropDownList",
      /**
       * The `SmartField` control displays a text input field control.
       */
      input = "input",
      /**
       * The `SmartField` control displays a select control.
       */
      selection = "selection",
    }
    /**
     * The different options to visualize the ObjectStatus control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.CriticalityRepresentationType'.
     */
    enum CriticalityRepresentationType {
      /**
       * If this is selected, the sap.m.ObjectStatus control visualizes the criticality using an icon.
       */
      WithIcon = "WithIcon",
      /**
       * If this is selected, the sap.m.ObjectStatus control does not visualize the criticality using an icon.
       */
      WithoutIcon = "WithoutIcon",
    }
    /**
     * The different options to define display behavior for the value help of a SmartField control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.DisplayBehaviour'.
     */
    enum DisplayBehaviour {
      /**
       * The SmartField chooses the display behavior.
       */
      auto = "auto",
      /**
       * Description and ID are displayed for available values.
       */
      descriptionAndId = "descriptionAndId",
      /**
       * Only the description of the available values is displayed.
       */
      descriptionOnly = "descriptionOnly",
      /**
       * ID and description are displayed for available values.
       */
      idAndDescription = "idAndDescription",
      /**
       * Shows the ID only.
       */
      idOnly = "idOnly",
      /**
       * Shows Boolean value as On/Off
       */
      OnOff = "OnOff",
      /**
       * Shows Boolean value as True/False
       */
      TrueFalse = "TrueFalse",
      /**
       * Shows Boolean value as Yes/No
       */
      YesNo = "YesNo",
    }
    /**
     * Provides information about the importance of the field
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.Importance'.
     *
     * @since 1.87
     */
    enum Importance {
      /**
       * `SmartField` with high importance
       */
      High = "High",
      /**
       * `SmartField` with low importance
       */
      Low = "Low",
      /**
       * `SmartField` with medium importance
       */
      Medium = "Medium",
    }
    /**
     * Enumeration of the different data types supported by the SmartField control, if it is using a JSON model.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.JSONType'.
     */
    enum JSONType {
      /**
       * Boolean Type
       */
      Boolean = "Boolean",
      /**
       * The JavaScript Date Object
       */
      Date = "Date",
      /**
       * Date Time Type
       */
      DateTime = "DateTime",
      /**
       * Float type
       */
      Float = "Float",
      /**
       * Integer type
       */
      Integer = "Integer",
      /**
       * The JavaScript primary type String
       */
      String = "String",
    }
    /**
     * Enumeration of sources from which text values for `Codes`/`IDs` are fetched in edit mode. The text is
     * usually visualized as description/text value for IDs, for example, for LT (Laptop).
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.TextInEditModeSource'.
     *
     * @since 1.54
     */
    enum TextInEditModeSource {
      /**
       * The text is fetched from the OData model property specified in the `Path` attribute of the `com.sap.vocabularies.Common.v1.Text`
       * annotation.
       */
      NavigationProperty = "NavigationProperty",
      /**
       * The `com.sap.vocabularies.UI.v1.TextArrangement` annotation and the value of the `displayBehaviour` property
       * of the `configuration` aggregation are not evaluated.
       */
      None = "None",
      /**
       * The text is fetched from the OData model property specified in the `Path` attribute of the `com.sap.vocabularies.Common.v1.Text`
       * annotation of the associated value list entity.
       */
      ValueList = "ValueList",
      /**
       * The text is fetched from the OData model property specified in the `Path` attribute of the `com.sap.vocabularies.Common.v1.Text`
       * annotation. Could be a value which is not included in the associated value list entity.
       *
       * **Note** Note that a scenario where more than one `SmartField` is bound to the same property could raise
       * a performance issue depending on the number of the smart fields.
       */
      ValueListNoValidation = "ValueListNoValidation",
      /**
       * The same behavior as ValueListNoValidation but for values that are considered invalid a warning message
       * will be created.
       *
       * NOTE: In this mode when the value is sent to the backend there might be 2 messages for the same field
       * from both frontend and backend validation.
       */
      ValueListWarning = "ValueListWarning",
    }
    /**
     * Provides information about the ValueHelpTitleSource of the field
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfield.ValueHelpTitleSource'.
     *
     * @since 1.132
     */
    enum ValueHelpTitleSource {
      /**
       * `SmartField` with Property ValueHelpTitleSource
       */
      Property = "Property",
      /**
       * `SmartField` with ValueList ValueHelpTitleSource
       */
      ValueList = "ValueList",
    }
  }

  export namespace smartfilterbar {
    /**
     * The available control types to configure the internal control selection of a SmartFilterBar control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfilterbar.ControlType'.
     */
    enum ControlType {
      /**
       * Shows field based on metadata.
       */
      auto = "auto",
      /**
       * Shows a date picker field.
       */
      date = "date",
      /**
       * Shows a date time picker field.
       */
      dateTimePicker = "dateTimePicker",
      /**
       * Shows a drop down list field.
       */
      dropDownList = "dropDownList",
      /**
       * Shows an input field.
       */
      input = "input",
    }
    /**
     * The different options to define display behavior for fields in the SmartFilter control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfilterbar.DisplayBehaviour'.
     */
    enum DisplayBehaviour {
      /**
       * Shows values based on metadata.
       */
      auto = "auto",
      /**
       * Shows description and then an id in values.
       */
      descriptionAndId = "descriptionAndId",
      /**
       * Shows only the description for values.
       */
      descriptionOnly = "descriptionOnly",
      /**
       * Shows id and then a description in values.
       */
      idAndDescription = "idAndDescription",
      /**
       * Shows only the id for values.
       */
      idOnly = "idOnly",
    }
    /**
     * The available filter types to configure the internal control of a SmartFilterBar control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfilterbar.FilterType'.
     */
    enum FilterType {
      /**
       * Restrict filter based on metadata.
       */
      auto = "auto",
      /**
       * Restrict filter to an interval.
       */
      interval = "interval",
      /**
       * Restrict filter to multiple entries.
       */
      multiple = "multiple",
      /**
       * Restrict filter to be used as first operand in startswith, endswith, and contains clauses.
       *
       * @since 1.107
       */
      searchExpression = "searchExpression",
      /**
       * Restrict filter to a single entry.
       */
      single = "single",
    }
    /**
     * The different options to define mandatory state for fields in the SmartFilter control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfilterbar.MandatoryType'.
     */
    enum MandatoryType {
      /**
       * Shows values based on metadata.
       */
      auto = "auto",
      /**
       * Shows field as mandatory.
       */
      mandatory = "mandatory",
      /**
       * Shows field as not mandatory.
       */
      notMandatory = "notMandatory",
    }
    /**
     * The different options to define Sign for Select Options used in SmartFilter control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartfilterbar.SelectOptionSign'.
     */
    enum SelectOptionSign {
      /**
       * Sign Exclude
       */
      E = "E",
      /**
       * Sign Exclude
       */
      exclude = "E",
      /**
       * Sign Include
       */
      I = "I",
      /**
       * Sign Include
       */
      include = "I",
    }
  }

  export namespace smartform {
    /**
     * Marker interface for SmartForm layouts.
     *
     * @since 1.56.0
     */
    interface SmartFormLayout {
      __implements__sap_ui_comp_smartform_SmartFormLayout: boolean;
    }

    /**
     * Enumeration of SmartForm Importance types
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartform.Importance'.
     *
     * @since 1.87
     */
    enum Importance {
      /**
       * Shows fields that are annotated with UI.ImportanceType/High or have importance property set to High
       */
      High = "High",
      /**
       * Shows all fields
       */
      Low = "Low",
      /**
       * Shows fields that are annotated with `UI.ImportanceType/Medium` or `UI.ImportanceType/High` or have the
       * `importance` property set to `medium` or `high`.
       */
      Medium = "Medium",
    }
    /**
     * Enumeration of SmartForm validation mode.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartform.SmartFormValidationMode'.
     *
     * @since 1.81
     */
    enum SmartFormValidationMode {
      /**
       * Async validation mode. This mode handles all types of `SmartField` controls both with sync and async
       * validation.
       *
       * Note: This is the recommended validation mode.
       */
      Async = "Async",
      /**
       * Standard validation mode which handles the validation only of nested `SmartField` with synchronous validation.
       */
      Standard = "Standard",
    }
  }

  export namespace smartlist {
    /**
     * Provides enumeration sap.ui.comp.smartlist.ListType. A subset of list types that fit to a simple API
     * returning one string.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartlist.ListType'.
     *
     * @since 1.48
     */
    enum ListType {
      /**
       * A list (sap.m.List) control shall be created as the content of the SmartList, if no list already exists
       * (default)
       */
      List = "List",
      /**
       * A tree (sap.m.Tree) control shall be created as the content of the SmartList, if no list/tree already
       * exists
       */
      Tree = "Tree",
    }
  }

  export namespace smarttable {
    /**
     * Provides the type of services available for export in the `SmartTable` control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smarttable.ExportType'.
     */
    enum ExportType {
      /**
       * Gateway backend spreadsheet export service is used
       *
       * @deprecated As of version 1.120.
       */
      GW = "GW",
      /**
       * UI5 client-side spreadsheet export service is used
       */
      UI5Client = "UI5Client",
      /**
       * UI5 client-side spreadsheet export service is used along with Gateway backend PDF export service.
       *
       * @since 1.100
       */
      UI5ClientPDF = "UI5ClientPDF",
    }
    /**
     * Enumeration `sap.ui.comp.smarttable.InfoToolbarBehavior` determines the behavior of the info toolbar
     * in the `SmartTable` control.
     *
     * The info toolbar represents the filters that are applied using the table personalization dialog.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smarttable.InfoToolbarBehavior'.
     *
     * @since 1.70
     */
    enum InfoToolbarBehavior {
      /**
       * The info toolbar is rendered for the `SmartTable` control of table type `ResponsiveTable` only.
       */
      Auto = "Auto",
      /**
       * The info toolbar is not rendered.
       */
      Off = "Off",
      /**
       * The info toolbar is rendered for the `SmartTable` control regardless of the table type.
       */
      On = "On",
    }
    /**
     * Provides enumeration sap.ui.comp.smarttable.TableType. A subset of table types that fit to a simple API
     * returning one string.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smarttable.TableType'.
     */
    enum TableType {
      /**
       * An analytical table (sap.ui.table.AnalyticalTable) control shall be created as the content of the SmartTable,
       * if no table already exists
       */
      AnalyticalTable = "AnalyticalTable",
      /**
       * A responsive table (sap.m.Table) control that can be used on mobile devices shall be created as the content
       * of the SmartTable, if no table already exists
       */
      ResponsiveTable = "ResponsiveTable",
      /**
       * A table (sap.ui.table.Table) control shall be created as the content of the SmartTable, if no table already
       * exists (default)
       */
      Table = "Table",
      /**
       * A tree table (sap.ui.table.TreeTable) control shall be created as the content of the SmartTable, if no
       * table already exists
       */
      TreeTable = "TreeTable",
    }
  }

  export namespace smartvariants {
    /**
     * Enumeration for changes for personalization of variant favorites.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'smartvariants.ChangeHandlerType'.
     */
    enum ChangeHandlerType {
      /**
       * Change handler creating a change for an added favorite.
       */
      addFavorite = "addFavorite",
      /**
       * Change handler creating a change for a removed favorite.
       */
      removeFavorite = "removeFavorite",
    }
  }

  export namespace valuehelpdialog {
    /**
     * The range operations supported by the `ValueHelpDialog` control.
     *
     * This enum is part of the 'sap/ui/comp/library' module export and must be accessed by the property 'valuehelpdialog.ValueHelpRangeOperation'.
     */
    enum ValueHelpRangeOperation {
      /**
       * The Between operation for the ranges.
       */
      BT = "BT",
      /**
       * The Contains operation for the ranges.
       */
      Contains = "Contains",
      /**
       * The EndsWith operation for the ranges.
       */
      EndsWith = "EndsWith",
      /**
       * The Equals operation for the ranges.
       */
      EQ = "EQ",
      /**
       * The Between or equals operation for the ranges.
       */
      GE = "GE",
      /**
       * The Greater operation for the ranges.
       */
      GT = "GT",
      /**
       * The Less or equals operation for the ranges.
       */
      LE = "LE",
      /**
       * The Less operation for the ranges.
       */
      LT = "LT",
      /**
       * The StartsWith operation for the ranges.
       */
      StartsWith = "StartsWith",
    }
  }
}

declare module "sap/ui/comp/config/ControlConfigurationBase" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * An abstract class for configuration of filters in the smart filter bar or in the smart table
   *
   * @since 1.126.0
   */
  export default class ControlConfigurationBase extends UI5Element {
    /**
     * Constructor for a new `ControlConfigurationBase`
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlConfigurationBaseSettings
    );
    /**
     * Constructor for a new `ControlConfigurationBase`
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlConfigurationBaseSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.config.ControlConfigurationBase with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ControlConfigurationBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.config.ControlConfigurationBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getConditionType conditionType}.
     *
     * The `conditionType` class name to be used for this filter item. Implementation should derive from sap.ui.comp.config.condition.Type
     *
     *
     * @returns Value of property `conditionType`
     */
    getConditionType(): any;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * The `key` property corresponds to the field name from the OData service $metadata document.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Sets a new value for property {@link #getConditionType conditionType}.
     *
     * The `conditionType` class name to be used for this filter item. Implementation should derive from sap.ui.comp.config.condition.Type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConditionType(
      /**
       * New value for property `conditionType`
       */
      oConditionType?: any
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * The `key` property corresponds to the field name from the OData service $metadata document.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ControlConfigurationBase constructor.
   */
  export interface $ControlConfigurationBaseSettings extends $ElementSettings {
    /**
     * The `key` property corresponds to the field name from the OData service $metadata document.
     */
    key?: string | PropertyBindingInfo;

    /**
     * The `conditionType` class name to be used for this filter item. Implementation should derive from sap.ui.comp.config.condition.Type
     */
    conditionType?: any | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/config/FilterControlConfiguration" {
  import {
    default as ControlConfigurationBase,
    $ControlConfigurationBaseSettings,
  } from "sap/ui/comp/config/ControlConfigurationBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The `FilterControlConfiguration` can be used to generate the dynamic date range control used for filtering
   * the smart table.
   *
   * @since 1.126.0
   */
  export default class FilterControlConfiguration extends ControlConfigurationBase {
    /**
     * Constructor for a new `FilterControlConfiguration`
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.config.ControlConfigurationBase#constructor sap.ui.comp.config.ControlConfigurationBase }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FilterControlConfigurationSettings
    );
    /**
     * Constructor for a new `FilterControlConfiguration`
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.config.ControlConfigurationBase#constructor sap.ui.comp.config.ControlConfigurationBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FilterControlConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.config.FilterControlConfiguration with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.config.ControlConfigurationBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterControlConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.config.FilterControlConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the FilterControlConfiguration constructor.
   */
  export interface $FilterControlConfigurationSettings
    extends $ControlConfigurationBaseSettings {}
}

declare module "sap/ui/comp/filterbar/FilterBar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import FilterGroupItem from "sap/ui/comp/filterbar/FilterGroupItem";

  import SegmentedButtonItem from "sap/m/SegmentedButtonItem";

  import FilterItem from "sap/ui/comp/filterbar/FilterItem";

  import Event from "sap/ui/base/Event";

  import Label from "sap/m/Label";

  import { ID, TitleLevel } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import UIState from "sap/ui/comp/state/UIState";

  import VariantManagement from "sap/ui/comp/variants/VariantManagement";

  import SearchField from "sap/m/SearchField";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The `FilterBar` displays filters in a user-friendly manner to populate values for a query. The `FilterBar`
   * consists of a row containing the {@link sap.ui.comp.smartvariants.SmartVariantManagementUi2 `SmartVariantManagementUi2` }
   * control, the related buttons, and an area underneath displaying the filters.
   *
   * The filters are arranged in a logical row that is divided depending on the space available and the width
   * of the filters. The area containing the filters can be hidden or shown using the **Hide FilterBar** /
   * **Show FilterBar** button. The **Go** button triggers the search event, and the **Adapt Filters** button
   * shows the `Adapt Filters Dialog`.
   *
   * In this dialog, the user has full control over the `FilterBar`.
   */
  export default class FilterBar extends Control {
    /**
     * Constructor for a new FilterBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/2ae520a67c44495ab5dbc69668c47a7f Filter Bar}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/filter-bar/ Filter Bar}
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FilterBarSettings
    );
    /**
     * Constructor for a new FilterBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/2ae520a67c44495ab5dbc69668c47a7f Filter Bar}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/filter-bar/ Filter Bar}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FilterBarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.filterbar.FilterBar with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.filterbar.FilterBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds a `FilterGroupItem` element to the aggregation `_parameters`.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to this in order to allow method chaining
     */
    _addParameter(
      /**
       * adding a analytical parameter
       */
      oParameter: FilterGroupItem
    ): this;
    /**
     * Checks if running on phone.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `True` if phone, `false` otherwise
     */
    _isPhone(): boolean;
    /**
     * Checks if running on tablet.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `True` if tablet, `false` otherwise
     */
    _isTablet(): boolean;
    /**
     * Retrieves the controls for all visible filters.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns all visible controls/filter name & controls
     */
    _retrieveCurrentSelectionSet(
      /**
       * determines the returning structure. Either list of controls, or list of filter name and control.
       */
      bWithName: boolean,
      /**
       * determines if parameters should be considered.
       */
      bConsiderParameters: boolean
    ): any[];
    /**
     * Updates the 'Filters'-button text with the count of filters with values
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _updateToolbarText(): void;
    /**
     * Enables to add application specific content as a custom view to the new adapt filters dialog.
     */
    addAdaptFilterDialogCustomContent(
      /**
       * the setting for the custom view
       */
      mCustomView: {
        /**
         * the custom button used in the view switch
         */
        item: SegmentedButtonItem;
        /**
         * the content displayed in the custom view
         */
        content: Control;
        /**
         * callback triggered by search - executed with the string as parameter
         */
        search?: Function;
        /**
         * callback triggered by the `Select` control in the header area - executed with the selected key as parameter
         */
        filterSelect?: Function;
        /**
         * callback triggered by selecting a view - executed with the key as parameter
         *
         * Note: This API is designed to fulfill the need of adding visual filters to "Adapt Filters" dialog so
         * applications can achieve the ALP scenario in free style. Other usages are not encouraged.
         */
        selectionChange?: Function;
      }
    ): void;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Enables to add application specific content to the filters dialog. If the content was not yet added it
     * will be added. The content will be set to visible, all other filters dialog content will be set to invisible.
     * Not implemented yet for the new Adapt Filters Dialog
     *
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns `oContent` added or `null` when filters dialog is not active
     */
    addFilterDialogContent(
      /**
       * to be added; if empty, nothing is inserted.
       */
      oContent: Control
    ): Control | null;
    /**
     * Adds some filterGroupItem to the aggregation {@link #getFilterGroupItems filterGroupItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFilterGroupItem(
      /**
       * The filterGroupItem to add; if empty, nothing is inserted
       */
      oFilterGroupItem: FilterGroupItem
    ): this;
    /**
     * Adds some filterItem to the aggregation {@link #getFilterItems filterItems}.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addFilterItem(
      /**
       * The filterItem to add; if empty, nothing is inserted
       */
      oFilterItem: FilterItem
    ): this;
    /**
     * Applies the variant.
     */
    applyVariant(
      /**
       * JSON object
       */
      oVariant: Object,
      /**
       * Describes in which context the variant is applied. The context is passed on to the application via the
       * afterVariantLoad event
       */
      sContext: string,
      /**
       * indicates if the apply was executed during the initialization phase.
       */
      bInitial: boolean
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantLoad afterVariantLoad} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after a variant has been loaded and applied to the `FilterBar`. The event can be
     * used to adapt custom filters with data from the variant.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantLoad(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$AfterVariantLoadEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantLoad afterVariantLoad} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after a variant has been loaded and applied to the `FilterBar`. The event can be
     * used to adapt custom filters with data from the variant.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantLoad(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$AfterVariantLoadEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after a variant has been saved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantSave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after a variant has been saved.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantSave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:assignedFiltersChanged assignedFiltersChanged }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the filters information has changed. It indicates specifically that the count
     * of assigned filters may be changed. One of the intended reaction to this event would be to call `retrieveFiltersWithValuesAsText`
     * method.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAssignedFiltersChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:assignedFiltersChanged assignedFiltersChanged }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the filters information has changed. It indicates specifically that the count
     * of assigned filters may be changed. One of the intended reaction to this event would be to call `retrieveFiltersWithValuesAsText`
     * method.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAssignedFiltersChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeVariantFetch beforeVariantFetch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired before a variant is fetched.
     *
     * @since 1.28.13
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeVariantFetch(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeVariantFetch beforeVariantFetch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired before a variant is fetched.
     *
     * @since 1.28.13
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeVariantFetch(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeVariantSave beforeVariantSave} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired before a variant is saved. The event can be used to adapt the data of the custom
     * filters, which will be saved as variant later. **Note:** This event is not fired during key user adaptation
     * of the `FilterBar` right away. The variant is saved when the key user saves the draft. Therefore it's
     * recommended to use the `beforeVariantFetch` event to adapt the data of custom filters for key user scenarios.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeVariantSave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeVariantSaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeVariantSave beforeVariantSave} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired before a variant is saved. The event can be used to adapt the data of the custom
     * filters, which will be saved as variant later. **Note:** This event is not fired during key user adaptation
     * of the `FilterBar` right away. The variant is saved when the key user saves the draft. Therefore it's
     * recommended to use the `beforeVariantFetch` event to adapt the data of custom filters for key user scenarios.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeVariantSave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeVariantSaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Cancel button on the Filters dialog is pressed and the variant is marked
     * as dirty.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Cancel button on the Filters dialog is pressed and the variant is marked
     * as dirty.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:clear clear} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Clear button is pressed. The consumer has to clear all filters.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClear(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$ClearEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:clear clear} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Clear button is pressed. The consumer has to clear all filters.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClear(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$ClearEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filterChange filterChange} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when a filter or multiple filters has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFilterChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FilterChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filterChange filterChange} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when a filter or multiple filters has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFilterChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FilterChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogBeforeOpen filtersDialogBeforeOpen }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the filters dialog is opened.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogBeforeOpen filtersDialogBeforeOpen }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the filters dialog is opened.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogCancel filtersDialogCancel} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Cancel button on the filters dialog is pressed.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogCancel(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogCancel filtersDialogCancel} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Cancel button on the filters dialog is pressed.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogCancel(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogClosed filtersDialogClosed} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the filters dialog is closed.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogClosed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogClosedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogClosed filtersDialogClosed} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the filters dialog is closed.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogClosed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogClosedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogSearch filtersDialogSearch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Go button on the filters dialog is pressed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogSearch(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogSearch filtersDialogSearch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Go button on the filters dialog is pressed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogSearch(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogSearchForFilters filtersDialogSearchForFilters }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when search field of the filter dialog is changed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogSearchForFilters(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogSearchForFiltersEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:filtersDialogSearchForFilters filtersDialogSearchForFilters }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when search field of the filter dialog is changed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFiltersDialogSearchForFilters(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogSearchForFiltersEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the FilterBar is initialized to indicate that metadata are available.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the FilterBar is initialized to indicate that metadata are available.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the `FilterBar` has been initialized, the user's default variant has been applied,
     * and a stable filter state has been achieved. With this event all relevant filter information, for example,
     * for navigation-related actions, is available via {@link sap.ui.comp.filterbar.FilterBar#getUiState}.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired after the `FilterBar` has been initialized, the user's default variant has been applied,
     * and a stable filter state has been achieved. With this event all relevant filter information, for example,
     * for navigation-related actions, is available via {@link sap.ui.comp.filterbar.FilterBar#getUiState}.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:reset reset} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Restore button is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachReset(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$ResetEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:reset reset} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Restore button is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachReset(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$ResetEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:search search} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Go button is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearch(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$SearchEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:search search} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterBar` itself.
     *
     * This event is fired when the Go button is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearch(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterBar$SearchEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Resets the current selection in the variant management control to standard.
     */
    clearVariantSelection(): void;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys all the filterGroupItems in the aggregation {@link #getFilterGroupItems filterGroupItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFilterGroupItems(): this;
    /**
     * Destroys all the filterItems in the aggregation {@link #getFilterItems filterItems}.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFilterItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterVariantLoad afterVariantLoad} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterVariantLoad(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$AfterVariantLoadEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterVariantSave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:assignedFiltersChanged assignedFiltersChanged }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAssignedFiltersChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeVariantFetch beforeVariantFetch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.13
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeVariantFetch(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeVariantSave beforeVariantSave} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeVariantSave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$BeforeVariantSaveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancel cancel} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancel(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:clear clear} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClear(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$ClearEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filterChange filterChange} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFilterChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$FilterChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filtersDialogBeforeOpen filtersDialogBeforeOpen }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFiltersDialogBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filtersDialogCancel filtersDialogCancel} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFiltersDialogCancel(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filtersDialogClosed filtersDialogClosed} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFiltersDialogClosed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogClosedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filtersDialogSearch filtersDialogSearch} event
     * of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFiltersDialogSearch(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:filtersDialogSearchForFilters filtersDialogSearchForFilters }
     * event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFiltersDialogSearchForFilters(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$FiltersDialogSearchForFiltersEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialise initialise} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialise(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:reset reset} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachReset(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$ResetEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:search search} event of this `sap.ui.comp.filterbar.FilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSearch(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterBar$SearchEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Retrieves the control associated to the filter.
     *
     *
     * @returns The corresponding control. If no match is found `null` is returned.
     */
    determineControlByFilterItem(
      /**
       * From the aggregations
       */
      oFilterItem: FilterItem,
      /**
       * check also analytics parameter
       */
      bConsiderParameters: boolean
    ): Control;
    /**
     * Retrieves the control based on the name and group name.
     *
     *
     * @returns The corresponding control, if no match is found, `null` is returned.
     */
    determineControlByName(
      /**
       * Name of the filter.
       */
      sName: string,
      /**
       * Group name of the filter; `null` for filter that belongs to basic group.
       */
      sGroupName?: string
    ): Control;
    /**
     * Retrieves the filter corresponding to the filter name.
     *
     *
     * @returns the corresponding filter item. If no match is found `null` will returned.
     */
    determineFilterItemByName(
      /**
       * the control's name
       */
      sName: string,
      /**
       * the filter's group name
       */
      sGroupName: string
    ): FilterGroupItem;
    /**
     * Retrieves the associated label based on the name and group name.
     *
     *
     * @returns The associated Label, if no match is found, `null` is returned.
     */
    determineLabelByName(
      /**
       * Name of the filter.
       */
      sName: string,
      /**
       * Group name of the filter; `null` for filter that belongs to basic group.
       */
      sGroupName: string
    ): Label;
    /**
     * Retrieves the mandatory filters.
     *
     *
     * @returns Of visible mandatory filters
     */
    determineMandatoryFilterItems(): any[];
    /**
     * Creates and returns the variant representation.
     *
     *
     * @returns An arbitrary Object with an example structure:
     *
     * ```javascript
     * {
     *   filterBarVariant: any,
     *   filterbar: [
     *     {
     *       group: string,
     *       name: string,
     *       partOfCurrentVariant: boolean,
     *       visible: boolean,
     *       visibleInFilterBar: boolean
     *     },
     *     ...
     *   ],
     *   orderedFilterItems: string,
     *   singleInputsTextArrangementData: string,
     *   version: string|undefined,
     *   basicSearch: string|undefined
     * }```
     */
    fetchVariant(): fetchVariantResponse;
    /**
     * Fires event {@link #event:afterVariantSave afterVariantSave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterVariantSave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:assignedFiltersChanged assignedFiltersChanged} to attached listeners.
     *
     * @since 1.38.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAssignedFiltersChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeVariantFetch beforeVariantFetch} to attached listeners.
     *
     * @since 1.28.13
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeVariantFetch(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:cancel cancel} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancel(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:clear clear} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClear(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$ClearEventParameters
    ): this;
    /**
     * Fires event {@link #event:filterChange filterChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFilterChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$FilterChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:filtersDialogBeforeOpen filtersDialogBeforeOpen} to attached listeners.
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFiltersDialogBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:filtersDialogCancel filtersDialogCancel} to attached listeners.
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFiltersDialogCancel(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:filtersDialogClosed filtersDialogClosed} to attached listeners.
     *
     * @since 1.34.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFiltersDialogClosed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$FiltersDialogClosedEventParameters
    ): this;
    /**
     * Fires event {@link #event:filtersDialogSearch filtersDialogSearch} to attached listeners.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFiltersDialogSearch(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:filtersDialogSearchForFilters filtersDialogSearchForFilters} to attached listeners.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFiltersDialogSearchForFilters(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$FiltersDialogSearchForFiltersEventParameters
    ): this;
    /**
     * Fires event {@link #event:initialise initialise} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialise(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @since 1.38.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:reset reset} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireReset(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$ResetEventParameters
    ): this;
    /**
     * Fires event {@link #event:search search} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSearch(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterBar$SearchEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAdvancedMode advancedMode}.
     *
     * The advanced mode is only relevant for the value help scenario. UI representation is different from the
     * standard FilterBar.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `advancedMode`
     */
    getAdvancedMode(): boolean;
    /**
     * Retrieves filters belonging to the current variant.
     *
     *
     * @returns filters Of the current variant
     */
    getAllFilterItems(
      /**
       * Indicates that only visible filters are retrieved. **Note:** hidden filters are treated as visible filters.
       */
      bConsiderOnlyVisibleFields: boolean
    ): any[];
    /**
     * ID of the element which is the current target of the association {@link #getBasicSearch basicSearch},
     * or `null`.
     *
     * @since 1.30.0
     */
    getBasicSearch(): ID | null;
    /**
     * Determine the internal basic search field name.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns name of the basic search field.
     */
    getBasicSearchName(): string;
    /**
     * Determine the value of the basic search.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns current value of the basic search field.
     */
    getBasicSearchValue(): string;
    /**
     * Gets current value of property {@link #getConsiderGroupTitle considerGroupTitle}.
     *
     * If this property is set, then the label for filters will be prefixed with the group title.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `considerGroupTitle`
     */
    getConsiderGroupTitle(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Do NOT use this aggregation directly. The `FilterBar` control is not meant to be used with arbitrary
     * content. It renders filterFields which are added by `filterGroupItems` aggregation. If you need to add
     * some content below the `FilterBar`, this can be done by adding it as sibling of the `FilterBar`. For
     * example, if `FilterBar` is child of `DynamicPageHeader`, the custom content can be added to the `DynamicPageHeader`
     * as well.
     *
     * @deprecated As of version 1.122. with no replacement.
     */
    getContent(): Control[];
    /**
     * Retrieves the current variant ID.
     *
     * @since 1.28.0
     *
     * @returns ID of the current variant
     */
    getCurrentVariantId(): string;
    /**
     * Retrieves the current variant as selection variant for UI navigation
     *
     * @since 1.28.0
     * @deprecated As of version 1.48. replaced by {@link sap.ui.comp.filterbar.FilterBar#getUiState}
     *
     * @returns JSON string representing the selection variant for UI navigation; `null` otherwise
     */
    getDataSuiteFormat(
      /**
       * also include empty/invisible fields filter data
       */
      bConsiderAllFilters: boolean
    ): string;
    /**
     * Gets current value of property {@link #getDeltaVariantMode deltaVariantMode}.
     *
     * Stores the delta as compared to the standard variant.
     *
     * Default value is `true`.
     *
     * @since 1.34.0
     *
     * @returns Value of property `deltaVariantMode`
     */
    getDeltaVariantMode(): boolean;
    /**
     * Reads the descriptions for given filters and value keys.
     *
     * @since 1.75
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getDescriptionForKeys(
      /**
       * List of filters with value keys to be retrieved
       */
      aFiltersWithValuesToBeRead: any[]
    ): void;
    /**
     * Gets current value of property {@link #getDisableSearchMatchesPatternWarning disableSearchMatchesPatternWarning}.
     *
     * Disables the warning for special symbols.
     *
     * **Note:** Changing the values here after the SmartFilter is initialized (`initialise` event was fired)
     * has no effect.
     *
     * Default value is `false`.
     *
     * @since 1.102
     *
     * @returns Value of property `disableSearchMatchesPatternWarning`
     */
    getDisableSearchMatchesPatternWarning(): boolean;
    /**
     * Gets current value of property {@link #getFilterBarExpanded filterBarExpanded}.
     *
     * Shows the filters area. When property `useToolbar` is set to `false`, `filterBarExpanded` is ignored
     * automatically and the `FilterBar` is always expanded. **Note:** When `SmartFilterBar` is used inside
     * a `ValueHelpDialog`, it is initially collapsed. The filter bar is initially expanded in the following
     * cases:
     *
     * - When there is no basic search field.
     *
     * - When `preventInitialDataFetchInValueHelpDialog` is set to `true` or the `fetchValues` property of the
     *     `valueList` annotation is set to `2`.
     *
     * - When there are mandatory fields, all fields are expanded (not only the first 7).
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     *
     * @returns Value of property `filterBarExpanded`
     */
    getFilterBarExpanded(): boolean;
    /**
     * Gets current value of property {@link #getFilterContainerWidth filterContainerWidth}.
     *
     * Sets the width of the filters container.
     *
     * Default value is `"12rem"`.
     *
     * @since 1.34.0
     *
     * @returns Value of property `filterContainerWidth`
     */
    getFilterContainerWidth(): string;
    /**
     * Returns the filter dialog content. `Node:`The original content is a {@link sap.ui.layout.form.Form Form}.
     * The form may be enhanced with a toolbar to enable the inner switch to an added custom content. Besides
     * such operations, the original content should not be manipulated in any way.
     *
     * @deprecated As of version 1.84. with no replacement.
     *
     * @returns of filters dialog content.
     */
    getFilterDialogContent(): any[];
    /**
     * Gets content of aggregation {@link #getFilterGroupItems filterGroupItems}.
     *
     * Contains all FilterBar filters.
     *  `Note:`In case a filter has to be added to the basic group
     * 	 - the property `groupName` has to be set to the constant `sap.ui.comp.filterbar.FilterBar.INTERNAL_GROUP`
     *
     * 	 - the property `groupLabel` will be handled internally and will be ignored, if set
     * 	 - the property `partOfCurrentVariant` has to be set to `true`
     * 	 - if the property `visibleInFilterBar` is set to `true`, the property `partOfCurrentVariant` will be
     *     set internally also to `true`
     */
    getFilterGroupItems(): FilterGroupItem[];
    /**
     * Gets content of aggregation {@link #getFilterItems filterItems}.
     *
     * Filters belonging to the basic group.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     */
    getFilterItems(): FilterItem[];
    /**
     * Gets current value of property {@link #getHeader header}.
     *
     * Specifies header text that is shown in the toolbar on the first position. This property is ignored, when
     * `useToolbar` is set to `false`.
     *
     * Default value is `empty string`.
     *
     * @since 1.38.0
     *
     * @returns Value of property `header`
     */
    getHeader(): string;
    /**
     * Gets current value of property {@link #getHeaderLevel headerLevel}.
     *
     * Specifies the semantic header level of the {@link #getHeader header} text property. For more information,
     * see {@link sap.m.Title#setLevel}. This property is ignored, when `useToolbar` is set to `false`.
     *
     * Default value is `Auto`.
     *
     * @since 1.121
     *
     * @returns Value of property `headerLevel`
     */
    getHeaderLevel(): TitleLevel;
    /**
     * Returns promise which will be resolve when the initialized event is fired.
     */
    getInitializedPromise(): Promise<undefined>;
    /**
     * Gets current value of property {@link #getIsRunningInValueHelpDialog isRunningInValueHelpDialog}.
     *
     * Sets whether the filter bar should look like the filters area in a ValueHelpDialog. True for SmartFilterBar
     * when used in a ValueHelpDialog. False otherwise.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `isRunningInValueHelpDialog`
     */
    getIsRunningInValueHelpDialog(): boolean;
    /**
     * Gets current value of property {@link #getPersistencyKey persistencyKey}.
     *
     * Key used to access personalization data. Only if the persistencyKey is provided, will the `VariantManagement`
     * control be used.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `persistencyKey`
     */
    getPersistencyKey(): string;
    /**
     * Gets current value of property {@link #getSearchEnabled searchEnabled}.
     *
     * Enables/disables the Search button.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.32.0. with no replacement.
     *
     * @returns Value of property `searchEnabled`
     */
    getSearchEnabled(): boolean;
    /**
     * Gets current value of property {@link #getShowAllFilters showAllFilters}.
     *
     * If set to `true`, when the `FilterBar` is expanded it will show all filters, not only the first 7.
     *
     * **Note:** This is valid only when the `FilterBar` is used inside a `ValueHelpDialog`
     *
     * Default value is `false`.
     *
     * @since 1.116.0
     *
     * @returns Value of property `showAllFilters`
     */
    getShowAllFilters(): boolean;
    /**
     * Gets current value of property {@link #getShowClearButton showClearButton}.
     *
     * Handles visibility of the Clear button on the Filters dialog.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.84. with no replacement. Users can select any Variant instead.
     *
     * @returns Value of property `showClearButton`
     */
    getShowClearButton(): boolean;
    /**
     * Gets current value of property {@link #getShowClearOnFB showClearOnFB}.
     *
     * Handles visibility of the Clear button on the FilterBar.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `showClearOnFB`
     */
    getShowClearOnFB(): boolean;
    /**
     * Gets current value of property {@link #getShowFilterConfiguration showFilterConfiguration}.
     *
     * Handles visibility of the Filters button on the FilterBar.
     *
     * Default value is `true`.
     *
     * @since 1.38.0
     *
     * @returns Value of property `showFilterConfiguration`
     */
    getShowFilterConfiguration(): boolean;
    /**
     * Gets current value of property {@link #getShowGoButton showGoButton}.
     *
     * Handles visibility of the Go button on the FilterBar.
     *
     * @since 1.26.1
     * @deprecated As of version 1.28.0. Replaced by property `showGoOnFB`
     *
     * @returns Value of property `showGoButton`
     */
    getShowGoButton(): boolean;
    /**
     * Gets current value of property {@link #getShowGoOnFB showGoOnFB}.
     *
     * Handles visibility of the Go button on the FilterBar.
     *
     * Default value is `true`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `showGoOnFB`
     */
    getShowGoOnFB(): boolean;
    /**
     * Gets current value of property {@link #getShowRestoreButton showRestoreButton}.
     *
     * Handles visibility of the "Restore" button on the "Filters" dialog. **Note:** Restore works only automatically
     * when a property `persistencyKey` is set and therefore Variant Management is used. In all other cases
     * the "restore" behavior needs to be implemented by the app, based on the event `reset`. Since 1.84 the
     * "Restore" button text is changed to "Reset"
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     *
     * @returns Value of property `showRestoreButton`
     */
    getShowRestoreButton(): boolean;
    /**
     * Gets current value of property {@link #getShowRestoreOnFB showRestoreOnFB}.
     *
     * Handles visibility of the Restore button on the FilterBar.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `showRestoreOnFB`
     */
    getShowRestoreOnFB(): boolean;
    /**
     * Retrieves the current UI state of the `FilterBar` control.
     *  The current UI state represents the data suite format.
     *
     * @since 1.48
     *
     * @returns object representing the ui-state. Currently only the SelectionVariant part is considered.
     */
    getUiState(
      /**
       * controls the API behavior
       */
      mProperties: {
        /**
         * include empty/invisible fields filter data
         */
        allFilters?: boolean;
      }
    ): UIState;
    /**
     * Gets current value of property {@link #getUseSnapshot useSnapshot}.
     *
     * Determines the behavior when `reset` is executed.
     *  **Note:** This property is only relevant if no variant management is used, and the filter bar is not
     * used in the advanced mode. A snapshot shows the current state of the filter bar, just before the Filters
     * dialog is opened.
     * 	 - `undefined` (default) defines the standard behavior: snapshot will be applied after `reset` was triggered
     *
     * 	 - `false` defines that the snapshot will not be applied
     * 	 - `true`is not considered at all
     *
     * @since 1.44
     *
     * @returns Value of property `useSnapshot`
     */
    getUseSnapshot(): boolean;
    /**
     * Gets current value of property {@link #getUseToolbar useToolbar}.
     *
     * Determines what design is used. Default is the design with toolbar. If the property `useToolbar` is set
     * to `false`, the property `filterBarExpanded` is ignored automatically and the `FilterBar` is always expanded.
     * **Note:**
     *  If set to `false`, the `VariantManagement` control is not available at all. This scenario is only intended
     * for the {@link sap.ui.comp.smartfilterbar.SmartFilterBar}.
     *
     * Default value is `true`.
     *
     * @since 1.38.0
     *
     * @returns Value of property `useToolbar`
     */
    getUseToolbar(): boolean;
    /**
     * Returns the associated VariantManagement control. The returned VariantManagement instance should not
     * be cached or manipulated in any ways. It should offer the application a convenient way to verify the
     * dirty state and to check for page variant scenario. The method may return `null` or a disabled VariantManagement
     * control.
     *
     * @since 1.44.0
     *
     * @returns the associated VariantManagement control.
     */
    getVariantManagement(): null | VariantManagement;
    /**
     * Hides the Go button on FilterBar. Allows to hide the Go-button for dedicated scenarios, like liveMode.
     *
     * @since 1.40.4
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    hideGoButton(): void;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.comp.filterbar.FilterGroupItem` in the aggregation {@link #getFilterGroupItems filterGroupItems}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFilterGroupItem(
      /**
       * The filterGroupItem whose index is looked for
       */
      oFilterGroupItem: FilterGroupItem
    ): int;
    /**
     * Checks for the provided `sap.ui.comp.filterbar.FilterItem` in the aggregation {@link #getFilterItems filterItems}.
     * and returns its index if found or -1 otherwise.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfFilterItem(
      /**
       * The filterItem whose index is looked for
       */
      oFilterItem: FilterItem
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Returns the information whether the flag 'executeOnSelect' is set or not on current variant.
     *
     *
     * @returns Flag 'executeOnSelect' flag. If variant management is disabled `false` is returned.
     */
    isCurrentVariantExecuteOnSelectEnabled(): boolean;
    /**
     * Determines if the current variant is the standard variant
     *
     * @since 1.44.0
     *
     * @returns indicates if the current variant is the standard variant. In case the variant management does
     * not exists, `undefined` is returned.
     */
    isCurrentVariantStandard(): boolean | undefined;
    /**
     * Determines if the filters dialog is opened.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns State of filters dialog
     */
    isDialogOpen(): boolean;
    /**
     * Registration of a callback function. The provided callback function is executed when a variant must be
     * applied. The callback function will receive the corresponding data set containing all relevant data in
     * JSON, as initially provided by the callback for fetchData.
     *
     *
     * @returns Returns `this` to allow method chaining.
     */
    registerApplyData(
      /**
       * Called when a variant must be applied
       */
      fCallBack: (p1: string, p2: string) => void
    ): this;
    /**
     * Registration of a callback function. The provided callback function is executed when saving a variant
     * is triggered and must provide all relevant fields and values in JSON.
     *
     *
     * @returns Returns `this` to allow method chaining.
     */
    registerFetchData(
      /**
       * Called when a variant must be fetched
       */
      fCallBack: (p1: string) => void
    ): this;
    /**
     * Registration of a callback function. The provided callback function is executed to obtain the filters
     * with values.
     *
     * @since 1.26.1
     *
     * @returns Reference to this in order to allow method chaining.
     */
    registerGetFiltersWithValues(
      /**
       * Called when a variant must be applied
       */
      fCallBack: /* was: sap.ui.comp.filterbar.FilterBar.fGetFiltersWithValuesCallBack */ any
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes all entries in the aggregation filterGroupItems.
     *
     *
     * @returns An array of the removed elements (might be empty).
     */
    removeAllFilterGroupItems(): FilterGroupItem[];
    /**
     * Removes all entries in the aggregation filterItems.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     *
     * @returns An array of the removed elements (might be empty).
     */
    removeAllFilterItems(): FilterItem[];
    /**
     * Removes all entries in the aggregations filterItems, filterGroupItems, basicSearch
     */
    removeAllFilters(): void;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     * @deprecated As of version 1.122. with no replacement.
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Removes a filterGroupItem from the aggregation {@link #getFilterGroupItems filterGroupItems}.
     *
     *
     * @returns The removed filterGroupItem or `null`
     */
    removeFilterGroupItem(
      /**
       * The filterGroupItem to remove or its index or id
       */
      vFilterGroupItem: int | string | FilterGroupItem
    ): FilterGroupItem | null;
    /**
     * Removes a filterItem from the aggregation {@link #getFilterItems filterItems}.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     *
     * @returns The removed filterItem or `null`
     */
    removeFilterItem(
      /**
       * The filterItem to remove or its index or id
       */
      vFilterItem: int | string | FilterItem
    ): FilterItem | null;
    /**
     * Restores the visibility of the Go button on FilterBar. The visibility of the Go button will be set, according
     * to the showGoOnFB property.
     *
     * @since 1.40.4
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    restoreGoButton(): void;
    /**
     * Retrieves the labels of all visible filters that belongs to the current variant and have an assigned
     * value.
     *
     *
     * @returns Filter labels that represents relevant filters with values
     */
    retrieveFiltersWithValues(): any[];
    /**
     * Returns a summary string that contains information about the filters currently assigned. The string starts
     * with the number of set filters, followed by "filters active" and their labels.
     *  Example:
     *  (3) filters active: Company Code, Fiscal Year, Customer
     *
     *
     * @returns A string that contains the number of set filters and their names
     */
    retrieveFiltersWithValuesAsText(): string;
    /**
     * Returns a summary string that contains information about the filters currently assigned. This string
     * is intended to be used in expanded state. The string starts with the total number of filters set, followed
     * by "filters active" and if available non-visible, the number of the non-visible with label "hidden" in
     * brackets.
     *  Example:
     *  (3) filters active (1 hidden)
     *
     *
     * @returns A string that contains the number of set filters and their names
     */
    retrieveFiltersWithValuesAsTextExpanded(): string;
    /**
     * Executes the search event. Controls of all visible filters will be passed as event-parameters.
     *
     *
     * @returns indicates the validation result. true means no validation errors.
     */
    search(): boolean;
    /**
     * Sets a new value for property {@link #getAdvancedMode advancedMode}.
     *
     * The advanced mode is only relevant for the value help scenario. UI representation is different from the
     * standard FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdvancedMode(
      /**
       * New value for property `advancedMode`
       */
      bAdvancedMode?: boolean
    ): this;
    /**
     * Sets the associated {@link #getBasicSearch basicSearch}.
     *
     * @since 1.30.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBasicSearch(
      /**
       * ID of an element which becomes the new target of this basicSearch association; alternatively, an element
       * instance may be given
       */
      oBasicSearch: ID | SearchField
    ): this;
    /**
     * Sets a new value for property {@link #getConsiderGroupTitle considerGroupTitle}.
     *
     * If this property is set, then the label for filters will be prefixed with the group title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConsiderGroupTitle(
      /**
       * New value for property `considerGroupTitle`
       */
      bConsiderGroupTitle?: boolean
    ): this;
    /**
     * Sets the height of the content area of the dialog. The passed dimension will be interpreted as 'px'.
     */
    setContentHeight(
      /**
       * the content height of the filters dialog.
       */
      fHeight: float
    ): void;
    /**
     * Sets the width of the content area of the dialog. The passed dimension will be interpreted as 'px'.
     */
    setContentWidth(
      /**
       * the content width of the filters dialog.
       */
      fWidth: float
    ): void;
    /**
     * Sets the current variant ID.
     *
     * @since 1.28.0
     */
    setCurrentVariantId(
      /**
       * ID of the variant
       */
      sVariantId: string,
      /**
       * If set to `true`, the `applyVariant` method is not executed yet. Relevant during navigation, when called
       * before the initialise event has been executed.
       */
      bDoNotApplyVariant: boolean
    ): void;
    /**
     * Sets the selection variant for UI navigation to FilterBar.
     *
     * @since 1.28.0
     * @deprecated As of version 1.48. replaced by {@link sap.ui.comp.filterbar.FilterBar#setUiState}
     */
    setDataSuiteFormat(
      /**
       * Represents the selection variants for UI navigation
       */
      sSuiteData: string,
      /**
       * Replaces existing filter data
       */
      bReplace: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getDeltaVariantMode deltaVariantMode}.
     *
     * Stores the delta as compared to the standard variant.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaVariantMode(
      /**
       * New value for property `deltaVariantMode`
       */
      bDeltaVariantMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDisableSearchMatchesPatternWarning disableSearchMatchesPatternWarning}.
     *
     * Disables the warning for special symbols.
     *
     * **Note:** Changing the values here after the SmartFilter is initialized (`initialise` event was fired)
     * has no effect.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.102
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisableSearchMatchesPatternWarning(
      /**
       * New value for property `disableSearchMatchesPatternWarning`
       */
      bDisableSearchMatchesPatternWarning?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFilterBarExpanded filterBarExpanded}.
     *
     * Shows the filters area. When property `useToolbar` is set to `false`, `filterBarExpanded` is ignored
     * automatically and the `FilterBar` is always expanded. **Note:** When `SmartFilterBar` is used inside
     * a `ValueHelpDialog`, it is initially collapsed. The filter bar is initially expanded in the following
     * cases:
     *
     * - When there is no basic search field.
     *
     * - When `preventInitialDataFetchInValueHelpDialog` is set to `true` or the `fetchValues` property of the
     *     `valueList` annotation is set to `2`.
     *
     * - When there are mandatory fields, all fields are expanded (not only the first 7).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterBarExpanded(
      /**
       * New value for property `filterBarExpanded`
       */
      bFilterBarExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFilterContainerWidth filterContainerWidth}.
     *
     * Sets the width of the filters container.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"12rem"`.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterContainerWidth(
      /**
       * New value for property `filterContainerWidth`
       */
      sFilterContainerWidth?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeader header}.
     *
     * Specifies header text that is shown in the toolbar on the first position. This property is ignored, when
     * `useToolbar` is set to `false`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeader(
      /**
       * New value for property `header`
       */
      sHeader?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderLevel headerLevel}.
     *
     * Specifies the semantic header level of the {@link #getHeader header} text property. For more information,
     * see {@link sap.m.Title#setLevel}. This property is ignored, when `useToolbar` is set to `false`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.121
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderLevel(
      /**
       * New value for property `headerLevel`
       */
      sHeaderLevel?: TitleLevel | keyof typeof TitleLevel
    ): this;
    /**
     * Sets a new value for property {@link #getIsRunningInValueHelpDialog isRunningInValueHelpDialog}.
     *
     * Sets whether the filter bar should look like the filters area in a ValueHelpDialog. True for SmartFilterBar
     * when used in a ValueHelpDialog. False otherwise.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsRunningInValueHelpDialog(
      /**
       * New value for property `isRunningInValueHelpDialog`
       */
      bIsRunningInValueHelpDialog?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPersistencyKey persistencyKey}.
     *
     * Key used to access personalization data. Only if the persistencyKey is provided, will the `VariantManagement`
     * control be used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPersistencyKey(
      /**
       * New value for property `persistencyKey`
       */
      sPersistencyKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSearchEnabled searchEnabled}.
     *
     * Enables/disables the Search button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.32.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSearchEnabled(
      /**
       * New value for property `searchEnabled`
       */
      bSearchEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowAllFilters showAllFilters}.
     *
     * If set to `true`, when the `FilterBar` is expanded it will show all filters, not only the first 7.
     *
     * **Note:** This is valid only when the `FilterBar` is used inside a `ValueHelpDialog`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.116.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowAllFilters(
      /**
       * New value for property `showAllFilters`
       */
      bShowAllFilters?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowClearButton showClearButton}.
     *
     * Handles visibility of the Clear button on the Filters dialog.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.84. with no replacement. Users can select any Variant instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowClearButton(
      /**
       * New value for property `showClearButton`
       */
      bShowClearButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowClearOnFB showClearOnFB}.
     *
     * Handles visibility of the Clear button on the FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowClearOnFB(
      /**
       * New value for property `showClearOnFB`
       */
      bShowClearOnFB?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowFilterConfiguration showFilterConfiguration}.
     *
     * Handles visibility of the Filters button on the FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFilterConfiguration(
      /**
       * New value for property `showFilterConfiguration`
       */
      bShowFilterConfiguration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowGoButton showGoButton}.
     *
     * Handles visibility of the Go button on the FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.26.1
     * @deprecated As of version 1.28.0. Replaced by property `showGoOnFB`
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowGoButton(
      /**
       * New value for property `showGoButton`
       */
      bShowGoButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowGoOnFB showGoOnFB}.
     *
     * Handles visibility of the Go button on the FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowGoOnFB(
      /**
       * New value for property `showGoOnFB`
       */
      bShowGoOnFB?: boolean
    ): this;
    /**
     * Once set, the activation of the 'Adapt Filters' button will open the 'old' filters dialog. This method
     * offers an intermediate solution for the visual filters scenario, which relies on the old filters dialog.
     *
     * @deprecated As of version 1.84. with no replacement.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setShowOldFilterDialog(): void;
    /**
     * Sets a new value for property {@link #getShowRestoreButton showRestoreButton}.
     *
     * Handles visibility of the "Restore" button on the "Filters" dialog. **Note:** Restore works only automatically
     * when a property `persistencyKey` is set and therefore Variant Management is used. In all other cases
     * the "restore" behavior needs to be implemented by the app, based on the event `reset`. Since 1.84 the
     * "Restore" button text is changed to "Reset"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRestoreButton(
      /**
       * New value for property `showRestoreButton`
       */
      bShowRestoreButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRestoreOnFB showRestoreOnFB}.
     *
     * Handles visibility of the Restore button on the FilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRestoreOnFB(
      /**
       * New value for property `showRestoreOnFB`
       */
      bShowRestoreOnFB?: boolean
    ): this;
    /**
     * Sets the current UI state of the `FilterBar` control.
     *  The current UI state represents the data suite format.
     *
     * @since 1.48
     */
    setUiState(
      /**
       * object representing the ui-state. Currently only the SelectionVariant part is considered.
       */
      oUiState: UIState,
      /**
       * controls the API behavior
       */
      mProperties: {
        /**
         * Replaces existing filter data
         */
        replace: boolean;
        /**
         * Determines filters and parameters based on the name.
         * 	 - `true`: Determines filters and parameters based on their exact name and type. If there is no exact
         *     match, the filter/parameter will be ignored.
         * 	 - `false`: Determines parameters first following this rule set:
         * 	If a parameter is found, use it.
         * 	 - If a filter is found, check first if a matching parameter exists with the filter name prefixed with
         *     "P_". If there is a match, use it as parameter, otherwise use it as filter.
         */
        strictMode: boolean;
      }
    ): void;
    /**
     * Apply the SelectionPresentationVariant annotated information as a variant. The current UI state represents
     * the data suite format.
     *
     * @since 1.54
     */
    setUiStateAsVariant(
      /**
       * object representing the ui-state.Only the SelectionVariant part is considered
       */
      oUiState: UIState,
      /**
       * Describes in which context the variant is applied. The context is passed on to the application via the
       * afterVariantLoad event
       */
      sContext: string
    ): void;
    /**
     * Sets a new value for property {@link #getUseSnapshot useSnapshot}.
     *
     * Determines the behavior when `reset` is executed.
     *  **Note:** This property is only relevant if no variant management is used, and the filter bar is not
     * used in the advanced mode. A snapshot shows the current state of the filter bar, just before the Filters
     * dialog is opened.
     * 	 - `undefined` (default) defines the standard behavior: snapshot will be applied after `reset` was triggered
     *
     * 	 - `false` defines that the snapshot will not be applied
     * 	 - `true`is not considered at all
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.44
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseSnapshot(
      /**
       * New value for property `useSnapshot`
       */
      bUseSnapshot: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseToolbar useToolbar}.
     *
     * Determines what design is used. Default is the design with toolbar. If the property `useToolbar` is set
     * to `false`, the property `filterBarExpanded` is ignored automatically and the `FilterBar` is always expanded.
     * **Note:**
     *  If set to `false`, the `VariantManagement` control is not available at all. This scenario is only intended
     * for the {@link sap.ui.comp.smartfilterbar.SmartFilterBar}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseToolbar(
      /**
       * New value for property `useToolbar`
       */
      bUseToolbar?: boolean
    ): this;
    /**
     * For backward compatibility. Creates adapt filters dialog
     */
    showFilterDialog(): void;
    /**
     * This method will be called by the SmartVariantMangement and indicates, that the standard variant was
     * obtained. It indicates, that the variant management is fully initialized.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    variantsInitialized(): void;
  }

  export type fetchVariantResponse = {
    filterBarVariant: string | Object;

    filterbar: Object;

    orderedFilterItems: string;

    singleInputsTextArrangementData: string;

    version: string | undefined;

    basicSearch: string | undefined;
  };

  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   */
  export interface $FilterBarSettings extends $ControlSettings {
    /**
     * Key used to access personalization data. Only if the persistencyKey is provided, will the `VariantManagement`
     * control be used.
     */
    persistencyKey?: string | PropertyBindingInfo;

    /**
     * The advanced mode is only relevant for the value help scenario. UI representation is different from the
     * standard FilterBar.
     */
    advancedMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Collapses/expands the advanced area.
     *
     * @deprecated As of version 1.30.0. Replaced by property `filterBarExpanded` This property is mapped to
     * the filterBarExpanded property.
     */
    expandAdvancedArea?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables/disables the Search button.
     *
     * @deprecated As of version 1.32.0. with no replacement.
     */
    searchEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Shows the filters area. When property `useToolbar` is set to `false`, `filterBarExpanded` is ignored
     * automatically and the `FilterBar` is always expanded. **Note:** When `SmartFilterBar` is used inside
     * a `ValueHelpDialog`, it is initially collapsed. The filter bar is initially expanded in the following
     * cases:
     *
     * - When there is no basic search field.
     *
     * - When `preventInitialDataFetchInValueHelpDialog` is set to `true` or the `fetchValues` property of the
     *     `valueList` annotation is set to `2`.
     *
     * - When there are mandatory fields, all fields are expanded (not only the first 7).
     *
     * @since 1.26.1
     */
    filterBarExpanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set, then the label for filters will be prefixed with the group title.
     *
     * @since 1.28.0
     */
    considerGroupTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, when the `FilterBar` is expanded it will show all filters, not only the first 7.
     *
     * **Note:** This is valid only when the `FilterBar` is used inside a `ValueHelpDialog`
     *
     * @since 1.116.0
     */
    showAllFilters?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the Clear button on the Filters dialog.
     *
     * @deprecated As of version 1.84. with no replacement. Users can select any Variant instead.
     */
    showClearButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the "Restore" button on the "Filters" dialog. **Note:** Restore works only automatically
     * when a property `persistencyKey` is set and therefore Variant Management is used. In all other cases
     * the "restore" behavior needs to be implemented by the app, based on the event `reset`. Since 1.84 the
     * "Restore" button text is changed to "Reset"
     *
     * @since 1.26.1
     */
    showRestoreButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the Go button on the FilterBar.
     *
     * @since 1.28.0
     */
    showGoOnFB?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the Restore button on the FilterBar.
     *
     * @since 1.28.0
     */
    showRestoreOnFB?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the Clear button on the FilterBar.
     *
     * @since 1.28.0
     */
    showClearOnFB?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Handles visibility of the Go button on the FilterBar.
     *
     * @since 1.26.1
     * @deprecated As of version 1.28.0. Replaced by property `showGoOnFB`
     */
    showGoButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Stores the delta as compared to the standard variant.
     *
     * @since 1.34.0
     */
    deltaVariantMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the width of the filters container.
     *
     * @since 1.34.0
     */
    filterContainerWidth?: string | PropertyBindingInfo;

    /**
     * Determines what design is used. Default is the design with toolbar. If the property `useToolbar` is set
     * to `false`, the property `filterBarExpanded` is ignored automatically and the `FilterBar` is always expanded.
     * **Note:**
     *  If set to `false`, the `VariantManagement` control is not available at all. This scenario is only intended
     * for the {@link sap.ui.comp.smartfilterbar.SmartFilterBar}.
     *
     * @since 1.38.0
     */
    useToolbar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies header text that is shown in the toolbar on the first position. This property is ignored, when
     * `useToolbar` is set to `false`.
     *
     * @since 1.38.0
     */
    header?: string | PropertyBindingInfo;

    /**
     * Handles visibility of the Filters button on the FilterBar.
     *
     * @since 1.38.0
     */
    showFilterConfiguration?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the behavior when `reset` is executed.
     *  **Note:** This property is only relevant if no variant management is used, and the filter bar is not
     * used in the advanced mode. A snapshot shows the current state of the filter bar, just before the Filters
     * dialog is opened.
     * 	 - `undefined` (default) defines the standard behavior: snapshot will be applied after `reset` was triggered
     *
     * 	 - `false` defines that the snapshot will not be applied
     * 	 - `true`is not considered at all
     *
     * @since 1.44
     */
    useSnapshot?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets whether the filter bar should look like the filters area in a ValueHelpDialog. True for SmartFilterBar
     * when used in a ValueHelpDialog. False otherwise.
     */
    isRunningInValueHelpDialog?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Disables the warning for special symbols.
     *
     * **Note:** Changing the values here after the SmartFilter is initialized (`initialise` event was fired)
     * has no effect.
     *
     * @since 1.102
     */
    disableSearchMatchesPatternWarning?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies the semantic header level of the {@link #getHeader header} text property. For more information,
     * see {@link sap.m.Title#setLevel}. This property is ignored, when `useToolbar` is set to `false`.
     *
     * @since 1.121
     */
    headerLevel?:
      | (TitleLevel | keyof typeof TitleLevel)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Filters belonging to the basic group.
     *
     * @deprecated As of version 1.48.0. Use aggregation `filterGroupItems` instead.
     */
    filterItems?:
      | FilterItem[]
      | FilterItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Contains all FilterBar filters.
     *  `Note:`In case a filter has to be added to the basic group
     * 	 - the property `groupName` has to be set to the constant `sap.ui.comp.filterbar.FilterBar.INTERNAL_GROUP`
     *
     * 	 - the property `groupLabel` will be handled internally and will be ignored, if set
     * 	 - the property `partOfCurrentVariant` has to be set to `true`
     * 	 - if the property `visibleInFilterBar` is set to `true`, the property `partOfCurrentVariant` will be
     *     set internally also to `true`
     */
    filterGroupItems?:
      | FilterGroupItem[]
      | FilterGroupItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Do NOT use this aggregation directly. The `FilterBar` control is not meant to be used with arbitrary
     * content. It renders filterFields which are added by `filterGroupItems` aggregation. If you need to add
     * some content below the `FilterBar`, this can be done by adding it as sibling of the `FilterBar`. For
     * example, if `FilterBar` is child of `DynamicPageHeader`, the custom content can be added to the `DynamicPageHeader`
     * as well.
     *
     * @deprecated As of version 1.122. with no replacement.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Populates the basic search area on the FilterBar and the Filters dialog.
     *
     * @since 1.30.0
     */
    basicSearch?: SearchField | string;

    /**
     * This event is fired when the Cancel button on the Filters dialog is pressed and the variant is marked
     * as dirty.
     */
    cancel?: (oEvent: Event) => void;

    /**
     * This event is fired when the Restore button is pressed.
     */
    reset?: (oEvent: FilterBar$ResetEvent) => void;

    /**
     * This event is fired when the Go button is pressed.
     */
    search?: (oEvent: FilterBar$SearchEvent) => void;

    /**
     * This event is fired before a variant is saved. The event can be used to adapt the data of the custom
     * filters, which will be saved as variant later. **Note:** This event is not fired during key user adaptation
     * of the `FilterBar` right away. The variant is saved when the key user saves the draft. Therefore it's
     * recommended to use the `beforeVariantFetch` event to adapt the data of custom filters for key user scenarios.
     */
    beforeVariantSave?: (oEvent: FilterBar$BeforeVariantSaveEvent) => void;

    /**
     * This event is fired before a variant is fetched.
     *
     * @since 1.28.13
     */
    beforeVariantFetch?: (oEvent: Event) => void;

    /**
     * This event is fired after a variant has been loaded and applied to the `FilterBar`. The event can be
     * used to adapt custom filters with data from the variant.
     */
    afterVariantLoad?: (oEvent: FilterBar$AfterVariantLoadEvent) => void;

    /**
     * This event is fired when a filter or multiple filters has changed.
     */
    filterChange?: (oEvent: FilterBar$FilterChangeEvent) => void;

    /**
     * This event is fired when the Clear button is pressed. The consumer has to clear all filters.
     */
    clear?: (oEvent: FilterBar$ClearEvent) => void;

    /**
     * This event is fired when the FilterBar is initialized to indicate that metadata are available.
     */
    initialise?: (oEvent: Event) => void;

    /**
     * This event is fired after the `FilterBar` has been initialized, the user's default variant has been applied,
     * and a stable filter state has been achieved. With this event all relevant filter information, for example,
     * for navigation-related actions, is available via {@link sap.ui.comp.filterbar.FilterBar#getUiState}.
     *
     * @since 1.38.0
     */
    initialized?: (oEvent: Event) => void;

    /**
     * This event is fired after a variant has been saved.
     */
    afterVariantSave?: (oEvent: Event) => void;

    /**
     * This event is fired after the filters dialog is closed.
     *
     * @since 1.34.0
     */
    filtersDialogClosed?: (oEvent: FilterBar$FiltersDialogClosedEvent) => void;

    /**
     * This event is fired after the filters dialog is opened.
     *
     * @since 1.48.0
     */
    filtersDialogBeforeOpen?: (oEvent: Event) => void;

    /**
     * This event is fired when the Go button on the filters dialog is pressed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     */
    filtersDialogSearch?: (oEvent: Event) => void;

    /**
     * This event is fired when the Cancel button on the filters dialog is pressed.
     *
     * @since 1.48.0
     */
    filtersDialogCancel?: (oEvent: Event) => void;

    /**
     * This event is fired when search field of the filter dialog is changed.
     *
     * @since 1.48.0
     * @deprecated As of version 1.84. with no replacement.
     */
    filtersDialogSearchForFilters?: (
      oEvent: FilterBar$FiltersDialogSearchForFiltersEvent
    ) => void;

    /**
     * This event is fired when the filters information has changed. It indicates specifically that the count
     * of assigned filters may be changed. One of the intended reaction to this event would be to call `retrieveFiltersWithValuesAsText`
     * method.
     *
     * @since 1.38.0
     */
    assignedFiltersChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FilterBar#afterVariantLoad event.
   */
  export interface FilterBar$AfterVariantLoadEventParameters {
    /**
     * Context of the event. Can also be `null` or `undefined`
     */
    context?: string;

    /**
     * executeOnSelect indicates if the variant will trigger search
     */
    executeOnSelect?: boolean;
  }

  /**
   * Event object of the FilterBar#afterVariantLoad event.
   */
  export type FilterBar$AfterVariantLoadEvent = Event<
    FilterBar$AfterVariantLoadEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#afterVariantSave event.
   */
  export interface FilterBar$AfterVariantSaveEventParameters {}

  /**
   * Event object of the FilterBar#afterVariantSave event.
   */
  export type FilterBar$AfterVariantSaveEvent = Event<
    FilterBar$AfterVariantSaveEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#assignedFiltersChanged event.
   */
  export interface FilterBar$AssignedFiltersChangedEventParameters {}

  /**
   * Event object of the FilterBar#assignedFiltersChanged event.
   */
  export type FilterBar$AssignedFiltersChangedEvent = Event<
    FilterBar$AssignedFiltersChangedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#beforeVariantFetch event.
   */
  export interface FilterBar$BeforeVariantFetchEventParameters {}

  /**
   * Event object of the FilterBar#beforeVariantFetch event.
   */
  export type FilterBar$BeforeVariantFetchEvent = Event<
    FilterBar$BeforeVariantFetchEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#beforeVariantSave event.
   */
  export interface FilterBar$BeforeVariantSaveEventParameters {
    /**
     * Context of the event. Can also be `null` or `undefined`
     */
    context?: string;
  }

  /**
   * Event object of the FilterBar#beforeVariantSave event.
   */
  export type FilterBar$BeforeVariantSaveEvent = Event<
    FilterBar$BeforeVariantSaveEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#cancel event.
   */
  export interface FilterBar$CancelEventParameters {}

  /**
   * Event object of the FilterBar#cancel event.
   */
  export type FilterBar$CancelEvent = Event<
    FilterBar$CancelEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#clear event.
   */
  export interface FilterBar$ClearEventParameters {
    /**
     * Visible controls
     */
    selectionSet?: Control[];
  }

  /**
   * Event object of the FilterBar#clear event.
   */
  export type FilterBar$ClearEvent = Event<
    FilterBar$ClearEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filterChange event.
   */
  export interface FilterBar$FilterChangeEventParameters {
    /**
     * This property is provided, whenever a filter is added via the add/remove filters dialog.
     */
    added?: Control;

    /**
     * This property is provided, whenever a filter is removed via the add/remove filters dialog.
     */
    deleted?: Control;

    /**
     * The filter item is only provided along with added or deleted properties.
     */
    filterItem?: FilterGroupItem;
  }

  /**
   * Event object of the FilterBar#filterChange event.
   */
  export type FilterBar$FilterChangeEvent = Event<
    FilterBar$FilterChangeEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filtersDialogBeforeOpen event.
   */
  export interface FilterBar$FiltersDialogBeforeOpenEventParameters {}

  /**
   * Event object of the FilterBar#filtersDialogBeforeOpen event.
   */
  export type FilterBar$FiltersDialogBeforeOpenEvent = Event<
    FilterBar$FiltersDialogBeforeOpenEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filtersDialogCancel event.
   */
  export interface FilterBar$FiltersDialogCancelEventParameters {}

  /**
   * Event object of the FilterBar#filtersDialogCancel event.
   */
  export type FilterBar$FiltersDialogCancelEvent = Event<
    FilterBar$FiltersDialogCancelEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filtersDialogClosed event.
   */
  export interface FilterBar$FiltersDialogClosedEventParameters {
    /**
     * Context of the event. Can also be `null` or `undefined`
     */
    context?: string;
  }

  /**
   * Event object of the FilterBar#filtersDialogClosed event.
   */
  export type FilterBar$FiltersDialogClosedEvent = Event<
    FilterBar$FiltersDialogClosedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filtersDialogSearch event.
   *
   * @deprecated As of version 1.84. with no replacement.
   */
  export interface FilterBar$FiltersDialogSearchEventParameters {}

  /**
   * Event object of the FilterBar#filtersDialogSearch event.
   *
   * @deprecated As of version 1.84. with no replacement.
   */
  export type FilterBar$FiltersDialogSearchEvent = Event<
    FilterBar$FiltersDialogSearchEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filtersDialogSearchForFilters event.
   *
   * @deprecated As of version 1.84. with no replacement.
   */
  export interface FilterBar$FiltersDialogSearchForFiltersEventParameters {
    /**
     * Contains the entered search filed value
     */
    newValue?: string;
  }

  /**
   * Event object of the FilterBar#filtersDialogSearchForFilters event.
   *
   * @deprecated As of version 1.84. with no replacement.
   */
  export type FilterBar$FiltersDialogSearchForFiltersEvent = Event<
    FilterBar$FiltersDialogSearchForFiltersEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#initialise event.
   */
  export interface FilterBar$InitialiseEventParameters {}

  /**
   * Event object of the FilterBar#initialise event.
   */
  export type FilterBar$InitialiseEvent = Event<
    FilterBar$InitialiseEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#initialized event.
   */
  export interface FilterBar$InitializedEventParameters {}

  /**
   * Event object of the FilterBar#initialized event.
   */
  export type FilterBar$InitializedEvent = Event<
    FilterBar$InitializedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#reset event.
   */
  export interface FilterBar$ResetEventParameters {
    /**
     * Visible controls
     */
    selectionSet?: Control[];
  }

  /**
   * Event object of the FilterBar#reset event.
   */
  export type FilterBar$ResetEvent = Event<
    FilterBar$ResetEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#search event.
   */
  export interface FilterBar$SearchEventParameters {
    /**
     * Visible controls
     */
    selectionSet?: Control[];

    /**
     * Set to `true` when event is fired due to user action in `FilterBar`
     */
    firedFromFilterBar?: boolean;
  }

  /**
   * Event object of the FilterBar#search event.
   */
  export type FilterBar$SearchEvent = Event<
    FilterBar$SearchEventParameters,
    FilterBar
  >;
}

declare module "sap/ui/comp/filterbar/FilterGroupItem" {
  import {
    default as FilterItem,
    $FilterItemSettings,
  } from "sap/ui/comp/filterbar/FilterItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents a filter belonging to a group other than basic.
   */
  export default class FilterGroupItem extends FilterItem {
    /**
     * Constructor for a new FilterBar/FilterGroupItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterGroupItemSettings
    );
    /**
     * Constructor for a new FilterBar/FilterGroupItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterGroupItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.filterbar.FilterGroupItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.filterbar.FilterItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterGroupItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.filterbar.FilterGroupItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys this element.
     */
    destroy(): void;
    /**
     * Gets current value of property {@link #getGroupName groupName}.
     *
     * Name of the group.
     *
     *
     * @returns Value of property `groupName`
     */
    getGroupName(): string;
    /**
     * Gets current value of property {@link #getGroupTitle groupTitle}.
     *
     * Title of the group.
     *
     *
     * @returns Value of property `groupTitle`
     */
    getGroupTitle(): string;
    /**
     * Controls the visibility of a filter item in the filter bar. Default value is `false`.
     *
     * @since 1.26.1
     *
     * @returns bValue State of visibility
     */
    getVisibleInFilterBar(): boolean;
    /**
     * Sets a new value for property {@link #getGroupName groupName}.
     *
     * Name of the group.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroupName(
      /**
       * New value for property `groupName`
       */
      sGroupName?: string
    ): this;
    /**
     * Setter for group title.
     */
    setGroupTitle(
      /**
       * Group title
       */
      sValue: string
    ): void;
  }
  /**
   * Describes the settings that can be provided to the FilterGroupItem constructor.
   */
  export interface $FilterGroupItemSettings extends $FilterItemSettings {
    /**
     * Title of the group.
     */
    groupTitle?: string | PropertyBindingInfo;

    /**
     * Name of the group.
     */
    groupName?: string | PropertyBindingInfo;

    /**
     * If set to true, this filter is visible on the filter bar by default. Mapped against the `visibleInFilterBar`
     * property.
     *
     * @since 1.24.0
     * @deprecated As of version 1.26.1. Replaced by property `visibleInFilterBar`
     */
    visibleInAdvancedArea?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/filterbar/FilterItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Represents a filter belonging to the basic group.
   */
  export default class FilterItem extends UI5Element {
    /**
     * Constructor for a new FilterBar/FilterItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterItemSettings
    );
    /**
     * Constructor for a new FilterBar/FilterItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.filterbar.FilterItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.filterbar.FilterItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.filterbar.FilterItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterItem` itself.
     *
     * This event is fired when one of the properties is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterItem$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.filterbar.FilterItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.filterbar.FilterItem` itself.
     *
     * This event is fired when one of the properties is changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FilterItem$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.filterbar.FilterItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys this element.
     */
    destroy(): void;
    /**
     * Destroys the control in the aggregation {@link #getControl control}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyControl(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.comp.filterbar.FilterItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FilterItem$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FilterItem$ChangeEventParameters
    ): this;
    /**
     * Always returns the initially added control.
     */
    getControl(): Control | null;
    /**
     * Gets current value of property {@link #getControlTooltip controlTooltip}.
     *
     * Tooltip for the filter'c control.
     *
     * @since 1.52.0
     *
     * @returns Value of property `controlTooltip`
     */
    getControlTooltip(): string;
    /**
     * Gets current value of property {@link #getEntitySetName entitySetName}.
     *
     * EntitySet name to which the filter belongs
     *
     * @since 1.58.0
     *
     * @returns Value of property `entitySetName`
     */
    getEntitySetName(): string;
    /**
     * Gets current value of property {@link #getEntityTypeName entityTypeName}.
     *
     * EntityType name to which the filter belongs
     *
     * @since 1.58.0
     *
     * @returns Value of property `entityTypeName`
     */
    getEntityTypeName(): string;
    /**
     * Gets current value of property {@link #getHiddenFilter hiddenFilter}.
     *
     * A hidden filter will never be visible in the filter bar control
     *
     * Default value is `false`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `hiddenFilter`
     */
    getHiddenFilter(): boolean;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Label of the filter.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getLabelTooltip labelTooltip}.
     *
     * Tooltip for the filter.
     *
     *
     * @returns Value of property `labelTooltip`
     */
    getLabelTooltip(): string;
    /**
     * Gets current value of property {@link #getMandatory mandatory}.
     *
     * Mandatory flag.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `mandatory`
     */
    getMandatory(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Name of the filter. This is an identifier for the filter and has to be unique.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPartOfCurrentVariant partOfCurrentVariant}.
     *
     * Determines if a filter is part of the currently selected variant.
     *  **Note:** This property can also be changed using the `visibleInFilterBar` property and by user interaction
     * in the Select Filters dialog or the variant handling.
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     * @deprecated As of version 1.87. Will be internally treated as if always set to true
     *
     * @returns Value of property `partOfCurrentVariant`
     */
    getPartOfCurrentVariant(): boolean;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Visibility state of the filter.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getVisibleInFilterBar visibleInFilterBar}.
     *
     * Controls the visibility of a filter item in the filter bar.
     *
     * Default value is `true`.
     *
     * @since 1.26.1
     *
     * @returns Value of property `visibleInFilterBar`
     */
    getVisibleInFilterBar(): boolean;
    /**
     * Initializes the filter item.
     */
    init(): void;
    /**
     * Sets the corresponding control. The control may not be overwritten by the application, once the filter
     * item is assigned to the FilterBar.
     */
    setControl(
      /**
       * associated with the filter.
       */
      oControl: Control
    ): void;
    /**
     * Sets a new value for property {@link #getControlTooltip controlTooltip}.
     *
     * Tooltip for the filter'c control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.52.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlTooltip(
      /**
       * New value for property `controlTooltip`
       */
      sControlTooltip?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEntitySetName entitySetName}.
     *
     * EntitySet name to which the filter belongs
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.58.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntitySetName(
      /**
       * New value for property `entitySetName`
       */
      sEntitySetName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEntityTypeName entityTypeName}.
     *
     * EntityType name to which the filter belongs
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.58.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntityTypeName(
      /**
       * New value for property `entityTypeName`
       */
      sEntityTypeName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHiddenFilter hiddenFilter}.
     *
     * A hidden filter will never be visible in the filter bar control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHiddenFilter(
      /**
       * New value for property `hiddenFilter`
       */
      bHiddenFilter?: boolean
    ): this;
    /**
     * Setter for label.
     */
    setLabel(
      /**
       * Label text
       */
      sValue: string
    ): void;
    /**
     * Setter for tooltip.
     */
    setLabelTooltip(
      /**
       * Tooltip text
       */
      sText: string
    ): void;
    /**
     * Setter for mandatory flag.
     */
    setMandatory(
      /**
       * Mandatory state
       */
      bValue: string
    ): void;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Name of the filter. This is an identifier for the filter and has to be unique.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Setter for partOfCurrentVariant in filter bar.
     *
     * @deprecated As of version 1.89. This property is treated as always set to `true`.
     */
    setPartOfCurrentVariant(
      /**
       * State of visibility in filter bar
       */
      bVisible: boolean
    ): void;
    /**
     * Setter for visible property.
     */
    setVisible(
      /**
       * State of visibility
       */
      bVisible: boolean
    ): void;
    /**
     * Setter for visible in filter bar.
     *
     * @since 1.26.1
     */
    setVisibleInFilterBar(
      /**
       * State of visibility in filter bar
       */
      bVisible: boolean
    ): void;
  }
  /**
   * Describes the settings that can be provided to the FilterItem constructor.
   */
  export interface $FilterItemSettings extends $ElementSettings {
    /**
     * Label of the filter.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Name of the filter. This is an identifier for the filter and has to be unique.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Mandatory flag.
     */
    mandatory?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Visibility state of the filter.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Tooltip for the filter.
     */
    labelTooltip?: string | PropertyBindingInfo;

    /**
     * Tooltip for the filter'c control.
     *
     * @since 1.52.0
     */
    controlTooltip?: string | PropertyBindingInfo;

    /**
     * Determines if a filter is part of the currently selected variant.
     *  **Note:** This property can also be changed using the `visibleInFilterBar` property and by user interaction
     * in the Select Filters dialog or the variant handling.
     *
     * @since 1.26.1
     * @deprecated As of version 1.87. Will be internally treated as if always set to true
     */
    partOfCurrentVariant?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of a filter item in the filter bar.
     *
     * @since 1.26.1
     */
    visibleInFilterBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A hidden filter will never be visible in the filter bar control
     *
     * @since 1.44.0
     */
    hiddenFilter?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * EntitySet name to which the filter belongs
     *
     * @since 1.58.0
     */
    entitySetName?: string | PropertyBindingInfo;

    /**
     * EntityType name to which the filter belongs
     *
     * @since 1.58.0
     */
    entityTypeName?: string | PropertyBindingInfo;

    /**
     * The control of the filter.
     */
    control?: Control;

    /**
     * This event is fired when one of the properties is changed.
     */
    change?: (oEvent: FilterItem$ChangeEvent) => void;
  }

  /**
   * Parameters of the FilterItem#change event.
   */
  export interface FilterItem$ChangeEventParameters {
    /**
     * Name of the changed property
     */
    propertyName?: string;
  }

  /**
   * Event object of the FilterItem#change event.
   */
  export type FilterItem$ChangeEvent = Event<
    FilterItem$ChangeEventParameters,
    FilterItem
  >;
}

declare module "sap/ui/comp/navpopover/LinkData" {
  import {
    default as LinkItem,
    $LinkItemSettings,
  } from "sap/ui/mdc/link/LinkItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Stores display text together with a navigation target hyperlink.
   *  The LinkData class is used by {@link sap.ui.comp.navpopover.SmartLink SmartLink} and {@link sap.ui.comp.navpopover.SemanticObjectController SemanticObjectController }
   * to define the visible links on {@link sap.ui.comp.navpopover.NavigationPopover NavigationPopover}.
   *
   * @since 1.28.0
   */
  export default class LinkData extends LinkItem {
    /**
     * Constructor for a new navpopover/LinkData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinkDataSettings
    );
    /**
     * Constructor for a new navpopover/LinkData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinkDataSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.navpopover.LinkData with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.link.LinkItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LinkData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.navpopover.LinkData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getIsSuperiorAction isSuperiorAction}.
     *
     * Marker for superior action.
     *
     * @since 1.48.0
     *
     * @returns Value of property `isSuperiorAction`
     */
    getIsSuperiorAction(): boolean;
    /**
     * Gets current value of property {@link #getTarget target}.
     *
     * The standard values for the `target` property are: _self, _top, _blank, _parent, _search. Alternatively,
     * a frame name can be entered. This property is only used if the `href` property is set.
     *
     *
     * @returns Value of property `target`
     */
    getTarget(): string;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Describes whether the link should be visible on the screen.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getVisibleChangedByUser visibleChangedByUser}.
     *
     * Describes whether the visibility is changed by end user or not.
     *
     * @since 1.58.0
     * @deprecated As of version 1.122. The SmartLink now uses information stored on {@link sap.ui.mdc.link.PanelItem}
     *
     * @returns Value of property `visibleChangedByUser`
     */
    getVisibleChangedByUser(): boolean;
    /**
     * Sets a new value for property {@link #getIsSuperiorAction isSuperiorAction}.
     *
     * Marker for superior action.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsSuperiorAction(
      /**
       * New value for property `isSuperiorAction`
       */
      bIsSuperiorAction: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTarget target}.
     *
     * The standard values for the `target` property are: _self, _top, _blank, _parent, _search. Alternatively,
     * a frame name can be entered. This property is only used if the `href` property is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * New value for property `target`
       */
      sTarget?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Describes whether the link should be visible on the screen.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVisibleChangedByUser visibleChangedByUser}.
     *
     * Describes whether the visibility is changed by end user or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.58.0
     * @deprecated As of version 1.122. The SmartLink now uses information stored on {@link sap.ui.mdc.link.PanelItem}
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisibleChangedByUser(
      /**
       * New value for property `visibleChangedByUser`
       */
      bVisibleChangedByUser: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LinkData constructor.
   */
  export interface $LinkDataSettings extends $LinkItemSettings {
    /**
     * The standard values for the `target` property are: _self, _top, _blank, _parent, _search. Alternatively,
     * a frame name can be entered. This property is only used if the `href` property is set.
     */
    target?: string | PropertyBindingInfo;

    /**
     * Describes whether the link should be visible on the screen.
     *
     * @since 1.44.0
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Marker for superior action.
     *
     * @since 1.48.0
     */
    isSuperiorAction?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Describes whether the visibility is changed by end user or not.
     *
     * @since 1.58.0
     * @deprecated As of version 1.122. The SmartLink now uses information stored on {@link sap.ui.mdc.link.PanelItem}
     */
    visibleChangedByUser?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/navpopover/NavigationPopover" {
  import {
    default as ResponsivePopover,
    $ResponsivePopoverSettings,
  } from "sap/m/ResponsivePopover";

  import LinkData from "sap/ui/comp/navpopover/LinkData";

  import Event from "sap/ui/base/Event";

  import { ID } from "sap/ui/core/library";

  import Link from "sap/m/Link";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import UI5Element from "sap/ui/core/Element";

  import Control from "sap/ui/core/Control";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The NavigationPopover control is used to present information in a specific format. **Note**: This control
   * is used by the {@link sap.ui.comp.navpopover.NavigationPopoverHandler NavigationPopoverHandler} and must
   * not be used manually.
   *
   * @deprecated As of version 1.121. SmartLink no longer opens a NavigationPopover, it got replaced by the
   * sap.ui.mdc.link.Panel in a sap.m.ResponsivePopover
   */
  export default class NavigationPopover extends ResponsivePopover {
    /**
     * Constructor for a new navpopover/NavigationPopover.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $NavigationPopoverSettings
    );
    /**
     * Constructor for a new navpopover/NavigationPopover.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $NavigationPopoverSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.navpopover.NavigationPopover with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ResponsivePopover.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NavigationPopover>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.navpopover.NavigationPopover.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some availableAction to the aggregation {@link #getAvailableActions availableActions}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAvailableAction(
      /**
       * The availableAction to add; if empty, nothing is inserted
       */
      oAvailableAction: LinkData
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:availableActionsPersonalizationPress availableActionsPersonalizationPress }
     * event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * This event is fired when personalization of `availableActions` is chosen.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAvailableActionsPersonalizationPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:availableActionsPersonalizationPress availableActionsPersonalizationPress }
     * event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * This event is fired when personalization of `availableActions` is chosen.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAvailableActionsPersonalizationPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * This event is fired when a link is chosen.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NavigationPopover$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * This event is fired when a link is chosen.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NavigationPopover$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:targetsObtained targetsObtained} event of this
     * `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * The navigation targets that are shown.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
     * targets are determined.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTargetsObtained(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:targetsObtained targetsObtained} event of this
     * `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopover` itself.
     *
     * The navigation targets that are shown.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
     * targets are determined.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTargetsObtained(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopover`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the availableActions in the aggregation {@link #getAvailableActions availableActions}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAvailableActions(): this;
    /**
     * Destroys the mainNavigation in the aggregation {@link #getMainNavigation mainNavigation}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMainNavigation(): this;
    /**
     * Destroys the ownNavigation in the aggregation {@link #getOwnNavigation ownNavigation}.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `ownNavigation` is obsolete as target determination is
     * no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyOwnNavigation(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:availableActionsPersonalizationPress availableActionsPersonalizationPress }
     * event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAvailableActionsPersonalizationPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NavigationPopover$NavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:targetsObtained targetsObtained} event of
     * this `sap.ui.comp.navpopover.NavigationPopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
     * targets are determined.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTargetsObtained(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:availableActionsPersonalizationPress availableActionsPersonalizationPress }
     * to attached listeners.
     *
     * @since 1.44.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAvailableActionsPersonalizationPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:navigate navigate} to attached listeners.
     *
     * @since 1.28.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NavigationPopover$NavigateEventParameters
    ): this;
    /**
     * Fires event {@link #event:targetsObtained targetsObtained} to attached listeners.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
     * targets are determined.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTargetsObtained(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAppStateKey appStateKey}.
     *
     * The application state key passed to retrieve the navigation targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `appStateKey` is obsolete as target determination is no
     * longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     *
     * @returns Value of property `appStateKey`
     */
    getAppStateKey(): string;
    /**
     * Gets content of aggregation {@link #getAvailableActions availableActions}.
     *
     * A list of available actions shown as links.
     *
     * @since 1.28.0
     */
    getAvailableActions(): LinkData[];
    /**
     * Gets current value of property {@link #getAvailableActionsPersonalizationText availableActionsPersonalizationText}.
     *
     * Determines the text of personalization link. If this property is set to some string, choosing the personalization
     * link will trigger the `availableActionsPersonalizationPress` event. If this property is not set, the
     * personalization link is not shown.
     *
     * Default value is `undefined`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `availableActionsPersonalizationText`
     */
    getAvailableActionsPersonalizationText(): string;
    /**
     * ID of the element which is the current target of the association {@link #getComponent component}, or
     * `null`.
     */
    getComponent(): ID | null;
    /**
     * Returns link for direct navigation if the NavigationPopover has only `mainNavigation` or one `availableAction`
     * and no `extraContent`.
     *
     *
     * @returns Link for direct navigation
     */
    getDirectLink(): Link | null;
    /**
     * ID of the element which is the current target of the association {@link #getExtraContent extraContent},
     * or `null`.
     *
     * @since 1.28.0
     */
    getExtraContent(): ID | null;
    /**
     * Gets content of aggregation {@link #getMainNavigation mainNavigation}.
     *
     * The main navigation link. If `mainNavigationId` is not set then `text` of `mainNavigation` is displayed.
     * Otherwise the `mainNavigationId` is displayed.
     *
     * @since 1.28.0
     */
    getMainNavigation(): LinkData;
    /**
     * Gets current value of property {@link #getMainNavigationId mainNavigationId}.
     *
     * Sets the description of the main navigation link. If `mainNavigation` also contains an href description,
     * then `mainNavigationId` is displayed. If `mainNavigationId` is set to an empty string `''`, neither description
     * nor subtitle are displayed.
     *
     * @since 1.28.0
     *
     * @returns Value of property `mainNavigationId`
     */
    getMainNavigationId(): string;
    /**
     * Gets content of aggregation {@link #getOwnNavigation ownNavigation}.
     *
     * The navigation taking the user back to the source application.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `ownNavigation` is obsolete as target determination is
     * no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     */
    getOwnNavigation(): LinkData;
    /**
     * Gets current value of property {@link #getSemanticAttributes semanticAttributes}.
     *
     * Describes the semantic attributes. The attribute has to be a map.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticAttributes` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     *
     * @returns Value of property `semanticAttributes`
     */
    getSemanticAttributes(): object;
    /**
     * Gets current value of property {@link #getSemanticObjectName semanticObjectName}.
     *
     * The name of the semantic object.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticObjectName` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     *
     * @returns Value of property `semanticObjectName`
     */
    getSemanticObjectName(): string;
    /**
     * ID of the element which is the current target of the association {@link #getSource source}, or `null`.
     *
     * @since 1.28.0
     */
    getSource(): ID | null;
    /**
     * Checks for the provided `sap.ui.comp.navpopover.LinkData` in the aggregation {@link #getAvailableActions availableActions}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.28.0
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAvailableAction(
      /**
       * The availableAction whose index is looked for
       */
      oAvailableAction: LinkData
    ): int;
    /**
     * Inserts a availableAction into the aggregation {@link #getAvailableActions availableActions}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAvailableAction(
      /**
       * The availableAction to insert; if empty, nothing is inserted
       */
      oAvailableAction: LinkData,
      /**
       * The `0`-based index the availableAction should be inserted at; for a negative value of `iIndex`, the
       * availableAction is inserted at position 0; for a value greater than the current size of the aggregation,
       * the availableAction is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getAvailableActions availableActions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.28.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAvailableActions(): LinkData[];
    /**
     * Removes a availableAction from the aggregation {@link #getAvailableActions availableActions}.
     *
     * @since 1.28.0
     *
     * @returns The removed availableAction or `null`
     */
    removeAvailableAction(
      /**
       * The availableAction to remove or its index or id
       */
      vAvailableAction: int | string | LinkData
    ): LinkData | null;
    /**
     * Determines the potential navigation targets for the semantical object and visualize the popover.
     *
     * @deprecated As of version 1.42.0. Target determination is no longer done by NavigationPopover. Instead
     * the NavigationPopoverHandler is responsible for target determination.
     */
    retrieveNavTargets(): void;
    /**
     * Sets a new value for property {@link #getAppStateKey appStateKey}.
     *
     * The application state key passed to retrieve the navigation targets.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `appStateKey` is obsolete as target determination is no
     * longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAppStateKey(
      /**
       * New value for property `appStateKey`
       */
      sAppStateKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAvailableActionsPersonalizationText availableActionsPersonalizationText}.
     *
     * Determines the text of personalization link. If this property is set to some string, choosing the personalization
     * link will trigger the `availableActionsPersonalizationPress` event. If this property is not set, the
     * personalization link is not shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAvailableActionsPersonalizationText(
      /**
       * New value for property `availableActionsPersonalizationText`
       */
      sAvailableActionsPersonalizationText?: string
    ): this;
    /**
     * Sets the associated {@link #getComponent component}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setComponent(
      /**
       * ID of an element which becomes the new target of this component association; alternatively, an element
       * instance may be given
       */
      oComponent: ID | UI5Element
    ): this;
    /**
     * Sets the associated {@link #getExtraContent extraContent}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExtraContent(
      /**
       * ID of an element which becomes the new target of this extraContent association; alternatively, an element
       * instance may be given
       */
      oExtraContent: ID | Control
    ): this;
    /**
     * Sets the aggregated {@link #getMainNavigation mainNavigation}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMainNavigation(
      /**
       * The mainNavigation to set
       */
      oMainNavigation: LinkData
    ): this;
    /**
     * Sets a new value for property {@link #getMainNavigationId mainNavigationId}.
     *
     * Sets the description of the main navigation link. If `mainNavigation` also contains an href description,
     * then `mainNavigationId` is displayed. If `mainNavigationId` is set to an empty string `''`, neither description
     * nor subtitle are displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMainNavigationId(
      /**
       * New value for property `mainNavigationId`
       */
      sMainNavigationId?: string
    ): this;
    /**
     * Sets the aggregated {@link #getOwnNavigation ownNavigation}.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `ownNavigation` is obsolete as target determination is
     * no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOwnNavigation(
      /**
       * The ownNavigation to set
       */
      oOwnNavigation: LinkData
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticAttributes semanticAttributes}.
     *
     * Describes the semantic attributes. The attribute has to be a map.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticAttributes` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticAttributes(
      /**
       * New value for property `semanticAttributes`
       */
      oSemanticAttributes?: object
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObjectName semanticObjectName}.
     *
     * The name of the semantic object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticObjectName` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectName(
      /**
       * New value for property `semanticObjectName`
       */
      sSemanticObjectName?: string
    ): this;
    /**
     * Sets the associated {@link #getSource source}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSource(
      /**
       * ID of an element which becomes the new target of this source association; alternatively, an element instance
       * may be given
       */
      oSource: ID | Control
    ): this;
    /**
     * Displays the popover. This method should be called, once all navigation targets are adapted by the application.
     */
    show(): void;
  }
  /**
   * Describes the settings that can be provided to the NavigationPopover constructor.
   *
   * @deprecated As of version 1.121. SmartLink no longer opens a NavigationPopover, it got replaced by the
   * sap.ui.mdc.link.Panel in a sap.m.ResponsivePopover
   */
  export interface $NavigationPopoverSettings
    extends $ResponsivePopoverSettings {
    /**
     * The name of the semantic object.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticObjectName` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     */
    semanticObjectName?: string | PropertyBindingInfo;

    /**
     * Describes the semantic attributes. The attribute has to be a map.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `semanticAttributes` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination.
     */
    semanticAttributes?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The application state key passed to retrieve the navigation targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `appStateKey` is obsolete as target determination is no
     * longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     */
    appStateKey?: string | PropertyBindingInfo;

    /**
     * Sets the description of the main navigation link. If `mainNavigation` also contains an href description,
     * then `mainNavigationId` is displayed. If `mainNavigationId` is set to an empty string `''`, neither description
     * nor subtitle are displayed.
     *
     * @since 1.28.0
     */
    mainNavigationId?: string | PropertyBindingInfo;

    /**
     * Determines the text of personalization link. If this property is set to some string, choosing the personalization
     * link will trigger the `availableActionsPersonalizationPress` event. If this property is not set, the
     * personalization link is not shown.
     *
     * @since 1.44.0
     */
    availableActionsPersonalizationText?: string | PropertyBindingInfo;

    /**
     * A list of available actions shown as links.
     *
     * @since 1.28.0
     */
    availableActions?:
      | LinkData[]
      | LinkData
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * The main navigation link. If `mainNavigationId` is not set then `text` of `mainNavigation` is displayed.
     * Otherwise the `mainNavigationId` is displayed.
     *
     * @since 1.28.0
     */
    mainNavigation?: LinkData;

    /**
     * The navigation taking the user back to the source application.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The property `ownNavigation` is obsolete as target determination is
     * no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target determination.
     */
    ownNavigation?: LinkData;

    /**
     * Source control for which the popover is displayed.
     *
     * @since 1.28.0
     */
    source?: Control | string;

    /**
     * In addition to main navigation link and available links some additional content can be displayed in the
     * popover.
     *
     * @since 1.28.0
     */
    extraContent?: Control | string;

    /**
     * The parent component.
     */
    component?: UI5Element | string;

    /**
     * The navigation targets that are shown.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
     * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
     * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
     * targets are determined.
     */
    targetsObtained?: (oEvent: Event) => void;

    /**
     * This event is fired when a link is chosen.
     *
     * @since 1.28.0
     */
    navigate?: (oEvent: NavigationPopover$NavigateEvent) => void;

    /**
     * This event is fired when personalization of `availableActions` is chosen.
     *
     * @since 1.44.0
     */
    availableActionsPersonalizationPress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the NavigationPopover#availableActionsPersonalizationPress event.
   */
  export interface NavigationPopover$AvailableActionsPersonalizationPressEventParameters {}

  /**
   * Event object of the NavigationPopover#availableActionsPersonalizationPress event.
   */
  export type NavigationPopover$AvailableActionsPersonalizationPressEvent =
    Event<
      NavigationPopover$AvailableActionsPersonalizationPressEventParameters,
      NavigationPopover
    >;

  /**
   * Parameters of the NavigationPopover#navigate event.
   */
  export interface NavigationPopover$NavigateEventParameters {
    /**
     * The UI text shown in the chosen link
     */
    text?: string;

    /**
     * The navigation target of the chosen link
     */
    href?: string;
  }

  /**
   * Event object of the NavigationPopover#navigate event.
   */
  export type NavigationPopover$NavigateEvent = Event<
    NavigationPopover$NavigateEventParameters,
    NavigationPopover
  >;

  /**
   * Parameters of the NavigationPopover#targetsObtained event.
   *
   * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
   * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
   * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
   * targets are determined.
   */
  export interface NavigationPopover$TargetsObtainedEventParameters {}

  /**
   * Event object of the NavigationPopover#targetsObtained event.
   *
   * @deprecated As of version 1.40.0. The event `navigationTargetsObtained` is obsolete as target determination
   * is no longer done by NavigationPopover. Instead the NavigationPopoverHandler is responsible for target
   * determination. The event `navigationTargetsObtained` is fired from NavigationPopoverHandler after navigation
   * targets are determined.
   */
  export type NavigationPopover$TargetsObtainedEvent = Event<
    NavigationPopover$TargetsObtainedEventParameters,
    NavigationPopover
  >;
}

declare module "sap/ui/comp/navpopover/NavigationPopoverHandler" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { ID } from "sap/ui/core/library";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import LinkData from "sap/ui/comp/navpopover/LinkData";

  import SimpleForm from "sap/ui/layout/form/SimpleForm";

  /**
   * The NavigationPopoverHandler control determines navigation targets for a semantic object and shows them
   * together with further information in a Popover.
   *  **Note:** Navigation targets are determined using {@link sap.ushell.services.CrossApplicationNavigation CrossApplicationNavigation }
   * of the unified shell service.
   *
   * @deprecated As of version 1.121. SmartLink no longer uses the NavigationPopoverHandler, it got replaced
   * by a sap.ui.mdc.Link implementation. All event handlings can be done directly on the SmartLink / SemanticObjectController.
   */
  export default class NavigationPopoverHandler extends ManagedObject {
    /**
     * Constructor for a new navpopover/NavigationPopoverHandler.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $NavigationPopoverHandlerSettings
    );
    /**
     * Constructor for a new navpopover/NavigationPopoverHandler.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $NavigationPopoverHandlerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.navpopover.NavigationPopoverHandler with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NavigationPopoverHandler>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.navpopover.NavigationPopoverHandler.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of NavigationPopoverHandler,
     * the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of NavigationPopoverHandler,
     * the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerNavigate innerNavigate} event of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NavigationPopoverHandler$InnerNavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerNavigate innerNavigate} event of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: NavigationPopoverHandler$InnerNavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.36.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.NavigationPopoverHandler` itself.
     *
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.36.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.NavigationPopoverHandler`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforePopoverOpens(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:innerNavigate innerNavigate} event of this
     * `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInnerNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: NavigationPopoverHandler$InnerNavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.NavigationPopoverHandler`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.36.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigationTargetsObtained(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: NavigationPopoverHandler$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforePopoverOpens beforePopoverOpens} to attached listeners.
     *
     * @since 1.36.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforePopoverOpens(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NavigationPopoverHandler$BeforePopoverOpensEventParameters
    ): this;
    /**
     * Fires event {@link #event:innerNavigate innerNavigate} to attached listeners.
     *
     * @since 1.36.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInnerNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NavigationPopoverHandler$InnerNavigateEventParameters
    ): this;
    /**
     * Fires event {@link #event:navigationTargetsObtained navigationTargetsObtained} to attached listeners.
     *
     * @since 1.36.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigationTargetsObtained(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: NavigationPopoverHandler$NavigationTargetsObtainedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAdditionalSemanticObjects additionalSemanticObjects}.
     *
     * Names of additional semantic objects which are used to determine target navigations.
     *
     * Default value is `[]`.
     *
     * @since 1.42.0
     *
     * @returns Value of property `additionalSemanticObjects`
     */
    getAdditionalSemanticObjects(): string[];
    /**
     * Gets current value of property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a `Promise`
     * resolving into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the
     * navigation will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the
     * following data:
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     *
     * @returns Value of property `beforeNavigationCallback`
     */
    getBeforeNavigationCallback(): Function;
    /**
     * Gets current value of property {@link #getContactAnnotationPath contactAnnotationPath}.
     *
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * Default value is `undefined`.
     *
     * @since 1.40.0
     *
     * @returns Value of property `contactAnnotationPath`
     */
    getContactAnnotationPath(): string;
    /**
     * ID of the element which is the current target of the association {@link #getControl control}, or `null`.
     *
     * @since 1.36.0
     */
    getControl(): ID | null;
    /**
     * Gets current value of property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `enableAvailableActionsPersonalization`
     */
    getEnableAvailableActionsPersonalization(): boolean;
    /**
     * Gets current value of property {@link #getFieldName fieldName}.
     *
     * The metadata field name for this NavigationPopoverHandler control.
     *
     * @since 1.36.0
     *
     * @returns Value of property `fieldName`
     */
    getFieldName(): string;
    /**
     * Gets current value of property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the NavigationPopoverHandler control will not replace its field name with the according
     * `semanticObject` property during the calculation of the semantic attributes. This enables the usage of
     * several NavigationPopoverHandler on the same semantic object. *
     *
     * Default value is `true`.
     *
     * @since 1.36.0
     *
     * @returns Value of property `mapFieldToSemanticObject`
     */
    getMapFieldToSemanticObject(): boolean;
    /**
     * Gets current value of property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     *
     * @returns Value of property `navigationTargetsObtainedCallback`
     */
    getNavigationTargetsObtainedCallback(): Function;
    /**
     * Gets current value of property {@link #getSemanticObject semanticObject}.
     *
     * Name of semantic object which is used to determine target navigations.
     *
     * @since 1.36.0
     *
     * @returns Value of property `semanticObject`
     */
    getSemanticObject(): string;
    /**
     * Gets current value of property {@link #getSemanticObjectController semanticObjectController}.
     *
     * The semantic object controller controls events for several NavigationPopoverHandler controls. If the
     * controller is not set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * @since 1.36.0
     *
     * @returns Value of property `semanticObjectController`
     */
    getSemanticObjectController(): any;
    /**
     * Gets current value of property {@link #getSemanticObjectLabel semanticObjectLabel}.
     *
     * Shown title of semantic object.
     *
     * @since 1.36.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     *
     * @returns Value of property `semanticObjectLabel`
     */
    getSemanticObjectLabel(): string;
    /**
     * Gets the current value assigned to the field with the NavigationPopoverHandler's semantic object name.
     *
     *
     * @returns The semantic object's value.
     */
    getSemanticObjectValue(): object;
    /**
     * Opens the `sap.m.Popover` with navigation targets in an asynchronous manner.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    openPopover(
      /**
       * Optional DOM reference to which the popover is attached. By default the `control` association is used
       * as DOM reference.
       */
      oDomRef: object
    ): Promise<any>;
    /**
     * Sets a new value for property {@link #getAdditionalSemanticObjects additionalSemanticObjects}.
     *
     * Names of additional semantic objects which are used to determine target navigations.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalSemanticObjects(
      /**
       * New value for property `additionalSemanticObjects`
       */
      sAdditionalSemanticObjects?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a `Promise`
     * resolving into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the
     * navigation will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the
     * following data:
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.75.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBeforeNavigationCallback(
      /**
       * New value for property `beforeNavigationCallback`
       */
      fnBeforeNavigationCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getContactAnnotationPath contactAnnotationPath}.
     *
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     * @since 1.40.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContactAnnotationPath(
      /**
       * New value for property `contactAnnotationPath`
       */
      sContactAnnotationPath?: string
    ): this;
    /**
     * Sets the associated {@link #getControl control}.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControl(
      /**
       * ID of an element which becomes the new target of this control association; alternatively, an element
       * instance may be given
       */
      oControl: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAvailableActionsPersonalization(
      /**
       * New value for property `enableAvailableActionsPersonalization`
       */
      bEnableAvailableActionsPersonalization?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFieldName fieldName}.
     *
     * The metadata field name for this NavigationPopoverHandler control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFieldName(
      /**
       * New value for property `fieldName`
       */
      sFieldName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the NavigationPopoverHandler control will not replace its field name with the according
     * `semanticObject` property during the calculation of the semantic attributes. This enables the usage of
     * several NavigationPopoverHandler on the same semantic object. *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMapFieldToSemanticObject(
      /**
       * New value for property `mapFieldToSemanticObject`
       */
      bMapFieldToSemanticObject?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.126
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigationTargetsObtainedCallback(
      /**
       * New value for property `navigationTargetsObtainedCallback`
       */
      fnNavigationTargetsObtainedCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObject semanticObject}.
     *
     * Name of semantic object which is used to determine target navigations.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObject(
      /**
       * New value for property `semanticObject`
       */
      sSemanticObject?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObjectController semanticObjectController}.
     *
     * The semantic object controller controls events for several NavigationPopoverHandler controls. If the
     * controller is not set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.36.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectController(
      /**
       * New value for property `semanticObjectController`
       */
      oSemanticObjectController?: any
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObjectLabel semanticObjectLabel}.
     *
     * Shown title of semantic object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.36.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectLabel(
      /**
       * New value for property `semanticObjectLabel`
       */
      sSemanticObjectLabel?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the NavigationPopoverHandler constructor.
   *
   * @deprecated As of version 1.121. SmartLink no longer uses the NavigationPopoverHandler, it got replaced
   * by a sap.ui.mdc.Link implementation. All event handlings can be done directly on the SmartLink / SemanticObjectController.
   */
  export interface $NavigationPopoverHandlerSettings
    extends $ManagedObjectSettings {
    /**
     * Name of semantic object which is used to determine target navigations.
     *
     * @since 1.36.0
     */
    semanticObject?: string | PropertyBindingInfo;

    /**
     * Names of additional semantic objects which are used to determine target navigations.
     *
     * @since 1.42.0
     */
    additionalSemanticObjects?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic object controller controls events for several NavigationPopoverHandler controls. If the
     * controller is not set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * @since 1.36.0
     */
    semanticObjectController?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The metadata field name for this NavigationPopoverHandler control.
     *
     * @since 1.36.0
     */
    fieldName?: string | PropertyBindingInfo;

    /**
     * Shown title of semantic object.
     *
     * @since 1.36.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     */
    semanticObjectLabel?: string | PropertyBindingInfo;

    /**
     * If set to `false`, the NavigationPopoverHandler control will not replace its field name with the according
     * `semanticObject` property during the calculation of the semantic attributes. This enables the usage of
     * several NavigationPopoverHandler on the same semantic object. *
     *
     * @since 1.36.0
     */
    mapFieldToSemanticObject?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * @since 1.40.0
     */
    contactAnnotationPath?: string | PropertyBindingInfo;

    /**
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * @since 1.44.0
     */
    enableAvailableActionsPersonalization?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Function that is called before the actual navigation happens. This function has to return a `Promise`
     * resolving into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the
     * navigation will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the
     * following data:
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     */
    beforeNavigationCallback?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     */
    navigationTargetsObtainedCallback?:
      | Function
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The parent control.
     *
     * @since 1.36.0
     */
    control?: Control | string;

    /**
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of NavigationPopoverHandler,
     * the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.36.0
     */
    beforePopoverOpens?: (
      oEvent: NavigationPopoverHandler$BeforePopoverOpensEvent
    ) => void;

    /**
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.36.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     */
    navigationTargetsObtained?: (
      oEvent: NavigationPopoverHandler$NavigationTargetsObtainedEvent
    ) => void;

    /**
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.36.0
     */
    innerNavigate?: (
      oEvent: NavigationPopoverHandler$InnerNavigateEvent
    ) => void;
  }

  /**
   * Parameters of the NavigationPopoverHandler#beforePopoverOpens event.
   */
  export interface NavigationPopoverHandler$BeforePopoverOpensEventParameters {
    /**
     * The semantic object for which the navigation targets will be retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes calculated from the binding that will be used to retrieve the
     * navigation targets.
     */
    semanticAttributes?: object;

    /**
     * A map of semantic objects for which the navigation targets will be retrieved and it's semantic attributes
     * calculated from the binding context. The semantic attributes will be used as parameters in order to retrieve
     * the navigation targets.
     */
    semanticAttributesOfSemanticObjects?: object;

    /**
     * This callback function enables you to define a changed semantic attributes map. Signatures: `setSemanticAttributes(oSemanticAttributesMap)`
     * Parameter:
     * 	 - {object} oSemanticAttributesMap New map containing the semantic attributes
     * 	 - {string} sSemanticObject Semantic Object for which the oSemanticAttributesMap belongs
     */
    setSemanticAttributes?: Function;

    /**
     * This callback function sets an application state key that is used over the cross-application navigation.
     * Signatures: `setAppStateKey(sAppStateKey)` Parameter:
     * 	 - {string} sAppStateKey
     */
    setAppStateKey?: Function;

    /**
     * The ID of the NavigationPopoverHandler.
     */
    originalId?: string;

    /**
     * This callback function triggers the retrieval of navigation targets and leads to the opening of the navigation
     * popover. Signatures: `open()` If the `beforePopoverOpens` has been registered, the `open` function has
     * to be called manually in order to open the navigation popover.
     */
    open?: Function;
  }

  /**
   * Event object of the NavigationPopoverHandler#beforePopoverOpens event.
   */
  export type NavigationPopoverHandler$BeforePopoverOpensEvent = Event<
    NavigationPopoverHandler$BeforePopoverOpensEventParameters,
    NavigationPopoverHandler
  >;

  /**
   * Parameters of the NavigationPopoverHandler#innerNavigate event.
   */
  export interface NavigationPopoverHandler$InnerNavigateEventParameters {
    /**
     * The UI text shown in the clicked link.
     */
    text?: string;

    /**
     * The navigation target of the clicked link.
     */
    href?: string;

    /**
     * The semantic object used to retrieve this target.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes used to retrieve this target.
     */
    semanticAttributes?: object;

    /**
     * The ID of the NavigationPopoverHandler.
     */
    originalId?: string;
  }

  /**
   * Event object of the NavigationPopoverHandler#innerNavigate event.
   */
  export type NavigationPopoverHandler$InnerNavigateEvent = Event<
    NavigationPopoverHandler$InnerNavigateEventParameters,
    NavigationPopoverHandler
  >;

  /**
   * Parameters of the NavigationPopoverHandler#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export interface NavigationPopoverHandler$NavigationTargetsObtainedEventParameters {
    /**
     * The main navigation object.
     */
    mainNavigation?: LinkData;

    /**
     * Array of available navigation target objects.
     */
    actions?: LinkData[];

    /**
     * The navigation object for the own application. This navigation option is by default not visible on the
     * popover.
     */
    ownNavigation?: LinkData;

    /**
     * Array containing contact data.
     */
    popoverForms?: SimpleForm[];

    /**
     * The semantic object for which the navigation targets have been retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes.
     */
    semanticAttributes?: object;

    /**
     * The ID of the NavigationPopoverHandler.
     */
    originalId?: string;

    /**
     * This callback function shows the actual navigation popover. If the `navigationTargetsObtained` has been
     * registered, the `show` function has to be called manually in order to open the navigation popover. Signatures:
     * `show()`
     * 	 - `show(oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object. With
     * `null` the main navigation object will be removed. With `undefined` the old object will remain.
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross
     *     application navigation links. With empty array all available links will be removed. With `undefined`
     *     the old links will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     * 	 - `show(sMainNavigationId, oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{string | undefined} sMainNavigationId The visible description for the main navigation link. With `''`,
     * both the description and subtitle will be removed. With `undefined`, the description is calculated using
     * the binding context of a given source object (for example `SmartLink` control).
     * 	 - {sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object.
     *     With `null` the main navigation object will be removed. With `undefined` the old object will remain.
     *
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross
     *     application navigation links. With empty array all available links will be removed. With `undefined`
     *     the old links will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     */
    show?: Function;
  }

  /**
   * Event object of the NavigationPopoverHandler#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export type NavigationPopoverHandler$NavigationTargetsObtainedEvent = Event<
    NavigationPopoverHandler$NavigationTargetsObtainedEventParameters,
    NavigationPopoverHandler
  >;
}

declare module "sap/ui/comp/navpopover/SmartLink" {
  import LinkData from "sap/ui/comp/navpopover/LinkData";

  import SimpleForm from "sap/ui/layout/form/SimpleForm";

  import Control from "sap/ui/core/Control";

  import { default as Link, $LinkSettings } from "sap/m/Link";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Object holding the information regarding the obtained navigation targets and extra content. This is used
   * as parameter and return value of the `Promise` in the `navigationTargetsObtainedCallback`.
   */
  export type NavigationTargets = {
    /**
     * The text of the main link / text that is displayed in the header of the popover.
     */
    mainNavigationId: string;
    /**
     * The main navigation object
     */
    mainNavigation: LinkData;
    /**
     * Array of available navigation target objects
     */
    actions: LinkData[];
    /**
     * The navigation object for the own application. This navigation option is not visible on the popover by
     * default.
     */
    ownNavigation: LinkData;
    /**
     * Array containing contact data. Manipulating this property won't have an effect, it's only relevant to
     * be streamlined with the old API. The `extraContent` property is used to return the intended content.
     */
    popoverForms: SimpleForm[];
    /**
     * The semantic object for which the navigation targets have been retrieved
     */
    semanticObject: String;
    /**
     * Map containing the semantic attributes
     */
    semanticAttributes: object;
    /**
     * The ID of the `SmartLink` or other parent control
     */
    originalId: String;
    /**
     * The control that is displayed in the extra content section on the popover. If set to `null`, the extra
     * content is removed. If set to `undefined`, a {@link sap.m.VBox} containing the `popoverForms` as items
     * is used as extra content. The `popoverForms` can be empty.
     */
    extraContent: Control | null | undefined;
  };

  /**
   * The `SmartLink` control uses a semantic object to display {@link sap.ui.comp.navpopover.NavigationPopover NavigationPopover }
   * for further navigation steps.
   *  **Note:** Navigation targets are determined using {@link sap.ushell.services.CrossApplicationNavigation CrossApplicationNavigation }
   * of the unified shell service.
   *
   * **Important:** Keep in mind that `SmartLink`, like all SAPUI5 smart controls, retrieves and analyzes
   * the metadata and annotations of OData services. **The OData metadata is its primary API. These OData
   * services are not part of the SAPUI5 framework and are usually maintained by the backend developers of
   * your application.**
   *
   * With time, `SmartLink` can evolve and acquire new features. This means that its behavior or functionalities
   * may change if the annotations that define this change are maintained in your backend metadata. To benefit
   * from the new functionalities, your application should be able to adapt the backend metadata. **Therefore,
   * we recommend using `SmartLink` only if you have control over the metadata of your application.**
   */
  export default class SmartLink extends Link {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/f638884d0d624ad8a243f4005f8e9972 Smart Link}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartLinkSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/f638884d0d624ad8a243f4005f8e9972 Smart Link}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartLinkSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.navpopover.SmartLink with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Link.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartLink>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.navpopover.SmartLink.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink
     * control, the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$BeforePopoverOpensEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink
     * control, the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$BeforePopoverOpensEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerNavigate innerNavigate} event of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$InnerNavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerNavigate innerNavigate} event of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$InnerNavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$NavigationTargetsObtainedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SmartLink` itself.
     *
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartLink$NavigationTargetsObtainedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SmartLink` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the innerControl in the aggregation {@link #getInnerControl innerControl}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInnerControl(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforePopoverOpens(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartLink$BeforePopoverOpensEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:innerNavigate innerNavigate} event of this
     * `sap.ui.comp.navpopover.SmartLink`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInnerNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartLink$InnerNavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SmartLink`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigationTargetsObtained(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartLink$NavigationTargetsObtainedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforePopoverOpens beforePopoverOpens} to attached listeners.
     *
     * @since 1.28.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforePopoverOpens(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartLink$BeforePopoverOpensEventParameters
    ): this;
    /**
     * Fires event {@link #event:innerNavigate innerNavigate} to attached listeners.
     *
     * @since 1.28.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInnerNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartLink$InnerNavigateEventParameters
    ): this;
    /**
     * Fires event {@link #event:navigationTargetsObtained navigationTargetsObtained} to attached listeners.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigationTargetsObtained(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartLink$NavigationTargetsObtainedEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAdditionalSemanticObjects additionalSemanticObjects}.
     *
     * Semantic object names which can be used additional to the default `semanticObject` property in order
     * to get navigation targets links.
     *
     * Default value is `[]`.
     *
     * @since 1.42.0
     *
     * @returns Value of property `additionalSemanticObjects`
     */
    getAdditionalSemanticObjects(): string[];
    /**
     * Gets current value of property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     *
     * @returns Value of property `beforeNavigationCallback`
     */
    getBeforeNavigationCallback(): Function;
    /**
     * Gets current value of property {@link #getContactAnnotationPath contactAnnotationPath}.
     *
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * Default value is `undefined`.
     *
     * @since 1.40.0
     *
     * @returns Value of property `contactAnnotationPath`
     */
    getContactAnnotationPath(): string;
    /**
     * Gets current value of property {@link #getCreateControlCallback createControlCallback}.
     *
     * Function that enables the SmartLink control to create an alternative control, which is displayed if `ignoreLinkRendering`
     * is enabled. The function has no parameters and has to return an instance of sap.ui.core.Control.
     *
     * @since 1.28.0
     *
     * @returns Value of property `createControlCallback`
     */
    getCreateControlCallback(): Function;
    /**
     * Gets current value of property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `enableAvailableActionsPersonalization`
     */
    getEnableAvailableActionsPersonalization(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Determines whether the link can be triggered by the user.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFieldName fieldName}.
     *
     * The metadata field name for this SmartLink control.
     *
     * @since 1.28.0
     *
     * @returns Value of property `fieldName`
     */
    getFieldName(): string;
    /**
     * Gets current value of property {@link #getForceLinkRendering forceLinkRendering}.
     *
     * If set to true, the `SmartLink` control is rendered as a link even if `contactAnnotationPath` is not
     * set and navigation targets do not exist. Setting this property to `true` allows the application, for
     * example, to modify the `SmartLink` control in the event handler, after the user has clicked on a link
     * and the registered event handler has been called.
     *
     * **Note:** The `ignoreLinkRendering` property and the `ignoredFields` property of the associated `SemanticObjectController`
     * take precedence over `forceLinkRendering`.
     *
     * Default value is `false`.
     *
     * @since 1.58.0
     *
     * @returns Value of property `forceLinkRendering`
     */
    getForceLinkRendering(): boolean;
    /**
     * Gets current value of property {@link #getIgnoreLinkRendering ignoreLinkRendering}.
     *
     * If set to `true`, the SmartLink control will render the `innerControl` or the control provided by `createControlCallback`
     * instead of the actual link. This is used for example by the SemanticObjectController if this SmartLink
     * is listed in its `ignoredFields` or no navigation targets were found during prefetch.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `ignoreLinkRendering`
     */
    getIgnoreLinkRendering(): boolean;
    /**
     * Gets content of aggregation {@link #getInnerControl innerControl}.
     *
     * Control that is displayed instead of SmartLink control, if the SmartLink is disabled (for example, if
     * no navigation targets are available). If `innerControl` is not provided, the SmartLink control tries
     * to create one with property `createControlCallback`.
     *
     * @since 1.28.0
     */
    getInnerControl(): Control;
    /**
     * Gets the value of the `innerControl` aggregate if available, otherwise the text of SmartLink control
     * will be returned.
     *
     *
     * @returns The value of `innerControl` aggregate or the text of the SmartLink
     */
    getInnerControlValue(): object;
    /**
     * Gets current value of property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes. This enables the usage of several SmartLink
     * controls on the same semantic object.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `mapFieldToSemanticObject`
     */
    getMapFieldToSemanticObject(): boolean;
    /**
     * Gets current value of property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     *
     * @returns Value of property `navigationTargetsObtainedCallback`
     */
    getNavigationTargetsObtainedCallback(): Function;
    /**
     * Gets current value of property {@link #getSemanticObject semanticObject}.
     *
     * Name of semantic object which is used to fill the navigation popover. **Note**: Setting a value triggers
     * an asynchronous determination, so the effect can be delayed.
     *
     * @since 1.28.0
     *
     * @returns Value of property `semanticObject`
     */
    getSemanticObject(): string;
    /**
     * Gets current value of property {@link #getSemanticObjectController semanticObjectController}.
     *
     * The semantic object controller controls events for several SmartLink controls. If the controller is not
     * set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * @since 1.28.0
     *
     * @returns Value of property `semanticObjectController`
     */
    getSemanticObjectController(): any;
    /**
     * Gets current value of property {@link #getSemanticObjectLabel semanticObjectLabel}.
     *
     * Shown label of semantic object.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     *
     * @returns Value of property `semanticObjectLabel`
     */
    getSemanticObjectLabel(): string;
    /**
     * Gets current value of property {@link #getUom uom}.
     *
     * Additionally to the `text` property the Unit of Measure can be displayed.
     *
     * Default value is `undefined`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `uom`
     */
    getUom(): string;
    /**
     * Gets current value of property {@link #getWrapping wrapping}.
     *
     * Determines whether the link text is allowed to wrap when there is no sufficient space.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `wrapping`
     */
    getWrapping(): boolean;
    /**
     * Sets a new value for property {@link #getAdditionalSemanticObjects additionalSemanticObjects}.
     *
     * Semantic object names which can be used additional to the default `semanticObject` property in order
     * to get navigation targets links.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalSemanticObjects(
      /**
       * New value for property `additionalSemanticObjects`
       */
      sAdditionalSemanticObjects?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.75.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBeforeNavigationCallback(
      /**
       * New value for property `beforeNavigationCallback`
       */
      fnBeforeNavigationCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getContactAnnotationPath contactAnnotationPath}.
     *
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     * @since 1.40.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContactAnnotationPath(
      /**
       * New value for property `contactAnnotationPath`
       */
      sContactAnnotationPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCreateControlCallback createControlCallback}.
     *
     * Function that enables the SmartLink control to create an alternative control, which is displayed if `ignoreLinkRendering`
     * is enabled. The function has no parameters and has to return an instance of sap.ui.core.Control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCreateControlCallback(
      /**
       * New value for property `createControlCallback`
       */
      fnCreateControlCallback?: Function
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAvailableActionsPersonalization(
      /**
       * New value for property `enableAvailableActionsPersonalization`
       */
      bEnableAvailableActionsPersonalization?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Determines whether the link can be triggered by the user.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFieldName fieldName}.
     *
     * The metadata field name for this SmartLink control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFieldName(
      /**
       * New value for property `fieldName`
       */
      sFieldName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getForceLinkRendering forceLinkRendering}.
     *
     * If set to true, the `SmartLink` control is rendered as a link even if `contactAnnotationPath` is not
     * set and navigation targets do not exist. Setting this property to `true` allows the application, for
     * example, to modify the `SmartLink` control in the event handler, after the user has clicked on a link
     * and the registered event handler has been called.
     *
     * **Note:** The `ignoreLinkRendering` property and the `ignoredFields` property of the associated `SemanticObjectController`
     * take precedence over `forceLinkRendering`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.58.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setForceLinkRendering(
      /**
       * New value for property `forceLinkRendering`
       */
      bForceLinkRendering?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoreLinkRendering ignoreLinkRendering}.
     *
     * If set to `true`, the SmartLink control will render the `innerControl` or the control provided by `createControlCallback`
     * instead of the actual link. This is used for example by the SemanticObjectController if this SmartLink
     * is listed in its `ignoredFields` or no navigation targets were found during prefetch.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoreLinkRendering(
      /**
       * New value for property `ignoreLinkRendering`
       */
      bIgnoreLinkRendering?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getInnerControl innerControl}.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInnerControl(
      /**
       * The innerControl to set
       */
      oInnerControl: Control
    ): this;
    /**
     * Sets a new value for property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes. This enables the usage of several SmartLink
     * controls on the same semantic object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMapFieldToSemanticObject(
      /**
       * New value for property `mapFieldToSemanticObject`
       */
      bMapFieldToSemanticObject?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.126
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigationTargetsObtainedCallback(
      /**
       * New value for property `navigationTargetsObtainedCallback`
       */
      fnNavigationTargetsObtainedCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObject semanticObject}.
     *
     * Name of semantic object which is used to fill the navigation popover. **Note**: Setting a value triggers
     * an asynchronous determination, so the effect can be delayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObject(
      /**
       * New value for property `semanticObject`
       */
      sSemanticObject?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObjectController semanticObjectController}.
     *
     * The semantic object controller controls events for several SmartLink controls. If the controller is not
     * set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectController(
      /**
       * New value for property `semanticObjectController`
       */
      oSemanticObjectController?: any
    ): this;
    /**
     * Sets a new value for property {@link #getSemanticObjectLabel semanticObjectLabel}.
     *
     * Shown label of semantic object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectLabel(
      /**
       * New value for property `semanticObjectLabel`
       */
      sSemanticObjectLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUom uom}.
     *
     * Additionally to the `text` property the Unit of Measure can be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUom(
      /**
       * New value for property `uom`
       */
      sUom?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWrapping wrapping}.
     *
     * Determines whether the link text is allowed to wrap when there is no sufficient space.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrapping(
      /**
       * New value for property `wrapping`
       */
      bWrapping?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartLink constructor.
   */
  export interface $SmartLinkSettings extends $LinkSettings {
    /**
     * Name of semantic object which is used to fill the navigation popover. **Note**: Setting a value triggers
     * an asynchronous determination, so the effect can be delayed.
     *
     * @since 1.28.0
     */
    semanticObject?: string | PropertyBindingInfo;

    /**
     * Semantic object names which can be used additional to the default `semanticObject` property in order
     * to get navigation targets links.
     *
     * @since 1.42.0
     */
    additionalSemanticObjects?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic object controller controls events for several SmartLink controls. If the controller is not
     * set manually, it tries to find a SemanticObjectController in its parent hierarchy.
     *
     * @since 1.28.0
     */
    semanticObjectController?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The metadata field name for this SmartLink control.
     *
     * @since 1.28.0
     */
    fieldName?: string | PropertyBindingInfo;

    /**
     * Shown label of semantic object.
     *
     * @since 1.28.0
     * @deprecated As of version 1.40.0. Title section with `semanticObjectLabel` has been removed due to new
     * UI design
     */
    semanticObjectLabel?: string | PropertyBindingInfo;

    /**
     * Function that enables the SmartLink control to create an alternative control, which is displayed if `ignoreLinkRendering`
     * is enabled. The function has no parameters and has to return an instance of sap.ui.core.Control.
     *
     * @since 1.28.0
     */
    createControlCallback?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes. This enables the usage of several SmartLink
     * controls on the same semantic object.
     */
    mapFieldToSemanticObject?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Navigation property that points from the current to the related entity type where the com.sap.vocabularies.Communication.v1.Contact
     * annotation is defined, for example, `'to_Supplier'`. An empty string means that the related entity type
     * is the current one.
     *
     * @since 1.40.0
     */
    contactAnnotationPath?: string | PropertyBindingInfo;

    /**
     * If set to `true`, the SmartLink control will render the `innerControl` or the control provided by `createControlCallback`
     * instead of the actual link. This is used for example by the SemanticObjectController if this SmartLink
     * is listed in its `ignoredFields` or no navigation targets were found during prefetch.
     *
     * @since 1.28.0
     */
    ignoreLinkRendering?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the personalization link is shown inside the NavigationPopover control.
     *
     * @since 1.44.0
     */
    enableAvailableActionsPersonalization?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to true, the `SmartLink` control is rendered as a link even if `contactAnnotationPath` is not
     * set and navigation targets do not exist. Setting this property to `true` allows the application, for
     * example, to modify the `SmartLink` control in the event handler, after the user has clicked on a link
     * and the registered event handler has been called.
     *
     * **Note:** The `ignoreLinkRendering` property and the `ignoredFields` property of the associated `SemanticObjectController`
     * take precedence over `forceLinkRendering`.
     *
     * @since 1.58.0
     */
    forceLinkRendering?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Additionally to the `text` property the Unit of Measure can be displayed.
     *
     * @since 1.48.0
     */
    uom?: string | PropertyBindingInfo;

    /**
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     */
    beforeNavigationCallback?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the link can be triggered by the user.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the link text is allowed to wrap when there is no sufficient space.
     */
    wrapping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `NavigationPopoverHandler`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     */
    navigationTargetsObtainedCallback?:
      | Function
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Control that is displayed instead of SmartLink control, if the SmartLink is disabled (for example, if
     * no navigation targets are available). If `innerControl` is not provided, the SmartLink control tries
     * to create one with property `createControlCallback`.
     *
     * @since 1.28.0
     */
    innerControl?: Control;

    /**
     * Event is fired before the navigation popover opens and before navigation target links are getting retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink
     * control, the `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     */
    beforePopoverOpens?: (oEvent: SmartLink$BeforePopoverOpensEvent) => void;

    /**
     * After the navigation targets are retrieved, `navigationTargetsObtained` is fired and provides the possibility
     * to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     */
    navigationTargetsObtained?: (
      oEvent: SmartLink$NavigationTargetsObtainedEvent
    ) => void;

    /**
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     */
    innerNavigate?: (oEvent: SmartLink$InnerNavigateEvent) => void;
  }

  /**
   * Parameters of the SmartLink#beforePopoverOpens event.
   */
  export interface SmartLink$BeforePopoverOpensEventParameters {
    /**
     * The semantic object for which the navigation targets will be retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes calculated from the binding that will be used to retrieve the
     * navigation targets.
     */
    semanticAttributes?: object;

    /**
     * A map of semantic objects for which the navigation targets will be retrieved and it's semantic attributes
     * calculated from the binding context. The semantic attributes will be used as parameters in order to retrieve
     * the navigation targets.
     */
    semanticAttributesOfSemanticObjects?: object;

    /**
     * This callback function enables you to define a changed semantic attributes map. Signatures: `setSemanticAttributes(oSemanticAttributesMap)`
     * Parameter:
     * 	 - {object} oSemanticAttributesMap New map containing the semantic attributes
     * 	 - {string} sSemanticObject Semantic Object for which the oSemanticAttributesMap belongs
     */
    setSemanticAttributes?: Function;

    /**
     * This callback function sets an application state key that is used over the cross-application navigation.
     * Signatures: `setAppStateKey(sAppStateKey)` Parameter:
     * 	 - {string} sAppStateKey
     */
    setAppStateKey?: Function;

    /**
     * The ID of the SmartLink control.
     */
    originalId?: string;

    /**
     * This callback function triggers the retrieval of navigation targets and leads to the opening of the navigation
     * popover. Signatures: `open()` If the `beforePopoverOpens` has been registered, the `open` function has
     * to be called manually in order to open the navigation popover or trigger a direct navigation.
     */
    open?: Function;
  }

  /**
   * Event object of the SmartLink#beforePopoverOpens event.
   */
  export type SmartLink$BeforePopoverOpensEvent = Event<
    SmartLink$BeforePopoverOpensEventParameters,
    SmartLink
  >;

  /**
   * Parameters of the SmartLink#innerNavigate event.
   */
  export interface SmartLink$InnerNavigateEventParameters {
    /**
     * The UI text shown in the clicked link.
     */
    text?: string;

    /**
     * The navigation target of the clicked link.
     */
    href?: string;

    /**
     * The semantic object used to retrieve this target.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes used to retrieve this target.
     */
    semanticAttributes?: object;

    /**
     * The ID of the SmartLink control.
     */
    originalId?: string;
  }

  /**
   * Event object of the SmartLink#innerNavigate event.
   */
  export type SmartLink$InnerNavigateEvent = Event<
    SmartLink$InnerNavigateEventParameters,
    SmartLink
  >;

  /**
   * Parameters of the SmartLink#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export interface SmartLink$NavigationTargetsObtainedEventParameters {
    /**
     * The main navigation object.
     */
    mainNavigation?: LinkData;

    /**
     * Array of available navigation target objects.
     */
    actions?: LinkData[];

    /**
     * The navigation object for the own application. This navigation option is by default not visible on the
     * popover.
     */
    ownNavigation?: LinkData;

    /**
     * Array containing contact data.
     */
    popoverForms?: SimpleForm[];

    /**
     * The semantic object for which the navigation targets have been retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes.
     */
    semanticAttributes?: object;

    /**
     * The ID of the SmartLink control.
     */
    originalId?: string;

    /**
     * This callback function shows the actual navigation popover. If the `navigationTargetsObtained` has been
     * registered, the `show` function has to be called manually in order to open the navigation popover. Signatures:
     * `show()`
     * 	 - `show(oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object. With
     * `null` the main navigation object will be removed. With `undefined` the old object will remain.
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross
     *     application navigation links. With empty array all available links will be removed. With `undefined`
     *     the old links will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     * 	 - `show(sMainNavigationId, oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{string | undefined} sMainNavigationId The visible description for the main navigation link. With `''`,
     * both the description and subtitle will be removed. With `undefined`, the description is calculated using
     * the binding context of a given source object (for example `SmartLink` control).
     * 	 - {sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object.
     *     With `null` the main navigation object will be removed. With `undefined` the old object will remain.
     *
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross
     *     application navigation links. With empty array all available links will be removed. With `undefined`
     *     the old links will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     */
    show?: Function;
  }

  /**
   * Event object of the SmartLink#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export type SmartLink$NavigationTargetsObtainedEvent = Event<
    SmartLink$NavigationTargetsObtainedEventParameters,
    SmartLink
  >;
}

declare module "sap/ui/comp/navpopover/SemanticObjectController" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SmartLink from "sap/ui/comp/navpopover/SmartLink";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  import LinkData from "sap/ui/comp/navpopover/LinkData";

  import SimpleForm from "sap/ui/layout/form/SimpleForm";

  /**
   * The `SemanticObjectController` control operates as a single entry point for `SmartLink` controls created
   * automatically by {@link sap.ui.comp.smarttable.SmartTable SmartTable} control, {@link sap.ui.comp.smartchart.SmartChart SmartChart }
   * control, {@link sap.ui.comp.smartform.SmartForm SmartForm} control and {@link sap.ui.comp.smartfield.SmartField SmartField }
   * control based on OData metadata. Additionally, all events provided by the `SmartLink` control are registered
   * by the SemanticObjectController and can be consumed there in a single place. As usual, the SemanticObjectController
   * can be defined within the XML view as well as in the code.
   */
  export default class SemanticObjectController extends UI5Element {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SemanticObjectControllerSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SemanticObjectControllerSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.navpopover.SemanticObjectController with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SemanticObjectController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.navpopover.SemanticObjectController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink,
     * `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * Event is fired before the navigation popover opens and before navigation target links are retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink,
     * `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePopoverOpens(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * After the navigation targets have been retrieved, `navigationTargetsObtained` is fired and makes it possible
     * you to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * After the navigation targets have been retrieved, `navigationTargetsObtained` is fired and makes it possible
     * you to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigationTargetsObtained(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:prefetchDone prefetchDone} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * If the property `prefetchNavigationTargets` is set to `true`, event `prefetchDone` is fired after all
     * navigation targets have been retrieved.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
     * `prefetchNavigationTargets` which has been deprecated.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPrefetchDone(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$PrefetchDoneEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:prefetchDone prefetchDone} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.navpopover.SemanticObjectController` itself.
     *
     * If the property `prefetchNavigationTargets` is set to `true`, event `prefetchDone` is fired after all
     * navigation targets have been retrieved.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
     * `prefetchNavigationTargets` which has been deprecated.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPrefetchDone(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$PrefetchDoneEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.navpopover.SemanticObjectController`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforePopoverOpens beforePopoverOpens} event
     * of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforePopoverOpens(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$BeforePopoverOpensEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigate navigate} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$NavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigationTargetsObtained navigationTargetsObtained }
     * event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigationTargetsObtained(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: SemanticObjectController$NavigationTargetsObtainedEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:prefetchDone prefetchDone} event of this `sap.ui.comp.navpopover.SemanticObjectController`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
     * `prefetchNavigationTargets` which has been deprecated.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPrefetchDone(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SemanticObjectController$PrefetchDoneEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforePopoverOpens beforePopoverOpens} to attached listeners.
     *
     * @since 1.28.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforePopoverOpens(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SemanticObjectController$BeforePopoverOpensEventParameters
    ): this;
    /**
     * Fires event {@link #event:navigate navigate} to attached listeners.
     *
     * @since 1.28.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SemanticObjectController$NavigateEventParameters
    ): this;
    /**
     * Fires event {@link #event:navigationTargetsObtained navigationTargetsObtained} to attached listeners.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigationTargetsObtained(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SemanticObjectController$NavigationTargetsObtainedEventParameters
    ): this;
    /**
     * Fires event {@link #event:prefetchDone prefetchDone} to attached listeners.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
     * `prefetchNavigationTargets` which has been deprecated.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePrefetchDone(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SemanticObjectController$PrefetchDoneEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     *
     * @returns Value of property `beforeNavigationCallback`
     */
    getBeforeNavigationCallback(): Function;
    /**
     * Gets current value of property {@link #getContactAnnotationPaths contactAnnotationPaths}.
     *
     * Navigation property that points from the current to the related entity type where the `com.sap.vocabularies.Communication.v1.Contact`
     * annotation is defined, for example, ` '\{"Supplier":"to_Supplier", "CompanyName":"to_Company"\}' `. An
     * empty string means that the related entity type is the current one.
     *
     * @since 1.40.0
     *
     * @returns Value of property `contactAnnotationPaths`
     */
    getContactAnnotationPaths(): object;
    /**
     * Gets current value of property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control. For example,
     * ` '\{"Supplier":false, "CompanyName":true\}' `.
     *
     * @since 1.44.0
     *
     * @returns Value of property `enableAvailableActionsPersonalization`
     */
    getEnableAvailableActionsPersonalization(): object;
    /**
     * Gets current value of property {@link #getEntitySet entitySet}.
     *
     * The name of the entity set used. If `entitySet` has not been defined, the SemanticObjectController tries
     * to retrieve the name from its parents. **Note:** This is not a dynamic UI5 property.
     *
     * @since 1.28.0
     *
     * @returns Value of property `entitySet`
     */
    getEntitySet(): string;
    /**
     * Gets current value of property {@link #getFieldSemanticObjectMap fieldSemanticObjectMap}.
     *
     * Maps the fields to the related semantic objects. When accessing this property for the first time, the
     * mapping will be calculated from the metadata within the provided model.
     *
     * @since 1.28.0
     *
     * @returns Value of property `fieldSemanticObjectMap`
     */
    getFieldSemanticObjectMap(): object;
    /**
     * Gets current value of property {@link #getForceLinkRendering forceLinkRendering}.
     *
     * Object containing fields for which the corresponding `SmartLink` control is rendered as a link even if
     * `contactAnnotationPaths` is not set and navigation targets do not exist. Setting this property to `true`
     * allows the application, for example, to modify the `SmartLink` control in the event handler, after the
     * user has clicked on a link and the registered event handler has been called.\n
     *
     * **Note:** The `ignoredFields` property and the `ignoreLinkRendering` property of the `SmartLink` control
     * take precedence over `forceLinkRendering`.\n
     *
     * Example of usage: ` '\{"Supplier":"true", "CompanyName":"true"\}' `
     *
     * @since 1.58.0
     *
     * @returns Value of property `forceLinkRendering`
     */
    getForceLinkRendering(): object;
    /**
     * Gets current value of property {@link #getIgnoredFields ignoredFields}.
     *
     * Comma-separated list of fields that must not be displayed as links.
     *
     * @since 1.28.0
     *
     * @returns Value of property `ignoredFields`
     */
    getIgnoredFields(): string;
    /**
     * Gets current value of property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes.
     *
     * @since 1.48.0
     *
     * @returns Value of property `mapFieldToSemanticObject`
     */
    getMapFieldToSemanticObject(): boolean;
    /**
     * Gets current value of property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `SmartLinkFieldInfo`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     *
     * @returns Value of property `navigationTargetsObtainedCallback`
     */
    getNavigationTargetsObtainedCallback(): Function;
    /**
     * Gets current value of property {@link #getPrefetchNavigationTargets prefetchNavigationTargets}.
     *
     * If set to `true`, the SemanticObjectController will retrieve all navigation targets once and will disable
     * links for which no targets were found. Setting this value to `true` will trigger an additional roundtrip.
     *
     * Default value is `false`.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The property `prefetchNavigationTargets` is obsolete as navigation
     * targets are determined automatically. The SmartLink controls are re-rendered as soon as the asynchronous
     * determination of navigation targets has been completed.
     *
     * @returns Value of property `prefetchNavigationTargets`
     */
    getPrefetchNavigationTargets(): boolean;
    /**
     * Gets current value of property {@link #getReplaceSmartLinkNavigationTargetsObtained replaceSmartLinkNavigationTargetsObtained}.
     *
     * Determines if the `navigationTargetsObtained` event handling of the `SmartLink` should be replaced when
     * this `SemanticObjectController` is set as `SemanticObjectController` on the SmartLink.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Value of property `replaceSmartLinkNavigationTargetsObtained`
     */
    getReplaceSmartLinkNavigationTargetsObtained(): boolean;
    /**
     * Checks if the given semantic object name has a navigation link. **Note**: this method returns a valid
     * value only after the event `prefetchDone` has been raised. The event `prefetchDone` is raised if the
     * property `prefetchNavigationTargets` is set to `true`.
     *
     * @deprecated As of version 1.42.0. The method `hasSemanticObjectLinks` is obsolete because it depends
     * on the property `prefetchNavigationTargets` which has been deprecated.
     *
     * @returns true if the semantic object has any navigation links
     */
    hasSemanticObjectLinks(
      /**
       * Name of semantic object
       */
      sSemanticObject: string
    ): boolean;
    /**
     * Returns whether the given control has been registered by the SemanticObjectController.
     *
     *
     * @returns `true` if the given control has been registered
     */
    isControlRegistered(
      /**
       * Control registered by `SemanticObjectController`
       */
      oControl: SmartLink
    ): boolean;
    /**
     * Adds the given control to the SemanticObjectController and registers all relevant events.
     */
    registerControl(
      /**
       * Control to be registered by `SemanticObjectController`
       */
      oControl: SmartLink
    ): void;
    /**
     * Sets a new value for property {@link #getBeforeNavigationCallback beforeNavigationCallback}.
     *
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.75.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBeforeNavigationCallback(
      /**
       * New value for property `beforeNavigationCallback`
       */
      fnBeforeNavigationCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getContactAnnotationPaths contactAnnotationPaths}.
     *
     * Navigation property that points from the current to the related entity type where the `com.sap.vocabularies.Communication.v1.Contact`
     * annotation is defined, for example, ` '\{"Supplier":"to_Supplier", "CompanyName":"to_Company"\}' `. An
     * empty string means that the related entity type is the current one.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.40.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContactAnnotationPaths(
      /**
       * New value for property `contactAnnotationPaths`
       */
      oContactAnnotationPaths?: object
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAvailableActionsPersonalization enableAvailableActionsPersonalization}.
     *
     * Determines whether the personalization link is shown inside the NavigationPopover control. For example,
     * ` '\{"Supplier":false, "CompanyName":true\}' `.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAvailableActionsPersonalization(
      /**
       * New value for property `enableAvailableActionsPersonalization`
       */
      oEnableAvailableActionsPersonalization?: object
    ): this;
    /**
     * Sets a new value for property {@link #getEntitySet entitySet}.
     *
     * The name of the entity set used. If `entitySet` has not been defined, the SemanticObjectController tries
     * to retrieve the name from its parents. **Note:** This is not a dynamic UI5 property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntitySet(
      /**
       * New value for property `entitySet`
       */
      sEntitySet?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFieldSemanticObjectMap fieldSemanticObjectMap}.
     *
     * Maps the fields to the related semantic objects. When accessing this property for the first time, the
     * mapping will be calculated from the metadata within the provided model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFieldSemanticObjectMap(
      /**
       * New value for property `fieldSemanticObjectMap`
       */
      oFieldSemanticObjectMap?: object
    ): this;
    /**
     * Sets a new value for property {@link #getForceLinkRendering forceLinkRendering}.
     *
     * Object containing fields for which the corresponding `SmartLink` control is rendered as a link even if
     * `contactAnnotationPaths` is not set and navigation targets do not exist. Setting this property to `true`
     * allows the application, for example, to modify the `SmartLink` control in the event handler, after the
     * user has clicked on a link and the registered event handler has been called.\n
     *
     * **Note:** The `ignoredFields` property and the `ignoreLinkRendering` property of the `SmartLink` control
     * take precedence over `forceLinkRendering`.\n
     *
     * Example of usage: ` '\{"Supplier":"true", "CompanyName":"true"\}' `
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.58.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setForceLinkRendering(
      /**
       * New value for property `forceLinkRendering`
       */
      oForceLinkRendering?: object
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoredFields ignoredFields}.
     *
     * Comma-separated list of fields that must not be displayed as links.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * New value for property `ignoredFields`
       */
      sIgnoredFields?: string
    ): this;
    /**
     * Checks if the given SmartLink has to be enabled or disabled and sets the state.
     *
     * @deprecated As of version 1.42.0. The method `setIgnoredState` is obsolete as SmartLink is processing
     * the internal state on its own.
     */
    setIgnoredState(
      /**
       * the SmartLink which should be enabled or disabled.
       */
      oSmartLink: SmartLink
    ): void;
    /**
     * Sets a new value for property {@link #getMapFieldToSemanticObject mapFieldToSemanticObject}.
     *
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMapFieldToSemanticObject(
      /**
       * New value for property `mapFieldToSemanticObject`
       */
      bMapFieldToSemanticObject: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNavigationTargetsObtainedCallback navigationTargetsObtainedCallback}.
     *
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `SmartLinkFieldInfo`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.126
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigationTargetsObtainedCallback(
      /**
       * New value for property `navigationTargetsObtainedCallback`
       */
      fnNavigationTargetsObtainedCallback: Function
    ): this;
    /**
     * Sets a new value for property {@link #getReplaceSmartLinkNavigationTargetsObtained replaceSmartLinkNavigationTargetsObtained}.
     *
     * Determines if the `navigationTargetsObtained` event handling of the `SmartLink` should be replaced when
     * this `SemanticObjectController` is set as `SemanticObjectController` on the SmartLink.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReplaceSmartLinkNavigationTargetsObtained(
      /**
       * New value for property `replaceSmartLinkNavigationTargetsObtained`
       */
      bReplaceSmartLinkNavigationTargetsObtained?: boolean
    ): this;
    /**
     * Removes the given control from the SemanticObjectController and unregisters all relevant events.
     */
    unregisterControl(
      /**
       * Control to be unregistered by `SemanticObjectController`
       */
      oControl: SmartLink
    ): void;
  }
  /**
   * Describes the settings that can be provided to the SemanticObjectController constructor.
   */
  export interface $SemanticObjectControllerSettings extends $ElementSettings {
    /**
     * Comma-separated list of fields that must not be displayed as links.
     *
     * @since 1.28.0
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * If set to `true`, the SemanticObjectController will retrieve all navigation targets once and will disable
     * links for which no targets were found. Setting this value to `true` will trigger an additional roundtrip.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The property `prefetchNavigationTargets` is obsolete as navigation
     * targets are determined automatically. The SmartLink controls are re-rendered as soon as the asynchronous
     * determination of navigation targets has been completed.
     */
    prefetchNavigationTargets?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Maps the fields to the related semantic objects. When accessing this property for the first time, the
     * mapping will be calculated from the metadata within the provided model.
     *
     * @since 1.28.0
     */
    fieldSemanticObjectMap?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The name of the entity set used. If `entitySet` has not been defined, the SemanticObjectController tries
     * to retrieve the name from its parents. **Note:** This is not a dynamic UI5 property.
     *
     * @since 1.28.0
     */
    entitySet?: string | PropertyBindingInfo;

    /**
     * Navigation property that points from the current to the related entity type where the `com.sap.vocabularies.Communication.v1.Contact`
     * annotation is defined, for example, ` '\{"Supplier":"to_Supplier", "CompanyName":"to_Company"\}' `. An
     * empty string means that the related entity type is the current one.
     *
     * @since 1.40.0
     */
    contactAnnotationPaths?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the personalization link is shown inside the NavigationPopover control. For example,
     * ` '\{"Supplier":false, "CompanyName":true\}' `.
     *
     * @since 1.44.0
     */
    enableAvailableActionsPersonalization?:
      | object
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to `false`, the SmartLink control will not replace its field name with the according `semanticObject`
     * property during the calculation of the semantic attributes.
     *
     * @since 1.48.0
     */
    mapFieldToSemanticObject?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Object containing fields for which the corresponding `SmartLink` control is rendered as a link even if
     * `contactAnnotationPaths` is not set and navigation targets do not exist. Setting this property to `true`
     * allows the application, for example, to modify the `SmartLink` control in the event handler, after the
     * user has clicked on a link and the registered event handler has been called.\n
     *
     * **Note:** The `ignoredFields` property and the `ignoreLinkRendering` property of the `SmartLink` control
     * take precedence over `forceLinkRendering`.\n
     *
     * Example of usage: ` '\{"Supplier":"true", "CompanyName":"true"\}' `
     *
     * @since 1.58.0
     */
    forceLinkRendering?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Function that is called before the actual navigation happens. This function has to return a promise resolving
     * into a Boolean value for which the navigation will wait. If the Boolean value is `true`, the navigation
     * will be processed. The `beforeNavigationCallback(oNavigationInfo)` parameter contains the following data:
     *
     * 	 - {String} text: Text of the navigation intent
     * 	 - {String} href: HREF of the navigation intent
     * 	 - {String} originalId: ID of the control that fires the navigation intent
     * 	 - {String} semanticObject: Name of the `SemanticObject` of the navigation intent
     * 	 - {Object} semanticAttributes: Object containing the `SemanticAttributes` of the navigation intent
     *
     *
     * @since 1.75.0
     */
    beforeNavigationCallback?: Function | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the `navigationTargetsObtained` event handling of the `SmartLink` should be replaced when
     * this `SemanticObjectController` is set as `SemanticObjectController` on the SmartLink.
     *
     * @since 1.97
     */
    replaceSmartLinkNavigationTargetsObtained?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Function that is called when the navigation targets provided by the SAP Fiori launchpad are obtained.
     * The function is called with one `oNavigationTargets` parameter of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * This function has to return a `Promise` resolving into an `Object` of type {@link sap.ui.comp.navpopover.NavigationTargets}.
     * The provided `oNavigationTargets` can be manipulated in this callback before being returned to the `SmartLinkFieldInfo`.
     * The `Popover` will open after the `Promise` has been resolved. This function replaces the `navigationTargetsObtained`
     * event. The event handling is ignored if this callback is set.
     *
     * @since 1.126
     */
    navigationTargetsObtainedCallback?:
      | Function
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * After the navigation targets have been retrieved, `navigationTargetsObtained` is fired and makes it possible
     * you to change the targets.
     *
     * @since 1.28.0
     * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
     */
    navigationTargetsObtained?: (
      oEvent: SemanticObjectController$NavigationTargetsObtainedEvent
    ) => void;

    /**
     * Event is fired before the navigation popover opens and before navigation target links are retrieved.
     * Event can be used to change the parameters used to retrieve the navigation targets. In case of SmartLink,
     * `beforePopoverOpens` is fired after the link has been clicked.
     *
     * @since 1.28.0
     */
    beforePopoverOpens?: (
      oEvent: SemanticObjectController$BeforePopoverOpensEvent
    ) => void;

    /**
     * This event is fired after a navigation link on the navigation popover has been clicked. This event is
     * only fired, if the user left-clicks the link. Right-clicking the link and selecting 'Open in New Window'
     * etc. in the context menu does not fire the event.
     *
     * @since 1.28.0
     */
    navigate?: (oEvent: SemanticObjectController$NavigateEvent) => void;

    /**
     * If the property `prefetchNavigationTargets` is set to `true`, event `prefetchDone` is fired after all
     * navigation targets have been retrieved.
     *
     * @since 1.28.0
     * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
     * `prefetchNavigationTargets` which has been deprecated.
     */
    prefetchDone?: (oEvent: SemanticObjectController$PrefetchDoneEvent) => void;
  }

  /**
   * Parameters of the SemanticObjectController#beforePopoverOpens event.
   */
  export interface SemanticObjectController$BeforePopoverOpensEventParameters {
    /**
     * The semantic object for which the navigation targets will be retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes calculated from the binding that will be used to retrieve the
     * navigation targets.
     */
    semanticAttributes?: object;

    /**
     * A map of semantic objects for which the navigation targets will be retrieved and it's semantic attributes
     * calculated from the binding context. The semantic attributes will be used as parameters in order to retrieve
     * the navigation targets.
     */
    semanticAttributesOfSemanticObjects?: object;

    /**
     * This callback function enables you to define a changed semantic attributes map. Signatures: `setSemanticAttributes(oSemanticAttributesMap)`
     * Parameter:
     * 	 - {object} oSemanticAttributesMap New map containing the semantic attributes
     * 	 - {string} sSemanticObject Semantic Object for which the oSemanticAttributesMap belongs
     */
    setSemanticAttributes?: Function;

    /**
     * This callback function sets an application state key that is used over the cross-application navigation.
     * Signatures: `setAppStateKey(sAppStateKey)` Parameter:
     * 	 - {string} sAppStateKey
     */
    setAppStateKey?: Function;

    /**
     * The ID of the control that fires this event. If `beforePopoverOpens` is registered on the SmartLink,
     * `originalId` is the same as the event's source ID which is also the SmartLink's ID. If the `beforePopoverOpens`
     * is registered on the SemanticObjectController, `originalId` helps to identify the original SmartLink
     * control which triggered the event.
     */
    originalId?: string;

    /**
     * This callback function triggers the retrieval of navigation targets and leads to the opening of the navigation
     * popover. Signatures: `open()` If `beforePopoverOpens` has been registered, `open` function has to be
     * called manually in order to open the navigation popover or trigger a direct navigation.
     */
    open?: Function;
  }

  /**
   * Event object of the SemanticObjectController#beforePopoverOpens event.
   */
  export type SemanticObjectController$BeforePopoverOpensEvent = Event<
    SemanticObjectController$BeforePopoverOpensEventParameters,
    SemanticObjectController
  >;

  /**
   * Parameters of the SemanticObjectController#navigate event.
   */
  export interface SemanticObjectController$NavigateEventParameters {
    /**
     * The UI text shown in the clicked link.
     */
    text?: string;

    /**
     * The navigation target of the clicked link.
     */
    href?: string;

    /**
     * The semantic object used to retrieve this target.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes used to retrieve this target.
     */
    semanticAttributes?: object;

    /**
     * The ID of the control that fires this event. If `navigate` is registered on the SmartLink, `originalId`
     * is the same as the event's source ID which is the SmartLink's ID. If `navigate` is registered on the
     * SemanticObjectController, `originalId` helps to identify the original SmartLink control which triggered
     * the event.
     */
    originalId?: string;
  }

  /**
   * Event object of the SemanticObjectController#navigate event.
   */
  export type SemanticObjectController$NavigateEvent = Event<
    SemanticObjectController$NavigateEventParameters,
    SemanticObjectController
  >;

  /**
   * Parameters of the SemanticObjectController#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export interface SemanticObjectController$NavigationTargetsObtainedEventParameters {
    /**
     * The main navigation object.
     */
    mainNavigation?: LinkData;

    /**
     * Array of available navigation target objects.
     */
    actions?: LinkData[];

    /**
     * The navigation object for the own application. This navigation option is by default not visible on the
     * popover.
     */
    ownNavigation?: LinkData;

    /**
     * Array containing contact data.
     */
    popoverForms?: SimpleForm[];

    /**
     * The semantic object for which the navigation targets have been retrieved.
     */
    semanticObject?: string;

    /**
     * Map containing the semantic attributes.
     */
    semanticAttributes?: object;

    /**
     * The ID of the control that fires this event. If `navigationTargetsObtained` is registered on the SmartLink,
     * `originalId` is the same as the event's source ID which is also the SmartLink's ID. If `navigationTargetsObtained`
     * is registered on the SemanticObjectController, `originalId` helps to identify the original SmartLink
     * control which triggered the event.
     */
    originalId?: string;

    /**
     * This callback function shows the actual navigation popover. If the `navigationTargetsObtained` has been
     * registered, the `show` function has to be called manually in order to open the navigation popover. Signatures:
     * `show()`
     * 	 - `show(oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object. With
     * `null` the main navigation object will be removed. With `undefined` the old object will remain.
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross-application
     *     navigation links. With empty array all available links will be removed. With `undefined` the old links
     *     will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     * 	 - `show(sMainNavigationId, oMainNavigation, aAvailableActions, oAdditionalContent)` Parameters:
     * 	{string | undefined} sMainNavigationId The visible description for the main navigation link. With `''`,
     * both the description and subtitle will be removed. With `undefined`, the description is calculated using
     * the binding context of a given source object (for example `SmartLink` control).
     * 	 - {sap.ui.comp.navpopover.LinkData | null | undefined} oMainNavigation The main navigation object.
     *     With `null` the main navigation object will be removed. With `undefined` the old object will remain.
     *
     * 	 - {sap.ui.comp.navpopover.LinkData[] | [] | undefined} aAvailableActions Array containing the cross-application
     *     navigation links. With empty array all available links will be removed. With `undefined` the old links
     *     will remain.
     * 	 - {sap.ui.core.Control | null | undefined} oAdditionalContent Control that will be displayed in extra
     *     content section on the popover. With `null` the main extra content object will be removed. With `undefined`
     *     the old object still remains.
     */
    show?: Function;
  }

  /**
   * Event object of the SemanticObjectController#navigationTargetsObtained event.
   *
   * @deprecated As of version 1.126. replaced by `navigationTargetsObtainedCallback` property.
   */
  export type SemanticObjectController$NavigationTargetsObtainedEvent = Event<
    SemanticObjectController$NavigationTargetsObtainedEventParameters,
    SemanticObjectController
  >;

  /**
   * Parameters of the SemanticObjectController#prefetchDone event.
   *
   * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
   * `prefetchNavigationTargets` which has been deprecated.
   */
  export interface SemanticObjectController$PrefetchDoneEventParameters {
    /**
     * A map containing all semantic objects as keys for which at least one navigation target has been found.
     * The value for each semantic object key is an array containing the available actions found for this semantic
     * object.
     */
    semanticObjects?: object;
  }

  /**
   * Event object of the SemanticObjectController#prefetchDone event.
   *
   * @deprecated As of version 1.42.0. The event `prefetchDone` is obsolete because it depends on the property
   * `prefetchNavigationTargets` which has been deprecated.
   */
  export type SemanticObjectController$PrefetchDoneEvent = Event<
    SemanticObjectController$PrefetchDoneEventParameters,
    SemanticObjectController
  >;
}

declare module "sap/ui/comp/odata/ComboBox" {
  import {
    default as ComboBox1,
    $ComboBoxSettings as $ComboBoxSettings1,
  } from "sap/m/ComboBox";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Extends the functionalities in sap.m.ComboBox
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class ComboBox
    extends ComboBox1
    implements /* was: sap.ui.comp.IDropDownTextArrangement */ Object
  {
    __implements__sap_ui_comp_IDropDownTextArrangement: boolean;
    /**
     * Constructor for a new `odata/ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );
    /**
     * Constructor for a new `odata/ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.odata.ComboBox with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ComboBox.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.odata.ComboBox.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectedKeyChange selectedKeyChange} event of
     * this `sap.ui.comp.odata.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.odata.ComboBox` itself.
     *
     * This event is fired when the selected key has changed only when: The key is valid. The control is visible
     * There is a change when the control gets visible.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectedKeyChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectedKeyChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.odata.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectedKeyChange selectedKeyChange} event of
     * this `sap.ui.comp.odata.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.odata.ComboBox` itself.
     *
     * This event is fired when the selected key has changed only when: The key is valid. The control is visible
     * There is a change when the control gets visible.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectedKeyChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectedKeyChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.odata.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectedKeyChange selectedKeyChange} event
     * of this `sap.ui.comp.odata.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectedKeyChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectedKeyChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:selectedKeyChange selectedKeyChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectedKeyChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ComboBox$SelectedKeyChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getTextArrangement textArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `textArrangement`
     */
    getTextArrangement(): string;
    /**
     * Sets a new value for property {@link #getTextArrangement textArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextArrangement(
      /**
       * New value for property `textArrangement`
       */
      sTextArrangement?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBox constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $ComboBoxSettings extends $ComboBoxSettings1 {
    /**
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     */
    textArrangement?: string | PropertyBindingInfo;

    /**
     * This event is fired when the selected key has changed only when: The key is valid. The control is visible
     * There is a change when the control gets visible.
     */
    selectedKeyChange?: (oEvent: ComboBox$SelectedKeyChangeEvent) => void;
  }

  /**
   * Parameters of the ComboBox#selectedKeyChange event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface ComboBox$SelectedKeyChangeEventParameters {
    /**
     * The selected key.
     */
    selectedKey?: string;
  }

  /**
   * Event object of the ComboBox#selectedKeyChange event.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type ComboBox$SelectedKeyChangeEvent = Event<
    ComboBox$SelectedKeyChangeEventParameters,
    ComboBox
  >;
}

declare module "sap/ui/comp/p13n/P13nItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base type for `items` aggregation in `P13nPanel` control.
   *
   * @since 1.136
   */
  export default class P13nItem extends UI5Element {
    /**
     * Constructor for a new P13nItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $P13nItemSettings
    );
    /**
     * Constructor for a new P13nItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $P13nItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.p13n.P13nItem with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, P13nItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.p13n.P13nItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAggregationRole aggregationRole}.
     *
     * Defines aggregation role
     *
     * @since 1.34.0
     *
     * @returns Value of property `aggregationRole`
     */
    getAggregationRole(): string;
    /**
     * Gets current value of property {@link #getColumnKey columnKey}.
     *
     * Can be used as input for subsequent actions.
     *
     *
     * @returns Value of property `columnKey`
     */
    getColumnKey(): string;
    /**
     * Gets current value of property {@link #getDescription description}.
     *
     * Defines additional information of the link.
     *
     * @since 1.56.0
     *
     * @returns Value of property `description`
     */
    getDescription(): string;
    /**
     * Gets current value of property {@link #getFormatSettings formatSettings}.
     *
     * A JSON object containing the formatSettings which will be used to pass additional type/format settings
     * for the entered value. if type==time or date or datetime the object will be used for the DateFormatter,
     * TimeFormatter or DateTimeFormatter
     *
     * Below you can find a brief example
     *
     *
     * ```javascript
     *
     * {
     * 		UTC: false,
     * 		style: "medium" //"short" or "long"
     * }
     * ```
     *
     *
     * @since 1.52
     *
     * @returns Value of property `formatSettings`
     */
    getFormatSettings(): object;
    /**
     * Gets current value of property {@link #getHref href}.
     *
     * Defines href of a link.
     *
     * @since 1.46.0
     *
     * @returns Value of property `href`
     */
    getHref(): string;
    /**
     * Gets current value of property {@link #getIsDefault isDefault}.
     *
     * the column with isDefault==true will be used as the selected column item on the conditionPanel
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `isDefault`
     */
    getIsDefault(): boolean;
    /**
     * Gets current value of property {@link #getMaxLength maxLength}.
     *
     * specifies the number of characters which can be entered in the value fields of the condition panel
     *
     *
     * @returns Value of property `maxLength`
     */
    getMaxLength(): string;
    /**
     * Gets current value of property {@link #getNullable nullable}.
     *
     * Defines if the item is nullable
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `nullable`
     */
    getNullable(): boolean;
    /**
     * Gets current value of property {@link #getPrecision precision}.
     *
     * if type==numeric the precision will be used to format the entered value (maxIntegerDigits of the used
     * Formatter)
     *
     *
     * @returns Value of property `precision`
     */
    getPrecision(): string;
    /**
     * Gets current value of property {@link #getPress press}.
     *
     * Defines press handler of a link.
     *
     * @since 1.46.0
     *
     * @returns Value of property `press`
     */
    getPress(): object;
    /**
     * Gets current value of property {@link #getRole role}.
     *
     * Defines role. The role is reflected in the manner how the dimension will influence the chart layout.
     *
     * @since 1.34.0
     *
     * @returns Value of property `role`
     */
    getRole(): string;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * if type==numeric the scale will be used to format the entered value (maxFractionDigits of the used Formatter)
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Gets current value of property {@link #getTarget target}.
     *
     * Defines target of a link.
     *
     *
     * @returns Value of property `target`
     */
    getTarget(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The text to be displayed for the item.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * data type of the column (text, numeric or date is supported)
     *
     * Default value is `"text"`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property {@link #getTypeInstance typeInstance}.
     *
     * data type instance of the column. Can be used instead of the type, precision, scale and formatSettings
     * properties
     *
     * @since 1.56
     *
     * @returns Value of property `typeInstance`
     */
    getTypeInstance(): object;
    /**
     * Gets current value of property {@link #getValues values}.
     *
     * the array of values for type bool. e.g. ["", "Off", "On"]. The first entry can be empty (used to blank
     * the value field). Next value represent the false value, last entry the true value.
     *
     * @since 1.34.0
     *
     * @returns Value of property `values`
     */
    getValues(): string[];
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Defines visibility of column
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines column width
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): string;
    /**
     * Sets a new value for property {@link #getAggregationRole aggregationRole}.
     *
     * Defines aggregation role
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAggregationRole(
      /**
       * New value for property `aggregationRole`
       */
      sAggregationRole?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColumnKey columnKey}.
     *
     * Can be used as input for subsequent actions.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnKey(
      /**
       * New value for property `columnKey`
       */
      sColumnKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDescription description}.
     *
     * Defines additional information of the link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.56.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDescription(
      /**
       * New value for property `description`
       */
      sDescription?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFormatSettings formatSettings}.
     *
     * A JSON object containing the formatSettings which will be used to pass additional type/format settings
     * for the entered value. if type==time or date or datetime the object will be used for the DateFormatter,
     * TimeFormatter or DateTimeFormatter
     *
     * Below you can find a brief example
     *
     *
     * ```javascript
     *
     * {
     * 		UTC: false,
     * 		style: "medium" //"short" or "long"
     * }
     * ```
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.52
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormatSettings(
      /**
       * New value for property `formatSettings`
       */
      oFormatSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getHref href}.
     *
     * Defines href of a link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHref(
      /**
       * New value for property `href`
       */
      sHref?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIsDefault isDefault}.
     *
     * the column with isDefault==true will be used as the selected column item on the conditionPanel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDefault(
      /**
       * New value for property `isDefault`
       */
      bIsDefault?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxLength maxLength}.
     *
     * specifies the number of characters which can be entered in the value fields of the condition panel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxLength(
      /**
       * New value for property `maxLength`
       */
      sMaxLength?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNullable nullable}.
     *
     * Defines if the item is nullable
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNullable(
      /**
       * New value for property `nullable`
       */
      bNullable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPrecision precision}.
     *
     * if type==numeric the precision will be used to format the entered value (maxIntegerDigits of the used
     * Formatter)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrecision(
      /**
       * New value for property `precision`
       */
      sPrecision?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPress press}.
     *
     * Defines press handler of a link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPress(
      /**
       * New value for property `press`
       */
      oPress?: object
    ): this;
    /**
     * Sets a new value for property {@link #getRole role}.
     *
     * Defines role. The role is reflected in the manner how the dimension will influence the chart layout.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRole(
      /**
       * New value for property `role`
       */
      sRole?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * if type==numeric the scale will be used to format the entered value (maxFractionDigits of the used Formatter)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTarget target}.
     *
     * Defines target of a link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * New value for property `target`
       */
      sTarget?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * The text to be displayed for the item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * data type of the column (text, numeric or date is supported)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"text"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTypeInstance typeInstance}.
     *
     * data type instance of the column. Can be used instead of the type, precision, scale and formatSettings
     * properties
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.56
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTypeInstance(
      /**
       * New value for property `typeInstance`
       */
      oTypeInstance?: object
    ): this;
    /**
     * Sets a new value for property {@link #getValues values}.
     *
     * the array of values for type bool. e.g. ["", "Off", "On"]. The first entry can be empty (used to blank
     * the value field). Next value represent the false value, last entry the true value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValues(
      /**
       * New value for property `values`
       */
      sValues?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Defines visibility of column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines column width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the P13nItem constructor.
   */
  export interface $P13nItemSettings extends $ElementSettings {
    /**
     * Can be used as input for subsequent actions.
     */
    columnKey?: string | PropertyBindingInfo;

    /**
     * The text to be displayed for the item.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines visibility of column
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * data type of the column (text, numeric or date is supported)
     */
    type?: string | PropertyBindingInfo;

    /**
     * data type instance of the column. Can be used instead of the type, precision, scale and formatSettings
     * properties
     *
     * @since 1.56
     */
    typeInstance?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * if type==numeric the precision will be used to format the entered value (maxIntegerDigits of the used
     * Formatter)
     */
    precision?: string | PropertyBindingInfo;

    /**
     * A JSON object containing the formatSettings which will be used to pass additional type/format settings
     * for the entered value. if type==time or date or datetime the object will be used for the DateFormatter,
     * TimeFormatter or DateTimeFormatter
     *
     * Below you can find a brief example
     *
     *
     * ```javascript
     *
     * {
     * 		UTC: false,
     * 		style: "medium" //"short" or "long"
     * }
     * ```
     *
     *
     * @since 1.52
     */
    formatSettings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * if type==numeric the scale will be used to format the entered value (maxFractionDigits of the used Formatter)
     */
    scale?: string | PropertyBindingInfo;

    /**
     * specifies the number of characters which can be entered in the value fields of the condition panel
     */
    maxLength?: string | PropertyBindingInfo;

    /**
     * Defines column width
     */
    width?: string | PropertyBindingInfo;

    /**
     * the column with isDefault==true will be used as the selected column item on the conditionPanel
     */
    isDefault?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * the array of values for type bool. e.g. ["", "Off", "On"]. The first entry can be empty (used to blank
     * the value field). Next value represent the false value, last entry the true value.
     *
     * @since 1.34.0
     */
    values?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines role. The role is reflected in the manner how the dimension will influence the chart layout.
     *
     * @since 1.34.0
     */
    role?: string | PropertyBindingInfo;

    /**
     * Defines aggregation role
     *
     * @since 1.34.0
     */
    aggregationRole?: string | PropertyBindingInfo;

    /**
     * Defines href of a link.
     *
     * @since 1.46.0
     */
    href?: string | PropertyBindingInfo;

    /**
     * Defines target of a link.
     */
    target?: string | PropertyBindingInfo;

    /**
     * Defines press handler of a link.
     *
     * @since 1.46.0
     */
    press?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines additional information of the link.
     *
     * @since 1.56.0
     */
    description?: string | PropertyBindingInfo;

    /**
     * Defines if the item is nullable
     */
    nullable?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartchart/SmartChart" {
  import { default as VBox, $VBoxSettings } from "sap/m/VBox";

  import Item from "sap/ui/core/Item";

  import Event from "sap/ui/base/Event";

  import Chart from "sap/chart/Chart";

  import { TitleLevel, ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { smartchart } from "sap/ui/comp/library";

  import SemanticObjectController from "sap/ui/comp/navpopover/SemanticObjectController";

  import Toolbar from "sap/m/Toolbar";

  import { ToolbarStyle, SelectionDetailsActionLevel } from "sap/m/library";

  import UIState from "sap/ui/comp/state/UIState";

  import Control from "sap/ui/core/Control";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Context from "sap/ui/model/Context";

  /**
   * The `SmartChart` control creates a chart based on the OData metadata and the provided configuration.
   * To use the control, the `entitySet` property must be specified. This property is used to fetch the metadata,
   * from which the chart UI will be generated.
   *  Based on the `chartType` property, this control will render initially the corresponding chart.
   *  **Note:** Most of the properties are not dynamic and cannot be changed once the control has been initialized.
   *
   * **Important:** Keep in mind that `SmartChart`, like all SAPUI5 smart controls, retrieves and analyzes
   * the metadata and annotations of OData services. **The OData metadata is its primary API. These OData
   * services are not part of the SAPUI5 framework and are usually maintained by the backend developers of
   * your application.**
   *
   * With time, `SmartChart` can evolve and acquire new features. This means that its behavior or functionalities
   * may change if the annotations that define this change are maintained in your backend metadata. To benefit
   * from the new functionalities, your application should be able to adapt the backend metadata. **Therefore,
   * we recommend using `SmartChart` only if you have control over the metadata of your application.**
   */
  export default class SmartChart extends VBox {
    /**
     * Constructor for a new SmartChart instance.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/7a32157697474864b041fa739fcc51ba Smart Chart}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartChartSettings
    );
    /**
     * Constructor for a new SmartChart instance.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/7a32157697474864b041fa739fcc51ba Smart Chart}
     */
    constructor(
      /**
       * ID for the new control that is generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartchart.SmartChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.VBox.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartchart.SmartChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some selectionDetailsAction to the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSelectionDetailsAction(
      /**
       * The selectionDetailsAction to add; if empty, nothing is inserted
       */
      oSelectionDetailsAction: Item
    ): this;
    /**
     * Adds some selectionDetailsActionGroup to the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSelectionDetailsActionGroup(
      /**
       * The selectionDetailsActionGroup to add; if empty, nothing is inserted
       */
      oSelectionDetailsActionGroup: Item
    ): this;
    /**
     * Adds some selectionDetailsItemAction to the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSelectionDetailsItemAction(
      /**
       * The selectionDetailsItemAction to add; if empty, nothing is inserted
       */
      oSelectionDetailsItemAction: Item
    ): this;
    /**
     * Interface function for SmartVariantManagement control that applies the current variant.
     */
    applyVariant(
      /**
       * The variant JSON
       */
      oVariantJSON: Variant,
      /**
       * Describes the context in which the variant has been applied
       */
      sContext: string
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantApply afterVariantApply} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after a variant has been applied.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantApply(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantApplyEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantApply afterVariantApply} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after a variant has been applied.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantApply(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantApplyEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantInitialise afterVariantInitialise }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after the variant management in the SmartChart control has been initialized.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantInitialise(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantInitialise afterVariantInitialise }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after the variant management in the SmartChart control has been initialized.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantInitialise(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after a variant has been saved. This event can be used to retrieve the ID of the
     * saved variant.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantSave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantSaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired after a variant has been saved. This event can be used to retrieve the ID of the
     * saved variant.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterVariantSave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantSaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeRebindChart beforeRebindChart} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right before the `SmartChart` control triggers the binding / rebinding of the inner
     * chart.
     *  **Note:** In certain cases the inner chart triggers a rebinding by itself. In these cases, the event
     * is not fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeRebindChart(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$BeforeRebindChartEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeRebindChart beforeRebindChart} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right before the `SmartChart` control triggers the binding / rebinding of the inner
     * chart.
     *  **Note:** In certain cases the inner chart triggers a rebinding by itself. In these cases, the event
     * is not fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeRebindChart(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$BeforeRebindChartEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDataChanged chartDataChanged} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when `SmartChart` control data changes, due to changes in the personalization dialog
     * or drill operations.
     *  The data can be changed via sorters, filters or drill-ups/drill-downs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDataChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$ChartDataChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDataChanged chartDataChanged} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when `SmartChart` control data changes, due to changes in the personalization dialog
     * or drill operations.
     *  The data can be changed via sorters, filters or drill-ups/drill-downs.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDataChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$ChartDataChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when data is received after binding. This event is fired if the binding for the chart
     * is done by the SmartChart control itself.
     *
     * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
     * directly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataReceived(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when data is received after binding. This event is fired if the binding for the chart
     * is done by the SmartChart control itself.
     *
     * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
     * directly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataReceived(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fullScreenToggled fullScreenToggled} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right after the full screen mode of the SmartChart control has been changed.
     *
     * @since 1.46
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFullScreenToggled(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$FullScreenToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fullScreenToggled fullScreenToggled} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right after the full screen mode of the SmartChart control has been changed.
     *
     * @since 1.46
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFullScreenToggled(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$FullScreenToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Loads the chart lib synchronously before the event is attached. That is done for compatibility reasons.
     * **Note:** Attaching to this event causes the inner chart to load synchronously. This does not fulfill
     * CSP requirements. Please use event `initialized` instead.
     *
     * @deprecated As of version 1.94. replaced by {@link #event:initialized}
     */
    attachInitialise(): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired once the control has been initialized, asynchronous successor of `initialise`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialized initialized} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired once the control has been initialized, asynchronous successor of `initialise`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialized(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionDetailsActionPress selectionDetailsActionPress }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when any action in the selection details popover is pressed.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionDetailsActionPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$SelectionDetailsActionPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionDetailsActionPress selectionDetailsActionPress }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when any action in the selection details popover is pressed.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionDetailsActionPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartChart$SelectionDetailsActionPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showOverlay showOverlay} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right before the overlay is shown.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowOverlay(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:showOverlay showOverlay} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired right before the overlay is shown.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShowOverlay(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uiStateChange uiStateChange} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when the UI state changes either via the {@link sap.ui.comp.smartchart.SmartChart#setUiState }
     * method or the chart personalization.
     *
     * @since 1.96.15
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUiStateChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uiStateChange uiStateChange} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartchart.SmartChart` itself.
     *
     * This event is fired when the UI state changes either via the {@link sap.ui.comp.smartchart.SmartChart#setUiState }
     * method or the chart personalization.
     *
     * @since 1.96.15
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUiStateChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartchart.SmartChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the selectionDetailsActionGroups in the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySelectionDetailsActionGroups(): this;
    /**
     * Destroys all the selectionDetailsActions in the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySelectionDetailsActions(): this;
    /**
     * Destroys all the selectionDetailsItemActions in the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySelectionDetailsItemActions(): this;
    /**
     * Destroys the semanticObjectController in the aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySemanticObjectController(): this;
    /**
     * Destroys the toolbar in the aggregation {@link #getToolbar toolbar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolbar(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterVariantApply afterVariantApply} event
     * of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterVariantApply(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantApplyEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterVariantInitialise afterVariantInitialise }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterVariantInitialise(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterVariantSave afterVariantSave} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterVariantSave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$AfterVariantSaveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeRebindChart beforeRebindChart} event
     * of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeRebindChart(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$BeforeRebindChartEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartDataChanged chartDataChanged} event of
     * this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartDataChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$ChartDataChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
     * directly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataReceived(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:fullScreenToggled fullScreenToggled} event
     * of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.46
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFullScreenToggled(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$FullScreenToggledEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialise initialise} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.65. replaced by {@link initialized}.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialise(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialized initialized} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialized(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionDetailsActionPress selectionDetailsActionPress }
     * event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionDetailsActionPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartChart$SelectionDetailsActionPressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:showOverlay showOverlay} event of this `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShowOverlay(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uiStateChange uiStateChange} event of this
     * `sap.ui.comp.smartchart.SmartChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.96.15
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUiStateChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Cleans up the control.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    exit(): void;
    /**
     * Function for the {@link sap.ui.comp.smartvariants.SmartVariantManagement} control that returns the currently
     * used variant data in an internal format. **Note:** This function must not be used by applications.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The currently used variant in an internal format
     */
    fetchVariant(): Variant;
    /**
     * Fires event {@link #event:afterVariantApply afterVariantApply} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterVariantApply(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$AfterVariantApplyEventParameters
    ): this;
    /**
     * Fires event {@link #event:afterVariantInitialise afterVariantInitialise} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterVariantInitialise(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:afterVariantSave afterVariantSave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterVariantSave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$AfterVariantSaveEventParameters
    ): this;
    /**
     * Fires event {@link #event:beforeRebindChart beforeRebindChart} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeRebindChart(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$BeforeRebindChartEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartDataChanged chartDataChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartDataChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$ChartDataChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:dataReceived dataReceived} to attached listeners.
     *
     * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
     * directly
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataReceived(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:fullScreenToggled fullScreenToggled} to attached listeners.
     *
     * @since 1.46
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFullScreenToggled(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$FullScreenToggledEventParameters
    ): this;
    /**
     * Fires event {@link #event:initialise initialise} to attached listeners.
     *
     * @deprecated As of version 1.65. replaced by {@link initialized}.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialise(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialized initialized} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialized(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionDetailsActionPress selectionDetailsActionPress} to attached listeners.
     *
     * @since 1.48
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionDetailsActionPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartChart$SelectionDetailsActionPressEventParameters
    ): this;
    /**
     * Fires event {@link #event:showOverlay showOverlay} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShowOverlay(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:uiStateChange uiStateChange} to attached listeners.
     *
     * @since 1.96.15
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUiStateChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getActivateTimeSeries activateTimeSeries}.
     *
     * Enables the use of timeseries on the inner chart when corresponding annotation is given
     *
     * **Note:** This timeseries is only supported for the following {@link sap.chart.TimeUnitType TimeUnitTypes }
     * and the following chart types {@link sap.viz.ui5.controls.VizFrame#getVizType}.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `activateTimeSeries`
     */
    getActivateTimeSeries(): boolean;
    /**
     * Returns the chart object used internally.
     *  **Note:** Direct changes made to the inner {@link sap.chart.Chart chart} object or its {@link sap.viz.ui5.controls.VizFrame vizFrame }
     * might lead to inconsistencies and side effects during runtime, as the `SmartChart` control doesn"t listen
     * to all changes made to the inner {@link sap.chart.Chart chart} instance. To avoid this, please use the
     * API provided by the `SmartChart` control itself. **Note:** Calling this method when the chart is not
     * yet initialized causes the inner chart to load synchronously. This does not fulfill CSP requirements.
     * Please use `getChartAsync` instead.
     *
     * @deprecated As of version 1.57. replaced by {@link #getChartAsync}
     *
     * @returns The inner chart object
     */
    getChart(): Chart;
    /**
     * Returns a promise which will be resolved with the internally used chart object, once all dependencies
     * have been loaded.
     *  **Note:** Direct changes made to the inner {@link sap.chart.Chart chart} object or its {@link sap.viz.ui5.controls.VizFrame vizFrame }
     * might lead to inconsistencies and side effects during runtime, as the `SmartChart` control doesn't listen
     * to all changes made to the inner {@link sap.chart.Chart chart} instance. To avoid this, please use the
     * API provided by the `SmartChart` control itself.
     *
     * @since 1.57.0
     *
     * @returns Promise for inner chart object
     */
    getChartAsync(): Promise<Chart>;
    /**
     * Gets current value of property {@link #getChartBindingPath chartBindingPath}.
     *
     * Specifies the path that is used during the binding of the chart. If not specified, the entitySet property
     * is used instead. (used only if binding is established internally/automatically - See enableAutoBinding)
     *
     *
     * @returns Value of property `chartBindingPath`
     */
    getChartBindingPath(): string;
    /**
     * Gets current value of property {@link #getChartType chartType}.
     *
     * Specifies the type of chart to be created by the SmartChart control.
     *
     *
     * @returns Value of property `chartType`
     */
    getChartType(): string;
    /**
     * Returns the ID of the currently selected variant.
     *
     *
     * @returns ID of the currently selected variant
     */
    getCurrentVariantId(): string;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * or entitySet property. This happens right after the `initialise` event has been fired.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
    /**
     * Gets current value of property {@link #getEntitySet entitySet}.
     *
     * The entity set name from which to fetch data and generate the columns.
     *  **Note** This is not a dynamic property.
     *
     *
     * @returns Value of property `entitySet`
     */
    getEntitySet(): string;
    /**
     * Gets current value of property {@link #getHeader header}.
     *
     * Specifies header text that is shown in the chart.
     *
     *
     * @returns Value of property `header`
     */
    getHeader(): string;
    /**
     * Gets current value of property {@link #getHeaderLevel headerLevel}.
     *
     * Semantic level of the header.
     *  For more information, see {@link sap.m.Title#setLevel}.
     *
     * Default value is `Auto`.
     *
     * @since 1.118
     *
     * @returns Value of property `headerLevel`
     */
    getHeaderLevel(): TitleLevel;
    /**
     * Gets current value of property {@link #getHeaderStyle headerStyle}.
     *
     * Defines style of the header.
     *  For more information, see {@link sap.m.Title#setTitle}.
     *
     * Default value is `Auto`.
     *
     * @since 1.119
     *
     * @returns Value of property `headerStyle`
     */
    getHeaderStyle(): TitleLevel;
    /**
     * Gets current value of property {@link #getIgnoredChartTypes ignoredChartTypes}.
     *
     * CSV of fields that is not shown in the list of available chart types.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     *
     * @returns Value of property `ignoredChartTypes`
     */
    getIgnoredChartTypes(): string;
    /**
     * Gets current value of property {@link #getIgnoredFields ignoredFields}.
     *
     * CSV of fields that must be ignored in the OData metadata by the SmartChart control.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     *
     * @returns Value of property `ignoredFields`
     */
    getIgnoredFields(): string;
    /**
     * Gets current value of property {@link #getIgnoreFromPersonalisation ignoreFromPersonalisation}.
     *
     * CSV of fields that is not shown in the personalization dialog.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     *
     * @returns Value of property `ignoreFromPersonalisation`
     */
    getIgnoreFromPersonalisation(): string;
    /**
     * Gets current value of property {@link #getLegendVisible legendVisible}.
     *
     * Set chart's legend properties.
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `legendVisible`
     */
    getLegendVisible(): boolean;
    /**
     * Gets current value of property {@link #getNoData noData}.
     *
     * Defines the custom text that will be displayed in case no data is found for the current binding.
     *
     * @since 1.46
     *
     * @returns Value of property `noData`
     */
    getNoData(): string;
    /**
     * Gets current value of property {@link #getNotAssignedText notAssignedText}.
     *
     * Text that is shown for values of an empty string. **Note:** The property does not change the behavior
     * for charts of type `timeseries`. **Note:** Can only be changed in the XML/JS view. It cannot be changed
     * once the control has been initialized.
     *
     * Default value is `empty string`.
     *
     * @since 1.106
     *
     * @returns Value of property `notAssignedText`
     */
    getNotAssignedText(): string;
    /**
     * Gets current value of property {@link #getPersistencyKey persistencyKey}.
     *
     * Key used to access personalization data.
     *
     *
     * @returns Value of property `persistencyKey`
     */
    getPersistencyKey(): string;
    /**
     * Gets current value of property {@link #getRequestAtLeastFields requestAtLeastFields}.
     *
     * CSV of fields that must be always requested by the backend system.
     *  This property is mainly meant to be used if there is no PresentationVariant annotation.
     *  If both this property and the PresentationVariant annotation exist, the select request sent to the backend
     * would be a combination of both.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters. Also,
     * setting this property during runtime, will delete the current drill-stack and lead to a loss of the drill
     * history.
     *
     *
     * @returns Value of property `requestAtLeastFields`
     */
    getRequestAtLeastFields(): string;
    /**
     * Gets content of aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * Actions on group level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    getSelectionDetailsActionGroups(): Item[];
    /**
     * Gets content of aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * Actions on footer level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    getSelectionDetailsActions(): Item[];
    /**
     * Gets content of aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * Actions on item level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    getSelectionDetailsItemActions(): Item[];
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Chart selection mode. Supported values are {@link sap.ui.comp.smartchart.SelectionMode.Single} or {@link sap.ui.comp.smartchart.SelectionMode.Multi},
     * case insensitive, always return in upper case. Unsupported values will be ignored.
     *
     * Default value is `Multi`.
     *
     * @since 1.36
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): smartchart.SelectionMode;
    /**
     * Gets content of aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     *
     * @since 1.36
     */
    getSemanticObjectController(): SemanticObjectController;
    /**
     * Gets current value of property {@link #getShowChartTooltip showChartTooltip}.
     *
     * Controls the visibility of the chart tooltip. If set to `true `, an instance of sap.viz.ui5.controls.VizTooltip
     * will be created and shown when hovering over a data point.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Value of property `showChartTooltip`
     */
    getShowChartTooltip(): boolean;
    /**
     * Gets current value of property {@link #getShowChartTypeSelectionButton showChartTypeSelectionButton}.
     *
     * Controls the visibility of the chart type selection button.
     *
     * Default value is `true`.
     *
     * @since 1.48
     *
     * @returns Value of property `showChartTypeSelectionButton`
     */
    getShowChartTypeSelectionButton(): boolean;
    /**
     * Gets current value of property {@link #getShowDetailsButton showDetailsButton}.
     *
     * Controls the visibility of the Details button. If set to `true`, the datapoint tooltip will be disabled
     * as the information of selected datapoints will be found in the details popover. This will also set the
     * drill-down button to invisible.
     *
     * Default value is `false`.
     *
     * @since 1.38
     *
     * @returns Value of property `showDetailsButton`
     */
    getShowDetailsButton(): boolean;
    /**
     * Gets current value of property {@link #getShowDimensionsTitle showDimensionsTitle}.
     *
     * Controls the visibility of the title in the dimension area of the chart.
     *
     * Default value is `true`.
     *
     * @since 1.54
     *
     * @returns Value of property `showDimensionsTitle`
     */
    getShowDimensionsTitle(): boolean;
    /**
     * Gets current value of property {@link #getShowDownloadButton showDownloadButton}.
     *
     * Controls the visibility of the chart download button.
     *
     * Default value is `false`.
     *
     * @since 1.39
     *
     * @returns Value of property `showDownloadButton`
     */
    getShowDownloadButton(): boolean;
    /**
     * Gets current value of property {@link #getShowDrillBreadcrumbs showDrillBreadcrumbs}.
     *
     * Controls the visibility of the Breadcrumbs control for drilling up within the visible dimensions. If
     * set to `true`, the toolbar header will be replaced by the Breadcrumbs control. This will also set the
     * drill-up button to invisible.
     *
     * Default value is `false`.
     *
     * @since 1.38
     *
     * @returns Value of property `showDrillBreadcrumbs`
     */
    getShowDrillBreadcrumbs(): boolean;
    /**
     * Gets current value of property {@link #getShowDrillButtons showDrillButtons}.
     *
     * Controls the visibility of the Drill Up and Drill Down buttons.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDrillButtons`
     */
    getShowDrillButtons(): boolean;
    /**
     * Gets current value of property {@link #getShowFullScreenButton showFullScreenButton}.
     *
     * Controls the visibility of the FullScreen button.
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `showFullScreenButton`
     */
    getShowFullScreenButton(): boolean;
    /**
     * Gets current value of property {@link #getShowLegendButton showLegendButton}.
     *
     * Controls the visibility of the Navigation button
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `showLegendButton`
     */
    getShowLegendButton(): boolean;
    /**
     * Gets current value of property {@link #getShowMeasuresTitle showMeasuresTitle}.
     *
     * Controls the visibility of the title in the measure area of the chart.
     *
     * Default value is `true`.
     *
     * @since 1.54
     *
     * @returns Value of property `showMeasuresTitle`
     */
    getShowMeasuresTitle(): boolean;
    /**
     * Gets current value of property {@link #getShowSemanticNavigationButton showSemanticNavigationButton}.
     *
     * Controls the visibility of the Navigation button
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `showSemanticNavigationButton`
     */
    getShowSemanticNavigationButton(): boolean;
    /**
     * Gets current value of property {@link #getShowToolbar showToolbar}.
     *
     * Controls the visibility of the toolbar.
     *
     * Default value is `true`.
     *
     * @since 1.54
     *
     * @returns Value of property `showToolbar`
     */
    getShowToolbar(): boolean;
    /**
     * Gets current value of property {@link #getShowVariantManagement showVariantManagement}.
     *
     * Controls the visibility of the Variant Management.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Value of property `showVariantManagement`
     */
    getShowVariantManagement(): boolean;
    /**
     * Gets current value of property {@link #getShowZoomButtons showZoomButtons}.
     *
     * Controls the visibility of the Zoom In and Zoom Out buttons.
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `showZoomButtons`
     */
    getShowZoomButtons(): boolean;
    /**
     * Gets current value of property {@link #getSmartFilterId smartFilterId}.
     *
     * ID of the corresponding SmartFilter control. If specified, the SmartChart control searches for the SmartFilter
     * control (also in the closest parent view) and attaches to the relevant events of the SmartFilter control
     * to fetch data, show overlay etc.
     *
     *
     * @returns Value of property `smartFilterId`
     */
    getSmartFilterId(): string;
    /**
     * ID of the element which is the current target of the association {@link #getSmartVariant smartVariant},
     * or `null`.
     *
     * @since 1.38
     */
    getSmartVariant(): ID | null;
    /**
     * Gets content of aggregation {@link #getToolbar toolbar}.
     *
     * A custom toolbar that can be specified by the user to define their own buttons, icons, etc. If this is
     * added, the SmartChart control does not create its own toolbar, but uses this one instead. However, if
     * default actions, such as showSemanticNavigation, showFullScreenButton etc. are set, these actions are
     * added at the left-hand side of the toolbar.
     */
    getToolbar(): Toolbar;
    /**
     * Gets current value of property {@link #getToolbarStyle toolbarStyle}.
     *
     * Defines the visual style of the smart charts `Toolbar`. **Note:** The visual styles are theme-dependent.
     *
     * @since 1.54
     *
     * @returns Value of property `toolbarStyle`
     */
    getToolbarStyle(): ToolbarStyle;
    /**
     * The method returns the current UI state of SmartChart control.
     *
     *
     * @returns Current UI state
     */
    getUiState(): UIState;
    /**
     * Gets current value of property {@link #getUseChartPersonalisation useChartPersonalisation}.
     *
     * If set to `true`, personalized chart settings are defined. If you want to persist the chart personalization,
     * you need to specify the persistencyKey property.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `useChartPersonalisation`
     */
    getUseChartPersonalisation(): boolean;
    /**
     * Gets current value of property {@link #getUseListForChartTypeSelection useListForChartTypeSelection}.
     *
     * Controls the visualization for chart type selection. If set to `true`, the list of available chart types
     * will be displayed. If set to `false` and there are three or fewer available chart types, the chart types
     * will be displayed as separate buttons in the toolbar. If there are more than three chart types, a list
     * will be shown.
     *
     * Default value is `true`.
     *
     * @since 1.38
     * @deprecated As of version 1.48.0. Setting the property to `false` will have no effect on the visualization
     * of chart type selection. `SmartChart` will always show a list of chart types.
     *
     * @returns Value of property `useListForChartTypeSelection`
     */
    getUseListForChartTypeSelection(): boolean;
    /**
     * Gets current value of property {@link #getUseTooltip useTooltip}.
     *
     * Specifies weather an instance of {@link sap.viz.ui5.controls.VizTooltip} or {@link sap.viz.ui5.controls.Popover }
     * is used. If set to `true`, a tooltip will be displayed, a popover otherwise.
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Value of property `useTooltip`
     */
    getUseTooltip(): boolean;
    /**
     * Gets current value of property {@link #getUseVariantManagement useVariantManagement}.
     *
     * If set to `true`, variants are used. As a prerequisite, you need to specify the persistencyKey property.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `useVariantManagement`
     */
    getUseVariantManagement(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Item` in the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.48
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSelectionDetailsAction(
      /**
       * The selectionDetailsAction whose index is looked for
       */
      oSelectionDetailsAction: Item
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Item` in the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.48
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSelectionDetailsActionGroup(
      /**
       * The selectionDetailsActionGroup whose index is looked for
       */
      oSelectionDetailsActionGroup: Item
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Item` in the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.48
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSelectionDetailsItemAction(
      /**
       * The selectionDetailsItemAction whose index is looked for
       */
      oSelectionDetailsItemAction: Item
    ): int;
    /**
     * Inserts a selectionDetailsAction into the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSelectionDetailsAction(
      /**
       * The selectionDetailsAction to insert; if empty, nothing is inserted
       */
      oSelectionDetailsAction: Item,
      /**
       * The `0`-based index the selectionDetailsAction should be inserted at; for a negative value of `iIndex`,
       * the selectionDetailsAction is inserted at position 0; for a value greater than the current size of the
       * aggregation, the selectionDetailsAction is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a selectionDetailsActionGroup into the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSelectionDetailsActionGroup(
      /**
       * The selectionDetailsActionGroup to insert; if empty, nothing is inserted
       */
      oSelectionDetailsActionGroup: Item,
      /**
       * The `0`-based index the selectionDetailsActionGroup should be inserted at; for a negative value of `iIndex`,
       * the selectionDetailsActionGroup is inserted at position 0; for a value greater than the current size
       * of the aggregation, the selectionDetailsActionGroup is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a selectionDetailsItemAction into the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSelectionDetailsItemAction(
      /**
       * The selectionDetailsItemAction to insert; if empty, nothing is inserted
       */
      oSelectionDetailsItemAction: Item,
      /**
       * The `0`-based index the selectionDetailsItemAction should be inserted at; for a negative value of `iIndex`,
       * the selectionDetailsItemAction is inserted at position 0; for a value greater than the current size of
       * the aggregation, the selectionDetailsItemAction is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Checks whether the control is initialized.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns whether the control is already initialized
     */
    isInitialised(): boolean;
    /**
     * This can be used to trigger binding on the chart used in the SmartChart
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    rebindChart(): void;
    /**
     * Removes all the controls from the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.48
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSelectionDetailsActionGroups(): Item[];
    /**
     * Removes all the controls from the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.48
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSelectionDetailsActions(): Item[];
    /**
     * Removes all the controls from the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.48
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSelectionDetailsItemActions(): Item[];
    /**
     * Removes a selectionDetailsAction from the aggregation {@link #getSelectionDetailsActions selectionDetailsActions}.
     *
     * @since 1.48
     *
     * @returns The removed selectionDetailsAction or `null`
     */
    removeSelectionDetailsAction(
      /**
       * The selectionDetailsAction to remove or its index or id
       */
      vSelectionDetailsAction: int | string | Item
    ): Item | null;
    /**
     * Removes a selectionDetailsActionGroup from the aggregation {@link #getSelectionDetailsActionGroups selectionDetailsActionGroups}.
     *
     * @since 1.48
     *
     * @returns The removed selectionDetailsActionGroup or `null`
     */
    removeSelectionDetailsActionGroup(
      /**
       * The selectionDetailsActionGroup to remove or its index or id
       */
      vSelectionDetailsActionGroup: int | string | Item
    ): Item | null;
    /**
     * Removes a selectionDetailsItemAction from the aggregation {@link #getSelectionDetailsItemActions selectionDetailsItemActions}.
     *
     * @since 1.48
     *
     * @returns The removed selectionDetailsItemAction or `null`
     */
    removeSelectionDetailsItemAction(
      /**
       * The selectionDetailsItemAction to remove or its index or id
       */
      vSelectionDetailsItemAction: int | string | Item
    ): Item | null;
    /**
     * Sets a new value for property {@link #getActivateTimeSeries activateTimeSeries}.
     *
     * Enables the use of timeseries on the inner chart when corresponding annotation is given
     *
     * **Note:** This timeseries is only supported for the following {@link sap.chart.TimeUnitType TimeUnitTypes }
     * and the following chart types {@link sap.viz.ui5.controls.VizFrame#getVizType}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActivateTimeSeries(
      /**
       * New value for property `activateTimeSeries`
       */
      bActivateTimeSeries?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getChartBindingPath chartBindingPath}.
     *
     * Specifies the path that is used during the binding of the chart. If not specified, the entitySet property
     * is used instead. (used only if binding is established internally/automatically - See enableAutoBinding)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartBindingPath(
      /**
       * New value for property `chartBindingPath`
       */
      sChartBindingPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getChartType chartType}.
     *
     * Specifies the type of chart to be created by the SmartChart control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartType(
      /**
       * New value for property `chartType`
       */
      sChartType?: string
    ): this;
    /**
     * Applies the current variant based on the sVariantId parameter. If an empty string or null or undefined
     * have been passed, the standard variant will be used. The standard variant will also be used if the passed
     * sVariantId cannot be found. If the flexibility variant, the content for the standard variant, or the
     * personalizable control cannot be obtained, no changes will be made.
     */
    setCurrentVariantId(
      /**
       * ID of the currently selected variant
       */
      sVariantId: string
    ): void;
    /**
     * Sets a new value for property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * or entitySet property. This happens right after the `initialise` event has been fired.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoBinding(
      /**
       * New value for property `enableAutoBinding`
       */
      bEnableAutoBinding?: boolean
    ): this;
    /**
     * The entity set name in the OData metadata against which the chart must be bound.
     */
    setEntitySet(
      /**
       * The entity set
       */
      sEntitySetName: string
    ): void;
    /**
     * Sets a new value for property {@link #getHeader header}.
     *
     * Specifies header text that is shown in the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeader(
      /**
       * New value for property `header`
       */
      sHeader?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderLevel headerLevel}.
     *
     * Semantic level of the header.
     *  For more information, see {@link sap.m.Title#setLevel}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.118
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderLevel(
      /**
       * New value for property `headerLevel`
       */
      sHeaderLevel?: TitleLevel | keyof typeof TitleLevel
    ): this;
    /**
     * Sets a new value for property {@link #getHeaderStyle headerStyle}.
     *
     * Defines style of the header.
     *  For more information, see {@link sap.m.Title#setTitle}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.119
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderStyle(
      /**
       * New value for property `headerStyle`
       */
      sHeaderStyle?: TitleLevel | keyof typeof TitleLevel
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoredChartTypes ignoredChartTypes}.
     *
     * CSV of fields that is not shown in the list of available chart types.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoredChartTypes(
      /**
       * New value for property `ignoredChartTypes`
       */
      sIgnoredChartTypes?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoredFields ignoredFields}.
     *
     * CSV of fields that must be ignored in the OData metadata by the SmartChart control.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * New value for property `ignoredFields`
       */
      sIgnoredFields?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoreFromPersonalisation ignoreFromPersonalisation}.
     *
     * CSV of fields that is not shown in the personalization dialog.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoreFromPersonalisation(
      /**
       * New value for property `ignoreFromPersonalisation`
       */
      sIgnoreFromPersonalisation?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNoData noData}.
     *
     * Defines the custom text that will be displayed in case no data is found for the current binding.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.46
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNoData(
      /**
       * New value for property `noData`
       */
      sNoData?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNotAssignedText notAssignedText}.
     *
     * Text that is shown for values of an empty string. **Note:** The property does not change the behavior
     * for charts of type `timeseries`. **Note:** Can only be changed in the XML/JS view. It cannot be changed
     * once the control has been initialized.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.106
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNotAssignedText(
      /**
       * New value for property `notAssignedText`
       */
      sNotAssignedText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPersistencyKey persistencyKey}.
     *
     * Key used to access personalization data.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPersistencyKey(
      /**
       * New value for property `persistencyKey`
       */
      sPersistencyKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRequestAtLeastFields requestAtLeastFields}.
     *
     * CSV of fields that must be always requested by the backend system.
     *  This property is mainly meant to be used if there is no PresentationVariant annotation.
     *  If both this property and the PresentationVariant annotation exist, the select request sent to the backend
     * would be a combination of both.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters. Also,
     * setting this property during runtime, will delete the current drill-stack and lead to a loss of the drill
     * history.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequestAtLeastFields(
      /**
       * New value for property `requestAtLeastFields`
       */
      sRequestAtLeastFields?: string
    ): this;
    /**
     * Sets the aggregated {@link #getSemanticObjectController semanticObjectController}.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectController(
      /**
       * The semanticObjectController to set
       */
      oSemanticObjectController: SemanticObjectController
    ): this;
    /**
     * Sets a new value for property {@link #getShowChartTooltip showChartTooltip}.
     *
     * Controls the visibility of the chart tooltip. If set to `true `, an instance of sap.viz.ui5.controls.VizTooltip
     * will be created and shown when hovering over a data point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowChartTooltip(
      /**
       * New value for property `showChartTooltip`
       */
      bShowChartTooltip?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowChartTypeSelectionButton showChartTypeSelectionButton}.
     *
     * Controls the visibility of the chart type selection button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowChartTypeSelectionButton(
      /**
       * New value for property `showChartTypeSelectionButton`
       */
      bShowChartTypeSelectionButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowDetailsButton showDetailsButton}.
     *
     * Controls the visibility of the Details button. If set to `true`, the datapoint tooltip will be disabled
     * as the information of selected datapoints will be found in the details popover. This will also set the
     * drill-down button to invisible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDetailsButton(
      /**
       * New value for property `showDetailsButton`
       */
      bShowDetailsButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowDownloadButton showDownloadButton}.
     *
     * Controls the visibility of the chart download button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.39
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDownloadButton(
      /**
       * New value for property `showDownloadButton`
       */
      bShowDownloadButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowDrillBreadcrumbs showDrillBreadcrumbs}.
     *
     * Controls the visibility of the Breadcrumbs control for drilling up within the visible dimensions. If
     * set to `true`, the toolbar header will be replaced by the Breadcrumbs control. This will also set the
     * drill-up button to invisible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDrillBreadcrumbs(
      /**
       * New value for property `showDrillBreadcrumbs`
       */
      bShowDrillBreadcrumbs?: boolean
    ): this;
    /**
     * Change the visibility of the toolbar
     *
     * @since 1.54
     */
    setShowToolbar(
      /**
       * If set to `true` the toolbar is shown, if set to `false` it is not visible
       */
      bShowToolbar: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getShowVariantManagement showVariantManagement}.
     *
     * Controls the visibility of the Variant Management.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowVariantManagement(
      /**
       * New value for property `showVariantManagement`
       */
      bShowVariantManagement?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSmartFilterId smartFilterId}.
     *
     * ID of the corresponding SmartFilter control. If specified, the SmartChart control searches for the SmartFilter
     * control (also in the closest parent view) and attaches to the relevant events of the SmartFilter control
     * to fetch data, show overlay etc.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSmartFilterId(
      /**
       * New value for property `smartFilterId`
       */
      sSmartFilterId?: string
    ): this;
    /**
     * Sets the associated {@link #getSmartVariant smartVariant}.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSmartVariant(
      /**
       * ID of an element which becomes the new target of this smartVariant association; alternatively, an element
       * instance may be given
       */
      oSmartVariant: ID | Control
    ): this;
    /**
     * Change the style of the toolbar
     *
     * @since 1.54
     */
    setToolbarStyle(
      /**
       * The style of the toolbar.
       */
      sStyle: ToolbarStyle | keyof typeof ToolbarStyle
    ): void;
    /**
     * The method replaces the current UI state of SmartChart control with the data represented in `uiState`.
     */
    setUiState(
      /**
       * the new representation of UI state
       */
      oUiState: UIState
    ): void;
    /**
     * Sets a new value for property {@link #getUseChartPersonalisation useChartPersonalisation}.
     *
     * If set to `true`, personalized chart settings are defined. If you want to persist the chart personalization,
     * you need to specify the persistencyKey property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseChartPersonalisation(
      /**
       * New value for property `useChartPersonalisation`
       */
      bUseChartPersonalisation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseListForChartTypeSelection useListForChartTypeSelection}.
     *
     * Controls the visualization for chart type selection. If set to `true`, the list of available chart types
     * will be displayed. If set to `false` and there are three or fewer available chart types, the chart types
     * will be displayed as separate buttons in the toolbar. If there are more than three chart types, a list
     * will be shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38
     * @deprecated As of version 1.48.0. Setting the property to `false` will have no effect on the visualization
     * of chart type selection. `SmartChart` will always show a list of chart types.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseListForChartTypeSelection(
      /**
       * New value for property `useListForChartTypeSelection`
       */
      bUseListForChartTypeSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseTooltip useTooltip}.
     *
     * Specifies weather an instance of {@link sap.viz.ui5.controls.VizTooltip} or {@link sap.viz.ui5.controls.Popover }
     * is used. If set to `true`, a tooltip will be displayed, a popover otherwise.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseTooltip(
      /**
       * New value for property `useTooltip`
       */
      bUseTooltip?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseVariantManagement useVariantManagement}.
     *
     * If set to `true`, variants are used. As a prerequisite, you need to specify the persistencyKey property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseVariantManagement(
      /**
       * New value for property `useVariantManagement`
       */
      bUseVariantManagement?: boolean
    ): this;
  }

  export type Variant = {
    /**
     * Information about all measures and dimensions of the chart
     */
    dimeasure: Dimeasure;
    /**
     * Information about the current filters applied to the chart
     */
    filter?: Filter;
    /**
     * Information about the current sorters applied to the chart
     */
    sort?: Sort;
  };

  export type Dimeasure = {
    /**
     * Internal key of the chart type stored in the variant
     */
    chartTypeKey?: string;
    /**
     * Representation of all dimension and measures in the chart and their current state
     */
    dimeasureItems: DimeasureItem[];
  };

  export type DimeasureItem = {
    /**
     * Aggregation role of the `DimeasureItem`, which can be either a `Dimension` or a `Measure`
     */
    aggregationRole: string;
    /**
     * Name of the property this `DimeasureItem` refers to in the metadata
     */
    columnKey: string;
    /**
     * Position of the dimension/name in the chart's drill stack
     */
    index: int;
    /**
     * The chart role of the dimension or measure
     */
    role: string;
    /**
     * Determines whether the dimension or measure is currently visualized in the chart
     */
    visible: boolean;
  };

  export type Filter = {
    /**
     * Representation of all current filters of the chart
     */
    filterItems: FilterItem[];
  };

  export type FilterItem = {
    /**
     * Name of the property this `DimeasureItem` refers to in the metadata
     */
    columnKey: string;
    /**
     * Determines whether this is an exclude filter
     */
    exclude: boolean;
    /**
     * Filter operation used for this filter
     */
    operation: string;
    /**
     * Value 1 for the filter operation
     */
    value1: any;
    /**
     * Value 2 for the filter operation
     */
    value2?: any;
  };

  export type Sort = {
    /**
     * Representation of all current sorters of the chart
     */
    sortItems: SortItem[];
  };

  export type SortItem = {
    /**
     * Name of the property this `DimeasureItem` refers to in the metadata
     */
    columnKey: string;
    /**
     * Sort operation, which can be either `Ascending` or `Descending`
     */
    operation: string;
  };

  /**
   * Describes the settings that can be provided to the SmartChart constructor.
   */
  export interface $SmartChartSettings extends $VBoxSettings {
    /**
     * The entity set name from which to fetch data and generate the columns.
     *  **Note** This is not a dynamic property.
     */
    entitySet?: string | PropertyBindingInfo;

    /**
     * ID of the corresponding SmartFilter control. If specified, the SmartChart control searches for the SmartFilter
     * control (also in the closest parent view) and attaches to the relevant events of the SmartFilter control
     * to fetch data, show overlay etc.
     */
    smartFilterId?: string | PropertyBindingInfo;

    /**
     * CSV of fields that must be ignored in the OData metadata by the SmartChart control.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * CSV of fields that must be always requested by the backend system.
     *  This property is mainly meant to be used if there is no PresentationVariant annotation.
     *  If both this property and the PresentationVariant annotation exist, the select request sent to the backend
     * would be a combination of both.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters. Also,
     * setting this property during runtime, will delete the current drill-stack and lead to a loss of the drill
     * history.
     */
    requestAtLeastFields?: string | PropertyBindingInfo;

    /**
     * CSV of fields that is not shown in the personalization dialog.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     */
    ignoreFromPersonalisation?: string | PropertyBindingInfo;

    /**
     * Specifies the type of chart to be created by the SmartChart control.
     */
    chartType?: string | PropertyBindingInfo;

    /**
     * CSV of fields that is not shown in the list of available chart types.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     */
    ignoredChartTypes?: string | PropertyBindingInfo;

    /**
     * If set to `true`, variants are used. As a prerequisite, you need to specify the persistencyKey property.
     */
    useVariantManagement?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, personalized chart settings are defined. If you want to persist the chart personalization,
     * you need to specify the persistencyKey property.
     */
    useChartPersonalisation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies header text that is shown in the chart.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Semantic level of the header.
     *  For more information, see {@link sap.m.Title#setLevel}.
     *
     * @since 1.118
     */
    headerLevel?:
      | (TitleLevel | keyof typeof TitleLevel)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines style of the header.
     *  For more information, see {@link sap.m.Title#setTitle}.
     *
     * @since 1.119
     */
    headerStyle?:
      | (TitleLevel | keyof typeof TitleLevel)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Key used to access personalization data.
     */
    persistencyKey?: string | PropertyBindingInfo;

    /**
     * Retrieves or applies the current variant.
     */
    currentVariantId?: string | PropertyBindingInfo;

    /**
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * or entitySet property. This happens right after the `initialise` event has been fired.
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the path that is used during the binding of the chart. If not specified, the entitySet property
     * is used instead. (used only if binding is established internally/automatically - See enableAutoBinding)
     */
    chartBindingPath?: string | PropertyBindingInfo;

    /**
     * Controls the visibility of the Drill Up and Drill Down buttons.
     */
    showDrillButtons?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Zoom In and Zoom Out buttons.
     *
     * @since 1.36
     */
    showZoomButtons?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Navigation button
     *
     * @since 1.36
     */
    showSemanticNavigationButton?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the Variant Management.
     *
     * @since 1.38
     */
    showVariantManagement?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the chart download button.
     *
     * @since 1.39
     */
    showDownloadButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Details button. If set to `true`, the datapoint tooltip will be disabled
     * as the information of selected datapoints will be found in the details popover. This will also set the
     * drill-down button to invisible.
     *
     * @since 1.38
     */
    showDetailsButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Breadcrumbs control for drilling up within the visible dimensions. If
     * set to `true`, the toolbar header will be replaced by the Breadcrumbs control. This will also set the
     * drill-up button to invisible.
     *
     * @since 1.38
     */
    showDrillBreadcrumbs?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the chart tooltip. If set to `true `, an instance of sap.viz.ui5.controls.VizTooltip
     * will be created and shown when hovering over a data point.
     *
     * @since 1.38
     */
    showChartTooltip?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the Navigation button
     *
     * @since 1.36
     */
    showLegendButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set chart's legend properties.
     *
     * @since 1.36
     */
    legendVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Chart selection mode. Supported values are {@link sap.ui.comp.smartchart.SelectionMode.Single} or {@link sap.ui.comp.smartchart.SelectionMode.Multi},
     * case insensitive, always return in upper case. Unsupported values will be ignored.
     *
     * @since 1.36
     */
    selectionMode?:
      | smartchart.SelectionMode
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the FullScreen button.
     *
     * @since 1.36
     */
    showFullScreenButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies weather an instance of {@link sap.viz.ui5.controls.VizTooltip} or {@link sap.viz.ui5.controls.Popover }
     * is used. If set to `true`, a tooltip will be displayed, a popover otherwise.
     *
     * @since 1.36
     */
    useTooltip?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visualization for chart type selection. If set to `true`, the list of available chart types
     * will be displayed. If set to `false` and there are three or fewer available chart types, the chart types
     * will be displayed as separate buttons in the toolbar. If there are more than three chart types, a list
     * will be shown.
     *
     * @since 1.38
     * @deprecated As of version 1.48.0. Setting the property to `false` will have no effect on the visualization
     * of chart type selection. `SmartChart` will always show a list of chart types.
     */
    useListForChartTypeSelection?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the chart type selection button.
     *
     * @since 1.48
     */
    showChartTypeSelectionButton?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the custom text that will be displayed in case no data is found for the current binding.
     *
     * @since 1.46
     */
    noData?: string | PropertyBindingInfo;

    /**
     * Controls the visibility of the toolbar.
     *
     * @since 1.54
     */
    showToolbar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the visual style of the smart charts `Toolbar`. **Note:** The visual styles are theme-dependent.
     *
     * @since 1.54
     */
    toolbarStyle?:
      | (ToolbarStyle | keyof typeof ToolbarStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the title in the dimension area of the chart.
     *
     * @since 1.54
     */
    showDimensionsTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the visibility of the title in the measure area of the chart.
     *
     * @since 1.54
     */
    showMeasuresTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables the use of timeseries on the inner chart when corresponding annotation is given
     *
     * **Note:** This timeseries is only supported for the following {@link sap.chart.TimeUnitType TimeUnitTypes }
     * and the following chart types {@link sap.viz.ui5.controls.VizFrame#getVizType}.
     *
     * @since 1.84
     */
    activateTimeSeries?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Text that is shown for values of an empty string. **Note:** The property does not change the behavior
     * for charts of type `timeseries`. **Note:** Can only be changed in the XML/JS view. It cannot be changed
     * once the control has been initialized.
     *
     * @since 1.106
     */
    notAssignedText?: string | PropertyBindingInfo;

    /**
     * A custom toolbar that can be specified by the user to define their own buttons, icons, etc. If this is
     * added, the SmartChart control does not create its own toolbar, but uses this one instead. However, if
     * default actions, such as showSemanticNavigation, showFullScreenButton etc. are set, these actions are
     * added at the left-hand side of the toolbar.
     */
    toolbar?: Toolbar;

    /**
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     *
     * @since 1.36
     */
    semanticObjectController?: SemanticObjectController;

    /**
     * Actions on item level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    selectionDetailsItemActions?:
      | Item[]
      | Item
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Actions on footer level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    selectionDetailsActions?:
      | Item[]
      | Item
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Actions on group level which can be specified for the selection details popover.
     *
     * @since 1.48
     */
    selectionDetailsActionGroups?:
      | Item[]
      | Item
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Identifies the SmartVariant control which should be used for the personalization. Will be ignored if
     * the advanced mode is set.
     *
     * @since 1.38
     */
    smartVariant?: Control | string;

    /**
     * This event is fired once the control has been initialized. **Note:** For compatibility reasons the sap.chart
     * library is loaded synchroniously as soon as a event handler for the `initialise` event has been attached.
     * Since this event does not fulfill CSP requirements, please use event `initialized` instead.
     *
     * @deprecated As of version 1.65. replaced by {@link initialized}.
     */
    initialise?: (oEvent: Event) => void;

    /**
     * This event is fired once the control has been initialized, asynchronous successor of `initialise`.
     */
    initialized?: (oEvent: Event) => void;

    /**
     * This event is fired right before the `SmartChart` control triggers the binding / rebinding of the inner
     * chart.
     *  **Note:** In certain cases the inner chart triggers a rebinding by itself. In these cases, the event
     * is not fired.
     */
    beforeRebindChart?: (oEvent: SmartChart$BeforeRebindChartEvent) => void;

    /**
     * This event is fired when data is received after binding. This event is fired if the binding for the chart
     * is done by the SmartChart control itself.
     *
     * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
     * directly
     */
    dataReceived?: (oEvent: Event) => void;

    /**
     * This event is fired after the variant management in the SmartChart control has been initialized.
     */
    afterVariantInitialise?: (oEvent: Event) => void;

    /**
     * This event is fired after a variant has been saved. This event can be used to retrieve the ID of the
     * saved variant.
     */
    afterVariantSave?: (oEvent: SmartChart$AfterVariantSaveEvent) => void;

    /**
     * This event is fired after a variant has been applied.
     */
    afterVariantApply?: (oEvent: SmartChart$AfterVariantApplyEvent) => void;

    /**
     * This event is fired right before the overlay is shown.
     */
    showOverlay?: (oEvent: Event) => void;

    /**
     * This event is fired right after the full screen mode of the SmartChart control has been changed.
     *
     * @since 1.46
     */
    fullScreenToggled?: (oEvent: SmartChart$FullScreenToggledEvent) => void;

    /**
     * This event is fired when any action in the selection details popover is pressed.
     *
     * @since 1.48
     */
    selectionDetailsActionPress?: (
      oEvent: SmartChart$SelectionDetailsActionPressEvent
    ) => void;

    /**
     * This event is fired when `SmartChart` control data changes, due to changes in the personalization dialog
     * or drill operations.
     *  The data can be changed via sorters, filters or drill-ups/drill-downs.
     */
    chartDataChanged?: (oEvent: SmartChart$ChartDataChangedEvent) => void;

    /**
     * This event is fired when the UI state changes either via the {@link sap.ui.comp.smartchart.SmartChart#setUiState }
     * method or the chart personalization.
     *
     * @since 1.96.15
     */
    uiStateChange?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SmartChart#afterVariantApply event.
   */
  export interface SmartChart$AfterVariantApplyEventParameters {
    /**
     * ID of the currently selected variant
     */
    currentVariantId?: string;

    /**
     * Context in which the variant has been applied
     */
    variantContext?: string;
  }

  /**
   * Event object of the SmartChart#afterVariantApply event.
   */
  export type SmartChart$AfterVariantApplyEvent = Event<
    SmartChart$AfterVariantApplyEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#afterVariantInitialise event.
   */
  export interface SmartChart$AfterVariantInitialiseEventParameters {}

  /**
   * Event object of the SmartChart#afterVariantInitialise event.
   */
  export type SmartChart$AfterVariantInitialiseEvent = Event<
    SmartChart$AfterVariantInitialiseEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#afterVariantSave event.
   */
  export interface SmartChart$AfterVariantSaveEventParameters {
    /**
     * ID of the currently selected variant
     */
    currentVariantId?: string;
  }

  /**
   * Event object of the SmartChart#afterVariantSave event.
   */
  export type SmartChart$AfterVariantSaveEvent = Event<
    SmartChart$AfterVariantSaveEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#beforeRebindChart event.
   */
  export interface SmartChart$BeforeRebindChartEventParameters {
    /**
     * The bindingParams object contains filters, sorters, and other binding-related information for the chart
     */
    bindingParams?: object;
  }

  /**
   * Event object of the SmartChart#beforeRebindChart event.
   */
  export type SmartChart$BeforeRebindChartEvent = Event<
    SmartChart$BeforeRebindChartEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#chartDataChanged event.
   */
  export interface SmartChart$ChartDataChangedEventParameters {
    /**
     * Object which contains a boolean flag for dimeasure, filter, sort. If set to `true`, it has been changed.
     */
    changeTypes?: object;
  }

  /**
   * Event object of the SmartChart#chartDataChanged event.
   */
  export type SmartChart$ChartDataChangedEvent = Event<
    SmartChart$ChartDataChangedEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#dataReceived event.
   *
   * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
   * directly
   */
  export interface SmartChart$DataReceivedEventParameters {}

  /**
   * Event object of the SmartChart#dataReceived event.
   *
   * @deprecated As of version 1.56. Use `beforeRebindChart` event to attach/listen to the binding "events"
   * directly
   */
  export type SmartChart$DataReceivedEvent = Event<
    SmartChart$DataReceivedEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#fullScreenToggled event.
   */
  export interface SmartChart$FullScreenToggledEventParameters {
    /**
     * If `true` the control is in full screen mode
     */
    fullScreen?: boolean;
  }

  /**
   * Event object of the SmartChart#fullScreenToggled event.
   */
  export type SmartChart$FullScreenToggledEvent = Event<
    SmartChart$FullScreenToggledEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#initialise event.
   *
   * @deprecated As of version 1.65. replaced by {@link initialized}.
   */
  export interface SmartChart$InitialiseEventParameters {}

  /**
   * Event object of the SmartChart#initialise event.
   *
   * @deprecated As of version 1.65. replaced by {@link initialized}.
   */
  export type SmartChart$InitialiseEvent = Event<
    SmartChart$InitialiseEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#initialized event.
   */
  export interface SmartChart$InitializedEventParameters {}

  /**
   * Event object of the SmartChart#initialized event.
   */
  export type SmartChart$InitializedEvent = Event<
    SmartChart$InitializedEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#selectionDetailsActionPress event.
   */
  export interface SmartChart$SelectionDetailsActionPressEventParameters {
    /**
     * The action that has to be processed once the action has been pressed
     */
    action?: Item;

    /**
     * If the action is pressed on one of the {@link sap.m.SelectionDetailsItem items}, the parameter contains
     * the {@link sap.ui.model.Context context} of the pressed {@link sap.m.SelectionDetailsItem item}. If a
     * custom action or action group of the SelectionDetails popover is pressed, this parameter contains all
     * {@link sap.ui.model.Context contexts} of the {@link sap.m.SelectionDetailsItem items}.
     */
    itemContexts?: Context;

    /**
     * The action level of action buttons. The available levels are Item, List and Group
     */
    level?:
      | SelectionDetailsActionLevel
      | keyof typeof SelectionDetailsActionLevel;
  }

  /**
   * Event object of the SmartChart#selectionDetailsActionPress event.
   */
  export type SmartChart$SelectionDetailsActionPressEvent = Event<
    SmartChart$SelectionDetailsActionPressEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#showOverlay event.
   */
  export interface SmartChart$ShowOverlayEventParameters {}

  /**
   * Event object of the SmartChart#showOverlay event.
   */
  export type SmartChart$ShowOverlayEvent = Event<
    SmartChart$ShowOverlayEventParameters,
    SmartChart
  >;

  /**
   * Parameters of the SmartChart#uiStateChange event.
   */
  export interface SmartChart$UiStateChangeEventParameters {}

  /**
   * Event object of the SmartChart#uiStateChange event.
   */
  export type SmartChart$UiStateChangeEvent = Event<
    SmartChart$UiStateChangeEventParameters,
    SmartChart
  >;
}

declare module "sap/ui/comp/smartfield/SmartField" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    IFormContent,
    ISemanticFormContent,
    ID,
    TextAlign,
    TextDirection,
    ValueState,
    CSSSize,
  } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import Configuration from "sap/ui/comp/smartfield/Configuration";

  import { smartfield } from "sap/ui/comp/library";

  import ControlProposal from "sap/ui/comp/smartfield/ControlProposal";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SemanticObjectController from "sap/ui/comp/navpopover/SemanticObjectController";

  import ODataMetaModel from "sap/ui/model/odata/ODataMetaModel";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  export type checkValuesValidityInfo = {
    /**
     * The Edm name of the property the control is bound to.
     */
    property: string;
    /**
     * The instance of the control on which the checkValuesValidity method was called
     */
    instance: SmartField;
  };

  /**
   * The `SmartField` control interprets metadata that represents entity-relationship models, data types,
   * service capabilities, and annotations in OData services to automatically generate the underlying inner
   * controls and reduce the amount of code needed for developing applications. In some cases, the OData entity
   * is derived from the control's binding context. The OData entity property that is changed or displayed
   * with the control is derived from the `value` property of the control.
   *
   * Structure : The `SmartField` control contains a basic UI element and an optional label. In `display`
   * mode the following UI elements are available to be rendered depending on the metadata:
   * 	 - {@link sap.m.Text Text}
   * 	 - {@link sap.m.Link Link}
   * 	 - {@link sap.ui.comp.navpopover.SmartLink SmartLink}  In `edit` mode, the available UI elements
   *     are:
   * 	 - One or two {@link sap.m.Input Input} fields (with or without a {@link sap.ui.comp.valuehelpdialog.ValueHelpDialog ValueHelpDialog})
   *
   * 	 - {@link sap.m.Select Select}
   * 	 - {@link sap.m.ComboBox ComboBox}
   * 	 - {@link sap.m.TextArea TextArea}
   * 	 - {@link sap.m.Checkbox Checkbox}
   * 	 - {@link sap.m.DatePicker DatePicker}
   * 	 - {@link sap.m.DateTimePicker DateTimePicker}
   * 	 - {@link sap.m.TimePicker TimePicker}  The `SmartField` comes with additional built-in features,
   *     such as autocomplete and suggestions, value help dialog, recently used and recommended values, textInEditModeSource,
   *     validation, and message handling.
   *
   * Usage: When to use
   * 	 - You use an OData service for your app (only OData version 2).
   * 	 - You use the smart table and your app is not performance critical. The `SmartField` control offers
   *     more flexibility than the controls provided directly by the smart table, especially for editing.
   * 	 - You use a smart form.
   *
   * When not to use
   * 	 - You are not using OData version 2.
   * 	 - You need a different control for entering or displaying data, such as multi input, a multi combo
   *     box, step input, a radio button, or a title. In this case, use the corresponding control directly.
   * 	 - You need a different dialog for offering value help, such as the select dialog or table select dialog.
   *
   * 	 - You use the smart table and your app is performance critical. In this case, the controls offered
   *     directly by the smart table offer less flexibility but better performance.
   * 	 -  You need custom validations.
   *
   * **Important:** Keep in mind that the `SmartField` control, like all SAPUI5 smart controls, retrieves
   * and analyzes the metadata and annotations of OData services. **The OData metadata is its primary API.
   * These OData services are not part of the SAPUI5 framework and are usually maintained by the backend developers
   * of your application.**
   *
   * With time, `SmartField` can evolve and acquire new features. This means that its behavior or functionalities
   * may change if the annotations that define this change are maintained in your backend metadata. To benefit
   * from the new functionalities, your application should be able to adapt the backend metadata. **Therefore,
   * we recommend using `SmartField` only if you have control over the metadata of your application.**
   */
  export default class SmartField
    extends Control
    implements IFormContent, ISemanticFormContent
  {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_ISemanticFormContent: boolean;
    /**
     * Constructor for a new `sap.ui.comp.smartfield.SmartField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/4864403f08c64ca08a2b0ee1fa9cb5e2 Smart Field}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/smart-field/ Smart Field}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFieldSettings
    );
    /**
     * Constructor for a new `sap.ui.comp.smartfield.SmartField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/4864403f08c64ca08a2b0ee1fa9cb5e2 Smart Field}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/smart-field/ Smart Field}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFieldSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfield.SmartField with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartField>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfield.SmartField.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Calculates the paths to the annotations used by the `SmartField` control.
     *
     *
     * @returns The resulting paths are returned
     */
    static getSupportedAnnotationPaths(
      /**
       * The given OData meta model
       */
      oMetaModel: ODataMetaModel,
      /**
       * The given entity set
       */
      oEntitySet: object,
      /**
       * The path identifying the OData property to which the value property of the `SmartField` control is bound
       */
      sValueBinding: string,
      /**
       * If set to `true`, no properties are returned
       */
      bNavigationPathsOnly: boolean
    ): Record<string, string[]>;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.96
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.34.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the text in the field has been changed and the focus leaves the field, or after
     * the Enter key has been pressed.
     *
     * **Note:** This event is fired even if the value of the text input field is subject to data type constraints
     * and the constraints are violated. Also, the invalid value is not stored in the binding/model.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the text in the field has been changed and the focus leaves the field, or after
     * the Enter key has been pressed.
     *
     * **Note:** This event is fired even if the value of the text input field is subject to data type constraints
     * and the constraints are violated. Also, the invalid value is not stored in the binding/model.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeModelValue changeModelValue} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired after the text in the field has been changed by user interaction in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the field
     * 	 - The Enter key is pressed
     * 	 - The value is selected from the suggestions list
     * 	 - The value is selected from the `ValueHelpDialog`
     *
     * If the value of the text input field is subject to data type constraints, the constraints must be fulfilled,
     * which implies the value is stored in the binding/model before the event is fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeModelValue(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeModelValueEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:changeModelValue changeModelValue} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired after the text in the field has been changed by user interaction in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the field
     * 	 - The Enter key is pressed
     * 	 - The value is selected from the suggestions list
     * 	 - The value is selected from the `ValueHelpDialog`
     *
     * If the value of the text input field is subject to data type constraints, the constraints must be fulfilled,
     * which implies the value is stored in the binding/model before the event is fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChangeModelValue(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeModelValueEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextEditableChanged contextEditableChanged }
     * event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired when the control is rendered if the value of `contextEditable` property of the control has changed.
     *
     * @since 1.32.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextEditableChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ContextEditableChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contextEditableChanged contextEditableChanged }
     * event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired when the control is rendered if the value of `contextEditable` property of the control has changed.
     *
     * @since 1.32.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContextEditableChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ContextEditableChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:editableChanged editableChanged} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired when the control is rendered if the value of `editable` property of the control has changed.
     *
     * @since 1.30.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEditableChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$EditableChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:editableChanged editableChanged} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fired when the control is rendered if the value of `editable` property of the control has changed.
     *
     * @since 1.30.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEditableChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$EditableChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:entitySetFound entitySetFound} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The OData entity set is either derived from the control's binding context or from control's entity set
     * property, if a value for it is specified. In both cases this event is fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEntitySetFound(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$EntitySetFoundEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:entitySetFound entitySetFound} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The OData entity set is either derived from the control's binding context or from control's entity set
     * property, if a value for it is specified. In both cases this event is fired.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEntitySetFound(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$EntitySetFoundEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the smart field has calculated its metadata.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the smart field has calculated its metadata.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerControlsCreated innerControlsCreated} event
     * of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the inner controls have been created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerControlsCreated(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:innerControlsCreated innerControlsCreated} event
     * of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the inner controls have been created.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInnerControlsCreated(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:modeToggled modeToggled} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the inner controls have been toggled.
     *
     * @since 1.117.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachModeToggled(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:modeToggled modeToggled} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the inner controls have been toggled.
     *
     * @since 1.117.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachModeToggled(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fires when the user triggers the link control or taps/clicks on an active title of the object identifier
     * control. When handler attached, the rendered control is `sap.m.Link`
     *
     * @since 1.36.0
     * @deprecated As of version 1.116.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * Fires when the user triggers the link control or taps/clicks on an active title of the object identifier
     * control. When handler attached, the rendered control is `sap.m.Link`
     *
     * @since 1.36.0
     * @deprecated As of version 1.116.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:valueListChanged valueListChanged} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired when after selection of values with value help or auto-suggest, the model is updated
     * with the selected data.
     *
     * @since 1.31.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachValueListChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ValueListChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:valueListChanged valueListChanged} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired when after selection of values with value help or auto-suggest, the model is updated
     * with the selected data.
     *
     * @since 1.31.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachValueListChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$ValueListChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$VisibleChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfield.SmartField` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartField$VisibleChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfield.SmartField` itself
       */
      oListener?: object
    ): this;
    /**
     * Checks whether a client error has been detected in edit mode. Additionally the error message is shown,
     * if this is not the case already.
     *
     * This method is typically used to check whether the value of every inner text input field in edit mode
     * is subject to data type constraints and whether the constraints are fulfilled.
     *
     * A data type constraint for a bound Entity Data Model (EDM) property can be violated in many ways, for
     * example:
     *
     *
     * 	 - The `Nullable` constraint for an EDM property typed as `Edm.String` is violated.
     * 	 - A user input is invalid for the bound EDM property typed as `Edm.DateTime`.
     *
     * If this happens, the following applies:
     *
     *
     * 	 - A validation error state is set on the text input field.
     * 	 - A validation error message is displayed for the text input field.
     * 	 - The validation error message (possibly generated by a user input) is added to a `sap.ui.core.message.MessageManager`
     *     object instance if, for example, a view object instance is registered to it.
     * 	 - The inner private text input field fires a {@link sap.ui.base.EventProvider#event:validationError},
     *     or {@link sap.ui.base.EventProvider#event:parseError} event.
     *
     * @deprecated As of version 1.64. replaced by {@link sap.ui.comp.smartfield.SmartField#checkValuesValidity}
     *
     * @returns `true`, if a client error has been detected, `false` otherwise
     */
    checkClientError(
      /**
       * Settings
       */
      oSettings?: {
        /**
         * Indicates whether client error checks are performed for the current value regardless of the current error
         * state of the control. If the `handleSuccess` setting is set to `true`, the text input field fires a {@link sap.ui.base.EventProvider#event:validationSuccess }
         * if its validation passes.
         */
        handleSuccess?: boolean;
      }
    ): boolean;
    /**
     * Checks the validity of the values for the given control.
     *
     * @since 1.90
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Indicates validity of the values
     */
    checkUnitValidity(
      /**
       * Additional settings
       */
      oSettings?: Object
    ): boolean;
    /**
     * Checks whether the value of every inner text input field in edit mode is valid.
     *
     * This method is typically used to check whether the value of every inner text input field in edit mode
     * is subject to data type constraints and whether the constraints are fulfilled.
     *
     * **Note:** In some scenarios, invoking this method may also trigger a back-end request to check whether
     * the value is valid.
     *
     * A data type constraint for a bound Entity Data Model (EDM) property can be violated in many ways, for
     * example:
     *
     *
     * 	 - The `Nullable` constraint for an EDM property typed as `Edm.String` is violated.
     * 	 - A user input is invalid for the bound EDM property typed as `Edm.DateTime`.
     *
     * If this happens, the following applies:
     *
     *
     * 	 - A validation error state is set on the text input field.
     * 	 - A validation error message is displayed for the text input field.
     * 	 - The validation error message (possibly generated by a user input) is added to a `sap.ui.core.message.MessageManager`
     *     object instance if, for example, a view object instance is registered to it.
     * 	 - The inner private text input field fires a {@link sap.ui.base.EventProvider#event:validationError},
     *     or {@link sap.ui.base.EventProvider#event:parseError} event. Note that the events are fired synchronously
     *     if the value is validated on client side or asynchronously if, for example, the value is validated on
     *     back-end side.
     *
     * The inner private text input field fires a {@link sap.ui.base.EventProvider#event:validationSuccess }
     * if its validation passes.
     *
     * **Note:** In display mode, this method always returns a fulfilled `Promise` object.
     *
     * **Note:** In two-way data binding scenarios, it is usually not necessary to invoke this method explicitly
     * to validate user input, as the data type validation is done automatically when the value in the input
     * field has changed and the focus leaves the text input field or the enter key is pressed. However, in
     * two-way data binding scenarios, this method may be used to check whether a value is valid before submitting
     * it to the back-end system.
     *
     * @since 1.64
     *
     * @returns A fulfilled `Promise` object or a `Promise` object to be fulfilled if the value of every text
     * input field is valid, otherwise a rejected `Promise` object or a `Promise` object to be rejected
     */
    checkValuesValidity(
      /**
       * Settings
       */
      oSettings?: {
        /**
         * Indicates whether client error checks are performed for the current value regardless of the current error
         * state of the control. If the `handleSuccess` setting is set to `false`, the text input field will not
         * fire a {@link sap.ui.base.EventProvider#event:validationSuccess} if its validation passes.
         */
        handleSuccess?: boolean;
      }
    ): Promise<checkValuesValidityInfo>;
    /**
     * Destroys the configuration in the aggregation {@link #getConfiguration configuration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyConfiguration(): this;
    /**
     * Destroys the controlProposal in the aggregation {@link #getControlProposal controlProposal}.
     *
     * @since 1.32.0
     * @deprecated As of version 1.34.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyControlProposal(): this;
    /**
     * Destroys the semanticObjectController in the aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySemanticObjectController(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:changeModelValue changeModelValue} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChangeModelValue(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$ChangeModelValueEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contextEditableChanged contextEditableChanged }
     * event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.32.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContextEditableChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$ContextEditableChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:editableChanged editableChanged} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.30.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEditableChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$EditableChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:entitySetFound entitySetFound} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEntitySetFound(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$EntitySetFoundEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialise initialise} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialise(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:innerControlsCreated innerControlsCreated }
     * event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInnerControlsCreated(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:modeToggled modeToggled} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.117.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachModeToggled(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.36.0
     * @deprecated As of version 1.116.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:valueListChanged valueListChanged} event of
     * this `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.31.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachValueListChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$ValueListChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartfield.SmartField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachVisibleChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartField$VisibleChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$ChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:changeModelValue changeModelValue} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChangeModelValue(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$ChangeModelValueEventParameters
    ): this;
    /**
     * Fires event {@link #event:contextEditableChanged contextEditableChanged} to attached listeners.
     *
     * @since 1.32.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContextEditableChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$ContextEditableChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:editableChanged editableChanged} to attached listeners.
     *
     * @since 1.30.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEditableChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$EditableChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:entitySetFound entitySetFound} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEntitySetFound(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$EntitySetFoundEventParameters
    ): this;
    /**
     * Fires event {@link #event:initialise initialise} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialise(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:innerControlsCreated innerControlsCreated} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInnerControlsCreated(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:modeToggled modeToggled} to attached listeners.
     *
     * @since 1.117.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireModeToggled(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @since 1.36.0
     * @deprecated As of version 1.116.0. with no replacement.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:valueListChanged valueListChanged} to attached listeners.
     *
     * @since 1.31.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireValueListChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$ValueListChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:visibleChanged visibleChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireVisibleChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartField$VisibleChangedEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.96
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.34.2
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getClientSideMandatoryCheck clientSideMandatoryCheck}.
     *
     * Determines if the mandatory check of whether the field has a value happens on the client side - `true`
     * or on the server side - `false`.
     *
     * **Note:** If the {@link sap.ui.comp.smartfield.SmartField#value} property of the `SmartField` control
     * is bound to an Entity Data Model (EDM) property of type different from Edm.String annotated as `Nullable="false"`,
     * the mandatory validation is performed on the client side regardless of the `clientSideMandatoryCheck`
     * setting.
     *
     * Example:
     *
     *
     * ```javascript
     *
     *     <Property Name="CategoryID" Type="Edm.Decimal" Nullable="false"/>
     * ```
     *
     *
     * Default value is `true`.
     *
     * @since 1.38.3
     *
     * @returns Value of property `clientSideMandatoryCheck`
     */
    getClientSideMandatoryCheck(): boolean;
    /**
     * Gets content of aggregation {@link #getConfiguration configuration}.
     *
     * Optional configuration for `SmartField`.
     *
     * **Note**: By default, the value of the `displayBehaviour` property is not evaluated in edit mode. To
     * enable this feature in edit mode, set the `textInEditModeSource` control property to a non-default value.
     */
    getConfiguration(): Configuration;
    /**
     * Gets current value of property {@link #getContextEditable contextEditable}.
     *
     * Notifies the control whether controls using the `SmartField` control are editable.
     *
     * Default value is `true`.
     *
     * @since 1.32.0
     *
     * @returns Value of property `contextEditable`
     */
    getContextEditable(): boolean;
    /**
     * Gets current value of property {@link #getControlContext controlContext}.
     *
     * Defines the context in which the layout of the `SmartField` control has to be interpreted.
     *
     * Default value is `None`.
     *
     * @since 1.32.0
     *
     * @returns Value of property `controlContext`
     */
    getControlContext(): smartfield.ControlContextType;
    /**
     * Gets content of aggregation {@link #getControlProposal controlProposal}.
     *
     * Proposes a control to be rendered. The `SmartField` control can ignore the proposal.
     *
     * @since 1.32.0
     * @deprecated As of version 1.34.0. with no replacement.
     */
    getControlProposal(): ControlProposal;
    /**
     * Returns the OData property to which the `value` property of the control is bound.
     *
     *
     * @returns The OData property.
     */
    getDataProperty(): Record<string, string> | null;
    /**
     * Returns the EDM data type of the OData property to which the value property of the control is bound.
     * If no model or no OData property is available `null` is returned.
     *
     *
     * @returns The data type to which the value property is bound.
     */
    getDataType(): string;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Indicates whether the control is in display or edit mode.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab order.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getEntitySet entitySet}.
     *
     * The name of an entity set for which the control manages values. This is an optional property.
     *
     * If this property is left empty, the entity set is computed by parsing the binding context path, for example,
     * `Tasks('id-1428419016778-51')` is parsed to `Tasks`.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `entitySet`
     */
    getEntitySet(): string;
    /**
     * Gets current value of property {@link #getExpandNavigationProperties expandNavigationProperties}.
     *
     * Indicates if entities related to navigation properties inside the metadata are requested. If set to `true`,
     * then these related entities are loaded with an `$expand` request.
     *
     * Annotations that can have navigation properties are the following:
     * 	 `com.sap.vocabularies.Common.v1.Text` for text arrangements  `Org.OData.Measures.V1.Unit` and `Org.OData.Measures.V1.ISOCurrency`
     * for units  `com.sap.vocabularies.Common.v1.FieldControl` for field control
     *
     * **Note:** Independent of the `fetchValueListReadOnly` value, setting this flag to `true` requests data
     * from the backend.
     *
     * **Note:** The back-end request to expand the navigation properties is sent only if the entity to which
     * `SmartField` is bound is persisted. For transient entities, there is no back-end request since no such
     * data is available.
     *
     * Default value is `false`.
     *
     * @since 1.48
     * @deprecated As of version 1.117. It is recommended the expand to be using the OData Model.
     *
     * @returns Value of property `expandNavigationProperties`
     */
    getExpandNavigationProperties(): boolean;
    /**
     * Gets current value of property {@link #getFetchValueListReadOnly fetchValueListReadOnly}.
     *
     * Indicates whether the value list collection is fetched in display mode from the resource path specified
     * in the `com.sap.vocabularies.Common.v1.ValueList` annotation.
     *
     * This collection data is used to infer a descriptive text for the value of the `SmartField` control. However,
     * fetching the value list collection for every `SmartField` instance individually may not be ideal in some
     * performance-critical scenarios. To optimize this default behavior, you can set this property to `false`
     * and provide the `com.sap.vocabularies.Common.v1.Text` annotation, which is used to specify the URL path
     * name to the Entity Data Model (EDM) property from which the descriptive text for the value of the `SmartField`
     * control is fetched, for example, LT (Laptop).
     *
     * **Note:** Setting this property to `false` only has an effect if the `value` property of the `SmartField`
     * control is bound to an Entity Data Model (EDM) property typed as `Edm.String`. In addition, applications
     * or frameworks have to make sure the descriptive text is fetched, for example, by expanding a navigation
     * property.
     *
     * Default value is `true`.
     *
     * @since 1.42.0
     *
     * @returns Value of property `fetchValueListReadOnly`
     */
    getFetchValueListReadOnly(): boolean;
    /**
     * Gets current value of property {@link #getFixedValueListValidationEnabled fixedValueListValidationEnabled}.
     *
     * If the property is set to `true`, a standard validation for {@link sap.m.ComboBox} is performed. An inner
     * control {@link sap.m.ComboBox} is created and the binding is to `selectedKey`. Changes at runtime are
     * not reflected.
     *
     * **Note:** This property switches the control in legacy mode. If set to `true` this will override any
     * setting to `textInEditModeSource` property regarding ComboBox validation.
     *
     * **Note:** If the property is set to `false`, the inner control is {@link sap.ui.comp.smartfield.ComboBox }
     * and the binding is to `enteredValue`. In this case, any entered value is valid irrespective of whether
     * it's in the predefined list or not.
     *
     * **Note:** This property is applicable only for fixed-value scenarios.
     *
     * Default value is `false`.
     *
     * @since 1.88
     *
     * @returns Value of property `fixedValueListValidationEnabled`
     */
    getFixedValueListValidationEnabled(): boolean;
    /**
     * Returns the DOM element that gets the focus.
     *
     *
     * @returns The DOM element that should get the focus, can be `null`
     */
    getFocusDomRef(): Element;
    /**
     * Returns the formatted value of a control used in a `SemanticFormElement`.
     *
     * @since 1.88
     *
     * @returns Formatted value or a `Promise` returning the formatted value if resolved
     */
    getFormFormattedValue(): Promise<string>;
    /**
     * Returns the name of the value-holding property of a control used in a `SemanticFormElement`.
     *
     * @since 1.88
     */
    getFormValueProperty(): string;
    /**
     * Gets current value of property {@link #getHistoryEnabled historyEnabled}.
     *
     * If the property is set to `false`, history values are disabled. Changes at runtime are not reflected.
     * The `historyEnabled` property is not applied to custom controls.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * Default value is `true`.
     *
     * @since 1.84
     *
     * @returns Value of property `historyEnabled`
     */
    getHistoryEnabled(): boolean;
    /**
     * Gets the ID of the control to which the label should point.
     *
     *
     * @returns The ID of the inner control if it exists, otherwise the ID of the `SmartField` control
     */
    getIdForLabel(): string;
    /**
     * Gets current value of property {@link #getImportance importance}.
     *
     * Specifies the importance of the field. Applicable only when the `SmartField` is used inside `SmartForm`.
     *
     * Default value is `Low`.
     *
     * @since 1.87
     *
     * @returns Value of property `importance`
     */
    getImportance(): smartfield.Importance;
    /**
     * Resolves the controls hosted currently by this `SmartField` control.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The controls hosted currently by this `SmartField`
     */
    getInnerControls(): any[];
    /**
     * Gets current value of property {@link #getJsontype jsontype}.
     *
     * Data types to be used, if the `SmartField` control is interacting with a JSON model. If the value property
     * of the control is bound to a property of an OData entity set, this property is not taken into consideration.
     *
     * @deprecated As of version 1.31.0. with no replacement.
     *
     * @returns Value of property `jsontype`
     */
    getJsontype(): smartfield.JSONType;
    /**
     * Gets current value of property {@link #getMandatory mandatory}.
     *
     * Indicates whether user input is required.
     *
     * **Note:** The `SmartField` control is metadata-driven and this property can be ignored if the following
     * applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property is annotated with the `Nullable` annotation. The `Nullable`
     *     annotation is a capability of the OData service that specifies whether a value is mandatory, hence it
     *     overrules the control's API settings. Therefore, if the `Nullable` attribute is specified as `Nullable="false"`,
     *     a value is mandatory.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `mandatory`
     */
    getMandatory(): boolean;
    /**
     * Gets current value of property {@link #getMaxLength maxLength}.
     *
     * Defines the highest possible number of permitted input characters that the user can enter into the text
     * input field.
     *
     * Computed `maxLength`: If the specified `maxLength` value is greater than the `maxLength` value specified
     * for the underlying bound Entity Data Model (EDM) property in the service metadata document, the `maxLength`
     * value of the EDM property takes precedence. Likewise, if the application code provides a binding data
     * type for the `value` property of the `SmartField` control and the binding data type has `maxLength` constraints
     * defined, this `maxLength` is also taken into consideration to compute the final `maxLength` value.
     *
     * Validation Behavior: By design, the `SmartField` control does not restrict/validate the highest number
     * of permitted input characters for every keystroke, but only when the text input field has changed, and
     * the browser focus leaves the text input field or the ENTER key is pressed. The `SmartField` control is
     * used more generically in broader contexts, and adding a `maxLength` attribute to the HTML text input
     * control may break data type formatting in two-way data-binding scenarios. Let's say the `maxLength` property
     * is set to 3, but the text input control has a formatter function attached to it to format the entered
     * value "DE" to "Germany (DE)". In this case, the formatted value will be truncated by the `maxLength`
     * setting.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `maxLength`
     */
    getMaxLength(): int;
    /**
     * Returns the current SmartField's edit mode
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Returns "edit" or "display"
     */
    getMode(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * To be used in the HTML code (for example, for HTML forms that send data to the server via 'submit').
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Text shown when no value available.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getProposedControl proposedControl}.
     *
     * Proposes a control to be rendered. The `SmartField` control can ignore the proposal.
     *
     * Default value is `None`.
     *
     * @since 1.32.0
     * @deprecated As of version 1.32.0. with no replacement.
     *
     * @returns Value of property `proposedControl`
     */
    getProposedControl(): smartfield.ControlProposalType;
    /**
     * Gets the value of the `mandatory` property.
     *
     * This function is needed as the "mandatory" feature is named "required" in a lot of other controls (like
     * `Label` or `Form`).
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns the true if the `SmartField` should be marked as required
     */
    getRequired(): boolean;
    /**
     * Gets content of aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     */
    getSemanticObjectController(): SemanticObjectController;
    /**
     * Gets current value of property {@link #getShowLabel showLabel}.
     *
     * If set to `false` the label is not displayed.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLabel`
     */
    getShowLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowSuggestion showSuggestion}.
     *
     * If set to `true`, the suggestion feature for a hosted control is enabled, if the hosted control supports
     * it.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showSuggestion`
     */
    getShowSuggestion(): boolean;
    /**
     * Gets current value of property {@link #getShowValueHelp showValueHelp}.
     *
     * If set to `true`, a value help indicator will be displayed inside the hosted control, if the hosted control
     * supports this.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showValueHelp`
     */
    getShowValueHelp(): boolean;
    /**
     * Gets current value of property {@link #getShowValueStateMessage showValueStateMessage}.
     *
     * Defines whether the value state message is shown or not.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showValueStateMessage`
     */
    getShowValueStateMessage(): boolean;
    /**
     * Gets current value of property {@link #getSuppressEmptyStringRequest suppressEmptyStringRequest}.
     *
     * Controls if a query is sent to the backend in case of an empty string.
     *
     * Default value is `true`.
     *
     * @since 1.124
     *
     * @returns Value of property `suppressEmptyStringRequest`
     */
    getSuppressEmptyStringRequest(): boolean;
    /**
     * Gets current value of property {@link #getTextAlign textAlign}.
     *
     * Horizontal alignment of the text.
     *
     * Default value is `Initial`.
     *
     *
     * @returns Value of property `textAlign`
     */
    getTextAlign(): TextAlign;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * The available text direction options are LTR and RTL. By default, the control inherits the text direction
     * from its parent control.
     *
     * The `textDirection` property can be used when, for example, the text direction in the application is
     * LTR but you want a specific field to have RTL text direction.
     *
     * **Note:** The `textDirection` property is not applicable for the `SmartField` control for units of measure
     * use cases.
     *
     * Default value is `Inherit`.
     *
     * @since 1.86.0
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Gets current value of property {@link #getTextInEditModeSource textInEditModeSource}.
     *
     * Sets the source from which text descriptions for `IDs` are fetched in edit mode, for example, for LT
     * (Laptop).
     *
     * **Note**: The `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` and `sap.ui.comp.smartfield.TextInEditModeSource.ValueList`
     * enumeration members are only supported if the following applies:
     *
     *
     * 	 - The `value` property of the `SmartField` control instance is bound to an Entity Data Model (EDM)
     *     property typed as `Edm.String` or `Edm.Guid`.
     * 	 - The `com.sap.vocabularies.UI.v1.TextArrangement` annotation for the bound EDM property or entity
     *     type is specified in the service metadata document or annotation file.
     * 	 - The binding mode for the `value` property of the `SmartField` control is the two-way binding mode.
     *
     * 	 - The field from which the description is fetched is filterable.
     *
     * **Note**: In addition, the `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` enumeration
     * member is only supported if the following applies:
     *
     *
     * 	 - The EDM navigation property association is defined in the service metadata document.
     * 	 - The `com.sap.vocabularies.Common.v1.Text` annotation for the bound EDM property is specified in the
     *     service metadata document or annotation file whose `Path` attribute points to a EDM navigation property
     *     of a lookup entity set/type whose single key property is the `ID`, which contains (among other properties)
     *     the descriptive value.
     * 	 - The lookup entity must be loaded. The lookup entity can be loaded by expanding the EDM navigation
     *     property via a `$expand` query parameter.
     * 	 - The EDM navigation property association defines a referential constraint that ties values of the
     *     dependent editable entity type/set to the lookup entity type/set in the service metadata document.
     * 	 - The EDM navigation property association end multiplicity of the lookup entity type/set is defined
     *     as `1` in the service metadata document. There must be a single-valued navigation from the editable entity
     *     set/type to the lookup entity set/type.
     * 	 - The lookup entity type/set from which the descriptive value is fetched contains a single-key EDM
     *     property.
     *
     * **Note**: As of version 1.82, if `SmartField` is used inside a `SmartForm`, `defaultTextInEditModeSource`
     * can be added as custom data to the form and it will be propagated to all smart fields that cover the
     * above criteria. However, if `textInEditModeSource` is added to the `SmartField` as property, it will
     * override the `defaultTextInEditModeSource` propagated from the `SmartForm` custom data.
     *
     * **Note**: As of version 1.107 the property will be used to configure the validation for fixed list fields
     * of type `ComboBox`. The values that will be considered:
     * 	 - ValueList - strict validation
     * 	 - ValueListWarning - non-strict validation
     *
     * Default value is `None`.
     *
     * @since 1.83
     *
     * @returns Value of property `textInEditModeSource`
     */
    getTextInEditModeSource(): smartfield.TextInEditModeSource;
    /**
     * Gets current value of property {@link #getTextLabel textLabel}.
     *
     * This property contains the text of an associated `SmartLabel`.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `textLabel`
     */
    getTextLabel(): string;
    /**
     * Gets current value of property {@link #getTooltipLabel tooltipLabel}.
     *
     * This property contains the tool tip of the associated `SmartLabel` control.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `tooltipLabel`
     */
    getTooltipLabel(): string;
    /**
     * If the OData property to which the control's value property is bound semantically represents a unit of
     * measure, the value of the current unit of measure is returned. Otherwise `null` is returned.
     *
     *
     * @returns The current unit of measure is returned, which can be null
     */
    getUnitOfMeasure(): any;
    /**
     * Gets current value of property {@link #getUomEditable uomEditable}.
     *
     * Indicates whether the unit of measure field is in display or edit mode.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `uomEditable`
     */
    getUomEditable(): boolean;
    /**
     * Gets current value of property {@link #getUomEnabled uomEnabled}.
     *
     * Enabled state of the unit, if the `SmartField` control addresses unit of measure use cases, for example,
     * an amount and its associated currency.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `uomEnabled`
     */
    getUomEnabled(): boolean;
    /**
     * Gets current value of property {@link #getUomVisible uomVisible}.
     *
     * Indicates whether the unit of measure field is visible.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this property can be ignored if the bound
     * EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `uomVisible`
     */
    getUomVisible(): boolean;
    /**
     * Gets current value of property {@link #getUrl url}.
     *
     * Contains a URL which is used to render a link. The link is rendered, if the OData property, to which
     * the value property of the control is bound, is of type `Edm.String` and the `SmartField` is in display
     * mode.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `url`
     */
    getUrl(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The binding path expression used to determine the bound Entity Data Model (EDM) property.
     *
     * **Note:** Composite binding expressions for this property are not supported. **Note:** Custom formatters
     * for this property are not supported. The `SmartField` control usually creates its own data type based
     * on the service metadata for the formatting of values. Also, when a custom formatter is specified for
     * a property, the binding mode is automatically switched to one-way binding mode. **Note:** Named models
     * are not supported, only the default model (named undefined) is supported. For example, when the binding
     * path expression contains a `>` sign, the string preceding it is a named model and the remainder after
     * the `>` is the binding path.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): any;
    /**
     * Gets current value of property {@link #getValueHelpTitleSource valueHelpTitleSource}.
     *
     * Controls if the title is taken from the label of the main property or from the label of the value list.
     *
     * Default value is `Property`.
     *
     * @since 1.132
     *
     * @returns Value of property `valueHelpTitleSource`
     */
    getValueHelpTitleSource(): smartfield.ValueHelpTitleSource;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Visualizes the validation state of the control, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * **Note:** This method is public because of an implementation side effect and should not be used for validation
     * purposes as it may conflict with the `SmartField` control's own binding type validation logic based on
     * the underlying metadata of the bound Entity Data Model (EDM) property. Invoking the `.setValueState()`
     * and/or `.setValueStateText()` methods in a `change` event handle to set an error state does not prevent
     * an invalid value from being stored in the binding/model in two-way data binding scenarios. In addition,
     * it does not fire the `validationError` event, which is usually required by some upstream modules, for
     * example, the message manager.
     *
     * Custom validation logic must be implemented in a custom binding type rather than in a `change` event
     * handler.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState;
    /**
     * Gets current value of property {@link #getValueStateText valueStateText}.
     *
     * Defines the text of the value state message popup.
     *
     * **Note:** This method is public because of an implementation side effect and should not be used for validation
     * purposes as it may conflict with the `SmartField` control's own binding type validation logic based on
     * the underlying metadata of the bound Entity Data Model (EDM) property. Invoking the `.setValueState()`
     * and/or `.setValueStateText()` methods in a `change` event handle to set an error state does not prevent
     * an invalid value from being stored in the binding/model in two-way data binding scenarios. In addition,
     * it does not fire the `validationError` event, which is usually required by some upstream modules, for
     * example, the message manager.
     *
     * Custom validation logic must be implemented in a custom binding type rather than in a `change` event
     * handler.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueStateText`
     */
    getValueStateText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWrapping wrapping}.
     *
     * Indicates whether the control break lines (in display mode) to prevent overflow.
     *
     * Default value is `true`.
     *
     * @since 1.36.6
     *
     * @returns Value of property `wrapping`
     */
    getWrapping(): boolean;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.96
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.34.2
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.96
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.34.2
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getClientSideMandatoryCheck clientSideMandatoryCheck}.
     *
     * Determines if the mandatory check of whether the field has a value happens on the client side - `true`
     * or on the server side - `false`.
     *
     * **Note:** If the {@link sap.ui.comp.smartfield.SmartField#value} property of the `SmartField` control
     * is bound to an Entity Data Model (EDM) property of type different from Edm.String annotated as `Nullable="false"`,
     * the mandatory validation is performed on the client side regardless of the `clientSideMandatoryCheck`
     * setting.
     *
     * Example:
     *
     *
     * ```javascript
     *
     *     <Property Name="CategoryID" Type="Edm.Decimal" Nullable="false"/>
     * ```
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38.3
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClientSideMandatoryCheck(
      /**
       * New value for property `clientSideMandatoryCheck`
       */
      bClientSideMandatoryCheck?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getConfiguration configuration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConfiguration(
      /**
       * The configuration to set
       */
      oConfiguration: Configuration
    ): this;
    /**
     * Sets a new value for property {@link #getContextEditable contextEditable}.
     *
     * Notifies the control whether controls using the `SmartField` control are editable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.32.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContextEditable(
      /**
       * New value for property `contextEditable`
       */
      bContextEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getControlContext controlContext}.
     *
     * Defines the context in which the layout of the `SmartField` control has to be interpreted.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.32.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlContext(
      /**
       * New value for property `controlContext`
       */
      sControlContext?: smartfield.ControlContextType
    ): this;
    /**
     * Sets the aggregated {@link #getControlProposal controlProposal}.
     *
     * @since 1.32.0
     * @deprecated As of version 1.34.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlProposal(
      /**
       * The controlProposal to set
       */
      oControlProposal: ControlProposal
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Indicates whether the control is in display or edit mode.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab order.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEntitySet entitySet}.
     *
     * The name of an entity set for which the control manages values. This is an optional property.
     *
     * If this property is left empty, the entity set is computed by parsing the binding context path, for example,
     * `Tasks('id-1428419016778-51')` is parsed to `Tasks`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntitySet(
      /**
       * New value for property `entitySet`
       */
      sEntitySet?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpandNavigationProperties expandNavigationProperties}.
     *
     * Indicates if entities related to navigation properties inside the metadata are requested. If set to `true`,
     * then these related entities are loaded with an `$expand` request.
     *
     * Annotations that can have navigation properties are the following:
     * 	 `com.sap.vocabularies.Common.v1.Text` for text arrangements  `Org.OData.Measures.V1.Unit` and `Org.OData.Measures.V1.ISOCurrency`
     * for units  `com.sap.vocabularies.Common.v1.FieldControl` for field control
     *
     * **Note:** Independent of the `fetchValueListReadOnly` value, setting this flag to `true` requests data
     * from the backend.
     *
     * **Note:** The back-end request to expand the navigation properties is sent only if the entity to which
     * `SmartField` is bound is persisted. For transient entities, there is no back-end request since no such
     * data is available.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.48
     * @deprecated As of version 1.117. It is recommended the expand to be using the OData Model.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandNavigationProperties(
      /**
       * New value for property `expandNavigationProperties`
       */
      bExpandNavigationProperties?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFetchValueListReadOnly fetchValueListReadOnly}.
     *
     * Indicates whether the value list collection is fetched in display mode from the resource path specified
     * in the `com.sap.vocabularies.Common.v1.ValueList` annotation.
     *
     * This collection data is used to infer a descriptive text for the value of the `SmartField` control. However,
     * fetching the value list collection for every `SmartField` instance individually may not be ideal in some
     * performance-critical scenarios. To optimize this default behavior, you can set this property to `false`
     * and provide the `com.sap.vocabularies.Common.v1.Text` annotation, which is used to specify the URL path
     * name to the Entity Data Model (EDM) property from which the descriptive text for the value of the `SmartField`
     * control is fetched, for example, LT (Laptop).
     *
     * **Note:** Setting this property to `false` only has an effect if the `value` property of the `SmartField`
     * control is bound to an Entity Data Model (EDM) property typed as `Edm.String`. In addition, applications
     * or frameworks have to make sure the descriptive text is fetched, for example, by expanding a navigation
     * property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFetchValueListReadOnly(
      /**
       * New value for property `fetchValueListReadOnly`
       */
      bFetchValueListReadOnly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFixedValueListValidationEnabled fixedValueListValidationEnabled}.
     *
     * If the property is set to `true`, a standard validation for {@link sap.m.ComboBox} is performed. An inner
     * control {@link sap.m.ComboBox} is created and the binding is to `selectedKey`. Changes at runtime are
     * not reflected.
     *
     * **Note:** This property switches the control in legacy mode. If set to `true` this will override any
     * setting to `textInEditModeSource` property regarding ComboBox validation.
     *
     * **Note:** If the property is set to `false`, the inner control is {@link sap.ui.comp.smartfield.ComboBox }
     * and the binding is to `enteredValue`. In this case, any entered value is valid irrespective of whether
     * it's in the predefined list or not.
     *
     * **Note:** This property is applicable only for fixed-value scenarios.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFixedValueListValidationEnabled(
      /**
       * New value for property `fixedValueListValidationEnabled`
       */
      bFixedValueListValidationEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHistoryEnabled historyEnabled}.
     *
     * If the property is set to `false`, history values are disabled. Changes at runtime are not reflected.
     * The `historyEnabled` property is not applied to custom controls.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHistoryEnabled(
      /**
       * New value for property `historyEnabled`
       */
      bHistoryEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getImportance importance}.
     *
     * Specifies the importance of the field. Applicable only when the `SmartField` is used inside `SmartForm`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Low`.
     *
     * @since 1.87
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImportance(
      /**
       * New value for property `importance`
       */
      sImportance?: smartfield.Importance | keyof typeof smartfield.Importance
    ): this;
    /**
     * Sets a new value for property {@link #getJsontype jsontype}.
     *
     * Data types to be used, if the `SmartField` control is interacting with a JSON model. If the value property
     * of the control is bound to a property of an OData entity set, this property is not taken into consideration.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.31.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setJsontype(
      /**
       * New value for property `jsontype`
       */
      sJsontype?: smartfield.JSONType | keyof typeof smartfield.JSONType
    ): this;
    /**
     * Sets a new value for property {@link #getMandatory mandatory}.
     *
     * Indicates whether user input is required.
     *
     * **Note:** The `SmartField` control is metadata-driven and this property can be ignored if the following
     * applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property is annotated with the `Nullable` annotation. The `Nullable`
     *     annotation is a capability of the OData service that specifies whether a value is mandatory, hence it
     *     overrules the control's API settings. Therefore, if the `Nullable` attribute is specified as `Nullable="false"`,
     *     a value is mandatory.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMandatory(
      /**
       * New value for property `mandatory`
       */
      bMandatory?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxLength maxLength}.
     *
     * Defines the highest possible number of permitted input characters that the user can enter into the text
     * input field.
     *
     * Computed `maxLength`: If the specified `maxLength` value is greater than the `maxLength` value specified
     * for the underlying bound Entity Data Model (EDM) property in the service metadata document, the `maxLength`
     * value of the EDM property takes precedence. Likewise, if the application code provides a binding data
     * type for the `value` property of the `SmartField` control and the binding data type has `maxLength` constraints
     * defined, this `maxLength` is also taken into consideration to compute the final `maxLength` value.
     *
     * Validation Behavior: By design, the `SmartField` control does not restrict/validate the highest number
     * of permitted input characters for every keystroke, but only when the text input field has changed, and
     * the browser focus leaves the text input field or the ENTER key is pressed. The `SmartField` control is
     * used more generically in broader contexts, and adding a `maxLength` attribute to the HTML text input
     * control may break data type formatting in two-way data-binding scenarios. Let's say the `maxLength` property
     * is set to 3, but the text input control has a formatter function attached to it to format the entered
     * value "DE" to "Germany (DE)". In this case, the formatted value will be truncated by the `maxLength`
     * setting.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxLength(
      /**
       * New value for property `maxLength`
       */
      iMaxLength?: int
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * To be used in the HTML code (for example, for HTML forms that send data to the server via 'submit').
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Text shown when no value available.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getProposedControl proposedControl}.
     *
     * Proposes a control to be rendered. The `SmartField` control can ignore the proposal.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.32.0
     * @deprecated As of version 1.32.0. with no replacement.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setProposedControl(
      /**
       * New value for property `proposedControl`
       */
      sProposedControl?: smartfield.ControlProposalType
    ): this;
    /**
     * Sets the aggregated {@link #getSemanticObjectController semanticObjectController}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectController(
      /**
       * The semanticObjectController to set
       */
      oSemanticObjectController: SemanticObjectController
    ): this;
    /**
     * Sets a new value for property {@link #getShowLabel showLabel}.
     *
     * If set to `false` the label is not displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLabel(
      /**
       * New value for property `showLabel`
       */
      bShowLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSuggestion showSuggestion}.
     *
     * If set to `true`, the suggestion feature for a hosted control is enabled, if the hosted control supports
     * it.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSuggestion(
      /**
       * New value for property `showSuggestion`
       */
      bShowSuggestion?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueHelp showValueHelp}.
     *
     * If set to `true`, a value help indicator will be displayed inside the hosted control, if the hosted control
     * supports this.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueHelp(
      /**
       * New value for property `showValueHelp`
       */
      bShowValueHelp?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueStateMessage showValueStateMessage}.
     *
     * Defines whether the value state message is shown or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueStateMessage(
      /**
       * New value for property `showValueStateMessage`
       */
      bShowValueStateMessage?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSuppressEmptyStringRequest suppressEmptyStringRequest}.
     *
     * Controls if a query is sent to the backend in case of an empty string.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.124
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSuppressEmptyStringRequest(
      /**
       * New value for property `suppressEmptyStringRequest`
       */
      bSuppressEmptyStringRequest?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTextAlign textAlign}.
     *
     * Horizontal alignment of the text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Initial`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextAlign(
      /**
       * New value for property `textAlign`
       */
      sTextAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * The available text direction options are LTR and RTL. By default, the control inherits the text direction
     * from its parent control.
     *
     * The `textDirection` property can be used when, for example, the text direction in the application is
     * LTR but you want a specific field to have RTL text direction.
     *
     * **Note:** The `textDirection` property is not applicable for the `SmartField` control for units of measure
     * use cases.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     * @since 1.86.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getTextInEditModeSource textInEditModeSource}.
     *
     * Sets the source from which text descriptions for `IDs` are fetched in edit mode, for example, for LT
     * (Laptop).
     *
     * **Note**: The `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` and `sap.ui.comp.smartfield.TextInEditModeSource.ValueList`
     * enumeration members are only supported if the following applies:
     *
     *
     * 	 - The `value` property of the `SmartField` control instance is bound to an Entity Data Model (EDM)
     *     property typed as `Edm.String` or `Edm.Guid`.
     * 	 - The `com.sap.vocabularies.UI.v1.TextArrangement` annotation for the bound EDM property or entity
     *     type is specified in the service metadata document or annotation file.
     * 	 - The binding mode for the `value` property of the `SmartField` control is the two-way binding mode.
     *
     * 	 - The field from which the description is fetched is filterable.
     *
     * **Note**: In addition, the `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` enumeration
     * member is only supported if the following applies:
     *
     *
     * 	 - The EDM navigation property association is defined in the service metadata document.
     * 	 - The `com.sap.vocabularies.Common.v1.Text` annotation for the bound EDM property is specified in the
     *     service metadata document or annotation file whose `Path` attribute points to a EDM navigation property
     *     of a lookup entity set/type whose single key property is the `ID`, which contains (among other properties)
     *     the descriptive value.
     * 	 - The lookup entity must be loaded. The lookup entity can be loaded by expanding the EDM navigation
     *     property via a `$expand` query parameter.
     * 	 - The EDM navigation property association defines a referential constraint that ties values of the
     *     dependent editable entity type/set to the lookup entity type/set in the service metadata document.
     * 	 - The EDM navigation property association end multiplicity of the lookup entity type/set is defined
     *     as `1` in the service metadata document. There must be a single-valued navigation from the editable entity
     *     set/type to the lookup entity set/type.
     * 	 - The lookup entity type/set from which the descriptive value is fetched contains a single-key EDM
     *     property.
     *
     * **Note**: As of version 1.82, if `SmartField` is used inside a `SmartForm`, `defaultTextInEditModeSource`
     * can be added as custom data to the form and it will be propagated to all smart fields that cover the
     * above criteria. However, if `textInEditModeSource` is added to the `SmartField` as property, it will
     * override the `defaultTextInEditModeSource` propagated from the `SmartForm` custom data.
     *
     * **Note**: As of version 1.107 the property will be used to configure the validation for fixed list fields
     * of type `ComboBox`. The values that will be considered:
     * 	 - ValueList - strict validation
     * 	 - ValueListWarning - non-strict validation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.83
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextInEditModeSource(
      /**
       * New value for property `textInEditModeSource`
       */
      sTextInEditModeSource?:
        | smartfield.TextInEditModeSource
        | keyof typeof smartfield.TextInEditModeSource
    ): this;
    /**
     * Sets a new value for property {@link #getTextLabel textLabel}.
     *
     * This property contains the text of an associated `SmartLabel`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextLabel(
      /**
       * New value for property `textLabel`
       */
      sTextLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTooltipLabel tooltipLabel}.
     *
     * This property contains the tool tip of the associated `SmartLabel` control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTooltipLabel(
      /**
       * New value for property `tooltipLabel`
       */
      sTooltipLabel?: string
    ): this;
    /**
     * If the OData property the control's value property is bound to semantically represents a unit of measure,
     * the value of the current unit of measure can be changed.
     */
    setUnitOfMeasure(
      /**
       * The new unit of measure to be set.
       */
      sUnit: string
    ): void;
    /**
     * Sets a new value for property {@link #getUomEditable uomEditable}.
     *
     * Indicates whether the unit of measure field is in display or edit mode.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUomEditable(
      /**
       * New value for property `uomEditable`
       */
      bUomEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUomEnabled uomEnabled}.
     *
     * Enabled state of the unit, if the `SmartField` control addresses unit of measure use cases, for example,
     * an amount and its associated currency.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUomEnabled(
      /**
       * New value for property `uomEnabled`
       */
      bUomEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUomVisible uomVisible}.
     *
     * Indicates whether the unit of measure field is visible.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this property can be ignored if the bound
     * EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUomVisible(
      /**
       * New value for property `uomVisible`
       */
      bUomVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUrl url}.
     *
     * Contains a URL which is used to render a link. The link is rendered, if the OData property, to which
     * the value property of the control is bound, is of type `Edm.String` and the `SmartField` is in display
     * mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUrl(
      /**
       * New value for property `url`
       */
      sUrl?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The binding path expression used to determine the bound Entity Data Model (EDM) property.
     *
     * **Note:** Composite binding expressions for this property are not supported. **Note:** Custom formatters
     * for this property are not supported. The `SmartField` control usually creates its own data type based
     * on the service metadata for the formatting of values. Also, when a custom formatter is specified for
     * a property, the binding mode is automatically switched to one-way binding mode. **Note:** Named models
     * are not supported, only the default model (named undefined) is supported. For example, when the binding
     * path expression contains a `>` sign, the string preceding it is a named model and the remainder after
     * the `>` is the binding path.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      oValue?: any
    ): this;
    /**
     * Sets a new value for property {@link #getValueHelpTitleSource valueHelpTitleSource}.
     *
     * Controls if the title is taken from the label of the main property or from the label of the value list.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Property`.
     *
     * @since 1.132
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueHelpTitleSource(
      /**
       * New value for property `valueHelpTitleSource`
       */
      sValueHelpTitleSource?:
        | smartfield.ValueHelpTitleSource
        | keyof typeof smartfield.ValueHelpTitleSource
    ): this;
    /**
     * Setter for property `valueState`. Default value is `None`.
     *
     * @since 1.30.0
     *
     * @returns `this` to allow method chaining
     */
    setValueState(
      /**
       * The new value for property `valueState`
       */
      sValueState: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Setter for property `valueStateText`. Default value is empty/`undefined`.
     *
     * @since 1.29
     *
     * @returns `this` to allow method chaining
     */
    setValueStateText(
      /**
       * The new value for property `valueStateText`
       */
      sText: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWrapping wrapping}.
     *
     * Indicates whether the control break lines (in display mode) to prevent overflow.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.36.6
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrapping(
      /**
       * New value for property `wrapping`
       */
      bWrapping?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartField constructor.
   */
  export interface $SmartFieldSettings extends $ControlSettings {
    /**
     * The binding path expression used to determine the bound Entity Data Model (EDM) property.
     *
     * **Note:** Composite binding expressions for this property are not supported. **Note:** Custom formatters
     * for this property are not supported. The `SmartField` control usually creates its own data type based
     * on the service metadata for the formatting of values. Also, when a custom formatter is specified for
     * a property, the binding mode is automatically switched to one-way binding mode. **Note:** Named models
     * are not supported, only the default model (named undefined) is supported. For example, when the binding
     * path expression contains a `>` sign, the string preceding it is a named model and the remainder after
     * the `>` is the binding path.
     */
    value?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab order.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The name of an entity set for which the control manages values. This is an optional property.
     *
     * If this property is left empty, the entity set is computed by parsing the binding context path, for example,
     * `Tasks('id-1428419016778-51')` is parsed to `Tasks`.
     */
    entitySet?: string | PropertyBindingInfo;

    /**
     * Indicates whether the control is in display or edit mode.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Notifies the control whether controls using the `SmartField` control are editable.
     *
     * @since 1.32.0
     */
    contextEditable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Horizontal alignment of the text.
     */
    textAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The available text direction options are LTR and RTL. By default, the control inherits the text direction
     * from its parent control.
     *
     * The `textDirection` property can be used when, for example, the text direction in the application is
     * LTR but you want a specific field to have RTL text direction.
     *
     * **Note:** The `textDirection` property is not applicable for the `SmartField` control for units of measure
     * use cases.
     *
     * @since 1.86.0
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Text shown when no value available.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * To be used in the HTML code (for example, for HTML forms that send data to the server via 'submit').
     */
    name?: string | PropertyBindingInfo;

    /**
     * Visualizes the validation state of the control, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * **Note:** This method is public because of an implementation side effect and should not be used for validation
     * purposes as it may conflict with the `SmartField` control's own binding type validation logic based on
     * the underlying metadata of the bound Entity Data Model (EDM) property. Invoking the `.setValueState()`
     * and/or `.setValueStateText()` methods in a `change` event handle to set an error state does not prevent
     * an invalid value from being stored in the binding/model in two-way data binding scenarios. In addition,
     * it does not fire the `validationError` event, which is usually required by some upstream modules, for
     * example, the message manager.
     *
     * Custom validation logic must be implemented in a custom binding type rather than in a `change` event
     * handler.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the text of the value state message popup.
     *
     * **Note:** This method is public because of an implementation side effect and should not be used for validation
     * purposes as it may conflict with the `SmartField` control's own binding type validation logic based on
     * the underlying metadata of the bound Entity Data Model (EDM) property. Invoking the `.setValueState()`
     * and/or `.setValueStateText()` methods in a `change` event handle to set an error state does not prevent
     * an invalid value from being stored in the binding/model in two-way data binding scenarios. In addition,
     * it does not fire the `validationError` event, which is usually required by some upstream modules, for
     * example, the message manager.
     *
     * Custom validation logic must be implemented in a custom binding type rather than in a `change` event
     * handler.
     */
    valueStateText?: string | PropertyBindingInfo;

    /**
     * Defines whether the value state message is shown or not.
     */
    showValueStateMessage?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Data types to be used, if the `SmartField` control is interacting with a JSON model. If the value property
     * of the control is bound to a property of an OData entity set, this property is not taken into consideration.
     *
     * @deprecated As of version 1.31.0. with no replacement.
     */
    jsontype?:
      | (smartfield.JSONType | keyof typeof smartfield.JSONType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Indicates whether user input is required.
     *
     * **Note:** The `SmartField` control is metadata-driven and this property can be ignored if the following
     * applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property is annotated with the `Nullable` annotation. The `Nullable`
     *     annotation is a capability of the OData service that specifies whether a value is mandatory, hence it
     *     overrules the control's API settings. Therefore, if the `Nullable` attribute is specified as `Nullable="false"`,
     *     a value is mandatory.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     */
    mandatory?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the highest possible number of permitted input characters that the user can enter into the text
     * input field.
     *
     * Computed `maxLength`: If the specified `maxLength` value is greater than the `maxLength` value specified
     * for the underlying bound Entity Data Model (EDM) property in the service metadata document, the `maxLength`
     * value of the EDM property takes precedence. Likewise, if the application code provides a binding data
     * type for the `value` property of the `SmartField` control and the binding data type has `maxLength` constraints
     * defined, this `maxLength` is also taken into consideration to compute the final `maxLength` value.
     *
     * Validation Behavior: By design, the `SmartField` control does not restrict/validate the highest number
     * of permitted input characters for every keystroke, but only when the text input field has changed, and
     * the browser focus leaves the text input field or the ENTER key is pressed. The `SmartField` control is
     * used more generically in broader contexts, and adding a `maxLength` attribute to the HTML text input
     * control may break data type formatting in two-way data-binding scenarios. Let's say the `maxLength` property
     * is set to 3, but the text input control has a formatter function attached to it to format the entered
     * value "DE" to "Germany (DE)". In this case, the formatted value will be truncated by the `maxLength`
     * setting.
     */
    maxLength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, the suggestion feature for a hosted control is enabled, if the hosted control supports
     * it.
     */
    showSuggestion?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, a value help indicator will be displayed inside the hosted control, if the hosted control
     * supports this.
     */
    showValueHelp?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `false` the label is not displayed.
     */
    showLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This property contains the text of an associated `SmartLabel`.
     */
    textLabel?: string | PropertyBindingInfo;

    /**
     * This property contains the tool tip of the associated `SmartLabel` control.
     */
    tooltipLabel?: string | PropertyBindingInfo;

    /**
     * Indicates whether the unit of measure field is visible.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this property can be ignored if the bound
     * EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     */
    uomVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the unit of measure field is in display or edit mode.
     *
     * **Note:** This control property is only valid if the `SmartField` control addresses a unit of measure
     * composite field, for example, an amount field and its associated currency field. The field must then
     * be annotated with one of the following annotations:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:unit`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.ISOCurrency`
     *     annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Measures.V1.Unit`
     *     annotation.
     *
     * **Note:** The `SmartField` control is metadata-driven, and this control property can be ignored if the
     * following applies:
     *
     *
     * 	 - The bound Entity Data Model (EDM) property or its entity set are annotated with the OData V2 `sap:updatable`
     *     annotation.
     * 	 - The bound EDM property or its entity set are annotated with the `sap:creatable` annotation.
     * 	 - The entity set of the bound EDM property is annotated with the OData V2 `sap:updatable-path` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.InsertRestrictions`
     *     annotation.
     * 	 - The bound EDM property is annotated with the `com.sap.vocabularies.Common.v1.FieldControl` annotation.
     *
     * 	 - The entity set of the bound EDM property is annotated with the OData V4 `Org.OData.Capabilities.V1.UpdateRestrictions`
     *     annotation.
     */
    uomEditable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enabled state of the unit, if the `SmartField` control addresses unit of measure use cases, for example,
     * an amount and its associated currency.
     */
    uomEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Contains a URL which is used to render a link. The link is rendered, if the OData property, to which
     * the value property of the control is bound, is of type `Edm.String` and the `SmartField` is in display
     * mode.
     */
    url?: string | PropertyBindingInfo;

    /**
     * Defines the context in which the layout of the `SmartField` control has to be interpreted.
     *
     * @since 1.32.0
     */
    controlContext?:
      | smartfield.ControlContextType
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Proposes a control to be rendered. The `SmartField` control can ignore the proposal.
     *
     * @since 1.32.0
     * @deprecated As of version 1.32.0. with no replacement.
     */
    proposedControl?:
      | smartfield.ControlProposalType
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Indicates whether the control break lines (in display mode) to prevent overflow.
     *
     * @since 1.36.6
     */
    wrapping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the mandatory check of whether the field has a value happens on the client side - `true`
     * or on the server side - `false`.
     *
     * **Note:** If the {@link sap.ui.comp.smartfield.SmartField#value} property of the `SmartField` control
     * is bound to an Entity Data Model (EDM) property of type different from Edm.String annotated as `Nullable="false"`,
     * the mandatory validation is performed on the client side regardless of the `clientSideMandatoryCheck`
     * setting.
     *
     * Example:
     *
     *
     * ```javascript
     *
     *     <Property Name="CategoryID" Type="Edm.Decimal" Nullable="false"/>
     * ```
     *
     *
     * @since 1.38.3
     */
    clientSideMandatoryCheck?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the value list collection is fetched in display mode from the resource path specified
     * in the `com.sap.vocabularies.Common.v1.ValueList` annotation.
     *
     * This collection data is used to infer a descriptive text for the value of the `SmartField` control. However,
     * fetching the value list collection for every `SmartField` instance individually may not be ideal in some
     * performance-critical scenarios. To optimize this default behavior, you can set this property to `false`
     * and provide the `com.sap.vocabularies.Common.v1.Text` annotation, which is used to specify the URL path
     * name to the Entity Data Model (EDM) property from which the descriptive text for the value of the `SmartField`
     * control is fetched, for example, LT (Laptop).
     *
     * **Note:** Setting this property to `false` only has an effect if the `value` property of the `SmartField`
     * control is bound to an Entity Data Model (EDM) property typed as `Edm.String`. In addition, applications
     * or frameworks have to make sure the descriptive text is fetched, for example, by expanding a navigation
     * property.
     *
     * @since 1.42.0
     */
    fetchValueListReadOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if entities related to navigation properties inside the metadata are requested. If set to `true`,
     * then these related entities are loaded with an `$expand` request.
     *
     * Annotations that can have navigation properties are the following:
     * 	 `com.sap.vocabularies.Common.v1.Text` for text arrangements  `Org.OData.Measures.V1.Unit` and `Org.OData.Measures.V1.ISOCurrency`
     * for units  `com.sap.vocabularies.Common.v1.FieldControl` for field control
     *
     * **Note:** Independent of the `fetchValueListReadOnly` value, setting this flag to `true` requests data
     * from the backend.
     *
     * **Note:** The back-end request to expand the navigation properties is sent only if the entity to which
     * `SmartField` is bound is persisted. For transient entities, there is no back-end request since no such
     * data is available.
     *
     * @since 1.48
     * @deprecated As of version 1.117. It is recommended the expand to be using the OData Model.
     */
    expandNavigationProperties?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the source from which text descriptions for `IDs` are fetched in edit mode, for example, for LT
     * (Laptop).
     *
     * **Note**: The `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` and `sap.ui.comp.smartfield.TextInEditModeSource.ValueList`
     * enumeration members are only supported if the following applies:
     *
     *
     * 	 - The `value` property of the `SmartField` control instance is bound to an Entity Data Model (EDM)
     *     property typed as `Edm.String` or `Edm.Guid`.
     * 	 - The `com.sap.vocabularies.UI.v1.TextArrangement` annotation for the bound EDM property or entity
     *     type is specified in the service metadata document or annotation file.
     * 	 - The binding mode for the `value` property of the `SmartField` control is the two-way binding mode.
     *
     * 	 - The field from which the description is fetched is filterable.
     *
     * **Note**: In addition, the `sap.ui.comp.smartfield.TextInEditModeSource.NavigationProperty` enumeration
     * member is only supported if the following applies:
     *
     *
     * 	 - The EDM navigation property association is defined in the service metadata document.
     * 	 - The `com.sap.vocabularies.Common.v1.Text` annotation for the bound EDM property is specified in the
     *     service metadata document or annotation file whose `Path` attribute points to a EDM navigation property
     *     of a lookup entity set/type whose single key property is the `ID`, which contains (among other properties)
     *     the descriptive value.
     * 	 - The lookup entity must be loaded. The lookup entity can be loaded by expanding the EDM navigation
     *     property via a `$expand` query parameter.
     * 	 - The EDM navigation property association defines a referential constraint that ties values of the
     *     dependent editable entity type/set to the lookup entity type/set in the service metadata document.
     * 	 - The EDM navigation property association end multiplicity of the lookup entity type/set is defined
     *     as `1` in the service metadata document. There must be a single-valued navigation from the editable entity
     *     set/type to the lookup entity set/type.
     * 	 - The lookup entity type/set from which the descriptive value is fetched contains a single-key EDM
     *     property.
     *
     * **Note**: As of version 1.82, if `SmartField` is used inside a `SmartForm`, `defaultTextInEditModeSource`
     * can be added as custom data to the form and it will be propagated to all smart fields that cover the
     * above criteria. However, if `textInEditModeSource` is added to the `SmartField` as property, it will
     * override the `defaultTextInEditModeSource` propagated from the `SmartForm` custom data.
     *
     * **Note**: As of version 1.107 the property will be used to configure the validation for fixed list fields
     * of type `ComboBox`. The values that will be considered:
     * 	 - ValueList - strict validation
     * 	 - ValueListWarning - non-strict validation
     *
     * @since 1.83
     */
    textInEditModeSource?:
      | (
          | smartfield.TextInEditModeSource
          | keyof typeof smartfield.TextInEditModeSource
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If the property is set to `false`, history values are disabled. Changes at runtime are not reflected.
     * The `historyEnabled` property is not applied to custom controls.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * @since 1.84
     */
    historyEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the importance of the field. Applicable only when the `SmartField` is used inside `SmartForm`.
     *
     * @since 1.87
     */
    importance?:
      | (smartfield.Importance | keyof typeof smartfield.Importance)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If the property is set to `true`, a standard validation for {@link sap.m.ComboBox} is performed. An inner
     * control {@link sap.m.ComboBox} is created and the binding is to `selectedKey`. Changes at runtime are
     * not reflected.
     *
     * **Note:** This property switches the control in legacy mode. If set to `true` this will override any
     * setting to `textInEditModeSource` property regarding ComboBox validation.
     *
     * **Note:** If the property is set to `false`, the inner control is {@link sap.ui.comp.smartfield.ComboBox }
     * and the binding is to `enteredValue`. In this case, any entered value is valid irrespective of whether
     * it's in the predefined list or not.
     *
     * **Note:** This property is applicable only for fixed-value scenarios.
     *
     * @since 1.88
     */
    fixedValueListValidationEnabled?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls if a query is sent to the backend in case of an empty string.
     *
     * @since 1.124
     */
    suppressEmptyStringRequest?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the title is taken from the label of the main property or from the label of the value list.
     *
     * @since 1.132
     */
    valueHelpTitleSource?:
      | (
          | smartfield.ValueHelpTitleSource
          | keyof typeof smartfield.ValueHelpTitleSource
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Optional configuration for `SmartField`.
     *
     * **Note**: By default, the value of the `displayBehaviour` property is not evaluated in edit mode. To
     * enable this feature in edit mode, set the `textInEditModeSource` control property to a non-default value.
     */
    configuration?: Configuration;

    /**
     * Proposes a control to be rendered. The `SmartField` control can ignore the proposal.
     *
     * @since 1.32.0
     * @deprecated As of version 1.34.0. with no replacement.
     */
    controlProposal?: ControlProposal;

    /**
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     */
    semanticObjectController?: SemanticObjectController;

    /**
     * Association to controls / IDs which label this control (see WAI-ARIA attribute `aria-labelledby`).
     *
     * @since 1.34.2
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Association to controls / IDs that describe this control (see WAI-ARIA attribute `aria-describedby`).
     *
     * @since 1.96
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * The OData entity set is either derived from the control's binding context or from control's entity set
     * property, if a value for it is specified. In both cases this event is fired.
     */
    entitySetFound?: (oEvent: SmartField$EntitySetFoundEvent) => void;

    /**
     * The event is fired after the text in the field has been changed and the focus leaves the field, or after
     * the Enter key has been pressed.
     *
     * **Note:** This event is fired even if the value of the text input field is subject to data type constraints
     * and the constraints are violated. Also, the invalid value is not stored in the binding/model.
     */
    change?: (oEvent: SmartField$ChangeEvent) => void;

    /**
     * Fired after the text in the field has been changed by user interaction in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the field
     * 	 - The Enter key is pressed
     * 	 - The value is selected from the suggestions list
     * 	 - The value is selected from the `ValueHelpDialog`
     *
     * If the value of the text input field is subject to data type constraints, the constraints must be fulfilled,
     * which implies the value is stored in the binding/model before the event is fired.
     */
    changeModelValue?: (oEvent: SmartField$ChangeModelValueEvent) => void;

    /**
     * The event is fired after the smart field has calculated its metadata.
     */
    initialise?: (oEvent: Event) => void;

    /**
     * The event is fired after the visibility of the control has changed.
     */
    visibleChanged?: (oEvent: SmartField$VisibleChangedEvent) => void;

    /**
     * Fired when the control is rendered if the value of `editable` property of the control has changed.
     *
     * @since 1.30.0
     */
    editableChanged?: (oEvent: SmartField$EditableChangedEvent) => void;

    /**
     * Fired when the control is rendered if the value of `contextEditable` property of the control has changed.
     *
     * @since 1.32.0
     */
    contextEditableChanged?: (
      oEvent: SmartField$ContextEditableChangedEvent
    ) => void;

    /**
     * The event is fired after the inner controls have been toggled.
     *
     * @since 1.117.0
     */
    modeToggled?: (oEvent: Event) => void;

    /**
     * The event is fired after the inner controls have been created.
     */
    innerControlsCreated?: (oEvent: Event) => void;

    /**
     * The event is fired when after selection of values with value help or auto-suggest, the model is updated
     * with the selected data.
     *
     * @since 1.31.0
     */
    valueListChanged?: (oEvent: SmartField$ValueListChangedEvent) => void;

    /**
     * Fires when the user triggers the link control or taps/clicks on an active title of the object identifier
     * control. When handler attached, the rendered control is `sap.m.Link`
     *
     * @since 1.36.0
     * @deprecated As of version 1.116.0. with no replacement.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SmartField#change event.
   */
  export interface SmartField$ChangeEventParameters {
    /**
     * The current value inside the text field
     *
     * **Note:** This value is the formatted value, and in some cases it might differ from the value stored
     * in the binding/model. Usually, the value that is sent to the back-end system should be the value stored
     * in the binding/model, which is the parsed and validated value.
     */
    value?: string;

    /**
     * The new value inside the text field
     */
    newValue?: string;
  }

  /**
   * Event object of the SmartField#change event.
   */
  export type SmartField$ChangeEvent = Event<
    SmartField$ChangeEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#changeModelValue event.
   */
  export interface SmartField$ChangeModelValueEventParameters {
    /**
     * Indicates whether the field quantity field has changed
     */
    valueChanged?: boolean;

    /**
     * Last value of the `valueState` property of the field quantity field
     */
    valueLastValueState?: boolean;

    /**
     * Indicates whether the field unit field has changed
     */
    unitChanged?: boolean;

    /**
     * Last value of the `valueState` property of the field unit field
     */
    unitLastValueState?: ValueState | keyof typeof ValueState;
  }

  /**
   * Event object of the SmartField#changeModelValue event.
   */
  export type SmartField$ChangeModelValueEvent = Event<
    SmartField$ChangeModelValueEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#contextEditableChanged event.
   */
  export interface SmartField$ContextEditableChangedEventParameters {
    /**
     * The value of the context editable property of the control
     */
    editable?: boolean;
  }

  /**
   * Event object of the SmartField#contextEditableChanged event.
   */
  export type SmartField$ContextEditableChangedEvent = Event<
    SmartField$ContextEditableChangedEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#editableChanged event.
   */
  export interface SmartField$EditableChangedEventParameters {
    /**
     * If `true`, the control is in edit mode
     */
    editable?: boolean;
  }

  /**
   * Event object of the SmartField#editableChanged event.
   */
  export type SmartField$EditableChangedEvent = Event<
    SmartField$EditableChangedEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#entitySetFound event.
   */
  export interface SmartField$EntitySetFoundEventParameters {
    /**
     * The path to the found entity set
     */
    entitySet?: string;
  }

  /**
   * Event object of the SmartField#entitySetFound event.
   */
  export type SmartField$EntitySetFoundEvent = Event<
    SmartField$EntitySetFoundEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#initialise event.
   */
  export interface SmartField$InitialiseEventParameters {}

  /**
   * Event object of the SmartField#initialise event.
   */
  export type SmartField$InitialiseEvent = Event<
    SmartField$InitialiseEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#innerControlsCreated event.
   */
  export interface SmartField$InnerControlsCreatedEventParameters {}

  /**
   * Event object of the SmartField#innerControlsCreated event.
   */
  export type SmartField$InnerControlsCreatedEvent = Event<
    SmartField$InnerControlsCreatedEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#linkPress event.
   */
  export interface SmartField$LinkPressEventParameters {}

  /**
   * Event object of the SmartField#linkPress event.
   */
  export type SmartField$LinkPressEvent = Event<
    SmartField$LinkPressEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#modeToggled event.
   */
  export interface SmartField$ModeToggledEventParameters {}

  /**
   * Event object of the SmartField#modeToggled event.
   */
  export type SmartField$ModeToggledEvent = Event<
    SmartField$ModeToggledEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#press event.
   *
   * @deprecated As of version 1.116.0. with no replacement.
   */
  export interface SmartField$PressEventParameters {}

  /**
   * Event object of the SmartField#press event.
   *
   * @deprecated As of version 1.116.0. with no replacement.
   */
  export type SmartField$PressEvent = Event<
    SmartField$PressEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#valueListChanged event.
   */
  export interface SmartField$ValueListChangedEventParameters {
    /**
     * An array of selected values
     */
    changes?: Control[];
  }

  /**
   * Event object of the SmartField#valueListChanged event.
   */
  export type SmartField$ValueListChangedEvent = Event<
    SmartField$ValueListChangedEventParameters,
    SmartField
  >;

  /**
   * Parameters of the SmartField#visibleChanged event.
   */
  export interface SmartField$VisibleChangedEventParameters {
    /**
     * If `true`, the control is visible
     */
    visible?: boolean;
  }

  /**
   * Event object of the SmartField#visibleChanged event.
   */
  export type SmartField$VisibleChangedEvent = Event<
    SmartField$VisibleChangedEventParameters,
    SmartField
  >;
}

declare module "sap/ui/comp/smartfield/ComboBox" {
  import {
    default as ComboBox1,
    $ComboBoxSettings as $ComboBoxSettings1,
  } from "sap/m/ComboBox";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Extends the functionalities in sap.m.ComboBox
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class ComboBox extends ComboBox1 {
    /**
     * Constructor for a new `SmartField/ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );
    /**
     * Constructor for a new `SmartField/ComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfield.ComboBox with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ComboBox.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfield.ComboBox.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnteredValue enteredValue}.
     *
     *
     * @returns Value of property `enteredValue`
     */
    getEnteredValue(): string;
    /**
     * Gets current value of property {@link #getRealValue realValue}.
     *
     * Property works the same as sap.m.Input control `value`
     *
     *
     * @returns Value of property `realValue`
     */
    getRealValue(): string;
    /**
     * Gets current value of property {@link #getSelectedKey selectedKey}.
     *
     * Key of the selected item.
     *
     * **Note:** If duplicate keys exist, the first item matching the key is used.
     *
     *
     * @returns Value of property `selectedKey`
     */
    getSelectedKey(): string;
    /**
     * Gets current value of property {@link #getValueTextArrangement valueTextArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `valueTextArrangement`
     */
    getValueTextArrangement(): string;
    /**
     * Sets a new value for property {@link #getEnteredValue enteredValue}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnteredValue(
      /**
       * New value for property `enteredValue`
       */
      sEnteredValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRealValue realValue}.
     *
     * Property works the same as sap.m.Input control `value`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRealValue(
      /**
       * New value for property `realValue`
       */
      sRealValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedKey selectedKey}.
     *
     * Key of the selected item.
     *
     * **Note:** If duplicate keys exist, the first item matching the key is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedKey(
      /**
       * New value for property `selectedKey`
       */
      sSelectedKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueTextArrangement valueTextArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueTextArrangement(
      /**
       * New value for property `valueTextArrangement`
       */
      sValueTextArrangement?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBox constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $ComboBoxSettings extends $ComboBoxSettings1 {
    /**
     * Key of the selected item.
     *
     * **Note:** If duplicate keys exist, the first item matching the key is used.
     */
    selectedKey?: string | PropertyBindingInfo;

    enteredValue?: string | PropertyBindingInfo;

    /**
     * Property works the same as sap.m.Input control `value`
     */
    realValue?: string | PropertyBindingInfo;

    /**
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     */
    valueTextArrangement?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/comp/smartfield/Configuration" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { smartfield } from "sap/ui/comp/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The configuration allows to further define the behavior of a `SmartField`.
   */
  export default class Configuration extends UI5Element {
    /**
     * Constructor for a new `Smartfield`/`Configuration`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ConfigurationSettings
    );
    /**
     * Constructor for a new `Smartfield`/`Configuration`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfield.Configuration with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Configuration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfield.Configuration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getControlType controlType}.
     *
     * By default the SmartField chooses the controls it hosts by interpreting OData metadata. This property
     * allows to overwrite the default behavior to some extent. For example makes it possible to define that
     * an OData property of type Edm.Boolean is displayed as a combo box.
     *
     *
     * @returns Value of property `controlType`
     */
    getControlType(): smartfield.ControlType;
    /**
     * Gets current value of property {@link #getCriticalityQualifier criticalityQualifier}.
     *
     * The property specifies the qualifier of the `DataPoint` or `FieldGroup` annotation from which the criticality
     * annotation information should be taken.
     *
     *
     * @returns Value of property `criticalityQualifier`
     */
    getCriticalityQualifier(): string;
    /**
     * Gets current value of property {@link #getDisplayBehaviour displayBehaviour}.
     *
     * The property specifies how value help, that is available for input fields, is presented. For example,
     * it specifies whether the descriptions of the values shown in the result after a query are displayed.
     *
     *
     * @returns Value of property `displayBehaviour`
     */
    getDisplayBehaviour(): smartfield.DisplayBehaviour;
    /**
     * Gets current value of property {@link #getPreventInitialDataFetchInValueHelpDialog preventInitialDataFetchInValueHelpDialog}.
     *
     * If there are value help annotations for a smart field, it is possible to specify whether the table in
     * the value help dialog for this field will be filled initially. The default value is `false`, which means
     * the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78 the default
     * value has been changed from `true` to `false`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `preventInitialDataFetchInValueHelpDialog`
     */
    getPreventInitialDataFetchInValueHelpDialog(): boolean;
    /**
     * Sets a new value for property {@link #getControlType controlType}.
     *
     * By default the SmartField chooses the controls it hosts by interpreting OData metadata. This property
     * allows to overwrite the default behavior to some extent. For example makes it possible to define that
     * an OData property of type Edm.Boolean is displayed as a combo box.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlType(
      /**
       * New value for property `controlType`
       */
      sControlType?:
        | smartfield.ControlType
        | keyof typeof smartfield.ControlType
    ): this;
    /**
     * Sets a new value for property {@link #getCriticalityQualifier criticalityQualifier}.
     *
     * The property specifies the qualifier of the `DataPoint` or `FieldGroup` annotation from which the criticality
     * annotation information should be taken.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCriticalityQualifier(
      /**
       * New value for property `criticalityQualifier`
       */
      sCriticalityQualifier?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayBehaviour displayBehaviour}.
     *
     * The property specifies how value help, that is available for input fields, is presented. For example,
     * it specifies whether the descriptions of the values shown in the result after a query are displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayBehaviour(
      /**
       * New value for property `displayBehaviour`
       */
      sDisplayBehaviour?:
        | smartfield.DisplayBehaviour
        | keyof typeof smartfield.DisplayBehaviour
    ): this;
    /**
     * Sets a new value for property {@link #getPreventInitialDataFetchInValueHelpDialog preventInitialDataFetchInValueHelpDialog}.
     *
     * If there are value help annotations for a smart field, it is possible to specify whether the table in
     * the value help dialog for this field will be filled initially. The default value is `false`, which means
     * the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78 the default
     * value has been changed from `true` to `false`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPreventInitialDataFetchInValueHelpDialog(
      /**
       * New value for property `preventInitialDataFetchInValueHelpDialog`
       */
      bPreventInitialDataFetchInValueHelpDialog?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Configuration constructor.
   */
  export interface $ConfigurationSettings extends $ElementSettings {
    /**
     * By default the SmartField chooses the controls it hosts by interpreting OData metadata. This property
     * allows to overwrite the default behavior to some extent. For example makes it possible to define that
     * an OData property of type Edm.Boolean is displayed as a combo box.
     */
    controlType?:
      | (smartfield.ControlType | keyof typeof smartfield.ControlType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The property specifies how value help, that is available for input fields, is presented. For example,
     * it specifies whether the descriptions of the values shown in the result after a query are displayed.
     */
    displayBehaviour?:
      | (smartfield.DisplayBehaviour | keyof typeof smartfield.DisplayBehaviour)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The property specifies the qualifier of the `DataPoint` or `FieldGroup` annotation from which the criticality
     * annotation information should be taken.
     */
    criticalityQualifier?: string | PropertyBindingInfo;

    /**
     * If there are value help annotations for a smart field, it is possible to specify whether the table in
     * the value help dialog for this field will be filled initially. The default value is `false`, which means
     * the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78 the default
     * value has been changed from `true` to `false`.
     */
    preventInitialDataFetchInValueHelpDialog?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartfield/ControlProposal" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { smartfield } from "sap/ui/comp/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ObjectStatus from "sap/ui/comp/smartfield/ObjectStatus";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Proposes a control to be rendered. The smart field may ignore the proposal.
   */
  export default class ControlProposal extends UI5Element {
    /**
     * Constructor for a new `smartfield/ControlProposal`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlProposalSettings
    );
    /**
     * Constructor for a new `smartfield/ControlProposal`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlProposalSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfield.ControlProposal with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ControlProposal>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfield.ControlProposal.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the objectStatus in the aggregation {@link #getObjectStatus objectStatus}.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyObjectStatus(): this;
    /**
     * Gets current value of property {@link #getControlType controlType}.
     *
     * By default the SmartField chooses the controls it hosts by interpreting OData meta data. This property
     * allows to overwrite the default behavior to some extent; for example this property allows to define that
     * an OData property of type Edm.Boolean is displayed as combo box.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `controlType`
     */
    getControlType(): smartfield.ControlProposalType;
    /**
     * Gets content of aggregation {@link #getObjectStatus objectStatus}.
     *
     * Optional definition to further qualify how an object status control should be rendered.
     *
     * @since 1.34.0
     */
    getObjectStatus(): ObjectStatus;
    /**
     * Sets a new value for property {@link #getControlType controlType}.
     *
     * By default the SmartField chooses the controls it hosts by interpreting OData meta data. This property
     * allows to overwrite the default behavior to some extent; for example this property allows to define that
     * an OData property of type Edm.Boolean is displayed as combo box.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlType(
      /**
       * New value for property `controlType`
       */
      sControlType?: smartfield.ControlProposalType
    ): this;
    /**
     * Sets the aggregated {@link #getObjectStatus objectStatus}.
     *
     * @since 1.34.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectStatus(
      /**
       * The objectStatus to set
       */
      oObjectStatus: ObjectStatus
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ControlProposal constructor.
   */
  export interface $ControlProposalSettings extends $ElementSettings {
    /**
     * By default the SmartField chooses the controls it hosts by interpreting OData meta data. This property
     * allows to overwrite the default behavior to some extent; for example this property allows to define that
     * an OData property of type Edm.Boolean is displayed as combo box.
     */
    controlType?:
      | smartfield.ControlProposalType
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Optional definition to further qualify how an object status control should be rendered.
     *
     * @since 1.34.0
     */
    objectStatus?: ObjectStatus;
  }
}

declare module "sap/ui/comp/smartfield/ObjectStatus" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { smartfield } from "sap/ui/comp/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines a possible object status control to be rendered. The smart field may ignore the proposal.
   */
  export default class ObjectStatus extends UI5Element {
    /**
     * Constructor for a new `SmartField/ObjectStatus` to be used in the `controlProposal` configuration
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ObjectStatusSettings
    );
    /**
     * Constructor for a new `SmartField/ObjectStatus` to be used in the `controlProposal` configuration
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ObjectStatusSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfield.ObjectStatus with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ObjectStatus>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfield.ObjectStatus.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCriticality criticality}.
     *
     * Optional attribute to determine the rendered state. Possible values are the numeric representations of
     * the enum members of annotation `com.sap.vocabularies.UI.v1.CriticalityType`: 0: None 1: Error 2: Warning
     * 3: Success
     *
     *
     * @returns Value of property `criticality`
     */
    getCriticality(): any;
    /**
     * Gets current value of property {@link #getCriticalityRepresentationType criticalityRepresentationType}.
     *
     * Optional attribute, which can be set to control how the criticality is visualized.
     *
     * Default value is `WithIcon`.
     *
     *
     * @returns Value of property `criticalityRepresentationType`
     */
    getCriticalityRepresentationType(): smartfield.CriticalityRepresentationType;
    /**
     * Sets a new value for property {@link #getCriticality criticality}.
     *
     * Optional attribute to determine the rendered state. Possible values are the numeric representations of
     * the enum members of annotation `com.sap.vocabularies.UI.v1.CriticalityType`: 0: None 1: Error 2: Warning
     * 3: Success
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCriticality(
      /**
       * New value for property `criticality`
       */
      oCriticality?: any
    ): this;
    /**
     * Sets a new value for property {@link #getCriticalityRepresentationType criticalityRepresentationType}.
     *
     * Optional attribute, which can be set to control how the criticality is visualized.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `WithIcon`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCriticalityRepresentationType(
      /**
       * New value for property `criticalityRepresentationType`
       */
      sCriticalityRepresentationType?:
        | smartfield.CriticalityRepresentationType
        | keyof typeof smartfield.CriticalityRepresentationType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ObjectStatus constructor.
   */
  export interface $ObjectStatusSettings extends $ElementSettings {
    /**
     * Optional attribute to determine the rendered state. Possible values are the numeric representations of
     * the enum members of annotation `com.sap.vocabularies.UI.v1.CriticalityType`: 0: None 1: Error 2: Warning
     * 3: Success
     */
    criticality?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Optional attribute, which can be set to control how the criticality is visualized.
     */
    criticalityRepresentationType?:
      | (
          | smartfield.CriticalityRepresentationType
          | keyof typeof smartfield.CriticalityRepresentationType
        )
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartfilterbar/ControlConfiguration" {
  import {
    default as ControlConfigurationBase,
    $ControlConfigurationBaseSettings,
  } from "sap/ui/comp/config/ControlConfigurationBase";

  import SelectOption from "sap/ui/comp/smartfilterbar/SelectOption";

  import { valuehelpdialog, smartfilterbar } from "sap/ui/comp/library";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * ControlConfiguration can be used to add additional configuration for filter fields in the SmartFilterBar
   * control, in order to overwrite the default settings from the OData metadata. For instance, it is possible
   * to change the label, index or control type of a filter field.
   */
  export default class ControlConfiguration extends ControlConfigurationBase {
    /**
     * Constructor for a new smartfilterbar/ControlConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlConfigurationSettings
    );
    /**
     * Constructor for a new smartfilterbar/ControlConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ControlConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.ControlConfiguration with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.config.ControlConfigurationBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ControlConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.ControlConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some defaultFilterValue to the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDefaultFilterValue(
      /**
       * The defaultFilterValue to add; if empty, nothing is inserted
       */
      oDefaultFilterValue: SelectOption
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.ControlConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.ControlConfiguration` itself.
     *
     * Fired when the value of a property, for example isVisible, has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ControlConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.ControlConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.ControlConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.ControlConfiguration` itself.
     *
     * Fired when the value of a property, for example isVisible, has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ControlConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.ControlConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the customControl in the aggregation {@link #getCustomControl customControl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomControl(): this;
    /**
     * Destroys all the defaultFilterValues in the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefaultFilterValues(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.ControlConfiguration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ControlConfiguration$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ControlConfiguration$ChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getConditionPanelDefaultOperation conditionPanelDefaultOperation}.
     *
     * Sets default operation for Condition Panel of the Value Help dialog. In case the newly set default operation
     * is not valid for the filter's EDM data type, then it is ignored.
     *
     * @since 1.99
     *
     * @returns Value of property `conditionPanelDefaultOperation`
     */
    getConditionPanelDefaultOperation(): valuehelpdialog.ValueHelpRangeOperation;
    /**
     * Gets current value of property {@link #getControlType controlType}.
     *
     * The SmartFilterBar calculates which kind of control will be used for a filter fields based on multiple
     * OData Attributes and annotations. Using this property it is possible to overwrite the OData metadata.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Value of property `controlType`
     */
    getControlType(): smartfilterbar.ControlType;
    /**
     * Gets content of aggregation {@link #getCustomControl customControl}.
     *
     * If a custom control is specified, the SmartFilterBar will not create a control but use the custom control.
     * Additional services like TypeAhead have to implemented manually.
     */
    getCustomControl(): Control;
    /**
     * Gets content of aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     * Default value for a filter field. The aggregation expects {@link sap.ui.comp.smartfilterbar.SelectOption|SelectOption }
     * instances, where the values' format (properties `low` and `high`) match the type of the referneced property
     * and consider also the given constraints of the property.
     *
     * Samples for valid formats: `Edm.DateTime` with constraint `sap:display-format='Date'`: "2018-12-24" (you
     * optionally can provide a time-part and timezone, too, (2018-12-24T00:00:00Z) but this is ignored)
     *
     * `Edm.DateTimeOffset`: "2018-12-24T13:55:59Z"
     *
     * `Edm.Time`: "PT12H34M56S"
     *
     * `Edm.Boolean`: "false"
     *
     * `Edm.Decimal`: "2983.12"
     */
    getDefaultFilterValues(): SelectOption[];
    /**
     * Gets current value of property {@link #getDisplayBehaviour displayBehaviour}.
     *
     * The displayBehaviour specifies how the content should be displayed on certain controls. Ex: DescriptionOnly
     * for Combobox (DropDown text) , Description and ID for MultiInput (token text)
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Value of property `displayBehaviour`
     */
    getDisplayBehaviour(): smartfilterbar.DisplayBehaviour;
    /**
     * Gets current value of property {@link #getFilterType filterType}.
     *
     * The filter type specifies whether the filter field is of type single value, multi-value, or interval.
     * The filter type is calculated by the {@link sap.ui.comp.smartfilterbar.SmartFilterBar} control based
     * on the OData metadata. Using this property the filter type can be configured manually.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Value of property `filterType`
     */
    getFilterType(): smartfilterbar.FilterType;
    /**
     * Gets current value of property {@link #getGroupId groupId}.
     *
     * The groupId can be used to move a field from one group to another. The groupId corresponds to the EntityName
     * from the OData metadata. It is also possible to move a field from the advanced area to the basic area
     * by specifying the groupId _BASIC.
     *
     *
     * @returns Value of property `groupId`
     */
    getGroupId(): string;
    /**
     * Gets current value of property {@link #getHasTypeAhead hasTypeAhead}.
     *
     * Property can be used to enable the TypeAhead service. TypeAhead does not work with all controls, e.g
     * it does not work for DropDownListbox
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hasTypeAhead`
     */
    getHasTypeAhead(): boolean;
    /**
     * Gets current value of property {@link #getHasValidation hasValidation}.
     *
     * Specifies whether `sap.m.ComboBox` selectedKey has corresponding item or not.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hasValidation`
     */
    getHasValidation(): boolean;
    /**
     * Gets current value of property {@link #getHasValueHelpDialog hasValueHelpDialog}.
     *
     * Specifies whether a value help dialog is available or not.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hasValueHelpDialog`
     */
    getHasValueHelpDialog(): boolean;
    /**
     * Gets current value of property {@link #getHistoryEnabled historyEnabled}.
     *
     * If set to `false` history values are disabled.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * Default value is `true`.
     *
     * @since 1.84
     *
     * @returns Value of property `historyEnabled`
     */
    getHistoryEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIndex index}.
     *
     * The index property specifies the initial order of fields without any variants. It's zero based so in
     * order for it to be taken into account, its value must be equal to or bigger than 0. **Note:** To ensure
     * the expected sorting behavior, the index property should have a unique value.
     *
     * Default value is `-1`.
     *
     *
     * @returns Value of property `index`
     */
    getIndex(): int;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Using this property it is possible to overwrite the label of a filter field in the SmartFilterBar.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getMandatory mandatory}.
     *
     * Property can be used to overwrite the mandatory state of a filter field. Property can only be set during
     * initialization. Changes at runtime will be ignored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Value of property `mandatory`
     */
    getMandatory(): smartfilterbar.MandatoryType;
    /**
     * Gets current value of property {@link #getPreventInitialDataFetchInValueHelpDialog preventInitialDataFetchInValueHelpDialog}.
     *
     * In case there are value help annotations for this filter field, it is possible to specify whether the
     * table in the value help dialog for this field will be filled initially. The default value is `false`,
     * which means the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78
     * the default value has been changed from `true` to `false`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `preventInitialDataFetchInValueHelpDialog`
     */
    getPreventInitialDataFetchInValueHelpDialog(): boolean;
    /**
     * Gets current value of property {@link #getTimezone timezone}.
     *
     * Sets time zone for filter of type Edm.DateTimeOffset
     *
     * **Note:** The property is IANA timezone ID, e.g. "America/New_York". An invalid IANA timezone ID will
     * fall back to the UTC.
     *
     * @since 1.103
     *
     * @returns Value of property `timezone`
     */
    getTimezone(): string;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Using this flag it is possible to hide fields from the OData metadata.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getVisibleInAdvancedArea visibleInAdvancedArea}.
     *
     * If set to true this field will be added to the advanced area (aka. Dynamic Selection) by default.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `visibleInAdvancedArea`
     */
    getVisibleInAdvancedArea(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the filter field in a CSS compatible format. The width can be set only once during initialization.
     * Changes at runtime will not be reflected. The width will not be applied to custom controls.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): string;
    /**
     * Checks for the provided `sap.ui.comp.smartfilterbar.SelectOption` in the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDefaultFilterValue(
      /**
       * The defaultFilterValue whose index is looked for
       */
      oDefaultFilterValue: SelectOption
    ): int;
    /**
     * Inserts a defaultFilterValue into the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDefaultFilterValue(
      /**
       * The defaultFilterValue to insert; if empty, nothing is inserted
       */
      oDefaultFilterValue: SelectOption,
      /**
       * The `0`-based index the defaultFilterValue should be inserted at; for a negative value of `iIndex`, the
       * defaultFilterValue is inserted at position 0; for a value greater than the current size of the aggregation,
       * the defaultFilterValue is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefaultFilterValues(): SelectOption[];
    /**
     * Removes a defaultFilterValue from the aggregation {@link #getDefaultFilterValues defaultFilterValues}.
     *
     *
     * @returns The removed defaultFilterValue or `null`
     */
    removeDefaultFilterValue(
      /**
       * The defaultFilterValue to remove or its index or id
       */
      vDefaultFilterValue: int | string | SelectOption
    ): SelectOption | null;
    /**
     * Sets a new value for property {@link #getConditionPanelDefaultOperation conditionPanelDefaultOperation}.
     *
     * Sets default operation for Condition Panel of the Value Help dialog. In case the newly set default operation
     * is not valid for the filter's EDM data type, then it is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.99
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConditionPanelDefaultOperation(
      /**
       * New value for property `conditionPanelDefaultOperation`
       */
      sConditionPanelDefaultOperation?:
        | valuehelpdialog.ValueHelpRangeOperation
        | keyof typeof valuehelpdialog.ValueHelpRangeOperation
    ): this;
    /**
     * Sets a new value for property {@link #getControlType controlType}.
     *
     * The SmartFilterBar calculates which kind of control will be used for a filter fields based on multiple
     * OData Attributes and annotations. Using this property it is possible to overwrite the OData metadata.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setControlType(
      /**
       * New value for property `controlType`
       */
      sControlType?:
        | smartfilterbar.ControlType
        | keyof typeof smartfilterbar.ControlType
    ): this;
    /**
     * Sets the aggregated {@link #getCustomControl customControl}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomControl(
      /**
       * The customControl to set
       */
      oCustomControl: Control
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayBehaviour displayBehaviour}.
     *
     * The displayBehaviour specifies how the content should be displayed on certain controls. Ex: DescriptionOnly
     * for Combobox (DropDown text) , Description and ID for MultiInput (token text)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayBehaviour(
      /**
       * New value for property `displayBehaviour`
       */
      sDisplayBehaviour?:
        | smartfilterbar.DisplayBehaviour
        | keyof typeof smartfilterbar.DisplayBehaviour
    ): this;
    /**
     * Sets a new value for property {@link #getFilterType filterType}.
     *
     * The filter type specifies whether the filter field is of type single value, multi-value, or interval.
     * The filter type is calculated by the {@link sap.ui.comp.smartfilterbar.SmartFilterBar} control based
     * on the OData metadata. Using this property the filter type can be configured manually.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterType(
      /**
       * New value for property `filterType`
       */
      sFilterType?:
        | smartfilterbar.FilterType
        | keyof typeof smartfilterbar.FilterType
    ): this;
    /**
     * Sets a new value for property {@link #getGroupId groupId}.
     *
     * The groupId can be used to move a field from one group to another. The groupId corresponds to the EntityName
     * from the OData metadata. It is also possible to move a field from the advanced area to the basic area
     * by specifying the groupId _BASIC.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroupId(
      /**
       * New value for property `groupId`
       */
      sGroupId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHasTypeAhead hasTypeAhead}.
     *
     * Property can be used to enable the TypeAhead service. TypeAhead does not work with all controls, e.g
     * it does not work for DropDownListbox
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasTypeAhead(
      /**
       * New value for property `hasTypeAhead`
       */
      bHasTypeAhead?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHasValidation hasValidation}.
     *
     * Specifies whether `sap.m.ComboBox` selectedKey has corresponding item or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasValidation(
      /**
       * New value for property `hasValidation`
       */
      bHasValidation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHasValueHelpDialog hasValueHelpDialog}.
     *
     * Specifies whether a value help dialog is available or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHasValueHelpDialog(
      /**
       * New value for property `hasValueHelpDialog`
       */
      bHasValueHelpDialog?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHistoryEnabled historyEnabled}.
     *
     * If set to `false` history values are disabled.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHistoryEnabled(
      /**
       * New value for property `historyEnabled`
       */
      bHistoryEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIndex index}.
     *
     * The index property specifies the initial order of fields without any variants. It's zero based so in
     * order for it to be taken into account, its value must be equal to or bigger than 0. **Note:** To ensure
     * the expected sorting behavior, the index property should have a unique value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIndex(
      /**
       * New value for property `index`
       */
      iIndex?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * Using this property it is possible to overwrite the label of a filter field in the SmartFilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMandatory mandatory}.
     *
     * Property can be used to overwrite the mandatory state of a filter field. Property can only be set during
     * initialization. Changes at runtime will be ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'auto'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMandatory(
      /**
       * New value for property `mandatory`
       */
      sMandatory?:
        | smartfilterbar.MandatoryType
        | keyof typeof smartfilterbar.MandatoryType
    ): this;
    /**
     * Sets a new value for property {@link #getPreventInitialDataFetchInValueHelpDialog preventInitialDataFetchInValueHelpDialog}.
     *
     * In case there are value help annotations for this filter field, it is possible to specify whether the
     * table in the value help dialog for this field will be filled initially. The default value is `false`,
     * which means the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78
     * the default value has been changed from `true` to `false`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPreventInitialDataFetchInValueHelpDialog(
      /**
       * New value for property `preventInitialDataFetchInValueHelpDialog`
       */
      bPreventInitialDataFetchInValueHelpDialog?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTimezone timezone}.
     *
     * Sets time zone for filter of type Edm.DateTimeOffset
     *
     * **Note:** The property is IANA timezone ID, e.g. "America/New_York". An invalid IANA timezone ID will
     * fall back to the UTC.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.103
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimezone(
      /**
       * New value for property `timezone`
       */
      sTimezone?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Using this flag it is possible to hide fields from the OData metadata.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVisibleInAdvancedArea visibleInAdvancedArea}.
     *
     * If set to true this field will be added to the advanced area (aka. Dynamic Selection) by default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisibleInAdvancedArea(
      /**
       * New value for property `visibleInAdvancedArea`
       */
      bVisibleInAdvancedArea?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the filter field in a CSS compatible format. The width can be set only once during initialization.
     * Changes at runtime will not be reflected. The width will not be applied to custom controls.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ControlConfiguration constructor.
   */
  export interface $ControlConfigurationSettings
    extends $ControlConfigurationBaseSettings {
    /**
     * The groupId can be used to move a field from one group to another. The groupId corresponds to the EntityName
     * from the OData metadata. It is also possible to move a field from the advanced area to the basic area
     * by specifying the groupId _BASIC.
     */
    groupId?: string | PropertyBindingInfo;

    /**
     * Using this property it is possible to overwrite the label of a filter field in the SmartFilterBar.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Using this flag it is possible to hide fields from the OData metadata.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether a value help dialog is available or not.
     */
    hasValueHelpDialog?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether `sap.m.ComboBox` selectedKey has corresponding item or not.
     */
    hasValidation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The SmartFilterBar calculates which kind of control will be used for a filter fields based on multiple
     * OData Attributes and annotations. Using this property it is possible to overwrite the OData metadata.
     */
    controlType?:
      | (smartfilterbar.ControlType | keyof typeof smartfilterbar.ControlType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The filter type specifies whether the filter field is of type single value, multi-value, or interval.
     * The filter type is calculated by the {@link sap.ui.comp.smartfilterbar.SmartFilterBar} control based
     * on the OData metadata. Using this property the filter type can be configured manually.
     */
    filterType?:
      | (smartfilterbar.FilterType | keyof typeof smartfilterbar.FilterType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The index property specifies the initial order of fields without any variants. It's zero based so in
     * order for it to be taken into account, its value must be equal to or bigger than 0. **Note:** To ensure
     * the expected sorting behavior, the index property should have a unique value.
     */
    index?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Property can be used to enable the TypeAhead service. TypeAhead does not work with all controls, e.g
     * it does not work for DropDownListbox
     */
    hasTypeAhead?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Property can be used to overwrite the mandatory state of a filter field. Property can only be set during
     * initialization. Changes at runtime will be ignored.
     */
    mandatory?:
      | (
          | smartfilterbar.MandatoryType
          | keyof typeof smartfilterbar.MandatoryType
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The width of the filter field in a CSS compatible format. The width can be set only once during initialization.
     * Changes at runtime will not be reflected. The width will not be applied to custom controls.
     */
    width?: string | PropertyBindingInfo;

    /**
     * If set to true this field will be added to the advanced area (aka. Dynamic Selection) by default.
     */
    visibleInAdvancedArea?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * In case there are value help annotations for this filter field, it is possible to specify whether the
     * table in the value help dialog for this field will be filled initially. The default value is `false`,
     * which means the table will be filled as the data fetch is not prevented. **Note:** As of version 1.78
     * the default value has been changed from `true` to `false`.
     */
    preventInitialDataFetchInValueHelpDialog?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The displayBehaviour specifies how the content should be displayed on certain controls. Ex: DescriptionOnly
     * for Combobox (DropDown text) , Description and ID for MultiInput (token text)
     */
    displayBehaviour?:
      | (
          | smartfilterbar.DisplayBehaviour
          | keyof typeof smartfilterbar.DisplayBehaviour
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to `false` history values are disabled.
     *
     * **Note:** For {@link sap.m.ComboBox} and {@link sap.m.MultiComboBox} the history values are disabled
     * by default. To enable them for these controls, you need to set the `historyEnabled` property to `true`.
     *
     * @since 1.84
     */
    historyEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets default operation for Condition Panel of the Value Help dialog. In case the newly set default operation
     * is not valid for the filter's EDM data type, then it is ignored.
     *
     * @since 1.99
     */
    conditionPanelDefaultOperation?:
      | (
          | valuehelpdialog.ValueHelpRangeOperation
          | keyof typeof valuehelpdialog.ValueHelpRangeOperation
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Sets time zone for filter of type Edm.DateTimeOffset
     *
     * **Note:** The property is IANA timezone ID, e.g. "America/New_York". An invalid IANA timezone ID will
     * fall back to the UTC.
     *
     * @since 1.103
     */
    timezone?: string | PropertyBindingInfo;

    /**
     * Default value for a filter field. The aggregation expects {@link sap.ui.comp.smartfilterbar.SelectOption|SelectOption }
     * instances, where the values' format (properties `low` and `high`) match the type of the referneced property
     * and consider also the given constraints of the property.
     *
     * Samples for valid formats: `Edm.DateTime` with constraint `sap:display-format='Date'`: "2018-12-24" (you
     * optionally can provide a time-part and timezone, too, (2018-12-24T00:00:00Z) but this is ignored)
     *
     * `Edm.DateTimeOffset`: "2018-12-24T13:55:59Z"
     *
     * `Edm.Time`: "PT12H34M56S"
     *
     * `Edm.Boolean`: "false"
     *
     * `Edm.Decimal`: "2983.12"
     */
    defaultFilterValues?:
      | SelectOption[]
      | SelectOption
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * If a custom control is specified, the SmartFilterBar will not create a control but use the custom control.
     * Additional services like TypeAhead have to implemented manually.
     */
    customControl?: Control;

    /**
     * Fired when the value of a property, for example isVisible, has changed.
     */
    change?: (oEvent: ControlConfiguration$ChangeEvent) => void;
  }

  /**
   * Parameters of the ControlConfiguration#change event.
   */
  export interface ControlConfiguration$ChangeEventParameters {
    /**
     * Name of the changed property
     */
    propertyName?: string;
  }

  /**
   * Event object of the ControlConfiguration#change event.
   */
  export type ControlConfiguration$ChangeEvent = Event<
    ControlConfiguration$ChangeEventParameters,
    ControlConfiguration
  >;
}

declare module "sap/ui/comp/smartfilterbar/GroupConfiguration" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * A GroupConfiguration can be used to add additional configurations for groups in the SmartFilterBar. A
   * group in the SmartFilterBar is a group of filter fields in the advanced search.
   */
  export default class GroupConfiguration extends UI5Element {
    /**
     * Constructor for a new smartfilterbar/GroupConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GroupConfigurationSettings
    );
    /**
     * Constructor for a new smartfilterbar/GroupConfiguration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GroupConfigurationSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.GroupConfiguration with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GroupConfiguration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.GroupConfiguration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.GroupConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.GroupConfiguration` itself.
     *
     * Fired when the value of a property, for example label, has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GroupConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.GroupConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.GroupConfiguration`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.GroupConfiguration` itself.
     *
     * Fired when the value of a property, for example label, has changed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GroupConfiguration$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.GroupConfiguration`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ui.comp.smartfilterbar.GroupConfiguration`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GroupConfiguration$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GroupConfiguration$ChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getIndex index}.
     *
     * Zero based integer index. The index can be used to specify the order of groups. If no index is specified,
     * the order like in the OData metadata will be used.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `index`
     */
    getIndex(): any;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * The key property must correspond to the `EntitySet` name or `FieldGroup Qualifier` from the OData service
     * $metadata document.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Using this property it is possible to overwrite the label of a group in the advanced area of the SmartFilterBar.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): any;
    /**
     * Sets a new value for property {@link #getIndex index}.
     *
     * Zero based integer index. The index can be used to specify the order of groups. If no index is specified,
     * the order like in the OData metadata will be used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIndex(
      /**
       * New value for property `index`
       */
      oIndex?: any
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * The key property must correspond to the `EntitySet` name or `FieldGroup Qualifier` from the OData service
     * $metadata document.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * Using this property it is possible to overwrite the label of a group in the advanced area of the SmartFilterBar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      oLabel?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GroupConfiguration constructor.
   */
  export interface $GroupConfigurationSettings extends $ElementSettings {
    /**
     * The key property must correspond to the `EntitySet` name or `FieldGroup Qualifier` from the OData service
     * $metadata document.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Zero based integer index. The index can be used to specify the order of groups. If no index is specified,
     * the order like in the OData metadata will be used.
     */
    index?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Using this property it is possible to overwrite the label of a group in the advanced area of the SmartFilterBar.
     */
    label?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the value of a property, for example label, has changed
     */
    change?: (oEvent: GroupConfiguration$ChangeEvent) => void;
  }

  /**
   * Parameters of the GroupConfiguration#change event.
   */
  export interface GroupConfiguration$ChangeEventParameters {
    /**
     * Name of the changed property
     */
    propertyName?: string;
  }

  /**
   * Event object of the GroupConfiguration#change event.
   */
  export type GroupConfiguration$ChangeEvent = Event<
    GroupConfiguration$ChangeEventParameters,
    GroupConfiguration
  >;
}

declare module "sap/ui/comp/smartfilterbar/SelectOption" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import FilterOperator from "sap/ui/model/FilterOperator";

  import { smartfilterbar } from "sap/ui/comp/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A Select Option can be used to specify default filter values for a control configuration of the SmartFilterBar.
   */
  export default class SelectOption extends UI5Element {
    /**
     * Constructor for a new smartfilterbar/SelectOption.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SelectOptionSettings
    );
    /**
     * Constructor for a new smartfilterbar/SelectOption.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SelectOptionSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.SelectOption with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SelectOption>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.SelectOption.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getHigh high}.
     *
     * The high value for a select option. The high value is only required for a few operators, e.g. BT (between).
     *
     *
     * @returns Value of property `high`
     */
    getHigh(): string;
    /**
     * Gets current value of property {@link #getLow low}.
     *
     * The low value for a select option.
     *
     *
     * @returns Value of property `low`
     */
    getLow(): string;
    /**
     * Gets current value of property {@link #getOperator operator}.
     *
     * The operator for a select option. The default value is EQ "for equals".
     *
     * Default value is `'EQ'`.
     *
     *
     * @returns Value of property `operator`
     */
    getOperator(): FilterOperator;
    /**
     * Gets current value of property {@link #getSign sign}.
     *
     * The sign for a Select Option. Possible values are I for include or E for exclude.
     *
     * Default value is `'I'`.
     *
     *
     * @returns Value of property `sign`
     */
    getSign(): smartfilterbar.SelectOptionSign;
    /**
     * Sets a new value for property {@link #getHigh high}.
     *
     * The high value for a select option. The high value is only required for a few operators, e.g. BT (between).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHigh(
      /**
       * New value for property `high`
       */
      sHigh?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLow low}.
     *
     * The low value for a select option.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLow(
      /**
       * New value for property `low`
       */
      sLow?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOperator operator}.
     *
     * The operator for a select option. The default value is EQ "for equals".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'EQ'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOperator(
      /**
       * New value for property `operator`
       */
      sOperator?: FilterOperator | keyof typeof FilterOperator
    ): this;
    /**
     * Sets a new value for property {@link #getSign sign}.
     *
     * The sign for a Select Option. Possible values are I for include or E for exclude.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'I'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSign(
      /**
       * New value for property `sign`
       */
      sSign?: smartfilterbar.SelectOptionSign
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SelectOption constructor.
   */
  export interface $SelectOptionSettings extends $ElementSettings {
    /**
     * The sign for a Select Option. Possible values are I for include or E for exclude.
     */
    sign?:
      | smartfilterbar.SelectOptionSign
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The operator for a select option. The default value is EQ "for equals".
     */
    operator?:
      | (FilterOperator | keyof typeof FilterOperator)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The low value for a select option.
     */
    low?: string | PropertyBindingInfo;

    /**
     * The high value for a select option. The high value is only required for a few operators, e.g. BT (between).
     */
    high?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/comp/smartfilterbar/SFBMultiComboBox" {
  import {
    default as MultiComboBox,
    $MultiComboBoxSettings,
  } from "sap/m/MultiComboBox";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Extends the functionalities in sap.m.MultiComboBox
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class SFBMultiComboBox
    extends MultiComboBox
    implements /* was: sap.ui.comp.IDropDownTextArrangement */ Object
  {
    __implements__sap_ui_comp_IDropDownTextArrangement: boolean;
    /**
     * Constructor for a new `SmartFilterBar/SFBMultiComboBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.SFBMultiComboBox with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.MultiComboBox.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SFBMultiComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.SFBMultiComboBox.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getTextArrangement textArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `textArrangement`
     */
    getTextArrangement(): string;
    /**
     * Sets a new value for property {@link #getTextArrangement textArrangement}.
     *
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextArrangement(
      /**
       * New value for property `textArrangement`
       */
      sTextArrangement?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SFBMultiComboBox constructor.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export interface $SFBMultiComboBoxSettings extends $MultiComboBoxSettings {
    /**
     * Sets the `value` property formatting according to the `com.sap.vocabularies.UI.v1.TextArrangementType`
     * from the ValueList property.
     */
    textArrangement?: string | PropertyBindingInfo;
  }
}

declare module "sap/ui/comp/smartfilterbar/SmartFilterBar" {
  import {
    default as FilterBar,
    fetchVariantResponse,
    $FilterBarSettings,
  } from "sap/ui/comp/filterbar/FilterBar";

  import ControlConfiguration from "sap/ui/comp/smartfilterbar/ControlConfiguration";

  import GroupConfiguration from "sap/ui/comp/smartfilterbar/GroupConfiguration";

  import FilterItem from "sap/ui/comp/filterbar/FilterItem";

  import Control from "sap/ui/core/Control";

  import SearchField from "sap/m/SearchField";

  import Filter from "sap/ui/model/Filter";

  import FilterGroupItem from "sap/ui/comp/filterbar/FilterGroupItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import SmartVariantManagement from "sap/ui/comp/smartvariants/SmartVariantManagement";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The `SmartFilterBar` is a wrapper that uses the OData metadata of an entity to create a filter bar based
   * on the content defined by the OData service. Whether a field is visible on the filter bar, supports type-ahead
   * and value help, for example, is automatically determined.
   *  Note that all internally created instances are considered as private.
   *  You can use the control configuration and group configuration classes to configure the filter fields
   * and adapt them to your needs. For example:
   * 	 - Determine the type of control – for example whether a field is shown as a {@link sap.m.MultiInput multi input }
   *     field or as a {@link sap.m.DatePicker date picker}.
   * 	 - Enable the autocomplete suggestions feature.
   * 	 - Enable the {@link sap.ui.comp.valuehelpdialog.ValueHelpDialog value help dialog}.
   * 	 - Overwrite settings from the OData service.
   * 	 - Set custom filter groups.
   * 	 - Add custom fields.
   * 	 - Access the settings of the underlying {@link sap.ui.comp.filterbar.FilterBar filter bar}.
   *
   * **Note:** Most of the attributes/properties are not dynamic and cannot be changed once the control has
   * been initialized.
   *
   * The SmartFilterBar control supports fiscal annotations, history of the recently used values and value
   * list IN/OUT parameters.
   *
   * Usage: When to use
   * 	 - You use an OData service for your app (only OData version 2).
   * 	 - You need a metadata-driven control and the features of the SmartFilterBar control are suitable for
   *     your app.
   * 	 - You want to develop quickly and efficiently.
   *
   * When not to use
   * 	 - You are not using OData version 2.
   * 	 - You need to implement extensive changes to the {@link sap.ui.comp.filterbar.FilterBar filter bar}.
   *
   *
   * **Important:** Keep in mind that `SmartFilterBar`, like all SAPUI5 smart controls, retrieves and analyzes
   * the metadata and annotations of OData services. **The OData metadata is its primary API. These OData
   * services are not part of the SAPUI5 framework and are usually maintained by the backend developers of
   * your application.**
   *
   * With time, `SmartFilterBar` can evolve and acquire new features. This means that its behavior or functionalities
   * may change if the annotations that define this change are maintained in your backend metadata. To benefit
   * from the new functionalities, your application should be able to adapt the backend metadata. **Therefore,
   * we recommend using `SmartFilterBar` only if you have control over the metadata of your application.**
   */
  export default class SmartFilterBar extends FilterBar {
    /**
     * Constructor for a new smartfilterbar/SmartFilterBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/7bcdffc056a94731b4341db73251e32b Smart Filter Bar}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/smart-filter-bar-annotations/ Smart Filter Bar}
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartFilterBarSettings
    );
    /**
     * Constructor for a new smartfilterbar/SmartFilterBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/7bcdffc056a94731b4341db73251e32b Smart Filter Bar}
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/smart-filter-bar-annotations/ Smart Filter Bar}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sID?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartFilterBarSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.SmartFilterBar with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.filterbar.FilterBar.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartFilterBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.SmartFilterBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some controlConfiguration to the aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addControlConfiguration(
      /**
       * The controlConfiguration to add; if empty, nothing is inserted
       */
      oControlConfiguration: ControlConfiguration
    ): this;
    /**
     * Searches for the filter field having the specified OData key and adds this filter field to the advanced
     * area. If there is no corresponding field in the OData metadata, this method has no effect.
     */
    addFieldToAdvancedArea(
      /**
       * The key like specified in the OData metadata
       */
      sKey: string
    ): void;
    /**
     * Adds some groupConfiguration to the aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGroupConfiguration(
      /**
       * The groupConfiguration to add; if empty, nothing is inserted
       */
      oGroupConfiguration: GroupConfiguration
    ): this;
    /**
     * Applies the current variant as opposed to `fetchVariant`. The variant is retrieved via the flex layer.
     */
    applyVariant(
      /**
       * The variant that must be applied. oVariant must contain a valid JSON object.
       */
      oVariant: Object
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pendingChange pendingChange} event of this `sap.ui.comp.smartfilterbar.SmartFilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.SmartFilterBar` itself.
     *
     * This event is fired after the pending state of the `FilterBar` control changes.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPendingChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartFilterBar$PendingChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.SmartFilterBar`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pendingChange pendingChange} event of this `sap.ui.comp.smartfilterbar.SmartFilterBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartfilterbar.SmartFilterBar` itself.
     *
     * This event is fired after the pending state of the `FilterBar` control changes.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPendingChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartFilterBar$PendingChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartfilterbar.SmartFilterBar`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the controlConfiguration in the aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyControlConfiguration(): this;
    /**
     * Destroys all the groupConfiguration in the aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGroupConfiguration(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pendingChange pendingChange} event of this
     * `sap.ui.comp.smartfilterbar.SmartFilterBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.36
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPendingChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartFilterBar$PendingChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Retrieves the control associated to the filter.
     *
     * @deprecated As of version 1.99. Use {@link sap.ui.core.Core.byId} instead.
     *
     * @returns The corresponding control. If no match is found `null` is returned.
     */
    determineControlByFilterItem(
      /**
       * From the aggregations
       */
      oFilterItem: FilterItem,
      /**
       * check also analytics parameter
       */
      bConsiderParameters: boolean
    ): Control;
    /**
     * Retrieves the control based on the name and group name.
     *
     * @deprecated As of version 1.99. Use {@link sap.ui.core.Core.byId} instead.
     *
     * @returns The corresponding control, if no match is found, `null` is returned.
     */
    determineControlByName(
      /**
       * Name of the filter.
       */
      sName: string,
      /**
       * Group name of the filter; `null` for filter that belongs to basic group.
       */
      sGroupName?: string
    ): Control;
    /**
     * Ensures the associated ValueHelpProvider is loaded.
     */
    ensureLoadedValueHelp(
      /**
       * is the name of the property from the entity type which is associated with a Value Help.
       */
      sFieldName: string
    ): void;
    /**
     * Retrieves the currently visible filters and the values for storing them as variants. The result will
     * be passed on as a JSON object to the callee smart variant control.
     *
     *
     * @returns An arbitrary Object with an example structure:
     *
     * ```javascript
     * {
     *   filterBarVariant: any,
     *   filterbar: [
     *     {
     *       group: string,
     *       name: string,
     *       partOfCurrentVariant: boolean,
     *       visible: boolean,
     *       visibleInFilterBar: boolean
     *     },
     *     ...
     *   ],
     *   orderedFilterItems: string,
     *   singleInputsTextArrangementData: string,
     *   version: string|undefined,
     *   basicSearch: string|undefined
     * }```
     */
    fetchVariant(): fetchVariantResponse;
    /**
     * Fires event {@link #event:pendingChange pendingChange} to attached listeners.
     *
     * @since 1.36
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePendingChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartFilterBar$PendingChangeEventParameters
    ): this;
    /**
     * Returns the binding paths for the parameters.
     *
     *
     * @returns Binding path of the parameters
     */
    getAnalyticBindingPath(): string;
    /**
     * Returns an instance of the control for the basic search.
     *
     *
     * @returns Basic search control
     */
    getBasicSearchControl(): Record<string, SearchField>;
    /**
     * Gets current value of property {@link #getBasicSearchFieldName basicSearchFieldName}.
     *
     * Name of the field that is the focus of the basic search.
     *
     *
     * @returns Value of property `basicSearchFieldName`
     */
    getBasicSearchFieldName(): string;
    /**
     * Gets current value of property {@link #getConsiderAnalyticalParameters considerAnalyticalParameters}.
     *
     * Indicates if the analytical parameters (SelectionVariant) must be taken into consideration.
     *
     * Default value is `false`.
     *
     * @since 1.42.0
     *
     * @returns Value of property `considerAnalyticalParameters`
     */
    getConsiderAnalyticalParameters(): boolean;
    /**
     * Gets current value of property {@link #getConsiderPresentationVariant considerPresentationVariant}.
     *
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.PresentationVariant` is taken into account.
     *
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `considerPresentationVariant`
     */
    getConsiderPresentationVariant(): boolean;
    /**
     * Gets current value of property {@link #getConsiderSelectionVariants considerSelectionVariants}.
     *
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.SelectionVariant` is taken into account.
     *  **Note**: Only relevant for control level personalization.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     *
     * @returns Value of property `considerSelectionVariants`
     */
    getConsiderSelectionVariants(): boolean;
    /**
     * Returns the control (if any) with the specified key (Property name in OData entity). Use just the property
     * name as the key when getting a control from the basic area. Example: "CompanyCode" & Use "EntityName/GroupName.FieldName"
     * format to get controls from groups. Example:"Account.CompanyCode"
     *
     * @deprecated As of version 1.99. Use {@link sap.ui.core.Core.byId} for custom controls provided by you.
     * To modify data use {@link sap.ui.comp.smartfilterbar.SmartFilterBar#setFilterData} or {@link sap.ui.comp.filterbar.FilterBar#setUiState}.
     *
     * @returns The control in the filter bar, if any
     */
    getControlByKey(
      /**
       * The key as present in the OData property name/control configuration
       */
      sKey: string
    ): Object | Control | undefined;
    /**
     * Gets content of aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     * Using control configurations you can add additional configuration to filter fields, for example set custom
     * labels, change the order of fields, or change the filter field control type. **Note:** Changing the values
     * here after the SmartFilter is initialized (`initialise` event was fired) has no effect.
     */
    getControlConfiguration(): ControlConfiguration[];
    /**
     * Returns the condition type object (if any) with the specified key (Property name in OData entity). Use
     * just the property name as the key when getting a control from the basic area.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns Promise with condition type object
     */
    getDateRangeTypeByKey(
      /**
       * The key as present in the OData property name/control configuration
       */
      sKey: string
    ): Promise<DateRangeTypeByKeyResponse | undefined>;
    /**
     * Gets current value of property {@link #getDefaultSelectionVariantName defaultSelectionVariantName}.
     *
     * Determines one specific variant that is based on the `com.sap.vocabularies.UI.v1.SelectionVariant` annotation,
     * which is then used as the default variant.
     *  This property is only relevant in case `considerSelectionVariants` is set to `true` and will only be
     * applied if there is no user-defined default variant specified.
     *  **Note**: Only relevant for control level personalization.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     *
     * @returns Value of property `defaultSelectionVariantName`
     */
    getDefaultSelectionVariantName(): string;
    /**
     * Reads the descriptions for given filters and value keys.
     *
     * @since 1.75
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getDescriptionForKeys(
      /**
       * List of filters with value keys to be retrieved
       */
      aFiltersWithKeyValues: any[]
    ): void;
    /**
     * Gets current value of property {@link #getEnableBasicSearch enableBasicSearch}.
     *
     * Enables the basic search field. The entered value can be accessed with {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getParameters}.
     * **Note:** When the `SmartFilterBar` control is used with a {@link sap.ui.comp.smarttable.SmartTable }
     * control the parameters are handled automatically. Therefore, this must only be enabled for OData service
     * entities that support basic search.
     * **Note:** basic search field is restricted to 1000 characters and spaces.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableBasicSearch`
     */
    getEnableBasicSearch(): boolean;
    /**
     * Gets current value of property {@link #getEntitySet entitySet}.
     *
     * The OData entity set whose metadata is used to create the `SmartFilterBar`. **Note:** Changing this value
     * after the `SmartFilterBar` is initialized (`initialise` event was fired) has no effect.
     *
     *
     * @returns Value of property `entitySet`
     */
    getEntitySet(): string;
    /**
     * Gets current value of property {@link #getEntityType entityType}.
     *
     * The OData entity type whose metadata is used to create the `SmartFilterBar`. **Note:** Changing this
     * value after the `SmartFilterBar` is initialized (`initialise` event was fired) has no effect.
     *
     * @deprecated As of version 1.40. Use `entitySet` property instead of this one, to enable V4 annotation
     * support
     *
     * @returns Value of property `entityType`
     */
    getEntityType(): string;
    /**
     * Get the filter context url.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Filter context url.
     */
    getFilterContextUrl(): string;
    /**
     * Returns the data currently set in the filter data model.
     *
     *
     * @returns The JSON data in the filter bar
     */
    getFilterData(
      /**
       * Also include empty/invisible fields filter data
       */
      bAllFilterData?: boolean,
      /**
       * indication if the filter valueState should be omitted
       */
      bIgnoreErrorState?: boolean
    ): Object;
    /**
     * Returns the data currently set in the filter data model as string.
     *
     *
     * @returns The JSON data string
     */
    getFilterDataAsString(
      /**
       * Also include empty/invisible fields filter data
       */
      bAllFilterData: boolean
    ): string | null;
    /**
     * Returns an array of filters (sap.ui.model.Filter instances), for visible fields, that can be used to
     * restrict the query result from OData.
     *  The result of this method can directly be used during aggregation binding or OData read.
     *
     *
     * @returns array of sap.ui.model.Filter or multi-filters
     */
    getFilters(
      /**
       * optional array of field names that filters should be returned, if not given all visible filters are returned
       */
      aFieldNames?: string[]
    ): Filter[];
    /**
     * Returns all filter items
     * 	 - Containing a value
     * 	 - With the `visible` property set to `true`
     * 	 - That are either flagged as `partOfCurrentVariant` or `visibleInFilterBar`
     * 	 - That are not custom filters  Even hidden filters will be considered as long as the mentioned
     *     criteria is fullfilled.
     *
     *
     * @returns Filter items containing a value
     */
    getFiltersWithValues(): FilterGroupItem[];
    /**
     * Gets content of aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     * Provides the possibility to add additional configuration to groups. Groups are used to show fields in
     * the advanced area of the SmartFilterBar. With additional configuration, you can for example set custom
     * labels or change the order of groups. **Note:** Changing the values here after the SmartFilter is initialized
     * (`initialise` event was fired) has no effect.
     */
    getGroupConfiguration(): GroupConfiguration[];
    /**
     * Gets current value of property {@link #getLiveMode liveMode}.
     *
     * If set the search will be automatically triggered, when a filter value was set via the change
     * event.
     *  **Note:** The liveMode only operates on non-mobile scenarios.
     *  Additionally, if liveMode is set, the following applies:
     * 	 - The error messagebox is not displayed, and the `showMessages` property is ignored.
     * 	 - The search is triggered after a variant has been selected.
     * 	 - Execute on Select for `VariantManagement` is not shown and not taken into account
     *
     * Default value is `false`.
     *
     * @since 1.40
     *
     * @returns Value of property `liveMode`
     */
    getLiveMode(): boolean;
    /**
     * Get the model data.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns of the model data.
     */
    getModelData(): Record<string, any>;
    /**
     * Gets current value of property {@link #getNavigationProperties navigationProperties}.
     *
     * This property is only evaluated if the property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getUseProvidedNavigationProperties }
     * is set to `true`. It contains a comma-separated list of `NavigationProperty`> names which are checked
     * for filters. It can also contain a list of separate filters from different `NavigationProperty` names.
     *
     *
     *
     * Default value is `empty string`.
     *
     * @since 1.48
     *
     * @returns Value of property `navigationProperties`
     */
    getNavigationProperties(): string;
    /**
     * Returns the binding paths for the parameters. This API can be used for both analytical and non-analytical
     * services. **Note**For analytical services, the API is NOT stable yet. Use at your own risk.
     *
     * @since 1.53.0
     *
     * @returns Binding path of the parameters
     */
    getParameterBindingPath(): string;
    /**
     * Get the parameter context url.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Parameter context url.
     */
    getParameterContextUrl(): string;
    /**
     * Returns a parameter object that can be used to restrict the result of an OData service request if a basic
     * search is performed. Example of a returned object:
     *
     *
     * ```javascript
     *
     * {
     * 	"custom": {
     * 		"search-focus": "MySearchFocusFieldName",
     * 		"search": "MySearchString"
     * 	}
     * }
     * ```
     *
     *
     * These parameters can be handed over as custom parameters, for example, to the {@link sap.ui.model.odata.v2.ODataListBinding}.
     *
     *
     * @returns A parameter object containing OData query parameters
     */
    getParameters(): Record<string, Record<string, string>>;
    /**
     * Gets current value of property {@link #getResourceUri resourceUri}.
     *
     * Optional. The OData service URL. If it is not specified, the service URL from the OData model (this.getModel())
     * will be used. **Note:** Changing this value after the SmartFilterBar is initialized (initialise event
     * was fired) has no effect.
     *
     * @deprecated As of version 1.29. Set an ODataModel as the main model on your control/view instead
     *
     * @returns Value of property `resourceUri`
     */
    getResourceUri(): string;
    /**
     * Gets current value of property {@link #getShowMessages showMessages}.
     *
     * If set to `true`, any errors that occur during the search, are displayed in a message box in addition
     * to the `valueState` with the error. **Note:** As of version 1.89, the default value has been changed
     * from `true` to `false`.
     *
     * Default value is `false`.
     *
     * @since 1.40
     *
     * @returns Value of property `showMessages`
     */
    getShowMessages(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getSmartVariant smartVariant},
     * or `null`.
     *
     * @since 1.38
     */
    getSmartVariant(): ID | null;
    /**
     * Gets current value of property {@link #getSuppressSelection suppressSelection}.
     *
     * If set to `true` all search requests will be ignored. This functionality is only intended to be used
     * internally to enable an optimal solution when the filter bar is controlled by the smart templates. NOTE:
     * As long as this property is set to `true`, all search requests will be neglected.
     *
     * Default value is `false`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `suppressSelection`
     */
    getSuppressSelection(): boolean;
    /**
     * Gets current value of property {@link #getUseDateRangeType useDateRangeType}.
     *
     * If set to `true` all date fields with filter restriction `interval` will be treated as `DateTimeRange`
     * filters. The `useDateRangeType` can be set only once during initialization. **Note:** If this property
     * is set to `true` and any date filters with filter restriction `interval` were stored as part of a variant,
     * the values of these filters cannot be applied. If this property is set to `false`, any previously stored
     * filters which were treated as type `DateTimeRange` based on the former setting, cannot be converted back
     * to the standard date interval.
     *
     * @since 1.46.0
     *
     * @returns Value of property `useDateRangeType`
     */
    getUseDateRangeType(): boolean;
    /**
     * Gets current value of property {@link #getUseProvidedNavigationProperties useProvidedNavigationProperties}.
     *
     * If set to `true`, only the navigation properties mentioned in property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getNavigationProperties }
     * are checked for further filters.
     *
     * Default value is `false`.
     *
     * @since 1.48
     *
     * @returns Value of property `useProvidedNavigationProperties`
     */
    getUseProvidedNavigationProperties(): boolean;
    /**
     * Checks for the provided `sap.ui.comp.smartfilterbar.ControlConfiguration` in the aggregation {@link #getControlConfiguration controlConfiguration}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfControlConfiguration(
      /**
       * The controlConfiguration whose index is looked for
       */
      oControlConfiguration: ControlConfiguration
    ): int;
    /**
     * Checks for the provided `sap.ui.comp.smartfilterbar.GroupConfiguration` in the aggregation {@link #getGroupConfiguration groupConfiguration}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGroupConfiguration(
      /**
       * The groupConfiguration whose index is looked for
       */
      oGroupConfiguration: GroupConfiguration
    ): int;
    /**
     * Inserts a controlConfiguration into the aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertControlConfiguration(
      /**
       * The controlConfiguration to insert; if empty, nothing is inserted
       */
      oControlConfiguration: ControlConfiguration,
      /**
       * The `0`-based index the controlConfiguration should be inserted at; for a negative value of `iIndex`,
       * the controlConfiguration is inserted at position 0; for a value greater than the current size of the
       * aggregation, the controlConfiguration is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a groupConfiguration into the aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGroupConfiguration(
      /**
       * The groupConfiguration to insert; if empty, nothing is inserted
       */
      oGroupConfiguration: GroupConfiguration,
      /**
       * The `0`-based index the groupConfiguration should be inserted at; for a negative value of `iIndex`, the
       * groupConfiguration is inserted at position 0; for a value greater than the current size of the aggregation,
       * the groupConfiguration is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Checks whether the control is initialised
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns whether control is already initialised
     */
    isInitialised(): boolean;
    /**
     * Determines if the custom data 'dateFormatSettings' is set with UTC mode `true`
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns whether the filter bar is running in UTC mode
     */
    isInUTCMode(): boolean;
    /**
     * Checks the pending state of the FilterBar control
     *
     *
     * @returns true if at least one FilterItem element of the FilterBar control is pending
     */
    isPending(): boolean;
    /**
     * Removes all the controls from the aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllControlConfiguration(): ControlConfiguration[];
    /**
     * Removes all the controls from the aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGroupConfiguration(): GroupConfiguration[];
    /**
     * Removes a controlConfiguration from the aggregation {@link #getControlConfiguration controlConfiguration}.
     *
     *
     * @returns The removed controlConfiguration or `null`
     */
    removeControlConfiguration(
      /**
       * The controlConfiguration to remove or its index or id
       */
      vControlConfiguration: int | string | ControlConfiguration
    ): ControlConfiguration | null;
    /**
     * Removes a groupConfiguration from the aggregation {@link #getGroupConfiguration groupConfiguration}.
     *
     *
     * @returns The removed groupConfiguration or `null`
     */
    removeGroupConfiguration(
      /**
       * The groupConfiguration to remove or its index or id
       */
      vGroupConfiguration: int | string | GroupConfiguration
    ): GroupConfiguration | null;
    /**
     * Resumes calls to the `search` method. If it was called during the suspension, the search will be triggered
     * once regardless of how many times it was called during suspension.
     */
    resumeSelection(): void;
    /**
     * Overwrites method from base class. Called when user clicks the search button of the FilterBar. The search
     * is executed asynchronously per default, but can be forced to synchronously execution by providing the
     * `bSync` set to `true`. Synchronous mode is only supported for non live mode scenarios. In the synchronous
     * mode a mandatory check prior to the search execution is made.
     *
     *
     * @returns Indicates if there are validation errors. NOTE: can also return 'undefined' (e.g. when 'suppressSelection'
     * is set). This cannot be expressed in the TypeScript API because this is incompatible to the parent class'
     * 'search' method return value.
     */
    search(
      /**
       * Indicates if the search should be triggered synchronously
       */
      bSync?: boolean
    ): boolean;
    /**
     * Sets a new value for property {@link #getBasicSearchFieldName basicSearchFieldName}.
     *
     * Name of the field that is the focus of the basic search.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBasicSearchFieldName(
      /**
       * New value for property `basicSearchFieldName`
       */
      sBasicSearchFieldName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getConsiderAnalyticalParameters considerAnalyticalParameters}.
     *
     * Indicates if the analytical parameters (SelectionVariant) must be taken into consideration.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConsiderAnalyticalParameters(
      /**
       * New value for property `considerAnalyticalParameters`
       */
      bConsiderAnalyticalParameters?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getConsiderPresentationVariant considerPresentationVariant}.
     *
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.PresentationVariant` is taken into account.
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConsiderPresentationVariant(
      /**
       * New value for property `considerPresentationVariant`
       */
      bConsiderPresentationVariant?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getConsiderSelectionVariants considerSelectionVariants}.
     *
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.SelectionVariant` is taken into account.
     *  **Note**: Only relevant for control level personalization.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setConsiderSelectionVariants(
      /**
       * New value for property `considerSelectionVariants`
       */
      bConsiderSelectionVariants?: boolean
    ): this;
    /**
     * Sets the the Dynamic Date Option of condition type (if any) data in the filter data model.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns Promise
     */
    setDateRangeTypeOperationByKey(
      /**
       * The key as present in the OData property name/control configuration
       */
      sKey: string,
      /**
       * The key of Dynamic Date Option
       */
      sOption: string
    ): Promise<DateRangeTypeByKeyResponse | undefined>;
    /**
     * Sets a new value for property {@link #getDefaultSelectionVariantName defaultSelectionVariantName}.
     *
     * Determines one specific variant that is based on the `com.sap.vocabularies.UI.v1.SelectionVariant` annotation,
     * which is then used as the default variant.
     *  This property is only relevant in case `considerSelectionVariants` is set to `true` and will only be
     * applied if there is no user-defined default variant specified.
     *  **Note**: Only relevant for control level personalization.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultSelectionVariantName(
      /**
       * New value for property `defaultSelectionVariantName`
       */
      sDefaultSelectionVariantName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnableBasicSearch enableBasicSearch}.
     *
     * Enables the basic search field. The entered value can be accessed with {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getParameters}.
     * **Note:** When the `SmartFilterBar` control is used with a {@link sap.ui.comp.smarttable.SmartTable }
     * control the parameters are handled automatically. Therefore, this must only be enabled for OData service
     * entities that support basic search.
     * **Note:** basic search field is restricted to 1000 characters and spaces.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableBasicSearch(
      /**
       * New value for property `enableBasicSearch`
       */
      bEnableBasicSearch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEntityType entityType}.
     *
     * The OData entity type whose metadata is used to create the `SmartFilterBar`. **Note:** Changing this
     * value after the `SmartFilterBar` is initialized (`initialise` event was fired) has no effect.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.40. Use `entitySet` property instead of this one, to enable V4 annotation
     * support
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntityType(
      /**
       * New value for property `entityType`
       */
      sEntityType?: string
    ): this;
    /**
     * Sets the data in the filter data model. The follow-on filterChange event is only triggered when none
     * _CUSTOM data is set.
     */
    setFilterData(
      /**
       * The JSON data in the filter bar
       */
      oJson: object,
      /**
       * Replace existing filter data
       */
      bReplace: boolean
    ): void;
    /**
     * Sets the data in the filter data model as string.
     */
    setFilterDataAsString(
      /**
       * The JSON data in the filter bar
       */
      sJson: string,
      /**
       * Replace existing filter data
       */
      bReplace: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getLiveMode liveMode}.
     *
     * If set the search will be automatically triggered, when a filter value was set via the change
     * event.
     *  **Note:** The liveMode only operates on non-mobile scenarios.
     *  Additionally, if liveMode is set, the following applies:
     * 	 - The error messagebox is not displayed, and the `showMessages` property is ignored.
     * 	 - The search is triggered after a variant has been selected.
     * 	 - Execute on Select for `VariantManagement` is not shown and not taken into account
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.40
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLiveMode(
      /**
       * New value for property `liveMode`
       */
      bLiveMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getNavigationProperties navigationProperties}.
     *
     * This property is only evaluated if the property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getUseProvidedNavigationProperties }
     * is set to `true`. It contains a comma-separated list of `NavigationProperty`> names which are checked
     * for filters. It can also contain a list of separate filters from different `NavigationProperty` names.
     *
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNavigationProperties(
      /**
       * New value for property `navigationProperties`
       */
      sNavigationProperties?: string
    ): this;
    /**
     * Uses the provided resource URI to fetch the OData metadata instead of using the default ODataModel (getModel()).
     * You should only set this if you intend to get the metadata for the filter bar from elsewhere!
     *
     * @deprecated As of version 1.29. Set an ODataModel as the main model on your control/view instead
     *
     * @returns `this` to allow method chaining
     */
    setResourceUri(
      /**
       * The URI of the oData service from which the metadata would be read
       */
      sResourceUri: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowMessages showMessages}.
     *
     * If set to `true`, any errors that occur during the search, are displayed in a message box in addition
     * to the `valueState` with the error. **Note:** As of version 1.89, the default value has been changed
     * from `true` to `false`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.40
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMessages(
      /**
       * New value for property `showMessages`
       */
      bShowMessages?: boolean
    ): this;
    /**
     * Sets the associated {@link #getSmartVariant smartVariant}.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSmartVariant(
      /**
       * ID of an element which becomes the new target of this smartVariant association; alternatively, an element
       * instance may be given
       */
      oSmartVariant: ID | SmartVariantManagement
    ): this;
    /**
     * Sets a new value for property {@link #getSuppressSelection suppressSelection}.
     *
     * If set to `true` all search requests will be ignored. This functionality is only intended to be used
     * internally to enable an optimal solution when the filter bar is controlled by the smart templates. NOTE:
     * As long as this property is set to `true`, all search requests will be neglected.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSuppressSelection(
      /**
       * New value for property `suppressSelection`
       */
      bSuppressSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseDateRangeType useDateRangeType}.
     *
     * If set to `true` all date fields with filter restriction `interval` will be treated as `DateTimeRange`
     * filters. The `useDateRangeType` can be set only once during initialization. **Note:** If this property
     * is set to `true` and any date filters with filter restriction `interval` were stored as part of a variant,
     * the values of these filters cannot be applied. If this property is set to `false`, any previously stored
     * filters which were treated as type `DateTimeRange` based on the former setting, cannot be converted back
     * to the standard date interval.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseDateRangeType(
      /**
       * New value for property `useDateRangeType`
       */
      bUseDateRangeType?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseProvidedNavigationProperties useProvidedNavigationProperties}.
     *
     * If set to `true`, only the navigation properties mentioned in property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getNavigationProperties }
     * are checked for further filters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.48
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseProvidedNavigationProperties(
      /**
       * New value for property `useProvidedNavigationProperties`
       */
      bUseProvidedNavigationProperties?: boolean
    ): this;
    /**
     * Suspends calls to the `search` method when not called with the `bSync` parameter.
     */
    suspendSelection(): void;
    /**
     * Verifies if all mandatory filters or parameters have values.
     *
     *
     * @returns true indicates that all mandatory filters and parameters have values.
     */
    validateMandatoryFields(): boolean;
    /**
     * Verifies if search is possible.
     *
     *
     * @returns An empty object indicates that all is fine and the search can be triggered.
     *  An object with the property mandatory indicates that some mandatory filters or parameters are empty
     *
     *  An object with the property pending indicates that a token validation is going on.
     *  An object with the property error indicates that some filters, parameters or the BasicSearch are in
     * error state.
     */
    verifySearchAllowed(): SearchAllowed;
  }

  export type DateRangeTypeByKeyResponse = {
    defaultValue: string;

    type: string;

    group: string;
  };

  export type SearchAllowed = {
    /**
     * Mandatory - Indicates that some mandatory filters or parameters are empty
     */
    mandatory?: undefined | boolean;
    /**
     * Pending - Indicates that a token validation is going on
     */
    pending?: undefined | boolean;
    /**
     * Error - Indicates that some filters or parameters are in error state
     */
    error?: undefined | boolean;
  };

  /**
   * Describes the settings that can be provided to the SmartFilterBar constructor.
   */
  export interface $SmartFilterBarSettings extends $FilterBarSettings {
    /**
     * The OData entity type whose metadata is used to create the `SmartFilterBar`. **Note:** Changing this
     * value after the `SmartFilterBar` is initialized (`initialise` event was fired) has no effect.
     *
     * @deprecated As of version 1.40. Use `entitySet` property instead of this one, to enable V4 annotation
     * support
     */
    entityType?: string | PropertyBindingInfo;

    /**
     * The OData entity set whose metadata is used to create the `SmartFilterBar`. **Note:** Changing this value
     * after the `SmartFilterBar` is initialized (`initialise` event was fired) has no effect.
     */
    entitySet?: string | PropertyBindingInfo;

    /**
     * Optional. The OData service URL. If it is not specified, the service URL from the OData model (this.getModel())
     * will be used. **Note:** Changing this value after the SmartFilterBar is initialized (initialise event
     * was fired) has no effect.
     *
     * @deprecated As of version 1.29. Set an ODataModel as the main model on your control/view instead
     */
    resourceUri?: string | PropertyBindingInfo;

    /**
     * Name of the field that is the focus of the basic search.
     */
    basicSearchFieldName?: string | PropertyBindingInfo;

    /**
     * Enables the basic search field. The entered value can be accessed with {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getParameters}.
     * **Note:** When the `SmartFilterBar` control is used with a {@link sap.ui.comp.smarttable.SmartTable }
     * control the parameters are handled automatically. Therefore, this must only be enabled for OData service
     * entities that support basic search.
     * **Note:** basic search field is restricted to 1000 characters and spaces.
     */
    enableBasicSearch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set the search will be automatically triggered, when a filter value was set via the change
     * event.
     *  **Note:** The liveMode only operates on non-mobile scenarios.
     *  Additionally, if liveMode is set, the following applies:
     * 	 - The error messagebox is not displayed, and the `showMessages` property is ignored.
     * 	 - The search is triggered after a variant has been selected.
     * 	 - Execute on Select for `VariantManagement` is not shown and not taken into account
     *
     * @since 1.40
     */
    liveMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, any errors that occur during the search, are displayed in a message box in addition
     * to the `valueState` with the error. **Note:** As of version 1.89, the default value has been changed
     * from `true` to `false`.
     *
     * @since 1.40
     */
    showMessages?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the analytical parameters (SelectionVariant) must be taken into consideration.
     *
     * @since 1.42.0
     */
    considerAnalyticalParameters?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to `true` all date fields with filter restriction `interval` will be treated as `DateTimeRange`
     * filters. The `useDateRangeType` can be set only once during initialization. **Note:** If this property
     * is set to `true` and any date filters with filter restriction `interval` were stored as part of a variant,
     * the values of these filters cannot be applied. If this property is set to `false`, any previously stored
     * filters which were treated as type `DateTimeRange` based on the former setting, cannot be converted back
     * to the standard date interval.
     *
     * @since 1.46.0
     */
    useDateRangeType?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true` all search requests will be ignored. This functionality is only intended to be used
     * internally to enable an optimal solution when the filter bar is controlled by the smart templates. NOTE:
     * As long as this property is set to `true`, all search requests will be neglected.
     *
     * @since 1.44.0
     */
    suppressSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.SelectionVariant` is taken into account.
     *  **Note**: Only relevant for control level personalization.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     */
    considerSelectionVariants?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines one specific variant that is based on the `com.sap.vocabularies.UI.v1.SelectionVariant` annotation,
     * which is then used as the default variant.
     *  This property is only relevant in case `considerSelectionVariants` is set to `true` and will only be
     * applied if there is no user-defined default variant specified.
     *  **Note**: Only relevant for control level personalization.
     *
     * @deprecated As of version 1.87. Please use the `com.sap.vocabularies.UI.v1.SelectionPresentationVariant`
     * annotation through the {@link sap.ui.comp.smartvariants.SmartVariantManagement#setEntitySet}
     */
    defaultSelectionVariantName?: string | PropertyBindingInfo;

    /**
     * If set to `true`, only the navigation properties mentioned in property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getNavigationProperties }
     * are checked for further filters.
     *
     * @since 1.48
     */
    useProvidedNavigationProperties?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * This property is only evaluated if the property {@link sap.ui.comp.smartfilterbar.SmartFilterBar#getUseProvidedNavigationProperties }
     * is set to `true`. It contains a comma-separated list of `NavigationProperty`> names which are checked
     * for filters. It can also contain a list of separate filters from different `NavigationProperty` names.
     *
     *
     *
     * @since 1.48
     */
    navigationProperties?: string | PropertyBindingInfo;

    /**
     * Indicates if the annotation `com.sap.vocabularies.UI.v1.PresentationVariant` is taken into account.
     */
    considerPresentationVariant?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Using control configurations you can add additional configuration to filter fields, for example set custom
     * labels, change the order of fields, or change the filter field control type. **Note:** Changing the values
     * here after the SmartFilter is initialized (`initialise` event was fired) has no effect.
     */
    controlConfiguration?:
      | ControlConfiguration[]
      | ControlConfiguration
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Provides the possibility to add additional configuration to groups. Groups are used to show fields in
     * the advanced area of the SmartFilterBar. With additional configuration, you can for example set custom
     * labels or change the order of groups. **Note:** Changing the values here after the SmartFilter is initialized
     * (`initialise` event was fired) has no effect.
     */
    groupConfiguration?:
      | GroupConfiguration[]
      | GroupConfiguration
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Identifies the SmartVariant control which should be used for the personalization.
     *
     * @since 1.38
     */
    smartVariant?: SmartVariantManagement | string;

    /**
     * This event is fired after the pending state of the `FilterBar` control changes.
     *
     * @since 1.36
     */
    pendingChange?: (oEvent: SmartFilterBar$PendingChangeEvent) => void;
  }

  /**
   * Parameters of the SmartFilterBar#pendingChange event.
   */
  export interface SmartFilterBar$PendingChangeEventParameters {
    /**
     * The current pending value.
     */
    pendingValue?: boolean;
  }

  /**
   * Event object of the SmartFilterBar#pendingChange event.
   */
  export type SmartFilterBar$PendingChangeEvent = Event<
    SmartFilterBar$PendingChangeEventParameters,
    SmartFilterBar
  >;
}

declare module "sap/ui/comp/smartfilterbar/SmartFilterBarFilterGroupItem" {
  import {
    default as FilterGroupItem,
    $FilterGroupItemSettings,
  } from "sap/ui/comp/filterbar/FilterGroupItem";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Represents a filter belonging to a group other than basic.
   */
  export default class SmartFilterBarFilterGroupItem extends FilterGroupItem {
    /**
     * Constructor for a new FilterBar/FilterGroupItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.filterbar.FilterGroupItem#constructor sap.ui.comp.filterbar.FilterGroupItem }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFilterBarFilterGroupItemSettings
    );
    /**
     * Constructor for a new FilterBar/FilterGroupItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.filterbar.FilterGroupItem#constructor sap.ui.comp.filterbar.FilterGroupItem }
     * can be used.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFilterBarFilterGroupItemSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartfilterbar.SmartFilterBarFilterGroupItem with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.filterbar.FilterGroupItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartFilterBarFilterGroupItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartfilterbar.SmartFilterBarFilterGroupItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Returns instance of the control
     *
     * @deprecated As of version 1.99. Use {@link sap.ui.core.Core.byId} instead!
     *
     * @returns A control or `null` if there is no control with provided name
     */
    getControl(): Control | null;
    /**
     * @deprecated As of version 1.99. There is no replacement as all internal controls are considered private.
     */
    setControl(
      /**
       * associated with the filter.
       */
      oControl: Control
    ): void;
  }
  /**
   * Describes the settings that can be provided to the SmartFilterBarFilterGroupItem constructor.
   */
  export interface $SmartFilterBarFilterGroupItemSettings
    extends $FilterGroupItemSettings {}
}

declare module "sap/ui/comp/smartform/ColumnLayout" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { smartform } from "sap/ui/comp/library";

  import { form } from "sap/ui/layout/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * If this layout is used in a `SmartForm` control, a `ColumnLayout` control is used to render the `Form`
   * control.
   *
   * **Note:** If this layout is used, the `useHorizontalLayout` property of the `SmartForm` control must
   * not be set.
   *
   * @since 1.56.0
   */
  export default class ColumnLayout
    extends UI5Element
    implements smartform.SmartFormLayout
  {
    __implements__sap_ui_comp_smartform_SmartFormLayout: boolean;
    /**
     * Constructor for a new smartform/ColumnLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnLayoutSettings
    );
    /**
     * Constructor for a new smartform/ColumnLayout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.ColumnLayout with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.ColumnLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColumnsL columnsL}.
     *
     * Number of columns for large size.
     *
     * The number of columns for large size must not be smaller than the number of columns for medium size.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `columnsL`
     */
    getColumnsL(): form.ColumnsL;
    /**
     * Gets current value of property {@link #getColumnsM columnsM}.
     *
     * Number of columns for medium size.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `columnsM`
     */
    getColumnsM(): form.ColumnsM;
    /**
     * Gets current value of property {@link #getColumnsXL columnsXL}.
     *
     * Number of columns for extra-large size.
     *
     * The number of columns for extra-large size must not be smaller than the number of columns for large size.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `columnsXL`
     */
    getColumnsXL(): form.ColumnsXL;
    /**
     * Gets current value of property {@link #getEmptyCellsLarge emptyCellsLarge}.
     *
     * Defines how many cells are empty at the end of a row. This could be used to keep the fields small on
     * large screens.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `emptyCellsLarge`
     */
    getEmptyCellsLarge(): form.EmptyCells;
    /**
     * Gets current value of property {@link #getLabelCellsLarge labelCellsLarge}.
     *
     * Defines how many cells a label uses if the column is large.
     *
     * Default value is `4`.
     *
     *
     * @returns Value of property `labelCellsLarge`
     */
    getLabelCellsLarge(): form.ColumnCells;
    /**
     * Sets a new value for property {@link #getColumnsL columnsL}.
     *
     * Number of columns for large size.
     *
     * The number of columns for large size must not be smaller than the number of columns for medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsL(
      /**
       * New value for property `columnsL`
       */
      sColumnsL?: form.ColumnsL
    ): this;
    /**
     * Sets a new value for property {@link #getColumnsM columnsM}.
     *
     * Number of columns for medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsM(
      /**
       * New value for property `columnsM`
       */
      sColumnsM?: form.ColumnsM
    ): this;
    /**
     * Sets a new value for property {@link #getColumnsXL columnsXL}.
     *
     * Number of columns for extra-large size.
     *
     * The number of columns for extra-large size must not be smaller than the number of columns for large size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsXL(
      /**
       * New value for property `columnsXL`
       */
      sColumnsXL?: form.ColumnsXL
    ): this;
    /**
     * Sets a new value for property {@link #getEmptyCellsLarge emptyCellsLarge}.
     *
     * Defines how many cells are empty at the end of a row. This could be used to keep the fields small on
     * large screens.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptyCellsLarge(
      /**
       * New value for property `emptyCellsLarge`
       */
      sEmptyCellsLarge?: form.EmptyCells
    ): this;
    /**
     * Sets a new value for property {@link #getLabelCellsLarge labelCellsLarge}.
     *
     * Defines how many cells a label uses if the column is large.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `4`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelCellsLarge(
      /**
       * New value for property `labelCellsLarge`
       */
      sLabelCellsLarge?: form.ColumnCells
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnLayout constructor.
   */
  export interface $ColumnLayoutSettings extends $ElementSettings {
    /**
     * Number of columns for extra-large size.
     *
     * The number of columns for extra-large size must not be smaller than the number of columns for large size.
     */
    columnsXL?: form.ColumnsXL | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns for large size.
     *
     * The number of columns for large size must not be smaller than the number of columns for medium size.
     */
    columnsL?: form.ColumnsL | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns for medium size.
     */
    columnsM?: form.ColumnsM | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how many cells a label uses if the column is large.
     */
    labelCellsLarge?: form.ColumnCells | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how many cells are empty at the end of a row. This could be used to keep the fields small on
     * large screens.
     */
    emptyCellsLarge?: form.EmptyCells | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartform/Group" {
  import {
    default as FormContainer,
    $FormContainerSettings,
  } from "sap/ui/layout/form/FormContainer";

  import CustomData from "sap/ui/core/CustomData";

  import { IFormGroupElement } from "sap/ui/comp/library";

  import GridData from "sap/ui/layout/GridData";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Title from "sap/ui/core/Title";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Groups are used to group group elements.
   */
  export default class Group extends FormContainer {
    /**
     * Constructor for a new smartform/Group.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupSettings
    );
    /**
     * Constructor for a new smartform/Group.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.Group with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.layout.form.FormContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Group>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.Group.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some CustomData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `GroupElement`
     * elements and the `SmartField` controls in the children hierarchy. Additional `customData` that is not
     * used by the `SmartField` control internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    addCustomData(
      /**
       * the customData to add; if empty, nothing is added
       */
      oCustomData: CustomData
    ): this;
    /**
     * Adds some groupElement to the aggregation {@link #getGroupElements groupElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGroupElement(
      /**
       * The groupElement to add; if empty, nothing is inserted
       */
      oGroupElement: IFormGroupElement
    ): this;
    /**
     * Destroys all the groupElements in the aggregation {@link #getGroupElements groupElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGroupElements(): this;
    /**
     * Destroys the layout in the aggregation {@link #getLayout layout}.
     *
     * @deprecated As of version 1.48.0. please use `layoutData` aggregation instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLayout(): this;
    /**
     * Destroys the title in the aggregation `title`.
     *
     *
     * @returns `this` to allow method chaining
     */
    destroyTitle(): this;
    /**
     * Gets content of aggregation {@link #getGroupElements groupElements}.
     *
     * A `GroupElement` is a combination of one label and different controls associated to this label.
     */
    getGroupElements(): IFormGroupElement[];
    /**
     * Gets current value of property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Value of property `horizontalLayoutGroupElementMinWidth`
     */
    getHorizontalLayoutGroupElementMinWidth(): int;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Label for the group.
     *
     * @deprecated As of version 1.88. replaced by `title` aggregation.
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets content of aggregation {@link #getLayout layout}.
     *
     * Layout to specify how the group shall be rendered (e.g. span and line-break)
     *
     * **Note:** Do not use `layout` and `layoutData` aggregations combined.
     *
     * @deprecated As of version 1.48.0. please use `layoutData` aggregation instead.
     */
    getLayout(): GridData;
    /**
     * Gets content of aggregation `title`.
     *
     * Can either be a `Title` element or a string.
     *
     *
     * @returns Title
     */
    getTitle(): Title | string;
    /**
     * Gets current value of property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups are rendered in a `ResponsiveLayout` with label on top of the group element.
     * Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `Group` element.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     *
     * @returns Value of property `useHorizontalLayout`
     */
    getUseHorizontalLayout(): boolean;
    /**
     * Checks for the provided `sap.ui.comp.IFormGroupElement` in the aggregation {@link #getGroupElements groupElements}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGroupElement(
      /**
       * The groupElement whose index is looked for
       */
      oGroupElement: IFormGroupElement
    ): int;
    /**
     * Inserts some customData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `GroupElement`
     * elements and the `SmartField` controls in the children hierarchy. Additional `customData` that is not
     * used by the `SmartField` control internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    insertCustomData(
      /**
       * the customData to insert; if empty, nothing is inserted
       */
      oCustomData: CustomData,
      /**
       * the 0-based index the customData should be inserted at; for a negative value of iIndex, the customData
       * is inserted at position 0; for a value greater than the current size of the aggregation, the customData
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a groupElement into the aggregation {@link #getGroupElements groupElements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGroupElement(
      /**
       * The groupElement to insert; if empty, nothing is inserted
       */
      oGroupElement: IFormGroupElement,
      /**
       * The `0`-based index the groupElement should be inserted at; for a negative value of `iIndex`, the groupElement
       * is inserted at position 0; for a value greater than the current size of the aggregation, the groupElement
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getGroupElements groupElements}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGroupElements(): IFormGroupElement[];
    /**
     * Removes a groupElement from the aggregation {@link #getGroupElements groupElements}.
     *
     *
     * @returns The removed groupElement or `null`
     */
    removeGroupElement(
      /**
       * The groupElement to remove or its index or id
       */
      vGroupElement: int | string | IFormGroupElement
    ): IFormGroupElement | null;
    /**
     * Setter for property `editable` of all smart fields in children hierarchy.
     *
     * @deprecated As of version 1.74.0. please do not change the edit mode on group level, let the SmartForm
     * inheritance do it
     *
     * @returns `this` to allow method chaining.
     */
    setEditMode(
      /**
       * new value for editable property of smart fields.
       */
      bEditMode: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalLayoutGroupElementMinWidth(
      /**
       * New value for property `horizontalLayoutGroupElementMinWidth`
       */
      iHorizontalLayoutGroupElementMinWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * Label for the group.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.88. replaced by `title` aggregation.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets the aggregated {@link #getLayout layout}.
     *
     * @deprecated As of version 1.48.0. please use `layoutData` aggregation instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayout(
      /**
       * The layout to set
       */
      oLayout: GridData
    ): this;
    /**
     * Sets the aggregated `title`.
     *
     * Can either be a `Title` element or a string. If a `Title` element is used, the style of the title can
     * be set.
     *
     * **Note:** If the title is provided as a string, the title is rendered with a theme-dependent default
     * level. As the `SmartForm` control cannot know the structure of the page, this might not fit the page
     * structure. In this case provide the title using a `Title` element and set its {@link sap.ui.core.Title#setLevel level }
     * to the required value.
     *
     *
     * @returns `this` to allow method chaining
     */
    setTitle(
      /**
       * The title to set
       */
      vTitle: Title | string
    ): this;
    /**
     * Sets a new value for property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups are rendered in a `ResponsiveLayout` with label on top of the group element.
     * Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `Group` element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseHorizontalLayout(
      /**
       * New value for property `useHorizontalLayout`
       */
      bUseHorizontalLayout?: boolean
    ): this;
    /**
     * Sets a new value for property `visible`. If set to `false`, the `Group` is not rendered. Default value
     * is true.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Group constructor.
   */
  export interface $GroupSettings extends $FormContainerSettings {
    /**
     * Specifies whether the groups are rendered in a `ResponsiveLayout` with label on top of the group element.
     * Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `Group` element.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     */
    useHorizontalLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     */
    horizontalLayoutGroupElementMinWidth?:
      | int
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Label for the group.
     *
     * @deprecated As of version 1.88. replaced by `title` aggregation.
     */
    label?: string | PropertyBindingInfo;

    /**
     * A `GroupElement` is a combination of one label and different controls associated to this label.
     */
    groupElements?:
      | IFormGroupElement[]
      | IFormGroupElement
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Layout to specify how the group shall be rendered (e.g. span and line-break)
     *
     * **Note:** Do not use `layout` and `layoutData` aggregations combined.
     *
     * @deprecated As of version 1.48.0. please use `layoutData` aggregation instead.
     */
    layout?: GridData;
  }
}

declare module "sap/ui/comp/smartform/GroupElement" {
  import {
    default as FormElement,
    $FormElementSettings,
  } from "sap/ui/layout/form/FormElement";

  import { IFormGroupElement } from "sap/ui/comp/library";

  import CustomData from "sap/ui/core/CustomData";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * A GroupElement is a combination of one label and different controls associated to this label.
   */
  export default class GroupElement
    extends FormElement
    implements IFormGroupElement
  {
    __implements__sap_ui_comp_IFormGroupElement: boolean;
    /**
     * Constructor for a new smartform/GroupElement.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupElementSettings
    );
    /**
     * Constructor for a new smartform/GroupElement.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupElementSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.GroupElement with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.layout.form.FormElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GroupElement>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.GroupElement.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some customData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `SmartField`
     * controls in the children hierarchy. Additional `customData` that is not used by the `SmartField` control
     * internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    addCustomData(
      /**
       * the customData to add; if empty, nothing is added
       */
      oCustomData: CustomData
    ): this;
    /**
     * Adds some element to the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addElement(
      /**
       * The element to add; if empty, nothing is inserted
       */
      oElement: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.GroupElement`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.GroupElement` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.GroupElement`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.GroupElement`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.GroupElement` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.GroupElement`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the elements in the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyElements(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.GroupElement`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachVisibleChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:visibleChanged visibleChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireVisibleChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getElementForLabel elementForLabel}.
     *
     * Index of element to be used for label determination
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `elementForLabel`
     */
    getElementForLabel(): int;
    /**
     * Gets content of aggregation {@link #getElements elements}.
     *
     * Aggregation of controls to be displayed together with a label.
     *
     * **Warning:** Do not put any layout or other container controls in here. This could damage the visual
     * layout, keyboard support and screen-reader support. Only form controls are allowed. Views are also not
     * supported. Allowed controls implement the interface `sap.ui.core.IFormContent`.
     */
    getElements(): Control[];
    /**
     * Returns the from element.
     *
     *
     * @returns the form element.
     */
    getFormElement(): FormElement;
    /**
     * Gets current value of property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Value of property `horizontalLayoutGroupElementMinWidth`
     */
    getHorizontalLayoutGroupElementMinWidth(): int;
    /**
     * Returns the text of the label.
     *
     *
     * @returns text of the label.
     */
    getLabelText(): string;
    /**
     * Gets current value of property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups shall be rendered in a `ResponsiveLayout` with label on top of the group
     * element. Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `GroupElement` element.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     *
     * @returns Value of property `useHorizontalLayout`
     */
    getUseHorizontalLayout(): boolean;
    /**
     * Determines the visibility of a `GroupElement` based on elements
     *
     *
     * @returns Returns true, in case one element of the group element is visible
     */
    getVisibleBasedOnElements(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getElements elements}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfElement(
      /**
       * The element whose index is looked for
       */
      oElement: Control
    ): int;
    /**
     * Inserts some customData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `SmartField`
     * controls in the children hierarchy. Additional `customData` that is not used by the `SmartField` control
     * internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    insertCustomData(
      /**
       * the customData to insert; if empty, nothing is inserted
       */
      oCustomData: CustomData,
      /**
       * the 0-based index the customData should be inserted at; for a negative value of iIndex, the customData
       * is inserted at position 0; for a value greater than the current size of the aggregation, the customData
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a element into the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertElement(
      /**
       * The element to insert; if empty, nothing is inserted
       */
      oElement: Control,
      /**
       * The `0`-based index the element should be inserted at; for a negative value of `iIndex`, the element
       * is inserted at position 0; for a value greater than the current size of the aggregation, the element
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getElements elements}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllElements(): Control[];
    /**
     * Removes a element from the aggregation {@link #getElements elements}.
     *
     *
     * @returns The removed element or `null`
     */
    removeElement(
      /**
       * The element to remove or its index or id
       */
      vElement: int | string | Control
    ): Control | null;
    /**
     * Setter for property editable of all smart fields in children hierarchy.
     *
     * @deprecated As of version 1.74.0. please do not change the edit mode on groupElement level, let the SmartForm
     * inheritance do it
     *
     * @returns `this` to allow method chaining.
     */
    setEditMode(
      /**
       * new value for editable property of smart fields.
       */
      bEditMode: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getElementForLabel elementForLabel}.
     *
     * Index of element to be used for label determination
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setElementForLabel(
      /**
       * New value for property `elementForLabel`
       */
      iElementForLabel?: int
    ): this;
    /**
     * Sets a new value for property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalLayoutGroupElementMinWidth(
      /**
       * New value for property `horizontalLayoutGroupElementMinWidth`
       */
      iHorizontalLayoutGroupElementMinWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups shall be rendered in a `ResponsiveLayout` with label on top of the group
     * element. Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `GroupElement` element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseHorizontalLayout(
      /**
       * New value for property `useHorizontalLayout`
       */
      bUseHorizontalLayout?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GroupElement constructor.
   */
  export interface $GroupElementSettings extends $FormElementSettings {
    /**
     * Specifies whether the groups shall be rendered in a `ResponsiveLayout` with label on top of the group
     * element. Each group will be rendered in a new line.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control.
     *
     * So don't set it to a different value from the one in the `SmartForm` control. For performance reasons
     * it might make sense to set it manually to the same value as the one in the `SmartForm` control when creating
     * the `GroupElement` element.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation of the `SmartForm` control.
     */
    useHorizontalLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the minimal size in pixels of all group elements of the form if horizontal Layout is used.
     *
     * **Note:** If `Group` is assigned to a `SmartForm` control, this property is inherited from the `SmartForm`
     * control. So don't set it manually.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     */
    horizontalLayoutGroupElementMinWidth?:
      | int
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Index of element to be used for label determination
     */
    elementForLabel?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation of controls to be displayed together with a label.
     *
     * **Warning:** Do not put any layout or other container controls in here. This could damage the visual
     * layout, keyboard support and screen-reader support. Only form controls are allowed. Views are also not
     * supported. Allowed controls implement the interface `sap.ui.core.IFormContent`.
     */
    elements?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is fired after the visibility of the control has changed.
     */
    visibleChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the GroupElement#visibleChanged event.
   */
  export interface GroupElement$VisibleChangedEventParameters {}

  /**
   * Event object of the GroupElement#visibleChanged event.
   */
  export type GroupElement$VisibleChangedEvent = Event<
    GroupElement$VisibleChangedEventParameters,
    GroupElement
  >;
}

declare module "sap/ui/comp/smartform/Layout" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { smartform } from "sap/ui/comp/library";

  import { GridSpan } from "sap/ui/layout/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Layout settings to adjust the `ResponsiveGridLayout` used inside the `Form`.
   */
  export default class Layout
    extends UI5Element
    implements smartform.SmartFormLayout
  {
    __implements__sap_ui_comp_smartform_SmartFormLayout: boolean;
    /**
     * Constructor for a new smartform/Layout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LayoutSettings
    );
    /**
     * Constructor for a new smartform/Layout.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LayoutSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.Layout with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Layout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.Layout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBreakpointL breakpointL}.
     *
     * Breakpoint (in pixel) between Medium size and Large size.
     *
     *
     * @returns Value of property `breakpointL`
     */
    getBreakpointL(): int;
    /**
     * Gets current value of property {@link #getBreakpointM breakpointM}.
     *
     * reakpoint (in pixel) between Small size and Medium size.
     *
     *
     * @returns Value of property `breakpointM`
     */
    getBreakpointM(): int;
    /**
     * Gets current value of property {@link #getBreakpointXL breakpointXL}.
     *
     * Breakpoint (in pixel) between large size and extra large (XL) size.
     *
     * @since 1.38.0
     *
     * @returns Value of property `breakpointXL`
     */
    getBreakpointXL(): int;
    /**
     * Gets current value of property {@link #getColumnsL columnsL}.
     *
     * Number of columns for large size.
     *  The number of columns for large size must not be smaller than the number of columns for medium size.
     *
     *
     * @returns Value of property `columnsL`
     */
    getColumnsL(): int;
    /**
     * Gets current value of property {@link #getColumnsM columnsM}.
     *
     * Number of columns for medium size.
     *
     *
     * @returns Value of property `columnsM`
     */
    getColumnsM(): int;
    /**
     * Gets current value of property {@link #getColumnsXL columnsXL}.
     *
     * Number of columns for extra large size.
     *  The number of columns for extra large size must not be smaller than the number of columns for large
     * size.
     *
     * @since 1.38.0
     *
     * @returns Value of property `columnsXL`
     */
    getColumnsXL(): int;
    /**
     * Gets current value of property {@link #getEmptySpanL emptySpanL}.
     *
     * Number of grid cells that are empty at the end of each line on large size.
     *
     *
     * @returns Value of property `emptySpanL`
     */
    getEmptySpanL(): int;
    /**
     * Gets current value of property {@link #getEmptySpanM emptySpanM}.
     *
     * Number of grid cells that are empty at the end of each line on medium size.
     *
     *
     * @returns Value of property `emptySpanM`
     */
    getEmptySpanM(): int;
    /**
     * Gets current value of property {@link #getEmptySpanS emptySpanS}.
     *
     * Number of grid cells that are empty at the end of each line on small size.
     *
     *
     * @returns Value of property `emptySpanS`
     */
    getEmptySpanS(): int;
    /**
     * Gets current value of property {@link #getEmptySpanXL emptySpanXL}.
     *
     * Number of grid cells that are empty at the end of each line on extra large size.
     *
     * @since 1.38.0
     *
     * @returns Value of property `emptySpanXL`
     */
    getEmptySpanXL(): int;
    /**
     * Gets current value of property {@link #getGridDataSpan gridDataSpan}.
     *
     * A string type that represents Grid's span values for large, medium and small screens. Allowed values
     * are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container
     * has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided
     * in the order large medium small.
     *  The value set here will be set to all group elements when used with horizontal layout (`SmartForm` property
     * `useHorizontalLayout`)
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `gridDataSpan`
     */
    getGridDataSpan(): GridSpan;
    /**
     * Gets current value of property {@link #getLabelSpanL labelSpanL}.
     *
     * Default span for labels in large size. This span is only used if more than 1 container is in one line,
     * if only 1 container is in the line the `labelSpanM` value is used.
     *
     *
     * @returns Value of property `labelSpanL`
     */
    getLabelSpanL(): int;
    /**
     * Gets current value of property {@link #getLabelSpanM labelSpanM}.
     *
     * Default span for labels in medium size. This property is used for full size containers. If more than
     * one Container is in one line, `labelSpanL` is used.
     *
     *
     * @returns Value of property `labelSpanM`
     */
    getLabelSpanM(): int;
    /**
     * Gets current value of property {@link #getLabelSpanS labelSpanS}.
     *
     * Default span for labels in small size.
     *
     *
     * @returns Value of property `labelSpanS`
     */
    getLabelSpanS(): int;
    /**
     * Gets current value of property {@link #getLabelSpanXL labelSpanXL}.
     *
     * Default span for labels in extra large size.
     *
     * @since 1.38.0
     *
     * @returns Value of property `labelSpanXL`
     */
    getLabelSpanXL(): int;
    /**
     * Gets current value of property {@link #getSingleGroupFullSize singleGroupFullSize}.
     *
     * If the `SmartForm` contains only one single Group and this property is set, the Group is displayed using
     * the full size of the `SmartForm`. In this case the properties `columnsL` and `columnsM` are ignored.
     *  In all other cases the Group is displayed in the size of one column.
     *
     * Default value is `true`.
     *
     * @since 1.34.1
     *
     * @returns Value of property `singleGroupFullSize`
     */
    getSingleGroupFullSize(): boolean;
    /**
     * Sets a new value for property {@link #getBreakpointL breakpointL}.
     *
     * Breakpoint (in pixel) between Medium size and Large size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBreakpointL(
      /**
       * New value for property `breakpointL`
       */
      iBreakpointL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getBreakpointM breakpointM}.
     *
     * reakpoint (in pixel) between Small size and Medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBreakpointM(
      /**
       * New value for property `breakpointM`
       */
      iBreakpointM?: int
    ): this;
    /**
     * Sets a new value for property {@link #getBreakpointXL breakpointXL}.
     *
     * Breakpoint (in pixel) between large size and extra large (XL) size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBreakpointXL(
      /**
       * New value for property `breakpointXL`
       */
      iBreakpointXL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getColumnsL columnsL}.
     *
     * Number of columns for large size.
     *  The number of columns for large size must not be smaller than the number of columns for medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsL(
      /**
       * New value for property `columnsL`
       */
      iColumnsL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getColumnsM columnsM}.
     *
     * Number of columns for medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsM(
      /**
       * New value for property `columnsM`
       */
      iColumnsM?: int
    ): this;
    /**
     * Sets a new value for property {@link #getColumnsXL columnsXL}.
     *
     * Number of columns for extra large size.
     *  The number of columns for extra large size must not be smaller than the number of columns for large
     * size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnsXL(
      /**
       * New value for property `columnsXL`
       */
      iColumnsXL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEmptySpanL emptySpanL}.
     *
     * Number of grid cells that are empty at the end of each line on large size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptySpanL(
      /**
       * New value for property `emptySpanL`
       */
      iEmptySpanL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEmptySpanM emptySpanM}.
     *
     * Number of grid cells that are empty at the end of each line on medium size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptySpanM(
      /**
       * New value for property `emptySpanM`
       */
      iEmptySpanM?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEmptySpanS emptySpanS}.
     *
     * Number of grid cells that are empty at the end of each line on small size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptySpanS(
      /**
       * New value for property `emptySpanS`
       */
      iEmptySpanS?: int
    ): this;
    /**
     * Sets a new value for property {@link #getEmptySpanXL emptySpanXL}.
     *
     * Number of grid cells that are empty at the end of each line on extra large size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptySpanXL(
      /**
       * New value for property `emptySpanXL`
       */
      iEmptySpanXL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getGridDataSpan gridDataSpan}.
     *
     * A string type that represents Grid's span values for large, medium and small screens. Allowed values
     * are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container
     * has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided
     * in the order large medium small.
     *  The value set here will be set to all group elements when used with horizontal layout (`SmartForm` property
     * `useHorizontalLayout`)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGridDataSpan(
      /**
       * New value for property `gridDataSpan`
       */
      sGridDataSpan?: GridSpan
    ): this;
    /**
     * Sets a new value for property {@link #getLabelSpanL labelSpanL}.
     *
     * Default span for labels in large size. This span is only used if more than 1 container is in one line,
     * if only 1 container is in the line the `labelSpanM` value is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelSpanL(
      /**
       * New value for property `labelSpanL`
       */
      iLabelSpanL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLabelSpanM labelSpanM}.
     *
     * Default span for labels in medium size. This property is used for full size containers. If more than
     * one Container is in one line, `labelSpanL` is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelSpanM(
      /**
       * New value for property `labelSpanM`
       */
      iLabelSpanM?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLabelSpanS labelSpanS}.
     *
     * Default span for labels in small size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelSpanS(
      /**
       * New value for property `labelSpanS`
       */
      iLabelSpanS?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLabelSpanXL labelSpanXL}.
     *
     * Default span for labels in extra large size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.38.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelSpanXL(
      /**
       * New value for property `labelSpanXL`
       */
      iLabelSpanXL?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSingleGroupFullSize singleGroupFullSize}.
     *
     * If the `SmartForm` contains only one single Group and this property is set, the Group is displayed using
     * the full size of the `SmartForm`. In this case the properties `columnsL` and `columnsM` are ignored.
     *  In all other cases the Group is displayed in the size of one column.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.34.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSingleGroupFullSize(
      /**
       * New value for property `singleGroupFullSize`
       */
      bSingleGroupFullSize?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Layout constructor.
   */
  export interface $LayoutSettings extends $ElementSettings {
    /**
     * Default span for labels in extra large size.
     *
     * @since 1.38.0
     */
    labelSpanXL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Default span for labels in large size. This span is only used if more than 1 container is in one line,
     * if only 1 container is in the line the `labelSpanM` value is used.
     */
    labelSpanL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Default span for labels in medium size. This property is used for full size containers. If more than
     * one Container is in one line, `labelSpanL` is used.
     */
    labelSpanM?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Default span for labels in small size.
     */
    labelSpanS?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of grid cells that are empty at the end of each line on extra large size.
     *
     * @since 1.38.0
     */
    emptySpanXL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of grid cells that are empty at the end of each line on large size.
     */
    emptySpanL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of grid cells that are empty at the end of each line on medium size.
     */
    emptySpanM?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of grid cells that are empty at the end of each line on small size.
     */
    emptySpanS?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns for extra large size.
     *  The number of columns for extra large size must not be smaller than the number of columns for large
     * size.
     *
     * @since 1.38.0
     */
    columnsXL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns for large size.
     *  The number of columns for large size must not be smaller than the number of columns for medium size.
     */
    columnsL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of columns for medium size.
     */
    columnsM?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * If the `SmartForm` contains only one single Group and this property is set, the Group is displayed using
     * the full size of the `SmartForm`. In this case the properties `columnsL` and `columnsM` are ignored.
     *  In all other cases the Group is displayed in the size of one column.
     *
     * @since 1.34.1
     */
    singleGroupFullSize?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Breakpoint (in pixel) between large size and extra large (XL) size.
     *
     * @since 1.38.0
     */
    breakpointXL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Breakpoint (in pixel) between Medium size and Large size.
     */
    breakpointL?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * reakpoint (in pixel) between Small size and Medium size.
     */
    breakpointM?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * A string type that represents Grid's span values for large, medium and small screens. Allowed values
     * are separated by space Letters L, M or S followed by number of columns from 1 to 12 that the container
     * has to take, for example: "L2 M4 S6", "M12", "s10" or "l4 m4". Note that the parameters has to be provided
     * in the order large medium small.
     *  The value set here will be set to all group elements when used with horizontal layout (`SmartForm` property
     * `useHorizontalLayout`)
     */
    gridDataSpan?: GridSpan | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartform/SemanticGroupElement" {
  import {
    default as SemanticFormElement,
    $SemanticFormElementSettings,
  } from "sap/ui/layout/form/SemanticFormElement";

  import { IFormGroupElement } from "sap/ui/comp/library";

  import CustomData from "sap/ui/core/CustomData";

  import Control from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * SemanticGroupElement holds the semantically connected fields divided by a delimiter. **Note:** Semantically
   * connected fields don't support the text arrangement async control functionality.
   *
   * @since 1.88
   */
  export default class SemanticGroupElement
    extends SemanticFormElement
    implements IFormGroupElement
  {
    __implements__sap_ui_comp_IFormGroupElement: boolean;
    /**
     * Constructor for a new smartform/SemanticGroupElement.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SemanticGroupElementSettings
    );
    /**
     * Constructor for a new smartform/SemanticGroupElement.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SemanticGroupElementSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.SemanticGroupElement with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.layout.form.SemanticFormElement.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SemanticGroupElement>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.SemanticGroupElement.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some custom data into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `SmartField`
     * controls in the children hierarchy. Additional `customData` that is not used by the `SmartField` control
     * internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    addCustomData(
      /**
       * the customData to add; if empty, nothing is added
       */
      oCustomData: CustomData
    ): this;
    /**
     * Adds some element to the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addElement(
      /**
       * The element to add; if empty, nothing is inserted
       */
      oElement: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.SemanticGroupElement`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SemanticGroupElement` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SemanticGroupElement`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.SemanticGroupElement`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SemanticGroupElement` itself.
     *
     * The event is fired after the visibility of the control has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVisibleChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SemanticGroupElement`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the elements in the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyElements(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:visibleChanged visibleChanged} event of this
     * `sap.ui.comp.smartform.SemanticGroupElement`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachVisibleChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:visibleChanged visibleChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireVisibleChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getElementForLabel elementForLabel}.
     *
     * Index of element to be used for label determination
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `elementForLabel`
     */
    getElementForLabel(): int;
    /**
     * Gets content of aggregation {@link #getElements elements}.
     *
     * Aggregation of controls to be displayed together with a label and separated by delimiter.
     *
     * **Warning:** Do not put any layout or other container controls in here. This could damage the visual
     * layout, keyboard support and screen-reader support. Views are also not supported. Only form controls
     * are allowed. Allowed controls implement the interface `sap.ui.core.IFormContent`.
     */
    getElements(): Control[];
    /**
     * Returns the semantic form element.
     */
    getFormElement(): SemanticFormElement;
    /**
     * Returns the text of the label.
     *
     *
     * @returns The text of the label.
     */
    getLabelText(): string;
    /**
     * Determines the visibility of a `SemanticGroupElement` based on the inner elements
     *
     *
     * @returns Returns true in case one element of the group elements is visible
     */
    getVisibleBasedOnElements(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getElements elements}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfElement(
      /**
       * The element whose index is looked for
       */
      oElement: Control
    ): int;
    /**
     * Inserts some custom data into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `SmartField`
     * controls in the children hierarchy. Additional `customData` that is not used by the `SmartField` control
     * internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    insertCustomData(
      /**
       * the custom data to insert; if empty, nothing is inserted
       */
      oCustomData: CustomData,
      /**
       * the 0-based index the custom data should be inserted at; for a negative value of iIndex, the custom data
       * is inserted at position 0; for a value greater than the current size of the aggregation, the custom data
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a element into the aggregation {@link #getElements elements}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertElement(
      /**
       * The element to insert; if empty, nothing is inserted
       */
      oElement: Control,
      /**
       * The `0`-based index the element should be inserted at; for a negative value of `iIndex`, the element
       * is inserted at position 0; for a value greater than the current size of the aggregation, the element
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getElements elements}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllElements(): Control[];
    /**
     * Removes a element from the aggregation {@link #getElements elements}.
     *
     *
     * @returns The removed element or `null`
     */
    removeElement(
      /**
       * The element to remove or its index or id
       */
      vElement: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getElementForLabel elementForLabel}.
     *
     * Index of element to be used for label determination
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setElementForLabel(
      /**
       * New value for property `elementForLabel`
       */
      iElementForLabel?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SemanticGroupElement constructor.
   */
  export interface $SemanticGroupElementSettings
    extends $SemanticFormElementSettings {
    /**
     * Index of element to be used for label determination
     */
    elementForLabel?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation of controls to be displayed together with a label and separated by delimiter.
     *
     * **Warning:** Do not put any layout or other container controls in here. This could damage the visual
     * layout, keyboard support and screen-reader support. Views are also not supported. Only form controls
     * are allowed. Allowed controls implement the interface `sap.ui.core.IFormContent`.
     */
    elements?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * The event is fired after the visibility of the control has changed.
     */
    visibleChanged?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SemanticGroupElement#visibleChanged event.
   */
  export interface SemanticGroupElement$VisibleChangedEventParameters {}

  /**
   * Event object of the SemanticGroupElement#visibleChanged event.
   */
  export type SemanticGroupElement$VisibleChangedEvent = Event<
    SemanticGroupElement$VisibleChangedEventParameters,
    SemanticGroupElement
  >;
}

declare module "sap/ui/comp/smartform/SmartForm" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import CustomData from "sap/ui/core/CustomData";

  import Group from "sap/ui/comp/smartform/Group";

  import Toolbar from "sap/m/Toolbar";

  import { smartform } from "sap/ui/comp/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SemanticObjectController from "sap/ui/comp/navpopover/SemanticObjectController";

  import SmartField from "sap/ui/comp/smartfield/SmartField";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The `SmartForm` control renders a form (`sap.ui.layout.form.Form`). When used with the `SmartField` control
   * the label is taken from the metadata annotation `sap:label` if not specified directly.
   *
   * **Warning:** Do not put any layout or other container controls into the `GroupElement`. Views are also
   * not supported. This could damage the visual layout, keyboard support and screen-reader support.
   */
  export default class SmartForm extends Control {
    /**
     * Constructor for a new smartform/SmartForm.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/99e33bdfde074bb48d2e603fa5ecd2d0 Smart Form}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFormSettings
    );
    /**
     * Constructor for a new smartform/SmartForm.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/99e33bdfde074bb48d2e603fa5ecd2d0 Smart Form}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SmartFormSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartform.SmartForm with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartForm>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartform.SmartForm.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.56.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some customData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `Group` elements,
     * `GroupElement` elements and the `SmartField` controls in the children hierarchy. Additional `customData`
     * that is not used by the `SmartField` control internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    addCustomData(
      /**
       * the customData to add; if empty, nothing is added
       */
      oCustomData: CustomData
    ): this;
    /**
     * Adds some group to the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGroup(
      /**
       * The group to add; if empty, nothing is inserted
       */
      oGroup: Group
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:checked checked} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SmartForm` itself.
     *
     * This event is fired after check was performed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChecked(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartForm$CheckedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SmartForm` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:checked checked} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SmartForm` itself.
     *
     * This event is fired after check was performed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChecked(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartForm$CheckedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SmartForm` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:editToggled editToggled} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SmartForm` itself.
     *
     * This event is fired when the editable property is toggled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEditToggled(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartForm$EditToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SmartForm` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:editToggled editToggled} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartform.SmartForm` itself.
     *
     * This event is fired when the editable property is toggled.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachEditToggled(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: SmartForm$EditToggledEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartform.SmartForm` itself
       */
      oListener?: object
    ): this;
    /**
     * Checks smart fields for client errors.
     *
     * This method is typically used to check whether the value of every text input field in edit mode is subject
     * to data type constraints and whether the constraints are fulfilled.
     *
     * A data type constraint for a bound Entity Data Model (EDM) property can be violated in many ways, for
     * example:
     *
     *
     * 	 - The `Nullable` constraint for an EDM property typed as `Edm.String` is violated.
     * 	 - A user input is invalid for the bound EDM property typed as `Edm.DateTime`.
     *
     * If this happens, the following applies:
     *
     *
     * 	 - A validation error state is set on the text input field.
     * 	 - A validation error message is displayed for the text input field.
     * 	 - The validation error message (possibly generated by a user input) is added to a `sap.ui.core.message.MessageManager`
     *     object instance if, for example, a view object instance is registered to it.
     * 	 - The text input field fires a {@link sap.ui.base.EventProvider#event:validationError}, or {@link sap.ui.base.EventProvider#event:parseError }
     *     event.
     *
     *
     * @returns An array of fields with errors or a promise depending on the `validationMode` property setting.
     * If the `validationMode` is asynchronous the returned promise will resolve with an array containing IDs
     * of all the fields with errors.
     */
    check(
      /**
       * Settings object or a boolean which determines if only visible fields in visible groups should be considered
       */
      vSettings?:
        | boolean
        | {
            /**
             * Determines if only visible fields in visible groups should be considered
             */
            considerOnlyVisible?: boolean;
            /**
             * Indicates whether client error checks are performed for the current value regardless of the current error
             * state of the text input fields of the `SmartForm` control. If the `handleSuccess` setting is set to `true`,
             * the {@link sap.ui.base.EventProvider#event:validationSuccess} will be fired by every of the text input
             * fields if their validation passes
             */
            handleSuccess?: boolean;
          }
    ): string[] | Promise<Object[]>;
    /**
     * Destroys the customToolbar in the aggregation {@link #getCustomToolbar customToolbar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomToolbar(): this;
    /**
     * Destroys all the groups in the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGroups(): this;
    /**
     * Destroys the layout in the aggregation {@link #getLayout layout}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLayout(): this;
    /**
     * Destroys the semanticObjectController in the aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySemanticObjectController(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:checked checked} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChecked(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartForm$CheckedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:editToggled editToggled} event of this `sap.ui.comp.smartform.SmartForm`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachEditToggled(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: SmartForm$EditToggledEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:checked checked} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChecked(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartForm$CheckedEventParameters
    ): this;
    /**
     * Fires event {@link #event:editToggled editToggled} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireEditToggled(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: SmartForm$EditToggledEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.56.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getCheckButton checkButton}.
     *
     * Specifies whether a check button is added to the toolbar.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `checkButton`
     */
    getCheckButton(): boolean;
    /**
     * Gets content of aggregation {@link #getCustomToolbar customToolbar}.
     *
     * An additional toolbar that can be added by the users, which can contain further custom buttons, controls,
     * etc.
     *
     * **Note:** If a special title is required inside the `Toolbar`, it must be added as content to the `Toolbar`.
     * In this case add the `Title` to the `ariaLabelledBy` association. Use the required title level to meet
     * the visual requirements. This might be theme-dependent.
     */
    getCustomToolbar(): Toolbar;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Applies a device-specific and theme-specific line height and label alignment to the form rows if the
     * form has editable content. If set, all (not only the editable) rows of the form will get the line height
     * of editable fields.
     *
     * The labels inside the form will be rendered by default in the according mode.
     *
     * **Note:** The setting of this property will be passed to all `SmartField` controls inside the form, so
     * they will be editable if the form is editable.
     *
     * **Warning:** The setting of this property will not be passed to controls other than `SmartField`. For
     * example, `Input` controls in a form with `editable` set to `false` are still editable.
     *
     * If controls other than `SmartField` controls are used, and the edit mode of their control is not set
     * correctly, this might lead to visual issues. The labels and fields might be misaligned, the labels might
     * be rendered in the wrong mode, and the spacing between the single controls might be wrong. Also, controls
     * that do not fit the mode might be rendered incorrectly.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getEditTogglable editTogglable}.
     *
     * If set to `true`, a button to toggle the `editable` property is shown in the toolbar.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `editTogglable`
     */
    getEditTogglable(): boolean;
    /**
     * Gets current value of property {@link #getEntityType entityType}.
     *
     * CSV of entity types for which the flexibility features are available.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     *
     * @returns Value of property `entityType`
     */
    getEntityType(): string;
    /**
     * Gets current value of property {@link #getExpandable expandable}.
     *
     * Specifies whether the control is expandable. Per default the control is not rendered as expanded.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `expandable`
     */
    getExpandable(): boolean;
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * If expandable, this property indicates whether the state is expanded or not. If expanded, then the toolbar
     * (if available) and the content is rendered; if expanded is false, then only the headerText/headerToolbar
     * is rendered.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getFlexEnabled flexEnabled}.
     *
     * Specifies whether the form enables flexibility features, such as adding new fields.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `flexEnabled`
     */
    getFlexEnabled(): boolean;
    /**
     * Gets content of aggregation {@link #getGroups groups}.
     *
     * Groups are used to group form elements.
     */
    getGroups(): Group[];
    /**
     * Gets current value of property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if the horizontal layout is used.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Value of property `horizontalLayoutGroupElementMinWidth`
     */
    getHorizontalLayoutGroupElementMinWidth(): int;
    /**
     * Gets current value of property {@link #getIgnoredFields ignoredFields}.
     *
     * A list of fields that must not be available in the key-user adaptation dialog. Listed field names are
     * separated by commas.
     *
     * The property is designed to be used by SAP Fiori elements, and it’s not evaluated by the `SmartForm`
     * control itself.
     *
     * **Note:**
     *  Please ensure that you do not add spaces or special characters as no validation is done for this property.
     *
     *
     * @returns Value of property `ignoredFields`
     */
    getIgnoredFields(): string;
    /**
     * Gets current value of property {@link #getImportance importance}.
     *
     * Specifies which smart fields will be visible inside the `SmartForm`.
     *
     * If set to **high**, only smart fields with high importance will be visible.
     *
     * If set to **medium**, only smart fields with high and medium importance will be visible.
     *
     * If set to **low** (default), all the smart fields will be visible regardless of their importance.
     *
     * Note: If a smart field is annotated as mandatory or hidden, its visibility will not be affected
     * by the `importance` property.
     *
     * Default value is `Low`.
     *
     * @since 1.87
     *
     * @returns Value of property `importance`
     */
    getImportance(): smartform.Importance;
    /**
     * Gets content of aggregation {@link #getLayout layout}.
     *
     * Layout settings to adjust the used layout.
     *
     * Use {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} to have the current UI.
     */
    getLayout(): smartform.SmartFormLayout;
    /**
     * Gets content of aggregation {@link #getSemanticObjectController semanticObjectController}.
     *
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     */
    getSemanticObjectController(): SemanticObjectController;
    /**
     * Retrieves all the smart fields of the form.
     *
     * **Note:** Even invisible `SmartField` controls are returned if the `group` or `groupElement` is visible.
     *
     *
     * @returns An array of smart fields (might be empty).
     */
    getSmartFields(
      /**
       * Determines if only visible `groups` are taken into account
       */
      bConsiderOnlyVisibleGroups?: boolean,
      /**
       * Determines if only visible `groupElement` elements are taken into account
       */
      bConsiderOnlyVisibleGroupElements?: boolean
    ): SmartField[];
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title of the form.
     *
     * **Note:** The title is rendered with a theme-dependent default level. As the `SmartForm` control cannot
     * know the structure of the page, this might not fit the page structure. In this case provide the title
     * using a {@link sap.m.Title Title} control and set its {@link sap.m.Title#setLevel level} to the required
     * value. Add this title to a {@link sap.m.Toolbar Toolbar} control and assign it to the `SmartForm` using
     * the `customToolbar` aggregation.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups are rendered in a {@link sap.ui.layout.form.ResponsiveLayout ResponsiveLayout }
     * with the label above the field. Each group is rendered in a new line.
     *
     * **Note:** This property should no longer be used. To arrange the fields in columns, {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout }
     * should be used in the `layout` aggregation.
     *
     * **Note:** The value of this property will be passed on to the `useHorizontalLayout` property of all `Group`
     * and `GroupElement` elements.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation.
     *
     * @returns Value of property `useHorizontalLayout`
     */
    getUseHorizontalLayout(): boolean;
    /**
     * Gets current value of property {@link #getValidationMode validationMode}.
     *
     * Controls the SmartForm validation mode. The default mode handles only nested `SmartField` controls with
     * synchronous validation. If the `SmartForm` should also handle controls with asynchronous validation the
     * property should be set to `Async` mode which is the recommended mode to be used as all types of nested
     * fields validation are handled.
     *
     * Note: Using `Async` mode the method `check` will return a promise instead of an array.
     *
     * Note: Using `Async` mode the event `checked` will be called asynchronously when all the nested `SmartField`
     * validations are executed.
     *
     * Default value is `Standard`.
     *
     * @since 1.81
     *
     * @returns Value of property `validationMode`
     */
    getValidationMode(): smartform.SmartFormValidationMode;
    /**
     * Returns the array of properties currently visible on the UI.
     *
     *
     * @returns The properties currently visible
     */
    getVisibleProperties(): string[];
    /**
     * Checks for the provided `sap.ui.comp.smartform.Group` in the aggregation {@link #getGroups groups}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGroup(
      /**
       * The group whose index is looked for
       */
      oGroup: Group
    ): int;
    /**
     * Inserts some customData into the aggregation `customData`.
     *
     * **Note:** `customData` that is used by the `SmartField` control itself is also added to the `Group` elements,
     * `GroupElement` elements and the `SmartField` controls in the children hierarchy. Additional `customData`
     * that is not used by the `SmartField` control internally might not be added.
     *
     *
     * @returns Reference to `this` to allow method chaining.
     */
    insertCustomData(
      /**
       * the customData to insert; if empty, nothing is inserted
       */
      oCustomData: CustomData,
      /**
       * the 0-based index the customData should be inserted at; for a negative value of iIndex, the customData
       * is inserted at position 0; for a value greater than the current size of the aggregation, the customData
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a group into the aggregation {@link #getGroups groups}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGroup(
      /**
       * The group to insert; if empty, nothing is inserted
       */
      oGroup: Group,
      /**
       * The `0`-based index the group should be inserted at; for a negative value of `iIndex`, the group is inserted
       * at position 0; for a value greater than the current size of the aggregation, the group is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Sets default span for `GridData` layout of group elements when used with horizontal layout.
     *
     * **Note:** There is no need to call this function as the update of all `GroupElement` elements inside
     * the `SmartForm` control is triggered automatically if the `GridDataSpan` property of the `Layout` aggregation
     * changes or the `Layout` aggregation is added.
     *
     *
     * @returns `this` to allow method chaining.
     */
    propagateGridDataSpan(): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.56.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getGroups groups}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGroups(): Group[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.56.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a group from the aggregation {@link #getGroups groups}.
     *
     *
     * @returns The removed group or `null`
     */
    removeGroup(
      /**
       * The group to remove or its index or id
       */
      vGroup: int | string | Group
    ): Group | null;
    /**
     * Sets a new value for property {@link #getCheckButton checkButton}.
     *
     * Specifies whether a check button is added to the toolbar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCheckButton(
      /**
       * New value for property `checkButton`
       */
      bCheckButton?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getCustomToolbar customToolbar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomToolbar(
      /**
       * The customToolbar to set
       */
      oCustomToolbar: Toolbar
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Applies a device-specific and theme-specific line height and label alignment to the form rows if the
     * form has editable content. If set, all (not only the editable) rows of the form will get the line height
     * of editable fields.
     *
     * The labels inside the form will be rendered by default in the according mode.
     *
     * **Note:** The setting of this property will be passed to all `SmartField` controls inside the form, so
     * they will be editable if the form is editable.
     *
     * **Warning:** The setting of this property will not be passed to controls other than `SmartField`. For
     * example, `Input` controls in a form with `editable` set to `false` are still editable.
     *
     * If controls other than `SmartField` controls are used, and the edit mode of their control is not set
     * correctly, this might lead to visual issues. The labels and fields might be misaligned, the labels might
     * be rendered in the wrong mode, and the spacing between the single controls might be wrong. Also, controls
     * that do not fit the mode might be rendered incorrectly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEditTogglable editTogglable}.
     *
     * If set to `true`, a button to toggle the `editable` property is shown in the toolbar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditTogglable(
      /**
       * New value for property `editTogglable`
       */
      bEditTogglable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEntityType entityType}.
     *
     * CSV of entity types for which the flexibility features are available.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntityType(
      /**
       * New value for property `entityType`
       */
      sEntityType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpandable expandable}.
     *
     * Specifies whether the control is expandable. Per default the control is not rendered as expanded.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandable(
      /**
       * New value for property `expandable`
       */
      bExpandable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * If expandable, this property indicates whether the state is expanded or not. If expanded, then the toolbar
     * (if available) and the content is rendered; if expanded is false, then only the headerText/headerToolbar
     * is rendered.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFlexEnabled flexEnabled}.
     *
     * Specifies whether the form enables flexibility features, such as adding new fields.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFlexEnabled(
      /**
       * New value for property `flexEnabled`
       */
      bFlexEnabled?: boolean
    ): this;
    /**
     * Sets the focus on the first editable control.
     *
     * @since 1.36.0
     */
    setFocusOnEditableControl(): void;
    /**
     * Sets a new value for property {@link #getHorizontalLayoutGroupElementMinWidth horizontalLayoutGroupElementMinWidth}.
     *
     * Specifies the minimal size in pixels of all group elements of the form if the horizontal layout is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalLayoutGroupElementMinWidth(
      /**
       * New value for property `horizontalLayoutGroupElementMinWidth`
       */
      iHorizontalLayoutGroupElementMinWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getIgnoredFields ignoredFields}.
     *
     * A list of fields that must not be available in the key-user adaptation dialog. Listed field names are
     * separated by commas.
     *
     * The property is designed to be used by SAP Fiori elements, and it’s not evaluated by the `SmartForm`
     * control itself.
     *
     * **Note:**
     *  Please ensure that you do not add spaces or special characters as no validation is done for this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIgnoredFields(
      /**
       * New value for property `ignoredFields`
       */
      sIgnoredFields?: string
    ): this;
    /**
     * Sets a new value for property {@link #getImportance importance}.
     *
     * Specifies which smart fields will be visible inside the `SmartForm`.
     *
     * If set to **high**, only smart fields with high importance will be visible.
     *
     * If set to **medium**, only smart fields with high and medium importance will be visible.
     *
     * If set to **low** (default), all the smart fields will be visible regardless of their importance.
     *
     * Note: If a smart field is annotated as mandatory or hidden, its visibility will not be affected
     * by the `importance` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Low`.
     *
     * @since 1.87
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImportance(
      /**
       * New value for property `importance`
       */
      sImportance?: smartform.Importance | keyof typeof smartform.Importance
    ): this;
    /**
     * Sets the aggregated {@link #getLayout layout}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayout(
      /**
       * The layout to set
       */
      oLayout: smartform.SmartFormLayout
    ): this;
    /**
     * Sets the aggregated {@link #getSemanticObjectController semanticObjectController}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSemanticObjectController(
      /**
       * The semanticObjectController to set
       */
      oSemanticObjectController: SemanticObjectController
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title of the form.
     *
     * **Note:** The title is rendered with a theme-dependent default level. As the `SmartForm` control cannot
     * know the structure of the page, this might not fit the page structure. In this case provide the title
     * using a {@link sap.m.Title Title} control and set its {@link sap.m.Title#setLevel level} to the required
     * value. Add this title to a {@link sap.m.Toolbar Toolbar} control and assign it to the `SmartForm` using
     * the `customToolbar` aggregation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUseHorizontalLayout useHorizontalLayout}.
     *
     * Specifies whether the groups are rendered in a {@link sap.ui.layout.form.ResponsiveLayout ResponsiveLayout }
     * with the label above the field. Each group is rendered in a new line.
     *
     * **Note:** This property should no longer be used. To arrange the fields in columns, {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout }
     * should be used in the `layout` aggregation.
     *
     * **Note:** The value of this property will be passed on to the `useHorizontalLayout` property of all `Group`
     * and `GroupElement` elements.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseHorizontalLayout(
      /**
       * New value for property `useHorizontalLayout`
       */
      bUseHorizontalLayout?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValidationMode validationMode}.
     *
     * Controls the SmartForm validation mode. The default mode handles only nested `SmartField` controls with
     * synchronous validation. If the `SmartForm` should also handle controls with asynchronous validation the
     * property should be set to `Async` mode which is the recommended mode to be used as all types of nested
     * fields validation are handled.
     *
     * Note: Using `Async` mode the method `check` will return a promise instead of an array.
     *
     * Note: Using `Async` mode the event `checked` will be called asynchronously when all the nested `SmartField`
     * validations are executed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Standard`.
     *
     * @since 1.81
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValidationMode(
      /**
       * New value for property `validationMode`
       */
      sValidationMode?:
        | smartform.SmartFormValidationMode
        | keyof typeof smartform.SmartFormValidationMode
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartForm constructor.
   */
  export interface $SmartFormSettings extends $ControlSettings {
    /**
     * Title of the form.
     *
     * **Note:** The title is rendered with a theme-dependent default level. As the `SmartForm` control cannot
     * know the structure of the page, this might not fit the page structure. In this case provide the title
     * using a {@link sap.m.Title Title} control and set its {@link sap.m.Title#setLevel level} to the required
     * value. Add this title to a {@link sap.m.Toolbar Toolbar} control and assign it to the `SmartForm` using
     * the `customToolbar` aggregation.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Specifies whether the groups are rendered in a {@link sap.ui.layout.form.ResponsiveLayout ResponsiveLayout }
     * with the label above the field. Each group is rendered in a new line.
     *
     * **Note:** This property should no longer be used. To arrange the fields in columns, {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout }
     * should be used in the `layout` aggregation.
     *
     * **Note:** The value of this property will be passed on to the `useHorizontalLayout` property of all `Group`
     * and `GroupElement` elements.
     *
     * @deprecated As of version 1.86. replaced by {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} in
     * the `layout` aggregation.
     */
    useHorizontalLayout?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the minimal size in pixels of all group elements of the form if the horizontal layout is used.
     *
     * @deprecated As of version 1.48.0. please do not use this property as it does not have any effect on the
     * current layout of the `SmartForm` control.
     */
    horizontalLayoutGroupElementMinWidth?:
      | int
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies whether a check button is added to the toolbar.
     */
    checkButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * CSV of entity types for which the flexibility features are available.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     *  **Note:** No validation is done. Please ensure that you do not add spaces or special characters.
     */
    entityType?: string | PropertyBindingInfo;

    /**
     * Specifies whether the control is expandable. Per default the control is not rendered as expanded.
     */
    expandable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If expandable, this property indicates whether the state is expanded or not. If expanded, then the toolbar
     * (if available) and the content is rendered; if expanded is false, then only the headerText/headerToolbar
     * is rendered.
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, a button to toggle the `editable` property is shown in the toolbar.
     */
    editTogglable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Applies a device-specific and theme-specific line height and label alignment to the form rows if the
     * form has editable content. If set, all (not only the editable) rows of the form will get the line height
     * of editable fields.
     *
     * The labels inside the form will be rendered by default in the according mode.
     *
     * **Note:** The setting of this property will be passed to all `SmartField` controls inside the form, so
     * they will be editable if the form is editable.
     *
     * **Warning:** The setting of this property will not be passed to controls other than `SmartField`. For
     * example, `Input` controls in a form with `editable` set to `false` are still editable.
     *
     * If controls other than `SmartField` controls are used, and the edit mode of their control is not set
     * correctly, this might lead to visual issues. The labels and fields might be misaligned, the labels might
     * be rendered in the wrong mode, and the spacing between the single controls might be wrong. Also, controls
     * that do not fit the mode might be rendered incorrectly.
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A list of fields that must not be available in the key-user adaptation dialog. Listed field names are
     * separated by commas.
     *
     * The property is designed to be used by SAP Fiori elements, and it’s not evaluated by the `SmartForm`
     * control itself.
     *
     * **Note:**
     *  Please ensure that you do not add spaces or special characters as no validation is done for this property.
     */
    ignoredFields?: string | PropertyBindingInfo;

    /**
     * Specifies whether the form enables flexibility features, such as adding new fields.
     *  For more information about SAPUI5 flexibility, refer to the Developer Guide.
     */
    flexEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls the SmartForm validation mode. The default mode handles only nested `SmartField` controls with
     * synchronous validation. If the `SmartForm` should also handle controls with asynchronous validation the
     * property should be set to `Async` mode which is the recommended mode to be used as all types of nested
     * fields validation are handled.
     *
     * Note: Using `Async` mode the method `check` will return a promise instead of an array.
     *
     * Note: Using `Async` mode the event `checked` will be called asynchronously when all the nested `SmartField`
     * validations are executed.
     *
     * @since 1.81
     */
    validationMode?:
      | (
          | smartform.SmartFormValidationMode
          | keyof typeof smartform.SmartFormValidationMode
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies which smart fields will be visible inside the `SmartForm`.
     *
     * If set to **high**, only smart fields with high importance will be visible.
     *
     * If set to **medium**, only smart fields with high and medium importance will be visible.
     *
     * If set to **low** (default), all the smart fields will be visible regardless of their importance.
     *
     * Note: If a smart field is annotated as mandatory or hidden, its visibility will not be affected
     * by the `importance` property.
     *
     * @since 1.87
     */
    importance?:
      | (smartform.Importance | keyof typeof smartform.Importance)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Groups are used to group form elements.
     */
    groups?: Group[] | Group | AggregationBindingInfo | `{${string}}`;

    /**
     * Layout settings to adjust the used layout.
     *
     * Use {@link sap.ui.comp.smartform.ColumnLayout ColumnLayout} to have the current UI.
     */
    layout?: smartform.SmartFormLayout;

    /**
     * The Semantic Object Controller allows the user to specify and overwrite functionality for semantic object
     * navigation.
     */
    semanticObjectController?: SemanticObjectController;

    /**
     * An additional toolbar that can be added by the users, which can contain further custom buttons, controls,
     * etc.
     *
     * **Note:** If a special title is required inside the `Toolbar`, it must be added as content to the `Toolbar`.
     * In this case add the `Title` to the `ariaLabelledBy` association. Use the required title level to meet
     * the visual requirements. This might be theme-dependent.
     */
    customToolbar?: Toolbar;

    /**
     * Association to controls / IDs that label this control (see WAI-ARIA attribute `aria-labelledby`).
     *
     * @since 1.56.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * This event is fired when the editable property is toggled.
     */
    editToggled?: (oEvent: SmartForm$EditToggledEvent) => void;

    /**
     * This event is fired after check was performed.
     */
    checked?: (oEvent: SmartForm$CheckedEvent) => void;
  }

  /**
   * Parameters of the SmartForm#checked event.
   */
  export interface SmartForm$CheckedEventParameters {
    /**
     * An array containing all smart fields with errors
     */
    erroneousFields?: SmartField[];
  }

  /**
   * Event object of the SmartForm#checked event.
   */
  export type SmartForm$CheckedEvent = Event<
    SmartForm$CheckedEventParameters,
    SmartForm
  >;

  /**
   * Parameters of the SmartForm#editToggled event.
   */
  export interface SmartForm$EditToggledEventParameters {
    /**
     * If `true`, the control is in edit mode
     */
    editable?: boolean;
  }

  /**
   * Event object of the SmartForm#editToggled event.
   */
  export type SmartForm$EditToggledEvent = Event<
    SmartForm$EditToggledEventParameters,
    SmartForm
  >;
}

declare module "sap/ui/comp/smartlist/SmartList" {
  import { default as VBox, $VBoxSettings } from "sap/m/VBox";

  import Event from "sap/ui/base/Event";

  import ListItemBase from "sap/m/ListItemBase";

  import { smartlist } from "sap/ui/comp/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ID } from "sap/ui/core/library";

  import Control from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A smart control to simplify using the `sap.m.List` and `sap.m.Tree` controls in list patterns. Overview:
   * The `SmartList` control creates a list or tree based on the configuration specified. There is, however,
   * a difference to other smart controls: This control does not use annotations to automatically create its
   * content. Hence, a template must always be provided for this control. Structure: The `SmartList` control
   * consists of the following elements:
   * 	 -  `OverflowToolbar` control: Displays the header and other action buttons. Users can add their own
   *     toolbar and buttons in the view.
   * 	 -  `List` or `Tree` control: The actual list/tree control. Users can also add this in the view with
   *     the required configuration.  The `entitySet` property must be specified to use the control. This
   *     attribute is used to fetch the actual data.
   *  The `listItemTemplate` aggregation must also be specified with the required item template, such as `StandardListItem/StandardTreeItem`,
   * which will be used during binding. **Note:**: Most of the attributes/properties are not dynamic and cannot
   * be changed once the control has been initialized.
   *
   * @since 1.48
   */
  export default class SmartList extends VBox {
    /**
     * Constructor for a new smartlist/SmartList.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartListSettings
    );
    /**
     * Constructor for a new smartlist/SmartList.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartListSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartlist.SmartList with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.VBox.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartList>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartlist.SmartList.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeRebindList beforeRebindList} event of
     * this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired right before the binding is being done.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeRebindList(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeRebindList beforeRebindList} event of
     * this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired right before the binding is being done.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeRebindList(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired when data is received after binding. The event is usually only fired if the binding for the
     * list is done by the `SmartList` control itself.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataReceived(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired when data is received after binding. The event is usually only fired if the binding for the
     * list is done by the `SmartList` control itself.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDataReceived(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired once the control has been initialized.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:initialise initialise} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ui.comp.smartlist.SmartList` itself.
     *
     * Event fired once the control has been initialized.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachInitialise(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ui.comp.smartlist.SmartList` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the listItemTemplate in the aggregation {@link #getListItemTemplate listItemTemplate}.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyListItemTemplate(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeRebindList beforeRebindList} event of
     * this `sap.ui.comp.smartlist.SmartList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeRebindList(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:dataReceived dataReceived} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDataReceived(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:initialise initialise} event of this `sap.ui.comp.smartlist.SmartList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachInitialise(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Cleans up the control
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    exit(): void;
    /**
     * Fires event {@link #event:beforeRebindList beforeRebindList} to attached listeners.
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeRebindList(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataReceived dataReceived} to attached listeners.
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDataReceived(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:initialise initialise} to attached listeners.
     *
     * @since 1.48.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireInitialise(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * When set to `true`, this enables automatic binding of the list using the `listBindingPath` (if it exists)
     * or `entitySet` property. This happens right after the `initialise` event has been fired.
     *
     * Default value is `false`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
    /**
     * Gets current value of property {@link #getEntitySet entitySet}.
     *
     * The entity set name from which to fetch data.
     *  Note:
     *  This is not a dynamic UI5 property.
     *
     * @since 1.48.0
     *
     * @returns Value of property `entitySet`
     */
    getEntitySet(): string;
    /**
     * Gets current value of property {@link #getExpandFields expandFields}.
     *
     * CSV of fields that must be expanded when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `expandFields`
     */
    getExpandFields(): string;
    /**
     * Gets current value of property {@link #getHeader header}.
     *
     * Specifies header text that is shown in list.
     *
     * @since 1.48.0
     *
     * @returns Value of property `header`
     */
    getHeader(): string;
    /**
     * Returns the `List` or `Tree` used internally.
     *
     *
     * @returns the control
     */
    getList(): object;
    /**
     * Gets current value of property {@link #getListBindingPath listBindingPath}.
     *
     * Specifies the path that is used during the binding of the list. If not specified, the `entitySet` property
     * is used instead. (used only if binding is done automatically or when using `rebindList`)
     *
     * @since 1.48.0
     *
     * @returns Value of property `listBindingPath`
     */
    getListBindingPath(): string;
    /**
     * Gets content of aggregation {@link #getListItemTemplate listItemTemplate}.
     *
     * Specifies the template that is used for the inner `List` or `Tree` control.
     *  **Note:**
     *  This template is used when binding the `items` of `sap.m.List` or `sap.m.Tree` control, and will not
     * be available in the `SmartList` control once the binding has been done.
     *
     * @since 1.48.0
     */
    getListItemTemplate(): ListItemBase;
    /**
     * Gets current value of property {@link #getListType listType}.
     *
     * Specifies the type of list to be created in the `SmartList` control.
     *  Note:
     *  If you add a `List` or `Tree` to the content of the `SmartList` control in the view, this property has
     * no effect.
     *
     * @since 1.48.0
     *
     * @returns Value of property `listType`
     */
    getListType(): smartlist.ListType;
    /**
     * Gets current value of property {@link #getSelectFields selectFields}.
     *
     * CSV of fields that must be selected when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `selectFields`
     */
    getSelectFields(): string;
    /**
     * Gets current value of property {@link #getShowFullScreenButton showFullScreenButton}.
     *
     * Controls the visibility of the full screen button.
     *
     * Default value is `false`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `showFullScreenButton`
     */
    getShowFullScreenButton(): boolean;
    /**
     * Gets current value of property {@link #getShowRowCount showRowCount}.
     *
     * The number of rows is shown along with the header text if the property `showRowCount` is set to `true`.
     *
     * **Note:**
     * 	 - To improve your application's performance, activate the inline count for OData bindings to avoid
     *     sending dedicated OData requests.
     * 	 - If no stable overall count can be retrieved from the binding, the count will not be displayed. This
     *     is currently the case for TreeBinding or if no count is requested by the binding.
     *
     * Default value is `true`.
     *
     * @since 1.48.0
     *
     * @returns Value of property `showRowCount`
     */
    getShowRowCount(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getSmartFilter smartFilter},
     * or `null`.
     *
     * @since 1.48.0
     */
    getSmartFilter(): ID | null;
    /**
     * Checks whether the control is initialized.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns returns whether control has already been initialized
     */
    isInitialised(): boolean;
    /**
     * This can be used to trigger binding on the list used in the SmartList
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    rebindList(
      /**
       * force bind call to be triggered on the inner list
       */
      bForceRebind: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * When set to `true`, this enables automatic binding of the list using the `listBindingPath` (if it exists)
     * or `entitySet` property. This happens right after the `initialise` event has been fired.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoBinding(
      /**
       * New value for property `enableAutoBinding`
       */
      bEnableAutoBinding?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEntitySet entitySet}.
     *
     * The entity set name from which to fetch data.
     *  Note:
     *  This is not a dynamic UI5 property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntitySet(
      /**
       * New value for property `entitySet`
       */
      sEntitySet?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpandFields expandFields}.
     *
     * CSV of fields that must be expanded when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandFields(
      /**
       * New value for property `expandFields`
       */
      sExpandFields?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeader header}.
     *
     * Specifies header text that is shown in list.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeader(
      /**
       * New value for property `header`
       */
      sHeader?: string
    ): this;
    /**
     * Sets a new value for property {@link #getListBindingPath listBindingPath}.
     *
     * Specifies the path that is used during the binding of the list. If not specified, the `entitySet` property
     * is used instead. (used only if binding is done automatically or when using `rebindList`)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListBindingPath(
      /**
       * New value for property `listBindingPath`
       */
      sListBindingPath?: string
    ): this;
    /**
     * Sets the aggregated {@link #getListItemTemplate listItemTemplate}.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListItemTemplate(
      /**
       * The listItemTemplate to set
       */
      oListItemTemplate: ListItemBase
    ): this;
    /**
     * Sets a new value for property {@link #getListType listType}.
     *
     * Specifies the type of list to be created in the `SmartList` control.
     *  Note:
     *  If you add a `List` or `Tree` to the content of the `SmartList` control in the view, this property has
     * no effect.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListType(
      /**
       * New value for property `listType`
       */
      sListType?: smartlist.ListType | keyof typeof smartlist.ListType
    ): this;
    /**
     * Sets a new value for property {@link #getSelectFields selectFields}.
     *
     * CSV of fields that must be selected when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectFields(
      /**
       * New value for property `selectFields`
       */
      sSelectFields?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowFullScreenButton showFullScreenButton}.
     *
     * Controls the visibility of the full screen button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFullScreenButton(
      /**
       * New value for property `showFullScreenButton`
       */
      bShowFullScreenButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRowCount showRowCount}.
     *
     * The number of rows is shown along with the header text if the property `showRowCount` is set to `true`.
     *
     * **Note:**
     * 	 - To improve your application's performance, activate the inline count for OData bindings to avoid
     *     sending dedicated OData requests.
     * 	 - If no stable overall count can be retrieved from the binding, the count will not be displayed. This
     *     is currently the case for TreeBinding or if no count is requested by the binding.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRowCount(
      /**
       * New value for property `showRowCount`
       */
      bShowRowCount?: boolean
    ): this;
    /**
     * Sets the associated {@link #getSmartFilter smartFilter}.
     *
     * @since 1.48.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSmartFilter(
      /**
       * ID of an element which becomes the new target of this smartFilter association; alternatively, an element
       * instance may be given
       */
      oSmartFilter: ID | Control
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartList constructor.
   */
  export interface $SmartListSettings extends $VBoxSettings {
    /**
     * The entity set name from which to fetch data.
     *  Note:
     *  This is not a dynamic UI5 property.
     *
     * @since 1.48.0
     */
    entitySet?: string | PropertyBindingInfo;

    /**
     * CSV of fields that must be selected when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * @since 1.48.0
     */
    selectFields?: string | PropertyBindingInfo;

    /**
     * CSV of fields that must be expanded when request is sent to the backend.
     *  Note:
     *  No validation is done. Please ensure that you do not add spaces or special characters.
     *  This property is only needed when used together with an `ODataModel`.
     *
     * @since 1.48.0
     */
    expandFields?: string | PropertyBindingInfo;

    /**
     * The number of rows is shown along with the header text if the property `showRowCount` is set to `true`.
     *
     * **Note:**
     * 	 - To improve your application's performance, activate the inline count for OData bindings to avoid
     *     sending dedicated OData requests.
     * 	 - If no stable overall count can be retrieved from the binding, the count will not be displayed. This
     *     is currently the case for TreeBinding or if no count is requested by the binding.
     *
     * @since 1.48.0
     */
    showRowCount?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies header text that is shown in list.
     *
     * @since 1.48.0
     */
    header?: string | PropertyBindingInfo;

    /**
     * When set to `true`, this enables automatic binding of the list using the `listBindingPath` (if it exists)
     * or `entitySet` property. This happens right after the `initialise` event has been fired.
     *
     * @since 1.48.0
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the path that is used during the binding of the list. If not specified, the `entitySet` property
     * is used instead. (used only if binding is done automatically or when using `rebindList`)
     *
     * @since 1.48.0
     */
    listBindingPath?: string | PropertyBindingInfo;

    /**
     * Specifies the type of list to be created in the `SmartList` control.
     *  Note:
     *  If you add a `List` or `Tree` to the content of the `SmartList` control in the view, this property has
     * no effect.
     *
     * @since 1.48.0
     */
    listType?:
      | (smartlist.ListType | keyof typeof smartlist.ListType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Controls the visibility of the full screen button.
     *
     * @since 1.48.0
     */
    showFullScreenButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the template that is used for the inner `List` or `Tree` control.
     *  **Note:**
     *  This template is used when binding the `items` of `sap.m.List` or `sap.m.Tree` control, and will not
     * be available in the `SmartList` control once the binding has been done.
     *
     * @since 1.48.0
     */
    listItemTemplate?: ListItemBase;

    /**
     * The `SmartFilterBar` control to be linked to the `SmartList` control. Some events of the `SmartFilterBar`
     * control are then used to fetch data, show overlay etc.
     *
     * @since 1.48.0
     */
    smartFilter?: Control | string;

    /**
     * Event fired once the control has been initialized.
     *
     * @since 1.48.0
     */
    initialise?: (oEvent: Event) => void;

    /**
     * Event fired right before the binding is being done.
     *
     * @since 1.48.0
     */
    beforeRebindList?: (oEvent: Event) => void;

    /**
     * Event fired when data is received after binding. The event is usually only fired if the binding for the
     * list is done by the `SmartList` control itself.
     *
     * @since 1.48.0
     */
    dataReceived?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the SmartList#beforeRebindList event.
   */
  export interface SmartList$BeforeRebindListEventParameters {}

  /**
   * Event object of the SmartList#beforeRebindList event.
   */
  export type SmartList$BeforeRebindListEvent = Event<
    SmartList$BeforeRebindListEventParameters,
    SmartList
  >;

  /**
   * Parameters of the SmartList#dataReceived event.
   */
  export interface SmartList$DataReceivedEventParameters {}

  /**
   * Event object of the SmartList#dataReceived event.
   */
  export type SmartList$DataReceivedEvent = Event<
    SmartList$DataReceivedEventParameters,
    SmartList
  >;

  /**
   * Parameters of the SmartList#initialise event.
   */
  export interface SmartList$InitialiseEventParameters {}

  /**
   * Event object of the SmartList#initialise event.
   */
  export type SmartList$InitialiseEvent = Event<
    SmartList$InitialiseEventParameters,
    SmartList
  >;
}

declare module "sap/ui/comp/smartmicrochart/SmartAreaMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SmartAreaMicroChart control creates a AreaMicroChart based on OData metadata and the configuration
   * specified. The entitySet attribute must be specified to use the control. This attribute is used to fetch
   * fields from OData metadata, from which Micro Area Chart UI will be generated; it can also be used to
   * fetch the actual chart data.
   *  **Note:**
   *  Most of the attributes/properties are not dynamic and cannot be changed once the control has been initialised.
   *
   * @since 1.38
   */
  export default class SmartAreaMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartAreaMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartAreaMicroChartSettings
    );
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartAreaMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartAreaMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartAreaMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartAreaMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartAreaMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * Only `true` value is supported: the chart will be bound to the chartBindingPath or to the entitySet
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
  }
  /**
   * Describes the settings that can be provided to the SmartAreaMicroChart constructor.
   */
  export interface $SmartAreaMicroChartSettings
    extends $SmartMicroChartBaseSettings {
    /**
     * Only `true` value is supported: the chart will be bound to the chartBindingPath or to the entitySet
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartmicrochart/SmartBulletMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SmartBulletMicroChart control creates a `sap.suite.ui.microchart.BulletMicroChart` based on OData
   * metadata and the configuration specified by `mSettings`. The entitySet attribute must be specified to
   * use the control. This attribute is used to fetch metadata and annotation information from the given default
   * OData model. Based on this, the BulletMicroChart UI is created.
   *  **Note:**
   *  Most of the attributes/properties are not dynamic and cannot be changed once the control has been initialized.
   *
   * @since 1.38
   */
  export default class SmartBulletMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartBulletMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartBulletMicroChartSettings
    );
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartBulletMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartBulletMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartBulletMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartBulletMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartBulletMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * property.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
    /**
     * Sets a new value for property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoBinding(
      /**
       * New value for property `enableAutoBinding`
       */
      bEnableAutoBinding?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartBulletMicroChart constructor.
   */
  export interface $SmartBulletMicroChartSettings
    extends $SmartMicroChartBaseSettings {
    /**
     * If set to `true`, this enables automatic binding of the chart using the chartBindingPath (if it exists)
     * property.
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartmicrochart/SmartColumnMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The SmartColumnMicroChart control creates a {@link sap.suite.ui.microchart.ColumnMicroChart ColumnMicroChart }
   * based on OData metadata and the configuration specified.
   * The `entitySet` property is required. The entity set you specify in this property is used to fetch OData
   * metadata and to generate the micro chart's UI. This property can also be used to fetch actual chart data.
   *  **Note:**
   *  Most properties are not dynamic and cannot be changed, once the control has been initialized.
   *
   * @since 1.60
   */
  export default class SmartColumnMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartColumnMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase#constructor sap.ui.comp.smartmicrochart.SmartMicroChartBase }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartColumnMicroChartSettings
    );
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartColumnMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase#constructor sap.ui.comp.smartmicrochart.SmartMicroChartBase }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartColumnMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartColumnMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartColumnMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartColumnMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the SmartColumnMicroChart constructor.
   */
  export interface $SmartColumnMicroChartSettings
    extends $SmartMicroChartBaseSettings {}
}

declare module "sap/ui/comp/smartmicrochart/SmartComparisonMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The SmartComparisonMicroChart control creates a ComparisonMicroChart based on OData metadata and the
   * configuration specified. The `entitySet` property is required to use the control. The entity set you
   * specify in this property is used to feetch OData metadata and to generate the micro chart's UI. This
   * property can also be used to fetch actual data.
   *  **Notes:**
   *
   * 	 - Most properties are not dynamic and cannot be changed, once the control has been initialized.
   * 	 -  SmartComparisonMicroChart does not have its own ChartType/Enum annotation. This means that ChartType
   *     annotation is not specified and SmartComparisonMicroChart cannot be created with a `SmartMicroChart`.
   *
   * @since 1.58
   */
  export default class SmartComparisonMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new SmartComparisonMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase#constructor sap.ui.comp.smartmicrochart.SmartMicroChartBase }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartComparisonMicroChartSettings
    );
    /**
     * Constructor for a new SmartComparisonMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase#constructor sap.ui.comp.smartmicrochart.SmartMicroChartBase }
     * can be used.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartComparisonMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartComparisonMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartComparisonMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartComparisonMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the SmartComparisonMicroChart constructor.
   */
  export interface $SmartComparisonMicroChartSettings
    extends $SmartMicroChartBaseSettings {}
}

declare module "sap/ui/comp/smartmicrochart/SmartDeltaMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SmartDeltaMicroChart control creates a {@link sap.suite.ui.microchart.DeltaMicroChart DeltaMicroChart }
   * based on OData metadata and the configuration specified. The delta micro chart represents the delta of
   * two values as a chart.
   *  The `entitySet` property is required to use the control. The entity set you specify in this property
   * is used to fetch OData metadata and to generate the micro chart's UI. This property can also be used
   * to fetch actual data.
   *  **Notes:**
   *
   * 	 - Most properties are not dynamic and cannot be changed once the control has been initialized.
   * 	 -  SmartDeltaMicroChart does not have its own ChartType/Enum annotation. This means that ChartType
   *     annotation is not specified and SmartDeltaMicroChart cannot be created with a `SmartMicroChart`.
   *
   * @since 1.61
   */
  export default class SmartDeltaMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartDeltaMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartDeltaMicroChartSettings
    );
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartDeltaMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartDeltaMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartDeltaMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartDeltaMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartDeltaMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic data binding using the `chartBindingPath` property , if such
     * a property exists.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
    /**
     * Sets a new value for property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, this enables automatic data binding using the `chartBindingPath` property , if such
     * a property exists.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoBinding(
      /**
       * New value for property `enableAutoBinding`
       */
      bEnableAutoBinding?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartDeltaMicroChart constructor.
   */
  export interface $SmartDeltaMicroChartSettings
    extends $SmartMicroChartBaseSettings {
    /**
     * If set to `true`, this enables automatic data binding using the `chartBindingPath` property , if such
     * a property exists.
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ui/comp/smartmicrochart/SmartHarveyBallMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import { ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Label from "sap/m/Label";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SmartHarveyBallMicroChart control creates a {@link sap.suite.ui.microchart.HarveyBallMicroChart }
   * based on OData metadata and the configuration specified in the `mSettings` of the {@link sap.ui.base.ManagedObject}.
   *
   * The `entitySet` property is required. The entity set is used to fetch OData metadata and annotation information
   * from the provided default OData model. The chart's UI is created based on this data.
   *  **Note:**
   *  Most of the properties are not dynamic and cannot be changed once the control has been initialized.
   *
   * @since 1.62.0
   */
  export default class SmartHarveyBallMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new SmartHarveyBallMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartHarveyBallMicroChartSettings
    );
    /**
     * Constructor for a new SmartHarveyBallMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartHarveyBallMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.ui.comp.smartmicrochart.SmartHarveyBallMicroChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SmartHarveyBallMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.comp.smartmicrochart.SmartHarveyBallMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, the chart is automatically bound using the `chartBindingPath` property, if it is specified.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableAutoBinding`
     */
    getEnableAutoBinding(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getFreeText freeText}, or `null`.
     */
    getFreeText(): ID | null;
    /**
     * Sets a new value for property {@link #getEnableAutoBinding enableAutoBinding}.
     *
     * If set to `true`, the chart is automatically bound using the `chartBindingPath` property, if it is specified.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAutoBinding(
      /**
       * New value for property `enableAutoBinding`
       */
      bEnableAutoBinding?: boolean
    ): this;
    /**
     * Sets the associated {@link #getFreeText freeText}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFreeText(
      /**
       * ID of an element which becomes the new target of this freeText association; alternatively, an element
       * instance may be given
       */
      oFreeText: ID | Label
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SmartHarveyBallMicroChart constructor.
   */
  export interface $SmartHarveyBallMicroChartSettings
    extends $SmartMicroChartBaseSettings {
    /**
     * If set to `true`, the chart is automatically bound using the `chartBindingPath` property, if it is specified.
     */
    enableAutoBinding?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If the associated control is provided, its `text` property is set to the free text provided by annotations.
     * The `Value` property of the `DataPoint` annotation should be annotated with this free text. The `Label`
     * annotation from the `OData Common` vocabulary can be used.
     */
    freeText?: Label | string;
  }
}

declare module "sap/ui/comp/smartmicrochart/SmartLineMicroChart" {
  import {
    default as SmartMicroChartBase,
    $SmartMicroChartBaseSettings,
  } from "sap/ui/comp/smartmicrochart/SmartMicroChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The SmartLineMicroChart control creates a {@link sap.suite.ui.microchart.LineMicroChart LineMicroChart }
   * based on OData metadata and the configuration specified.
   * The `entitySet` property is required. The entity set you specify in this property is used to fetch OData
   * metadata and to generate the micro chart's UI. This property can also be used to fetch actual chart data.
   *  **Note:**
   *  Most properties are not dynamic and cannot be changed, once the control has been initialized.
   *
   * @since 1.60
   */
  export default class SmartLineMicroChart extends SmartMicroChartBase {
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartLineMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.ui.comp.smartmicrochart.SmartMicroChartBase#constructor sap.ui.comp.smartmicrochart.SmartMicroChartBase }
     * can be used.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SmartLineMicroChartSettings
    );
    /**
     * Constructor for a new sap.ui.comp.smartmicrochart.SmartLineMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.Manage