// For Library Version: 1.136.8

declare module "sap/ovp/library" {}

declare module "sap/ovp/app/Component" {
  import {
    default as AppComponent,
    $AppComponentSettings,
  } from "sap/fe/core/AppComponent";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  /**
   * Overview Page Application Component
   */
  export default class Component
    extends AppComponent
    implements
      /* was: sap.fe.core.buildingBlocks.IBuildingBlockOwnerComponent */ Object
  {
    __implements__sap_fe_core_buildingBlocks_IBuildingBlockOwnerComponent: boolean;
    /**
     * Main class used for Overview Page Application Component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.fe.core.AppComponent#constructor sap.fe.core.AppComponent }
     * can be used.@ui5-updated-doclet
     */
    constructor();

    /**
     * Creates a new subclass of class sap.ovp.app.Component with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.fe.core.AppComponent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ovp.app.Component.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
  }
  /**
   * Describes the settings that can be provided to the Component constructor.
   */
  export interface $ComponentSettings extends $AppComponentSettings {}
}

declare module "sap/ovp/app/TemplateBaseExtension" {
  import ControllerExtension from "sap/ui/core/mvc/ControllerExtension";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class contains all extension functions that can be implemented by the application developers in
   * their extension code. Application developers must not override any methods that are not mentioned in
   * this documentation.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  interface TemplateBaseExtension extends ControllerExtension {
    /**
     * Creates a new subclass of class sap.ovp.app.TemplateBaseExtension with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.mvc.ControllerExtension.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    extend(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: object,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ovp.app.TemplateBaseExtension.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    getMetadata(): Metadata;
  }
  const TemplateBaseExtension: TemplateBaseExtension;
  export default TemplateBaseExtension;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/ovp/app/Component": undefined;

    "sap/ovp/app/TemplateBaseExtension": undefined;

    "sap/ovp/library": undefined;
  }
}
