// For Library Version: 1.136.8

declare module "sap/suite/ui/microchart/library" {
  /**
   * Enum of available views for the area micro chart concerning the position of the labels.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'AreaMicroChartViewType'.
   *
   * @since 1.34
   */
  export enum AreaMicroChartViewType {
    /**
     * The view with labels on the top and bottom.
     */
    Normal = "Normal",
    /**
     * The view with labels on the left and right.
     */
    Wide = "Wide",
  }
  /**
   * Defines if the horizontal bar represents a current value only or if it represents the delta between a
   * current value and a threshold value.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'BulletMicroChartModeType'.
   *
   * @since 1.34
   */
  export enum BulletMicroChartModeType {
    /**
     * Displays the Actual value.
     */
    Actual = "Actual",
    /**
     * Displays delta between the Actual and Threshold values.
     */
    Delta = "Delta",
  }
  /**
   * Lists the available theme-specific background colors.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'CommonBackgroundType'.
   *
   * @since 1.34
   */
  export enum CommonBackgroundType {
    /**
     * Dark background color.
     */
    Dark = "Dark",
    /**
     * The darkest background color.
     */
    Darkest = "Darkest",
    /**
     * Extra dark background color.
     */
    ExtraDark = "ExtraDark",
    /**
     * Extra light background color.
     */
    ExtraLight = "ExtraLight",
    /**
     * Light background color.
     */
    Light = "Light",
    /**
     * The lightest background color.
     */
    Lightest = "Lightest",
    /**
     * Medium background color.
     */
    Medium = "Medium",
    /**
     * Medium light background color.
     */
    MediumLight = "MediumLight",
    /**
     * The transparent background color.
     */
    Transparent = "Transparent",
  }
  /**
   * Lists the views of the comparison micro chart concerning the position of titles and labels.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'ComparisonMicroChartViewType'.
   *
   * @since 1.34
   */
  export enum ComparisonMicroChartViewType {
    /**
     * Titles and values are displayed above the bars.
     */
    Normal = "Normal",
    /**
     * Behavior changes based on the current width of the chart. `Normal` view is used for charts up to 192px
     * wide, and `Wide` is used for wider charts.
     */
    Responsive = "Responsive",
    /**
     * Titles and values are displayed in the same line with the bars.
     */
    Wide = "Wide",
  }
  /**
   * Lists the views of the delta micro chart concerning the position of titles.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'DeltaMicroChartViewType'.
   *
   * @since 1.61
   */
  export enum DeltaMicroChartViewType {
    /**
     * Titles are displayed above the bars.
     */
    Normal = "Normal",
    /**
     * Behavior changes based on the current width of the chart. `Normal` view is used for charts up to 192px
     * wide, and `Wide` is used for wider charts.
     */
    Responsive = "Responsive",
    /**
     * Titles are displayed in the same line with the bars.
     */
    Wide = "Wide",
  }
  /**
   * Alignment type for the microchart content.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'HorizontalAlignmentType'.
   *
   * @since 1.62
   */
  export enum HorizontalAlignmentType {
    /**
     * Center alignment.
     */
    Center = "Center",
    /**
     * Left alignment.
     */
    Left = "Left",
    /**
     * Right alignment.
     */
    Right = "Right",
  }
  /**
   * Type of the microchart line.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'LineType'.
   *
   * @since 1.60
   */
  export enum LineType {
    /**
     * Dashed line.
     */
    Dashed = "Dashed",
    /**
     * Dotted line.
     */
    Dotted = "Dotted",
    /**
     * Solid line.
     */
    Solid = "Solid",
  }
  /**
   * Colors to highlight certain UI chart elements.
   *
   * Instead of the `ValueState`, semantic colors must be defined by the application.
   *
   * This enum is part of the 'sap/suite/ui/microchart/library' module export and must be accessed by the
   * property 'MicroChartColorType'.
   * See:
   * 	{@link fiori:/how-to-use-semantic-colors/ Semantic Colors}
   *
   * @since 1.129
   */
  export enum MicroChartColorType {
    /**
     * Critical value color.
     */
    Critical = "Critical",
    /**
     * Bad value color.
     */
    Error = "Error",
    /**
     * Good value color.
     */
    Good = "Good",
    /**
     * Neutral value color.
     */
    Neutral = "Neutral",
    /**
     * None value color.
     */
    None = "None",
    /**
     * Sequence1 value colors.
     */
    Sequence1 = "Sequence1",
    /**
     * Sequence10 value colors.
     */
    Sequence10 = "Sequence10",
    /**
     * Sequence11 value colors.
     */
    Sequence11 = "Sequence11",
    /**
     * Sequence12 value colors.
     */
    Sequence12 = "Sequence12",
    /**
     * Sequence2 value colors.
     */
    Sequence2 = "Sequence2",
    /**
     * Sequence3 value colors.
     */
    Sequence3 = "Sequence3",
    /**
     * Sequence4 value colors.
     */
    Sequence4 = "Sequence4",
    /**
     * Sequence5 value colors.
     */
    Sequence5 = "Sequence5",
    /**
     * Sequence6 value colors.
     */
    Sequence6 = "Sequence6",
    /**
     * Sequence7 value colors.
     */
    Sequence7 = "Sequence7",
    /**
     * Sequence8 value colors.
     */
    Sequence8 = "Sequence8",
    /**
     * Sequence9 value colors.
     */
    Sequence9 = "Sequence9",
  }
}

declare module "sap/suite/ui/microchart/AreaMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import AreaMicroChartItem from "sap/suite/ui/microchart/AreaMicroChartItem";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import AreaMicroChartLabel from "sap/suite/ui/microchart/AreaMicroChartLabel";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  import { AreaMicroChartViewType } from "sap/suite/ui/microchart/library";

  /**
   *
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.34
   */
  export default class AreaMicroChart extends Control {
    /**
     * Constructor for a new AreaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AreaMicroChartSettings
    );
    /**
     * Constructor for a new AreaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AreaMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.AreaMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AreaMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.AreaMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some line to the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addLine(
      /**
       * The line to add; if empty, nothing is inserted
       */
      oLine: AreaMicroChartItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.AreaMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.AreaMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.AreaMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.AreaMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.AreaMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.AreaMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getChart chart} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindChart(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getLines lines} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindLines(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getTarget target} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindTarget(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys the chart in the aggregation {@link #getChart chart}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyChart(): this;
    /**
     * Destroys the firstXLabel in the aggregation {@link #getFirstXLabel firstXLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFirstXLabel(): this;
    /**
     * Destroys the firstYLabel in the aggregation {@link #getFirstYLabel firstYLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFirstYLabel(): this;
    /**
     * Destroys the innerMaxThreshold in the aggregation {@link #getInnerMaxThreshold innerMaxThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInnerMaxThreshold(): this;
    /**
     * Destroys the innerMinThreshold in the aggregation {@link #getInnerMinThreshold innerMinThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyInnerMinThreshold(): this;
    /**
     * Destroys the lastXLabel in the aggregation {@link #getLastXLabel lastXLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLastXLabel(): this;
    /**
     * Destroys the lastYLabel in the aggregation {@link #getLastYLabel lastYLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLastYLabel(): this;
    /**
     * Destroys all the lines in the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLines(): this;
    /**
     * Destroys the maxLabel in the aggregation {@link #getMaxLabel maxLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMaxLabel(): this;
    /**
     * Destroys the maxThreshold in the aggregation {@link #getMaxThreshold maxThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMaxThreshold(): this;
    /**
     * Destroys the minLabel in the aggregation {@link #getMinLabel minLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMinLabel(): this;
    /**
     * Destroys the minThreshold in the aggregation {@link #getMinThreshold minThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyMinThreshold(): this;
    /**
     * Destroys the target in the aggregation {@link #getTarget target}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTarget(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.AreaMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Enables x-values of all points are automatically indexed with numeric, equidistant values.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    enableXIndexing(
      /**
       * Flag to activate automatic index
       */
      useIndex: boolean
    ): void;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getChart chart}.
     *
     * The configuration of the actual values line. The color property defines the color of the line. Points
     * are rendered in the same sequence as in this aggregation.
     */
    getChart(): AreaMicroChartItem;
    /**
     * Gets current value of property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. If this property is set, semantic colors defined in AreaMicroChartItem
     * are ignored. As a result, colors of the palette are assigned to each line. When all the palette colors
     * are used up, assignment of the colors starts again from the beginning of the palette.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `colorPalette`
     */
    getColorPalette(): string[];
    /**
     * Gets content of aggregation {@link #getFirstXLabel firstXLabel}.
     *
     * The label on X axis for the first point of the chart.
     */
    getFirstXLabel(): AreaMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getFirstYLabel firstYLabel}.
     *
     * The label on Y axis for the first point of the chart.
     */
    getFirstYLabel(): AreaMicroChartLabel;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets content of aggregation {@link #getInnerMaxThreshold innerMaxThreshold}.
     *
     * The configuration of the upper line of the inner threshold area. The color property defines the color
     * of the area between inner thresholds. For rendering of the inner threshold area, both innerMaxThreshold
     * and innerMinThreshold aggregations must be defined. Points are rendered in the same sequence as in this
     * aggregation.
     */
    getInnerMaxThreshold(): AreaMicroChartItem;
    /**
     * Gets content of aggregation {@link #getInnerMinThreshold innerMinThreshold}.
     *
     * The configuration of the bottom line of the inner threshold area. The color property is ignored. For
     * rendering of the inner threshold area, both innerMaxThreshold and innerMinThreshold aggregations must
     * be defined. Points are rendered in the same sequence as in this aggregation.
     */
    getInnerMinThreshold(): AreaMicroChartItem;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets content of aggregation {@link #getLastXLabel lastXLabel}.
     *
     * The label on X axis for the last point of the chart.
     */
    getLastXLabel(): AreaMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getLastYLabel lastYLabel}.
     *
     * The label on Y axis for the last point of the chart.
     */
    getLastYLabel(): AreaMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getLines lines}.
     *
     * The set of lines.
     */
    getLines(): AreaMicroChartItem[];
    /**
     * Gets content of aggregation {@link #getMaxLabel maxLabel}.
     *
     * The label for the maximum point of the chart.
     */
    getMaxLabel(): AreaMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getMaxThreshold maxThreshold}.
     *
     * The configuration of the max threshold area. The color property defines the color of the area above the
     * max threshold line. Points are rendered in the same sequence as in this aggregation.
     */
    getMaxThreshold(): AreaMicroChartItem;
    /**
     * Gets current value of property {@link #getMaxXValue maxXValue}.
     *
     * If this property is set, it indicates the value the X-axis ends with.
     *
     *
     * @returns Value of property `maxXValue`
     */
    getMaxXValue(): float;
    /**
     * Gets current value of property {@link #getMaxYValue maxYValue}.
     *
     * If this property is set it indicates the value X axis ends with.
     *
     *
     * @returns Value of property `maxYValue`
     */
    getMaxYValue(): float;
    /**
     * Gets content of aggregation {@link #getMinLabel minLabel}.
     *
     * The label for the minimum point of the chart.
     */
    getMinLabel(): AreaMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getMinThreshold minThreshold}.
     *
     * The configuration of the min threshold area. The color property defines the color of the area below the
     * min threshold line. Points are rendered in the same sequence as in this aggregation.
     */
    getMinThreshold(): AreaMicroChartItem;
    /**
     * Gets current value of property {@link #getMinXValue minXValue}.
     *
     * If this property is set it indicates the value X axis ends with.
     *
     *
     * @returns Value of property `minXValue`
     */
    getMinXValue(): float;
    /**
     * Gets current value of property {@link #getMinYValue minYValue}.
     *
     * If this property is set it indicates the value X axis ends with.
     *
     *
     * @returns Value of property `minYValue`
     */
    getMinYValue(): float;
    /**
     * Gets current value of property {@link #getShowLabel showLabel}.
     *
     * Determines if the labels are displayed or not.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLabel`
     */
    getShowLabel(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets content of aggregation {@link #getTarget target}.
     *
     * The configuration of the target values line. The color property defines the color of the line. Points
     * are rendered in the same sequence as in this aggregation.
     */
    getTarget(): AreaMicroChartItem;
    /**
     * Gets current value of property {@link #getView view}.
     *
     * The view of the chart.
     *
     * Default value is `"Normal"`.
     *
     *
     * @returns Value of property `view`
     */
    getView(): AreaMicroChartViewType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.AreaMicroChartItem` in the aggregation {@link #getLines lines}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfLine(
      /**
       * The line whose index is looked for
       */
      oLine: AreaMicroChartItem
    ): int;
    /**
     * Inserts a line into the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertLine(
      /**
       * The line to insert; if empty, nothing is inserted
       */
      oLine: AreaMicroChartItem,
      /**
       * The `0`-based index the line should be inserted at; for a negative value of `iIndex`, the line is inserted
       * at position 0; for a value greater than the current size of the aggregation, the line is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getLines lines}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllLines(): AreaMicroChartItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a line from the aggregation {@link #getLines lines}.
     *
     *
     * @returns The removed line or `null`
     */
    removeLine(
      /**
       * The line to remove or its index or id
       */
      vLine: int | string | AreaMicroChartItem
    ): AreaMicroChartItem | null;
    /**
     * Sets the aggregated {@link #getChart chart}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChart(
      /**
       * The chart to set
       */
      oChart: AreaMicroChartItem
    ): this;
    /**
     * Sets a new value for property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. If this property is set, semantic colors defined in AreaMicroChartItem
     * are ignored. As a result, colors of the palette are assigned to each line. When all the palette colors
     * are used up, assignment of the colors starts again from the beginning of the palette.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorPalette(
      /**
       * New value for property `colorPalette`
       */
      sColorPalette?: string[]
    ): this;
    /**
     * Sets the aggregated {@link #getFirstXLabel firstXLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstXLabel(
      /**
       * The firstXLabel to set
       */
      oFirstXLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getFirstYLabel firstYLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstYLabel(
      /**
       * The firstYLabel to set
       */
      oFirstYLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getInnerMaxThreshold innerMaxThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInnerMaxThreshold(
      /**
       * The innerMaxThreshold to set
       */
      oInnerMaxThreshold: AreaMicroChartItem
    ): this;
    /**
     * Sets the aggregated {@link #getInnerMinThreshold innerMinThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInnerMinThreshold(
      /**
       * The innerMinThreshold to set
       */
      oInnerMinThreshold: AreaMicroChartItem
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getLastXLabel lastXLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLastXLabel(
      /**
       * The lastXLabel to set
       */
      oLastXLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getLastYLabel lastYLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLastYLabel(
      /**
       * The lastYLabel to set
       */
      oLastYLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getMaxLabel maxLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxLabel(
      /**
       * The maxLabel to set
       */
      oMaxLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getMaxThreshold maxThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxThreshold(
      /**
       * The maxThreshold to set
       */
      oMaxThreshold: AreaMicroChartItem
    ): this;
    /**
     * Property setter for the Max X value
     */
    setMaxXValue(
      /**
       * new value Max X
       */
      value: float,
      /**
       * Suppress in validate
       */
      bSuppressInvalidate: boolean
    ): void;
    /**
     * Property setter for the Max Y value
     */
    setMaxYValue(
      /**
       * new value Max Y
       */
      value: float,
      /**
       * Suppress in validate
       */
      bSuppressInvalidate: boolean
    ): void;
    /**
     * Sets the aggregated {@link #getMinLabel minLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinLabel(
      /**
       * The minLabel to set
       */
      oMinLabel: AreaMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getMinThreshold minThreshold}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinThreshold(
      /**
       * The minThreshold to set
       */
      oMinThreshold: AreaMicroChartItem
    ): this;
    /**
     * Property setter for the Min X value
     */
    setMinXValue(
      /**
       * new value Min X
       */
      value: float,
      /**
       * Suppress in validate
       */
      bSuppressInvalidate: boolean
    ): void;
    /**
     * Property setter for the Min Y value
     */
    setMinYValue(
      /**
       * new value Min Y
       */
      value: float,
      /**
       * Suppress in validate
       */
      bSuppressInvalidate: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getShowLabel showLabel}.
     *
     * Determines if the labels are displayed or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLabel(
      /**
       * New value for property `showLabel`
       */
      bShowLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets the aggregated {@link #getTarget target}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTarget(
      /**
       * The target to set
       */
      oTarget: AreaMicroChartItem
    ): this;
    /**
     * Sets a new value for property {@link #getView view}.
     *
     * The view of the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Normal"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setView(
      /**
       * New value for property `view`
       */
      sView?: AreaMicroChartViewType | keyof typeof AreaMicroChartViewType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getChart chart} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindChart(): this;
    /**
     * Unbinds aggregation {@link #getLines lines} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindLines(): this;
    /**
     * Unbinds aggregation {@link #getTarget target} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindTarget(): this;
  }
  /**
   * Describes the settings that can be provided to the AreaMicroChart constructor.
   */
  export interface $AreaMicroChartSettings extends $ControlSettings {
    /**
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set, it indicates the value the X-axis ends with.
     */
    maxXValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set it indicates the value X axis ends with.
     */
    minXValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set it indicates the value X axis ends with.
     */
    maxYValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set it indicates the value X axis ends with.
     */
    minYValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The view of the chart.
     */
    view?:
      | (AreaMicroChartViewType | keyof typeof AreaMicroChartViewType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The color palette for the chart. If this property is set, semantic colors defined in AreaMicroChartItem
     * are ignored. As a result, colors of the palette are assigned to each line. When all the palette colors
     * are used up, assignment of the colors starts again from the beginning of the palette.
     */
    colorPalette?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the labels are displayed or not.
     */
    showLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The configuration of the actual values line. The color property defines the color of the line. Points
     * are rendered in the same sequence as in this aggregation.
     */
    chart?: AreaMicroChartItem;

    /**
     * The configuration of the max threshold area. The color property defines the color of the area above the
     * max threshold line. Points are rendered in the same sequence as in this aggregation.
     */
    maxThreshold?: AreaMicroChartItem;

    /**
     * The configuration of the upper line of the inner threshold area. The color property defines the color
     * of the area between inner thresholds. For rendering of the inner threshold area, both innerMaxThreshold
     * and innerMinThreshold aggregations must be defined. Points are rendered in the same sequence as in this
     * aggregation.
     */
    innerMaxThreshold?: AreaMicroChartItem;

    /**
     * The configuration of the bottom line of the inner threshold area. The color property is ignored. For
     * rendering of the inner threshold area, both innerMaxThreshold and innerMinThreshold aggregations must
     * be defined. Points are rendered in the same sequence as in this aggregation.
     */
    innerMinThreshold?: AreaMicroChartItem;

    /**
     * The configuration of the min threshold area. The color property defines the color of the area below the
     * min threshold line. Points are rendered in the same sequence as in this aggregation.
     */
    minThreshold?: AreaMicroChartItem;

    /**
     * The configuration of the target values line. The color property defines the color of the line. Points
     * are rendered in the same sequence as in this aggregation.
     */
    target?: AreaMicroChartItem;

    /**
     * The label on X axis for the first point of the chart.
     */
    firstXLabel?: AreaMicroChartLabel;

    /**
     * The label on Y axis for the first point of the chart.
     */
    firstYLabel?: AreaMicroChartLabel;

    /**
     * The label on X axis for the last point of the chart.
     */
    lastXLabel?: AreaMicroChartLabel;

    /**
     * The label on Y axis for the last point of the chart.
     */
    lastYLabel?: AreaMicroChartLabel;

    /**
     * The label for the maximum point of the chart.
     */
    maxLabel?: AreaMicroChartLabel;

    /**
     * The label for the minimum point of the chart.
     */
    minLabel?: AreaMicroChartLabel;

    /**
     * The set of lines.
     */
    lines?:
      | AreaMicroChartItem[]
      | AreaMicroChartItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AreaMicroChart#press event.
   */
  export interface AreaMicroChart$PressEventParameters {}

  /**
   * Event object of the AreaMicroChart#press event.
   */
  export type AreaMicroChart$PressEvent = Event<
    AreaMicroChart$PressEventParameters,
    AreaMicroChart
  >;
}

declare module "sap/suite/ui/microchart/AreaMicroChartItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import AreaMicroChartPoint from "sap/suite/ui/microchart/AreaMicroChartPoint";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Graphical representation of the area micro chart regarding the value lines, the thresholds, and the target
   * values.
   *
   * @since 1.34
   */
  export default class AreaMicroChartItem extends UI5Element {
    /**
     * The configuration of the graphic element on the chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartItemSettings
    );
    /**
     * The configuration of the graphic element on the chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartItemSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.AreaMicroChartItem with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AreaMicroChartItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.AreaMicroChartItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some point to the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPoint(
      /**
       * The point to add; if empty, nothing is inserted
       */
      oPoint: AreaMicroChartPoint
    ): this;
    /**
     * Binds aggregation {@link #getPoints points} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindPoints(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the points in the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPoints(): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets content of aggregation {@link #getPoints points}.
     *
     * The set of points for this graphic element.
     */
    getPoints(): AreaMicroChartPoint[];
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * The line title.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Checks for the provided `sap.suite.ui.microchart.AreaMicroChartPoint` in the aggregation {@link #getPoints points}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPoint(
      /**
       * The point whose index is looked for
       */
      oPoint: AreaMicroChartPoint
    ): int;
    /**
     * Inserts a point into the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPoint(
      /**
       * The point to insert; if empty, nothing is inserted
       */
      oPoint: AreaMicroChartPoint,
      /**
       * The `0`-based index the point should be inserted at; for a negative value of `iIndex`, the point is inserted
       * at position 0; for a value greater than the current size of the aggregation, the point is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getPoints points}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPoints(): AreaMicroChartPoint[];
    /**
     * Removes a point from the aggregation {@link #getPoints points}.
     *
     *
     * @returns The removed point or `null`
     */
    removePoint(
      /**
       * The point to remove or its index or id
       */
      vPoint: int | string | AreaMicroChartPoint
    ): AreaMicroChartPoint | null;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * The line title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Unbinds aggregation {@link #getPoints points} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindPoints(): this;
  }
  /**
   * Describes the settings that can be provided to the AreaMicroChartItem constructor.
   */
  export interface $AreaMicroChartItemSettings extends $ElementSettings {
    /**
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The line title.
     */
    title?: string | PropertyBindingInfo;

    /**
     * The set of points for this graphic element.
     */
    points?:
      | AreaMicroChartPoint[]
      | AreaMicroChartPoint
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/AreaMicroChartLabel" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Displays or hides the labels for start and end dates, start and end values, and minimum and maximum values.
   *
   * @since 1.34
   */
  export default class AreaMicroChartLabel extends UI5Element {
    /**
     * Constructor for a new AreaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartLabelSettings
    );
    /**
     * Constructor for a new AreaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartLabelSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.AreaMicroChartLabel with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AreaMicroChartLabel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.AreaMicroChartLabel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * The line title.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * The line title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AreaMicroChartLabel constructor.
   */
  export interface $AreaMicroChartLabelSettings extends $ElementSettings {
    /**
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The line title.
     */
    label?: string | PropertyBindingInfo;
  }
}

declare module "sap/suite/ui/microchart/AreaMicroChartPoint" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the data for the point.
   *
   * @since 1.34
   */
  export default class AreaMicroChartPoint extends UI5Element {
    /**
     * This control contains data for the point.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartPointSettings
    );
    /**
     * This control contains data for the point.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AreaMicroChartPointSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.AreaMicroChartPoint with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AreaMicroChartPoint>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.AreaMicroChartPoint.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getX x}.
     *
     * X value for the given point.
     *
     *
     * @returns Value of property `x`
     */
    getX(): float;
    /**
     * Returns the x value. It returns 'undefined', if the x property was not set or an invalid number was set.
     *
     *
     * @returns The x-value, or undefined if the value set was invalid
     */
    getXValue(): float;
    /**
     * Gets current value of property {@link #getY y}.
     *
     * Y value for the given point.
     *
     *
     * @returns Value of property `y`
     */
    getY(): float;
    /**
     * Returns the y value. It returns 'undefined', if the y property was not set or an invalid number was set.
     *
     *
     * @returns The y-value, or undefined if the value set was invalid
     */
    getYValue(): float;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * X value for the given point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX?: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * Y value for the given point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AreaMicroChartPoint constructor.
   */
  export interface $AreaMicroChartPointSettings extends $ElementSettings {
    /**
     * X value for the given point.
     */
    x?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Y value for the given point.
     */
    y?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/BulletMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import BulletMicroChartData from "sap/suite/ui/microchart/BulletMicroChartData";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    BulletMicroChartModeType,
    CommonBackgroundType,
  } from "sap/suite/ui/microchart/library";

  import { Size } from "sap/m/library";

  /**
   * Displays a colored horizontal bar representing a current value on top of a background bar representing
   * the compared value. The vertical bars can represent the numeric values, the scaling factors, the thresholds,
   * and the target values. This control replaces the deprecated sap.suite.ui.commons.BulletChart.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.34
   */
  export default class BulletMicroChart extends Control {
    /**
     * Constructor for a new BulletMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BulletMicroChartSettings
    );
    /**
     * Constructor for a new BulletMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BulletMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.BulletMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BulletMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.BulletMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some threshold to the aggregation {@link #getThresholds thresholds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addThreshold(
      /**
       * The threshold to add; if empty, nothing is inserted
       */
      oThreshold: BulletMicroChartData
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.BulletMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.BulletMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.BulletMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.BulletMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.BulletMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.BulletMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getActual actual} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindActual(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getThresholds thresholds} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindThresholds(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys the actual in the aggregation {@link #getActual actual}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyActual(): this;
    /**
     * Destroys all the thresholds in the aggregation {@link #getThresholds thresholds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyThresholds(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.BulletMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getActual actual}.
     *
     * Actual data of the BulletMicroChart.
     */
    getActual(): BulletMicroChartData;
    /**
     * Gets current value of property {@link #getActualValueLabel actualValueLabel}.
     *
     * If set, displays a specified label instead of the numeric actual value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `actualValueLabel`
     */
    getActualValueLabel(): string;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDeltaValueLabel deltaValueLabel}.
     *
     * If set, displays a specified label instead of the calculated numeric delta value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `deltaValueLabel`
     */
    getDeltaValueLabel(): string;
    /**
     * Gets current value of property {@link #getForecastValue forecastValue}.
     *
     * The forecast value that is displayed in Actual mode only. If set, the forecast value bar appears in the
     * background of the actual value bar.
     *
     *
     * @returns Value of property `forecastValue`
     */
    getForecastValue(): float;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets current value of property {@link #getMaxValue maxValue}.
     *
     * The maximum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     *
     *
     * @returns Value of property `maxValue`
     */
    getMaxValue(): float;
    /**
     * Gets current value of property {@link #getMinValue minValue}.
     *
     * The minimum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     *
     *
     * @returns Value of property `minValue`
     */
    getMinValue(): float;
    /**
     * Gets current value of property {@link #getMode mode}.
     *
     * The mode of displaying the actual value itself or the delta between the actual value and the target value.
     * If not set, the actual value is displayed.
     *
     * Default value is `"Actual"`.
     *
     *
     * @returns Value of property `mode`
     */
    getMode(): BulletMicroChartModeType;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * The scaling suffix that is added to all values.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Gets current value of property {@link #getScaleColor scaleColor}.
     *
     * The background color of the scale. The theming is enabled only for the default value of this property.
     *
     * Default value is `"MediumLight"`.
     *
     *
     * @returns Value of property `scaleColor`
     */
    getScaleColor(): CommonBackgroundType;
    /**
     * Gets current value of property {@link #getShowActualValue showActualValue}.
     *
     * If set to true, shows the numeric actual value. This property works in Actual mode only.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showActualValue`
     */
    getShowActualValue(): boolean;
    /**
     * Gets current value of property {@link #getShowActualValueInDeltaMode showActualValueInDeltaMode}.
     *
     * If set to true, shows the numeric actual value and possibly hides the delta value, if showDeltaValue
     * is set to true. This property works in Delta mode only and has priority over showDeltaValue.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showActualValueInDeltaMode`
     */
    getShowActualValueInDeltaMode(): boolean;
    /**
     * Gets current value of property {@link #getShowDeltaValue showDeltaValue}.
     *
     * If set to true, shows the calculated delta value instead of the numeric actual value regardless of the
     * showActualValue setting. This property works in Delta mode only.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDeltaValue`
     */
    getShowDeltaValue(): boolean;
    /**
     * Gets current value of property {@link #getShowTargetValue showTargetValue}.
     *
     * If set to true, shows the numeric target value.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTargetValue`
     */
    getShowTargetValue(): boolean;
    /**
     * Gets current value of property {@link #getShowThresholds showThresholds}.
     *
     * If set to true, shows the threshold markers.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showThresholds`
     */
    getShowThresholds(): boolean;
    /**
     * Gets current value of property {@link #getShowValueMarker showValueMarker}.
     *
     * If set to true, shows the value marker.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showValueMarker`
     */
    getShowValueMarker(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getSmallRangeAllowed smallRangeAllowed}.
     *
     * If set to True, the control allows small value ranges for comparing different values. The minimum value
     * of the value range is not taken as 0.
     *
     * Default value is `false`.
     *
     * @since 1.86
     *
     * @returns Value of property `smallRangeAllowed`
     */
    getSmallRangeAllowed(): boolean;
    /**
     * Gets current value of property {@link #getTargetValue targetValue}.
     *
     * The target value that is displayed as a black vertical bar.
     *
     *
     * @returns Value of property `targetValue`
     */
    getTargetValue(): float;
    /**
     * Gets current value of property {@link #getTargetValueLabel targetValueLabel}.
     *
     * If set, displays a specified label instead of the numeric target value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `targetValueLabel`
     */
    getTargetValueLabel(): string;
    /**
     * Gets content of aggregation {@link #getThresholds thresholds}.
     *
     * Threshold data of the BulletMicroChart.
     */
    getThresholds(): BulletMicroChartData[];
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.BulletMicroChartData` in the aggregation {@link #getThresholds thresholds}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfThreshold(
      /**
       * The threshold whose index is looked for
       */
      oThreshold: BulletMicroChartData
    ): int;
    /**
     * Inserts a threshold into the aggregation {@link #getThresholds thresholds}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertThreshold(
      /**
       * The threshold to insert; if empty, nothing is inserted
       */
      oThreshold: BulletMicroChartData,
      /**
       * The `0`-based index the threshold should be inserted at; for a negative value of `iIndex`, the threshold
       * is inserted at position 0; for a value greater than the current size of the aggregation, the threshold
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getThresholds thresholds}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllThresholds(): BulletMicroChartData[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a threshold from the aggregation {@link #getThresholds thresholds}.
     *
     *
     * @returns The removed threshold or `null`
     */
    removeThreshold(
      /**
       * The threshold to remove or its index or id
       */
      vThreshold: int | string | BulletMicroChartData
    ): BulletMicroChartData | null;
    /**
     * Sets the aggregated {@link #getActual actual}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActual(
      /**
       * The actual to set
       */
      oActual: BulletMicroChartData
    ): this;
    /**
     * Sets a new value for property {@link #getActualValueLabel actualValueLabel}.
     *
     * If set, displays a specified label instead of the numeric actual value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActualValueLabel(
      /**
       * New value for property `actualValueLabel`
       */
      sActualValueLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDeltaValueLabel deltaValueLabel}.
     *
     * If set, displays a specified label instead of the calculated numeric delta value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaValueLabel(
      /**
       * New value for property `deltaValueLabel`
       */
      sDeltaValueLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getForecastValue forecastValue}.
     *
     * The forecast value that is displayed in Actual mode only. If set, the forecast value bar appears in the
     * background of the actual value bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setForecastValue(
      /**
       * New value for property `forecastValue`
       */
      fForecastValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxValue maxValue}.
     *
     * The maximum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxValue(
      /**
       * New value for property `maxValue`
       */
      fMaxValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMinValue minValue}.
     *
     * The minimum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinValue(
      /**
       * New value for property `minValue`
       */
      fMinValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMode mode}.
     *
     * The mode of displaying the actual value itself or the delta between the actual value and the target value.
     * If not set, the actual value is displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Actual"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMode(
      /**
       * New value for property `mode`
       */
      sMode?: BulletMicroChartModeType | keyof typeof BulletMicroChartModeType
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * The scaling suffix that is added to all values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getScaleColor scaleColor}.
     *
     * The background color of the scale. The theming is enabled only for the default value of this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"MediumLight"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScaleColor(
      /**
       * New value for property `scaleColor`
       */
      sScaleColor?: CommonBackgroundType | keyof typeof CommonBackgroundType
    ): this;
    /**
     * Sets a new value for property {@link #getShowActualValue showActualValue}.
     *
     * If set to true, shows the numeric actual value. This property works in Actual mode only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowActualValue(
      /**
       * New value for property `showActualValue`
       */
      bShowActualValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowActualValueInDeltaMode showActualValueInDeltaMode}.
     *
     * If set to true, shows the numeric actual value and possibly hides the delta value, if showDeltaValue
     * is set to true. This property works in Delta mode only and has priority over showDeltaValue.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowActualValueInDeltaMode(
      /**
       * New value for property `showActualValueInDeltaMode`
       */
      bShowActualValueInDeltaMode?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowDeltaValue showDeltaValue}.
     *
     * If set to true, shows the calculated delta value instead of the numeric actual value regardless of the
     * showActualValue setting. This property works in Delta mode only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDeltaValue(
      /**
       * New value for property `showDeltaValue`
       */
      bShowDeltaValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTargetValue showTargetValue}.
     *
     * If set to true, shows the numeric target value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTargetValue(
      /**
       * New value for property `showTargetValue`
       */
      bShowTargetValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowThresholds showThresholds}.
     *
     * If set to true, shows the threshold markers.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowThresholds(
      /**
       * New value for property `showThresholds`
       */
      bShowThresholds?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueMarker showValueMarker}.
     *
     * If set to true, shows the value marker.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueMarker(
      /**
       * New value for property `showValueMarker`
       */
      bShowValueMarker?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getSmallRangeAllowed smallRangeAllowed}.
     *
     * If set to True, the control allows small value ranges for comparing different values. The minimum value
     * of the value range is not taken as 0.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.86
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSmallRangeAllowed(
      /**
       * New value for property `smallRangeAllowed`
       */
      bSmallRangeAllowed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTargetValue targetValue}.
     *
     * The target value that is displayed as a black vertical bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTargetValue(
      /**
       * New value for property `targetValue`
       */
      fTargetValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTargetValueLabel targetValueLabel}.
     *
     * If set, displays a specified label instead of the numeric target value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTargetValueLabel(
      /**
       * New value for property `targetValueLabel`
       */
      sTargetValueLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getActual actual} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindActual(): this;
    /**
     * Unbinds aggregation {@link #getThresholds thresholds} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindThresholds(): this;
  }
  /**
   * Describes the settings that can be provided to the BulletMicroChart constructor.
   */
  export interface $BulletMicroChartSettings extends $ControlSettings {
    /**
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The mode of displaying the actual value itself or the delta between the actual value and the target value.
     * If not set, the actual value is displayed.
     */
    mode?:
      | (BulletMicroChartModeType | keyof typeof BulletMicroChartModeType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The scaling suffix that is added to all values.
     */
    scale?: string | PropertyBindingInfo;

    /**
     * The forecast value that is displayed in Actual mode only. If set, the forecast value bar appears in the
     * background of the actual value bar.
     */
    forecastValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The target value that is displayed as a black vertical bar.
     */
    targetValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The minimum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     */
    minValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The maximum scale value for the bar chart used for defining a fixed size of the scale in different instances
     * of this control.
     */
    maxValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the numeric actual value. This property works in Actual mode only.
     */
    showActualValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the calculated delta value instead of the numeric actual value regardless of the
     * showActualValue setting. This property works in Delta mode only.
     */
    showDeltaValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the numeric actual value and possibly hides the delta value, if showDeltaValue
     * is set to true. This property works in Delta mode only and has priority over showDeltaValue.
     */
    showActualValueInDeltaMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the numeric target value.
     */
    showTargetValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the value marker.
     */
    showValueMarker?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, shows the threshold markers.
     */
    showThresholds?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set, displays a specified label instead of the numeric actual value.
     */
    actualValueLabel?: string | PropertyBindingInfo;

    /**
     * If set, displays a specified label instead of the calculated numeric delta value.
     */
    deltaValueLabel?: string | PropertyBindingInfo;

    /**
     * If set, displays a specified label instead of the numeric target value.
     */
    targetValueLabel?: string | PropertyBindingInfo;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The background color of the scale. The theming is enabled only for the default value of this property.
     */
    scaleColor?:
      | (CommonBackgroundType | keyof typeof CommonBackgroundType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed or by the width and height property.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to True, the control allows small value ranges for comparing different values. The minimum value
     * of the value range is not taken as 0.
     *
     * @since 1.86
     */
    smallRangeAllowed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Actual data of the BulletMicroChart.
     */
    actual?: BulletMicroChartData;

    /**
     * Threshold data of the BulletMicroChart.
     */
    thresholds?:
      | BulletMicroChartData[]
      | BulletMicroChartData
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the BulletMicroChart#press event.
   */
  export interface BulletMicroChart$PressEventParameters {}

  /**
   * Event object of the BulletMicroChart#press event.
   */
  export type BulletMicroChart$PressEvent = Event<
    BulletMicroChart$PressEventParameters,
    BulletMicroChart
  >;
}

declare module "sap/suite/ui/microchart/BulletMicroChartData" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ValueColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the thresholds data.
   *
   * @since 1.34
   */
  export default class BulletMicroChartData extends UI5Element {
    /**
     * Constructor for a new BulletMicroChartData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BulletMicroChartDataSettings
    );
    /**
     * Constructor for a new BulletMicroChartData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BulletMicroChartDataSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.BulletMicroChartData with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BulletMicroChartData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.BulletMicroChartData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The semantic color of the actual value.
     *
     * Default value is `"Neutral"`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): ValueColor;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The actual value.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The semantic color of the actual value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Neutral"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: ValueColor | keyof typeof ValueColor
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The actual value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BulletMicroChartData constructor.
   */
  export interface $BulletMicroChartDataSettings extends $ElementSettings {
    /**
     * The actual value.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic color of the actual value.
     */
    color?:
      | (ValueColor | keyof typeof ValueColor)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/ColumnMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import ColumnMicroChartData from "sap/suite/ui/microchart/ColumnMicroChartData";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ColumnMicroChartLabel from "sap/suite/ui/microchart/ColumnMicroChartLabel";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  /**
   * Compares different values which are represented as vertical bars. This control replaces the deprecated
   * sap.suite.ui.commons.ColumnMicroChart.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.34
   */
  export default class ColumnMicroChart extends Control {
    /**
     * Constructor for a new ColumnMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnMicroChartSettings
    );
    /**
     * Constructor for a new ColumnMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.ColumnMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.ColumnMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some column to the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add; if empty, nothing is inserted
       */
      oColumn: ColumnMicroChartData
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ColumnMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ColumnMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ColumnMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ColumnMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getColumns columns} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindColumns(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the columns in the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColumns(): this;
    /**
     * Destroys the leftBottomLabel in the aggregation {@link #getLeftBottomLabel leftBottomLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLeftBottomLabel(): this;
    /**
     * Destroys the leftTopLabel in the aggregation {@link #getLeftTopLabel leftTopLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLeftTopLabel(): this;
    /**
     * Destroys the rightBottomLabel in the aggregation {@link #getRightBottomLabel rightBottomLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRightBottomLabel(): this;
    /**
     * Destroys the rightTopLabel in the aggregation {@link #getRightTopLabel rightTopLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRightTopLabel(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAllowColumnLabels allowColumnLabels}.
     *
     * If set to true and there is enough space, top labels of the chart are hidden and labels for each column
     * are shown instead.
     *
     * @since 1.60.0
     *
     * @returns Value of property `allowColumnLabels`
     */
    getAllowColumnLabels(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getColumns columns}.
     *
     * The column chart data.
     */
    getColumns(): ColumnMicroChartData[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size, width and height properties are ignored in this case.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60.0. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets content of aggregation {@link #getLeftBottomLabel leftBottomLabel}.
     *
     * The label on the left bottom corner of the chart.
     */
    getLeftBottomLabel(): ColumnMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getLeftTopLabel leftTopLabel}.
     *
     * The label on the left top corner of the chart.
     */
    getLeftTopLabel(): ColumnMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getRightBottomLabel rightBottomLabel}.
     *
     * The label on the right bottom corner of the chart.
     */
    getRightBottomLabel(): ColumnMicroChartLabel;
    /**
     * Gets content of aggregation {@link #getRightTopLabel rightTopLabel}.
     *
     * The label on the right top corner of the chart.
     */
    getRightTopLabel(): ColumnMicroChartLabel;
    /**
     * Gets current value of property {@link #getShowBottomLabels showBottomLabels}.
     *
     * If this property is set to `false`, both bottom labels are hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showBottomLabels`
     */
    getShowBottomLabels(): boolean;
    /**
     * Gets current value of property {@link #getShowTopLabels showTopLabels}.
     *
     * If this property is set to `false`, both top labels are hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTopLabels`
     */
    getShowTopLabels(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the column micro chart is included.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.ColumnMicroChartData` in the aggregation {@link #getColumns columns}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColumn(
      /**
       * The column whose index is looked for
       */
      oColumn: ColumnMicroChartData
    ): int;
    /**
     * Inserts a column into the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColumn(
      /**
       * The column to insert; if empty, nothing is inserted
       */
      oColumn: ColumnMicroChartData,
      /**
       * The `0`-based index the column should be inserted at; for a negative value of `iIndex`, the column is
       * inserted at position 0; for a value greater than the current size of the aggregation, the column is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getColumns columns}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColumns(): ColumnMicroChartData[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a column from the aggregation {@link #getColumns columns}.
     *
     *
     * @returns The removed column or `null`
     */
    removeColumn(
      /**
       * The column to remove or its index or id
       */
      vColumn: int | string | ColumnMicroChartData
    ): ColumnMicroChartData | null;
    /**
     * Sets a new value for property {@link #getAllowColumnLabels allowColumnLabels}.
     *
     * If set to true and there is enough space, top labels of the chart are hidden and labels for each column
     * are shown instead.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllowColumnLabels(
      /**
       * New value for property `allowColumnLabels`
       */
      bAllowColumnLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size, width and height properties are ignored in this case.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60.0. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getLeftBottomLabel leftBottomLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeftBottomLabel(
      /**
       * The leftBottomLabel to set
       */
      oLeftBottomLabel: ColumnMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getLeftTopLabel leftTopLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeftTopLabel(
      /**
       * The leftTopLabel to set
       */
      oLeftTopLabel: ColumnMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getRightBottomLabel rightBottomLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRightBottomLabel(
      /**
       * The rightBottomLabel to set
       */
      oRightBottomLabel: ColumnMicroChartLabel
    ): this;
    /**
     * Sets the aggregated {@link #getRightTopLabel rightTopLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRightTopLabel(
      /**
       * The rightTopLabel to set
       */
      oRightTopLabel: ColumnMicroChartLabel
    ): this;
    /**
     * Sets a new value for property {@link #getShowBottomLabels showBottomLabels}.
     *
     * If this property is set to `false`, both bottom labels are hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowBottomLabels(
      /**
       * New value for property `showBottomLabels`
       */
      bShowBottomLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTopLabels showTopLabels}.
     *
     * If this property is set to `false`, both top labels are hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTopLabels(
      /**
       * New value for property `showTopLabels`
       */
      bShowTopLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the column micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getColumns columns} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindColumns(): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnMicroChart constructor.
   */
  export interface $ColumnMicroChartSettings extends $ControlSettings {
    /**
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the column micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size, width and height properties are ignored in this case.
     *
     * @since 1.38.0
     * @deprecated As of version 1.60.0. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `false`, both top labels are hidden.
     */
    showTopLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `false`, both bottom labels are hidden.
     */
    showBottomLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true and there is enough space, top labels of the chart are hidden and labels for each column
     * are shown instead.
     *
     * * @since 1.60.0
     */
    allowColumnLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The column chart data.
     */
    columns?:
      | ColumnMicroChartData[]
      | ColumnMicroChartData
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * The label on the left top corner of the chart.
     */
    leftTopLabel?: ColumnMicroChartLabel;

    /**
     * The label on the right top corner of the chart.
     */
    rightTopLabel?: ColumnMicroChartLabel;

    /**
     * The label on the left bottom corner of the chart.
     */
    leftBottomLabel?: ColumnMicroChartLabel;

    /**
     * The label on the right bottom corner of the chart.
     */
    rightBottomLabel?: ColumnMicroChartLabel;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ColumnMicroChart#press event.
   */
  export interface ColumnMicroChart$PressEventParameters {}

  /**
   * Event object of the ColumnMicroChart#press event.
   */
  export type ColumnMicroChart$PressEvent = Event<
    ColumnMicroChart$PressEventParameters,
    ColumnMicroChart
  >;
}

declare module "sap/suite/ui/microchart/ColumnMicroChartData" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the column chart data.
   *
   * @since 1.34
   */
  export default class ColumnMicroChartData extends UI5Element {
    /**
     * Constructor for a new ColumnMicroChartData control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnMicroChartDataSettings
    );
    /**
     * Constructor for a new ColumnMicroChartData control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnMicroChartDataSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.ColumnMicroChartData with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnMicroChartData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.ColumnMicroChartData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChartData`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ColumnMicroChartData` itself.
     *
     * The event is fired when the user chooses the column data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ColumnMicroChartData`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChartData`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ColumnMicroChartData` itself.
     *
     * The event is fired when the user chooses the column data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ColumnMicroChartData`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.ColumnMicroChartData`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * Overrides the value with a string that is shown when used in combination with {@link sap.suite.ui.microchart.ColumnMicroChart }
     * `allowColumnLabels`.
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): string;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * The line title.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The actual value.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * Overrides the value with a string that is shown when used in combination with {@link sap.suite.ui.microchart.ColumnMicroChart }
     * `allowColumnLabels`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      sDisplayValue: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * The line title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The actual value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnMicroChartData constructor.
   */
  export interface $ColumnMicroChartDataSettings extends $ElementSettings {
    /**
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The line title.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Overrides the value with a string that is shown when used in combination with {@link sap.suite.ui.microchart.ColumnMicroChart }
     * `allowColumnLabels`.
     */
    displayValue?: string | PropertyBindingInfo;

    /**
     * The actual value.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The event is fired when the user chooses the column data.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ColumnMicroChartData#press event.
   */
  export interface ColumnMicroChartData$PressEventParameters {}

  /**
   * Event object of the ColumnMicroChartData#press event.
   */
  export type ColumnMicroChartData$PressEvent = Event<
    ColumnMicroChartData$PressEventParameters,
    ColumnMicroChartData
  >;
}

declare module "sap/suite/ui/microchart/ColumnMicroChartLabel" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Displays or hides the labels of a column micro chart.
   *
   * @since 1.34
   */
  export default class ColumnMicroChartLabel extends UI5Element {
    /**
     * Constructor for a new ColumnMicroChartLabel control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnMicroChartLabelSettings
    );
    /**
     * Constructor for a new ColumnMicroChartLabel control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnMicroChartLabelSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.ColumnMicroChartLabel with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnMicroChartLabel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.ColumnMicroChartLabel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * The line title.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * The line title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnMicroChartLabel constructor.
   */
  export interface $ColumnMicroChartLabelSettings extends $ElementSettings {
    /**
     * The graphic element color. For SAPUI5 1.x releases, we are going to use string as the type for Micro
     * Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5
     * 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The line title.
     */
    label?: string | PropertyBindingInfo;
  }
}

declare module "sap/suite/ui/microchart/ComparisonMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import ComparisonMicroChartData from "sap/suite/ui/microchart/ComparisonMicroChartData";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  import { ComparisonMicroChartViewType } from "sap/suite/ui/microchart/library";

  /**
   * Illustrates values as colored bar charts with title, numeric value, and scaling factor in the content
   * area. This control replaces the deprecated sap.suite.ui.commons.ComparisonChart.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.34
   */
  export default class ComparisonMicroChart extends Control {
    /**
     * Constructor for a new ComparisonMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComparisonMicroChartSettings
    );
    /**
     * Constructor for a new ComparisonMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComparisonMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.ComparisonMicroChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComparisonMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.ComparisonMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some data to the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addData(
      /**
       * The data to add; if empty, nothing is inserted
       */
      oData: ComparisonMicroChartData
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ComparisonMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ComparisonMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ComparisonMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ComparisonMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getData data} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindData(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the data in the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyData(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. If this property is set, semantic colors defined in ComparisonData are
     * ignored. Colors from the palette are assigned to each bar consequentially. When all the palette colors
     * are used, assignment of the colors begins from the first palette color.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `colorPalette`
     */
    getColorPalette(): string[];
    /**
     * Gets content of aggregation {@link #getData data}.
     *
     * The comparison chart bar data.
     */
    getData(): ComparisonMicroChartData[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets current value of property {@link #getMaxValue maxValue}.
     *
     * The maximum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * @since 1.42.0
     *
     * @returns Value of property `maxValue`
     */
    getMaxValue(): float;
    /**
     * Gets current value of property {@link #getMinValue minValue}.
     *
     * The minimum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * @since 1.42.0
     *
     * @returns Value of property `minValue`
     */
    getMinValue(): float;
    /**
     * Gets current value of property {@link #getScale scale}.
     *
     * The scaling suffix that is added to the actual and target values.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `scale`
     */
    getScale(): string;
    /**
     * Gets current value of property {@link #getShrinkable shrinkable}.
     *
     * If it is set to true, the height of the control is defined by its content.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `shrinkable`
     */
    getShrinkable(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getView view}.
     *
     * The view of the chart. If not set, the Normal view is used by default.
     *
     * Default value is `"Normal"`.
     *
     *
     * @returns Value of property `view`
     */
    getView(): ComparisonMicroChartViewType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.ComparisonMicroChartData` in the aggregation {@link #getData data}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfData(
      /**
       * The data whose index is looked for
       */
      oData: ComparisonMicroChartData
    ): int;
    /**
     * Inserts a data into the aggregation {@link #getData data}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertData(
      /**
       * The data to insert; if empty, nothing is inserted
       */
      oData: ComparisonMicroChartData,
      /**
       * The `0`-based index the data should be inserted at; for a negative value of `iIndex`, the data is inserted
       * at position 0; for a value greater than the current size of the aggregation, the data is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getData data}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllData(): ComparisonMicroChartData[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a data from the aggregation {@link #getData data}.
     *
     *
     * @returns The removed data or `null`
     */
    removeData(
      /**
       * The data to remove or its index or id
       */
      vData: int | string | ComparisonMicroChartData
    ): ComparisonMicroChartData | null;
    /**
     * Sets a new value for property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. If this property is set, semantic colors defined in ComparisonData are
     * ignored. Colors from the palette are assigned to each bar consequentially. When all the palette colors
     * are used, assignment of the colors begins from the first palette color.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorPalette(
      /**
       * New value for property `colorPalette`
       */
      sColorPalette?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxValue maxValue}.
     *
     * The maximum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxValue(
      /**
       * New value for property `maxValue`
       */
      fMaxValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMinValue minValue}.
     *
     * The minimum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.42.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinValue(
      /**
       * New value for property `minValue`
       */
      fMinValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getScale scale}.
     *
     * The scaling suffix that is added to the actual and target values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScale(
      /**
       * New value for property `scale`
       */
      sScale?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShrinkable shrinkable}.
     *
     * If it is set to true, the height of the control is defined by its content.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShrinkable(
      /**
       * New value for property `shrinkable`
       */
      bShrinkable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getView view}.
     *
     * The view of the chart. If not set, the Normal view is used by default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Normal"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setView(
      /**
       * New value for property `view`
       */
      sView?:
        | ComparisonMicroChartViewType
        | keyof typeof ComparisonMicroChartViewType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getData data} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindData(): this;
  }
  /**
   * Describes the settings that can be provided to the ComparisonMicroChart constructor.
   */
  export interface $ComparisonMicroChartSettings extends $ControlSettings {
    /**
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the bullet micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The scaling suffix that is added to the actual and target values.
     */
    scale?: string | PropertyBindingInfo;

    /**
     * The minimum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * @since 1.42.0
     */
    minValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The maximum scale value for the chart used to define the value range of the scale for comparing different
     * values.
     *
     * @since 1.42.0
     */
    maxValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The view of the chart. If not set, the Normal view is used by default.
     */
    view?:
      | (
          | ComparisonMicroChartViewType
          | keyof typeof ComparisonMicroChartViewType
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The color palette for the chart. If this property is set, semantic colors defined in ComparisonData are
     * ignored. Colors from the palette are assigned to each bar consequentially. When all the palette colors
     * are used, assignment of the colors begins from the first palette color.
     */
    colorPalette?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * If it is set to true, the height of the control is defined by its content.
     */
    shrinkable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * @since 1.38.0
     * @deprecated As of version 1.58. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The comparison chart bar data.
     */
    data?:
      | ComparisonMicroChartData[]
      | ComparisonMicroChartData
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ComparisonMicroChart#press event.
   */
  export interface ComparisonMicroChart$PressEventParameters {}

  /**
   * Event object of the ComparisonMicroChart#press event.
   */
  export type ComparisonMicroChart$PressEvent = Event<
    ComparisonMicroChart$PressEventParameters,
    ComparisonMicroChart
  >;
}

declare module "sap/suite/ui/microchart/ComparisonMicroChartData" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the values of the comparison chart.
   *
   * @since 1.34
   */
  export default class ComparisonMicroChartData extends UI5Element {
    /**
     * Constructor for a new ComparisonMicroChartData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ComparisonMicroChartDataSettings
    );
    /**
     * Constructor for a new ComparisonMicroChartData.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ComparisonMicroChartDataSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.ComparisonMicroChartData with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComparisonMicroChartData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.ComparisonMicroChartData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChartData`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ComparisonMicroChartData` itself.
     *
     * The event is fired when the user chooses the comparison chart bar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ComparisonMicroChartData`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChartData`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.ComparisonMicroChartData` itself.
     *
     * The event is fired when the user chooses the comparison chart bar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.ComparisonMicroChartData`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.ComparisonMicroChartData`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The semantic color of the value. For SAPUI5 1.x releases, we are going to use string as the type for
     * Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the
     * SAPUI5 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * If this property is set then it will be displayed instead of value.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * The comparison bar title.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The value for comparison.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The semantic color of the value. For SAPUI5 1.x releases, we are going to use string as the type for
     * Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the
     * SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * If this property is set then it will be displayed instead of value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      sDisplayValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * The comparison bar title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The value for comparison.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ComparisonMicroChartData constructor.
   */
  export interface $ComparisonMicroChartDataSettings extends $ElementSettings {
    /**
     * The value for comparison.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The semantic color of the value. For SAPUI5 1.x releases, we are going to use string as the type for
     * Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the
     * SAPUI5 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The comparison bar title.
     */
    title?: string | PropertyBindingInfo;

    /**
     * If this property is set then it will be displayed instead of value.
     */
    displayValue?: string | PropertyBindingInfo;

    /**
     * The event is fired when the user chooses the comparison chart bar.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ComparisonMicroChartData#press event.
   */
  export interface ComparisonMicroChartData$PressEventParameters {}

  /**
   * Event object of the ComparisonMicroChartData#press event.
   */
  export type ComparisonMicroChartData$PressEvent = Event<
    ComparisonMicroChartData$PressEventParameters,
    ComparisonMicroChartData
  >;
}

declare module "sap/suite/ui/microchart/DeltaMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  import { DeltaMicroChartViewType } from "sap/suite/ui/microchart/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents the delta of two values as a chart. This control replaces the deprecated sap.suite.ui.commons.DeltaMicroChart.
   *
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string.
   *
   * @since 1.34
   */
  export default class DeltaMicroChart extends Control {
    /**
     * Constructor for a new DeltaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DeltaMicroChartSettings
    );
    /**
     * Constructor for a new DeltaMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DeltaMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.DeltaMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DeltaMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.DeltaMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.DeltaMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.DeltaMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.DeltaMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.DeltaMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.DeltaMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.DeltaMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.DeltaMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The semantic color of the delta value. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from
     * the SAPUI5 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): string;
    /**
     * Gets current value of property {@link #getDeltaDisplayValue deltaDisplayValue}.
     *
     * If this property is set, it is rendered instead of a calculated delta.
     *
     *
     * @returns Value of property `deltaDisplayValue`
     */
    getDeltaDisplayValue(): string;
    /**
     * Gets current value of property {@link #getDisplayValue1 displayValue1}.
     *
     * If this property is set, it is rendered instead of value1.
     *
     *
     * @returns Value of property `displayValue1`
     */
    getDisplayValue1(): string;
    /**
     * Gets current value of property {@link #getDisplayValue2 displayValue2}.
     *
     * If this property is set, it is rendered instead of value2.
     *
     *
     * @returns Value of property `displayValue2`
     */
    getDisplayValue2(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.61.0. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the delta micro chart is included.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getTitle1 title1}.
     *
     * The first value title.
     *
     *
     * @returns Value of property `title1`
     */
    getTitle1(): string;
    /**
     * Gets current value of property {@link #getTitle2 title2}.
     *
     * The second value title.
     *
     *
     * @returns Value of property `title2`
     */
    getTitle2(): string;
    /**
     * Gets current value of property {@link #getValue1 value1}.
     *
     * The first value for delta calculation.
     *
     *
     * @returns Value of property `value1`
     */
    getValue1(): float;
    /**
     * Gets current value of property {@link #getValue2 value2}.
     *
     * The second value for delta calculation.
     *
     *
     * @returns Value of property `value2`
     */
    getValue2(): float;
    /**
     * Gets current value of property {@link #getView view}.
     *
     * The view of the chart. If not set, the `Normal` view is used by default.
     *
     * Default value is `"Normal"`.
     *
     * @since 1.61.0
     *
     * @returns Value of property `view`
     */
    getView(): DeltaMicroChartViewType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The semantic color of the delta value. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from
     * the SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDeltaDisplayValue deltaDisplayValue}.
     *
     * If this property is set, it is rendered instead of a calculated delta.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDeltaDisplayValue(
      /**
       * New value for property `deltaDisplayValue`
       */
      sDeltaDisplayValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue1 displayValue1}.
     *
     * If this property is set, it is rendered instead of value1.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue1(
      /**
       * New value for property `displayValue1`
       */
      sDisplayValue1?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayValue2 displayValue2}.
     *
     * If this property is set, it is rendered instead of value2.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue2(
      /**
       * New value for property `displayValue2`
       */
      sDisplayValue2?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.61.0. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the delta micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getTitle1 title1}.
     *
     * The first value title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle1(
      /**
       * New value for property `title1`
       */
      sTitle1?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle2 title2}.
     *
     * The second value title.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle2(
      /**
       * New value for property `title2`
       */
      sTitle2?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue1 value1}.
     *
     * The first value for delta calculation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue1(
      /**
       * New value for property `value1`
       */
      fValue1: float
    ): this;
    /**
     * Sets a new value for property {@link #getValue2 value2}.
     *
     * The second value for delta calculation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue2(
      /**
       * New value for property `value2`
       */
      fValue2: float
    ): this;
    /**
     * Sets a new value for property {@link #getView view}.
     *
     * The view of the chart. If not set, the `Normal` view is used by default.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Normal"`.
     *
     * @since 1.61.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setView(
      /**
       * New value for property `view`
       */
      sView?: DeltaMicroChartViewType | keyof typeof DeltaMicroChartViewType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DeltaMicroChart constructor.
   */
  export interface $DeltaMicroChartSettings extends $ControlSettings {
    /**
     * The first value for delta calculation.
     */
    value1?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The second value for delta calculation.
     */
    value2?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The first value title.
     */
    title1?: string | PropertyBindingInfo;

    /**
     * The second value title.
     */
    title2?: string | PropertyBindingInfo;

    /**
     * If this property is set, it is rendered instead of value1.
     */
    displayValue1?: string | PropertyBindingInfo;

    /**
     * If this property is set, it is rendered instead of value2.
     */
    displayValue2?: string | PropertyBindingInfo;

    /**
     * If this property is set, it is rendered instead of a calculated delta.
     */
    deltaDisplayValue?: string | PropertyBindingInfo;

    /**
     * The semantic color of the delta value. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from
     * the SAPUI5 2.0 release.
     */
    color?: string | PropertyBindingInfo;

    /**
     * The view of the chart. If not set, the `Normal` view is used by default.
     *
     * @since 1.61.0
     */
    view?:
      | (DeltaMicroChartViewType | keyof typeof DeltaMicroChartViewType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The size of the microchart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the delta micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * If this set to true, width and height of the control are determined by the width and height of the container
     * in which the control is placed. Size and Width properties are ignored in such case.
     *
     * @since 1.38.0
     * @deprecated As of version 1.61.0. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DeltaMicroChart#press event.
   */
  export interface DeltaMicroChart$PressEventParameters {}

  /**
   * Event object of the DeltaMicroChart#press event.
   */
  export type DeltaMicroChart$PressEvent = Event<
    DeltaMicroChart$PressEventParameters,
    DeltaMicroChart
  >;
}

declare module "sap/suite/ui/microchart/HarveyBallMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import HarveyBallMicroChartItem from "sap/suite/ui/microchart/HarveyBallMicroChartItem";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { HorizontalAlignmentType } from "sap/suite/ui/microchart/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  /**
   * A radial chart that displays a value compared to its total.
   * Unlike a pie chart, which shows multiple values or sectors, a Harvey Ball microchart shows only one value
   * from a total.
   * The sector that represents a value being compared to a total is defined by {@link sap.suite.ui.microchart.HarveyBallMicroChartItem}.
   *
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.34
   */
  export default class HarveyBallMicroChart extends Control {
    /**
     * Constructor for a new HarveyBallMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $HarveyBallMicroChartSettings
    );
    /**
     * Constructor for a new HarveyBallMicroChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $HarveyBallMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.HarveyBallMicroChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HarveyBallMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.HarveyBallMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: HarveyBallMicroChartItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.HarveyBallMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.HarveyBallMicroChart` itself.
     *
     * This event is fired when the chart is clicked or tapped.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.HarveyBallMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.HarveyBallMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.HarveyBallMicroChart` itself.
     *
     * This event is fired when the chart is clicked or tapped.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.HarveyBallMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getItems items} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindItems(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.HarveyBallMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAlignContent alignContent}.
     *
     * The alignment of the content. If not set, the `Left` alignment type is used.
     *
     * Default value is `"Left"`.
     *
     * @since 1.62.0
     *
     * @returns Value of property `alignContent`
     */
    getAlignContent(): HorizontalAlignmentType;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. Currently only a single color (first color in the array) is supported.
     *
     * If this property is defined, the semantic color defined in the {@link sap.suite.ui.microchart.HarveyBallMicroChartItem }
     * is ignored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `colorPalette`
     */
    getColorPalette(): string[];
    /**
     * Gets current value of property {@link #getFormattedLabel formattedLabel}.
     *
     * If set to `true`, the `totalLabel` property is used instead of the combination of the total value and
     * its scaling factor.
     * The default value is `false`, which means that the total value, defined by the `total` property, and
     * the scaling factor, defined by the `totalScale` property, are displayed separately.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `formattedLabel`
     */
    getFormattedLabel(): boolean;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * @since 1.62.0
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getIsResponsive isResponsive}.
     *
     * If set to `true`, the width and height of the control are determined by the width and height of the parent
     * container, in which case the `size` and `width` properties are ignored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.62.0. the concept has been discarded.
     *
     * @returns Value of property `isResponsive`
     */
    getIsResponsive(): boolean;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * The set of items. Currently only a single item is supported.
     */
    getItems(): HarveyBallMicroChartItem[];
    /**
     * Gets current value of property {@link #getShowFractions showFractions}.
     *
     * If set to `true`, the fraction values are displayed next to the chart. The default setting is `true`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showFractions`
     */
    getShowFractions(): boolean;
    /**
     * Gets current value of property {@link #getShowTotal showTotal}.
     *
     * If set to `true`, the total value is displayed next to the chart. The default setting is `true`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTotal`
     */
    getShowTotal(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the device type.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getTotal total}.
     *
     * The total value. The total value is represented by a full circle, or 360 degrees value on the chart.
     *
     *
     * @returns Value of property `total`
     */
    getTotal(): float;
    /**
     * Gets current value of property {@link #getTotalLabel totalLabel}.
     *
     * The total label. If specified, it is displayed instead of the total value.
     *
     *
     * @returns Value of property `totalLabel`
     */
    getTotalLabel(): string;
    /**
     * Gets current value of property {@link #getTotalScale totalScale}.
     *
     * The scaling factor that is displayed next to the total value.
     *
     *
     * @returns Value of property `totalScale`
     */
    getTotalScale(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.HarveyBallMicroChartItem` in the aggregation {@link #getItems items}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: HarveyBallMicroChartItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: HarveyBallMicroChartItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): HarveyBallMicroChartItem[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | HarveyBallMicroChartItem
    ): HarveyBallMicroChartItem | null;
    /**
     * Sets a new value for property {@link #getAlignContent alignContent}.
     *
     * The alignment of the content. If not set, the `Left` alignment type is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Left"`.
     *
     * @since 1.62.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlignContent(
      /**
       * New value for property `alignContent`
       */
      sAlignContent?:
        | HorizontalAlignmentType
        | keyof typeof HorizontalAlignmentType
    ): this;
    /**
     * Sets a new value for property {@link #getColorPalette colorPalette}.
     *
     * The color palette for the chart. Currently only a single color (first color in the array) is supported.
     *
     * If this property is defined, the semantic color defined in the {@link sap.suite.ui.microchart.HarveyBallMicroChartItem }
     * is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorPalette(
      /**
       * New value for property `colorPalette`
       */
      sColorPalette?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getFormattedLabel formattedLabel}.
     *
     * If set to `true`, the `totalLabel` property is used instead of the combination of the total value and
     * its scaling factor.
     * The default value is `false`, which means that the total value, defined by the `total` property, and
     * the scaling factor, defined by the `totalScale` property, are displayed separately.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormattedLabel(
      /**
       * New value for property `formattedLabel`
       */
      bFormattedLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.62.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsResponsive isResponsive}.
     *
     * If set to `true`, the width and height of the control are determined by the width and height of the parent
     * container, in which case the `size` and `width` properties are ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.38.0
     * @deprecated As of version 1.62.0. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsResponsive(
      /**
       * New value for property `isResponsive`
       */
      bIsResponsive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowFractions showFractions}.
     *
     * If set to `true`, the fraction values are displayed next to the chart. The default setting is `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFractions(
      /**
       * New value for property `showFractions`
       */
      bShowFractions?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTotal showTotal}.
     *
     * If set to `true`, the total value is displayed next to the chart. The default setting is `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTotal(
      /**
       * New value for property `showTotal`
       */
      bShowTotal?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the device type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getTotal total}.
     *
     * The total value. The total value is represented by a full circle, or 360 degrees value on the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTotal(
      /**
       * New value for property `total`
       */
      fTotal?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTotalLabel totalLabel}.
     *
     * The total label. If specified, it is displayed instead of the total value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTotalLabel(
      /**
       * New value for property `totalLabel`
       */
      sTotalLabel: string
    ): this;
    /**
     * Sets a new value for property {@link #getTotalScale totalScale}.
     *
     * The scaling factor that is displayed next to the total value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTotalScale(
      /**
       * New value for property `totalScale`
       */
      sTotalScale: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getItems items} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindItems(): this;
  }
  /**
   * Describes the settings that can be provided to the HarveyBallMicroChart constructor.
   */
  export interface $HarveyBallMicroChartSettings extends $ControlSettings {
    /**
     * The total value. The total value is represented by a full circle, or 360 degrees value on the chart.
     */
    total?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The total label. If specified, it is displayed instead of the total value.
     */
    totalLabel?: string | PropertyBindingInfo;

    /**
     * The scaling factor that is displayed next to the total value.
     */
    totalScale?: string | PropertyBindingInfo;

    /**
     * If set to `true`, the `totalLabel` property is used instead of the combination of the total value and
     * its scaling factor.
     * The default value is `false`, which means that the total value, defined by the `total` property, and
     * the scaling factor, defined by the `totalScale` property, are displayed separately.
     */
    formattedLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, the total value is displayed next to the chart. The default setting is `true`.
     */
    showTotal?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, the fraction values are displayed next to the chart. The default setting is `true`.
     */
    showFractions?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The size of the chart. If not set, the default size is applied based on the device type.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The color palette for the chart. Currently only a single color (first color in the array) is supported.
     *
     * If this property is defined, the semantic color defined in the {@link sap.suite.ui.microchart.HarveyBallMicroChartItem }
     * is ignored.
     */
    colorPalette?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * @since 1.62.0
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The alignment of the content. If not set, the `Left` alignment type is used.
     *
     * @since 1.62.0
     */
    alignContent?:
      | (HorizontalAlignmentType | keyof typeof HorizontalAlignmentType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to `true`, the width and height of the control are determined by the width and height of the parent
     * container, in which case the `size` and `width` properties are ignored.
     *
     * @since 1.38.0
     * @deprecated As of version 1.62.0. the concept has been discarded.
     */
    isResponsive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The set of items. Currently only a single item is supported.
     */
    items?:
      | HarveyBallMicroChartItem[]
      | HarveyBallMicroChartItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * This event is fired when the chart is clicked or tapped.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the HarveyBallMicroChart#press event.
   */
  export interface HarveyBallMicroChart$PressEventParameters {}

  /**
   * Event object of the HarveyBallMicroChart#press event.
   */
  export type HarveyBallMicroChart$PressEvent = Event<
    HarveyBallMicroChart$PressEventParameters,
    HarveyBallMicroChart
  >;
}

declare module "sap/suite/ui/microchart/HarveyBallMicroChartItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the fraction value that is compared with total in a {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
   *
   * @since 1.34
   */
  export default class HarveyBallMicroChartItem extends UI5Element {
    /**
     * Constructor for a new HarveyBallMicroChartItem to be used in a {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HarveyBallMicroChartItemSettings
    );
    /**
     * Constructor for a new HarveyBallMicroChartItem to be used in a {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HarveyBallMicroChartItemSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.HarveyBallMicroChartItem with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HarveyBallMicroChartItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.HarveyBallMicroChartItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * The color of the sector representing the fraction value.
     * The same color is used for the fraction value label defined either by the `fraction` property or by the
     * `fractionLabel` property. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getFormattedLabel formattedLabel}.
     *
     * If set to `true`, the `fractionLabel` property is used instead of the combination of the fraction value
     * and scaling factor.
     * The default value is `false`, which means that the fraction value, defined by the `fraction` property,
     * and the scaling factor, defined by the `fractionScale` property are displayed separately.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `formattedLabel`
     */
    getFormattedLabel(): boolean;
    /**
     * Gets current value of property {@link #getFraction fraction}.
     *
     * The fraction value that defines the size of the colored sector.
     * This property must be set to a value that is a fraction of the `total` value defined for the {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `fraction`
     */
    getFraction(): float;
    /**
     * Gets current value of property {@link #getFractionLabel fractionLabel}.
     *
     * The fraction label. If this property is specified, it is displayed instead of the label that is based
     * on the `fraction` property.
     *
     *
     * @returns Value of property `fractionLabel`
     */
    getFractionLabel(): string;
    /**
     * Gets current value of property {@link #getFractionScale fractionScale}.
     *
     * The scaling factor that is displayed after the fraction value.
     *
     *
     * @returns Value of property `fractionScale`
     */
    getFractionScale(): string;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * The color of the sector representing the fraction value.
     * The same color is used for the fraction value label defined either by the `fraction` property or by the
     * `fractionLabel` property. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getFormattedLabel formattedLabel}.
     *
     * If set to `true`, the `fractionLabel` property is used instead of the combination of the fraction value
     * and scaling factor.
     * The default value is `false`, which means that the fraction value, defined by the `fraction` property,
     * and the scaling factor, defined by the `fractionScale` property are displayed separately.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFormattedLabel(
      /**
       * New value for property `formattedLabel`
       */
      bFormattedLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFraction fraction}.
     *
     * The fraction value that defines the size of the colored sector.
     * This property must be set to a value that is a fraction of the `total` value defined for the {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFraction(
      /**
       * New value for property `fraction`
       */
      fFraction?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFractionLabel fractionLabel}.
     *
     * The fraction label. If this property is specified, it is displayed instead of the label that is based
     * on the `fraction` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFractionLabel(
      /**
       * New value for property `fractionLabel`
       */
      sFractionLabel: string
    ): this;
    /**
     * Sets a new value for property {@link #getFractionScale fractionScale}.
     *
     * The scaling factor that is displayed after the fraction value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFractionScale(
      /**
       * New value for property `fractionScale`
       */
      sFractionScale: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HarveyBallMicroChartItem constructor.
   */
  export interface $HarveyBallMicroChartItemSettings extends $ElementSettings {
    /**
     * The color of the sector representing the fraction value.
     * The same color is used for the fraction value label defined either by the `fraction` property or by the
     * `fractionLabel` property. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The fraction value that defines the size of the colored sector.
     * This property must be set to a value that is a fraction of the `total` value defined for the {@link sap.suite.ui.microchart.HarveyBallMicroChart}.
     */
    fraction?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The fraction label. If this property is specified, it is displayed instead of the label that is based
     * on the `fraction` property.
     */
    fractionLabel?: string | PropertyBindingInfo;

    /**
     * The scaling factor that is displayed after the fraction value.
     */
    fractionScale?: string | PropertyBindingInfo;

    /**
     * If set to `true`, the `fractionLabel` property is used instead of the combination of the fraction value
     * and scaling factor.
     * The default value is `false`, which means that the fraction value, defined by the `fraction` property,
     * and the scaling factor, defined by the `fractionScale` property are displayed separately.
     */
    formattedLabel?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/InteractiveBarChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, Percentage } from "sap/ui/core/library";

  import InteractiveBarChartBar from "sap/suite/ui/microchart/InteractiveBarChartBar";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The InteractiveBarChart control belongs to a chart control group in the MicroChart library with a number
   * of interactive features. These interactive features provide more information on a chart value. For example,
   * by selecting a bar you can get more details on the displayed value.
   *
   * @since 1.42.0
   */
  export default class InteractiveBarChart extends Control {
    /**
     * Constructor for a new InteractiveBarChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveBarChartSettings
    );
    /**
     * Constructor for a new InteractiveBarChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveBarChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveBarChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveBarChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveBarChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some bar to the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addBar(
      /**
       * The bar to add; if empty, nothing is inserted
       */
      oBar: InteractiveBarChartBar
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveBarChart` itself.
     *
     * The event is fired when the user presses the chart while its bars are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the bars.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveBarChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveBarChart` itself.
     *
     * The event is fired when the user presses the chart while its bars are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the bars.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveBarChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveBarChart` itself.
     *
     * Event is fired when user has selected or deselected a bar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveBarChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveBarChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveBarChart` itself.
     *
     * Event is fired when user has selected or deselected a bar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveBarChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveBarChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getBars bars} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindBars(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the bars in the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBars(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveBarChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: InteractiveBarChart$SelectionChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChanged selectionChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: InteractiveBarChart$SelectionChangedEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getBars bars}.
     *
     * Bars displayed on the chart.
     */
    getBars(): InteractiveBarChartBar[];
    /**
     * Gets current value of property {@link #getDisplayedBars displayedBars}.
     *
     * The number of displayed bars.
     *
     * Default value is `3`.
     *
     *
     * @returns Value of property `displayedBars`
     */
    getDisplayedBars(): int;
    /**
     * Gets current value of property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     *
     * @returns Value of property `errorMessage`
     */
    getErrorMessage(): string;
    /**
     * Gets current value of property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     *
     * @returns Value of property `errorMessageTitle`
     */
    getErrorMessageTitle(): string;
    /**
     * Gets current value of property {@link #getLabelWidth labelWidth}.
     *
     * Width of the labels column in the resulting layout (in percentage). Possible range of values from 0 to
     * 100. A value of 40 results in the labels column taking up 40% of available space.
     *
     * Default value is `"40%"`.
     *
     *
     * @returns Value of property `labelWidth`
     */
    getLabelWidth(): Percentage;
    /**
     * Gets current value of property {@link #getMax max}.
     *
     * End of displayed scale.
     *
     *
     * @returns Value of property `max`
     */
    getMax(): float;
    /**
     * Gets current value of property {@link #getMin min}.
     *
     * Begin of displayed scale.
     *
     *
     * @returns Value of property `min`
     */
    getMin(): float;
    /**
     * Gets all selected bars.
     *
     *
     * @returns All selected bars
     */
    getSelectedBars(): InteractiveBarChartBar[];
    /**
     * Gets current value of property {@link #getSelectionEnabled selectionEnabled}.
     *
     * Enables the selection in the chart.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `selectionEnabled`
     */
    getSelectionEnabled(): boolean;
    /**
     * Gets current value of property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showError`
     */
    getShowError(): boolean;
    /**
     * Checks for the provided `sap.suite.ui.microchart.InteractiveBarChartBar` in the aggregation {@link #getBars bars}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfBar(
      /**
       * The bar whose index is looked for
       */
      oBar: InteractiveBarChartBar
    ): int;
    /**
     * Inserts a bar into the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertBar(
      /**
       * The bar to insert; if empty, nothing is inserted
       */
      oBar: InteractiveBarChartBar,
      /**
       * The `0`-based index the bar should be inserted at; for a negative value of `iIndex`, the bar is inserted
       * at position 0; for a value greater than the current size of the aggregation, the bar is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getBars bars}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllBars(): InteractiveBarChartBar[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a bar from the aggregation {@link #getBars bars}.
     *
     *
     * @returns The removed bar or `null`
     */
    removeBar(
      /**
       * The bar to remove or its index or id
       */
      vBar: int | string | InteractiveBarChartBar
    ): InteractiveBarChartBar | null;
    /**
     * Sets a new value for property {@link #getDisplayedBars displayedBars}.
     *
     * The number of displayed bars.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `3`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedBars(
      /**
       * New value for property `displayedBars`
       */
      iDisplayedBars?: int
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessage(
      /**
       * New value for property `errorMessage`
       */
      sErrorMessage: string
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessageTitle(
      /**
       * New value for property `errorMessageTitle`
       */
      sErrorMessageTitle: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabelWidth labelWidth}.
     *
     * Width of the labels column in the resulting layout (in percentage). Possible range of values from 0 to
     * 100. A value of 40 results in the labels column taking up 40% of available space.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"40%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelWidth(
      /**
       * New value for property `labelWidth`
       */
      sLabelWidth?: Percentage
    ): this;
    /**
     * Sets a new value for property {@link #getMax max}.
     *
     * End of displayed scale.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMax(
      /**
       * New value for property `max`
       */
      fMax: float
    ): this;
    /**
     * Sets a new value for property {@link #getMin min}.
     *
     * Begin of displayed scale.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMin(
      /**
       * New value for property `min`
       */
      fMin: float
    ): this;
    /**
     * Already selected bars will be deselected and members of the selectedBars parameter which are part of
     * the bars aggregation will be set to selected state.
     *
     *
     * @returns this to allow method chaining
     */
    setSelectedBars(
      /**
       * A bar element or an array of bars for which the status should be set to selected.
       */
      selectedBars: InteractiveBarChartBar | InteractiveBarChartBar[]
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionEnabled selectionEnabled}.
     *
     * Enables the selection in the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionEnabled(
      /**
       * New value for property `selectionEnabled`
       */
      bSelectionEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowError(
      /**
       * New value for property `showError`
       */
      bShowError?: boolean
    ): this;
    /**
     * Unbinds aggregation {@link #getBars bars} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindBars(): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveBarChart constructor.
   */
  export interface $InteractiveBarChartSettings extends $ControlSettings {
    /**
     * The number of displayed bars.
     */
    displayedBars?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the labels column in the resulting layout (in percentage). Possible range of values from 0 to
     * 100. A value of 40 results in the labels column taking up 40% of available space.
     */
    labelWidth?: Percentage | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables the selection in the chart.
     */
    selectionEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Begin of displayed scale.
     */
    min?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * End of displayed scale.
     */
    max?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * TRUE if error is present, FALSE otherwise
     */
    showError?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * error message title
     */
    errorMessageTitle?: string | PropertyBindingInfo;

    /**
     * error message description
     */
    errorMessage?: string | PropertyBindingInfo;

    /**
     * Bars displayed on the chart.
     */
    bars?:
      | InteractiveBarChartBar[]
      | InteractiveBarChartBar
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Event is fired when user has selected or deselected a bar.
     */
    selectionChanged?: (
      oEvent: InteractiveBarChart$SelectionChangedEvent
    ) => void;

    /**
     * The event is fired when the user presses the chart while its bars are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the bars.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InteractiveBarChart#press event.
   */
  export interface InteractiveBarChart$PressEventParameters {}

  /**
   * Event object of the InteractiveBarChart#press event.
   */
  export type InteractiveBarChart$PressEvent = Event<
    InteractiveBarChart$PressEventParameters,
    InteractiveBarChart
  >;

  /**
   * Parameters of the InteractiveBarChart#selectionChanged event.
   */
  export interface InteractiveBarChart$SelectionChangedEventParameters {
    /**
     * All bars which are in selected state.
     */
    selectedBars?: InteractiveBarChartBar[];

    /**
     * The bar being selected or deselected.
     */
    bar?: InteractiveBarChartBar;

    /**
     * The selection state of the bar being selected or deselected.
     */
    selected?: boolean;
  }

  /**
   * Event object of the InteractiveBarChart#selectionChanged event.
   */
  export type InteractiveBarChart$SelectionChangedEvent = Event<
    InteractiveBarChart$SelectionChangedEventParameters,
    InteractiveBarChart
  >;
}

declare module "sap/suite/ui/microchart/InteractiveBarChartBar" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ValueColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A bar element for the InteractiveBarChart.
   *
   * @since 1.42.0
   */
  export default class InteractiveBarChartBar extends UI5Element {
    /**
     * Constructor for the bar element of the InteractiveBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveBarChartBarSettings
    );
    /**
     * Constructor for the bar element of the InteractiveBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveBarChartBarSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveBarChartBar with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveBarChartBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveBarChartBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Determines the color of the bar.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Value of property `color`
     */
    getColor(): ValueColor;
    /**
     * Gets current value of property {@link #getDisplayedValue displayedValue}.
     *
     * The value label to be displayed on the bar in the chart.
     *
     *
     * @returns Value of property `displayedValue`
     */
    getDisplayedValue(): string;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * The label for the chart bar.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Determines if the chart bar is selected.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The numeric value of the chart bar to be displayed on the bar.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Determines the color of the bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: ValueColor | keyof typeof ValueColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayedValue displayedValue}.
     *
     * The value label to be displayed on the bar in the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedValue(
      /**
       * New value for property `displayedValue`
       */
      sDisplayedValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * The label for the chart bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Determines if the chart bar is selected.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The numeric value of the chart bar to be displayed on the bar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveBarChartBar constructor.
   */
  export interface $InteractiveBarChartBarSettings extends $ElementSettings {
    /**
     * The label for the chart bar.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Determines if the chart bar is selected.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value label to be displayed on the bar in the chart.
     */
    displayedValue?: string | PropertyBindingInfo;

    /**
     * Determines the color of the bar.
     *
     * @since 1.50.0
     */
    color?:
      | (ValueColor | keyof typeof ValueColor)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The numeric value of the chart bar to be displayed on the bar.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/InteractiveDonutChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import InteractiveDonutChartSegment from "sap/suite/ui/microchart/InteractiveDonutChartSegment";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The InteractiveDonutChart control belongs to a chart control group in the MicroChart library with a number
   * of interactive features. These interactive features provide more information on a chart value. For example,
   * by selecting a segment you can get more details on the displayed value.
   *
   * @since 1.42.0
   */
  export default class InteractiveDonutChart extends Control {
    /**
     * Constructor for InteractiveDonutChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveDonutChartSettings
    );
    /**
     * Constructor for InteractiveDonutChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveDonutChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveDonutChart with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveDonutChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveDonutChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some segment to the aggregation {@link #getSegments segments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addSegment(
      /**
       * The segment to add; if empty, nothing is inserted
       */
      oSegment: InteractiveDonutChartSegment
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveDonutChart` itself.
     *
     * The event is fired when the user presses the chart while its segments are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the chart.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveDonutChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveDonutChart` itself.
     *
     * The event is fired when the user presses the chart while its segments are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the chart.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveDonutChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveDonutChart` itself.
     *
     * Event is fired when a user has selected or deselected a segment or a legend entry.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveDonutChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveDonutChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveDonutChart` itself.
     *
     * Event is fired when a user has selected or deselected a segment or a legend entry.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveDonutChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveDonutChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getSegments segments} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindSegments(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the segments in the aggregation {@link #getSegments segments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySegments(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveDonutChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: InteractiveDonutChart$SelectionChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChanged selectionChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: InteractiveDonutChart$SelectionChangedEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDisplayedSegments displayedSegments}.
     *
     * Number of segments to be displayed.
     *
     * Default value is `3`.
     *
     *
     * @returns Value of property `displayedSegments`
     */
    getDisplayedSegments(): int;
    /**
     * Gets current value of property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     *
     * @returns Value of property `errorMessage`
     */
    getErrorMessage(): string;
    /**
     * Gets current value of property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     *
     * @returns Value of property `errorMessageTitle`
     */
    getErrorMessageTitle(): string;
    /**
     * Gets content of aggregation {@link #getSegments segments}.
     *
     * Aggregation which contains all segments.
     */
    getSegments(): InteractiveDonutChartSegment[];
    /**
     * Gets all selected segments or an empty array if there is no segment selected yet
     *
     *
     * @returns All selected segments
     */
    getSelectedSegments(): InteractiveDonutChartSegment[];
    /**
     * Gets current value of property {@link #getSelectionEnabled selectionEnabled}.
     *
     * Switch which enables or disables selection.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `selectionEnabled`
     */
    getSelectionEnabled(): boolean;
    /**
     * Gets current value of property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showError`
     */
    getShowError(): boolean;
    /**
     * Checks for the provided `sap.suite.ui.microchart.InteractiveDonutChartSegment` in the aggregation {@link #getSegments segments}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSegment(
      /**
       * The segment whose index is looked for
       */
      oSegment: InteractiveDonutChartSegment
    ): int;
    /**
     * Inserts a segment into the aggregation {@link #getSegments segments}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertSegment(
      /**
       * The segment to insert; if empty, nothing is inserted
       */
      oSegment: InteractiveDonutChartSegment,
      /**
       * The `0`-based index the segment should be inserted at; for a negative value of `iIndex`, the segment
       * is inserted at position 0; for a value greater than the current size of the aggregation, the segment
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getSegments segments}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSegments(): InteractiveDonutChartSegment[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a segment from the aggregation {@link #getSegments segments}.
     *
     *
     * @returns The removed segment or `null`
     */
    removeSegment(
      /**
       * The segment to remove or its index or id
       */
      vSegment: int | string | InteractiveDonutChartSegment
    ): InteractiveDonutChartSegment | null;
    /**
     * Sets a new value for property {@link #getDisplayedSegments displayedSegments}.
     *
     * Number of segments to be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `3`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedSegments(
      /**
       * New value for property `displayedSegments`
       */
      iDisplayedSegments?: int
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessage(
      /**
       * New value for property `errorMessage`
       */
      sErrorMessage: string
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessageTitle(
      /**
       * New value for property `errorMessageTitle`
       */
      sErrorMessageTitle: string
    ): this;
    /**
     * Already selected segments will be unselected and members of selectedSegments attribute which are part
     * of the segments aggregation will be set to selected state.
     *
     *
     * @returns The current object in order to allow method chaining
     */
    setSelectedSegments(
      /**
       * A segment element or an array of segments for which the status should be set to selected
       */
      selectedSegments:
        | InteractiveDonutChartSegment
        | InteractiveDonutChartSegment[]
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionEnabled selectionEnabled}.
     *
     * Switch which enables or disables selection.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionEnabled(
      /**
       * New value for property `selectionEnabled`
       */
      bSelectionEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowError(
      /**
       * New value for property `showError`
       */
      bShowError?: boolean
    ): this;
    /**
     * Unbinds aggregation {@link #getSegments segments} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindSegments(): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveDonutChart constructor.
   */
  export interface $InteractiveDonutChartSettings extends $ControlSettings {
    /**
     * Number of segments to be displayed.
     */
    displayedSegments?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch which enables or disables selection.
     */
    selectionEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * TRUE if error is present, FALSE otherwise
     */
    showError?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * error message title
     */
    errorMessageTitle?: string | PropertyBindingInfo;

    /**
     * error message description
     */
    errorMessage?: string | PropertyBindingInfo;

    /**
     * Aggregation which contains all segments.
     */
    segments?:
      | InteractiveDonutChartSegment[]
      | InteractiveDonutChartSegment
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Event is fired when a user has selected or deselected a segment or a legend entry.
     */
    selectionChanged?: (
      oEvent: InteractiveDonutChart$SelectionChangedEvent
    ) => void;

    /**
     * The event is fired when the user presses the chart while its segments are not selectable in non-interactive
     * mode. This is decided internally, depending on the size of the chart.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InteractiveDonutChart#press event.
   */
  export interface InteractiveDonutChart$PressEventParameters {}

  /**
   * Event object of the InteractiveDonutChart#press event.
   */
  export type InteractiveDonutChart$PressEvent = Event<
    InteractiveDonutChart$PressEventParameters,
    InteractiveDonutChart
  >;

  /**
   * Parameters of the InteractiveDonutChart#selectionChanged event.
   */
  export interface InteractiveDonutChart$SelectionChangedEventParameters {
    /**
     * Contains all selected segments.
     */
    selectedSegments?: InteractiveDonutChartSegment[];

    /**
     * The segment whose selection state has changed.
     */
    segment?: InteractiveDonutChartSegment;

    /**
     * Indicates whether the segment "segment" is selected or not.
     */
    selected?: boolean;
  }

  /**
   * Event object of the InteractiveDonutChart#selectionChanged event.
   */
  export type InteractiveDonutChart$SelectionChangedEvent = Event<
    InteractiveDonutChart$SelectionChangedEventParameters,
    InteractiveDonutChart
  >;
}

declare module "sap/suite/ui/microchart/InteractiveDonutChartSegment" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ValueColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A donut chart segment.
   *
   * @since 1.42.0
   */
  export default class InteractiveDonutChartSegment extends UI5Element {
    /**
     * Constructor for InteractiveDonutChartSegment element.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new element
       */
      mSettings?: $InteractiveDonutChartSegmentSettings
    );
    /**
     * Constructor for InteractiveDonutChartSegment element.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new element
       */
      mSettings?: $InteractiveDonutChartSegmentSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveDonutChartSegment with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveDonutChartSegment>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveDonutChartSegment.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Determines the color of the segment.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Value of property `color`
     */
    getColor(): ValueColor;
    /**
     * Gets current value of property {@link #getDisplayedValue displayedValue}.
     *
     * The value that is directly displayed on the legend.
     *
     *
     * @returns Value of property `displayedValue`
     */
    getDisplayedValue(): string;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Displayed text for the segment.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Indicator for the selected state.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The value representing a percentage or an absolute value.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Determines the color of the segment.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: ValueColor | keyof typeof ValueColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayedValue displayedValue}.
     *
     * The value that is directly displayed on the legend.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedValue(
      /**
       * New value for property `displayedValue`
       */
      sDisplayedValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * Displayed text for the segment.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Indicator for the selected state.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The value representing a percentage or an absolute value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveDonutChartSegment constructor.
   */
  export interface $InteractiveDonutChartSegmentSettings
    extends $ElementSettings {
    /**
     * Displayed text for the segment.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Indicator for the selected state.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value representing a percentage or an absolute value.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The value that is directly displayed on the legend.
     */
    displayedValue?: string | PropertyBindingInfo;

    /**
     * Determines the color of the segment.
     *
     * @since 1.50.0
     */
    color?:
      | (ValueColor | keyof typeof ValueColor)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/InteractiveLineChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID } from "sap/ui/core/library";

  import InteractiveLineChartPoint from "sap/suite/ui/microchart/InteractiveLineChartPoint";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The InteractiveLineChart control belongs to a chart control group in the MicroChart library having a
   * number of interactive features.
   *
   * @since 1.42.0
   */
  export default class InteractiveLineChart extends Control {
    /**
     * Constructor for a new InteractiveLineChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveLineChartSettings
    );
    /**
     * Constructor for a new InteractiveLineChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveLineChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveLineChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveLineChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveLineChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some point to the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPoint(
      /**
       * The point to add; if empty, nothing is inserted
       */
      oPoint: InteractiveLineChartPoint
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveLineChart` itself.
     *
     * The event is fired only in non-interactive mode when the user presses the chart; in this mode, the points
     * and surrounding areas are not selectable. Non-interactive mode is decided upon internally, depending
     * on the size of the areas surrounding the points.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveLineChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveLineChart` itself.
     *
     * The event is fired only in non-interactive mode when the user presses the chart; in this mode, the points
     * and surrounding areas are not selectable. Non-interactive mode is decided upon internally, depending
     * on the size of the areas surrounding the points.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveLineChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveLineChart` itself.
     *
     * Event is fired when a user has selected or deselected a point.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveLineChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveLineChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.InteractiveLineChart` itself.
     *
     * Event is fired when a user has selected or deselected a point.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InteractiveLineChart$SelectionChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.InteractiveLineChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getPoints points} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindPoints(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the points in the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPoints(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChanged selectionChanged} event of
     * this `sap.suite.ui.microchart.InteractiveLineChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: InteractiveLineChart$SelectionChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectionChanged selectionChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: InteractiveLineChart$SelectionChangedEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDisplayedPoints displayedPoints}.
     *
     * The maximum number of points to be displayed on the chart.
     *
     * Default value is `6`.
     *
     *
     * @returns Value of property `displayedPoints`
     */
    getDisplayedPoints(): int;
    /**
     * Gets current value of property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     *
     * @returns Value of property `errorMessage`
     */
    getErrorMessage(): string;
    /**
     * Gets current value of property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     *
     * @returns Value of property `errorMessageTitle`
     */
    getErrorMessageTitle(): string;
    /**
     * Gets content of aggregation {@link #getPoints points}.
     *
     * Points displayed in the chart.
     */
    getPoints(): InteractiveLineChartPoint[];
    /**
     * Gets current value of property {@link #getPrecedingPoint precedingPoint}.
     *
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly into the visible
     * part of the chart.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `precedingPoint`
     */
    getPrecedingPoint(): float;
    /**
     * Retrieves the selected point elements from the points aggregation and returns them.
     *
     *
     * @returns Array of sap.suite.ui.microchart.InteractiveLineChartPoint instances.
     */
    getSelectedPoints(): InteractiveLineChartPoint[];
    /**
     * Gets current value of property {@link #getSelectionEnabled selectionEnabled}.
     *
     * If this property is set to true, one or multiple points are selectable.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `selectionEnabled`
     */
    getSelectionEnabled(): boolean;
    /**
     * Gets current value of property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showError`
     */
    getShowError(): boolean;
    /**
     * Gets current value of property {@link #getSucceedingPoint succeedingPoint}.
     *
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly out of the visible
     * part of the chart.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `succeedingPoint`
     */
    getSucceedingPoint(): float;
    /**
     * Checks for the provided `sap.suite.ui.microchart.InteractiveLineChartPoint` in the aggregation {@link #getPoints points}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPoint(
      /**
       * The point whose index is looked for
       */
      oPoint: InteractiveLineChartPoint
    ): int;
    /**
     * Inserts a point into the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPoint(
      /**
       * The point to insert; if empty, nothing is inserted
       */
      oPoint: InteractiveLineChartPoint,
      /**
       * The `0`-based index the point should be inserted at; for a negative value of `iIndex`, the point is inserted
       * at position 0; for a value greater than the current size of the aggregation, the point is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getPoints points}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPoints(): InteractiveLineChartPoint[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a point from the aggregation {@link #getPoints points}.
     *
     *
     * @returns The removed point or `null`
     */
    removePoint(
      /**
       * The point to remove or its index or id
       */
      vPoint: int | string | InteractiveLineChartPoint
    ): InteractiveLineChartPoint | null;
    /**
     * Sets a new value for property {@link #getDisplayedPoints displayedPoints}.
     *
     * The maximum number of points to be displayed on the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `6`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedPoints(
      /**
       * New value for property `displayedPoints`
       */
      iDisplayedPoints?: int
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessage errorMessage}.
     *
     * error message description
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessage(
      /**
       * New value for property `errorMessage`
       */
      sErrorMessage: string
    ): this;
    /**
     * Sets a new value for property {@link #getErrorMessageTitle errorMessageTitle}.
     *
     * error message title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setErrorMessageTitle(
      /**
       * New value for property `errorMessageTitle`
       */
      sErrorMessageTitle: string
    ): this;
    /**
     * Sets a new value for property {@link #getPrecedingPoint precedingPoint}.
     *
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly into the visible
     * part of the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrecedingPoint(
      /**
       * New value for property `precedingPoint`
       */
      fPrecedingPoint?: float
    ): this;
    /**
     * Already selected points will be deselected and members of the selectedPoints attribute which are part
     * of the points aggregation will be set to selected state.
     *
     *
     * @returns this to allow method chaining
     */
    setSelectedPoints(
      /**
       * A point element or an array of points for which the status should be set to selected.
       */
      selectedPoints: InteractiveLineChartPoint | InteractiveLineChartPoint[]
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionEnabled selectionEnabled}.
     *
     * If this property is set to true, one or multiple points are selectable.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionEnabled(
      /**
       * New value for property `selectionEnabled`
       */
      bSelectionEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowError showError}.
     *
     * TRUE if error is present, FALSE otherwise
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowError(
      /**
       * New value for property `showError`
       */
      bShowError?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSucceedingPoint succeedingPoint}.
     *
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly out of the visible
     * part of the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSucceedingPoint(
      /**
       * New value for property `succeedingPoint`
       */
      fSucceedingPoint?: float
    ): this;
    /**
     * Unbinds aggregation {@link #getPoints points} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindPoints(): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveLineChart constructor.
   */
  export interface $InteractiveLineChartSettings extends $ControlSettings {
    /**
     * The maximum number of points to be displayed on the chart.
     */
    displayedPoints?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly into the visible
     * part of the chart.
     */
    precedingPoint?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Abstract invisible point outside of the chart that ensures that the graph flows smoothly out of the visible
     * part of the chart.
     */
    succeedingPoint?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to true, one or multiple points are selectable.
     */
    selectionEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * TRUE if error is present, FALSE otherwise
     */
    showError?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * error message title
     */
    errorMessageTitle?: string | PropertyBindingInfo;

    /**
     * error message description
     */
    errorMessage?: string | PropertyBindingInfo;

    /**
     * Points displayed in the chart.
     */
    points?:
      | InteractiveLineChartPoint[]
      | InteractiveLineChartPoint
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Event is fired when a user has selected or deselected a point.
     */
    selectionChanged?: (
      oEvent: InteractiveLineChart$SelectionChangedEvent
    ) => void;

    /**
     * The event is fired only in non-interactive mode when the user presses the chart; in this mode, the points
     * and surrounding areas are not selectable. Non-interactive mode is decided upon internally, depending
     * on the size of the areas surrounding the points.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the InteractiveLineChart#press event.
   */
  export interface InteractiveLineChart$PressEventParameters {}

  /**
   * Event object of the InteractiveLineChart#press event.
   */
  export type InteractiveLineChart$PressEvent = Event<
    InteractiveLineChart$PressEventParameters,
    InteractiveLineChart
  >;

  /**
   * Parameters of the InteractiveLineChart#selectionChanged event.
   */
  export interface InteractiveLineChart$SelectionChangedEventParameters {
    /**
     * All points which are in selected state.
     */
    selectedPoints?: InteractiveLineChartPoint[];

    /**
     * The point which is pressed.
     */
    point?: InteractiveLineChartPoint;

    /**
     * The selection state of the point which is pressed.
     */
    selected?: boolean;
  }

  /**
   * Event object of the InteractiveLineChart#selectionChanged event.
   */
  export type InteractiveLineChart$SelectionChangedEvent = Event<
    InteractiveLineChart$SelectionChangedEventParameters,
    InteractiveLineChart
  >;
}

declare module "sap/suite/ui/microchart/InteractiveLineChartPoint" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ValueColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A point element for the InteractiveLineChart.
   *
   * @since 1.42.0
   */
  export default class InteractiveLineChartPoint extends UI5Element {
    /**
     * Constructor for the point element of the InteractiveLineChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveLineChartPointSettings
    );
    /**
     * Constructor for the point element of the InteractiveLineChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InteractiveLineChartPointSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.InteractiveLineChartPoint with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InteractiveLineChartPoint>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.InteractiveLineChartPoint.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Determines the color of the point.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Value of property `color`
     */
    getColor(): ValueColor;
    /**
     * Gets current value of property {@link #getDisplayedValue displayedValue}.
     *
     * The value label to be displayed near the point in the chart.
     *
     *
     * @returns Value of property `displayedValue`
     */
    getDisplayedValue(): string;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * The bottom label for the chart point.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getSecondaryLabel secondaryLabel}.
     *
     * The label that is displayed right below the `label`..
     *
     *
     * @returns Value of property `secondaryLabel`
     */
    getSecondaryLabel(): string;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Determines if the chart point is selected.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The numeric value of the chart point.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Determines the color of the point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Neutral"`.
     *
     * @since 1.50.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?: ValueColor | keyof typeof ValueColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayedValue displayedValue}.
     *
     * The value label to be displayed near the point in the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayedValue(
      /**
       * New value for property `displayedValue`
       */
      sDisplayedValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * The bottom label for the chart point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryLabel secondaryLabel}.
     *
     * The label that is displayed right below the `label`..
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryLabel(
      /**
       * New value for property `secondaryLabel`
       */
      sSecondaryLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Determines if the chart point is selected.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The numeric value of the chart point.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InteractiveLineChartPoint constructor.
   */
  export interface $InteractiveLineChartPointSettings extends $ElementSettings {
    /**
     * The bottom label for the chart point.
     */
    label?: string | PropertyBindingInfo;

    /**
     * The label that is displayed right below the `label`..
     */
    secondaryLabel?: string | PropertyBindingInfo;

    /**
     * Determines if the chart point is selected.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The numeric value of the chart point.
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The value label to be displayed near the point in the chart.
     */
    displayedValue?: string | PropertyBindingInfo;

    /**
     * Determines the color of the point.
     *
     * @since 1.50.0
     */
    color?:
      | (ValueColor | keyof typeof ValueColor)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/LineMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import LineMicroChartLine from "sap/suite/ui/microchart/LineMicroChartLine";

  import LineMicroChartPoint from "sap/suite/ui/microchart/LineMicroChartPoint";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  /**
   * Chart that displays the history of values as segmented lines along a threshold line. The scale is optional
   * and showing the points is also optional.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string.
   *
   * @since 1.48.0
   */
  export default class LineMicroChart extends Control {
    /**
     * Constructor for a new LineMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LineMicroChartSettings
    );
    /**
     * Constructor for a new LineMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LineMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.LineMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LineMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.LineMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some line to the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addLine(
      /**
       * The line to add; if empty, nothing is inserted
       */
      oLine: LineMicroChartLine
    ): this;
    /**
     * Adds some point to the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPoint(
      /**
       * The point to add; if empty, nothing is inserted
       */
      oPoint: LineMicroChartPoint
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.LineMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.LineMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.LineMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.LineMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.LineMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.LineMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getLines lines} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindLines(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getPoints points} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindPoints(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the lines in the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLines(): this;
    /**
     * Destroys all the points in the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPoints(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.LineMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Describes the color of the chart.
     * In conjunction with emphasized points, it is only used if all points have the sap.m.ValueColor.Neutral
     * color.
     * The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the 'above|' and
     * 'below' properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * The `color` property of {@link sap.suite.ui.microchart.LineMicroChartLine} has priority over this property
     * in case it is set.
     *
     * Default value is `"Neutral"`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): any;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getLeftBottomLabel leftBottomLabel}.
     *
     * Describes the left bottom label of the chart. The label color is set internally. The space for the label
     * is not reserved if the label is not set.
     *
     *
     * @returns Value of property `leftBottomLabel`
     */
    getLeftBottomLabel(): string;
    /**
     * Gets current value of property {@link #getLeftTopLabel leftTopLabel}.
     *
     * Describes the left top label of the chart. The label color is determined by the color property of the
     * first LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     *
     *
     * @returns Value of property `leftTopLabel`
     */
    getLeftTopLabel(): string;
    /**
     * Gets content of aggregation {@link #getLines lines}.
     *
     * Aggregation that containes lines with data points.
     * This aggregation should be used instead of the `points` aggregation.
     */
    getLines(): LineMicroChartLine[];
    /**
     * Gets current value of property {@link #getMaxXValue maxXValue}.
     *
     * If this property is set, it indicates the value the X-axis ends with.
     *
     *
     * @returns Value of property `maxXValue`
     */
    getMaxXValue(): float;
    /**
     * Gets current value of property {@link #getMaxYValue maxYValue}.
     *
     * If this property is set, it indicates the value the Y-axis ends with.
     *
     *
     * @returns Value of property `maxYValue`
     */
    getMaxYValue(): float;
    /**
     * Gets current value of property {@link #getMinXValue minXValue}.
     *
     * If this property is set, it indicates the value the X-axis starts with.
     *
     *
     * @returns Value of property `minXValue`
     */
    getMinXValue(): float;
    /**
     * Gets current value of property {@link #getMinYValue minYValue}.
     *
     * If this property is set, it indicates the value the Y-axis starts with.
     *
     *
     * @returns Value of property `minYValue`
     */
    getMinYValue(): float;
    /**
     * Gets content of aggregation {@link #getPoints points}.
     *
     * Aggregation that contains all data points that should be provided in an ordered way. If both the `points`
     * and `lines` aggregations are used, the chart is rendered based on the `points` aggregation, while the
     * lines from the `lines` aggregations are ignored.
     * The `points` aggregation can be used to ensure backward compatibility. However in general, the `lines`
     * aggregation should be preferred.
     */
    getPoints(): LineMicroChartPoint[];
    /**
     * Gets current value of property {@link #getRightBottomLabel rightBottomLabel}.
     *
     * Describes the right bottom label of the chart. The label color is set automatically. The space for the
     * label is not reserved if the label is not set.
     *
     *
     * @returns Value of property `rightBottomLabel`
     */
    getRightBottomLabel(): string;
    /**
     * Gets current value of property {@link #getRightTopLabel rightTopLabel}.
     *
     * Describes the right top label of the chart. The label color is determined by the color property of the
     * last LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     *
     *
     * @returns Value of property `rightTopLabel`
     */
    getRightTopLabel(): string;
    /**
     * Gets current value of property {@link #getShowBottomLabels showBottomLabels}.
     *
     * If this property is set to `false`, both bottom labels are hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showBottomLabels`
     */
    getShowBottomLabels(): boolean;
    /**
     * Gets current value of property {@link #getShowPoints showPoints}.
     *
     * Defines if the control renders the points or not.
     * If emphasized points are used, there is no effect.
     * If the value is true, the points in the aggregation are shown.
     *
     *
     * The `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChartLine} control has priority
     * over this property in case it is set.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showPoints`
     */
    getShowPoints(): boolean;
    /**
     * Gets current value of property {@link #getShowThresholdLine showThresholdLine}.
     *
     * If this property is set to `false`, the threshold line is hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showThresholdLine`
     */
    getShowThresholdLine(): boolean;
    /**
     * Gets current value of property {@link #getShowThresholdValue showThresholdValue}.
     *
     * If this property is set to `false`, the threshold value is hidden.
     * If this property is set to `true`, the value will be shown only if the `showThresholdLine` property is
     * also set to `true`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showThresholdValue`
     */
    getShowThresholdValue(): boolean;
    /**
     * Gets current value of property {@link #getShowTopLabels showTopLabels}.
     *
     * If this property is set to `false`, both top labels are hidden.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showTopLabels`
     */
    getShowTopLabels(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the type of the device.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getThreshold threshold}.
     *
     * Determines the chart threshold which is used for vertical normalization. If the threshold does not belong
     * to the value range given by minYValue...maxYValue, the threshold is ignored. By setting the threshold
     * property's value to null, the threshold is disabled and excluded from range calculations.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `threshold`
     */
    getThreshold(): float;
    /**
     * Gets current value of property {@link #getThresholdDisplayValue thresholdDisplayValue}.
     *
     * Overrides the threshold value with a string that is shown instead.
     *
     *
     * @returns Value of property `thresholdDisplayValue`
     */
    getThresholdDisplayValue(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.LineMicroChartLine` in the aggregation {@link #getLines lines}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfLine(
      /**
       * The line whose index is looked for
       */
      oLine: LineMicroChartLine
    ): int;
    /**
     * Checks for the provided `sap.suite.ui.microchart.LineMicroChartPoint` in the aggregation {@link #getPoints points}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPoint(
      /**
       * The point whose index is looked for
       */
      oPoint: LineMicroChartPoint
    ): int;
    /**
     * Inserts a line into the aggregation {@link #getLines lines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertLine(
      /**
       * The line to insert; if empty, nothing is inserted
       */
      oLine: LineMicroChartLine,
      /**
       * The `0`-based index the line should be inserted at; for a negative value of `iIndex`, the line is inserted
       * at position 0; for a value greater than the current size of the aggregation, the line is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a point into the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPoint(
      /**
       * The point to insert; if empty, nothing is inserted
       */
      oPoint: LineMicroChartPoint,
      /**
       * The `0`-based index the point should be inserted at; for a negative value of `iIndex`, the point is inserted
       * at position 0; for a value greater than the current size of the aggregation, the point is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getLines lines}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllLines(): LineMicroChartLine[];
    /**
     * Removes all the controls from the aggregation {@link #getPoints points}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPoints(): LineMicroChartPoint[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a line from the aggregation {@link #getLines lines}.
     *
     *
     * @returns The removed line or `null`
     */
    removeLine(
      /**
       * The line to remove or its index or id
       */
      vLine: int | string | LineMicroChartLine
    ): LineMicroChartLine | null;
    /**
     * Removes a point from the aggregation {@link #getPoints points}.
     *
     *
     * @returns The removed point or `null`
     */
    removePoint(
      /**
       * The point to remove or its index or id
       */
      vPoint: int | string | LineMicroChartPoint
    ): LineMicroChartPoint | null;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Describes the color of the chart.
     * In conjunction with emphasized points, it is only used if all points have the sap.m.ValueColor.Neutral
     * color.
     * The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the 'above|' and
     * 'below' properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * The `color` property of {@link sap.suite.ui.microchart.LineMicroChartLine} has priority over this property
     * in case it is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Neutral"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      oColor?: any
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLeftBottomLabel leftBottomLabel}.
     *
     * Describes the left bottom label of the chart. The label color is set internally. The space for the label
     * is not reserved if the label is not set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeftBottomLabel(
      /**
       * New value for property `leftBottomLabel`
       */
      sLeftBottomLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLeftTopLabel leftTopLabel}.
     *
     * Describes the left top label of the chart. The label color is determined by the color property of the
     * first LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeftTopLabel(
      /**
       * New value for property `leftTopLabel`
       */
      sLeftTopLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMaxXValue maxXValue}.
     *
     * If this property is set, it indicates the value the X-axis ends with.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxXValue(
      /**
       * New value for property `maxXValue`
       */
      fMaxXValue: float
    ): this;
    /**
     * Sets a new value for property {@link #getMaxYValue maxYValue}.
     *
     * If this property is set, it indicates the value the Y-axis ends with.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxYValue(
      /**
       * New value for property `maxYValue`
       */
      fMaxYValue: float
    ): this;
    /**
     * Sets a new value for property {@link #getMinXValue minXValue}.
     *
     * If this property is set, it indicates the value the X-axis starts with.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinXValue(
      /**
       * New value for property `minXValue`
       */
      fMinXValue: float
    ): this;
    /**
     * Sets a new value for property {@link #getMinYValue minYValue}.
     *
     * If this property is set, it indicates the value the Y-axis starts with.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinYValue(
      /**
       * New value for property `minYValue`
       */
      fMinYValue: float
    ): this;
    /**
     * Sets a new value for property {@link #getRightBottomLabel rightBottomLabel}.
     *
     * Describes the right bottom label of the chart. The label color is set automatically. The space for the
     * label is not reserved if the label is not set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRightBottomLabel(
      /**
       * New value for property `rightBottomLabel`
       */
      sRightBottomLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRightTopLabel rightTopLabel}.
     *
     * Describes the right top label of the chart. The label color is determined by the color property of the
     * last LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRightTopLabel(
      /**
       * New value for property `rightTopLabel`
       */
      sRightTopLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowBottomLabels showBottomLabels}.
     *
     * If this property is set to `false`, both bottom labels are hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowBottomLabels(
      /**
       * New value for property `showBottomLabels`
       */
      bShowBottomLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPoints showPoints}.
     *
     * Defines if the control renders the points or not.
     * If emphasized points are used, there is no effect.
     * If the value is true, the points in the aggregation are shown.
     *
     *
     * The `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChartLine} control has priority
     * over this property in case it is set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPoints(
      /**
       * New value for property `showPoints`
       */
      bShowPoints?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowThresholdLine showThresholdLine}.
     *
     * If this property is set to `false`, the threshold line is hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowThresholdLine(
      /**
       * New value for property `showThresholdLine`
       */
      bShowThresholdLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowThresholdValue showThresholdValue}.
     *
     * If this property is set to `false`, the threshold value is hidden.
     * If this property is set to `true`, the value will be shown only if the `showThresholdLine` property is
     * also set to `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowThresholdValue(
      /**
       * New value for property `showThresholdValue`
       */
      bShowThresholdValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTopLabels showTopLabels}.
     *
     * If this property is set to `false`, both top labels are hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTopLabels(
      /**
       * New value for property `showTopLabels`
       */
      bShowTopLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the type of the device.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getThreshold threshold}.
     *
     * Determines the chart threshold which is used for vertical normalization. If the threshold does not belong
     * to the value range given by minYValue...maxYValue, the threshold is ignored. By setting the threshold
     * property's value to null, the threshold is disabled and excluded from range calculations.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThreshold(
      /**
       * New value for property `threshold`
       */
      fThreshold?: float
    ): this;
    /**
     * Sets a new value for property {@link #getThresholdDisplayValue thresholdDisplayValue}.
     *
     * Overrides the threshold value with a string that is shown instead.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setThresholdDisplayValue(
      /**
       * New value for property `thresholdDisplayValue`
       */
      sThresholdDisplayValue: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getLines lines} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindLines(): this;
    /**
     * Unbinds aggregation {@link #getPoints points} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindPoints(): this;
  }
  /**
   * Describes the settings that can be provided to the LineMicroChart constructor.
   */
  export interface $LineMicroChartSettings extends $ControlSettings {
    /**
     * The size of the chart. If not set, the default size is applied based on the type of the device.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the chart threshold which is used for vertical normalization. If the threshold does not belong
     * to the value range given by minYValue...maxYValue, the threshold is ignored. By setting the threshold
     * property's value to null, the threshold is disabled and excluded from range calculations.
     */
    threshold?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `false`, the threshold line is hidden.
     */
    showThresholdLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `false`, the threshold value is hidden.
     * If this property is set to `true`, the value will be shown only if the `showThresholdLine` property is
     * also set to `true`.
     */
    showThresholdValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Overrides the threshold value with a string that is shown instead.
     */
    thresholdDisplayValue?: string | PropertyBindingInfo;

    /**
     * If this property is set, it indicates the value the X-axis starts with.
     */
    minXValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set, it indicates the value the X-axis ends with.
     */
    maxXValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set, it indicates the value the Y-axis starts with.
     */
    minYValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set, it indicates the value the Y-axis ends with.
     */
    maxYValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Describes the left top label of the chart. The label color is determined by the color property of the
     * first LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     */
    leftTopLabel?: string | PropertyBindingInfo;

    /**
     * Describes the right top label of the chart. The label color is determined by the color property of the
     * last LineMicroChartPoint in the points aggregation. The space for the label is not reserved if the label
     * is not set.
     */
    rightTopLabel?: string | PropertyBindingInfo;

    /**
     * Describes the left bottom label of the chart. The label color is set internally. The space for the label
     * is not reserved if the label is not set.
     */
    leftBottomLabel?: string | PropertyBindingInfo;

    /**
     * Describes the right bottom label of the chart. The label color is set automatically. The space for the
     * label is not reserved if the label is not set.
     */
    rightBottomLabel?: string | PropertyBindingInfo;

    /**
     * If this property is set to `false`, both top labels are hidden.
     */
    showTopLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this property is set to `false`, both bottom labels are hidden.
     */
    showBottomLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Describes the color of the chart.
     * In conjunction with emphasized points, it is only used if all points have the sap.m.ValueColor.Neutral
     * color.
     * The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the 'above|' and
     * 'below' properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * The `color` property of {@link sap.suite.ui.microchart.LineMicroChartLine} has priority over this property
     * in case it is set.
     */
    color?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines if the control renders the points or not.
     * If emphasized points are used, there is no effect.
     * If the value is true, the points in the aggregation are shown.
     *
     *
     * The `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChartLine} control has priority
     * over this property in case it is set.
     */
    showPoints?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation that contains all data points that should be provided in an ordered way. If both the `points`
     * and `lines` aggregations are used, the chart is rendered based on the `points` aggregation, while the
     * lines from the `lines` aggregations are ignored.
     * The `points` aggregation can be used to ensure backward compatibility. However in general, the `lines`
     * aggregation should be preferred.
     */
    points?:
      | LineMicroChartPoint[]
      | LineMicroChartPoint
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregation that containes lines with data points.
     * This aggregation should be used instead of the `points` aggregation.
     */
    lines?:
      | LineMicroChartLine[]
      | LineMicroChartLine
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the LineMicroChart#press event.
   */
  export interface LineMicroChart$PressEventParameters {}

  /**
   * Event object of the LineMicroChart#press event.
   */
  export type LineMicroChart$PressEvent = Event<
    LineMicroChart$PressEventParameters,
    LineMicroChart
  >;
}

declare module "sap/suite/ui/microchart/LineMicroChartEmphasizedPoint" {
  import {
    default as LineMicroChartPoint,
    $LineMicroChartPointSettings,
  } from "sap/suite/ui/microchart/LineMicroChartPoint";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the emphasized point of the line micro chart.
   *
   * @since 1.48.0
   */
  export default class LineMicroChartEmphasizedPoint extends LineMicroChartPoint {
    /**
     * Constructor for a new LineMicroChartEmphasizedPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartEmphasizedPointSettings
    );
    /**
     * Constructor for a new LineMicroChartEmphasizedPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartEmphasizedPointSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.LineMicroChartEmphasizedPoint with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.suite.ui.microchart.LineMicroChartPoint.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LineMicroChartEmphasizedPoint>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.LineMicroChartEmphasizedPoint.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Determines the color of the emphasized point. The property has an effect only if the 'show' property
     * is true. If at least one emphasized point has a color different from Neutral, the graph is grey; otherwise,
     * the graph is blue.
     *
     * For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts instead of sap.m.ValueCSSColor.
     * The value (or type, or property) will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getShow show}.
     *
     * Determines whether the chart point should be displayed or not.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `show`
     */
    getShow(): boolean;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Determines the color of the emphasized point. The property has an effect only if the 'show' property
     * is true. If at least one emphasized point has a color different from Neutral, the graph is grey; otherwise,
     * the graph is blue.
     *
     * For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts instead of sap.m.ValueCSSColor.
     * The value (or type, or property) will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      sColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getShow show}.
     *
     * Determines whether the chart point should be displayed or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShow(
      /**
       * New value for property `show`
       */
      bShow?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LineMicroChartEmphasizedPoint constructor.
   */
  export interface $LineMicroChartEmphasizedPointSettings
    extends $LineMicroChartPointSettings {
    /**
     * Determines the color of the emphasized point. The property has an effect only if the 'show' property
     * is true. If at least one emphasized point has a color different from Neutral, the graph is grey; otherwise,
     * the graph is blue.
     *
     * For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts instead of sap.m.ValueCSSColor.
     * The value (or type, or property) will only support MicroChartColorType from the SAPUI5 2.0 release.
     */
    color?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the chart point should be displayed or not.
     */
    show?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/LineMicroChartLine" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import LineMicroChartPoint from "sap/suite/ui/microchart/LineMicroChartPoint";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { LineType } from "sap/suite/ui/microchart/library";

  /**
   * The container containing all the points of the line.
   *
   * @since 1.60
   */
  export default class LineMicroChartLine extends UI5Element {
    /**
     * Constructor for a new LineMicroChartLine.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartLineSettings
    );
    /**
     * Constructor for a new LineMicroChartLine.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartLineSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.LineMicroChartLine with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LineMicroChartLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.LineMicroChartLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some point to the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPoint(
      /**
       * The point to add; if empty, nothing is inserted
       */
      oPoint: LineMicroChartPoint
    ): this;
    /**
     * Binds aggregation {@link #getPoints points} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindPoints(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the points in the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPoints(): this;
    /**
     * Gets current value of property {@link #getColor color}.
     *
     * Defines the color of the chart.
     * In conjunction with emphasized points, this property is only used if all points have the {@link sap.m.ValueColor.Neutral }
     * color. The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the `above`
     * and `below` properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * This property has priority over the property `color` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the value of the `color` property from the parent {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     *
     *
     * @returns Value of property `color`
     */
    getColor(): any;
    /**
     * Gets content of aggregation {@link #getPoints points}.
     *
     * Aggregation that contains all data points that should be provided in an ordered way.
     *
     *
     * **Note:** Points can be bound without template/factory method.
     * This approach is more efficient when many points are used, because no new objects will be created for
     * them and only their representation in the model will be kept. See the {@link https://ui5.sap.com/#/sample/sap.suite.ui.microchart.sample.LineMicroChartBinding/preview samples}.
     *
     * To use emphasized points, the `emphasized` property has to be set in the model of the point and can be
     * used together with the properties `show` and `color`, as shown in the sample. When this binding method
     * is used, the #getPoints method will always return an empty array.
     */
    getPoints(): LineMicroChartPoint[];
    /**
     * Gets current value of property {@link #getShowPoints showPoints}.
     *
     * Defines whether the points are shown.
     * If emphasized points are used, this property is ignored.
     * If this property is set to `true`, the points in the `points` aggregation are shown.
     *
     *
     * This property has priority over the property `showPoints` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     *
     *
     * @returns Value of property `showPoints`
     */
    getShowPoints(): boolean;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the type of the line.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): LineType;
    /**
     * Checks for the provided `sap.suite.ui.microchart.LineMicroChartPoint` in the aggregation {@link #getPoints points}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPoint(
      /**
       * The point whose index is looked for
       */
      oPoint: LineMicroChartPoint
    ): int;
    /**
     * Inserts a point into the aggregation {@link #getPoints points}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPoint(
      /**
       * The point to insert; if empty, nothing is inserted
       */
      oPoint: LineMicroChartPoint,
      /**
       * The `0`-based index the point should be inserted at; for a negative value of `iIndex`, the point is inserted
       * at position 0; for a value greater than the current size of the aggregation, the point is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getPoints points}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPoints(): LineMicroChartPoint[];
    /**
     * Removes a point from the aggregation {@link #getPoints points}.
     *
     *
     * @returns The removed point or `null`
     */
    removePoint(
      /**
       * The point to remove or its index or id
       */
      vPoint: int | string | LineMicroChartPoint
    ): LineMicroChartPoint | null;
    /**
     * Sets a new value for property {@link #getColor color}.
     *
     * Defines the color of the chart.
     * In conjunction with emphasized points, this property is only used if all points have the {@link sap.m.ValueColor.Neutral }
     * color. The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the `above`
     * and `below` properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * This property has priority over the property `color` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the value of the `color` property from the parent {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColor(
      /**
       * New value for property `color`
       */
      oColor: any
    ): this;
    /**
     * Sets a new value for property {@link #getShowPoints showPoints}.
     *
     * Defines whether the points are shown.
     * If emphasized points are used, this property is ignored.
     * If this property is set to `true`, the points in the `points` aggregation are shown.
     *
     *
     * This property has priority over the property `showPoints` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPoints(
      /**
       * New value for property `showPoints`
       */
      bShowPoints: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the type of the line.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Solid`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: LineType | keyof typeof LineType
    ): this;
    /**
     * Unbinds aggregation {@link #getPoints points} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindPoints(): this;
  }
  /**
   * Describes the settings that can be provided to the LineMicroChartLine constructor.
   */
  export interface $LineMicroChartLineSettings extends $ElementSettings {
    /**
     * Defines the color of the chart.
     * In conjunction with emphasized points, this property is only used if all points have the {@link sap.m.ValueColor.Neutral }
     * color. The color can be set as an {@link sap.m.ValueCSSColor} or as a plain object. It has the `above`
     * and `below` properties that determine the color of the graph above and below the threshold, respectively.
     *
     *
     * This property has priority over the property `color` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the value of the `color` property from the parent {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     */
    color?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the points are shown.
     * If emphasized points are used, this property is ignored.
     * If this property is set to `true`, the points in the `points` aggregation are shown.
     *
     *
     * This property has priority over the property `showPoints` of {@link sap.suite.ui.microchart.LineMicroChart }
     * in case it is set.
     * If this property is not defined, the `showPoints` property of the {@link sap.suite.ui.microchart.LineMicroChart }
     * is used instead.
     */
    showPoints?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the type of the line.
     */
    type?:
      | (LineType | keyof typeof LineType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Aggregation that contains all data points that should be provided in an ordered way.
     *
     *
     * **Note:** Points can be bound without template/factory method.
     * This approach is more efficient when many points are used, because no new objects will be created for
     * them and only their representation in the model will be kept. See the {@link https://ui5.sap.com/#/sample/sap.suite.ui.microchart.sample.LineMicroChartBinding/preview samples}.
     *
     * To use emphasized points, the `emphasized` property has to be set in the model of the point and can be
     * used together with the properties `show` and `color`, as shown in the sample. When this binding method
     * is used, the #getPoints method will always return an empty array.
     */
    points?:
      | LineMicroChartPoint[]
      | LineMicroChartPoint
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/LineMicroChartPoint" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the point of the line micro chart.
   *
   * @since 1.48.0
   */
  export default class LineMicroChartPoint extends UI5Element {
    /**
     * Constructor for a new LineMicroChartPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartPointSettings
    );
    /**
     * Constructor for a new LineMicroChartPoint.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LineMicroChartPointSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.LineMicroChartPoint with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LineMicroChartPoint>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.LineMicroChartPoint.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getX x}.
     *
     * The point's horizontal position.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `x`
     */
    getX(): float;
    /**
     * Gets current value of property {@link #getY y}.
     *
     * The point's vertical position.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `y`
     */
    getY(): float;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * The point's horizontal position.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX?: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * The point's vertical position.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LineMicroChartPoint constructor.
   */
  export interface $LineMicroChartPointSettings extends $ElementSettings {
    /**
     * The point's horizontal position.
     */
    x?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The point's vertical position.
     */
    y?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/suite/ui/microchart/RadialMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import {
    HorizontalAlignmentType,
    MicroChartColorType,
  } from "sap/suite/ui/microchart/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size, ValueCSSColor } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Displays a ring chart highlighting a current status. The status is displayed with a semantically colored
   * radial bar and a percentage value.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string.
   *
   * @since 1.36.0
   */
  export default class RadialMicroChart extends Control {
    /**
     * Describes the configuration of the graphic element on the chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.RadialMicroChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RadialMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.RadialMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.RadialMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.RadialMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.RadialMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.RadialMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.RadialMicroChart` itself.
     *
     * The event is triggered when the chart is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.RadialMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.RadialMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAlignContent alignContent}.
     *
     * The alignment of the content. If it is not set, the `Left` alignment type is used.
     *
     * Default value is `"Left"`.
     *
     * @since 1.62.0
     *
     * @returns Value of property `alignContent`
     */
    getAlignContent(): HorizontalAlignmentType;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getFraction fraction}.
     *
     * The fraction of the total value that is displayed.
     *
     *
     * @returns Value of property `fraction`
     */
    getFraction(): float;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * @since 1.62.0
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getPercentage percentage}.
     *
     * The percentage that is displayed. When a percentage is set, properties total and fraction are not considered.
     *
     *
     * @returns Value of property `percentage`
     */
    getPercentage(): float;
    /**
     * Gets current value of property {@link #getShowPercentageSymbol showPercentageSymbol}.
     *
     * If set to true, the percentage symbol(%) is displayed. If set to false, the percentage symbol(%) is not
     * displayed.
     *
     * Default value is `true`.
     *
     * @since 1.121.0
     * @deprecated As of version 1.123.0. Setting this property does not have any impact on the display of the
     * percentage symbol(%)
     *
     * @returns Value of property `showPercentageSymbol`
     */
    getShowPercentageSymbol(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the chart. If it is not set, the Auto size is used.
     *
     * Default value is `"Auto"`.
     *
     * @since 1.44.0
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getTotal total}.
     *
     * The total value. This is taken as 360 degrees value on the chart.
     *
     *
     * @returns Value of property `total`
     */
    getTotal(): float;
    /**
     * Gets current value of property {@link #getValueColor valueColor}.
     *
     * The color shown in the completed path. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value (or type, or property) will only support MicroChartColorType
     * from the SAPUI5 2.0 release.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Value of property `valueColor`
     */
    getValueColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * @since 1.62.0
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAlignContent alignContent}.
     *
     * The alignment of the content. If it is not set, the `Left` alignment type is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Left"`.
     *
     * @since 1.62.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAlignContent(
      /**
       * New value for property `alignContent`
       */
      sAlignContent?:
        | HorizontalAlignmentType
        | keyof typeof HorizontalAlignmentType
    ): this;
    /**
     * Sets a new value for property {@link #getFraction fraction}.
     *
     * The fraction of the total value that is displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFraction(
      /**
       * New value for property `fraction`
       */
      fFraction?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.62.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPercentage percentage}.
     *
     * The percentage that is displayed. When a percentage is set, properties total and fraction are not considered.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPercentage(
      /**
       * New value for property `percentage`
       */
      fPercentage?: float
    ): this;
    /**
     * Sets a new value for property {@link #getShowPercentageSymbol showPercentageSymbol}.
     *
     * If set to true, the percentage symbol(%) is displayed. If set to false, the percentage symbol(%) is not
     * displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.121.0
     * @deprecated As of version 1.123.0. Setting this property does not have any impact on the display of the
     * percentage symbol(%)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPercentageSymbol(
      /**
       * New value for property `showPercentageSymbol`
       */
      bShowPercentageSymbol?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the chart. If it is not set, the Auto size is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Auto"`.
     *
     * @since 1.44.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getTotal total}.
     *
     * The total value. This is taken as 360 degrees value on the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTotal(
      /**
       * New value for property `total`
       */
      fTotal: float
    ): this;
    /**
     * Sets a new value for property {@link #getValueColor valueColor}.
     *
     * The color shown in the completed path. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value (or type, or property) will only support MicroChartColorType
     * from the SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MicroChartColorType.Neutral`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueColor(
      /**
       * New value for property `valueColor`
       */
      sValueColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.62.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RadialMicroChart constructor.
   */
  export interface $RadialMicroChartSettings extends $ControlSettings {
    /**
     * The total value. This is taken as 360 degrees value on the chart.
     */
    total?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The fraction of the total value that is displayed.
     */
    fraction?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The percentage that is displayed. When a percentage is set, properties total and fraction are not considered.
     */
    percentage?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The color shown in the completed path. For SAPUI5 1.x releases, we are going to use string as the type
     * for Micro Charts instead of sap.m.ValueCSSColor. The value (or type, or property) will only support MicroChartColorType
     * from the SAPUI5 2.0 release.
     */
    valueColor?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The size of the chart. If it is not set, the Auto size is used.
     *
     * @since 1.44.0
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * @since 1.62.0
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * @since 1.62.0
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The alignment of the content. If it is not set, the `Left` alignment type is used.
     *
     * @since 1.62.0
     */
    alignContent?:
      | (HorizontalAlignmentType | keyof typeof HorizontalAlignmentType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to true, the percentage symbol(%) is displayed. If set to false, the percentage symbol(%) is not
     * displayed.
     *
     * @since 1.121.0
     * @deprecated As of version 1.123.0. Setting this property does not have any impact on the display of the
     * percentage symbol(%)
     */
    showPercentageSymbol?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is triggered when the chart is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the RadialMicroChart#press event.
   */
  export interface RadialMicroChart$PressEventParameters {}

  /**
   * Event object of the RadialMicroChart#press event.
   */
  export type RadialMicroChart$PressEvent = Event<
    RadialMicroChart$PressEventParameters,
    RadialMicroChart
  >;
}

declare module "sap/suite/ui/microchart/StackedBarMicroChart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import StackedBarMicroChartBar from "sap/suite/ui/microchart/StackedBarMicroChartBar";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size } from "sap/m/library";

  /**
   * Illustrates values as stacked and colored bar charts displaying numeric values (as absolute values or
   * percentages) inside the bars.
   * Note: You can assign a custom tooltip for this microchart. The custom tooltip can be set using expression
   * binding. When no custom tooltip is defined, the tooltip is generated automatically based on the logic
   * described in {@link sap.ui.core.Element#getTooltip_AsString}. For a combination of a generated and a
   * custom tooltip, use `((AltText))` inside of the tooltip string. The aggregated data of the microchart
   * can also be customized.
   *
   * @since 1.44.0
   */
  export default class StackedBarMicroChart extends Control {
    /**
     * Constructor for a new StackedBarMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedBarMicroChartSettings
    );
    /**
     * Constructor for a new StackedBarMicroChart control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedBarMicroChartSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.StackedBarMicroChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StackedBarMicroChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.StackedBarMicroChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some bar to the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addBar(
      /**
       * The bar to add; if empty, nothing is inserted
       */
      oBar: StackedBarMicroChartBar
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.StackedBarMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.StackedBarMicroChart` itself.
     *
     * The event is fired when the user chooses the microchart.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.StackedBarMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.suite.ui.microchart.StackedBarMicroChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.suite.ui.microchart.StackedBarMicroChart` itself.
     *
     * The event is fired when the user chooses the microchart.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.suite.ui.microchart.StackedBarMicroChart`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getBars bars} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindBars(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the bars in the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBars(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.suite.ui.microchart.StackedBarMicroChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getBars bars}.
     *
     * The stacked bar chart items.
     */
    getBars(): StackedBarMicroChartBar[];
    /**
     * Gets current value of property {@link #getDisplayZeroValue displayZeroValue}.
     *
     * Defines whether stacked bars with zero value should be rendered. The default is `true` where these zero
     * value stacked bars are rendered with a minimum width of 0.25rem.
     *
     * Default value is `true`.
     *
     * @since 1.76
     *
     * @returns Value of property `displayZeroValue`
     */
    getDisplayZeroValue(): boolean;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Value of property `hideOnNoData`
     */
    getHideOnNoData(): boolean;
    /**
     * Gets current value of property {@link #getMaxValue maxValue}.
     *
     * The maximum value can be set to scale StackedBarMicroChartBar values to the same base. If maxValue is
     * smaller than the sum of all StackedMicroChartBar values, the maxValue is ignored. All values are shown
     * as percentage values (same behavior as maxValue is not used). If maxValue is equal or bigger than the
     * sum of all StackedMicroChartBars, all values are scaled to the value of maxValue and the percentage mode
     * is turned off. Absolute values are shown instead. The difference between the sum and maxValue is shown
     * as invisible bar, thus e.g. different StackedBarMicroChart instances can be compared.
     *
     *
     * @returns Value of property `maxValue`
     */
    getMaxValue(): float;
    /**
     * Gets current value of property {@link #getPrecision precision}.
     *
     * The precision of the rounding for the calculated percentage values of the bars. It defines how many digits
     * after the decimal point are displayed. The default is set to 1 digit.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `precision`
     */
    getPrecision(): int;
    /**
     * Gets current value of property {@link #getShowLabels showLabels}.
     *
     * Defines whether the bar labels should be rendered. If set to `true`, the labels that were specified for
     * each bar become visible.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLabels`
     */
    getShowLabels(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the stacked bar micro chart is included.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.suite.ui.microchart.StackedBarMicroChartBar` in the aggregation {@link #getBars bars}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfBar(
      /**
       * The bar whose index is looked for
       */
      oBar: StackedBarMicroChartBar
    ): int;
    /**
     * Inserts a bar into the aggregation {@link #getBars bars}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertBar(
      /**
       * The bar to insert; if empty, nothing is inserted
       */
      oBar: StackedBarMicroChartBar,
      /**
       * The `0`-based index the bar should be inserted at; for a negative value of `iIndex`, the bar is inserted
       * at position 0; for a value greater than the current size of the aggregation, the bar is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getBars bars}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllBars(): StackedBarMicroChartBar[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.60.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a bar from the aggregation {@link #getBars bars}.
     *
     *
     * @returns The removed bar or `null`
     */
    removeBar(
      /**
       * The bar to remove or its index or id
       */
      vBar: int | string | StackedBarMicroChartBar
    ): StackedBarMicroChartBar | null;
    /**
     * Sets a new value for property {@link #getDisplayZeroValue displayZeroValue}.
     *
     * Defines whether stacked bars with zero value should be rendered. The default is `true` where these zero
     * value stacked bars are rendered with a minimum width of 0.25rem.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayZeroValue(
      /**
       * New value for property `displayZeroValue`
       */
      bDisplayZeroValue?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the chart. Overrides the height specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHideOnNoData hideOnNoData}.
     *
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOnNoData(
      /**
       * New value for property `hideOnNoData`
       */
      bHideOnNoData?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMaxValue maxValue}.
     *
     * The maximum value can be set to scale StackedBarMicroChartBar values to the same base. If maxValue is
     * smaller than the sum of all StackedMicroChartBar values, the maxValue is ignored. All values are shown
     * as percentage values (same behavior as maxValue is not used). If maxValue is equal or bigger than the
     * sum of all StackedMicroChartBars, all values are scaled to the value of maxValue and the percentage mode
     * is turned off. Absolute values are shown instead. The difference between the sum and maxValue is shown
     * as invisible bar, thus e.g. different StackedBarMicroChart instances can be compared.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxValue(
      /**
       * New value for property `maxValue`
       */
      fMaxValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getPrecision precision}.
     *
     * The precision of the rounding for the calculated percentage values of the bars. It defines how many digits
     * after the decimal point are displayed. The default is set to 1 digit.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrecision(
      /**
       * New value for property `precision`
       */
      iPrecision?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowLabels showLabels}.
     *
     * Defines whether the bar labels should be rendered. If set to `true`, the labels that were specified for
     * each bar become visible.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLabels(
      /**
       * New value for property `showLabels`
       */
      bShowLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * The size of the chart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the stacked bar micro chart is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the chart. Overrides the width specified in the `size` property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getBars bars} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindBars(): this;
  }
  /**
   * Describes the settings that can be provided to the StackedBarMicroChart constructor.
   */
  export interface $StackedBarMicroChartSettings extends $ControlSettings {
    /**
     * The size of the chart. If not set, the default size is applied based on the size of the device tile.
     * Responsive size takes width and height of the parent container where the stacked bar micro chart is included.
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The maximum value can be set to scale StackedBarMicroChartBar values to the same base. If maxValue is
     * smaller than the sum of all StackedMicroChartBar values, the maxValue is ignored. All values are shown
     * as percentage values (same behavior as maxValue is not used). If maxValue is equal or bigger than the
     * sum of all StackedMicroChartBars, all values are scaled to the value of maxValue and the percentage mode
     * is turned off. Absolute values are shown instead. The difference between the sum and maxValue is shown
     * as invisible bar, thus e.g. different StackedBarMicroChart instances can be compared.
     */
    maxValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The precision of the rounding for the calculated percentage values of the bars. It defines how many digits
     * after the decimal point are displayed. The default is set to 1 digit.
     */
    precision?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether stacked bars with zero value should be rendered. The default is `true` where these zero
     * value stacked bars are rendered with a minimum width of 0.25rem.
     *
     * @since 1.76
     */
    displayZeroValue?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the chart. Overrides the width specified in the `size` property.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the chart. Overrides the height specified in the `size` property.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the bar labels should be rendered. If set to `true`, the labels that were specified for
     * each bar become visible.
     */
    showLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to True, the control will be hidden in 'No data' scenario.
     *
     * @since 1.84
     */
    hideOnNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The stacked bar chart items.
     */
    bars?:
      | StackedBarMicroChartBar[]
      | StackedBarMicroChartBar
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Controls or IDs that label this control. Can be used by screen reader software.
     *
     * @since 1.60.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * The event is fired when the user chooses the microchart.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the StackedBarMicroChart#press event.
   */
  export interface StackedBarMicroChart$PressEventParameters {}

  /**
   * Event object of the StackedBarMicroChart#press event.
   */
  export type StackedBarMicroChart$PressEvent = Event<
    StackedBarMicroChart$PressEventParameters,
    StackedBarMicroChart
  >;
}

declare module "sap/suite/ui/microchart/StackedBarMicroChartBar" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { MicroChartColorType } from "sap/suite/ui/microchart/library";

  import { ValueCSSColor } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains the values of the stacked bar chart.
   *
   * @since 1.44.0
   */
  export default class StackedBarMicroChartBar extends UI5Element {
    /**
     * Constructor for a new StackedBarMicroChartBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedBarMicroChartBarSettings
    );
    /**
     * Constructor for a new StackedBarMicroChartBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedBarMicroChartBarSettings
    );

    /**
     * Creates a new subclass of class sap.suite.ui.microchart.StackedBarMicroChartBar with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StackedBarMicroChartBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.suite.ui.microchart.StackedBarMicroChartBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDisplayValue displayValue}.
     *
     * If this property is set, then it will be displayed instead of value.
     *
     *
     * @returns Value of property `displayValue`
     */
    getDisplayValue(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The value for stacked bar chart. It is used in order to determine the width of the bar
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): float;
    /**
     * Gets current value of property {@link #getValueColor valueColor}.
     *
     * The color of the bar. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     *
     * @returns Value of property `valueColor`
     */
    getValueColor(): MicroChartColorType | ValueCSSColor;
    /**
     * Sets a new value for property {@link #getDisplayValue displayValue}.
     *
     * If this property is set, then it will be displayed instead of value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayValue(
      /**
       * New value for property `displayValue`
       */
      sDisplayValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The value for stacked bar chart. It is used in order to determine the width of the bar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      fValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getValueColor valueColor}.
     *
     * The color of the bar. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueColor(
      /**
       * New value for property `valueColor`
       */
      sValueColor?:
        | (MicroChartColorType | keyof typeof MicroChartColorType)
        | ValueCSSColor
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StackedBarMicroChartBar constructor.
   */
  export interface $StackedBarMicroChartBarSettings extends $ElementSettings {
    /**
     * The value for stacked bar chart. It is used in order to determine the width of the bar
     */
    value?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The color of the bar. For SAPUI5 1.x releases, we are going to use string as the type for Micro Charts
     * instead of sap.m.ValueCSSColor. The value will only support MicroChartColorType from the SAPUI5 2.0 release.
     */
    valueColor?:
      | (MicroChartColorType | keyof typeof MicroChartColorType)
      | ValueCSSColor
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If this property is set, then it will be displayed instead of value.
     */
    displayValue?: string | PropertyBindingInfo;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/suite/ui/microchart/AreaMicroChart": undefined;

    "sap/suite/ui/microchart/AreaMicroChartItem": undefined;

    "sap/suite/ui/microchart/AreaMicroChartLabel": undefined;

    "sap/suite/ui/microchart/AreaMicroChartPoint": undefined;

    "sap/suite/ui/microchart/BulletMicroChart": undefined;

    "sap/suite/ui/microchart/BulletMicroChartData": undefined;

    "sap/suite/ui/microchart/ColumnMicroChart": undefined;

    "sap/suite/ui/microchart/ColumnMicroChartData": undefined;

    "sap/suite/ui/microchart/ColumnMicroChartLabel": undefined;

    "sap/suite/ui/microchart/ComparisonMicroChart": undefined;

    "sap/suite/ui/microchart/ComparisonMicroChartData": undefined;

    "sap/suite/ui/microchart/DeltaMicroChart": undefined;

    "sap/suite/ui/microchart/HarveyBallMicroChart": undefined;

    "sap/suite/ui/microchart/HarveyBallMicroChartItem": undefined;

    "sap/suite/ui/microchart/InteractiveBarChart": undefined;

    "sap/suite/ui/microchart/InteractiveBarChartBar": undefined;

    "sap/suite/ui/microchart/InteractiveDonutChart": undefined;

    "sap/suite/ui/microchart/InteractiveDonutChartSegment": undefined;

    "sap/suite/ui/microchart/InteractiveLineChart": undefined;

    "sap/suite/ui/microchart/InteractiveLineChartPoint": undefined;

    "sap/suite/ui/microchart/library": undefined;

    "sap/suite/ui/microchart/LineMicroChart": undefined;

    "sap/suite/ui/microchart/LineMicroChartEmphasizedPoint": undefined;

    "sap/suite/ui/microchart/LineMicroChartLine": undefined;

    "sap/suite/ui/microchart/LineMicroChartPoint": undefined;

    "sap/suite/ui/microchart/RadialMicroChart": undefined;

    "sap/suite/ui/microchart/StackedBarMicroChart": undefined;

    "sap/suite/ui/microchart/StackedBarMicroChartBar": undefined;
  }
}
