import { ChangeAction } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
/**
 * Fix to rename the identifier of an attribute in an HTML tag.
 * @param attribute The identifier to be renamed.
 * @param newName The new identifier for the attribute.
 */
export default class RenameAttributeFix extends HtmlFix {
    newName;
    startPositionDetail;
    endPositionDetail;
    constructor(attribute, newName) {
        super();
        this.newName = newName;
        this.startPositionDetail = attribute.name.start;
        this.endPositionDetail = attribute.name.end;
    }
    calculateSourceCodeRange(toPosition) {
        this.startPos = toPosition(this.startPositionDetail);
        this.endPos = toPosition(this.endPositionDetail);
    }
    generateChanges() {
        if (this.startPos === undefined || this.endPos === undefined) {
            throw new Error("Start and end position are not defined");
        }
        return {
            action: ChangeAction.REPLACE,
            start: this.startPos,
            end: this.endPos,
            value: this.newName,
        };
    }
}
//# sourceMappingURL=RenameAttributeFix.js.map