"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValue = void 0;
const getValue = (dataWithPosition) => {
    if (typeof dataWithPosition === "undefined") {
        return undefined;
    }
    if (Array.isArray(dataWithPosition)) {
        return dataWithPosition.map((el) => (0, exports.getValue)(el));
    }
    const value = dataWithPosition.valueOf();
    if (value instanceof Object) {
        const result = {};
        for (const key in dataWithPosition) {
            // istanbul ignore next
            if (Object.prototype.hasOwnProperty.call(dataWithPosition, key)) {
                result[key] = (0, exports.getValue)(dataWithPosition[key]);
            }
        }
        return result;
    }
    else {
        return value;
    }
};
exports.getValue = getValue;
//# sourceMappingURL=getValue.js.map