"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = transformer;
var _movePropIntoSlots = _interopRequireDefault(require("../utils/movePropIntoSlots"));
var _movePropIntoSlotProps = _interopRequireDefault(require("../utils/movePropIntoSlotProps"));
/**
 * @param {import('jscodeshift').FileInfo} file
 * @param {import('jscodeshift').API} api
 */
function transformer(file, api, options) {
  const j = api.jscodeshift;
  const root = j(file.source);
  const printOptions = options.printOptions;
  (0, _movePropIntoSlots.default)(j, {
    root,
    componentName: 'SpeedDial',
    propName: 'TransitionComponent',
    slotName: 'transition'
  });
  (0, _movePropIntoSlotProps.default)(j, {
    root,
    componentName: 'SpeedDial',
    propName: 'TransitionProps',
    slotName: 'transition'
  });
  return root.toSource(printOptions);
}