// For Library Version: 0.0.1

declare module "sap/cux/home/AppsContainer" {
  import {
    default as BaseContainer,
    $BaseContainerSettings,
  } from "sap/cux/home/BaseContainer";

  /**
   * Container class for managing and storing apps.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class AppsContainer extends BaseContainer {
    /**
     * Constructor for a new app container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.AppsContainer.$AppsContainerSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the AppsContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $AppsContainerSettings extends $BaseContainerSettings {}
}

declare module "sap/cux/home/BaseContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Button from "sap/m/Button";

  import BasePanel from "sap/cux/home/BasePanel";

  import MenuItem from "sap/cux/home/MenuItem";

  /**
   * Abstract base class for all container controls in the Home Page Layout.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class BaseContainer extends Control {
    /**
     * Constructor for a new Base Container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseContainer.$BaseContainerSettings */ any
    );

    /**
     * Gets current value of property height.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property width.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property height.
     *
     *
     * @returns Value of property `height`
     */
    setHeight(): CSSSize;
    /**
     * Gets current value of property width.
     *
     *
     * @returns Value of property `width`
     */
    setWidth(): CSSSize;
  }
  /**
   * Describes the settings that can be provided to the BaseContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $BaseContainerSettings extends $ControlSettings {
    /**
     * Height to be set for the container.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Width to be set for the container.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * This aggregation contains the actions that should be displayed within the container.
     */
    actionButtons?: Button[] | Button | AggregationBindingInfo | `{${string}}`;

    /**
     * The container content aggregation which should be of type BasePanel.
     */
    content?: BasePanel[] | BasePanel | AggregationBindingInfo | `{${string}}`;

    /**
     * This aggregation holds the items that should be shown within the dropdown menu of the container.
     */
    menuItems?: MenuItem[] | MenuItem | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/cux/home/BaseLayout" {
  import { default as Page, $PageSettings } from "sap/m/Page";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Abstract base class for My Home layout.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class BaseLayout extends Page {
    /**
     * Constructor for a new Base Layout.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseLayout.$BaseLayoutSettings */ any
    );

    /**
     * Gets current value of property persContainerId.
     *
     *
     * @returns Value of property `persContainerId`
     */
    getPersContainerId(): string;
    /**
     * Gets current value of property persContainerId.
     *
     *
     * @returns Value of property `persContainerId`
     */
    setPersContainerId(): string;
    /**
     * Sets SettingsDialog aggregation.
     * Overridden to update cached settings panels.
     * Sets the aggregated settingsDialog.
     * The settings dialog aggregation which controls settings for my home controls.
     * It should be of type BaseSettingsDialog.
     * If Not provided, a default settings dialog will be created from sap.cux.home.SettingsDialog.
     * In case of only custom settings panels, the settings dialog should be created and set manually from sap.cux.home.SettingsDialog.
     *
     *
     *
     * @returns the dialog for chaining
     */
    setSettingsDialog(): this;
  }
  /**
   * Describes the settings that can be provided to the BaseLayout constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $BaseLayoutSettings extends $PageSettings {
    /**
     * Container ID for Ushell Personalisation.
     * This property holds the ID of the personalization container.
     * It is used to store and retrieve personalized settings for the control.
     */
    persContainerId?: string | PropertyBindingInfo;
  }
}

declare module "sap/cux/home/BasePanel" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  /**
   * Abstract base class for all panels placed in {@link sap.cux.home.BaseContainer }.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class BasePanel extends UI5Element {
    /**
     * Constructor for a new Base Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePanel.$BasePanelSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the BasePanel constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $BasePanelSettings extends $ElementSettings {}
}

declare module "sap/cux/home/BaseSettingsDialog" {
  import { default as Dialog, $DialogSettings } from "sap/m/Dialog";

  import BaseSettingsPanel from "sap/cux/home/BaseSettingsPanel";

  /**
   * Abstract base class for custom settings dialog for {@link sap.cux.home.BaseLayout }.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class BaseSettingsDialog extends Dialog {
    /**
     * Constructor for a new Base Settings Dialog.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseSettingsDialog.$BaseSettingsDialogSettings */ any
    );

    /**
     * Adds a new panel at the end of the available panels.
     * Overridden to update cached panels.
     * Adds some panel to the aggregation "panels".
     * Contains the panels aggregation and should be of type BaseSettingsPanel.
     *
     *
     *
     * @returns the dialog for chaining
     */
    addPanel(): BaseSettingsDialog;
    /**
     * Returns all the panels in the dialog.
     * Overridden to return cached panels.
     * Gets content of aggregation "panels".
     * Contains the panels aggregation and should be of type BaseSettingsPanel.
     *
     *
     *
     * @returns panel array
     */
    getPanels(): BaseSettingsPanel[];
    /**
     * Init lifecycle method
     */
    init(): void;
    /**
     * Adds a new panel to the 'panels' aggregation at the index.
     * Overridden to update cached panels.
     * Inserts a panel into the aggregation "panels".
     * Contains the panels aggregation and should be of type BaseSettingsPanel.
     *
     *
     *
     * @returns Returns 'this' to allow method chaining.
     */
    insertPanel(
      /**
       * The panel to insert.
       */
      panel: BaseSettingsPanel,
      /**
       * The index at which to insert the panel.
       */
      index: number
    ): BaseSettingsDialog;
    /**
     * Removes all panels from the dialog, clears the internal panel cache.
     * Overridden to update cached panels.
     * Removes all the controls from the aggregation "panels".
     * Additionally, it unregisters them from the hosting UIArea.
     * Contains the panels aggregation and should be of type BaseSettingsPanel.
     *
     *
     *
     * @returns An empty array representing the removed panels.
     */
    removeAllPanels(): BaseSettingsPanel[];
    /**
     * Removes a panel from the dialog and updates the cache.
     * Removes a panel from the aggregation "panels".
     * Contains the panels aggregation and should be of type BaseSettingsPanel.
     *
     *
     *
     * @returns The removed panel.
     */
    removePanel(
      /**
       * - The panel to remove.
       */
      panel: BaseSettingsPanel
    ): BaseSettingsPanel;
  }
  /**
   * Describes the settings that can be provided to the BaseSettingsDialog constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $BaseSettingsDialogSettings extends $DialogSettings {}
}

declare module "sap/cux/home/BaseSettingsPanel" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Button from "sap/m/Button";

  /**
   * Abstract base class for panels inside My Home Settings Dialog.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class BaseSettingsPanel extends UI5Element {
    /**
     * Constructor for a new Base Settings Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseSettingsPanel.$BaseSettingsPanelSettings */ any
    );

    /**
     * Adds an action button to the panel.
     *
     *
     * @returns The instance of the panel for chaining.
     */
    addActionButton(
      /**
       * - The button to add.
       */
      button: Button
    ): BaseSettingsPanel;
    /**
     * Add Changes made by user in case of KeyUser Settings Panel.
     */
    addKeyUserChanges(): void;
    /**
     * Clear all KeyUser Changes made by user.
     */
    clearKeyUserChanges(): void;
    /**
     * Retrieves the action buttons from the panel.
     *
     *
     * @returns array of action buttons.
     */
    getActionButtons(): Button[];
    /**
     * Returns the KeyUser Changes made by user.
     */
    getKeyUserChanges(): /* was: sap.cux.home.interface.KeyUserInterface.IKeyUserChange */ any[];
    /**
     * Init lifecycle method
     */
    init(): void;
    /**
     * Inserts an action button at a specific index in the panel.
     *
     *
     * @returns The instance of the panel for chaining.
     */
    insertActionButton(
      /**
       * - The button to insert.
       */
      button: Button,
      /**
       * - The index at which to insert the button.
       */
      index: number
    ): BaseSettingsPanel;
    /**
     * Checks if the panel is supported. To be overridden by subclasses.
     *
     *
     * @returns A promise that resolves to true if the panel is supported.
     */
    isSupported(): Promise<boolean>;
    /**
     * Removes an action button from the panel.
     *
     *
     * @returns The removed button or null if not found.
     */
    removeActionButton(
      /**
       * - The button to remove.
       */
      button: Button
    ): null | Button;
  }
  /**
   * Describes the settings that can be provided to the BaseSettingsPanel constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $BaseSettingsPanelSettings extends $ElementSettings {}
}

declare module "sap/cux/home/CardsPanel" {
  import {
    default as BasePanel,
    $BasePanelSettings,
  } from "sap/cux/home/BasePanel";

  /**
   * Panel class for managing and storing Insights Cards.
   *
   * @since 1.122.0
   * @experimental As of version 1.122.0.
   */
  export default class CardsPanel extends BasePanel {
    /**
     * Constructor for a new card panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.CardsPanel.$CardsPanelSettings */ any
    );

    /**
     * Triggers a full refresh of the Insights Cards's data and UI.
     * Reloads all the user cards within the Insights Cards section by reinitializing relevant services
     * and re-rendering the panel.
     *
     *
     *
     * @returns A promise that resolves once the Insights Cards section has been refreshed.
     */
    refreshData(): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the CardsPanel constructor.
   *
   * @experimental As of version 1.122.0.
   */
  export interface $CardsPanelSettings extends $BasePanelSettings {}
}

declare module "sap/cux/home/FavAppPanel" {
  /**
   * Provides the FavAppPanel Class.
   *
   * @since 1.121.0
   * @experimental As of version 1.121.0.
   */
  export default class FavAppPanel
    extends /* was: sap.cux.home.BaseAppPersPanel */ Object
  {
    /**
     * Constructor for a new favorite app panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePanel.$BasePanelSettings */ any
    );
  }
}

declare module "sap/cux/home/FrequentAppPanel" {
  /**
   * Provides the class for managing frequent apps.
   *
   * @since 1.121.0
   * @experimental As of version 1.121.0.
   */
  export default class FrequentAppPanel
    extends /* was: sap.cux.home.BaseAppPersPanel */ Object
  {
    /**
     * Constructor for a new frequent app panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePanel.$BasePanelSettings */ any
    );
  }
}

declare module "sap/cux/home/InsightsContainer" {
  import {
    default as BaseContainer,
    $BaseContainerSettings,
  } from "sap/cux/home/BaseContainer";

  /**
   * Container class for managing and storing Insights Tiles and Insights Cards.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class InsightsContainer extends BaseContainer {
    /**
     * Constructor for a new Insights container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseContainer.$BaseContainerSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the InsightsContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $InsightsContainerSettings extends $BaseContainerSettings {}
}

declare module "sap/cux/home/IToDoPanel" {
  import Context from "sap/ui/model/Context";

  import Control from "sap/ui/core/Control";

  /**
   * Common Interface for creating To-Do Panels displayed in the {@link sap.cux.home.ToDosContainer }.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export interface IToDoPanel {
    __implements__sap_cux_home_IToDoPanel: boolean;

    /**
     * Generate a default card template for the To Do Panel.
     * An extended panel can have it's own template by overridding
     * this method and providing a custom card template.
     *
     *
     * @returns The generated card template.
     */
    generateCardTemplate(
      /**
       * The ID for the template.
       */
      id: string,
      /**
       * The context required for the template.
       */
      context: Context
    ): Control;
    /**
     * Provides custom request URLs specific to the To-Do Panel.
     *
     *
     * @returns An array of request URLs.
     */
    generateRequestUrls(
      /**
       * - The number of cards which will be displayed in the To-Do Panel.
       */
      cardCount: number
    ): string[];
    /**
     * Retrieves the text for the "No Data" message for the To-Do Panel.
     *
     *
     * @returns The text for the "No Data" message.
     */
    getNoDataText(): string;
    /**
     * Handles the data received from a batch request.
     * This hook can be used to process the data before it is displayed.
     *
     *
     * @returns A promise that resolves when the data has been processed.
     */
    onDataReceived(
      /**
       * - The data received from the request.
       */
      data: any[],
      /**
       * - Optional request options.
       */
      options?: /* was: sap.cux.home.ToDoPanel.RequestOptions */ any
    ): Promise<void>;
  }
}

declare module "sap/cux/home/Layout" {
  import {
    default as BaseLayout,
    $BaseLayoutSettings,
  } from "sap/cux/home/BaseLayout";

  /**
   * Layout class for the My Home layout.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class Layout extends BaseLayout {
    /**
     * Constructor for a new layout.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseLayout.$BaseLayoutSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the Layout constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $LayoutSettings extends $BaseLayoutSettings {}
}

declare module "sap/cux/home/library" {
  /**
   * Supported News Types for {@link sap.cux.home.NewsPanel }.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export enum NewsType {}
}

declare module "sap/cux/home/MenuItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Class for managing and storing menu items.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class MenuItem extends UI5Element {
    /**
     * Constructor for a new menu item.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.MenuItem.$MenuItemSettings */ any
    );

    /**
     * Gets current value of property icon.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property title.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property type.
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Gets current value of property visible.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property icon.
     *
     *
     * @returns Value of property `icon`
     */
    setIcon(): URI;
    /**
     * Gets current value of property title.
     *
     *
     * @returns Value of property `title`
     */
    setTitle(): string;
    /**
     * Gets current value of property type.
     *
     *
     * @returns Value of property `type`
     */
    setType(): string;
    /**
     * Gets current value of property visible.
     *
     *
     * @returns Value of property `visible`
     */
    setVisible(): boolean;
  }
  /**
   * Describes the settings that can be provided to the MenuItem constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $MenuItemSettings extends $ElementSettings {
    /**
     * Icon of the menu item.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Title of the menu item.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Type of the menu item visualization in the menu list
     */
    type?: string | PropertyBindingInfo;

    /**
     * Visibility of the menu item in the menu list
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the MenuItem#press event.
   */
  export interface MenuItem$PressEventParameters {}

  /**
   * Event object of the MenuItem#press event.
   */
  export type MenuItem$PressEvent = Event<
    MenuItem$PressEventParameters,
    MenuItem
  >;
}

declare module "sap/cux/home/NewsAndPagesContainer" {
  import {
    default as BaseContainer,
    $BaseContainerSettings,
  } from "sap/cux/home/BaseContainer";

  /**
   * Container class for managing and storing News and Pages.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class NewsAndPagesContainer extends BaseContainer {
    /**
     * Constructor for the new News and Pages container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.NewsAndPagesContainer.$NewsAndPagesContainerSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the NewsAndPagesContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $NewsAndPagesContainerSettings
    extends $BaseContainerSettings {}
}

declare module "sap/cux/home/NewsPanel" {
  /**
   * Panel class for managing and storing News.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class NewsPanel
    extends /* was: sap.cux.home.BaseNewsPanel */ Object
  {
    /**
     * Constructor for a new News Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseNewsPanel.$BaseNewsPanelSettings */ any
    );

    /**
     * Gets current value of property url.
     *
     *
     * @returns Value of property `url`
     */
    getUrl(): string;
    /**
     * Gets current value of property url.
     *
     *
     * @returns Value of property `url`
     */
    setUrl(): string;
  }
}

declare module "sap/cux/home/NoDataContainer" {
  import {
    default as BaseContainer,
    $BaseContainerSettings,
  } from "sap/cux/home/BaseContainer";

  /**
   * Container class to show no data content.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class NoDataContainer extends BaseContainer {
    /**
     * Constructor for a new NoData Container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BaseContainer.$BaseContainerSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the NoDataContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $NoDataContainerSettings extends $BaseContainerSettings {}
}

declare module "sap/cux/home/PagePanel" {
  /**
   * Panel class for managing and storing Pages.
   *
   * @since 1.122
   * @experimental As of version 1.122.
   */
  export default class PagePanel
    extends /* was: sap.cux.home.BasePagePanel */ Object
  {
    /**
     * Constructor for a new Page panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePagePanel.$BasePagePanelSettings */ any
    );
  }
}

declare module "sap/cux/home/RecentAppPanel" {
  /**
   * Provides class for managing Recently Used apps.
   *
   * @since 1.121.0
   * @experimental As of version 1.121.0.
   */
  export default class RecentAppPanel
    extends /* was: sap.cux.home.BaseAppPersPanel */ Object
  {
    /**
     * Constructor for a new Recently Used apps Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePanel.$BasePanelSettings */ any
    );
  }
}

declare module "sap/cux/home/RecommendedAppPanel" {
  /**
   * Provides the RecommendedAppPanel Class.
   *
   * @since 1.128.0
   * @experimental As of version 1.128.0.
   */
  export default class RecommendedAppPanel
    extends /* was: sap.cux.home.BaseAppPersPanel */ Object
  {
    /**
     * Constructor for a new Recommended Apps Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.BasePanel.$BasePanelSettings */ any
    );
  }
}

declare module "sap/cux/home/SituationPanel" {
  import {
    default as ToDoPanel,
    $ToDoPanelSettings,
  } from "sap/cux/home/ToDoPanel";

  /**
   * Panel class for managing and storing Situation cards.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class SituationPanel extends ToDoPanel {
    /**
     * Constructor for a new Situation Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.ToDoPanel.$ToDoPanelSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the SituationPanel constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $SituationPanelSettings extends $ToDoPanelSettings {}
}

declare module "sap/cux/home/TaskPanel" {
  import {
    default as ToDoPanel,
    $ToDoPanelSettings,
  } from "sap/cux/home/ToDoPanel";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Panel class for managing and storing Task cards.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class TaskPanel extends ToDoPanel {
    /**
     * Constructor for a new Task Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.TaskPanel.$TaskPanelSettings */ any
    );

    /**
     * Gets current value of property customAttributeUrl.
     *
     *
     * @returns Value of property `customAttributeUrl`
     */
    getCustomAttributeUrl(): string;
    /**
     * Gets current value of property enableActions.
     *
     *
     * @returns Value of property `enableActions`
     */
    getEnableActions(): boolean;
    /**
     * Gets current value of property customAttributeUrl.
     *
     *
     * @returns Value of property `customAttributeUrl`
     */
    setCustomAttributeUrl(): string;
    /**
     * Gets current value of property enableActions.
     *
     *
     * @returns Value of property `enableActions`
     */
    setEnableActions(): boolean;
  }
  /**
   * Describes the settings that can be provided to the TaskPanel constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $TaskPanelSettings extends $ToDoPanelSettings {
    /**
     * Specifies the URL that fetches the custom attributes to be displayed along with the task cards.
     */
    customAttributeUrl?: string | PropertyBindingInfo;

    /**
     * Specifies if actions should be enabled for the task cards.
     */
    enableActions?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/cux/home/TilesPanel" {
  import {
    default as BasePanel,
    $BasePanelSettings,
  } from "sap/cux/home/BasePanel";

  /**
   * Tiles Panel class for managing and storing Insights Tiles.
   *
   * @since 1.122.0
   * @experimental As of version 1.122.0.
   */
  export default class TilesPanel extends BasePanel {
    /**
     * Constructor for a new Tiles Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.TilesPanel.$TilesPanelSettings */ any
    );
  }
  /**
   * Describes the settings that can be provided to the TilesPanel constructor.
   *
   * @experimental As of version 1.122.0.
   */
  export interface $TilesPanelSettings extends $BasePanelSettings {}
}

declare module "sap/cux/home/ToDoPanel" {
  import {
    default as BasePanel,
    $BasePanelSettings,
  } from "sap/cux/home/BasePanel";

  import { IToDoPanel } from "sap/cux/home/IToDoPanel";

  import Context from "sap/ui/model/Context";

  import Control from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Abstract Panel class for managing and storing To-Do cards.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default abstract class ToDoPanel
    extends BasePanel
    implements IToDoPanel
  {
    __implements__sap_cux_home_IToDoPanel: boolean;
    /**
     * Constructor for a new To-Dos Panel.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: /* was: sap.cux.home.ToDoPanel.$ToDoPanelSettings */ any
    );

    /**
     * Generates the card template for the Current Panel.
     *
     *
     * @returns The generated card template.
     */
    generateCardTemplate(
      /**
       * The ID for the template.
       */
      id: string,
      /**
       * The context for the template.
       */
      context: Context
    ): Control;
    /**
     * Generates request URLs for fetching data based on the specified card count.
     *
     *
     * @returns An array of request URLs.
     */
    generateRequestUrls(
      /**
       * - The number of cards to retrieve.
       */
      cardCount: number
    ): string[];
    /**
     * Gets current value of property baseUrl.
     *
     *
     * @returns Value of property `baseUrl`
     */
    getBaseUrl(): string;
    /**
     * Gets current value of property countUrl.
     *
     *
     * @returns Value of property `countUrl`
     */
    getCountUrl(): string;
    /**
     * Gets current value of property dataUrl.
     *
     *
     * @returns Value of property `dataUrl`
     */
    getDataUrl(): string;
    /**
     * Get the text for the "No Data" message.
     *
     *
     * @returns The text for the "No Data" message.
     */
    getNoDataText(): string;
    /**
     * Gets current value of property targetAppUrl.
     *
     *
     * @returns Value of property `targetAppUrl`
     */
    getTargetAppUrl(): string;
    /**
     * A promise that resolves when the data has been processed.
     * This method can be overridden to perform additional data processing operations.
     */
    onDataReceived(
      /**
       * - Data retrieved from the batch call.
       */
      results?: any[],
      /**
       * - Additional options for parsing the data.
       * Structure may vary based on the backend service.
       */
      options?: /* was: sap.cux.home.ToDoPanel.RequestOptions */ any
    ): Promise<void>;
    /**
     * Gets current value of property baseUrl.
     *
     *
     * @returns Value of property `baseUrl`
     */
    setBaseUrl(): string;
    /**
     * Gets current value of property countUrl.
     *
     *
     * @returns Value of property `countUrl`
     */
    setCountUrl(): string;
    /**
     * Gets current value of property dataUrl.
     *
     *
     * @returns Value of property `dataUrl`
     */
    setDataUrl(): string;
    /**
     * Gets current value of property targetAppUrl.
     *
     *
     * @returns Value of property `targetAppUrl`
     */
    setTargetAppUrl(): string;
  }
  /**
   * Describes the settings that can be provided to the ToDoPanel constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $ToDoPanelSettings extends $BasePanelSettings {
    /**
     * Specifies the base URL for batching requests sent from the panel.
     */
    baseUrl?: string | PropertyBindingInfo;

    /**
     * Specifies the URL for fetching the count of requested to-do cards.
     */
    countUrl?: string | PropertyBindingInfo;

    /**
     * Specifies the URL from where the to-do cards should be fetched.
     */
    dataUrl?: string | PropertyBindingInfo;

    /**
     * Specifies the URL of the target application associated with the to-do cards.
     */
    targetAppUrl?: string | PropertyBindingInfo;
  }
}

declare module "sap/cux/home/ToDosContainer" {
  import {
    default as BaseContainer,
    $BaseContainerSettings,
  } from "sap/cux/home/BaseContainer";

  /**
   * Container class for managing and storing To-Do cards.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class ToDosContainer extends BaseContainer {
    /**
     * Constructor for a new To-Dos container.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      settings?: $ToDosContainerSettings
    );
    /**
     * Constructor for a new To-Dos container.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if an ID is not provided
       */
      id?: string,
      /**
       * Initial settings for the new control
       */
      settings?: $ToDosContainerSettings
    );

    /**
     * Gets the selected key of the To-Dos container.
     * If no selected key is set, it defaults to the first item.
     *
     *
     * @returns The selected key.
     */
    getSelectedKey(): string;
    /**
     * Asynchronously refreshes the section by forcing all inner panels to be reloaded.
     *
     *
     * @returns A promise that resolves when the section is successfully refreshed.
     */
    refreshData(): Promise<void>;
  }
  /**
   * Describes the settings that can be provided to the ToDosContainer constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $ToDosContainerSettings extends $BaseContainerSettings {}
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/cux/home/AppsContainer": undefined;

    "sap/cux/home/BaseContainer": undefined;

    "sap/cux/home/BaseLayout": undefined;

    "sap/cux/home/BasePanel": undefined;

    "sap/cux/home/BaseSettingsDialog": undefined;

    "sap/cux/home/BaseSettingsPanel": undefined;

    "sap/cux/home/CardsPanel": undefined;

    "sap/cux/home/FavAppPanel": undefined;

    "sap/cux/home/FrequentAppPanel": undefined;

    "sap/cux/home/InsightsContainer": undefined;

    "sap/cux/home/IToDoPanel": undefined;

    "sap/cux/home/Layout": undefined;

    "sap/cux/home/library": undefined;

    "sap/cux/home/MenuItem": undefined;

    "sap/cux/home/NewsAndPagesContainer": undefined;

    "sap/cux/home/NewsPanel": undefined;

    "sap/cux/home/NoDataContainer": undefined;

    "sap/cux/home/PagePanel": undefined;

    "sap/cux/home/RecentAppPanel": undefined;

    "sap/cux/home/RecommendedAppPanel": undefined;

    "sap/cux/home/SituationPanel": undefined;

    "sap/cux/home/TaskPanel": undefined;

    "sap/cux/home/TilesPanel": undefined;

    "sap/cux/home/ToDoPanel": undefined;

    "sap/cux/home/ToDosContainer": undefined;
  }
}
