import ts from "typescript";
import { ChangeSet } from "../../../utils/textChanges.js";
import { Attribute, Position } from "sax-wasm";
import PropertyAssignmentBaseFix from "./PropertyAssignmentBaseFix.js";
import { PositionInfo } from "../../LinterContext.js";
import { FixHelpers } from "./Fix.js";
export interface PropertyAssignmentFixParams {
    /**
     * Property name to replace the property access with.
     * If not defined, the complete property assignment will be removed.
     */
    property?: string;
}
/**
 * Fix a global property access. Requires a module name which will be imported and replaces the defined property access.
 * The property access is in the order of the AST, e.g. ["core", "ui", "sap"]
 */
export default class PropertyAssignmentFix extends PropertyAssignmentBaseFix {
    private params;
    constructor(params: PropertyAssignmentFixParams);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo, _helpers: FixHelpers): boolean;
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
    visitAutofixXmlNode(node: Attribute, toPosition: (pos: Position) => number): boolean;
    generateChanges(): ChangeSet;
}
