import ts from "typescript";
import LinterContext, { CoverageInfo, PositionRange } from "../LinterContext.js";
import { MESSAGE } from "../messages.js";
import { MessageArgs } from "../MessageArgs.js";
import { Ui5TypeInfo } from "./Ui5TypeInfo.js";
import Fix from "./fix/Fix.js";
interface ReporterCoverageInfo extends CoverageInfo {
    node: ts.Node;
}
interface SourceFileMessageOptions {
    /**
     * Optional node which will be used to determine the position of the linting message.
     * If no node is provided, the first column of the first line of the source file will be used.
     */
    node?: ts.Node;
    ui5TypeInfo?: Ui5TypeInfo;
    fix?: Fix;
}
export default class SourceFileReporter {
    #private;
    constructor(context: LinterContext, sourceFile: ts.SourceFile, sourceMap: string | undefined);
    addMessage<M extends MESSAGE>(id: M, args: MessageArgs[M] | null, options: SourceFileMessageOptions): void;
    addCoverageInfo({ node, message, messageDetails, category }: ReporterCoverageInfo): void;
    getPositionsForNode(node: ts.Node): PositionRange;
    addMessagesToContext(): void;
}
export {};
