"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AppSearch;
var React = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _helpers = require("docs/src/modules/utils/helpers");
var ReactDOMServer = _interopRequireWildcard(require("react-dom/server"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _link = _interopRequireDefault(require("next/link"));
var _router = require("next/router");
var _react2 = require("@docsearch/react");
var _Chip = _interopRequireDefault(require("@mui/material/Chip"));
var _ArticleRounded = _interopRequireDefault(require("@mui/icons-material/ArticleRounded"));
var _ToggleOffRounded = _interopRequireDefault(require("@mui/icons-material/ToggleOffRounded"));
var _EditRounded = _interopRequireDefault(require("@mui/icons-material/EditRounded"));
var _HandymanRounded = _interopRequireDefault(require("@mui/icons-material/HandymanRounded"));
var _KeyboardArrowRightRounded = _interopRequireDefault(require("@mui/icons-material/KeyboardArrowRightRounded"));
var _Search = _interopRequireDefault(require("@mui/icons-material/Search"));
var _GlobalStyles = _interopRequireDefault(require("@mui/material/GlobalStyles"));
var _styles = require("@mui/material/styles");
var _config = require("docs/config");
var _Link = _interopRequireDefault(require("docs/src/modules/components/Link"));
var _i18n = require("@mui/docs/i18n");
var _useLazyCSS = _interopRequireDefault(require("docs/src/modules/utils/useLazyCSS"));
var _getUrlProduct = _interopRequireDefault(require("docs/src/modules/utils/getUrlProduct"));
var _jsxRuntime = require("react/jsx-runtime");
var _ArticleRoundedIcon, _ToggleOffRoundedIcon, _EditRoundedIcon, _HandymanRoundedIcon, _KeyboardArrowRightRo, _NewStartScreen;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchButton = (0, _styles.styled)('button')(({
  theme
}) => {
  return {
    minHeight: 34,
    display: 'flex',
    alignItems: 'center',
    paddingLeft: `${theme.spacing(1)}px`,
    [theme.breakpoints.only('xs')]: {
      backgroundColor: 'transparent',
      padding: 0,
      minWidth: 34,
      justifyContent: 'center',
      '& > *:not(.MuiSvgIcon-root)': {
        display: 'none'
      }
    },
    [theme.breakpoints.up('sm')]: {
      minWidth: 200
    },
    fontFamily: theme.typography.fontFamily,
    position: 'relative',
    backgroundColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[900] : theme.palette.grey[50],
    color: theme.palette.text.secondary,
    fontSize: theme.typography.pxToRem(14),
    border: `1px solid ${theme.palette.mode === 'dark' ? theme.palette.primaryDark[700] : theme.palette.grey[200]}`,
    borderRadius: 10,
    cursor: 'pointer',
    transitionProperty: 'all',
    transitionDuration: '150ms',
    '&:hover': {
      background: theme.palette.mode === 'dark' ? (0, _styles.alpha)(theme.palette.primaryDark[700], 0.4) : (0, _styles.alpha)(theme.palette.grey[100], 0.7),
      borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[600] : theme.palette.grey[300]
    }
  };
});
const SearchLabel = (0, _styles.styled)('span')(({
  theme
}) => {
  return {
    marginLeft: `${theme.spacing(1)}px`,
    marginRight: 'auto'
  };
});
const Shortcut = (0, _styles.styled)('div')(({
  theme
}) => {
  return {
    fontSize: theme.typography.pxToRem(12),
    fontWeight: 700,
    lineHeight: '20px',
    marginLeft: `${theme.spacing(0.5)}px`,
    border: `1px solid ${theme.palette.mode === 'dark' ? theme.palette.primaryDark[500] : theme.palette.grey[200]}`,
    backgroundColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[800] : '#FFF',
    padding: `${theme.spacing(0, 0.8)}px`,
    borderRadius: 5
  };
});
const NewStartScreen = () => {
  const startScreenOptions = [{
    category: {
      name: 'Getting started',
      icon: _ArticleRoundedIcon || (_ArticleRoundedIcon = /*#__PURE__*/(0, _jsxRuntime.jsx)(_ArticleRounded.default, {
        className: "DocSearch-NewStartScreenTitleIcon"
      }))
    },
    items: [{
      name: 'Installation',
      href: '/material-ui/getting-started/installation/'
    }, {
      name: 'Usage',
      href: '/material-ui/getting-started/usage/'
    }, {
      name: 'Learn',
      href: '/material-ui/getting-started/learn/'
    }]
  }, {
    category: {
      name: 'Popular searches',
      icon: _ToggleOffRoundedIcon || (_ToggleOffRoundedIcon = /*#__PURE__*/(0, _jsxRuntime.jsx)(_ToggleOffRounded.default, {
        className: "DocSearch-NewStartScreenTitleIcon"
      }))
    },
    items: [{
      name: 'Material Icons',
      href: '/material-ui/material-icons/'
    }, {
      name: 'Text field',
      href: '/material-ui/react-text-field/'
    }, {
      name: 'Button',
      href: '/material-ui/react-button/'
    }]
  }, {
    category: {
      name: 'Customization',
      icon: _EditRoundedIcon || (_EditRoundedIcon = /*#__PURE__*/(0, _jsxRuntime.jsx)(_EditRounded.default, {
        className: "DocSearch-NewStartScreenTitleIcon"
      }))
    },
    items: [{
      name: 'How to customize',
      href: '/material-ui/customization/how-to-customize/'
    }, {
      name: 'Theming',
      href: '/material-ui/customization/theming/'
    }, {
      name: 'Default Theme',
      href: '/material-ui/customization/default-theme/'
    }]
  }, {
    category: {
      name: 'System',
      icon: _HandymanRoundedIcon || (_HandymanRoundedIcon = /*#__PURE__*/(0, _jsxRuntime.jsx)(_HandymanRounded.default, {
        className: "DocSearch-NewStartScreenTitleIcon"
      }))
    },
    items: [{
      name: 'Basics',
      href: '/system/basics/'
    }, {
      name: 'Properties',
      href: '/system/properties/'
    }, {
      name: 'The sx prop',
      href: '/system/the-sx-prop/'
    }]
  }];
  return /*#__PURE__*/(0, _jsxRuntime.jsx)("div", {
    className: "DocSearch-NewStartScreen",
    children: startScreenOptions.map(({
      category,
      items
    }) => /*#__PURE__*/(0, _jsxRuntime.jsxs)("div", {
      className: "DocSearch-NewStartScreenCategory",
      children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)("div", {
        className: "DocSearch-NewStartScreenTitle",
        children: [category.icon, category.name]
      }), items.map(({
        name,
        href
      }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(_link.default, {
        href: href,
        children: /*#__PURE__*/(0, _jsxRuntime.jsxs)("a", {
          href: href,
          className: "DocSearch-NewStartScreenItem",
          children: [name, _KeyboardArrowRightRo || (_KeyboardArrowRightRo = /*#__PURE__*/(0, _jsxRuntime.jsx)(_KeyboardArrowRightRounded.default, {
            className: "DocSearch-NewStartScreenItemIcon"
          }))]
        })
      }, name))]
    }, category.name))
  });
};
function DocSearchHit(props) {
  const {
    children,
    hit
  } = props;
  function displayTag(pathname) {
    // does not need to show product label for MUI X because they are grouped by the product name in the search
    // i.e. Data Grid, Date Picker
    if (!pathname.match(/^\/(material-ui|joy-ui|base)\//)) {
      return null;
    }
    let text = '';
    if (pathname.startsWith('/material-ui/')) {
      text = 'Material UI';
    }
    if (pathname.startsWith('/joy-ui/')) {
      text = 'Joy UI';
    }
    if (pathname.startsWith('/base/')) {
      text = 'Base UI';
    }
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(_Chip.default, {
      label: text,
      size: "small",
      variant: "outlined",
      sx: {
        mr: 1
      }
    });
  }
  if (hit.pathname) {
    return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_Link.default, {
      href: hit.pathname,
      as: hit.as,
      sx: {
        display: 'flex !important',
        '& .DocSearch-Hit-Container': {
          flex: 1,
          minWidth: 0
        }
      },
      children: [children, displayTag(hit.pathname)]
    });
  }

  // DocSearch stores the old results in its cache
  // hit.pathname won't be defined for them.
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_Link.default, {
    href: hit.url,
    children: children
  });
}
process.env.NODE_ENV !== "production" ? DocSearchHit.propTypes = {
  children: _propTypes.default.node,
  hit: _propTypes.default.object.isRequired
} : void 0;
function AppSearch() {
  (0, _useLazyCSS.default)('https://cdn.jsdelivr.net/npm/@docsearch/css@3.0.0-alpha.40/dist/style.min.css', '#app-search');
  const FADE_DURATION = 100; // ms
  const t = (0, _i18n.useTranslate)();
  const userLanguage = (0, _i18n.useUserLanguage)();
  const searchButtonRef = React.useRef(null);
  const [isOpen, setIsOpen] = React.useState(false);
  const [initialQuery, setInitialQuery] = React.useState(undefined);
  const facetFilterLanguage = _config.LANGUAGES_SSR.indexOf(userLanguage) !== -1 ? `language:${userLanguage}` : `language:en`;
  const macOS = window.navigator.platform.toUpperCase().indexOf('MAC') >= 0;
  const onOpen = React.useCallback(() => {
    setIsOpen(true);
  }, [setIsOpen]);
  const router = (0, _router.useRouter)();
  const productSpace = (0, _getUrlProduct.default)(router.asPath);
  const keyboardNavigator = {
    navigate({
      item
    }) {
      const as = item.userLanguage !== 'en' ? `/${item.userLanguage}${item.as}` : item.as;
      router.push(item.pathname, as);
    }
  };
  const onClose = React.useCallback(() => {
    const modal = document.querySelector('.DocSearch-Container');
    if (modal) {
      // fade out transition
      modal.style.opacity = 0;
    }
    setIsOpen(false); // DO NOT call setIsOpen inside a timeout (it causes scroll issue).
  }, [setIsOpen]);
  const onInput = React.useCallback(event => {
    setIsOpen(true);
    setInitialQuery(event.key);
  }, [setIsOpen, setInitialQuery]);
  (0, _react2.useDocSearchKeyboardEvents)({
    isOpen,
    onOpen,
    onClose,
    onInput,
    searchButtonRef
  });
  React.useEffect(() => {
    const addStartScreen = () => {
      const dropDown = document.querySelector('.DocSearch-Dropdown');
      const isExisting = document.querySelector('.DocSearch-NewStartScreen');
      if (dropDown && !isExisting) {
        dropDown.insertAdjacentHTML('beforeend', ReactDOMServer.renderToStaticMarkup(_NewStartScreen || (_NewStartScreen = /*#__PURE__*/(0, _jsxRuntime.jsx)(NewStartScreen, {}))));
      }
    };
    // add transition to Modal
    if (isOpen) {
      const modal = document.querySelector('.DocSearch-Container');
      const searchInput = document.querySelector('.DocSearch-Input');
      if (modal) {
        modal.style.opacity = 1;
        addStartScreen();
      }
      if (searchInput) {
        const handleInput = event => {
          const newStartScreen = document.querySelector('.DocSearch-NewStartScreen');
          if (newStartScreen) {
            newStartScreen.style.display = event.target.value !== '' ? 'none' : 'grid';
          }
        };
        searchInput.addEventListener('input', handleInput);
        return () => {
          searchInput.removeEventListener('input', handleInput);
        };
      }
    }
    return () => {};
  }, [isOpen]);
  const search = `${t('algoliaSearch')}…`;
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(React.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(SearchButton, {
      ref: searchButtonRef,
      onClick: onOpen,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_Search.default, {
        fontSize: "small",
        sx: {
          color: theme => theme.palette.mode === 'dark' ? theme.palette.primary[300] : theme.palette.primary[500]
        }
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(SearchLabel, {
        children: search
      }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(Shortcut, {
        children: [macOS ? '⌘' : 'Ctrl+', "K"]
      })]
    }), isOpen && /*#__PURE__*/(0, _reactDom.createPortal)( /*#__PURE__*/(0, _jsxRuntime.jsx)(_react2.DocSearchModal, {
      initialQuery: initialQuery,
      appId: 'TZGZ85B9TB',
      apiKey: '8177dfb3e2be72b241ffb8c5abafa899',
      indexName: "material-ui",
      searchParameters: {
        facetFilters: ['version:master', facetFilterLanguage],
        optionalFilters: [`product:${productSpace}`],
        hitsPerPage: 40
      },
      placeholder: search,
      transformItems: items => {
        return items.map(item => {
          // `url` contains the domain
          // but we want to link to the current domain e.g. deploy-preview-1--material-ui.netlify.app
          const parseUrl = document.createElement('a');
          parseUrl.href = item.url;
          const {
            canonicalAs,
            canonicalPathname
          } = (0, _helpers.pathnameToLanguage)(`${parseUrl.pathname}${parseUrl.hash}`);
          return {
            ...item,
            pathname: canonicalPathname,
            as: canonicalAs,
            userLanguage
          };
        });
      },
      hitComponent: DocSearchHit,
      initialScrollY: typeof window !== 'undefined' ? window.scrollY : undefined,
      onClose: onClose,
      navigator: keyboardNavigator
    }), document.body), /*#__PURE__*/(0, _jsxRuntime.jsx)(_GlobalStyles.default, {
      styles: theme => ({
        html: {
          ':root': {
            '--docsearch-primary-color': theme.palette.mode === 'dark' ? theme.palette.primaryDark[300] : theme.palette.primary[500],
            '--docsearch-text-color': theme.palette.text.primary,
            '--docsearch-muted-color': theme.palette.grey[600],
            '--docsearch-searchbox-shadow': 0,
            '--docsearch-hit-shadow': 0,
            '--docsearch-footer-shadow': 0,
            '--docsearch-spacing': `${theme.spacing(1.5)}px`,
            '--docsearch-hit-active-color': theme.palette.mode === 'dark' ? theme.palette.primary[300] : theme.palette.primary[600],
            '--docsearch-logo-color': theme.palette.grey[600],
            '--docsearch-searchbox-focus-background': 'unset',
            '--docsearch-footer-background': 'unset',
            '--docsearch-modal-background': theme.palette.background.paper
          }
        },
        body: {
          '.DocSearch-Container': {
            transition: `opacity ${FADE_DURATION}ms`,
            opacity: 0,
            zIndex: theme.zIndex.tooltip + 100,
            backgroundColor: theme.palette.mode === 'dark' ? (0, _styles.alpha)(theme.palette.grey[900], 0.7) : (0, _styles.alpha)(theme.palette.grey[600], 0.2),
            backdropFilter: 'blur(4px)'
          },
          '& .DocSearch-StartScreen': {
            display: 'none'
          },
          '& .DocSearch-NewStartScreen': {
            display: 'grid',
            gridTemplateColumns: 'repeat(2, 1fr)',
            gap: `${theme.spacing(2)}px`,
            padding: `${theme.spacing(2, 1)}px`
          },
          '& .DocSearch-NewStartScreenCategory': {
            display: 'flex',
            flexDirection: 'column'
          },
          '& .DocSearch-NewStartScreenTitle': {
            display: 'flex',
            alignItems: 'center',
            padding: `${theme.spacing(1, 1)}px`,
            fontSize: theme.typography.pxToRem(14),
            color: theme.palette.text.secondary
          },
          '& .DocSearch-NewStartScreenTitleIcon': {
            color: theme.palette.mode === 'dark' ? theme.palette.primaryDark[300] : theme.palette.primary[500],
            marginRight: `${theme.spacing(1.5)}px`,
            fontSize: theme.typography.pxToRem(16)
          },
          '& .DocSearch-NewStartScreenItem': {
            display: 'flex',
            alignItems: 'center',
            cursor: 'pointer',
            width: '100%',
            padding: `${theme.spacing(0.5, 4.6)}px`,
            color: theme.palette.mode === 'dark' ? theme.palette.primaryDark[300] : theme.palette.primary[500],
            fontWeight: 500,
            fontSize: theme.typography.pxToRem(14),
            '&:hover, &:focus': {
              '.DocSearch-NewStartScreenItemIcon': {
                marginLeft: `${theme.spacing(1)}px`
              }
            }
          },
          '& .DocSearch-NewStartScreenItemIcon': {
            marginLeft: `${theme.spacing(0.5)}px`,
            transition: 'margin 0.2s',
            fontSize: theme.typography.pxToRem(16)
          },
          '& .DocSearch-Modal': {
            maxWidth: '700px',
            boxShadow: `0px 4px 20px ${theme.palette.mode === 'dark' ? (0, _styles.alpha)(theme.palette.background.paper, 0.7) : (0, _styles.alpha)(theme.palette.grey[700], 0.2)}`,
            ...(theme.palette.mode === 'dark' && {
              border: '1px solid',
              borderColor: theme.palette.primaryDark[700]
            }),
            // docsearch.css: <= 750px will be full screen modal
            borderRadius: `clamp(0px, (100vw - 750px) * 9999, ${theme.shape.borderRadius}px)`
          },
          '& .DocSearch-SearchBar': {
            borderBottom: '1px solid',
            borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[700] : theme.palette.grey[200],
            padding: `${theme.spacing(1)}px`
          },
          '& .DocSearch-Form': {
            '& .DocSearch-Reset': {
              display: 'none'
            },
            '& .DocSearch-Input': {
              paddingLeft: `${theme.spacing(2.5)}px`
            },
            '& .DocSearch-Search-Icon': {
              width: '20px',
              height: '20px'
            }
          },
          '& .DocSearch-Cancel': {
            display: 'block',
            alignSelf: 'center',
            height: '1.5rem',
            marginRight: `${theme.spacing(1)}px`,
            padding: `${theme.spacing(0.3, 0.8, 0.6, 0.8)}px`,
            fontSize: 0,
            borderRadius: 5,
            backgroundColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[800] : theme.palette.grey[50],
            border: '1px solid',
            borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[600] : theme.palette.grey[300],
            '&::before': {
              content: '"esc"',
              fontSize: theme.typography.pxToRem(12),
              letterSpacing: '.08rem',
              fontWeight: 700,
              color: theme.palette.text.secondary
            }
          },
          '& .DocSearch-Dropdown': {
            minHeight: 384,
            // = StartScreen height, to prevent layout shift when first char
            '&::-webkit-scrollbar-thumb': {
              borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[900] : theme.palette.background.paper,
              backgroundColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[700] : theme.palette.grey[500]
            },
            '&::-webkit-scrollbar-track': {
              backgroundColor: theme.palette.background.paper
            }
          },
          '& .DocSearch-Dropdown-Container': {
            '& .DocSearch-Hits:first-of-type': {
              '& .DocSearch-Hit-source': {
                paddingTop: `${theme.spacing(1)}px`
              }
            }
          },
          '& .DocSearch-Hit-source': {
            top: 'initial',
            paddingTop: `${theme.spacing(2)}px`,
            background: theme.palette.background.paper,
            fontSize: theme.typography.pxToRem(13),
            fontWeight: 500,
            color: theme.palette.text.secondary
          },
          '& .DocSearch-Hit': {
            paddingBottom: 0,
            '&:not(:first-of-type)': {
              marginTop: -1
            }
          },
          '& .DocSearch-Hit a': {
            backgroundColor: 'transparent',
            padding: `${theme.spacing(0.25, 0)}px`,
            paddingLeft: `${theme.spacing(2)}px`,
            border: '1px solid transparent',
            borderBottomColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[700] : theme.palette.grey[100]
          },
          '& .DocSearch-Hit-content-wrapper': {
            paddingLeft: `${theme.spacing(2)}px`
          },
          '& .DocSearch-Hit-title': {
            fontSize: theme.typography.pxToRem(14),
            color: `${theme.palette.text.primary}`
          },
          '& .DocSearch-Hit-path': {
            fontSize: theme.typography.pxToRem(12),
            color: `${theme.palette.text.secondary}`
          },
          '& .DocSearch-Hit-Select-Icon': {
            height: '15px',
            width: '15px'
          },
          '& .DocSearch-Hit[aria-selected="true"] a': {
            backgroundColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[800] : theme.palette.primary[50],
            borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[400] : theme.palette.primary[500],
            borderRadius: theme.shape.borderRadius
          },
          '& .DocSearch-Hit-action, & .DocSearch-Hits mark': {
            color: `${theme.palette.mode === 'dark' ? theme.palette.primary[400] : theme.palette.primary[500]}`
          },
          '& .DocSearch-Footer': {
            borderTop: '1px solid',
            borderColor: theme.palette.mode === 'dark' ? theme.palette.primaryDark[700] : theme.palette.grey[200],
            '& .DocSearch-Commands': {
              display: 'none'
            }
          }
        }
      })
    })]
  });
}