/// <reference types="node" />
import { CheerioOptions } from './options';
import { CheerioAPI } from './cheerio';
import type { Node } from 'domhandler';
/**
 * Create a querying function, bound to a document created from the provided
 * markup. Note that similar to web browser contexts, this operation may
 * introduce `<html>`, `<head>`, and `<body>` elements; set `isDocument` to
 * `false` to switch to fragment mode and disable this.
 *
 * See the README section titled "Loading" for additional usage information.
 *
 * @param content - Markup to be loaded.
 * @param options - Options for the created instance.
 * @param isDocument - Allows parser to be switched to fragment mode.
 * @returns The loaded document.
 */
export declare function load(content: string | Node | Node[] | Buffer, options?: CheerioOptions | null, isDocument?: boolean): CheerioAPI;
//# sourceMappingURL=load.d.ts.map