import ts from "typescript";
import { ChangeAction } from "../../../utils/textChanges.js";
import CallExpressionBaseFix from "./CallExpressionBaseFix.js";
export default class CallExpressionGeneratorFix extends CallExpressionBaseFix {
    params;
    generatorArgs;
    generatorContext = {};
    constructor(params, ui5TypeInfo) {
        super(params, ui5TypeInfo);
        this.params = params;
    }
    visitLinterNode(node, sourcePosition, helpers) {
        if (!super.visitLinterNode(node, sourcePosition, helpers)) {
            return false;
        }
        if (!ts.isCallExpression(node)) {
            return false;
        }
        if (this.params.validateArguments) {
            if (!this.params.validateArguments(this.generatorContext, helpers, ...node.arguments)) {
                return false;
            }
        }
        return true;
    }
    visitAutofixNode(node, position, sourceFile) {
        if (!super.visitAutofixNode(node, position, sourceFile)) {
            return false;
        }
        if (!ts.isCallExpression(node)) {
            return false;
        }
        // Collect arguments for the generator function
        this.generatorArgs = node.arguments.map((arg) => {
            return arg.getFullText();
        });
        return true;
    }
    getNewModuleDependencies() {
        if (this.params.moduleName && this.params.moduleImports) {
            throw new Error("Parameters 'moduleName' and 'moduleImports' are both defined. Only one may be used at a time.");
        }
        else if (this.params.moduleName) {
            return super.getNewModuleDependencies();
        }
        else if (!this.params.moduleImports) {
            return;
        }
        const usagePosition = this.startPos;
        if (usagePosition === undefined) {
            throw new Error("Start position is not defined");
        }
        return this.params.moduleImports.map((moduleImport) => {
            return {
                ...moduleImport,
                usagePosition,
            };
        });
    }
    getNewGlobalAccess() {
        if (this.params.globalName && this.params.globalNames) {
            throw new Error("Parameters 'globalName' and 'globalNames' are both defined. Only one may be used at a time.");
        }
        else if (this.params.globalName) {
            return super.getNewGlobalAccess();
        }
        else if (!this.params.globalNames) {
            return;
        }
        const usagePosition = this.startPos;
        if (usagePosition === undefined) {
            throw new Error("Start position is not defined");
        }
        return this.params.globalNames.map((globalName) => {
            return {
                globalName,
                usagePosition,
            };
        });
    }
    generateChanges() {
        if (this.startPos === undefined || this.endPos === undefined || !this.generatorArgs) {
            throw new Error("Start, end position or arguments are not defined");
        }
        let moduleNames;
        if (this.params.moduleName) {
            moduleNames = [this.params.moduleName];
        }
        else if (this.params.moduleImports) {
            moduleNames = this.params.moduleImports.map((moduleImport) => moduleImport.moduleName);
        }
        const globalNames = this.params.globalName ? [this.params.globalName] : this.params.globalNames;
        const identifiers = this.getIdentifiersForMultipleRequests(moduleNames, globalNames);
        if (!identifiers) {
            return;
        }
        const value = this.params.generator(this.generatorContext, identifiers, ...this.generatorArgs);
        if (value === undefined) {
            return;
        }
        return {
            action: ChangeAction.REPLACE,
            start: this.startPos,
            end: this.endPos,
            value,
        };
    }
}
//# sourceMappingURL=CallExpressionGeneratorFix.js.map