import ts from "typescript";
import LinterContext from "../../LinterContext.js";
declare module "typescript" {
    interface Node {
        _remove?: boolean;
    }
}
/**
 * Creates a TypeScript "transformer" that will be applied to each source file, doing the actual transpilation
 * The source file is expected to be classic UI5 JavaScript, using UI5s's AMD loader and other UI5 specific API.
 * Modern JavaScript language features are generally supported, however there might be gaps in the implementation
 * at the time of writing this comment.
 *
 * If a transformation of a specific API (such as "sap.ui.define") is not possible for some reason, an "Unsupported*"
 * error is thrown. In that case, the rest of the module is still processed. However it's possible that the result
 * will be equal to the input.
*/
export declare function createTransformer(program: ts.Program, resourcePath: string, context: LinterContext): ts.TransformerFactory<ts.SourceFile>;
