import ts from "typescript";
export interface ProbingRequireExpression {
    async: false;
    dependency: ts.StringLiteral | ts.NoSubstitutionTemplateLiteral;
}
export interface RequireExpression {
    async: true;
    dependencies: ts.ArrayLiteralExpression;
    callback?: ts.ArrowFunction | ts.FunctionExpression | ts.FunctionDeclaration;
    errback?: ts.ArrowFunction | ts.FunctionExpression | ts.FunctionDeclaration;
}
/**
 * For a given array of arguments, try to match them to the parameters of the sap.ui.define and sap.ui.predefine
 * signatures
 */
export default function parseRequire(args: ts.CallExpression["arguments"], checker: ts.TypeChecker): ProbingRequireExpression | RequireExpression;
export type RequireCallArgument = ts.StringLiteral | ts.NoSubstitutionTemplateLiteral | ts.ArrayLiteralExpression | ts.ArrowFunction | ts.FunctionExpression | ts.FunctionDeclaration;
