/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.codemods.NodeBasedRecipe;
import org.openrewrite.codemods.Putout;
import org.openrewrite.codemods.RecipeResources;
import org.openrewrite.codemods.UI5Messages;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.PlainText;

public final class UI5
extends NodeBasedRecipe {
    private static final String UI5_DIR = Putout.class.getName() + ".UI5_DIR";
    private final transient UI5Messages messages = new UI5Messages((Recipe)this);

    public String getDisplayName() {
        return "Lint UI5 projects with UI5 linter";
    }

    public String getDescription() {
        return "Runs the [UI5 Linter](https://github.com/SAP/ui5-linter), a static code analysis tool for UI5 projects. It checks JavaScript, TypeScript, XML, JSON, and other files in your project and reports findings.";
    }

    @Override
    public NodeBasedRecipe.Accumulator getInitialValue(ExecutionContext ctx) {
        Path path = RecipeResources.from(((Object)((Object)this)).getClass()).extractResources("config", UI5_DIR, ctx);
        ctx.putMessage(UI5_DIR, (Object)path);
        return super.getInitialValue(ctx);
    }

    @Override
    protected List<String> getNpmCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("sh");
        command.add("-c");
        command.add("node ${nodeModules}/@ui5/linter/bin/ui5lint.js --fix --format=json || true");
        return command;
    }

    @Override
    protected void processOutput(Path output, NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        try {
            HashMap<Path, JsonNode> results = new HashMap<Path, JsonNode>();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode resultsArray = objectMapper.readTree(output.toFile());
            for (JsonNode resultNode : resultsArray) {
                int errorCount = resultNode.get("errorCount").intValue();
                int warningCount = resultNode.get("warningCount").intValue();
                if (errorCount <= 0 && warningCount <= 0) continue;
                Path filePath = Paths.get(resultNode.get("filePath").asText(), new String[0]);
                results.put(filePath, resultNode);
            }
            acc.putData("results", results);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected SourceFile createAfter(SourceFile before, NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        SourcePosition endPosition;
        Map results = (Map)acc.getData("results");
        if (results == null) {
            return super.createAfter(before, acc, ctx);
        }
        JsonNode resultNode = (JsonNode)results.get(before.getSourcePath());
        if (resultNode == null) {
            return super.createAfter(before, acc, ctx);
        }
        String content = acc.content(before);
        ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
        SourcePosition currentPosition = new SourcePosition(content, 1, 1, 0);
        PlainText.Snippet currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
        ArrayNode messagesNode = (ArrayNode)resultNode.get("messages");
        JsonNode previousMessage = null;
        for (int i = 0; i < messagesNode.size(); ++i) {
            int column;
            JsonNode message = messagesNode.get(i);
            int line = message.get("line").asInt();
            SourcePosition nextPosition = currentPosition.scanForwardTo(line, column = message.get("column").asInt());
            if (nextPosition.offset > currentPosition.offset) {
                SourcePosition endPosition2;
                if (previousMessage != null && (endPosition2 = currentPosition.scanForwardTo(previousMessage.get("endLine").intValue(), previousMessage.get("endColumn").intValue())).offset < nextPosition.offset) {
                    snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, endPosition2.offset)));
                    currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
                    currentPosition = endPosition2;
                }
                snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, nextPosition.offset)));
                currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
            }
            int severity = message.get("severity").asInt();
            String messageText = message.get("message").asText();
            String ruleId = message.get("ruleId").asText();
            SearchResult marker = new SearchResult(Tree.randomId(), messageText);
            this.messages.insertRow(ctx, new UI5Messages.Row(before.getSourcePath().toString(), ruleId, UI5Messages.Severity.of(severity), line, column, messageText));
            currentSnippet = currentSnippet.withMarkers(currentSnippet.getMarkers().add((Marker)marker));
            currentPosition = nextPosition;
            previousMessage = message.has("endLine") ? message : null;
        }
        if (previousMessage != null && (endPosition = currentPosition.scanForwardTo(previousMessage.get("endLine").intValue(), previousMessage.get("endColumn").intValue())).offset < content.length()) {
            snippets.add(currentSnippet.withText(content.substring(currentPosition.offset, endPosition.offset)));
            currentSnippet = new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, "");
            currentPosition = endPosition;
        }
        snippets.add(currentSnippet.withText(content.substring(currentPosition.offset)));
        return new PlainText(before.getId(), before.getSourcePath(), before.getMarkers(), before.getCharset() != null ? before.getCharset().name() : null, before.isCharsetBomMarked(), before.getFileAttributes(), null, "", snippets);
    }

    @Generated
    public UI5() {
    }

    @Generated
    public UI5Messages getMessages() {
        return this.messages;
    }

    @Generated
    public String toString() {
        return "UI5(messages=" + (Object)((Object)this.getMessages()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UI5)) {
            return false;
        }
        UI5 other = (UI5)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UI5;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class SourcePosition {
        private final String text;
        private final int line;
        private final int column;
        private final int offset;

        private SourcePosition scanForwardTo(int line, int column) {
            if (line == this.line && column == this.column) {
                return this;
            }
            int currentLine = this.line;
            int currentColumn = this.column;
            int currentOffset = this.offset;
            while (currentLine < line || currentLine == line && currentColumn < column) {
                if (this.text.charAt(currentOffset) == '\n') {
                    ++currentLine;
                    currentColumn = 1;
                    ++currentOffset;
                    continue;
                }
                ++currentColumn;
                ++currentOffset;
            }
            return new SourcePosition(this.text, line, column, currentOffset);
        }

        @Generated
        public SourcePosition(String text, int line, int column, int offset) {
            this.text = text;
            this.line = line;
            this.column = column;
            this.offset = offset;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public int getLine() {
            return this.line;
        }

        @Generated
        public int getColumn() {
            return this.column;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourcePosition)) {
                return false;
            }
            SourcePosition other = (SourcePosition)o;
            if (this.getLine() != other.getLine()) {
                return false;
            }
            if (this.getColumn() != other.getColumn()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            result = result * 59 + this.getOffset();
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UI5.SourcePosition(text=" + this.getText() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", offset=" + this.getOffset() + ")";
        }
    }
}

