// For Library Version: 1.136.9

declare module "sap/sac/df/library" {}

declare module "sap/sac/df/changeHandler/MultiDimModelChangeHandler" {
  import { default as Control, $ControlSettings } from "sap/ui/mdc/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import MultiDimModel from "sap/sac/df/model/MultiDimModel";

  /**
   * Control to handle changes of {@link sap.sac.df.model.MultiDimModel }. To store the changes in {@link sap.ui.fl.variants.VariantManagement }
   * you need to include this change handler control as a dependent somewhere in the view tree for which the
   * variant management is responsible. Each time new data is fetched and the event `dataLoaded` is fired
   * a new change will be created. The method `dataLoaded` needs to be called once to register the {@link sap.sac.df.model.MultiDimModel }
   * to the change handler.
   *
   * @since 1.120
   * @experimental As of version 1.120.
   */
  export default class MultiDimModelChangeHandler extends Control {
    /**
     * Constructor for a new `MultiDimModelChangeHandler`.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string
    );

    /**
     * Creates a new subclass of class sap.sac.df.changeHandler.MultiDimModelChangeHandler with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiDimModelChangeHandler>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.changeHandler.MultiDimModelChangeHandler.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Register {@link sap.sac.df.model.MultiDimModel} for handling changes
     */
    registerMultiDimModel(oMultiDimModel: MultiDimModel): void;
    /**
     * Skip the triggering of the event `apply` once
     */
    skipApplyModelChangeOnce(): void;
  }
  /**
   * Describes the settings that can be provided to the MultiDimModelChangeHandler constructor.
   *
   * @experimental As of version 1.120.
   */
  export interface $MultiDimModelChangeHandlerSettings
    extends $ControlSettings {}
}

declare module "sap/sac/df/DataAnalyzer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import DataAnalyzerPanelName from "sap/sac/df/types/DataAnalyzerPanelName";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * DataAnalyzer A control to display multi-dimensional data
   *
   * @experimental As of version 1.132.
   */
  export default class DataAnalyzer extends Control {
    /**
     * Constructor for a new `DataAnalyzer` control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.DataAnalyzer with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataAnalyzer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.DataAnalyzer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property {@link #getSelectedPanel selectedPanel}.
     *
     * Selected panel item
     *
     *
     * @returns Value of property `selectedPanel`
     */
    getSelectedPanel(): DataAnalyzerPanelName;
    /**
     * Gets current value of property {@link #getShowTitle showTitle}.
     *
     * Show / hide title
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTitle`
     */
    getShowTitle(): boolean;
    /**
     * Gets current value of property {@link #getShowVisualizationType showVisualizationType}.
     *
     * Show visualization type
     *
     *
     * @returns Value of property `showVisualizationType`
     */
    getShowVisualizationType(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedPanel selectedPanel}.
     *
     * Selected panel item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedPanel(
      /**
       * New value for property `selectedPanel`
       */
      sSelectedPanel: DataAnalyzerPanelName
    ): this;
    /**
     * Sets a new value for property {@link #getShowTitle showTitle}.
     *
     * Show / hide title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTitle(
      /**
       * New value for property `showTitle`
       */
      bShowTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowVisualizationType showVisualizationType}.
     *
     * Show visualization type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowVisualizationType(
      /**
       * New value for property `showVisualizationType`
       */
      bShowVisualizationType: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DataAnalyzer constructor.
   *
   * @experimental As of version 1.132.
   */
  export interface $DataAnalyzerSettings extends $ControlSettings {
    /**
     * Defines the relative path to the data provider in the multidimensional model.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Selected panel item
     */
    selectedPanel?: DataAnalyzerPanelName | PropertyBindingInfo | `{${string}}`;

    /**
     * Show visualization type
     */
    showVisualizationType?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show / hide title
     */
    showTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Title
     */
    title?: string | PropertyBindingInfo;
  }
}

declare module "sap/sac/df/DesignerPanel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * DesignerPanel A panel control to design layouts / visualizations
   *
   * @experimental As of version 1.129.
   */
  export default class DesignerPanel extends Control {
    /**
     * Constructor for a new `MultiDimDesignerPanel` control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.DesignerPanel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DesignerPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.DesignerPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to visualization of the corresponding data provider in the multidimensional
     * model.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property {@link #getShowAvailableObjects showAvailableObjects}.
     *
     * Show available objects panel
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showAvailableObjects`
     */
    getShowAvailableObjects(): boolean;
    /**
     * Gets current value of property {@link #getShowVisualizationType showVisualizationType}.
     *
     * Show visualization type
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showVisualizationType`
     */
    getShowVisualizationType(): boolean;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to visualization of the corresponding data provider in the multidimensional
     * model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowAvailableObjects showAvailableObjects}.
     *
     * Show available objects panel
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowAvailableObjects(
      /**
       * New value for property `showAvailableObjects`
       */
      bShowAvailableObjects?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowVisualizationType showVisualizationType}.
     *
     * Show visualization type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowVisualizationType(
      /**
       * New value for property `showVisualizationType`
       */
      bShowVisualizationType?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DesignerPanel constructor.
   *
   * @experimental As of version 1.129.
   */
  export interface $DesignerPanelSettings extends $ControlSettings {
    /**
     * Defines the relative path to visualization of the corresponding data provider in the multidimensional
     * model.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Show visualization type
     */
    showVisualizationType?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show available objects panel
     */
    showAvailableObjects?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/sac/df/FilterBar" {
  import {
    default as FilterBar1,
    $FilterBarSettings as $FilterBarSettings1,
  } from "sap/ui/mdc/FilterBar";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A Filter Bar based on Multidimensional Model
   *
   * @experimental As of version 1.119.
   */
  export default class FilterBar extends FilterBar1 {
    /**
     * Constructor for a new Filter Bar.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.FilterBar with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.FilterBar.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FilterBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   *
   * @experimental As of version 1.119.
   */
  export interface $FilterBarSettings extends $FilterBarSettings1 {
    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/sac/df/FilterField" {
  import {
    default as FilterField1,
    $FilterFieldSettings as $FilterFieldSettings1,
  } from "sap/ui/mdc/FilterField";

  import { IFormContent, ISemanticFormContent } from "sap/ui/core/library";

  import { IOverflowToolbarContent } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `FilterField` control is used to filter data based on the conditions. The conditions are managed
   * in the corresponding {@link sap.ui.mdc.condition.ConditionModel ConditionModel}.
   *
   * @since 1.121
   * @experimental As of version 1.121.
   */
  export default class FilterField
    extends FilterField1
    implements IFormContent, ISemanticFormContent, IOverflowToolbarContent
  {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_ISemanticFormContent: boolean;
    __implements__sap_m_IOverflowToolbarContent: boolean;
    /**
     * Constructor for a new `FilterField`.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterFieldSettings
    );
    /**
     * Constructor for a new `FilterField`.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FilterFieldSettings
    );

    /**
     * Creates a new subclass of class sap.sac.df.FilterField with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.FilterField.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterField>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FilterField.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FilterField constructor.
   *
   * @experimental As of version 1.121.
   */
  export interface $FilterFieldSettings extends $FilterFieldSettings1 {
    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/sac/df/FilterPanel" {
  import Metadata from "sap/ui/base/Metadata";

  /**
   * A Filter Panel based on Multidimensional Model
   *
   * @experimental As of version 1.128.
   */
  export default class FilterPanel
    extends /* was: sap.ui.mdc.p13n.panels.FilterPanel */ Object
  {
    /**
     * Constructor for a new Filter Panel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.FilterPanel with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.mdc.p13n.panels.FilterPanel.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FilterPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.FilterPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets current value of property {@link #getEnableReorder enableReorder}.
     *
     * Determines whether the reordering of personalization items is enabled.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableReorder`
     */
    getEnableReorder(): boolean;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Sets a new value for property {@link #getEnableReorder enableReorder}.
     *
     * Determines whether the reordering of personalization items is enabled.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableReorder(
      /**
       * New value for property `enableReorder`
       */
      bEnableReorder?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
  }
}

declare module "sap/sac/df/Grid" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Grid A grid control for displaying multi-dimensional data
   *
   * @experimental As of version 1.129.
   */
  export default class Grid extends Control {
    /**
     * Constructor for a new `Grid` control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.Grid with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Grid>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.Grid.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:onCellClick onCellClick} event of this `sap.sac.df.Grid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.Grid` itself.
     *
     * Fires on cell click event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOnCellClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Grid$OnCellClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.Grid` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:onCellClick onCellClick} event of this `sap.sac.df.Grid`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.sac.df.Grid` itself.
     *
     * Fires on cell click event
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOnCellClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Grid$OnCellClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.sac.df.Grid` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:onCellClick onCellClick} event of this `sap.sac.df.Grid`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOnCellClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Grid$OnCellClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:onCellClick onCellClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOnCellClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Grid$OnCellClickEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Gets current value of property {@link #getShowStatusBar showStatusBar}.
     *
     * Show / hide status bar
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showStatusBar`
     */
    getShowStatusBar(): boolean;
    /**
     * Gets current value of property {@link #getShowTitle showTitle}.
     *
     * Show / hide title
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTitle`
     */
    getShowTitle(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowStatusBar showStatusBar}.
     *
     * Show / hide status bar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowStatusBar(
      /**
       * New value for property `showStatusBar`
       */
      bShowStatusBar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTitle showTitle}.
     *
     * Show / hide title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTitle(
      /**
       * New value for property `showTitle`
       */
      bShowTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Grid constructor.
   *
   * @experimental As of version 1.129.
   */
  export interface $GridSettings extends $ControlSettings {
    /**
     * Defines the relative path to the data provider in the multidimensional model.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Show / hide status bar
     */
    showStatusBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show / hide title
     */
    showTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Title
     */
    title?: string | PropertyBindingInfo;

    /**
     * Fires on cell click event
     */
    onCellClick?: (oEvent: Grid$OnCellClickEvent) => void;
  }

  /**
   * Parameters of the Grid#onCellClick event.
   */
  export interface Grid$OnCellClickEventParameters {
    /**
     * Cell context
     */
    cellContext?: object;
  }

  /**
   * Event object of the Grid#onCellClick event.
   */
  export type Grid$OnCellClickEvent = Event<
    Grid$OnCellClickEventParameters,
    Grid
  >;
}

declare module "sap/sac/df/model/Configuration" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  import StylingPanelItem from "sap/sac/df/types/configuration/StylingPanelItem";

  import TableTemplate from "sap/sac/df/types/configuration/TableTemplate";

  /**
   * Configuration of the multidimensional model and its components
   *
   * @since 1.132
   * @experimental As of version 1.132.
   */
  export default class Configuration extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Configuration with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Configuration>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Configuration.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets current value of property {@link #getCalculations Calculations}.
     *
     * Calculations
     *
     * Default value is `true`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Value of property `Calculations`
     */
    getCalculations(): boolean;
    /**
     * Gets current value of property {@link #getCommenting Commenting}.
     *
     * Commenting
     *
     * Default value is `false`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Value of property `Commenting`
     */
    getCommenting(): boolean;
    /**
     * Gets current value of property {@link #getContextMenuVariant ContextMenuVariant}.
     *
     * Variant of context menu configuration
     *
     * Default value is `sapui5`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Value of property `ContextMenuVariant`
     */
    getContextMenuVariant(): /* was: sap.sac.df.types.configuration.ContextMenuVariant */ any;
    /**
     * Gets current value of property {@link #getStylingPanelItems StylingPanelItems}.
     *
     * Styling Panel Items
     *
     * Default value is `[TableProperties, NumberFormatting]`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Value of property `StylingPanelItems`
     */
    getStylingPanelItems(): StylingPanelItem[];
    /**
     * Gets current value of property {@link #getTableTemplates TableTemplates}.
     *
     * Available Table Templates
     *
     * Default value is `[Default, Basic]`.
     *
     * @since 1.135
     * @experimental As of version 1.135.
     *
     * @returns Value of property `TableTemplates`
     */
    getTableTemplates(): TableTemplate[];
    /**
     * Gets current value of property {@link #getTableTemplateSelection TableTemplateSelection}.
     *
     * Default table template selection
     *
     * Default value is `TableTemplate.Default`.
     *
     * @since 1.135
     * @experimental As of version 1.135.
     *
     * @returns Value of property `TableTemplateSelection`
     */
    getTableTemplateSelection(): String;
    /**
     * Sets a new value for property {@link #getCalculations Calculations}.
     *
     * Calculations
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalculations(
      /**
       * New value for property `Calculations`
       */
      bCalculations?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getCommenting Commenting}.
     *
     * Commenting
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCommenting(
      /**
       * New value for property `Commenting`
       */
      bCommenting?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getContextMenuVariant ContextMenuVariant}.
     *
     * Variant of context menu configuration
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sapui5`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContextMenuVariant(
      /**
       * New value for property `ContextMenuVariant`
       */
      sContextMenuVariant?: /* was: sap.sac.df.types.configuration.ContextMenuVariant */ any
    ): this;
    /**
     * Sets a new value for property {@link #getStylingPanelItems StylingPanelItems}.
     *
     * Styling Panel Items
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[TableProperties, NumberFormatting]`.
     *
     * @since 1.132
     * @experimental As of version 1.132.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStylingPanelItems(
      /**
       * New value for property `StylingPanelItems`
       */
      sStylingPanelItems?: Array<
        StylingPanelItem | keyof typeof StylingPanelItem
      >
    ): this;
    /**
     * Sets a new value for property {@link #getTableTemplates TableTemplates}.
     *
     * Available Table Templates
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[Default, Basic]`.
     *
     * @since 1.135
     * @experimental As of version 1.135.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableTemplates(
      /**
       * New value for property `TableTemplates`
       */
      sTableTemplates?: Array<TableTemplate | keyof typeof TableTemplate>
    ): this;
    /**
     * Sets a new value for property {@link #getTableTemplateSelection TableTemplateSelection}.
     *
     * Default table template selection
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `TableTemplate.Default`.
     *
     * @since 1.135
     * @experimental As of version 1.135.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTableTemplateSelection(
      /**
       * New value for property `TableTemplateSelection`
       */
      sTableTemplateSelection?: String
    ): this;
  }
}

declare module "sap/sac/df/model/DataProvider" {
  import JSONModel from "sap/ui/model/json/JSONModel";

  import DataSourceInfo from "sap/sac/df/model/DataSourceInfo";

  import Dimension from "sap/sac/df/model/Dimension";

  import Variable from "sap/sac/df/model/Variable";

  import Metadata from "sap/ui/base/Metadata";

  import Event from "sap/ui/base/Event";

  import DataSourceType from "sap/sac/df/types/DataSourceType";

  /**
   * A data provider is an analytical query exposed via an analytical engine and accessed via InA protocol.
   * It represents a navigable query manager and allows to access and change data. Instances of this class
   * should only be created by the {@link sap.sac.df.model.MultiDimModel}.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "DataSourceInfo": { },
   * "Variables": { }
   * "Dimensions": { },
   * "Measures": [ ],
   * "Messages": [ ]
   * "AutoFetchEnabled": ""
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class DataProvider extends JSONModel {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
    /**
     * Indicator if the result set should be fetched automatically. The default value is true.
     */
    AutoFetchEnabled: boolean;

    /**
     * DataSourceInfo
     */
    DataSourceInfo: DataSourceInfo;

    /**
     * Dimensions
     */
    Dimensions: Record<string, Dimension>;

    /**
     * Measures
     */
    Measures: Record<string, /* was: sap.sac.df.model.Measure */ any>;

    /**
     * Variables
     */
    Variables: Record<string, Variable>;

    /**
     * Visualizations
     */
    Visualizations: Record<
      string,
      /* was: sap.sac.df.model.Visualization */ any
    >;

    /**
     * Creates a new subclass of class sap.sac.df.model.DataProvider with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.model.json.JSONModel.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataProvider>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.DataProvider.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add new visualization
     *
     *
     * @returns Returns visualization
     */
    addVisualization(
      /**
       * visualization name
       */
      sName: string,
      /**
       * type of visualization
       */
      sType: /* was: sap.sac.df.types.VisualizationType */ any
    ): /* was: sap.sac.df.model.Visualization */ any;
    /**
     * Execute scenario on data provider
     *
     * @since 1.134
     *
     * @returns Promise with reference to created scenario
     */
    createScenario(
      /**
       * scenario
       */
      sScenarioId: undefined
    ): Promise</* was: sap.sac.df.Scenario */ any>;
    /**
     * Updates the multidimensional model from the given the state of a data provider
     *
     *
     * @returns Promise with reference to this in order to allow method chaining
     */
    deserialize(
      /**
       * the JSON object containing the persisted state of a data provider to be applied.
       */
      oModelState: object,
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY).
       */
      sFormat?: string,
      /**
       * Indicator if the data provider updated should be suppressed after deserialization
       */
      bSuppressUpdate?: boolean
    ): Promise<this>;
    /**
     * Export Data
     */
    exportData(
      /**
       * Data export configuration
       */
      oDataExportConfig: object
    ): void;
    /**
     * Fires event {@link #event:dataUpdated dataUpdated} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataUpdated(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:visualizationAdded visualizationAdded} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireVisualizationAdded(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:visualizationRemoved visualizationRemoved} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireVisualizationRemoved(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Get the property AutoFetchEnabled
     */
    getAutoFetchEnabled(): boolean;
    /**
     * Get data source information
     *
     *
     * @returns data source information object
     */
    getDataSourceInfo(): DataSourceInfo;
    /**
     * Get the scaling factor of a measure or cell
     *
     *
     * @returns Number of decimal places
     */
    getDecimalPlaces(
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): int;
    /**
     * Get Dimension
     *
     *
     * @returns Dimension object
     */
    getDimension(
      /**
       * Dimension name
       */
      sDimensionName: string
    ): Dimension;
    /**
     * Get all dimensions
     *
     *
     * @returns Object of all dimensions
     */
    getDimensions(): Record<string, Dimension>;
    /**
     * Get grid visualization
     *
     *
     * @returns visualization object if found
     */
    getGridVisualization(): /* was: sap.sac.df.model.Visualization */ any;
    /**
     * Get measure
     *
     *
     * @returns Measure object
     */
    getMeasure(
      /**
       * Measure name
       */
      sMeasureName: string
    ): /* was: sap.sac.df.model.Measure */ any;
    /**
     * Get all measures
     *
     *
     * @returns Object of all measures
     */
    getMeasures(): Record<string, /* was: sap.sac.df.model.Measure */ any>;
    /**
     * Get Measure Structure Dimension
     *
     *
     * @returns Measure structure dimension
     */
    getMeasureStructureDimension(): Dimension;
    /**
     * Get the scaling factor of a measure or cell
     *
     *
     * @returns Scaling factor
     */
    getScalingFactor(
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): int;
    /**
     * Get structure (non-measure) dimension
     *
     *
     * @returns Structure dimension object
     */
    getStructureDimension(): Dimension;
    /**
     * Get Variable
     *
     *
     * @returns Variable object
     */
    getVariable(
      /**
       * Variable Name
       */
      sVariableName: string
    ): Variable;
    /**
     * Get all variables
     *
     *
     * @returns Object of all variables
     */
    getVariables(): Record<string, Variable>;
    /**
     * Get visualization
     *
     *
     * @returns visualization object if found
     */
    getVisualization(
      /**
       * visualization name
       */
      sName: String
    ): /* was: sap.sac.df.model.Visualization */ any;
    /**
     * Get all visualizations
     *
     *
     * @returns Object of all visualizations
     */
    getVisualizations(): Record<
      string,
      /* was: sap.sac.df.model.Visualization */ any
    >;
    /**
     * Remove existing visualization from data provider
     *
     *
     * @returns Promise which resolves when the removing s finished
     */
    removeVisualization(
      /**
       * visualization name
       */
      sName: string
    ): Promise<void>;
    /**
     * Serialize the data provider state to a JSON representation
     *
     *
     * @returns A JSON object which represents the data provider
     */
    serialize(
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY)
       */
      sFormat?: string
    ): object;
    /**
     * Set the property `AutoFetchEnabled`, if the data should be automatically be refreshed on invalid.
     */
    setAutoFetchEnabled(bAutoFetchEnabled: boolean): void;
    /**
     * Set the number of decimal places of a measure or cell
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setDecimalPlaces(
      /**
       * Number of the decimal places
       */
      nNumberOfDecimalPlaces: int,
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): this;
    /**
     * Set the scaling factor of a measure or cell
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setScalingFactor(
      /**
       * Scaling factor
       */
      nFactor: int,
      /**
       * Measure structure member
       */
      sMeasureStructureMember: string,
      /**
       * Structure (non-measure) member
       */
      sStructureMember: string
    ): this;
    /**
     * Checks whether an InA capability is supported by the server. Throws an error for unhandled capabilities.
     * List of handled capabilities can be seen in type {@link sap.sac.df.model.Capability}
     *
     *
     * @returns Returns true, if the capability is supported, else false
     */
    supportsCapability(
      /**
       * Capability name
       */
      sCapability: undefined
    ): boolean;
  }
  /**
   * Data provider configuration object.
   *
   * @experimental As of version 1.135.
   */
  export type Configuration = {
    /**
     * name
     */
    Name: string;
    /**
     * data source
     */
    DataSource: Configuration.DataSource;
    /**
     * setup properties
     */
    SetupProperties: Configuration.SetupProperties;
    /**
     * semantic information
     */
    SemanticInfo: object;
  };

  /**
   * Parameters of the DataProvider#dataUpdated event.
   */
  export interface DataProvider$DataUpdatedEventParameters {}

  /**
   * Event object of the DataProvider#dataUpdated event.
   */
  export type DataProvider$DataUpdatedEvent = Event<
    DataProvider$DataUpdatedEventParameters,
    DataProvider
  >;

  /**
   * Parameters of the DataProvider#visualizationAdded event.
   */
  export interface DataProvider$VisualizationAddedEventParameters {}

  /**
   * Event object of the DataProvider#visualizationAdded event.
   */
  export type DataProvider$VisualizationAddedEvent = Event<
    DataProvider$VisualizationAddedEventParameters,
    DataProvider
  >;

  /**
   * Parameters of the DataProvider#visualizationRemoved event.
   */
  export interface DataProvider$VisualizationRemovedEventParameters {}

  /**
   * Event object of the DataProvider#visualizationRemoved event.
   */
  export type DataProvider$VisualizationRemovedEvent = Event<
    DataProvider$VisualizationRemovedEventParameters,
    DataProvider
  >;

  export namespace Configuration {
    /**
     * Data provider configuration data source.
     *
     * @experimental As of version 1.135.
     */
    type DataSource = {
      /**
       * name
       */
      Name: string;
      /**
       * type
       */
      Type: DataSourceType | keyof typeof DataSourceType;
      /**
       * system name
       */
      SystemName: string;
      /**
       * package
       */
      Package: string;
      /**
       * schema
       */
      Schema: string;
    };

    /**
     * Data provider configuration setup properties.
     *
     * @experimental As of version 1.135.
     */
    type SetupProperties = {
      /**
       * start with auto fetch
       */
      AutoFetch: boolean[];
    };
  }
}

declare module "sap/sac/df/model/DataSourceInfo" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Data source information.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   *  "QueryTitle": "",
   *  "QueryName": "",
   *  "QueryType": "",
   *  "SystemName": "",
   *  "CreatedBy": "",
   *  "CreatedOn": "",
   *  "QueryDueDateText": "",
   *  "CreatedOnText": "",
   *  "QueryDueDate": "",
   *  "ResultAlignmentRows": "",
   *  "ResultAlignmentColumns": "",
   *  "LastUpdated": "",
   *  "LastUpdatedBy": "",
   *  "LastUpdatedText": ""
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class DataSourceInfo extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.DataSourceInfo with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DataSourceInfo>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.DataSourceInfo.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/sac/df/model/Dimension" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  import SortDirection from "sap/sac/df/types/SortDirection";

  import SortType from "sap/sac/df/types/SortType";

  /**
   * Dimension Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "TechName": "",
   * "Description": "",
   * "Axis": "",
   * "Type": "",
   * "HierarchyActive": "",
   * "HasFilter": "",
   * "MemberFilter": [],
   * "SortDirection": "",
   * "Position": "",
   * "LastPosition": "",
   * "IsStructure": "",
   * "IsMeasureStructure": "",
   * "ValueType": "",
   * "SemanticObject": "",
   * "Members": [{
   *   "Key": "",
   *   "Name": "",
   *   "TechName": "",
   *   "Description": "",
   *   "SemanticObject": "
   * }],
   * "SupportedOperators": ["EQ"]
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class Dimension extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Dimension with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dimension>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Dimension.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add dimension filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Add a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Clear the filter of a dimension
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(): this;
    /**
     * Get effective dimension filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Move dimension one position down on its axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    moveDown(): this;
    /**
     * Move dimension one position up on it's axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    moveUp(): this;
    /**
     * Open a dialog to display and change the settings of a dimension of the `DataProvider`
     *
     *
     * @returns indicator whether the dialog was confirmed or canceled
     */
    openPropertyDialog(): Promise<boolean>;
    /**
     * Open a dialog to display and change the filter on a dimension
     *
     *
     * @returns resolving to a boolean which is false when the dialog is cancelled and true if is was closed
     * with Ok and dynamic filters of the given dimension are updated
     */
    openValueHelpDialog(): Promise<any>;
    /**
     * Read hierarchy
     *
     *
     * @returns resolving to the object of hierarchy nodes.
     */
    readHierarchy(
      /**
       * level
       */
      iLevel: int
    ): Object;
    /**
     * Remove a drill operation on a dimension member
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeDrilldown(): this;
    /**
     * Remove the filter of a dimension
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Remove a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Set Display Type of Dimension
     *
     *
     * @returns } resolving to the Dimension to allow chaining.
     */
    setDimensionDisplay(
      /**
       * level
       */
      sDisplayType: string
    ): Dimension;
    /**
     * Set Display Hierarchy
     *
     *
     * @returns resolving to the `Dimension` to allow chaining.
     */
    setDisplayHierarchy(
      /**
       * whether the hierarchy should be activated
       */
      bActive: boolean,
      /**
       * the name of the hierarchy (optional)
       */
      sHierarchyName: string,
      /**
       * the version of the hierarchy (optional)
       */
      sVersion: string
    ): Dimension;
    /**
     * Set hierarchy drill level
     *
     *
     * @returns resolving to the `Dimension` to allow chaining.
     */
    setHierarchyDrillLevel(
      /**
       * drill level (from root)
       */
      iDrillLevel: int
    ): Dimension;
    /**
     * Set dimension filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[]
    ): this;
    /**
     * Set a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Sort the members of a dimension
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    sort(
      /**
       * of sorting
       */
      direction: SortDirection,
      /**
       * of sorting
       */
      type: SortType,
      /**
       * in case of a measure structure the member according to which is sorted
       */
      sMeasureStructureMember: string,
      /**
       * in case of a secondary structure the member according to which is sorted
       */
      sStructureMember: string
    ): this;
    /**
     * Move dimension to the columns axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    toColumns(): this;
    /**
     * Move dimension to the rows axis
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    toRows(): this;
  }
}

declare module "sap/sac/df/model/MultiDimModel" {
  import JSONModel from "sap/ui/model/json/JSONModel";

  import Configuration from "sap/sac/df/model/Configuration";

  import {
    default as DataProvider,
    Configuration as Configuration1,
  } from "sap/sac/df/model/DataProvider";

  import Message from "sap/ui/core/message/Message";

  import VariableGroup from "sap/sac/df/model/VariableGroup";

  import DataSourceType from "sap/sac/df/types/DataSourceType";

  import Metadata from "sap/ui/base/Metadata";

  import Event from "sap/ui/base/Event";

  /**
   * The multidimensional model allows to access and change data accessed via the InA Protocol. The multidimensional
   * model populate it's exposed data in JSON format via binding to controls.
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "DataProviders": { },
   * "VariableGroups": { },
   * "Messages": [ ]
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class MultiDimModel extends JSONModel {
    /**
     * Constructor for a new MultiDimModel. After model creation you need to wait for the event {@link #event:loaded loaded}.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: object
    );
    /**
     * Configuration
     */
    Configuration: Record<string, Configuration>;

    /**
     * Data Providers
     */
    DataProviders: Record<string, DataProvider>;

    /**
     * Messages
     */
    Messages: Message[];

    /**
     * Variable Groups
     */
    VariableGroups: Record<string, VariableGroup>;

    /**
     * Creates a new subclass of class sap.sac.df.model.MultiDimModel with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.model.json.JSONModel.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MultiDimModel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.MultiDimModel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Creates a new data provider and attaches it to the model.
     *
     *
     * @returns Promise which resolves the created data provider
     */
    addDataProvider(
      /**
       * Data provider name
       */
      sDataProviderName: string,
      /**
       * Datasource name which the data provider is supposed to expose
       */
      sDataSourceName: Configuration1 | string,
      /**
       * System name
       */
      sSystem?: string,
      /**
       * Package name
       */
      sPackage?: string,
      /**
       * Schema name
       */
      sSchema?: string,
      /**
       * Data source type
       */
      sDataSourceType?: DataSourceType | keyof typeof DataSourceType,
      /**
       * if the data should be fetched automatically
       */
      bAutoFetchEnabled?: boolean
    ): Promise<DataProvider>;
    /**
     * Creates a new variable group and attaches it to the model.
     *
     * A variable group defines which variables of the underlying data providers should behave as the same variable.
     * The group is defined by a name and a rule. The first added variable becomes automatically the `MergedVariable`.
     *
     *
     * @returns created variable group
     */
    createVariableGroup(
      /**
       * Variable group name
       */
      sVariableGroupName: string,
      /**
       * Rule is a function which accept the variable definition and decides if the variable has to be part of
       * te group.
       */
      fnRule: Function,
      /**
       * Additional properties
       */
      oProperties: Object
    ): VariableGroup;
    /**
     * Updates the model from the given the model state including all aggregated data providers
     *
     *
     * @returns Promise with reference to this in order to allow method chaining
     */
    deserialize(
      /**
       * A JSON object which represents the multidimensional model to be applied
       */
      oModelState: object,
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY).
       */
      sFormat?: string
    ): Promise<this>;
    /**
     * Ensures all aggregated data providers are destroyed.
     *
     *
     * @returns Promise which resolves when destroy is finished.
     */
    destroy(): Promise<any>;
    /**
     * Fires event {@link #event:dataProviderAdded dataProviderAdded} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderAdded(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataProviderRemoved dataProviderRemoved} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderRemoved(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:dataProviderUpdated dataProviderUpdated} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireDataProviderUpdated(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Fires event {@link #event:variableGroupsAdded variableGroupsAdded} to attached listeners.
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    fireVariableGroupsAdded(
      /**
       * Parameters to pass along with the event
       */
      oParameters?: object
    ): this;
    /**
     * Get context menu provider registry
     *
     *
     * @returns sap.sac.df.model.extentsions.contextMenu.ContextMenuProviderRegistry
     */
    getContextMenuProviderRegistry(): undefined;
    /**
     * Get a data provider
     *
     *
     * @returns Data provider object if found
     */
    getDataProvider(
      /**
       * Data provider name
       */
      sDataProviderName: string
    ): DataProvider;
    /**
     * Get all data providers
     *
     *
     * @returns Object of all data providers
     */
    getDataProviders(): Record<string, DataProvider>;
    /**
     * Get grid styling template registry
     *
     * @deprecated As of version 1.135. the concept has been discarded.
     *
     * @returns sap.sac.df.model.extentsions.styling.GridStylingTemplateRegistry
     */
    getGridStylingTemplateRegistry(): undefined;
    /**
     * Get all messages
     *
     *
     * @returns Array of messages
     */
    getMessages(): Message[];
    /**
     * Get a variable group
     *
     *
     * @returns Variable group object
     */
    getVariableGroup(
      /**
       * Variable group name
       */
      sVariableGroupName: string
    ): VariableGroup;
    /**
     * Get all variable groups
     *
     *
     * @returns Object of all variable groups
     */
    getVariableGroups(): Record<string, VariableGroup>;
    /**
     * Remove existing data provider from the model.
     *
     *
     * @returns Promise which resolves when the removing s finished
     */
    removeDataProvider(
      /**
       * Data provider name to be removed
       */
      sDataProviderName: string
    ): Promise<void>;
    /**
     * Reset the model to the initial state
     *
     *
     * @returns Promise which resolves when reset is finished.
     */
    resetModel(): Promise<void>;
    /**
     * Serialize the model with all aggregated data providers to a JSON representation
     *
     *
     * @returns A JSON object which represents the multidimensional model
     */
    serialize(
      /**
       * Format of the serialization (INA_REPOSITORY_DELTA or INA_REPOSITORY)
       */
      sFormat?: string
    ): object;
    /**
     * Resets the messages
     */
    setMessages(
      /**
       * The new messages for the model, mapping a binding path to an array of sap.ui.core.message.Message objects
       */
      mMessages: Record<string, Message[]>
    ): void;
    /**
     * Set variable groups.
     *
     * A variable group defines which variables of the underlying data providers should behave as the same variable.
     * The group is defined by a name and a rule. The first added variable becomes automatically the `MergedVariable`.
     *
     *
     * @returns Promise which resolves the created variable group
     */
    setVariableGroups(
      /**
       * array of variable groups
       */
      aVariableGroups: VariableGroup[]
    ): Promise<VariableGroup[]>;
  }
  /**
   * Parameters of the MultiDimModel#dataLoaded event.
   */
  export interface MultiDimModel$DataLoadedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataLoaded event.
   */
  export type MultiDimModel$DataLoadedEvent = Event<
    MultiDimModel$DataLoadedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#dataProviderAdded event.
   */
  export interface MultiDimModel$DataProviderAddedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderAdded event.
   */
  export type MultiDimModel$DataProviderAddedEvent = Event<
    MultiDimModel$DataProviderAddedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#dataProviderRemoved event.
   */
  export interface MultiDimModel$DataProviderRemovedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderRemoved event.
   */
  export type MultiDimModel$DataProviderRemovedEvent = Event<
    MultiDimModel$DataProviderRemovedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#dataProviderUpdated event.
   */
  export interface MultiDimModel$DataProviderUpdatedEventParameters {}

  /**
   * Event object of the MultiDimModel#dataProviderUpdated event.
   */
  export type MultiDimModel$DataProviderUpdatedEvent = Event<
    MultiDimModel$DataProviderUpdatedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#loaded event.
   */
  export interface MultiDimModel$LoadedEventParameters {}

  /**
   * Event object of the MultiDimModel#loaded event.
   */
  export type MultiDimModel$LoadedEvent = Event<
    MultiDimModel$LoadedEventParameters,
    MultiDimModel
  >;

  /**
   * Parameters of the MultiDimModel#variableGroupsAdded event.
   */
  export interface MultiDimModel$VariableGroupsAddedEventParameters {}

  /**
   * Event object of the MultiDimModel#variableGroupsAdded event.
   */
  export type MultiDimModel$VariableGroupsAddedEvent = Event<
    MultiDimModel$VariableGroupsAddedEventParameters,
    MultiDimModel
  >;
}

declare module "sap/sac/df/model/Variable" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Variable Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "Dimension": "",
   * "ValueType": "",
   * "VariableType": "",
   * "Description": "",
   * "Mandatory": "",
   * "SupportsMultipleValues": "",
   * "TechName": "",
   * "InputEnabled": "",
   * "Position": ""
   * "SupportsValueHelp": "",
   * "DataProviderName": "",
   * "MemberFilter": []
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class Variable extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.Variable with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Variable>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.Variable.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add variable filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Add a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Clear variable filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(): this;
    /**
     * Get effective variable filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Open a dialog to display and change the filter on a variable
     *
     *
     * @returns resolving to a boolean which is false when the dialog is cancelled and true if is was closed
     * with Ok and dynamic filters of the given dimension are updated
     */
    openValueHelpDialog(): Promise<any>;
    /**
     * Remove variable filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Remove a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Set variable filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[]
    ): this;
    /**
     * Set a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
  }
}

declare module "sap/sac/df/model/VariableGroup" {
  import BaseObject from "sap/ui/base/Object";

  import Variable from "sap/sac/df/model/Variable";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Variable Group Object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "Name": "",
   * "MergedVariable": { },
   * "Rule": function () {}
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class VariableGroup extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
    /**
     * Merged Variable
     */
    MergedVariable: Variable;

    /**
     * Name
     */
    Name: string;

    /**
     * Creates a new subclass of class sap.sac.df.model.VariableGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VariableGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.VariableGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Add variable group filters
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Add a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    addMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Clear variable group filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    clearMemberFilter(): this;
    /**
     * Get effective variable group filters
     *
     *
     * @returns array of member filters
     */
    getMemberFilter(): /* was: sap.sac.df.model.MemberFilter */ any[];
    /**
     * Opens the value help dialog so the user choose a value for a variable group After the value is selected
     * only teh VariableGroup.MergedVariable is updated. The variables of the aggregated DataProviders are updated
     * with the next ResultSet fetch
     *
     *
     * @returns to indicate if the VariableGroup has been updated
     */
    openValueHelpDialog(): Promise<boolean>;
    /**
     * Remove variable group filter
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilter(
      /**
       * a member filter object
       */
      oMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any
    ): this;
    /**
     * Remove a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    removeMemberFilterByKey(
      /**
       * (internal) key of a dimension member
       */
      sKey: string
    ): this;
    /**
     * Set variable group filters
     *
     *
     * @returns Promise which resolve when the value is set
     */
    setMemberFilter(
      /**
       * array of member filters
       */
      aMemberFilter: /* was: sap.sac.df.model.MemberFilter */ any[]
    ): undefined;
    /**
     * Set a member filter by its (internal) key
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setMemberFilterByKey(
      /**
       * (internal) ey of a dimension member
       */
      sKey: string
    ): this;
  }
}

declare module "sap/sac/df/model/visualization/Documents" {
  import BaseObject from "sap/ui/base/Object";

  import DocumentsSupportType from "sap/sac/df/types/DocumentsSupportType";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Documents manager object
   *
   * **Structure of Exposed Data:**
   * ```javascript
   *
   * "ActiveDocumentsDirectory": "",
   * "DocumentsSupportType": ""
   * "IsBasedOnCDSView": ""
   * ```
   *
   *
   * @since 1.119
   * @experimental As of version 1.119.
   */
  export default class Documents extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    ActiveDocumentsDirectory: undefined;

    DocumentsSupportType: undefined;

    IsBasedOnCDSView: undefined;

    /**
     * Creates a new subclass of class sap.sac.df.model.visualization.Documents with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Documents>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.visualization.Documents.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Create and retrieve document in the document store
     *
     *
     * @returns a promise which resolves with the newly created document.
     */
    createAndRetrieveDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the content of the document
       */
      sContent: undefined,
      /**
       * properties (ideally as key-value-pair)
       */
      oProperties: undefined
    ): Promise<object>;
    /**
     * Create a document in the document store
     *
     *
     * @returns a promise which resolves to true if create operation is successful, otherwise false.
     */
    createDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the content of the document
       */
      sContent: undefined,
      /**
       * properties (ideally as key-value-pair)
       */
      oProperties: undefined
    ): Promise<boolean>;
    /**
     * Creates a document ID for a data cell in the result set
     *
     *
     * @returns a promise which resolves with the newly created document ID
     */
    createDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<String>;
    /**
     * Delete a document in the document store
     *
     *
     * @returns a promise which resolves to true if delete operation is successful, otherwise false.
     */
    deleteDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined
    ): Promise<boolean>;
    /**
     * Delete a document ID for a data cell in the result set
     *
     *
     * @returns a promise which resolves to true if the delete operation is successful, otherwise false.
     */
    deleteDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<boolean>;
    /**
     * Get a document ID of a data cell in the result set
     *
     *
     * @returns a promise which resolves with the document ID
     */
    getDocumentId(
      /**
       * the row index
       */
      nRowIndex: int,
      /**
       * the column index
       */
      nColumnIndex: int
    ): Promise<String>;
    /**
     * Get the type of documents support.
     *
     *
     * @returns documents support type
     */
    getDocumentsSupportType(): DocumentsSupportType;
    /**
     * Retrieves a document from the document store
     *
     *
     * @returns a promise which resolves with the version(s) of the document.
     */
    retrieveDocument(
      /**
       * the document ID
       */
      sDocumentId: undefined,
      /**
       * the version of the document - if version is not supplied, returns all versions.
       */
      sVersion: undefined
    ): Promise<object>;
    /**
     * Retrieve multiple documents from the document store
     *
     *
     * @returns a promise which resolves with all documents and its versions.
     */
    retrieveMultipleDocuments(
      /**
       * the array of document IDs
       */
      aDocumentIds: undefined
    ): Promise<object>;
    /**
     * Is document storage supporting delete access
     *
     *
     * @returns if delete access is supported
     */
    supportsDelete(): boolean;
    /**
     * Is document storage supporting read access
     *
     *
     * @returns if read access is supported
     */
    supportsRead(): boolean;
    /**
     * Is document storage supporting write (create and change) access
     *
     *
     * @returns if write (create and change) access is supported
     */
    supportsWrite(): boolean;
  }
}

declare module "sap/sac/df/model/visualization/Grid" {
  import BaseObject from "sap/ui/base/Object";

  import TableTemplate from "sap/sac/df/types/configuration/TableTemplate";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Grid Visualization Object
   *
   * @since 1.132
   * @experimental As of version 1.132.
   */
  export default class Grid extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Creates a new subclass of class sap.sac.df.model.visualization.Grid with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Grid>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.model.visualization.Grid.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Get active template
     *
     *
     * @returns active template
     */
    getActiveTemplate(): TableTemplate;
    /**
     * Get the current axes layout for rows and columns
     *
     *
     * @returns columns and rows axes layout object
     */
    getAxesLayout(): AxesLayout;
    /**
     * Gets the cell context for a cell in the result set
     *
     *
     * @returns a promise which resolves with the retrieved cell context
     */
    getCellContext(
      /**
       * the row index of data cell
       */
      nRowIndex: int,
      /**
       * the column index of data cell
       */
      nColumnIndex: int
    ): Promise<Object>;
    /**
     * Get the data of the visualization
     * ```javascript
     *
     * "Cells": [],
     * "TotalColumns": Integer,
     * "TotalRows": Integer
     * ```
     *
     *
     *
     * @returns a promise which resolves with the visualization data
     */
    getVisualizationData(): Promise<Object>;
    /**
     * Set active template
     *
     *
     * @returns resolving to the axes layout object to allow chaining
     */
    setActiveTemplate(
      /**
       * styling template name
       */
      sTemplateName: string
    ): Grid;
    /**
     * Set the dimensions on row and column axis
     *
     *
     * @returns resolving to the axes layout object to allow chaining
     */
    setAxesLayout(
      /**
       * an object containing the names of the dimensions on row and column axis. The order of the dimensions
       * control the position on the axis.
       */
      oAxisLayout: AxesLayout
    ): Grid;
  }
  /**
   * Axes Layout object type.
   *
   * @experimental As of version 1.132.
   */
  export type AxesLayout = {
    /**
     * dimensions on column axis
     */
    Columns: string[];
    /**
     * dimensions on row axis
     */
    Rows: string[];
    /**
     * members of measure structure dimension
     */
    MeasureStructureMembers: string[];
    /**
     * members of structure dimension
     */
    StructureMembers: string[];
  };
}

declare module "sap/sac/df/StylingPanel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * StylingPanel A panel control to format the data being displayed.
   *
   * @experimental As of version 1.129.
   */
  export default class StylingPanel extends Control {
    /**
     * Constructor for a new `StylingPanel` control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.sac.df.StylingPanel with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StylingPanel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.sac.df.StylingPanel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     *
     * @returns Value of property `metaPath`
     */
    getMetaPath(): string;
    /**
     * Sets a new value for property {@link #getMetaPath metaPath}.
     *
     * Defines the relative path to the data provider in the multidimensional model.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMetaPath(
      /**
       * New value for property `metaPath`
       */
      sMetaPath: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StylingPanel constructor.
   *
   * @experimental As of version 1.129.
   */
  export interface $StylingPanelSettings extends $ControlSettings {
    /**
     * Defines the relative path to the data provider in the multidimensional model.
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/sac/df/types/Axis" {
  /**
   * Axis of a multidimensional Result Set
   *
   * @experimental As of version 1.119.
   */
  enum Axis {
    /**
     * Columns axis (horizontal direction in a Grid)
     */
    Columns = "Columns",
    /**
     * Free axis (contains all dimensions that can be placed on the row/column axis)
     */
    Free = "Free",
    /**
     * Row axis (vertical direction in a Grid)
     */
    Rows = "Rows",
  }
  export default Axis;
}

declare module "sap/sac/df/types/configuration/StylingPanelItem" {
  /**
   * Item of the styling panel
   *
   * @since 1.132
   * @experimental As of version 1.132.
   */
  enum StylingPanelItem {
    /**
     * Conditional Formatting
     */
    ConditionalFormatting = "ConditionalFormatting",
    /**
     * Number Formatting
     */
    NumberFormatting = "NumberFormatting",
    /**
     * Table Properties
     */
    TableProperties = "TableProperties",
  }
  export default StylingPanelItem;
}

declare module "sap/sac/df/types/configuration/TableTemplate" {
  /**
   * Item of the styling panel
   *
   * @since 1.135
   * @experimental As of version 1.135.
   */
  enum TableTemplate {
    /**
     * Basic
     */
    Basic = "Basic",
    /**
     * Default
     */
    Default = "Default",
    /**
     * Financial
     */
    Financial = "Financial",
    /**
     * Report
     */
    Report = "Report",
  }
  export default TableTemplate;
}

declare module "sap/sac/df/types/DataAnalyzerPanelName" {
  /**
   * DataAnalyzer Panels
   *
   * @experimental As of version 1.132.
   */
  enum DataAnalyzerPanelName {
    /**
     * Designer Panel
     */
    Designer = "OlapDesignerDocument",
    /**
     * Styling Panel
     */
    Styling = "StylingPanelDocument",
  }
  export default DataAnalyzerPanelName;
}

declare module "sap/sac/df/types/DataSourceType" {
  /**
   * Type of a data source
   *
   * @experimental As of version 1.89.
   */
  enum DataSourceType {
    /**
     * CDS Projection View
     */
    CDSProjectionView = "CDSProjectionView",
    /**
     * Cube
     */
    Cube = "Cube",
    /**
     * Ina Model
     */
    InAModel = "InAModel",
    /**
     * Insight (widget definition)
     */
    Insight = "Insight",
    /**
     * Query
     */
    Query = "Query",
    /**
     * View
     */
    View = "View",
  }
  export default DataSourceType;
}

declare module "sap/sac/df/types/DocumentsSupportType" {
  /**
   * Documents support type
   *
   * @experimental As of version 1.120.
   */
  enum DocumentsSupportType {
    /**
     * Documents are not supported.
     */
    None = "NONE",
    /**
     * Read-only documents support.
     */
    Read = "READ",
    /**
     * Read, create, change documents support.
     */
    ReadCreateChange = "READ_CREATE_CHANGE",
    /**
     * Read, create, change, delete documents support.
     */
    ReadWrite = "READ_WRITE",
  }
  export default DocumentsSupportType;
}

declare module "sap/sac/df/types/SemanticRole" {
  /**
   * Semantic Role of a dimension member
   *
   * @since 1.135
   * @experimental As of version 1.135.
   */
  enum SemanticRole {
    /**
     * Absolute Variance
     */
    AbsoluteVariance = "AbsoluteVariance",
    /**
     * Actual Data
     */
    Actual = "Actual",
    /**
     * Budget Data
     */
    Budget = "Budget",
    /**
     * Forecast Data
     */
    Forecast = "Forecast",
    /**
     * Percentage Variance
     */
    PercentageVariance = "PercentageVariance",
    /**
     * Previous Data
     */
    Previous = "Previous",
  }
  export default SemanticRole;
}

declare module "sap/sac/df/types/SortDirection" {
  /**
   * Sort Direction
   *
   * @experimental As of version 1.130.
   */
  enum SortDirection {
    /**
     * Ascending
     */
    Ascending = "ASCENDING",
    /**
     * Descending
     */
    Descending = "DESCENDING",
    /**
     * No sorting
     */
    None = "NONE",
  }
  export default SortDirection;
}

declare module "sap/sac/df/types/SortType" {
  /**
   * Sort Type
   *
   * @experimental As of version 1.130.
   */
  enum SortType {
    /**
     * Sort according to Filter
     */
    Filter = "FILTER",
    /**
     * Sort according to Key
     */
    MemberKey = "MEMBER_KEY",
    /**
     * Sort according to Text
     */
    MemberText = "MEMBER_TEXT",
    /**
     * No sorting
     */
    unset = "unset",
  }
  export default SortType;
}

declare module "sap/sac/df/types/SystemType" {
  /**
   * System Type of an InA System
   *
   * @experimental As of version 1.89.
   */
  enum SystemType {
    /**
     * The ABAP analytic engine
     */
    ABAP_MDS = "ABAP_MDS",
    /**
     * The BW analytic engine
     */
    BW = "BW",
    /**
     * The Data Warehouce Cloud analytic engine
     */
    DWC = "DWC",
    /**
     * The HANA/MDS analytic engine
     */
    HANA = "HANA",
  }
  export default SystemType;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/sac/df/changeHandler/MultiDimModelChangeHandler": undefined;

    "sap/sac/df/DataAnalyzer": undefined;

    "sap/sac/df/DesignerPanel": undefined;

    "sap/sac/df/FilterBar": undefined;

    "sap/sac/df/FilterField": undefined;

    "sap/sac/df/FilterPanel": undefined;

    "sap/sac/df/Grid": undefined;

    "sap/sac/df/library": undefined;

    "sap/sac/df/model/Configuration": undefined;

    "sap/sac/df/model/DataProvider": undefined;

    "sap/sac/df/model/DataSourceInfo": undefined;

    "sap/sac/df/model/Dimension": undefined;

    "sap/sac/df/model/Measure": undefined;

    "sap/sac/df/model/MultiDimModel": undefined;

    "sap/sac/df/model/Variable": undefined;

    "sap/sac/df/model/VariableGroup": undefined;

    "sap/sac/df/model/visualization/Documents": undefined;

    "sap/sac/df/model/visualization/Grid": undefined;

    "sap/sac/df/StylingPanel": undefined;

    "sap/sac/df/types/Axis": undefined;

    "sap/sac/df/types/configuration/StylingPanelItem": undefined;

    "sap/sac/df/types/configuration/TableTemplate": undefined;

    "sap/sac/df/types/DataAnalyzerPanelName": undefined;

    "sap/sac/df/types/DataSourceType": undefined;

    "sap/sac/df/types/DocumentsSupportType": undefined;

    "sap/sac/df/types/SemanticRole": undefined;

    "sap/sac/df/types/SortDirection": undefined;

    "sap/sac/df/types/SortType": undefined;

    "sap/sac/df/types/SystemType": undefined;
  }
}
