/**
 *
 * @param usedNames
 * @param sName
 */
export declare const alreadyExists: (usedNames: Set<string> | undefined, sName: string, additionalCheck?: (arg: string) => boolean) => boolean;
/**
 * @param sName, e.g. Date
 * @returns whether or not the name is a valid candidate
 */
export declare const isValidIdentifierName: (sName: string) => boolean;
/**
 * Returns a unique name.
 * If the name has segments (separated with "." by default, e.g. a.b.c),
 * tries to find a unique name by starting with the last segment (c) and
 * adding former ones camelcasing (bC) until it is unique.
 *
 * If the name contains "-", these are replaced by camelcasing.
 * If the name contains invalid characters, they are replaced by "_".
 * If the name starts with a non-start character or is a reserved keyword,
 * the name is prefixed with "o".
 * If the name is not unique a count (starting with 0) is added as a suffix.
 *
 * @param usedNames names which are already in use and should not
 * be taken
 * @param sName module name e.g. sap.ui.model.type.Date; or already split
 * name, e.g. ["sap", "ui", "model", "type", "Date"]
 * @returns unique name which is neither reserved nor taken
 */
export declare const getUniqueName: (usedNames: Set<string> | undefined, sName: string | string[], splitCharacter?: string, additionalCheck?: (arg: string) => boolean) => string;
