import { ChangeAction } from "../../../utils/textChanges.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
import AccessExpressionBaseFix, { AccessExpressionBaseFixParams } from "./AccessExpressionBaseFix.js";
export interface AccessExpressionGeneratorFixParams extends AccessExpressionBaseFixParams {
    /**
     * Modules to import. If this parameter is specified, the standalone parameters "moduleName" and
     * "preferredIdentifier" must not be provided.
    */
    moduleImports?: {
        moduleName: string;
        preferredIdentifier?: string;
    }[];
    /**
     * Names of a global variable to use in the fix (e.g. "document"). If this parameter is specified, parameter
     * "globalName" must not be provided.
     *
     * The fix will be provided with the identifier names or property access strings to use via
     * the setIdentifierForGlobal method.
     *
     * For example, if there is already a conflicting identifier within the same file,
     * the fix will be provided with an alternative like "globalThis.document"
     */
    globalNames?: string[];
    /**
     * The generator function will be used to determine the value of the replacement, affecting
     * the whole access expression
     *
     * If the return value is undefined, no change will be generated
     */
    generator: (identifierNames: string[]) => string | undefined;
}
/**
 * Fix a property access. This could also be the property access of a call expression, allowing for a more general
 * replacement in cases where the arguments or other conditions of the call expression do not matter.
 */
export default class AccessExpressionGeneratorFix extends AccessExpressionBaseFix {
    protected params: AccessExpressionGeneratorFixParams;
    constructor(params: AccessExpressionGeneratorFixParams, ui5TypeInfo: Ui5TypeInfo);
    getNewModuleDependencies(): import("./Fix.js").ModuleDependencyRequest | {
        usagePosition: number;
        moduleName: string;
        preferredIdentifier?: string;
    }[] | undefined;
    getNewGlobalAccess(): import("./Fix.js").GlobalAccessRequest | import("./Fix.js").GlobalAccessRequest[] | undefined;
    generateChanges(): {
        action: ChangeAction;
        start: number;
        end: number;
        value: string;
    } | undefined;
}
