import ControllerByIdInfo from "../ControllerByIdInfo.js";
import { ControlDeclaration, RequireExpression, Position } from "../Parser.js";
import Writer from "./Writer.js";
interface ImportStatement {
    moduleName: string;
    variableName: string;
    start?: Position;
    end?: Position;
}
export default abstract class AbstractGenerator {
    _imports: Set<ImportStatement>;
    _variableNames: Set<string>;
    _body: Writer;
    _idToModule: Map<string, string>;
    _controllerByIdInfo: ControllerByIdInfo;
    constructor(filePath: string, controllerByIdInfo: ControllerByIdInfo);
    writeRootControl(controlDeclaration: ControlDeclaration): void;
    writeControl(controlDeclaration: ControlDeclaration, rootControl?: boolean): void;
    writeRequire(requireExpression: RequireExpression): void;
    getModuleContent(): {
        source: string;
        map: string;
    };
    _getUniqueVariableName(variableName: string): string;
    _writeControlFactoryCall(moduleName: string, importVariableName: string, controlDeclaration: ControlDeclaration, rootControl: boolean): void;
}
export {};
